//Songs:
//Starwars' Imperial March
const uint8_t imperialMarch[] PROGMEM = {
  N_A4,  32,  N_A4,  32,  N_A4,  32,  N_F4,  23,  N_C5,  10,  N_A4,  32,  N_F4,  23,  N_C5,  10,  N_A4,  42,  0   ,  32,  N_E5,  32,  N_E5,  32,  N_E5,  32,  N_F5,  23, N_C5,  10,  N_G4S, 32,
  N_F4,  23,  N_C5,  10,  N_A4,  42,  0   ,  32,  N_A5,  32,  N_A4,  19,  N_A4,  10,  N_A5,  32,  N_G5S, 21,  N_G5,  11,  N_F5S,  8,  N_F5,   8,  N_F5S, 16, 0    , 21,  N_A4S, 16,  N_D5S, 32,
  N_D5,  21,  N_C5S, 11,  N_C5,   8,  N_B4,   8,  N_C5,  16,  0    , 23,  N_F4,  16,  N_G4S, 32,  N_F4,  23,  N_A4,   8,  N_C5,  32,  N_A4,  24,  N_C5,   8,  N_E5,  42, 0    , 32,  N_A5,  32,
  N_A4,  19,  N_A4,  10,  N_A5,  32,  N_G5S, 21,  N_G5,  11,  N_F4S,  8,  N_F5,   8,  N_F4S, 16,  0    , 21,  N_A4S, 16,  N_D5S, 32,  N_D5,  21,  N_C5S, 11,  N_C5,   8, N_B4,   8,  N_C5,  16,  
  0   ,  23,  N_F4,  16,  N_G4S, 32,  N_F4,  24,  N_C5,   8,  N_A4,  32,  N_F4,  24,  N_C5,   8,  N_A4,  42,  0     ,42
};
//macGyver theme song!
const uint8_t macGyver[] PROGMEM = {
  N_B3, 16, N_E4, 16, N_A4, 16, N_B4, 16, N_A4, 16, N_B3, 16, N_E4, 16, N_B3, 16, 0   , 16, N_E4, 16,  N_A4, 16, N_B4, 16,  N_A4, 16,  N_E4, 16,  N_B3, 16,  N_E4, 16,
  0   , 16, N_E4, 16, N_A4, 16, N_B4, 16, N_A4, 16, N_B3, 16, N_E4, 16, N_B3, 32, 0   , 16, N_A4, 16,  N_D5, 16, N_C5, 16,  N_D5, 16,  N_C5, 16,  N_B4, 16,  N_A4, 16,
  N_B4, 48, N_A4, 76, 0   , 4,  N_A4, 48, N_G4, 76, 0   , 4,  N_B4, 14, 0   , 2,  N_B4, 48, N_A4, 76,  0   , 4,  N_A4, 48,  N_G4, 32,  N_A4, 72,  0   , 8,   N_C5, 12,
  0   , 2,  N_C5, 12, 0   , 2,  N_C5, 12, 0   , 2,  N_C5, 12, 0   , 2,  N_C5, 12, 0   , 2,  N_C5, 12,  0   , 2,  N_B4, 64,  N_F4S, 16, N_A4, 32,  N_G4, 80,  N_C5, 14,
  0, 2,     N_C5, 32, N_B4, 32, N_C5, 16, N_B4, 16, N_A4, 16, N_G4, 16, N_E5, 32, N_A4, 64, N_C5, 14,  0   , 2,  N_C5, 80,  N_F4S, 16, N_A4, 32,  N_G4, 76,  N_C5, 14,
     0,  2, N_C5, 32, N_B4, 32, N_C5, 16, N_B4, 16, N_G4, 16, N_E5, 32, N_A4, 64, N_B4, 64, N_C5, 16,  N_B4, 16, N_A4, 16,  N_C5, 32,  N_B4, 16,  N_A4, 16,  N_D5, 32,
  N_C5, 16, N_B4, 16, N_D5, 32, N_C5, 16, N_B4, 16, N_E5, 32, N_D5, 16, N_E5, 16, N_F5S,32, N_B4, 32,  N_G5S, 48,N_F5S, 32, N_F5, 32,  N_B4, 32,  N_G5, 16,  N_E5, 16,
  N_B4, 16, N_F5S, 16,N_D5, 16, N_A4, 16, N_E5, 16, N_C5, 16, N_G4, 16, N_D5, 16, N_B4, 16, N_G4, 16,  N_C5, 16, N_E4, 16,  N_B4, 16,  N_D4, 16,  N_C5, 16,  N_B4, 16,
  N_A4, 16, N_G4, 16, N_A4S, 32,N_A4, 32, N_G5, 16, N_G4, 16, N_D5, 16, N_G4, 16, N_D5S, 16,N_D4S, 16, N_A4S, 16,N_A4, 16,  N_G4, 16,  N_G3, 16,  N_D4, 16,  N_G3, 16,
  N_D4S, 16,N_G3, 16, N_A3S, 16,N_A3, 16, N_G3, 14, 0    , 2, N_G3, 14, 0   , 2,  N_G3, 14,0     , 2,  N_G3, 14, 0   , 2,   N_G3, 14,  0   , 2,   N_G3, 14,  0   , 2,
  N_G3, 14, 0   , 2
};

//Connecting to MQTT...
void connectToMqtt() {
  mqttClient.connect();
}
//callbacks
void onMqttConnect(bool sessionPresent) {
  mqttClient.subscribe(HANAME "/button/" DEVICENAME "_" DEVICEID "/set", 0);
  mqttClient.publish(MQTT_PUB_TOPIC, 0, false, MQTT_PUB_MESSAGE VERSION);
  MQTTAutoConfig();
  MQTT_UpdateStates();
  OutputOffsets();
}
//Disconnected from MQTT
void onMqttDisconnect(AsyncMqttClientDisconnectReason reason) {
  if (WiFi.isConnected()) {
    mqttReconnectTimer.once(2, connectToMqtt);    
  }
}
void onMqttSubscribe(uint16_t packetId, uint8_t qos) {}
void onMqttUnsubscribe(uint16_t packetId) {}

void onMqttMessage(char* t, char* pl, AsyncMqttClientMessageProperties properties, size_t len, size_t index, size_t total) {
  char command = pl[0];
  // Switch case for commands only uses first char
  switch (command) {
    case 'C': { //Clean
      if(roomba.roombaState == roombaHome){
          //Callibrate offsets for IMU and reset Yaw
          mpu.CalibrateAccel(7);
          mpu.CalibrateGyro(7);
          OutputOffsets();
          yawOffset = ypr[0];
        }
        roomba.clean();
        break;
      }
    case 'D': { //Dock
        roomba.dock();
        break;
      }
    case 'S': { //Spot
        roomba.spot();
        break;
      }
    case 'X': { //Stop command
        roomba.stop();
        break;
      }
    case 'Q': { //Calibration run
        //Callibrate offsets for IMU
        mpu.CalibrateAccel(7);
        mpu.CalibrateGyro(7);
        OutputOffsets();
        yawOffset = ypr[0];
        roomba.Xcoo = 0;
        roomba.Ycoo = 0;
        roomba.theta = 0;
        roomba.playScript(CallibrationRun);
        break;
      }
    case 'E': { //Empty dusbin
        if(roomba.docked){
          //Callibrate offsets for IMU and reset Yaw
          mpu.CalibrateAccel(7);
          mpu.CalibrateGyro(7);
          OutputOffsets();
          yawOffset = ypr[0];
          roomba.playScript(Empty);
          roomba.playMusic(macGyver, sizeof(macGyver));
        }
        else {
          roomba.playMusic(imperialMarch, sizeof(imperialMarch));
        }
        break;
      }
    case 'I': { //Initialize IMU
        //Callibrate offsets for IMU
        mpu.CalibrateAccel(7);
        mpu.CalibrateGyro(7);
        OutputOffsets();
        yawOffset = ypr[0];
        break;
      }
    case 'M': { //Locate / play music
        static bool songSelect;
        if(songSelect){
          roomba.playMusic(imperialMarch, sizeof(imperialMarch));
        }
        else{
          roomba.playMusic(macGyver, sizeof(macGyver));
        }
        songSelect = !songSelect;
        MQTT_UpdateSensors();
        break;
      }
    default:
      roomba.stop();
      break;
  }
}

void onMqttPublish(uint16_t packetId) {}

//Roomba event callbacks:
void onEndRun(){
  mqttClient.publish(HANAME "/device_automation/" DEVICENAME "_" DEVICEID "/event_EndRun", 
  0, false, 
  "end run");
  MQTT_UpdateSensors();
}
void onStartRun(){
  mqttClient.publish(HANAME "/device_automation/" DEVICENAME "_" DEVICEID "/event_StartRun", 
  0, false, 
  "start run");
  MQTT_UpdateSensors();
}
void onRoombaError(){
  mqttClient.publish(HANAME "/device_automation/" DEVICENAME "_" DEVICEID "/event_Error", 
  0, false, 
  "error");
  MQTT_UpdateSensors();
}
void onRoombaStateChange(){
  MQTT_UpdateStates();
}
void MQTTAutoConfig() {
  //Event triggers
  //Cleaning
  mqttClient.publish(
    HANAME "/device_automation/" DEVICENAME "_" DEVICEID "/event_StartRun/config", 
    0, true, 
    "{"
    "\"atype\": \"trigger\", "
    "\"pl\": \"start run\", "
    "\"p\": \"device_automation\", "
    "\"t\": \"" HANAME "/device_automation/" DEVICENAME "_" DEVICEID "/event_StartRun" "\", "
    "\"type\": \"event\", "
    "\"stype\": \"start_run\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  mqttClient.publish(
    HANAME "/device_automation/" DEVICENAME "_" DEVICEID "/event_EndRun/config", 
    0, true, 
    "{"
    "\"atype\": \"trigger\", "
    "\"pl\": \"end run\", "
    "\"p\": \"device_automation\", "
    "\"t\": \"" HANAME "/device_automation/" DEVICENAME "_" DEVICEID "/event_EndRun" "\", "
    "\"type\": \"event\", "
    "\"stype\": \"end_run\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  mqttClient.publish(
    HANAME "/device_automation/" DEVICENAME "_" DEVICEID "/event_Error/config", 
    0, true, 
    "{"
    "\"atype\": \"trigger\", "
    "\"pl\": \"error\", "
    "\"p\": \"device_automation\", "
    "\"t\": \"" HANAME "/device_automation/" DEVICENAME "_" DEVICEID "/event_Error" "\", "
    "\"type\": \"event\", "
    "\"stype\": \"error\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );

  //Actions
  //Start cleaning
  mqttClient.publish(
    HANAME "/button/" DEVICENAME "_" DEVICEID "/clean_button/config", 
    0, true, 
    "{"
    "\"name\": \"Start cleaning\", "
    "\"cmd_t\": \"" HANAME "/button/" DEVICENAME "_" DEVICEID "/set" "\", "
    "\"pl_prs\": \"Clean\", "
    "\"avty_t\": \"" HANAME "/button/" DEVICENAME "_" DEVICEID "/clean_button/available" "\", "
    "\"uniq_id\": \"" DEVICENAME "_" DEVICEID "_Clean\", "
    "\"ic\": \"mdi:vacuum-outline\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  //Return to dock
  mqttClient.publish(
    HANAME "/button/" DEVICENAME "_" DEVICEID "/dock_button/config", 
    0, true, 
    "{"
    "\"name\": \"Return to dock\", "
    "\"cmd_t\": \"" HANAME "/button/" DEVICENAME "_" DEVICEID "/set" "\", "
    "\"pl_prs\": \"Dock\", "
    "\"avty_t\": \"" HANAME "/button/" DEVICENAME "_" DEVICEID "/dock_button/available" "\", "
    "\"uniq_id\": \"" DEVICENAME "_" DEVICEID "_Dock\", "
    "\"ic\": \"mdi:home-import-outline\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  //Locate / music
  mqttClient.publish(
    HANAME "/button/" DEVICENAME "_" DEVICEID "/locate_button/config", 
    0, true, 
    "{"
    "\"name\": \"Play music\", "
    "\"cmd_t\": \"" HANAME "/button/" DEVICENAME "_" DEVICEID "/set" "\", "
    "\"pl_prs\": \"Music\", "
    "\"avty_t\": \"" HANAME "/button/" DEVICENAME "_" DEVICEID "/locate_button/available" "\", "
    "\"uniq_id\": \"" DEVICENAME "_" DEVICEID "_Locate\", "
    "\"ic\": \"mdi:music\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  //Empty dustbin
  mqttClient.publish(
    HANAME "/button/" DEVICENAME "_" DEVICEID "/empty_button/config", 
    0, true, 
    "{"
    "\"name\": \"Empty dustbin\", "
    "\"cmd_t\": \"" HANAME "/button/" DEVICENAME "_" DEVICEID "/set" "\", "
    "\"pl_prs\": \"Empty\", "
    "\"avty_t\": \"" HANAME "/button/" DEVICENAME "_" DEVICEID "/empty_button/available" "\", "
    "\"uniq_id\": \"" DEVICENAME "_" DEVICEID "_Empty\", "
    "\"ic\": \"mdi:delete-empty\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  //Sensors
  //System voltage:
  mqttClient.publish(
    HANAME "/sensor/" DEVICENAME "_" DEVICEID "/voltage/config", 
    0, true, 
    "{"
    "\"name\": \"System voltage\", "
    "\"dev_cla\": \"voltage\", "
    "\"stat_t\": \"" HANAME "/sensor/" DEVICENAME "_" DEVICEID "/voltage/value" "\", "
    "\"stat_cla\": \"measurement\", "
    "\"unit_of_meas\": \"mV\", "
    "\"val_tpl\": \"{{value_json.V}}\", "
    "\"uniq_id\": \"" DEVICENAME "_" DEVICEID "_SysVoltage\", "
    "\"ic\": \"mdi:battery-plus\", "
    "\"exp_aft\": \"600\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  //System current:
  mqttClient.publish(
    HANAME "/sensor/" DEVICENAME "_" DEVICEID "/current/config", 
    0, true, 
    "{"
    "\"name\": \"System current\", "
    "\"dev_cla\": \"current\", "
    "\"stat_t\": \"" HANAME "/sensor/" DEVICENAME "_" DEVICEID "/current/value" "\", "
    "\"stat_cla\": \"measurement\", "
    "\"unit_of_meas\": \"mA\", "
    "\"val_tpl\": \"{{value_json.A}}\", "
    "\"uniq_id\": \"" DEVICENAME "_" DEVICEID "_SysCurrent\", "
    "\"ic\": \"mdi:current-dc\", "
    "\"exp_aft\": \"600\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  //Battery temperature:
  mqttClient.publish(
    HANAME "/sensor/" DEVICENAME "_" DEVICEID "/temperature/config", 
    0, true, 
    "{"
    "\"name\": \"Battery temperature\", "
    "\"dev_cla\": \"temperature\", "
    "\"stat_t\": \"" HANAME "/sensor/" DEVICENAME "_" DEVICEID "/temperature/value" "\", "
    "\"stat_cla\": \"measurement\", "
    "\"unit_of_meas\": \"°C\", "
    "\"val_tpl\": \"{{value_json.Bt}}\", "
    "\"uniq_id\": \"" DEVICENAME "_" DEVICEID "_BatTemp\", "
    "\"ic\": \"mdi:battery-heart\", "
    "\"exp_aft\": \"600\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  //WiFi signal:
  mqttClient.publish(
    HANAME "/sensor/" DEVICENAME "_" DEVICEID "/signal/config", 
    0, true, 
    "{"
    "\"name\": \"WiFi signal strength\", "
    "\"dev_cla\": \"signal_strength\", "
    "\"stat_t\": \"" HANAME "/sensor/" DEVICENAME "_" DEVICEID "/signal/value" "\", "
    "\"stat_cla\": \"measurement\", "
    "\"unit_of_meas\": \"dBm\", "
    "\"val_tpl\": \"{{value_json.Si}}\", "
    "\"uniq_id\": \"" DEVICENAME "_" DEVICEID "_Signal\", "
    "\"ic\": \"mdi:wifi\", "
    "\"exp_aft\": \"600\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  //Number of loops:
  mqttClient.publish(
    HANAME "/sensor/" DEVICENAME "_" DEVICEID "/loops/config", 
    0, true, 
    "{"
    "\"name\": \"Main program loops per second\", "
//    "\"dev_cla\": \"None\", "
    "\"stat_t\": \"" HANAME "/sensor/" DEVICENAME "_" DEVICEID "/loops/value" "\", "
    "\"stat_cla\": \"measurement\", "
//    "\"unit_of_meas\": \"Hz\", "
    "\"val_tpl\": \"{{value_json.Lp}}\", "
    "\"uniq_id\": \"" DEVICENAME "_" DEVICEID "_Loops\", "
    "\"ic\": \"mdi:reload\", "
    "\"exp_aft\": \"600\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  //Free RAM:
  mqttClient.publish(
    HANAME "/sensor/" DEVICENAME "_" DEVICEID "/RAM/config", 
    0, true, 
    "{"
    "\"name\": \"Free RAM\", "
//    "\"dev_cla\": \"None\", "
    "\"stat_t\": \"" HANAME "/sensor/" DEVICENAME "_" DEVICEID "/RAM/value" "\", "
    "\"stat_cla\": \"measurement\", "
//    "\"unit_of_meas\": \"Hz\", "
    "\"val_tpl\": \"{{value_json.RAM}}\", "
    "\"uniq_id\": \"" DEVICENAME "_" DEVICEID "_RAM\", "
    "\"ic\": \"mdi:memory\", "
    "\"exp_aft\": \"600\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  //Heap fragmentation:
  mqttClient.publish(
    HANAME "/sensor/" DEVICENAME "_" DEVICEID "/heap/config", 
    0, true, 
    "{"
    "\"name\": \"Fragmentation of heap memory\", "
//    "\"dev_cla\": \"None\", "
    "\"stat_t\": \"" HANAME "/sensor/" DEVICENAME "_" DEVICEID "/heap/value" "\", "
    "\"stat_cla\": \"measurement\", "
//    "\"unit_of_meas\": \"Hz\", "
    "\"val_tpl\": \"{{value_json.Hf}}\", "
    "\"uniq_id\": \"" DEVICENAME "_" DEVICEID "_Heap\", "
    "\"ic\": \"mdi:set-split\", "
    "\"exp_aft\": \"600\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
  //Debug value (can be WiFi reconnects, state):
  mqttClient.publish(
    HANAME "/sensor/" DEVICENAME "_" DEVICEID "/debug/config", 
    0, true, 
    "{"
    "\"name\": \"Value for debugging\", "
//    "\"dev_cla\": \"None\", "
    "\"stat_t\": \"" HANAME "/sensor/" DEVICENAME "_" DEVICEID "/debug/value" "\", "
//    "\"stat_cla\": \"measurement\", "
//    "\"unit_of_meas\": \"Hz\", "
    "\"val_tpl\": \"{{value_json.Db}}\", "
    "\"uniq_id\": \"" DEVICENAME "_" DEVICEID "_Debug\", "
    "\"ic\": \"mdi:bug\", "
    "\"exp_aft\": \"600\", "
    "\"dev\": {"
        "\"ids\": [\"" DEVICENAME "_" DEVICEID "\"], "
        "\"name\": \"" DEVICENAME "_" DEVICEID "\", "
        "\"mf\": \"" MANUFACTURER "\", "
        "\"sw\": \"" VERSION "\", "
        "\"mdl\": \"" MODEL "\""
        "}"
    "}"
    );
    MQTT_UpdateSensors();
}
void MQTT_UpdateSensors(){
  //Snapshot of memmory conditions
  ESPFreeHeap = ESP.getFreeHeap();
  ESPHeapFragmentation = ESP.getHeapFragmentation();
  debugVal ++;

  char buffer[32]; //96
  JsonDocument doc; //96
  doc["V"] = roomba.batteryVoltage;
  size_t n = serializeJson(doc, buffer); 
  mqttClient.publish(HANAME "/sensor/" DEVICENAME "_" DEVICEID "/voltage/value", 0, false, buffer, n);
  doc.clear();
  doc["A"] = roomba.current;
  n = serializeJson(doc, buffer); 
  mqttClient.publish(HANAME "/sensor/" DEVICENAME "_" DEVICEID "/current/value", 0, false, buffer, n);
  doc.clear();
  doc["Bt"] = roomba.batteryTemp;
  n = serializeJson(doc, buffer); 
  mqttClient.publish(HANAME "/sensor/" DEVICENAME "_" DEVICEID "/temperature/value", 0, false, buffer, n);
  doc.clear();
  doc["Si"] = WiFi.RSSI();
  n = serializeJson(doc, buffer); 
  mqttClient.publish(HANAME "/sensor/" DEVICENAME "_" DEVICEID "/signal/value", 0, false, buffer, n);
  doc.clear();
  //doc["Lp"] = SketchExtras.LoopsPerSec;
  doc["Lp"] = debugLoops;
  n = serializeJson(doc, buffer); 
  mqttClient.publish(HANAME "/sensor/" DEVICENAME "_" DEVICEID "/loops/value", 0, false, buffer, n);
  doc.clear();
  doc["RAM"] = ESPFreeHeap;
  n = serializeJson(doc, buffer); 
  mqttClient.publish(HANAME "/sensor/" DEVICENAME "_" DEVICEID "/RAM/value", 0, false, buffer, n);
  doc.clear();
  doc["Hf"] = ESPHeapFragmentation;
  n = serializeJson(doc, buffer); 
  mqttClient.publish(HANAME "/sensor/" DEVICENAME "_" DEVICEID "/heap/value", 0, false, buffer, n);
  doc.clear();
  doc["Db"] = debugVal;
  //doc["Db"] = roomba.debugVal;
  //debugVal = 0;
  //doc.shrinkToFit();
  n = serializeJson(doc, buffer); 
  mqttClient.publish(HANAME "/sensor/" DEVICENAME "_" DEVICEID "/debug/value", 0, false, buffer, n);
}
void MQTT_UpdatePositionLog(){
#ifdef TEST
#else
  char buffer[32]; //64
  JsonDocument doc;
  doc["X"] = roomba.Xcoo;
  doc["Y"] = roomba.Ycoo;
  //doc["rTh"] = roomba.theta;
  //doc["rTh"] = roomba.AuxYaw;
  //doc["bR"] = roomba.bumpRight;
  //doc["bL"] = roomba.bumpLeft;
  //doc.shrinkToFit();
  size_t n = serializeJson(doc, buffer);
  mqttClient.publish(MQTT_POSE_TOPIC, 0, false, buffer, n);
#endif
}
void MQTT_UpdateRawLog(){
#ifdef TEST
#else
  char buffer[192]; //192 for all (>160)
  JsonDocument doc;
  doc["EL"] = roomba.encoderLeft;
  doc["ER"] = roomba.encoderRight;
  doc["Th"] = roomba.theta;
  doc["Xa"] = roomba.AuxXacc;
  doc["Ya"] = roomba.AuxYacc;
  doc["Yw"] = roomba.AuxYaw;
  doc["LL"] = roomba.ltBumperLeft;
  doc["FL"] = roomba.ltBumperFrontLeft;
  doc["CL"] = roomba.ltBumperCenterLeft;
  doc["CR"] = roomba.ltBumperCenterRight;
  doc["FR"] = roomba.ltBumperFrontRight;
  doc["RR"] = roomba.ltBumperRight;
  //doc.shrinkToFit();
  size_t n = serializeJson(doc, buffer);
  //debugVal = n;-
  mqttClient.publish(MQTT_RAW_TOPIC, 0, false, buffer, n);
#endif
}
void MQTT_UpdateStates(){
  if((roomba.roombaState == roombaIdle)||
    (roomba.roombaState == roombaHome) || 
    (roomba.roombaState == roombaDocking) ||
    (roomba.roombaState == roombaSpotCleaning) ||
    (roomba.roombaState == roombaPlayingScript)){
      mqttClient.publish(HANAME "/button/" DEVICENAME "_" DEVICEID "/clean_button/available", 0, true, "online"); 
  }
  else{
      mqttClient.publish(HANAME "/button/" DEVICENAME "_" DEVICEID "/clean_button/available", 0, true, "offline");
  }
  if((roomba.roombaState == roombaIdle)|| 
    (roomba.roombaState == roombaCleaning) ||
    (roomba.roombaState == roombaSpotCleaning) ||
    (roomba.roombaState == roombaPlayingScript)){
      mqttClient.publish(HANAME "/button/" DEVICENAME "_" DEVICEID "/dock_button/available", 0, true, "online");
  }
  else{
      mqttClient.publish(HANAME "/button/" DEVICENAME "_" DEVICEID "/dock_button/available", 0, true, "offline"); 
  }
  if((roomba.roombaState == roombaIdle)||
    (roomba.roombaState == roombaCleaning) || 
    (roomba.roombaState == roombaDocking) ||
    (roomba.roombaState == roombaSpotCleaning) ||
    (roomba.roombaState == roombaPlayingScript)){
      mqttClient.publish(HANAME "/button/" DEVICENAME "_" DEVICEID "/locate_button/available", 0, true, "online"); 
  }
  else{
      mqttClient.publish(HANAME "/button/" DEVICENAME "_" DEVICEID "/locate_button/available", 0, true, "offline");
  }  

  if(roomba.roombaState == roombaHome){
      mqttClient.publish(HANAME "/button/" DEVICENAME "_" DEVICEID "/empty_button/available", 0, true, "online");
  }
  else{
      mqttClient.publish(HANAME "/button/" DEVICENAME "_" DEVICEID "/empty_button/available", 0, true, "offline"); 
  }
}
void OutputOffsets() {
  char buffer[96]; //96
  JsonDocument doc; //96
  doc["Xgyro"] =  mpu.getXGyroOffset();
  doc["Ygyro"] = mpu.getYGyroOffset();
  doc["Zgyro"] = mpu.getZGyroOffset();
  doc["Xacc"] = mpu.getXAccelOffset();
  doc["Yacc"] = mpu.getYAccelOffset();
  doc["Zacc"] = mpu.getZAccelOffset();
  size_t n = serializeJson(doc, buffer);
  mqttClient.publish(MQTT_PUB_TOPIC, 0, false, buffer, n);
}
