;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@        S Y M B O S   C O N S O L E   C O M M A N D   E X A M P L E         @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;
; Template for compiling SymbOS apps on SjAsmPlus by: NYYRIKKI
; For WinAPE templates (by Prodatron) visit: https://symbos.de

            output "BIN/HELLOMSX.COM"

            ; The fixed SymbOS file structure is:
            ; - Code area
            ;   - Application header
            ;   - Application code
            ; - Data area
            ; - Transfer area
            ; - Relocation table

            org #1000               ; Origin (High byte does not really matter much)
            relocate_start          ; SjAsmPlus statement. We want to be able to relocate everything.

Compile_Address:
;==============================================================================
;### CODE AREA ################################################################
;==============================================================================
Code_Area_Start:

            ; Name definitions used on documentation:
            include "LIB/SymbOS-Constants.asm"

            ; Support Macros for graphics:
            include "LIB/SymbOS-Macros.asm"

;------------------------------------------------------------------------------
;### APPLICATION HEADER #######################################################
;------------------------------------------------------------------------------
            ; Application header is same for SymbOS .COM and .EXE files.

            dw Code_Area_Size       ; +000 length of the code area
            dw Data_Area_Size       ; +002 length of the data area
            dw Transfer_Area_Size   ; +004 length of the transfer area
Data_Area_Address:                  ; +006 After loading:  This points to start of data area.
            dw Compile_Address      ; +006 Before loading: The address where program was compiled
Transter_Area_Address:              ; +008 After loading: This points to start of transfer adrea.
            dw relocate_count       ; +008 Before loading: Number of relocation table entries (SjAsm defined constant)
Sub_Proces_IDs:                     ; +010 (...+013) After loading: Sub process IDs (max 4pcs)
                                    ;      These will be killed automatically on exit
                                    ;      remove IDs from table if you kill manually.
            dw App_Stack_Offset     ; +010 Before loading: Application stack offset from Transfer area start
            dw 0                    ; +012 Before loading: Length of crunched data (NOT YET SUPPORTED)
App_Bank_Number:                    ; +014 After loading: RAM bank number where application was loaded.
            db 0                    ; +014 Before loading: Cruncher type (NOT YET SUPPORTED)
App_Name:   SIZE "SymbOS Example",24; +015 Application name (up to 24 characters)
            db 0                    ; +039 ASCIIZ String terminator (=0) in case the Name is max size
            db 1                    ; +040 Flags (+1=16 color icon available)
            dw App_16C_Icon.Offset  ; +041 16 color icon offset from beginning (Optional) 0 = None
            ds 5,0                  ; +043 (...+047) Reserved, must be 0
Reserved_Memory_Table:              ; +048 (...+087) After loading: Table of additional memory areas (max 8pcs)
                                    ;      Format: 8x ( db RAM_Bank : dw Address : dw Length )                   ;
            db "SymExe10"           ; +048 Before loading: SymbOS executable identification string
            dw 0                    ; +056 Before loading: Length of additional reserved code area memory
            dw 0                    ; +058 Before loading: Length of additional reserved data area memory
            dw 0                    ; +060 Before loading: Length of additional reserved transfer area memory
            ds 26,0                 ; +062 Before loading: Reserved space for future use. Must be 0
App_ID:                             ; +088 After loading: Application ID
            db 0                    ; +088 Before loading: Required OS Version minor (after dot)
Main_Process_ID:                    ; +089 After loading: Main process ID (Alternative address for App_Process_ID)
            db 2                    ; +089 Before loading: Required OS version major (before dot)
App_Icon_Small:                     ; +090 Application icon (small version), 8x8 pixel
            Graphic_Simple 8,8      ;      Macro for 4-color graphics header
            DS .ByteCount           ;      Actual picture data (16-bytes)
App_Icon_Large:                     ; +109 Application icon (Large version), 24x24 pixel
            Graphic_Simple 24,24    ;      Macro for 4-color graphics header
            DS .ByteCount           ;      Actual picture data (144-bytes)
                                    ; +256 Application code
;------------------------------------------------------------------------------
;### APPLICATION DATA #########################################################
;------------------------------------------------------------------------------

            ; This address has low byte 0, so this is good place to put
            ; ie. tables that need to be alligned to 256 byte boundary.

;------------------------------------------------------------------------------
;### START OF PROGRAM #########################################################
;------------------------------------------------------------------------------


App_Start:
            ; The application start address
            ; This address is defined in stack. -> See Transfer area
            ;
            ; Please note: Shadow registers are reserved for OS use.
            ;-------------------------------------------------------

            ; This routine contains all COM-file specific stuff. Other than these mandatory calls
            ; the Shell-program works like any other EXE-file.

            call SyShell_PARALL     ; Mandatory: Get commandline parameters
            call SyShell_PARSHL     ; Mandatory: Parse Shell-specific parameters (ie. Shell Process ID)
                                    ; Please see the SymShell include file & documentation for details.
                                    ; This call will parse also user parameters to "string descriptor"-list.

            call Main_Routine       ; Call our Hello You-program.
            call FLUSH_CHAR_BUFFER  ; Print possible remaining characters from MSX-library character buffer
                                    ;
            ld e,0                  ; Exit type: Quit (Exit permanently)
            call SyShell_EXIT       ; Mandatory: Tell Shell host that we are quitting
            jp SySystem_EXIT        ; Exit the program


            ; The actual "Hello You"-program written on MSX-BIOS style.

Main_Routine:

            ld hl,.TxtName   ; Print "What is your name"
            call .Print

            call QINLIN      ; Ask string input with "? "
            inc hl
            push hl

            ld hl,.TxtHello
            call .Print       ; Print "Hello, "

            pop hl
            call .Print       ; Print name

            ld hl,.TxtRet     ; Print CR,LF
.Print
            ld a,(hl)
            and a
            ret z
            inc hl
            push hl
            call CHPUT
            pop hl
            jr .Print


;--------------------------------

.TxtName:    db "What is your name",0
.TxtHello:   db 10,13,"Hello, ",0
.TxtRet:     db 10,13,0

;------------------------------------------------------------------------------
;### LIBRARIES ################################################################
;------------------------------------------------------------------------------

             ; Add custom libraries here:
             include "LIB/SymbOS_Lib-MSX-compatibility.asm"

             ; System libraries:
             ; All individual routines in these system libraries are included
             ; to project ONLY if they are used ABOWE, so normally there
             ; should be no reason to comment these lines out.

             include "LIB/SymbOS_Lib-NetworkDaemon.asm"
             include "LIB/SymbOS_Lib-SymShell.asm"
             include "LIB/SymbOS_Lib-FileManager.asm"
             include "LIB/SymbOS_Lib-DesktopManager.asm"
             include "LIB/SymbOS_Lib-SystemManager.asm"
             include "LIB/SymbOS_Lib-Kernel.asm"

Code_Area_End:
Code_Area_Size: equ Code_Area_End - Code_Area_Start
;==============================================================================
;### DATA AREA ################################################################
;==============================================================================
Data_Area_Start:   ; ; (Will be loaded to 256-byte boundary)

            ; Place all data here that needs to be plotted to desktop
            ; Even if not needed, every area must have at least 1 byte of data.


            ; Optional 16-color application icon (24px x 24px)
App_16C_Icon:
            Graphic_Extended 24,24  ; Macro for 16-color graphics header
            DS .ByteCount           ; Graphics in MSX SCREEN 5/7 format (288 bytes)

Data_Area_End:
Data_Area_Size equ Data_Area_End - Data_Area_Start
;==============================================================================
;### TRANSFER AREA ############################################################
;==============================================================================
Transfer_Area_Start:  ; (Will be loaded to 256-byte boundary)

            ; Data area for the stack, the message buffer and all window data records,
            ; control data records and their control variables (radio button status,
            ; selected tab etc.)

            ;--- Main process stack definition  ---
            ds 128                  ; Your app default stack space, increase if needed
App_Stack:  ds 6*2                  ; Fixed space for register storage
            dw App_Start            ; The stack content defines your applications start address
App_Process_ID:
            db 0                    ; process ID (Filled by kernel, alternative address for Main_Proces_ID)
App_Stack_Offset: equ App_Stack - Transfer_Area_Start
            ;--- End of main process stack ---

            ; You can add more stacks here if needed for other processes

            ;--- Common Message buffer used by the libraries ---
Message_Buffer:
            ds 14

            ; Other possible data that needs to be on Transfer area

Transfer_Area_End:
Transfer_Area_Size equ Transfer_Area_End - Transfer_Area_Start
;==============================================================================
;### RELOCATION TABLE #########################################################
;==============================================================================

            ; Relocation table will be placed here
            ; by SjAsmPlus and handled by OS, do not modify.
            ;
            ; Please note: Don't break this system by
            ; using coding style like:
            ;   LD H,EXAMPLE / 256
            ;   LD L,A
            ; Write instead:
            ;   LD HL,EXAMPLE
            ;   LD L,A

            relocate_table
            relocate_end

The_End:    ; This random label is placed here just to catch errors if assembly
            ; can't be done on 3 passes. (Reorder your code properly.)