;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@                S Y M B O S   G R A P H I C   L I B R A R Y                 @
;@        - PLATFORM INDEPENDENT GRAPHIC FUNCTIONS FOR PICTURE BOXES -        @
;@                                    API                                     @
;@                                                                            @
;@               (c) 2014 by Prodatron / SymbiosiS (Jrn Mika)                @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


gfxbnkbuf   ds 256
gfxbnknum   db 0


;### GFXSET -> Setups graphic library inside a secondary ram bank
;### Input      HL=filename, A=destination bank, DE=destination address, (gfxbnknum)=actual bank
;### Output     CF=0 -> ok, CF=1 -> A=error code (-2=corrupt file)
;### Destroyed  AF,BC,DE,HL,IX,IY,(gfxbnkbuf)
gfxset  ld (gfxset1+1),sp
        ld (gfxset2+1),a
        ld (gfxset3+1),de
        ld a,(gfxbnknum)
        db #dd:ld h,a
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILOPN
        ret c
        ld hl,gfxbnkbuf
        ld de,(gfxbnknum)
        ld bc,4
        call gfxset0
        ld a,b
        ld bc,(gfxbnkbuf+0)
gfxset2 ld e,0
gfxset3 ld hl,0
        call gfxset0
gfxset4 ld hl,(gfxbnkbuf+2)
        ld a,l
        or h
        jr z,gfxset8
        ld de,126
        or a
        sbc hl,de
        jr nc,gfxset5
        add hl,de
        ex de,hl
        ld hl,0
gfxset5 ld (gfxbnkbuf+2),hl
        push de
        ld a,b
        ex de,hl
        add hl,hl
        ld c,l
        ld b,h
        ld hl,gfxbnkbuf+4
        ld de,(gfxbnknum)
        push hl
        call gfxset0
        ld hl,(gfxset3+1)
        ld de,-#1000
        add hl,de
        ld (gfxset7+1),hl
        pop hl          ;hl=reloctab
        pop de          ;de=number of entries
        push bc
gfxset6 push de
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        push hl
        ex de,hl
gfxset7 ld de,0
        add hl,de
        ld a,(gfxset2+1)
        rst #20:dw jmp_bnkrwd
        dec hl
        dec hl
        ex de,hl
        add hl,bc
        ld c,l
        ld b,h
        ex de,hl
        rst #20:dw jmp_bnkwwd
        pop hl
        pop de
        dec de
        ld a,e
        or d
        jr nz,gfxset6
        pop bc
        jr gfxset4
gfxset0 push af
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILINP
        pop bc
        jp c,gfxset1
        ld a,-2
        scf
        jr nz,gfxset1
        ret
gfxset8 xor a
        ld (gfxbnkbuf+16),a
        inc a
        ld (gfxbnkbuf+0),a
        ld a,(gfxbnknum)
        ld (gfxbnkbuf+1),a
        ld a,(gfxset2+1)
        ld de,(gfxset3+1)
        ld hl,gfxbnkbuf
        ld bc,17
        call gfxcll
        xor a
gfxset1 ld sp,0
        push af
        ld a,b
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILCLO
        pop af
        ret

;### GFXCLL -> Calls graphic library
;### Input      A=bank, DE=address, HL=command queue, BC=queue length, (gfxbnknum)=actual bank
;###            command queue = (16 * [cmd,15 byte parameters])
;###            cmd0 -> abort
;###            cmd1 -> ini (p01=A)
;###            cmd2 -> enc (p01=IX)
;###            cmd3 -> cop (p01=A,p02=BC,p04=DE,p06=HL,p08=IX,p10=IY)
;### Destroyed  AF,BC,DE,HL,IX,IY
gfxcll  push af
        push de
        push hl
        ld hl,63
        add hl,de
        ex de,hl
        add a:add a:add a:add a
        ld hl,gfxbnknum
        add (hl)
        pop hl
        push de
        rst #20:dw jmp_bnkcop
        pop iy
        pop ix
        pop bc
        jp jmp_bnkcll

;### GFXPID -> Prepares fast graphic pasting (GFXSID)
;### Input      C=bank, DE=address, IX=canvas header, IY=canvas ylen, HL=ypos correction, A=transparency
gfxpidc db 3:ds 16
gfxpid  ld (gfxpidc+1),a
        ld (gfxpidc+2),ix
        ld (gfxpidc+4),iy
        ld (gfxpidc+6),hl
        ld a,c
        ld (gfxsid3+1),a
        ld hl,3
        add hl,de
        ld (gfxsid1+2),hl
        ld bc,63-3
        add hl,bc
        ld (gfxsid2+2),hl
        ld hl,gfxpidc
        ld bc,17
        jr gfxcll

;### GFXSID -> Pastes graphic into another one via ID and pre-settings
;### Input      A=graphic ID (0-127), DE=xpos signed, HL=ypos (0-511)
gfxsid  add a           ;1
        or h            ;1
        ld h,a          ;1
gfxsid1 ld ix,0         ;4
gfxsid2 ld iy,0         ;4
gfxsid3 ld b,0          ;2
        jp jmp_bnkcll   ;3 16


SySystem_CallFunction
;******************************************************************************
;*** Name           System_CallFunction
;*** Input          ((SP+0)) = System manager command
;***                ((SP+1)) = Function ID
;***                AF,BC,DE,HL,IX,IY = Input for the function
;*** Output         AF,BC,DE,HL,IX,IY = Output from the function
;*** Destroyed      -
;*** Description    Calls a function via the system manager. This function is
;***                needed to have access to the file manager.
;******************************************************************************
        ld (AppMsgB+04),bc      ;copy registers into the message buffer
        ld (AppMsgB+06),de
        ld (AppMsgB+08),hl
        ld (AppMsgB+10),ix
        ld (AppMsgB+12),iy
        push af
        pop hl
        ld (AppMsgB+02),hl
        pop hl
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        push hl
        ld (AppMsgB+00),de      ;module und funktion number
        ld a,e
        ld (SyCallN),a
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #10                 ;send message
SyCall1 rst #30
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #18                 ;wait for answer
        db #dd:dec l
        jr nz,SyCall1
        ld a,(AppMsgB)
        sub 128
        ld e,a
        ld a,(SyCallN)
        cp e
        jr nz,SyCall1
        ld hl,(AppMsgB+02)      ;get registers out of the message buffer
        push hl
        pop af
        ld bc,(AppMsgB+04)
        ld de,(AppMsgB+06)
        ld hl,(AppMsgB+08)
        ld ix,(AppMsgB+10)
        ld iy,(AppMsgB+12)
        ret
SyCallN db 0
