;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@     S Y M B O S   W I N D O W   A P P L I C A T I O N   E X A M P L E      @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;
; Template for compiling SymbOS apps on SjAsmPlus by: NYYRIKKI
; For WinAPE templates (by Prodatron) visit: https://symbos.de

            output "BIN/HELLO_U.EXE"

            ; The fixed SymbOS file structure is:
            ; - Code area
            ;   - Application header
            ;   - Application code
            ; - Data area
            ; - Transfer area
            ; - Relocation table

            org #1000               ; Origin (High byte does not really matter much)
            relocate_start          ; SjAsmPlus statement. We want to be able to relocate everything.

Compile_Address:
;==============================================================================
;### CODE AREA ################################################################
;==============================================================================
Code_Area_Start:

            ; Name definitions used on documentation:
            include "LIB/SymbOS-Constants.asm"

            ; Support Macros for graphics:
            include "LIB/SymbOS-Macros.asm"

;------------------------------------------------------------------------------
;### APPLICATION HEADER #######################################################
;------------------------------------------------------------------------------
            ; Application header is same for SymbOS .COM and .EXE files.

            dw Code_Area_Size       ; +000 length of the code area
            dw Data_Area_Size       ; +002 length of the data area
            dw Transfer_Area_Size   ; +004 length of the transfer area
Data_Area_Address:                  ; +006 After loading:  This points to start of data area.
            dw Compile_Address      ; +006 Before loading: The address where program was compiled
Transter_Area_Address:              ; +008 After loading: This points to start of transfer adrea.
            dw relocate_count       ; +008 Before loading: Number of relocation table entries (SjAsm defined constant)
Sub_Proces_IDs:                     ; +010 (...+013) After loading: Sub process IDs (max 4pcs)
                                    ;      These will be killed automatically on exit
                                    ;      remove IDs from table if you kill manually.
            dw App_Stack_Offset     ; +010 Before loading: Application stack offset from Transfer area start
            dw 0                    ; +012 Before loading: Length of crunched data (NOT YET SUPPORTED)
App_Bank_Number:                    ; +014 After loading: RAM bank number where application was loaded.
            db 0                    ; +014 Before loading: Cruncher type (NOT YET SUPPORTED)
App_Name:   SIZE "SymbOS Example",24; +015 Application name (up to 24 characters)
            db 0                    ; +039 ASCIIZ String terminator (=0) in case the Name is max size
            db 1                    ; +040 Flags (+1=16 color icon available)
            dw App_16C_Icon.Offset  ; +041 16 color icon offset from beginning (Optional) 0 = None
            ds 5,0                  ; +043 (...+047) Reserved, must be 0
Reserved_Memory_Table:              ; +048 (...+087) After loading: Table of additional memory areas (max 8pcs)
                                    ;      Format: 8x ( db RAM_Bank : dw Address : dw Length )                   ;
            db "SymExe10"           ; +048 Before loading: SymbOS executable identification string
            dw 0                    ; +056 Before loading: Length of additional reserved code area memory
            dw 0                    ; +058 Before loading: Length of additional reserved data area memory
            dw 0                    ; +060 Before loading: Length of additional reserved transfer area memory
            ds 26,0                 ; +062 Before loading: Reserved space for future use. Must be 0
App_ID:                             ; +088 After loading: Application ID
            db 0                    ; +088 Before loading: Required OS Version minor (after dot)
Main_Process_ID:                    ; +089 After loading: Main process ID (Alternative address for App_Process_ID)
            db 2                    ; +089 Before loading: Required OS version major (before dot)
App_Icon_Small:                     ; +090 Application icon (small version), 8x8 pixel
            Graphic_Simple 8,8      ;      Macro for 4-color graphics header
            DS .ByteCount           ;      Actual picture data (16-bytes)
App_Icon_Large:                     ; +109 Application icon (Large version), 24x24 pixel
            Graphic_Simple 24,24    ;      Macro for 4-color graphics header
            DS .ByteCount           ;      Actual picture data (144-bytes)
                                    ; +256 Application code
;------------------------------------------------------------------------------
;### APPLICATION DATA #########################################################
;------------------------------------------------------------------------------

            ; This address has low byte 0, so this is good place to put
            ; ie. tables that need to be alligned to 256 byte boundary.

;------------------------------------------------------------------------------
;### START OF PROGRAM #########################################################
;------------------------------------------------------------------------------


App_Start:
            ; The application start address
            ; This address is defined in stack. -> See Transfer area
            ;
            ; Please note: Shadow registers are reserved for OS use.
            ;-------------------------------------------------------

            call Main_Routine
            jp Quit

Main_Routine:

            ; This is the "Hello You" example for SymbOS

                                       ; First let's prepare things a bit, so it will be easier to read..
                                       ;
            ld iy,Desktop_Message      ; This is the first "Window open" message we want to send to Desktop manager
            ld a,(App_Bank_Number)     ; Our messages are on Tranfer area, but on same RAM bank as our program
            ld (iy+1),a                ; Let's tell our "post office" to Desktop manager so it knows where to respond
            ld (System_Message+3),a    ; Let's also tell it to System manager a bit later
                                       ;
            ld a,(App_Process_ID)      ; It is me, who is talking... (our application and bank can have multiple processes)
            ld l,a                     ;
            ld h,PRC_ID_SYSTEM         ; Sometimes I like to talk to System manager
            ld (Me2System),hl          ; So let's save our contact details for later use
            ld ixl,a                   ;
            ld ixh,PRC_ID_DESKTOP      ; ...but first I want to talk to Desktop manager
            ld (Me2Desktop),ix         ; and let's save these contact details as well...
            ld (Question_Form+3),a     ; I need Desktop manager to know that I also own the question form we will be talking about.
                                       ; So...
            rst #10                    ; Hello, Desktop manager, here is my "Window open" request for my question form!
            dec ixl                    ; (See passive content from Transfer area)
            ret nz                     ; Something on sending went horribly wrong -> Quit (Though so unlikely that I won't do this check again)

.WaitDeskMSG
            ld ix,(Me2Desktop)         ; I want to talk with Desktop manager
            rst #08                    ; I'm waiting for a message
            ld a,ixl                   ;
            and a                      ;
            jr z,.WaitDeskMSG          ; "All our lines are busy at the moment, please hold."
            ld a,(iy)                  ; You have a message.
            cp MSR_DSK_WOPNOK          ; Was our form opened successfully?
            jr z,.Save_ID              ; Yes, save ID for later use and wait for next message
            cp MSR_DSK_WOPNER          ; Did it fail to open? Horrible news...
            ret z                      ; I didn't expect this to happen in real life. I think I should just quit ASAP.
            cp MSR_DSK_WCLICK          ; Was the message about our form being clicked?
            jr nz,.WaitDeskMSG         ; No? Then I'm not interested... Call again when you have something I like to know.
            ld a,(iy+2)                ; Yes, I want to know more
            cp DSK_ACT_CLOSE           ; Was it a close-button click?
            jr z,.Close_Window         ; Yes? Ok, then close the damn window and quit
            cp DSK_ACT_CONTENT         ; Was it click to the Window content?
            jr nz,.WaitDeskMSG         ; No? Must have been key or something... Next message please
            ld a,(iy+8)                ; Give me the Window control ID value
            and a                      ; Maybe zero?
            jr z,.WaitDeskMSG          ; Tough luck... I've given only my Ok-button a non zero value. Call again.
                                       ; Ok, so we finally had an Ok-button click...
            call .Close_Window         ; You can close the window now.
                                       ; Definitely too much window design & handling for one example application...
            ld ix,(Me2System)          ; I want to talk about this to System manager
            ld iy,System_Message       ; Here is preloaded Message buffer with display instructions. (See transfer area)
            rst #10                    ; Dear System manager, could you please just display this message as info box?

.WaitSysMSG
            ld ix,(Me2System)          ; Hello System manager,
            rst #08                    ; I'm waiting for responce.
            ld a,ixl
            and a
            jr z,.WaitSysMSG           ; System manager is busy at the moment, he will come back to you soon.
            ld a,(iy)                  ; Ok, we got message.
            cp MSR_SYS_SYSWRN          ; Is this message about the info box we requested?
            jr nz,.WaitSysMSG          ; Nope? Well... We are not really interested...
            ret                        ; Yes? Well... We still don't actually care if the display was successful
                                       ; or not as we will quit anyway

.Save_ID:
            ld a,(iy+4)                ; Save Window ID for later use
            ld (WindowID),a
            jr .WaitDeskMSG

.Close_Window:
            ld ix,(Me2Desktop)         ; I want to talk with Desktop manager
            ld a,(WindowID)            ; Here is my window ID
            ld (iy+1),a
            ld (iy),MSC_DSK_WINCLS     ; Please close it.
            rst #10                    ; *Send the message*
            ret


Quit:
            ld ix,(Me2System)          ; I want to talk to System manager
            ld iy,System_Message
            ld a,(App_ID)              ; I'm done and I have just one more simple request:
            ld (iy+1),a                ; Here is my application ID
            ld (iy), MSC_SYS_PRGEND    ; Please just kill me, ok?
            rst #10                    ; *Send*
.Death_Spiral
            rst #30                    ; I'll just sit here and wait until I die.
            jr .Death_Spiral



Me2Desktop  dw 0                       ; Storage for my and Desktop manager ID
Me2System   dw 0                       ; Storage for my and System manager ID
WindowID    db 0                       ; Storage for Window ID


;------------------------------------------------------------------------------
;### LIBRARIES ################################################################
;------------------------------------------------------------------------------

             ; Add custom libraries here:

             ; System libraries:
             ; All individual routines in these system libraries are included
             ; to project ONLY if they are used ABOWE, so normally there
             ; should be no reason to comment these lines out.

             ; include "LIB/SymbOS_Lib-NetworkDaemon.asm"
             ; include "LIB/SymbOS_Lib-SymShell.asm"
             ; include "LIB/SymbOS_Lib-FileManager.asm"
             ; include "LIB/SymbOS_Lib-DesktopManager.asm"
             ; include "LIB/SymbOS_Lib-SystemManager.asm"
             ; include "LIB/SymbOS_Lib-Kernel.asm"

Code_Area_End:
Code_Area_Size: equ Code_Area_End - Code_Area_Start
;==============================================================================
;### DATA AREA ################################################################
;==============================================================================
Data_Area_Start: ; (Will be loaded to 256-byte boundary)

                 ; Place all data here that needs to be plotted to desktop
                 ; Even if not needed, every area must have at least 1 byte of data.


                 ; Optional 16-color application icon (24px x 24px)
App_16C_Icon:
                 Graphic_Extended 24,24  ; Macro for 16-color graphics header
                 DS .ByteCount           ; Graphics in MSX SCREEN 5/7 format (288 bytes)

;-----------------------------------------------
; String data for our "Hello You" question form:

Title_Text       db "Question:",0
Label_Text:      db "What is your name?",0
Ok_Text          db "Ok"
Zero             db 0

; String used on the Infobox:

Hello_Text       ds 10,32                ; Some spaces are used to adjust the location of string
                 db "Hello, "
Name_Buffer      ds 14,0


;-----------------------------------------------

Data_Area_End:
Data_Area_Size   equ Data_Area_End - Data_Area_Start
;==============================================================================
;### TRANSFER AREA ############################################################
;==============================================================================
Transfer_Area_Start:  ; (Will be loaded to 256-byte boundary)

            ; Data area for the stack, the message buffer and all window data records,
            ; control data records and their control variables (radio button status,
            ; selected tab etc.)

            ;--- Main process stack definition  ---

                 ds 128            ; Your app default stack space, increase if needed
App_Stack:       ds 6*2            ; Fixed space for register storage
                 dw App_Start      ; The stack content defines your applications start address
App_Process_ID:  db 0              ; process ID (Filled by kernel, alternative address for Main_Proces_ID)
App_Stack_Offset: equ App_Stack - Transfer_Area_Start

            ;--- End of main process stack ---

            ; You can add more stacks here if needed for other processes

            ;--- Message buffers ---

System_Message: ; Infobox popup.

                 db MSC_SYS_SYSWRN; 2 ; Open infobox
                 dw Infobox_Content_Data
                 db 0              ; Ram Bank
                 db %00010001      ; 1-button infobox
                 ds 9              ; Unused message buffer space

Infobox_Content_Data: ;(See System manager Dialogue_Infobox_Command)

                 dw Zero,6          ; Line1, color
                 dw Hello_Text,6    ; Line2, color
                 dw Zero,6          ; Line3, color


Desktop_Message:
                 db MSC_DSK_WINOPN
                 db 0              ; Ram Bank
                 dw Question_Form
                 ds 10             ; Unused message buffer space


;--- START OF FORM DATA ---

                    ; See Desktop Data Records documentation

Question_Form:      ; WINDOW DATA RECORD
                 dw #1481,7,079,035,116,070,0,0,116,070,116,070,116,070
                 dw 0,Title_Text,0,0,.Control_Group,0,0
                 ds 136+14

.Control_Group:     ; CONTROL GROUP DATA RECORD
                 db .Control_Records_Count,0
                 dw .Control_Records,0,0,4,0,0,3

.Control_Records:   ; CONTROL DATA RECORDS
    dw 00,          0 ,2,             0,0,1000,1000,0 ; Background fill (See: paint_area)
    dw 00,255*256+  1,.Label_Record,  08, 10,100, 8,0 ; Label           (See: paint_text)
    dw 00,255*256+ 32,.Namebox_Record,23, 28, 70,12,0 ; Name box        (See: textinput_line)
    dw 01,255*256+ 16, Ok_Text,       33, 48, 50,12,0 ; "Ok"-Button     (See: button_simple)
.Control_Records_Count equ ($-.Control_Records)/16

                    ; ITEM DATA RECORDS
.Label_Record:   dw Label_Text, 2+4+512
.Namebox_Record: dw Name_Buffer,0,0,0,0,13,0


;----- END OF FORM -----

            ; Other possible data that needs to be on Transfer area

Transfer_Area_End:
Transfer_Area_Size equ Transfer_Area_End - Transfer_Area_Start
;==============================================================================
;### RELOCATION TABLE #########################################################
;==============================================================================

            ; Relocation table will be placed here
            ; by SjAsmPlus and handled by OS, do not modify.
            ;
            ; Please note: Don't break this system by
            ; using coding style like:
            ;   LD H,EXAMPLE / 256
            ;   LD L,A
            ; Write instead:
            ;   LD HL,EXAMPLE
            ;   LD L,A

            relocate_table
            relocate_end

The_End:    ; This random label is placed here just to catch errors if assembly
            ; can't be done on 3 passes. (Reorder your code properly.)