;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@     S Y M B O S   W I N D O W   A P P L I C A T I O N   E X A M P L E      @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;
; Template for compiling SymbOS apps on SjAsmPlus by: NYYRIKKI
; For WinAPE templates (by Prodatron) visit: https://symbos.de

            output "BIN/HELLOU.EXE"

            ; The fixed SymbOS file structure is:
            ; - Code area
            ;   - Application header
            ;   - Application code
            ; - Data area
            ; - Transfer area
            ; - Relocation table

            org #1000               ; Origin (High byte does not really matter much)
            relocate_start          ; SjAsmPlus statement. We want to be able to relocate everything.

Compile_Address:
;==============================================================================
;### CODE AREA ################################################################
;==============================================================================
Code_Area_Start:

            ; Name definitions used on documentation:
            include "LIB/SymbOS-Constants.asm"

            ; Support Macros for graphics:
            include "LIB/SymbOS-Macros.asm"

;------------------------------------------------------------------------------
;### APPLICATION HEADER #######################################################
;------------------------------------------------------------------------------
            ; Application header is same for SymbOS .COM and .EXE files.

            dw Code_Area_Size       ; +000 length of the code area
            dw Data_Area_Size       ; +002 length of the data area
            dw Transfer_Area_Size   ; +004 length of the transfer area
Data_Area_Address:                  ; +006 After loading:  This points to start of data area.
            dw Compile_Address      ; +006 Before loading: The address where program was compiled
Transter_Area_Address:              ; +008 After loading: This points to start of transfer adrea.
            dw relocate_count       ; +008 Before loading: Number of relocation table entries (SjAsm defined constant)
Sub_Proces_IDs:                     ; +010 (...+013) After loading: Sub process IDs (max 4pcs)
                                    ;      These will be killed automatically on exit
                                    ;      remove IDs from table if you kill manually.
            dw App_Stack_Offset     ; +010 Before loading: Application stack offset from Transfer area start
            dw 0                    ; +012 Before loading: Length of crunched data (NOT YET SUPPORTED)
App_Bank_Number:                    ; +014 After loading: RAM bank number where application was loaded.
            db 0                    ; +014 Before loading: Cruncher type (NOT YET SUPPORTED)
App_Name:   SIZE "SymbOS Example",24; +015 Application name (up to 24 characters)
            db 0                    ; +039 ASCIIZ String terminator (=0) in case the Name is max size
            db 1                    ; +040 Flags (+1=16 color icon available)
            dw App_16C_Icon.Offset  ; +041 16 color icon offset from beginning (Optional) 0 = None
            ds 5,0                  ; +043 (...+047) Reserved, must be 0
Reserved_Memory_Table:              ; +048 (...+087) After loading: Table of additional memory areas (max 8pcs)
                                    ;      Format: 8x ( db RAM_Bank : dw Address : dw Length )                   ;
            db "SymExe10"           ; +048 Before loading: SymbOS executable identification string
            dw 0                    ; +056 Before loading: Length of additional reserved code area memory
            dw 0                    ; +058 Before loading: Length of additional reserved data area memory
            dw 0                    ; +060 Before loading: Length of additional reserved transfer area memory
            ds 26,0                 ; +062 Before loading: Reserved space for future use. Must be 0
App_ID:                             ; +088 After loading: Application ID
            db 0                    ; +088 Before loading: Required OS Version minor (after dot)
Main_Process_ID:                    ; +089 After loading: Main process ID (Alternative address for App_Process_ID)
            db 2                    ; +089 Before loading: Required OS version major (before dot)
App_Icon_Small:                     ; +090 Application icon (small version), 8x8 pixel
            Graphic_Simple 8,8      ;      Macro for 4-color graphics header
            DS .ByteCount           ;      Actual picture data (16-bytes)
App_Icon_Large:                     ; +109 Application icon (Large version), 24x24 pixel
            Graphic_Simple 24,24    ;      Macro for 4-color graphics header
            DS .ByteCount           ;      Actual picture data (144-bytes)
                                    ; +256 Application code
;------------------------------------------------------------------------------
;### APPLICATION DATA #########################################################
;------------------------------------------------------------------------------

            ; This address has low byte 0, so this is good place to put
            ; ie. tables that need to be alligned to 256 byte boundary.

;------------------------------------------------------------------------------
;### START OF PROGRAM #########################################################
;------------------------------------------------------------------------------


App_Start:
            ; The application start address
            ; This address is defined in stack. -> See Transfer area
            ;
            ; Please note: Shadow registers are reserved for OS use.
            ;-------------------------------------------------------

            call Main_Routine
            jp SySystem_EXIT

Main_Routine:

            ; This is the "Hello You" example for SymbOS

            ld de,Question_Form        ; We have custom window to ask the name (on Transfer area)
            ld a,(App_Bank_Number)     ; It is in same RAM bank as our program
            call SyDesktop_WINOPN      ; Open the window
            ret c                      ; Maximum number of Windows reached -> Quit
            ld (WindowID),A            ; Save Window ID for later use
.loop
            call SyDesktop_WaitMessage ; Wait for Desktop manager message
            CP MSR_DSK_WCLICK          ; Was it "click"-event ?
            jr nz,.loop                ; No? Not interested... Maybe next time.
            ld a,(iy+2)                ; Yes, I want to know more
            cp DSK_ACT_CLOSE           ; Was it a close-button click?
            jr z,.Close_Window         ; Yes? Close the damn window and quit
            cp DSK_ACT_CONTENT         ; Was it click to the Window content?
            jr nz,.loop                ; No? Must have been key or something...
            ld a,(iy+8)                ; Give me the Window control ID value
            and a                      ; Maybe zero?
            jr z,.loop                 ; Tough luck... I've given only my Ok-button a non zero value.
                                       ; So we had an Ok-button click...
            call .Close_Window         ; We can close the window now.
                                       ; Definitely enough window design for one example application...
            ld a,(App_Bank_Number)     ; Next time we use Info window (See: Dialogue_Infobox_Command)
            ld b,%00010001             ; Yes, one 1-button infobox, please
            ld hl,Dialogue_Info        ; Here is what it should say. (on Transfer area)
            ld de,0                    ; (DE = Parent window data record for modal info boxes)
            jp SySystem_SYSWRN         ; Just display it and quit.

.Close_Window:
            ld a,(WindowID)
            call SyDesktop_WINCLS
            ret

WindowID:   db 0


;------------------------------------------------------------------------------
;### LIBRARIES ################################################################
;------------------------------------------------------------------------------

             ; Add custom libraries here:

             ; System libraries:
             ; All individual routines in these system libraries are included
             ; to project ONLY if they are used ABOWE, so normally there
             ; should be no reason to comment these lines out.

             include "LIB/SymbOS_Lib-NetworkDaemon.asm"
             include "LIB/SymbOS_Lib-SymShell.asm"
             include "LIB/SymbOS_Lib-FileManager.asm"
             include "LIB/SymbOS_Lib-DesktopManager.asm"
             include "LIB/SymbOS_Lib-SystemManager.asm"
             include "LIB/SymbOS_Lib-Kernel.asm"

Code_Area_End:
Code_Area_Size: equ Code_Area_End - Code_Area_Start
;==============================================================================
;### DATA AREA ################################################################
;==============================================================================
Data_Area_Start: ; (Will be loaded to 256-byte boundary)

                 ; Place all data here that needs to be plotted to desktop
                 ; Even if not needed, every area must have at least 1 byte of data.


                 ; Optional 16-color application icon (24px x 24px)
App_16C_Icon:
                 Graphic_Extended 24,24  ; Macro for 16-color graphics header
                 DS .ByteCount           ; Graphics in MSX SCREEN 5/7 format (288 bytes)

;-----------------------------------------------
; String data for our "Hello You" question form:

Title_Text       db "Question:",0
Label_Text:      db "What is your name?",0
Ok_Text          db "Ok"
Zero             db 0
;-----------------------------------------------
; String used on the Dialogue Infobox:

Hello_Text       ds 10,32                ; Some spaces are used to adjust the location of string
                 db "Hello, "
Name_Buffer      ds 14,0


Data_Area_End:
Data_Area_Size   equ Data_Area_End - Data_Area_Start
;==============================================================================
;### TRANSFER AREA ############################################################
;==============================================================================
Transfer_Area_Start:  ; (Will be loaded to 256-byte boundary)

            ; Data area for the stack, the message buffer and all window data records,
            ; control data records and their control variables (radio button status,
            ; selected tab etc.)

            ;--- Main process stack definition  ---

                 ds 128            ; Your app default stack space, increase if needed
App_Stack:       ds 6*2            ; Fixed space for register storage
                 dw App_Start      ; The stack content defines your applications start address
App_Process_ID:  db 0              ; process ID (Filled by kernel, alternative address for Main_Proces_ID)
App_Stack_Offset: equ App_Stack - Transfer_Area_Start

            ;--- End of main process stack ---

            ; You can add more stacks here if needed for other processes

            ;--- Common Message buffer used by the libraries ---
Message_Buffer:  ds 14

;--- START OF FORM DATA ---

Question_Form:      ; WINDOW DATA RECORD
                 dw #1481,7,079,035,116,070,0,0,116,070,116,070,116,070
                 dw 0,Title_Text,0,0,.Control_Group,0,0
                 ds 136+14

.Control_Group:     ; CONTROL GROUP DATA RECORD
                 db .Control_Records_Count,0
                 dw .Control_Records,0,0,4,0,0,3

.Control_Records:   ; CONTROL DATA RECORDS
    dw 00,          0 ,2,             0,0,1000,1000,0 ; Background fill (See: paint_area)
    dw 00,255*256+  1,.Label_Record,  08, 10,100, 8,0 ; Label           (See: paint_text)
    dw 00,255*256+ 32,.Namebox_Record,23, 28, 70,12,0 ; Name box        (See: text_input_line)
    dw 01,255*256+ 16, Ok_Text,       33, 48, 50,12,0 ; "Ok"-Button     (See: button_simple)
.Control_Records_Count equ ($-.Control_Records)/16

                    ; ITEM DATA RECORDS
.Label_Record:   dw Label_Text, 2+4+512
.Namebox_Record: dw Name_Buffer,0,0,0,0,13,0


;----- END OF FORM -----

Dialogue_Info: ; (See: Dialogue_Infobox_Command)
                 dw Zero,6          ; Line1, color
                 dw Hello_Text,6    ; Line2, color
                 dw Zero,6          ; Line3, color


            ; Other possible data that needs to be on Transfer area

Transfer_Area_End:
Transfer_Area_Size equ Transfer_Area_End - Transfer_Area_Start
;==============================================================================
;### RELOCATION TABLE #########################################################
;==============================================================================

            ; Relocation table will be placed here
            ; by SjAsmPlus and handled by OS, do not modify.
            ;
            ; Please note: Don't break this system by
            ; using coding style like:
            ;   LD H,EXAMPLE / 256
            ;   LD L,A
            ; Write instead:
            ;   LD HL,EXAMPLE
            ;   LD L,A

            relocate_table
            relocate_end

The_End:    ; This random label is placed here just to catch errors if assembly
            ; can't be done on 3 passes. (Reorder your code properly.)