;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@                S Y M B O S   G R A P H I C   L I B R A R Y                 @
;@        - PLATFORM INDEPENDENT GRAPHIC FUNCTIONS FOR PICTURE BOXES -        @
;@                                    CORE                                    @
;@                                                                            @
;@               (c) 2014 by Prodatron / SymbiosiS (Jrn Mika)                @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


;### GFXINI -> Initialises graphic library
;### GFXENC -> Adjusts the encoding of the graphic (4col CPC/PCW->MSX, 16col MSX->CPC/PCW, unchanged if already ok)
;### GFXSPR -> Pastes graphic into another one

;### GFXPXA -> Pastes graphic into another one (pixel-aligned, MSX encoded 4 colours)
;### GFXPXB -> Pastes graphic into another one (pixel-aligned, MSX encoded 16 colours)
;### GFXPXC -> Pastes graphic into another one (pixel-aligned, CPC encoded 4 colours)
;### GFXBYT -> Pastes graphic into another one (byte-aligned)
;### GFXPAR -> Calculates all parameters for pasting
;### GFXCLP -> Calculates clipped values for pasting
;### GFXSUB -> Calculates subvalues for clipping
;### GFXMUL -> Multiplies two values (16bit)
;### GFXLIN -> Calculates line size/masks
;### GFXMSK -> Calculates pixel mask


;constants
gfxdatxbt   equ 0       ;width of the complete graphic in bytes
gfxdatxpx   equ 1       ;width of the graphic area, which should be displayed, in pixel
gfxdatypx   equ 2       ;height of the graphic area, which should be displayed, in pixel
gfxdatadr   equ 3       ;address of the graphic data, including the area offset
gfxdatenc   equ 5       ;address of the encoding information byte (this single byte has ALWAYS to be placed directly in front of the complete graphic data)
                        ;[bit0-1] = colour encoding (0 = CPC, 1 = MSX), [bit2-3] = colour depth (0 = 4 colours, 1 = 16 colours)
gfxdatlen   equ 7       ;size of the complete graphic


;global variables
gfx_com     db 0        ;computer type (0=CPC 464, 1=CPC 664, 2=CPC 6128, 3=CPC 464+, 4=CPC 6128+, 7=Enterprise, 8=MSX2, 9=MSX2+, 10=MSX turboR, 12=PCW8xxx, 13=PCW9xxx)
gfx_bnk     db 0        ;bank number (0-15)
gfx_enc     db 0        ;actual encoding (+1=MSX, +4=16c, +16=half ofs)


;### GFXINI -> Initialises graphic library
;### Input      A=current bank number
;### Destroyed  AF,BC,DE,HL,IX,IY
gfxinic dw gfxbytm0-1,gfxmska-1,6,#00   ;cpc
gfxinim dw gfxbytm1-1,gfxmskb-1,3,#87   ;msx
gfxinia dw 2, gfxbytb+1, 2,gfxmsk2+1, 1,gfxmsk+1, 1,gfxmsk1, 0     ;addresses

gfxini  push af                 ;** get computer type
        ld e,7
        rst #20:dw jmp_sysinf       ;DE = core area address (including the header; ram bank 0)
        ld hl,245+6
        add hl,de
        ld de,gfx_com
        pop af
        ld (gfx_bnk),a
        add a:add a:add a:add a
        ld bc,1
        rst #20:dw jmp_bnkcop
        ld a,(gfx_com)          ;** patch routines
        ld hl,gfxinic
        cp 8
        jr c,gfxini1
        cp 12
        jr nc,gfxini1
        ld hl,gfxinim
gfxini1 ld ix,gfxinia
        ld bc,4
gfxini2 ld a,(ix+0)
        cp 1
        ret c
        ld e,(ix+2)
        ld d,(ix+3)
        ld a,(hl)
        inc hl
        ld (de),a
        jr z,gfxini3
        inc de
        ld a,(hl)
        ld (de),a
gfxini3 inc hl
        add ix,bc
        jr gfxini2

;### GFXENC -> Relocates graphic and adjusts its encoding (4col CPC/PCW->MSX, 16col MSX->CPC/PCW, unchanged if already ok)
;### Input      IX=graphic header
;### Output     CF=0 no encoding necessary, CF=1 encoding has been done
;### Destroyed  AF,BC,DE,HL,IY
gfxenct db %000000,%010000,%000001,%010001,%100000,%110000,%100001,%110001,%000010,%010010,%000011,%010011,%100010,%110010,%100011,%110011

gfxenc  push ix             ;relocate
        pop hl
        ld de,10
        add hl,de
        ld (ix+3),l
        ld (ix+4),h
        dec hl
        ld (ix+5),l
        ld (ix+6),h

        ld a,(gfx_com)      ;check, which encoding and if necessary
        ld b,0
        and #f
        cp 8
        jr c,gfxenc1
        cp 12
        jr nc,gfxenc1
        ld b,5
gfxenc1 ld l,(ix+gfxdatenc+0)
        ld h,(ix+gfxdatenc+1)
        ld a,b
        cp (hl)
        ret z
        or a
        jr nz,gfxenc5
        bit 4,(hl)              ;*** 16col MSX->CPC/PCW
        ret nz
        res 0,(hl)
        res 2,(hl)
        set 4,(hl)
        inc hl
        ld e,l:ld d,h
        ld iy,gfxenct
        ld c,(ix+gfxdatlen+0)
        ld b,(ix+gfxdatlen+1)
        srl b
        rr c
gfxenc2 push bc
        call gfxenc3
        add a:add a
        ld b,a
        call gfxenc3
        or b
        ld (de),a
        inc de
        pop bc
        dec bc
        ld a,c
        or b
        jr nz,gfxenc2
        scf
        ret
gfxenc3 ld a,(hl)
        and #30
        rrca:rrca
        ld c,a
        ld a,(hl)
        inc hl
        and #03
        or c
        ld (gfxenc4+2),a
gfxenc4 ld a,(iy+0)
        ret
gfxenc5 set 0,(hl)              ;*** 4col CPC/PCW->MSX
        ld e,(ix+gfxdatlen+0)
        ld d,(ix+gfxdatlen+1)
gfxenc6 inc hl
        ld c,0
        ld b,4
gfxenc7 ld a,(hl):rla:rla:rla:rla
        rr c
        ld a,(hl):rra
        rr c
        rrc (hl)
        djnz gfxenc7
        ld (hl),c
        dec de
        ld a,e
        or d
        jr nz,gfxenc6
        scf
        ret

;### GFXSPR -> Pastes graphic into another one
;### Input      IX=source graphic header, IY=destination graphic header, DE=xpos signed, HL=ypos signed, BC=destination graphic ylen, A=transparency colour (-1=no transparency)
;###            Source and destination graphics must be of same encoding type
;### Destroyed  ?
gfxspr  inc a
        ;jr nz,...............transparency
        call gfxpar
        ret c
        ld (gfx_enc),a
        ld a,c
        or b
        jp z,gfxbyt
        ld a,(gfx_enc)
        and #f
        cp 1
        jp c,gfxpxc     ;0 -> cpc 4col
        jp z,gfxpxa     ;1 -> msx 4col
        jp gfxpxb       ;5 -> msx 16col

;### GFXPXA -> Pastes graphic into another one (pixel-aligned, MSX encoded 4 colours)
;### Input      HL=source address, DE=destination address, IXL=xlen pixel, IXH=ylen pixel, IYL=total source width in bytes, IYH=total destination width in bytes, (gfx_enc)=encoding
;###            C=xbeg source (0-3), B=xbeg destination (0-3)
;### Destroyed  AF,BC,DE,HL,IX
gfxpxa  push de
        push hl
        push bc
        call gfxlin             ;B=startpixel, IXL=length -> E/D=left/right mask, C=middle length in bytes
        ld a,e                  ;beg-maske
        ld (gfxpxa3+1),a
        cpl
        ld (gfxpxa1+1),a
        ld a,d                  ;end-maske
        ld (gfxpxa9+1),a
        cpl
        ld (gfxpxa7+1),a
        ld a,c                  ;len-mitte
        ld (gfxpxa4+1),a
        pop bc
        pop hl
        db #fd:ld a,l
        ld (gfxpxab+1),a        ;sprxlen
        db #fd:ld a,h
        ld (gfxpxaa+1),a        ;scrxlen
        ld a,c
        sub b                   ;a=sprbeg-scrbeg
        jp p,gfxpxac
        dec hl
        add 4
gfxpxac ld c,a                  ;c=sprbeg-scrbeg
        ld b,a
        or a
        ld a,#ff
        jr z,gfxpxaf
gfxpxae rlca
        rlca
        and #fc
        djnz gfxpxae
gfxpxaf ld (gfxpxax+1),a        ;maske byte 1
        ld (gfxpxau+1),a
        ld (gfxpxar+1),a
        cpl
        ld (gfxpxaz+1),a        ;maske byte 2
        ld (gfxpxaw+1),a
        ld (gfxpxat+1),a
        ld a,c                  ;a=sprbeg-scrbeg
        dec a
        and 3
        add a
        ld (gfxpxay+1),a
        ld (gfxpxav+1),a
        ld (gfxpxas+1),a
        ld a,c
        cpl
        add 3+1
        add a
        ld (gfxpxa2+1),a
        ld (gfxpxa6+1),a
        ld (gfxpxa8+1),a
        cp 3
        ld bc,#0618
        jr nz,gfxpxaq
        ld bc,0
gfxpxaq ld (gfxpxap),bc
        pop de

gfxpxa0 push hl         ;4
        push de         ;4

gfxpxa1 ld a,0          ;2      Anfang
        ld c,a          ;1
        inc a           ;1
        jr z,gfxpxa4
        ld a,(de)
        and c
        ld c,a

        ld a,(hl)
        inc hl
gfxpxa2 jr gfxpxa2
        rlca:rlca
        rlca:rlca
        rlca:rlca
gfxpxax and 0
        ld b,a
        ld a,(hl)
gfxpxay jr gfxpxay
        rrca:rrca
        rrca:rrca
        rrca:rrca
gfxpxaz and 0
        or b
gfxpxa3 and 0
        or c
        ld (de),a
        inc de

gfxpxa4 ld c,0          ;2      Mitte
        inc c
        dec c
        jr z,gfxpxa7

gfxpxap jr gfxpxa5
        ld b,0
        ldir
        jr gfxpxa7

gfxpxa5 db #dd:ld l,c
        ld a,(hl)       ;2
gfxpxa6 jr gfxpxa6      ;3
        rlca:rlca       ;0/2
        rlca:rlca       ;0/2
        rlca:rlca       ;0/2

gfxpxau and 0           ;2
        ld b,a          ;1
        inc hl          ;2
        ld a,(hl)       ;2
gfxpxav jr gfxpxav      ;3
        rrca:rrca       ;0/2
        rrca:rrca       ;0/2
        rrca:rrca       ;0/2
        ld c,a
gfxpxaw and 0           ;2
        or b            ;1
        ld (de),a       ;2
        inc de          ;2
        ld a,c
        db #dd:dec l    ;1
        jr nz,gfxpxau   ;3

gfxpxa7 ld a,0          ;2      Ende
        ld c,a          ;1
        inc a           ;1
        jr z,gfxpxad    ;3
        ld a,(de)
        and c
        ld c,a
        ld a,(hl)
        inc hl
gfxpxa8 jr gfxpxa8
        rlca:rlca
        rlca:rlca
        rlca:rlca
gfxpxar and 0
        ld b,a
        ld a,(hl)
gfxpxas jr gfxpxas
        rrca:rrca
        rrca:rrca
        rrca:rrca
gfxpxat and 0
        or b
gfxpxa9 and 0
        or c
        ld (de),a

gfxpxad pop hl          ;3      naechste Zeile
gfxpxaa ld bc,0         ;3
        add hl,bc       ;3
        ex de,hl        ;1
        pop hl          ;3
gfxpxab ld bc,0         ;3
        add hl,bc       ;3
        db #dd:dec h    ;2
        jp nz,gfxpxa0   ;3
        ret

;### GFXPXB -> Pastes graphic into another one (pixel-aligned, MSX encoded 16 colours)
;### Input      HL=source address, DE=destination address, IXL=xlen pixel, IXH=ylen pixel, IYL=total source width in bytes, IYH=total destination width in bytes, (gfx_enc)=encoding
;###            C=xbeg source (0-1), B=xbeg destination (0-1)
;### Destroyed  ?
gfxpxb  ld a,b
        ld (gfxpxb1+1),a        ;flag, if beg-pixel
        neg
        db #dd:add l
        ld b,a
        srl b                   ;b=length in byte
        and 1
        ld (gfxpxb4+1),a        ;flag, if end-pixel
        ld a,b
        ld (gfxpxb2+1),a        ;middle-length in byte
        db #fd:ld a,l
        ld (gfxpxb7+1),a        ;sprxlen
        db #fd:ld a,h
        ld (gfxpxb6+1),a        ;scrxlen

gfxpxb1 ld a,0                  ;beg-pixel
        push hl
        push de
        or a
        jr z,gfxpxb2
        ld a,(hl)
        rrca:rrca:rrca:rrca
        and #0f
        ld c,a
        ld a,(de)
        and #f0
        or c
        ld (de),a
        inc de

gfxpxb2 ld a,0                  ;middle
        or a
        jr z,gfxpxb4
        db #dd:ld l,a
        ld a,(hl)
        rrca:rrca:rrca:rrca
gfxpxb3 and #f0
        ld c,a
        inc hl
        ld a,(hl)
        rrca:rrca:rrca:rrca
        ld b,a
        and #0f
        or c
        ld (de),a
        inc de
        ld a,b
        db #dd:dec l
        jr nz,gfxpxb3

gfxpxb4 ld c,0                  ;end-pixel
        dec c
        jr nz,gfxpxb5
        and #f0
        ld c,a
        ld a,(de)
        and #0f
        or c
        ld (de),a

gfxpxb5 pop hl                  ;next line
gfxpxb6 ld bc,0
        add hl,bc
        ex de,hl
        pop hl
gfxpxb7 ld bc,0
        add hl,bc
        db #dd:dec h
        jp nz,gfxpxb1
        ret

;### GFXPXC -> Pastes graphic into another one (pixel-aligned, CPC encoded 4 colours)
;### Input      HL=source address, DE=destination address, IXL=xlen pixel, IXH=ylen pixel, IYL=total source width in bytes, IYH=total destination width in bytes, (gfx_enc)=encoding
;###            C=xbeg source (0-3), B=xbeg destination (0-3)
;### Destroyed  AF,BC,DE,HL,IXH
gfxpxc  push de
        push hl
        push bc
        call gfxlin             ;B=startpixel, IXL=length -> E/D=left/right mask, C=middle length in bytes
        ld a,e                  ;beg-maske
        ld (gfxpxc3+1),a
        cpl
        ld (gfxpxc1+1),a
        ld a,d                  ;end-maske
        ld (gfxpxc9+1),a
        cpl
        ld (gfxpxc7+1),a
        ld a,c                  ;len-mitte
        ld (gfxpxc4+1),a
        pop bc
        pop hl
        db #fd:ld a,l
        ld (gfxpxcb+1),a        ;sprxlen
        db #fd:ld a,h
        ld (gfxpxca+1),a        ;scrxlen
        ld a,c
        sub b                   ;a=sprbeg-scrbeg
        jp p,gfxpxcc
        dec hl
        add 4
gfxpxcc ld c,a                  ;c=sprbeg-scrbeg
        ld b,a
        or a
        ld a,#ff
        jr z,gfxpxcf
gfxpxce rlca
        and #ee
        djnz gfxpxce
gfxpxcf ld (gfxpxcx+1),a        ;maske byte 1
        ld (gfxpxcu+1),a
        ld (gfxpxcr+1),a
        cpl
        ld (gfxpxcz+1),a        ;maske byte 2
        ld (gfxpxcw+1),a
        ld (gfxpxct+1),a
        ld a,c                  ;a=sprbeg-scrbeg
        dec a
        and 3
        ld (gfxpxcy+1),a
        ld (gfxpxcv+1),a
        ld (gfxpxcs+1),a
        ld a,c
        cpl
        add 3+1
        ld (gfxpxc2+1),a
        ld (gfxpxc6+1),a
        ld (gfxpxc8+1),a
        cp 3
        ld bc,#0618
        jr nz,gfxpxcq
        ld bc,0
gfxpxcq ld (gfxpxcp),bc
        pop de

gfxpxc0 push hl         ;4
        push de         ;4

gfxpxc1 ld a,0          ;2      Anfang
        ld c,a          ;1
        inc a           ;1
        jr z,gfxpxc4
        ld a,(de)
        and c
        ld c,a

        ld a,(hl)
        inc hl
gfxpxc2 jr gfxpxc2
        rlca
        rlca
        rlca
gfxpxcx and 0
        ld b,a
        ld a,(hl)
gfxpxcy jr gfxpxcy
        rrca
        rrca
        rrca
gfxpxcz and 0
        or b
gfxpxc3 and 0
        or c
        ld (de),a
        inc de

gfxpxc4 ld c,0          ;2      Mitte
        inc c
        dec c
        jr z,gfxpxc7

gfxpxcp jr gfxpxc5
        ld b,0
        ldir
        jr gfxpxc7

gfxpxc5 ld a,(hl)       ;2
        inc hl          ;2
gfxpxc6 jr gfxpxc6      ;3
        rlca            ;0/1
        rlca            ;0/1
        rlca            ;0/1
gfxpxcu and 0           ;2
        ld b,a          ;1
        ld a,(hl)       ;2
gfxpxcv jr gfxpxcv      ;3
        rrca            ;0/1
        rrca            ;0/1
        rrca            ;0/1
gfxpxcw and 0           ;2
        or b            ;1
        ld (de),a       ;2
        inc de          ;2
        dec c           ;1
        jr nz,gfxpxc5   ;3 30

gfxpxc7 ld a,0          ;2      Ende
        ld c,a          ;1
        inc a           ;1
        jr z,gfxpxcd    ;3
        ld a,(de)
        and c
        ld c,a
        ld a,(hl)
        inc hl
gfxpxc8 jr gfxpxc2
        rlca
        rlca
        rlca
gfxpxcr and 0
        ld b,a
        ld a,(hl)
gfxpxcs jr gfxpxcy
        rrca
        rrca
        rrca
gfxpxct and 0
        or b
gfxpxc9 and 0
        or c
        ld (de),a

gfxpxcd pop hl          ;3      naechste Zeile
gfxpxca ld bc,0         ;3
        add hl,bc       ;3
        ex de,hl        ;1
        pop hl          ;3
gfxpxcb ld bc,0         ;3
        add hl,bc       ;3
        db #dd:dec h    ;2
        jr nz,gfxpxc0   ;3
        ret

;### GFXBYT -> Pastes graphic into another one (byte-aligned)
;### Input      HL=source address, DE=destination address, IXL=xlen pixel, IXH=ylen pixel, IYL=total source width in bytes, IYH=total destination width in bytes, (gfx_enc)=encoding
;### Destroyed  AF,BC,DE,HL,IXH,IY
gfxbytm0    db %01110111,%00110011,%00010001    ;cpc  4 col
gfxbytm1    db %00111111,%00001111,%00000011    ;msx  4 col
gfxbytm2    db %00001111                        ;msx 16 col

gfxbyt  push hl
        ld a,(gfx_enc)
        bit 2,a
        db #dd:ld a,l
        ld c,a
        jr nz,gfxbyt0
gfxbytb ld hl,gfxbytm0-1        ;cpc -> gfxbytm0, msx -> gfxbytm1
        and 3
        srl c
        jr gfxbyt1
gfxbyt0 ld hl,gfxbytm2-1
        and 1
gfxbyt1 srl c           ;C=width in bytes
        ld b,a          ;B=remaining pixels
        ld (gfxbyt5+2),hl
        pop hl
        push bc
        push de
        push hl
        ld a,c          ;HL=source, DE=destination, A=xlen in bytes, IXH=ylen, IYL=total source width, IYH=total destination width
        ld (gfxbyt2+1),a
        neg
        ld c,a
        db #fd:ld a,l
        add c
        ld (gfxbyt3+1),a
        ld (gfxbyt9+1),a
        db #fd:ld a,h
        add c
        ld (gfxbyt4+1),a
        ld (gfxbyta+1),a
        db #dd:ld a,h       ;** byte loop
        ld b,0
gfxbyt2 ld c,0
        ldir
gfxbyt3 ld c,0
        add hl,bc
        ex de,hl
gfxbyt4 ld c,0
        add hl,bc
        ex de,hl
        dec a
        jr nz,gfxbyt2
        pop hl
        pop de
        pop bc
        ld a,b
        or a
        ret z
        ld b,0
        add hl,bc
        ex de,hl
        add hl,bc
        ex de,hl
        ld (gfxbyt6+2),a
gfxbyt5 ld iy,gfxbytm0-1
gfxbyt6 ld a,(iy+0)
        ld (gfxbyt8+1),a
gfxbyt7 ld a,(de)           ;** pixel-end loop
gfxbyt8 and 0
        or (hl)
        ld (de),a
gfxbyt9 ld c,0
        add hl,bc
        ex de,hl
gfxbyta ld c,0
        add hl,bc
        ex de,hl
        db #dd:dec h
        jr nz,gfxbyt7
        ret

;### GFXPAR -> Calculates all parameters for pasting
;### Input      IX=source graphic header, IY=destination graphic header, DE=xpos signed, HL=ypos signed, BC=destination graphic ylen
;### Output     CF=1 -> not visible, CF=0 -> HL=source address, DE=destination address, C=xbeg source ([16]0-1/[4]0-3), B=xbeg destination ([16]0-1/[4]0-3), IXL=xlen pixel, IXH=ylen pixel,
;###                                         IYL=total source width in bytes, IYH=total destination width in bytes, A=encoding
;### Destroyed  F,IY
gfxpar  ld (gfxpar5+2),ix
        call gfxclp     ;DE=destination xpos, HL=destination ypos, C=xlen, B=xbeg, IXL=ylen, IXH=ybeg, A=encoding
        ret c
        ld (gfxpar3+1),a
        bit 2,a
        ld a,e
        jr nz,gfxpar1
        and 3
        srl d:rr e
        srl d:rr e
        ld d,a
        ld a,b
        and 3
        srl b
        jr gfxpar2
gfxpar1 and 1
        srl d:rr e
        ld d,a
        ld a,b
        and 1
gfxpar2 srl b           ;HL=ypos, E=xofs destination, B=xofs source, IXH=ybeg source,        C=xlen pixel, IXL=ylen pixel,      D=xbeg destination (0-3), A=xbeg source (0-3)
        push hl
        ld l,a
        ld h,d
        ex (sp),hl      ;       (SP)=xbeg source/xbeg destination
        ld a,b
        db #dd:ld b,l
        push bc         ;       (SP)=xlen/ylen pixel
        ld c,e          ;C=xofs destination
        ld b,a          ;B=xofs source
        ex de,hl        ;DE=ypos
gfxpar3 ld a,0
        bit 4,a
        push af
        ld a,(iy+gfxdatxbt)
        jr z,gfxpar4
        srl a
gfxpar4 ld (gfxpar8+3),a
        call gfxmul     ;HL=yofs destination
        ld e,c
        ld d,0
        add hl,de       ;HL=ofs destination
        ld e,(iy+gfxdatenc+0)
        ld d,(iy+gfxdatenc+1)
        inc de
        add hl,de
        pop af
        push hl         ;       (SP)=destination address
gfxpar5 ld iy,0
        push af
        ld a,(iy+gfxdatxbt)
        jr z,gfxpar6
        srl a
gfxpar6 ld (gfxpar8+2),a
        db #dd:ld e,h
        ld d,0
        call gfxmul     ;HL=yofs source
        ld c,b
        ld b,0
        add hl,bc
        ex de,hl        ;DE=ofs source
        ld l,(iy+gfxdatadr+0)
        ld h,(iy+gfxdatadr+1)
        pop af          ;A=encoding
        jr z,gfxpar7
        ld c,(iy+gfxdatenc+0)
        ld b,(iy+gfxdatenc+1)
        inc bc
        or a
        sbc hl,bc
        srl h:rr l
        add hl,bc
gfxpar7 add hl,de       ;HL=source address
        pop de          ;DE=destination address
        pop ix          ;IXL=xlen, IXH=ylen
        pop bc          ;C=xbeg source (0-3), B=xbeg destination (0-3)
gfxpar8 ld iy,0         ;IYL=total source width in bytes, IYH=total destination width in bytes
        ret

;### GFXCLP -> Calculates clipped values for pasting
;### Input      IX=source graphic header, IY=destination graphic header, DE=xpos signed, HL=ypos signed, BC=destination graphic ylen
;### Output     CF=1 -> not visible, CF=0 -> DE=destination xpos, HL=destination ypos, C=xlen, B=xbeg, IXL=ylen, IXH=ybeg, A=encoding
;### Destroyed  F
gfxclp  push de
        ex de,hl            ;calculate y clipping
        ld l,c
        ld h,b
        ld c,(ix+gfxdatypx)
        call gfxsub         ;DE=ypos, C=ylen, B=ybeg
        pop hl
        ret c
        push de
        push bc
        ex de,hl            ;calculate x clipping
        ld l,(iy+gfxdatenc+0)
        ld h,(iy+gfxdatenc+1)
        ld a,(hl)           ;A=encoding
        bit 2,a
        ld l,(iy+gfxdatxbt+0)
        ld h,(iy+gfxdatxbt+1)
        add hl,hl
        jr nz,gfxclp1
        add hl,hl
gfxclp1 ld c,(ix+gfxdatxpx)
        push af
        call gfxsub         ;DE=xpos, C=xlen, B=xbeg
        pop hl
        ld a,h
        pop ix              ;IXL=ylen, IXH=ybeg
        pop hl              ;HL=ypos
        ret

;### GFXSUB -> Calculates subvalues for clipping
;### Input      DE=pos signed, C=source length, HL=destination length
;### Output     CF=1 -> not visible, CF=0 -> DE=pos, C=length, B=begin
;### Destroyed  AF,HL
gfxsub  ld b,0
        bit 7,d         ;test, if pos<0
        jr z,gfxsub1
        inc d           ;yes -> adjust for left/upper clipping
        scf
        ret nz
        ld a,c
        add e
        scf
        ret z
        ccf
        ret c
        ld c,a
        ld a,e
        neg
        ld b,a
        ld de,0
gfxsub1 or a            ;test, if pos+len > destination length
        sbc hl,de
        ld a,b
        ld b,0
        or a
        sbc hl,bc
        ld b,a
        bit 7,h
        ret z
        inc h           ;yes -> adjust for right/lower clipping
        scf
        ret nz
        ld a,c
        add l
        scf
        ret z
        ccf
        ret c
        ld c,a
        ret

;### GFXMUL -> Multiplies two values (16bit)
;### Input      A=value1, DE=value2
;### Output     HL=value1*value2 (16bit)
;### Destroyed  AF,DE
gfxmul  ld hl,0         ;3
gfxmul1 or a            ;1
        ret z           ;2 (4)
        rra             ;1
        jr nc,gfxmul2   ;3/2
        add hl,de       ;0/3
gfxmul2 sla e           ;2
        rl d            ;2
        jr gfxmul1      ;3 -> 15 pro durchlauf

;### GFXLIN -> Calculates line size/masks
;### Input      B=startpixel, IXL=length
;### Output     E/D=left/right mask, C=middle length in bytes
;### Destroyed  AF,B,HL
gfxlin  db #dd:ld d,l           ;d=xlen
        ld a,b
        or a
        jr z,gfxlin2
        ld h,a                  ;h=pixbeg
        ld a,4
        sub h
        ld l,a                  ;l=pixanz-pixbeg
        ld a,d
        cp l
        jr nc,gfxlin1
        ld l,a
gfxlin1 ld a,d
        sub l
        ld d,a                  ;D=neue lnge
        call gfxmsk             ;A=Maske
gfxlin2 ld e,a                  ;** E=Maske Beginn
        ld a,3
        and d
        srl d
        srl d                   ;D=Anzahl Bytes Mitte
        or a
        jr z,gfxlin3
        ld h,0
        ld l,a
        call gfxmsk             ;A=Maske Ende
gfxlin3 ld c,d                  ;** C=Laenge Mitte
        ld d,a                  ;** D=Maske Ende
        ret

;### GFXMSK -> Calculates pixel mask
;### Input      H=startpixel, L=length
;### Output     A=mask
;### Destroyed  AF,BC,HL
gfxmska db #88,#cc,#ee
gfxmskb db #c0,#f0,#fc
gfxmsk  ld a,6      ;cpc 6, msx 3
        sub h
gfxmsk1 add a       ;cpc nop, msx add a
        ld (gfxmsk3+1),a
        ld h,0
gfxmsk2 ld bc,gfxmska-1
        add hl,bc
        ld a,(hl)
gfxmsk3 jr gfxmsk3
        rrca:rrca
        rrca:rrca
        rrca:rrca
        ret
