;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@                S Y M B O S   G R A P H I C   L I B R A R Y                 @
;@        - PLATFORM INDEPENDENT GRAPHIC FUNCTIONS FOR PICTURE BOXES -        @
;@                            WRAPPER ON CORE SIDE                            @
;@                                                                            @
;@               (c) 2014 by Prodatron / SymbiosiS (Jrn Mika)                @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


            jp gfxcmd
            jp gfxsid
            ds 64-6-1   ;stack
gfxcmdbuf   ds 16*12
            db 0
gfxsidadr   ds 128*2

;### GFXSID -> Plots single graphic via ID
;### Input      DE=xpos, HL[0-8]=ypos (0-511), H[1-7]=graphic ID (0-127)
;### Destroyed  AF,BC,DE,HL,IX,IY
gfxsid  ld a,h          ;1
        and #fe         ;2
        ld bc,gfxsidadr ;3
        ld c,a          ;1
        ld a,(bc)       ;2
        db #dd:ld l,a   ;2
        inc bc          ;2
        ld a,(bc)       ;2
        db #dd:ld h,a   ;2
        ld a,h          ;1
        and 1           ;2
        ld h,a          ;1
gfxsid1 ld bc,0         ;3
        add hl,bc       ;3
gfxsid2 ld iy,0         ;4
gfxsid3 ld a,-1         ;2
gfxsid4 ld bc,0         ;3
        call gfxspr     ;3 39
        jp jmp_bnkret

;### GFXCMD -> Executes graphic library commands
;### Input      (gfxcmdbuf)=command queue (12 * [cmd,15 byte parameters])
;###            cmd0 -> abort
;###            cmd1 -> ini (p01=ram bank)
;###            cmd2 -> enc (p01=graphic ID [-1=no ID], p02=graphic header)
;###            cmd3 -> par (p01=transparency, p02=canvas header, p04=canvas ylen, p06=ypos correction)
;###            cmd4 -> spr (p01=A, p02=BC, p04=DE, p06=HL, p08=IX, p10=IY)
;### Destroyed  AF,BC,DE,HL,IX,IY
gfxcmdt dw gfxcmdini,gfxcmdenc,gfxcmdpar,gfxcmdspr

gfxcmd  ld hl,gfxcmdbuf
gfxcmd1 ld a,(hl)
        or a
        jp z,jmp_bnkret
        ld e,l
        ld d,h
        ld bc,16
        add hl,bc
        push hl
        add a
        ld hl,gfxcmdt-2
        add l
        ld l,a
        adc h
        sub l
        ld h,a
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        jp (hl)
gfxcmd0 pop hl
        jr gfxcmd1

gfxcmdini               ;*** GFXINI
        inc de
        ld a,(de)
        call gfxini
        jr gfxcmd0

gfxcmdenc               ;*** GFXENC
        ex de,hl
        inc hl
        ld a,(hl)
        inc hl
        ld c,(hl)
        inc hl
        ld b,(hl)
        inc a
        jr z,gfxcmdenc1
        add a
        ld l,a
        ld h,0
        ld de,gfxsidadr-2
        add hl,de
        ld (hl),c
        inc hl
        ld (hl),b
gfxcmdenc1
        db #dd:ld l,c
        db #dd:ld h,b
        call gfxenc
        jr gfxcmd0

gfxcmdpar               ;*** prepares GFXSID
        ld (gfxcmdpar1+1),sp
        ex de,hl
        di
        ld sp,hl
        pop af
        ld (gfxsid3+1),a
        pop hl
        ld (gfxsid2+2),hl
        pop hl
        ld (gfxsid4+1),hl
        pop hl
        ld (gfxsid1+1),hl
gfxcmdpar1
        ld sp,0
        ei
        jr gfxcmd0

gfxcmdspr               ;*** GFXSPR
        ld (gfxcmdspr1+1),sp
        ex de,hl
        di
        ld sp,hl
        pop af
        pop bc
        pop de
        pop hl
        pop ix
        pop iy
gfxcmdspr1
        ld sp,0
        ei
        call gfxspr
        jr gfxcmd0
