/*
  Created 10/5/23    -jkl

  The example code is from Universal 8bit Graphics Library (https://github.com/olikraus/u8g2/)
  Read the licensing requirements for this library!

  Modified for the STMG431 WeActDuino.
  4/11/25 - Continuing experiments. Currently using Adafruit libraries for128x64 display. 
            Goal is to use U8g2 library and make Wire work for G431 by setting SDA and SCL pins.
  4/11/25 - U8g2 library works using I2C SDA and SCL as hoped! Width of display area seems about 2/3 
              of what it should be.
            ** Display had to be powered down and backup to reset positioning. Looks good now!
            ** Removed all the Adafruit stuff. Refer to G431_Dual_I2C for Adafruit examples.
*/

#include <Arduino.h>
#include <Wire.h>
#include <U8g2lib.h>

// Section: Defines
#define SDA3_PIN 31 //  WeActDuino I2C3 SDA pin 
#define SCL3_PIN 21 //  WeActDuino I2C3 SCL pin

// Section: Globals

// U8g2 Constructor List (Frame Buffer)
// The complete list is available here: https://github.com/olikraus/u8g2/wiki/u8g2setupcpp
// Please update the pin numbers according to your setup. Use U8X8_PIN_NONE if the reset pin is not connected
U8G2_SSD1306_72X40_ER_F_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE);   // EastRising 0.42" OLED

// Section: Setup

void setup() {
  Wire.setSDA(SDA3_PIN);
  Wire.setSCL(SCL3_PIN);
  u8g2.begin(); // Wire.begin() is called by this function
  delay(1000);
}

// Section: Main Loop

void loop() {
  static int flip = 0:
  if (flip < 1) {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(0,10,"Hello!");  // write something to the internal memory
  u8g2.drawStr(0,20,"World!!");  //write something to the internal memory
  u8g2.sendBuffer();          // transfer internal memory to the display*/
  delay(1000);  
  flip = 1;
  } else {
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB08_tr); // choose a suitable font
  u8g2.drawStr(0,10,"Bye Bye!");  // write something to the internal memory
  u8g2.drawStr(0,20,"Baby!!");  //write something to the internal memory
  u8g2.sendBuffer();          // transfer internal memory to the display*/
  delay(1000);  
  flip = 0;
  }
}
