/*
  Created 10/8/23    -jkl

  The example code is from Gavin Lyons and uses the HD44780_LCD_PCF8574 arduino library. Please be aware of
  the licensing requirements for this library!

 This is an example for our Monochrome OLEDs based on SSD1306 drivers
 Pick one up today in the adafruit shop!
 ------> http://www.adafruit.com/category/63_98
  
  Modified for the STM32 G431 WeActDuino.  --jkl
*/

#include <Arduino.h>
#include "Wire.h"
#include "HD44780_LCD_PCF8574.h"
#define SSD1306_NO_SPLASH 1 // Skips AdaFruit splash screen
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

// Section: Defines
#define DISPLAY_DELAY_INIT 50 // mS
#define SDA_PIN 35 //  WeActDuino I2C1 SDA pin 
#define SCL_PIN 28 //  WeActDuino I2C1 SCL pin
#define SDA3_PIN 31 //  WeActDuino I2C3 SDA pin 
#define SCL3_PIN 21 //  WeActDuino I2C3 SCL pin

#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 64 // OLED display height, in pixels

// Section: Globals
// Instantiate I2C controller objects
TwoWire Wire2(SDA_PIN, SCL_PIN);  // use I2C1 Port
TwoWire Wire3(SDA3_PIN, SCL3_PIN);  // uses I2C3 Port
// Instantiate display objects
HD44780LCD myLCD(2, 16, 0x27, &Wire2); // Two line, 16 character display at I2C address 0x27 using Wire2.
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire3);  // 128 x 64 display using Wire3

// Section: Setup

void setup() {
  pinMode(LED_BUILTIN, OUTPUT);
  
  delay(DISPLAY_DELAY_INIT);
  myLCD.PCF8574_LCDInit(myLCD.LCDCursorTypeOn);
  myLCD.PCF8574_LCDClearScreen();
  myLCD.PCF8574_LCDBackLightSet(true);
  myLCD.PCF8574_LCDGOTO(myLCD.LCDLineNumberOne, 0);
  
  digitalWrite(LED_BUILTIN,HIGH);  // turn on led to indicate starting
  if(!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) { // Address 0x3C for 128x64
//  Serial.println(F("SSD1306 allocation failed"));
    digitalWrite(LED_BUILTIN,LOW);  // turn off led on failure to find display
    for(;;); // Don't proceed, loop forever
  }
}

// Section: Main Loop

void loop() {
  char testString[] = "Hello World";
  char testString2[] = "Howdy Globe";
  static int flip = 0;
  if (flip < 1) {
  myLCD.PCF8574_LCDSendString(testString);
  
  display.clearDisplay();
  display.setTextColor(SSD1306_WHITE);
  display.setTextSize(2);
  display.setCursor(30,20);
  //display.println("Hello, ho!");
  display.println("Hello!");
  display.display();
  delay(1000); 
  flip = 1;
  } else { 
  myLCD.PCF8574_LCDSendString(testString2);
  
  display.clearDisplay();
  display.setTextColor(SSD1306_WHITE);
  display.setTextSize(2);
  display.setCursor(30,20);
  //display.println("Hello, ho!");
  display.println("Hi Ho!");
  display.display();
  delay(1000); 
  flip = 0;
  }
}
