/*

DESCRIPTION:    include file for i2cm.c.

KNOWN BUGS:     the macros don't incorporate timeout and could hang in 
                situations where the slave doesn't release the clock.

COPYRIGHT:      (c) 2022, Brian Cornell, all rights reserved.

DEPENDENCIES:   i2cp.h,
                _xtal_freq.h (to support the __delay_ macros).

VERSION:        1.0

MODIFICATION HISTORY:

    6 Mar 22, BWC, created file.

*/


#ifndef _XTAL_FREQ
#include "_xtal_freq.h"
#endif


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Configure MSSP
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define CFG_SSP1_CON_1      0x28            //Enabled, master
#define CFG_SSP1_STAT       0x00            //Slew enabled, SMBus disabled
#define CFG_SSP1_CON_2      0x00            //Idle for initialization
#define CFG_SSP1_CON_3      0x08            //SDA hold time=300nS
//#define CFG_SSP1_CON_3      0x00            //SDA hold time=100nS
#define CFG_SSP1_ADD        0x09            //400kHz


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * I2C BIT VALUES.
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define I2C_NACK            1               //Not acknowledged
#define I2C_ACK             0               //Acknowledged
#define I2C_SET             1               //Register set bit
#define I2C_CLR             0               //Register clear bit
#define I2C_WRITE           0xFE            //Bit 0 of address byte clear
#define I2C_READ            0x01            //Bit 0 of address byte set
#define I2C_RMODEB          0               //Background reads
#define I2C_RMODEF          1               //Foreground reads
#define I2C_RMODED          I2C_RMODEF      //Default read mode


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * TIMEOUT VALUES.
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define I2C_SPEED           400000          //I2C clock (SCL) speed
#define I2C_CLOCK           (1000000/I2C_SPEED) //Integer value of clock period
#define I2C_PSTO            (I2C_CLOCK*3)   //Fixed delay, uS, for start & stop
#define I2C_ACKTO           (I2C_CLOCK*3)   //Fixed delay, uS, for start & stop
#define I2C_TMR_RTO         3               //Read timeout *10mS for user
#define I2C_TMR_WTO         3               //Write timeout *10mS for i2c_m_Wd


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * MACROS:
 * + I2CSTOP issues the STOP bit.
 * + I2CSTART issues the START bit.
 * + I2C_M_TXB transmits a single byte.
 * + I2CSETWR sets the write bit for address a
 * + I2CSETRD sets the read bit for address a
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define I2CSTOP()   i2c_idle=TRUE; i2c_rsen=FALSE; PEN=I2C_SET; \
    __delay_us(I2C_PSTO); SSP1IF=I2C_CLR
#define I2CSTART()  i2c_idle=FALSE; SEN=I2C_SET; __delay_us(I2C_PSTO); \
    SSP1IF=I2C_CLR
#define I2CRSTRT()  RSEN=I2C_SET; __delay_us(I2C_PSTO); SSP1IF=I2C_CLR
#define I2C_M_WB(b) SSP1IF=I2C_CLR; i2c_tor=I2C_TMR_WTO; SSP1BUF=b; \
    while (!(SSP1IF) && i2c_tor); SSP1IF=I2C_CLR
#define I2CSETWR(a) (a & I2C_WRITE)
#define I2CSETRD(a) (a | I2C_READ)
#define I2CHKBUS()  if (!(i2c_idle)) {I2CSTOP();}


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Function declarations.  See source file for documentation.
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void i2c_m_cfg(void);
__bit i2c_m_Wd(unsigned char *);
__bit i2c_m_Rd(unsigned char *);
void i2c_m_isrRd(void);


//End of file