/*

DESCRIPTION:    PIC config register include file for spib.

COPYRIGHT:      (c) 2020-2021, Brian Cornell, all rights reserved.

DEPENDENCIES:

 TARGET MCU:    PIC16F1776

HW REVISION:    210218

HW RELEASE:     210218

VERSION:        1.0

MODIFICATION HISTORY:

    12 Apr 21, BWC, created config.


*/


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *                      Configuration Bit Settings
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
//CONFIG1
#pragma config FOSC = INTOSC    //Oscillator Selection Bits (INTOSC oscillator:
                                //I/O function on CLKIN pin)
#pragma config WDTE = SWDTEN    //Watchdog Timer Enable (WDT controlled by the 
                                //SWDTEN bit in the WDTCON register)
#pragma config PWRTE = ON       //Power-up Timer Enable (PWRT enabled)
#pragma config MCLRE = OFF      //MCLR Pin Function Select (MCLR/VPP pin 
                                //function is digital input)
#pragma config CP = OFF         //Flash Program Memory Code Protection (Program 
                                //memory code protection is disabled)
#pragma config BOREN = ON       //Brown-out Reset Enable (Brown-out Reset 
                                //enabled)
#pragma config CLKOUTEN = OFF   //Clock Out Enable (CLKOUT function is disabled.
                                //I/O or oscillator function on the CLKOUT pin)
#pragma config IESO = OFF       //Internal/External Switchover Mode (Internal/
                                //External Switchover Mode is disabled)
#pragma config FCMEN = OFF      //Fail-Safe Clock Monitor Enable (Fail-Safe 
                                //Clock Monitor is disabled)
//CONFIG2
#pragma config WRT = OFF        //Flash Memory Self-Write Protection (Write 
                                //protection off)
#pragma config PPS1WAY = OFF    //Peripheral Pin Select one-way control (The 
                                //PPSLOCK bit can be set and cleared repeatedly 
                                //by software)
#pragma config ZCD = OFF        //Zero-cross detect disable (Zero-cross detect 
                                //circuit is disabled at POR)
#pragma config PLLEN = OFF      //Phase Lock Loop enable (4x PLL is enabled when
                                //software sets the SPLLEN bit)
#pragma config STVREN = ON      //Stack Overflow/Underflow Reset Enable (Stack 
                                //Overflow or Underflow will cause a Reset)
#pragma config BORV = LO        //Brown-out Reset Voltage Selection (Brown-out 
                                //Reset Voltage (Vbor), low trip point selected.)
#pragma config LPBOR = ON       //Low-Power Brown Out Reset (Low-Power BOR is 
                                //enabled)
#pragma config LVP = OFF        //Low-Voltage Programming Enable (Low-voltage 
                                //programming disabled)


//End of file