/*

DESCRIPTION:  user EUSART peripheral configuration used with usart.h Contains
the constants that must be configured for the usart.c module to function.

SYNTAX:  n/a

KNOWN BUGS:  n/a.

COPYRIGHT:  (c) 2017-2022, Brian Cornell, all rights reserved.

DEPENDENCIES:  none

VERSION:  3.0, release

MODIFICATION HISTORY:

    18 Jan 23, BWC, appended 'v3' to file name for versioning with shared usart
    source.

    7 Mar 22, BWC, created file.

*/


//DO NOT EDIT!
#define _USARTC


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * CONDITIONAL COMPILE.
 * Uncomment to include.
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define _OPT_FCT_WRITE                  //Include usartWrite functions.

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Rx & Tx pins:  user must define the pins to use and also the pin configuration
 * bits.
 * 
 * Flow control:  define pins if flow control is to be used.  If not both pin
 * constants MUST be commented out.  Subsequent pin configuration bits are ignored.
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
//#define USART_PINCTS    ???             //Pin to use for CTS
//#define USART_PINRTS    ???             //Pin to use for RTS
#define USART_PINRX     RB7             //Pin to use for Rx
#define USART_PINTX     RB6             //Pin to use for Tx

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Pin configuration:  assign pin configuration register bits corresponding to
 * pin mapping.  Comment out analog select (ANSxx) if not applicable.
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
//#define USART_ANSCTS    ?           //Analog select for CTS pin
//#define USART_TRISCTS   ?          //TRIS control for CTS pin
//#define USART_WPUCTS    ?           //Must be defined if PIC has weak pull-ups enabled
//#define USART_ANSRX     ?           //Analog select for Rx pin
#define USART_TRISRX    TRISB7          //TRIS control for Rx pin
#define USART_WPURX     WPUB7           //Must be defined if PIC has weak pull-ups enabled
//#define USART_ANSTX     ?           //Analog select for Tx pin
#define USART_TRISTX    TRISB6          //TRIS control for Tx pin
#define USART_SLRTX     SLRB6           //Slew rate for Tx pin
//#define USART_ANSRTS    ?           //Analog select for RTS pin
//#define USART_TRISRTS   ?          //TRIS control for RTS pin
//#define USART_SLRRTS    ?           //Slew rate for RTS pin

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Peripheral Pin Select (PPS) for Rx & Tx pins:  set these as required by the 
 * PIC in use and user pin selections.  Comment out if not required
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
//Rx PPS
#define USART_PPSPRX    RXPPS           //PPS register for Rx
#define USART_PPSVRX    0x0F            //Register value mapping pin to USART Rx (RB7)
//Tx PPS
#define USART_PPSPTX    RB6PPS          //Pin to assign to Tx
#define USART_PPSVTX    0x24            //Register value mapping pin to USART Tx

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * CTS Interrupt On Change (IOC):  if HW flow control is used then these must
 * be defined to set the respective port register bits and mask.  Necessary to
 * use function usartTxBkgd.
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
//#define USART_IOCREG    ?           //IOC flag register that CTS pin maps to
//#define USART_IOCNEG    ?           //IOC negative edge register that CTS pin maps to
//#define USART_IOCMSK    ?            //IOC bit mask for CTS pin


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * USART configuration:  user must set baud rate and TX1 register.
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define USART_BRG16     TRUE            //TRUE or FALSE for use of 16-bit baud rate generator
#define USART_BRGH      0x00            //Baud rate high register
#define USART_BRGL      0x22            //Baud rate low register (115.2)
#define USART_TX1STA    0x24            //Register TX1 configuration

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * USART & Rx / Tx constants:  these control the behavior of routines and can be 
 * adjusted to suit needs.
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define USARTSZRXBUF    64              //Size of receive buffer
#define USARTMXRXBUF    (USARTSZRXBUF - 4)  //Maximum useable size of receive buffer
#define USARTDISDLY     9               //# mS to delay before disabling serial port
#define USARTENADLY     2               //# uS to delay before enabling serial port
#define USARTTXTO       35              //Tx timeout value in uS:  USARTTXWAIT x USARTTXDLY
#define USARTTXWAIT     10              //# uS between Tx retries



//End of file