#!/bin/bash
#
# DESCRIPTION:
# Maintains the build number log.  Reads current build # from build.txt and
# optionally from a common folder (passed as first parameter to script), adds
# the build numbers and appends to a log.
#
# Copyright (c) 2025 Brian Cornell, all rights reserved.
#
# DEPENDENCIES:  
#
# COMPONENTS:   buildlog.sh - this script.
#               build.txt - contains integer build # on first line.
#		buildlog.txt - appended log of builds.
#
# VERSION:  250724.
#
# MODIFICATION HISTORY:
# 24 Jul 25, Brian Cornell: created script.
#
#
#


BuildnumFil="build.txt"
BuildnumLog="buildlog.txt"

exec 3<> $BuildnumFil
read BuildNumPri <&3
exec 3>&-

if [ -n "${1}" ]
then
    exec 3<> $1"/"$BuildnumFil
    read BuildNumCom <&3
    exec 3>&-
else
    BuildNumCom=0
fi

let BuildNum=$BuildNumPri+$BuildNumCom

echo `date`", build $BuildNum: P=$BuildNumPri, C=$BuildNumCom" >>$BuildnumLog


#
#
# End of file.
