
enum { _xtlfreq = 20000000 , _clkfreq = 300'000'000  };


#include <propeller2.h>
#include <stdio.h>
#include <stdint.h>

struct __using("psram.spin2") psram;
struct __using("atsc_mod9.spin2") modulator;
//struct __using("qpsk_mod3.spin2") modulator;

#ifndef _clockfreq
#ifdef __P2__
#define _clockfreq() (*(unsigned int *)0x14)
#else
#define _clockfreq() _CLKFREQ
#endif
#endif

unsigned long time_us()
{
    unsigned long mhz = _clockfreq() / 1000000;
    return _cnt() / mhz;
}

#define PIN 2 // pin for RF output 


int main()
{
	unsigned long startTime, endTime;
	int  i, r;
	int  filesize=0;
	int  ram_amt=32*1024*1024;
	char  ram_file[32768];
	_setbaud(2000000);
	for( i=0;i<=16384;i++)
	{
		ram_file[i]=0x77;
	}
	printf("startup\n");
	psram.start();
	modulator.start(PIN,ram_file,ram_file+(32768));
	//while(1); // TEST
	//snprintf(ram_file,256,"/sd/HAPPYN.BIN");
	snprintf(ram_file,256,"/sd/LOOP.TS"); 
	//snprintf(ram_file,256,"/sd/TARA.BIN");

	unsigned int *px;
	//px=modulator.tlut();
	//for( i=0;i<=(256*8);i++)
	//	printf("%d %x %8x %8x\n",i,px,*px++,*px++);
	

	// initialize the file systems
#ifdef P9
	r = mount("/sd", _vfs_open_host());
	if (r == 0) {
		printf("mounted P9 as /\n");
	}
	//do_dir("/sd");
#else
	r = mount("/sd", _vfs_open_sdcard());
	if (r == 0) {
		printf("mounted SD card as /\n");
	}
	//do_dir("/sd");
#endif	
	printf("trying to open\n");
	FILE * f = fopen( ram_file, "rb" );
	if( !f )//|| ferror( f ) )
	{
		printf( "Error1: %x not found\n", ram_file );
		printf( "Error1: %s not found\n", ram_file );
		return -5;
	}
	fseek( f, 0, SEEK_END );
	long flen = ftell( f );
	fseek( f, 0, SEEK_SET );
	if( flen > ram_amt )
	{
		printf( "Error: Could not fit RAM image (%ld bytes) into %d\n", flen, ram_amt );
		return -6;
	}
	i=0;



	startTime = time_us();
	int c;
	for(;;) {
		c = fread( ram_file, 1, 512 , f );
		psram.write(ram_file,i,c);
		if ((i&0x1ffff)==0)
			printf("%d\n",i);
		i+=c;
		if (c < 511) break;
                   //psram_write_byte(i,c);
		   //break;
		//break; // FIXME debug for reed soloman
	}
	endTime = time_us();
	filesize=i;
	printf("done memcpy\n");
	printf("read %d bytes \n",filesize);
	// the below are incorrect because of counter overflow
	//printf ("in %u us\n", endTime - startTime);
	//printf ("%u us\n", (filesize*1000)/(endTime - startTime));

	printf("clock frequency = %u\n", _clockfreq());
	psram.read1(ram_file,0,512);
	printf("spot check: %x\n", *ram_file );

	for( i=0;i<32768;i++)
	{
		ram_file[i]=0;
	}
	r=0;
	i=0;
	while(1)
	{
#define CHUNK 1024
		startTime = time_us();
		px=modulator.wait_for_space(CHUNK+10900);
		endTime = time_us();
                psram.read1( px, i,CHUNK);
		modulator.register_dma_data(CHUNK);
		i+=CHUNK;

		//printf("%x.",endTime-startTime);
		if( i>=(filesize-1) ) 
		{
			i=0;
			_txraw((r&7)+'0'); // tested to 560 loops, probably good forever
			r++;
			//printf("wrap %d\n",r++);
		}

		//printf("%d\n",modulator.active_line());
	}
}
