
#include <avr/io.h>
#include <stdint.h>

uint8_t lfsr_fibonacci(uint16_t *lfsr);
uint8_t rng(uint16_t *lfsr, uint8_t digits);
uint8_t ascii2byte(uint8_t ascii);
void byte2ascii(uint8_t byte, uint8_t *ascii);
void refreshLEDs(uint8_t brightness, uint8_t *arr);
void initGameState(uint8_t *game, uint8_t *leds, uint8_t bright);
void wait(uint16_t time_ms, uint16_t *tick);
uint8_t isEmpty(uint8_t *arr, uint8_t len);
uint8_t sum(uint8_t *arr, uint8_t len);
void gameOver(uint8_t score0, uint8_t score1);
void initInterrupts(void);
void initTimerB0Interrupt1ms(void);
void initI2CDevices(void);
void portInit(void);
uint16_t readButtons(uint16_t *last);
void makeMove(uint8_t start, uint8_t *game);
void howMany(uint8_t pot, uint8_t *game);
void brightnessAdjust(uint8_t *brightnessArr, uint8_t brightness);
void mancala(void);