#include <avr/io.h>
#include "twi.h"
#include "tca9535.h"

void initTCA9535(void){
    TWI_InitTransmission(TCA9535_ADDR,0);
    TWI_SendByte(POLARITY0_REGISTER_ADDR);
    TWI_SendByte(0xFF);
    TWI_EndSession(); 
    
    TWI_InitTransmission(TCA9535_ADDR,0);
    TWI_SendByte(POLARITY1_REGISTER_ADDR);
    TWI_SendByte(0xFF);
    TWI_EndSession(); 

    TWI_InitTransmission(TCA9535_ADDR,0);
    TWI_SendByte(CONFIG0_REGISTER_ADDR);
    TWI_SendByte(0xFF);
    TWI_EndSession(); 

    TWI_InitTransmission(TCA9535_ADDR,0);
    TWI_SendByte(CONFIG1_REGISTER_ADDR);
    TWI_SendByte(0xFF);
    TWI_EndSession();   
}

uint16_t readTCA9535Inputs(void){
    uint8_t arr[2];
    uint16_t inputData = 0;
    TWI_InitTransmission(TCA9535_ADDR,0);
    TWI_SendByte(INPUT0_REGISTER_ADDR); 
    TWI_InitTransmission(TCA9535_ADDR,1);   
    TWI_ReadN(arr, 2); 
    TWI_EndSession(); 
    inputData = (arr[1]<<8) | arr[0];
    return inputData;
}
