#include <avr/io.h>
#include "twi.h"
#include "tlc59116.h"

void resetTLC59116(void){
    TWI_InitTransmission(0b1101011,0);
    TWI_SendByte(0xA5);
    TWI_SendByte(0x5A);    
    TWI_EndSession();     
}

void configIREF(uint8_t hl, uint8_t subcurrent, uint8_t cm){
    uint8_t irefReg = ((hl<<7)|(subcurrent<<6))|cm;
    TWI_InitTransmission(TLC59116_ADDR,0);
    TWI_SendByte(IREF_REGISTER);
    TWI_SendByte(irefReg);
    TWI_EndSession();
}

void initTLC59116(void){  
    TWI_InitTransmission(TLC59116_ADDR,0);
    TWI_SendByte(OFF);
    TWI_SendByte(OFF);
    TWI_EndSession();      
    
    TWI_InitTransmission(TLC59116_ADDR,0);
    TWI_SendByte(OUTPUT_MODE_REGISTER);
    for(uint8_t i=0; i<4; i++){
        TWI_SendByte(INDIVIDUAL_PWM_OUT);
    }
    TWI_EndSession();      
    
    TWI_InitTransmission(TLC59116_ADDR,0);
    TWI_SendByte(0x1C);
    TWI_SendByte(0b01001111);
    TWI_EndSession();       
    
    configIREF(0,0,0b1111);
}

void setLED(uint8_t LED_ADDR, uint8_t brightness){
    uint8_t address = LED_ADDR + OFFSET;
    TWI_InitTransmission(TLC59116_ADDR,0);
    TWI_SendByte(address);
    TWI_SendByte(brightness);
    TWI_EndSession();        
}

void setLEDs(uint8_t brightness){
    TWI_InitTransmission(TLC59116_ADDR,0);
    TWI_SendByte(PWM_CONTROL_REGISTER);
    for(uint8_t p=0; p<16; p++){
        TWI_SendByte(brightness);
    }
    TWI_EndSession();
}