#ifndef _TWI_
#define _TWI_

#include <avr/io.h>
#include <stdint.h>

#define TWI_SCL_FREQ 100000UL
#define F_CLKPER 2000000UL
#define TWI_BAUD (uint8_t)(((F_CLKPER/TWI_SCL_FREQ) - 10)/2)
#define ONEHUNDREDKHZ 45

typedef enum {
    TWI_INIT = 0, 
    TWI_READY,
    TWI_ERROR
} TWI_Status;

typedef enum{
    TWI_WRITE = 0,
    TWI_READ = 1
} TWI_Direction;

//uint8_t twibaud = (uint8_t)(((F_CLKPER/TWI_SCL_FREQ) - 10)/2);

void    TWI_Init(uint8_t baudrate);
uint8_t TWI_InitTransmission(uint8_t address, TWI_Direction dir);
uint8_t TWI_SendByte(uint8_t data); 
uint8_t TWI_SendN(uint8_t *pData, uint8_t len); 
uint8_t TWI_ReadByte(uint8_t *data); 
uint8_t TWI_ReadN(uint8_t *pData, uint8_t len); 
uint8_t TWI_SendData(uint8_t address, uint8_t *pData, uint8_t len);
uint8_t TWI_GetData(uint8_t address, uint8_t *pData, uint8_t len); 
void    TWI_EndSession(void);


#endif