
#include <avr/io.h>
#include "usart.h"

void insert(uint8_t value, volatile uint8_t *numItems, volatile uint8_t *bufferTail, volatile uint8_t *buffer){
    *(buffer+(*bufferTail % MAX_ITEMS)) = value;
    *bufferTail = (*(bufferTail)+1)%MAX_ITEMS;
    if(*numItems < MAX_ITEMS){
        *numItems = *numItems + 1;
    }
}

uint8_t pop(volatile uint8_t *numItems, volatile uint8_t *bufferHead, volatile uint8_t *buffer){
    uint8_t popped_val = *(buffer+(*bufferHead % MAX_ITEMS));
    *bufferHead = (*bufferHead + 1) % MAX_ITEMS;
    if(*numItems){
        *(numItems) = *(numItems) - 1;
    }
    return popped_val;
}


void initRingBuffer(volatile uint8_t *buf){
    for(uint8_t i=0; i<MAX_ITEMS; i++){
        *(buf+i) = 0;
    }
}

void initUSARTAsynchronous(uint16_t baud){
    USART0.BAUD = baud;
    USART0.CTRLB |= RX_ON | TX_ON;
    USART0.CTRLC = EIGHTNONE;
}

void initUSARTInterrupt(void){
    USART0.CTRLA |= (1<<7);
}

uint8_t readUSART(void){
    uint8_t data = 0;
    while(!(USART0.STATUS&RCIF_BM));
    data = USART0.RXDATAL;
    return data;
}

void sendUSART(uint8_t byte){
    USART0.TXDATAL = byte;
    while(!(USART0.STATUS&TXIF_BM));
    USART0.STATUS |= (1<<6);
}

void sendUSARTbytes(uint8_t *bytes, uint8_t size){
    for(uint8_t i=0; i<size; i++){
        sendUSART(*(bytes+i));
    }
}

