/* 
 * File:   usart.h
 * Author: zacharymurtishi
 *
 * Created on January 25, 2025, 7:31 AM
 */

#ifndef USART_H
#define	USART_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <avr/io.h>

#define F_CLKPER 2000000UL
#define BAUDRATE 9600
#define BAUDRATE_VALUE (uint16_t)(((64*F_CLKPER)/BAUDRATE)/16)
    
#define EIGHTNONE 0x03
#define RX_ON 1<<7
#define TX_ON 1<<6
#define RCIF_BM 0x80
#define TXIF_BM 0x40
    
#define MAX_ITEMS 16

void insert(uint8_t value, volatile uint8_t *numItems, volatile uint8_t *bufferTail, volatile uint8_t *buffer);
uint8_t pop(volatile uint8_t *numItems, volatile uint8_t *bufferHead, volatile uint8_t *buffer);
void initRingBuffer(volatile uint8_t *buf);
void initUSARTAsynchronous(uint16_t baud);
void initUSARTInterrupt(void);
uint8_t readUSART(void);
void sendUSART(uint8_t byte);
void sendUSARTbytes(uint8_t *bytes, uint8_t size);

#ifdef	__cplusplus
}
#endif

#endif	/* USART_H */

