// camferCube1

//dims = [10, 10, 10];
//camferCube(dims, false);


module camferCube(dims, center = false, camfer=1.0) {
    width = dims[0];
    length = dims[1];
    height = dims[2];
    if (center) {
        translate([0, 0, -height / 2]) {
            hull() {
                // base
                translate([0, 0, 0]) topBottomPlane(dims, camfer=1.0);
                // lowerMid
                translate([0, 0, camfer]) middlePlane(dims, camfer=1.0);
                // upperPlane
                translate([0, 0, height - camfer]) middlePlane(dims, camfer=1.0);
                // top
                translate([0, 0, height]) topBottomPlane(dims, camfer=1.0);
            }
        }
    } else {
        translate([width / 2, length / 2, 0]) {
            hull() {
                // base
                translate([0, 0, 0]) topBottomPlane(dims, camfer=1.0);
                // lowerMid
                translate([0, 0, camfer]) middlePlane(dims, camfer=1.0);
                // upperPlane
                translate([0, 0, height - camfer]) middlePlane(dims, camfer=1.0);
                // top
                translate([0, 0, height]) topBottomPlane(dims, camfer=1.0);
            }
        }
    }
}

module camferHalfCube(dims, center = false, camfer=1.0) {
    width = dims[0];
    length = dims[1];
    height = dims[2];
    if (center) {
        translate([0, 0, -height / 2]) {
            hull() {
                // base
                translate([0, 0, 0]) topBottomPlane(dims, camfer=1.0);
                // lowerMid
                translate([0, 0, camfer]) middlePlane(dims, camfer=1.0);
                // top
                translate([0, 0, height]) middlePlane(dims, camfer=1.0);
            }
        }
    } else {
        translate([width / 2, length / 2, 0]) {
            hull() {
                // base
                translate([0, 0, 0]) topBottomPlane(dims, camfer=1.0);
                // lowerMid
                translate([0, 0, camfer]) middlePlane(dims, camfer=1.0);
                // top
                translate([0, 0, height]) middlePlane(dims, camfer=1.0);
            }
        }
    }
}

module topBottomPlane(dims, camfer) {
    width = dims[0];
    length = dims[1];
    height = dims[2];
    radius = 0.01;
        translate([-width / 2 + camfer, -length / 2 + camfer, 0]) sphere(r = radius);
        translate([width / 2 - camfer,  -length / 2 + camfer, 0]) sphere(r = radius);
        translate([-width / 2 + camfer,  length / 2 - camfer, 0]) sphere(r = radius);
        translate([width / 2 - camfer,   length / 2 - camfer, 0]) sphere(r = radius);
 }

module middlePlane(dims, camfer) {
    width = dims[0];
    length = dims[1];
    height = dims[2];
    radius = 0.01;
    // 
    translate([-width / 2 + camfer, -length / 2]) sphere(r = radius);  
    translate([-width / 2, -length / 2 + camfer]) sphere(r = radius); 
    // 
    translate([width / 2 - camfer, -length / 2]) sphere(r = radius);  
    translate([width / 2, -length / 2 + camfer]) sphere(r = radius); 
    // 
    translate([-width / 2 + camfer, length / 2]) sphere(r = radius);  
    translate([-width / 2, length / 2 - camfer]) sphere(r = radius); 
    // 
    translate([width / 2 - camfer, length / 2]) sphere(r = radius);  
    translate([width / 2, length / 2 - camfer]) sphere(r = radius); 
}

