//paperTapePunchConverterBox1 // uniBox2

$fn = 32;
include <./camferCube.scad>
include <./screwShapes1.scad>
include <./subDE-9.scad>

realPcbW = 65.0;
realPcbL = 99.0;

pcbW = realPcbW + 11.3;
pcbL = realPcbL + 5;
bottomHeight = 17;
wall = 2;
componentHeight = 20.0;

bottomDimsOutside = [pcbW + 2 * wall, pcbL + 2 * wall, bottomHeight];
bottomDimsInside = [pcbW, pcbL, bottomHeight];

// print position
//translate([10 - wall, 0, 0]) color("red") top();
// inspect position
//rotate([0, 180, 0]) translate([10 - wall * 2, 0, -34]) color("red") {
//    intersection() {
//        top(); 
//        cube([80, 60, 30]);
//    }
//}
//
//translate([-pcbW - 10, 0, 0]) color("lightblue") bottom();

//translate([10, - bottomHeight * 2 - 10, 0]) panel();
//translate([10, - bottomHeight * 2 - 10, 0]) ptpc_backPanel();
translate([10, - bottomHeight * 2 - 50, 0]) ptpc_frontPanel();

//translate([-46, 54, 5]) pcb();


module bottom() {
    top(true);
}


module top(screwSide = false) {
    difference() {
        camferHalfCube(bottomDimsOutside, false);
        translate([wall, wall, wall]) camferHalfCube(bottomDimsInside, false);
        // front bezelled cutout
        dims = [bottomDimsInside[0] - 4 * wall, wall, bottomHeight];
        translate([3.0 * wall, -0.01, 3 * wall]) bezelCube(dims, false, 1.0);
        // back bezelled cutout
        translate([bottomDimsOutside[0] - 3 * wall, pcbL + 2 * wall +0.01, 3 * wall]) rotate([0, 0, 180]) bezelCube(dims, false, 1.0);
        // side ridge concave
        translate([pcbW + 2 * wall - wall/2, (pcbL + 2 * wall) / 2, bottomHeight]) sideRidge();
        if (screwSide) {
             translate([2 * wall, 3.75 * wall, -0.02]) flatHeadM3(bottomHeight);
             translate([bottomDimsInside[0], 3.75 * wall, -0.02]) flatHeadM3(bottomHeight);
             translate([2 * wall, bottomDimsInside[1] - 1.75 * wall, -0.02]) flatHeadM3(bottomHeight);
             translate([bottomDimsInside[0], bottomDimsInside[1] - 1.75 * wall, -0.02]) flatHeadM3(bottomHeight);
        }
    }
    // side ridge convex
    translate([wall/2, (pcbL + 2 * wall) / 2, bottomHeight]) sideRidge(wall);
//    translate([pcbW + 2 * wall - wall/2, (pcbL + 2 * wall) / 2, bottomHeight]) sideRidge(wall);
    // pillars
    translate([2 * wall, 3.75 * wall, wall]) screwPillar(screwSide, bottomDimsInside[2] - wall - 0.5);
    translate([bottomDimsInside[0], 3.75 * wall, wall]) screwPillar(screwSide, bottomDimsInside[2] - wall - 0.5);
    translate([2 * wall, bottomDimsInside[1] - 1.75 * wall, wall]) screwPillar(screwSide, bottomDimsInside[2] - wall - 0.5);
    translate([bottomDimsInside[0], bottomDimsInside[1] - 1.75 * wall, wall]) screwPillar(screwSide, bottomDimsInside[2] - wall - 0.5);
    // panel ridges bottom
    translate([wall, 2.1 * wall, wall]) cube([bottomDimsInside[0], wall, wall]);
    translate([wall, bottomDimsInside[1] - 1.1 * wall, wall]) cube([bottomDimsInside[0], wall, wall]);
}

module sideRidge(redux = 0) {
    ridgeSize = wall * 0.5;
    rotate([0, 45, 0]) cube([ridgeSize, pcbL - 7 * wall - redux, ridgeSize], true);
}

module bezelCube(dims, center = false, camfer = 1.0) {
    width  = dims[0];
    height = dims[1];
    length = dims[2];
    radius = 0.01;
    translate([width, height, length]) {
        rotate([-90, 0, 180]) {
            hull() {
                // lower plane
                translate([0, 0, 0]) sphere(r = radius);
                translate([ width, 0, 0]) sphere(r = radius);
                translate([0,  length, 0]) sphere(r = radius); 
                translate([ width,  length, 0]) sphere(r = radius); 
                // upper plane
                translate([- camfer, - camfer, height]) sphere(r = radius);
                translate([ width + camfer, - camfer, height]) sphere(r = radius);
                translate([- camfer,  length + camfer, height]) sphere(r = radius); 
                translate([ width + camfer,  length + camfer, height]) sphere(r = radius); 
            }
        }
    }
}

module screwPillar(screwSide = false, height) {
    insideDiam = 2.6;
    outsideDiam = insideDiam + 2 * wall;
    difference() {
        cylinder(d = outsideDiam, h = height);
        translate([0, 0, -0.01]) {
            if (screwSide) {
                cylinder(d = 3.3, h = height + 0.02);
            } else {
                cylinder(d = insideDiam, h = height + 0.02);
            }
        }
    }
}

module panel() {
    dims = [pcbW - 0.2, bottomHeight * 2 - 2 * wall - 0.2, wall - 0.2];
    camferHalfCube(dims, false, wall/2);
}


module ptpc_backPanel() {
    rimHeight = 3.75;
    difference() {
        panel();
        translate([25.0, -0.1 + 0, -0.02]) cube([35.0, 5.5, wall + 0.02]);
    }
}

module ptpc_frontPanel() {
    ledDiam = 3.2;
    rimHeight = 4.75;
    difference() {
        panel();
        // sub-DE
        translate([18.25 + 14.25, rimHeight + 14.5, 0]) wholeSubDE(wall + 0.02);
    }
}

module wholeSubDE(height) {
    shellRad = 1.25;
    shellHeight = 13.0;
    shellWidth = 28.5;
    hull() {
        translate([ 0,  shellHeight/2 - shellRad, -0.02]) {
            translate([ shellWidth/2 + shellRad, 0, 0]) cylinder(r = shellRad, h = height);
            translate([-shellWidth/2 + shellRad, 0, 0]) cylinder(r = shellRad, h = height);
        }
        translate([ 0, -shellHeight/2 + shellRad, -0.02]) {
            translate([ shellWidth/2 + shellRad, 0, 0]) cylinder(r = shellRad, h = height);
            translate([-shellWidth/2 + shellRad, 0, 0]) cylinder(r = shellRad, h = height);
        }
    }
}

module pcb() {
    pcbThick = 1.6;
    
    color("green") cube([realPcbW, realPcbL, pcbThick], true);
    translate([0, 0, pcbThick/2 + componentHeight/2]) color("darkgray") cube([realPcbW - 5.0, realPcbL - 5.0, componentHeight], true);
}