//
//subDEHole(1.5);

module subDEHole(wall) {
    $fn = 32;
    subDEcornerRad = 3.0;
    subDEWidth = 19.5;
    subDEHeight = 11.0;
    subDEWidthReduc = 2.0;
    subDEHoleDist = 25.4;
    subDEHoleXOffset = -3.0;
    caseWall = wall;
    translate([0, subDEWidth/2, subDEHeight/2]) {
        // sub-DE shaped hole
        rotate([90, 180, 90]) {
            hull() {
                translate([subDEcornerRad, subDEHeight - subDEcornerRad, 0]) 
                    cylinder(r = subDEcornerRad, h = caseWall + 0.02);
                translate([subDEWidth - subDEcornerRad, subDEHeight - subDEcornerRad, 0]) 
                    cylinder(r = subDEcornerRad, h = caseWall + 0.02);
                translate([subDEWidthReduc, subDEcornerRad, 0]) 
                    cylinder(r = subDEcornerRad, h = caseWall + 0.02);
                translate([subDEWidth - subDEWidthReduc, subDEcornerRad, 0]) 
                    cylinder(r = subDEcornerRad, h = caseWall + 0.02);
            }
            // side holes
            translate([subDEHoleXOffset, subDEHeight / 2, 0]) 
                cylinder(d = 3.0, h = caseWall + 0.02);
            translate([subDEHoleDist + subDEHoleXOffset, subDEHeight / 2, 0]) 
                cylinder(d = 3.0, h = caseWall + 0.02);
        }
    }
}
