# XGB2USB Build & Flash Guide

## 1. Toolchain and Flash Tool Downloads

- **RISC-V Toolchain:**  
  [xpack-riscv-none-elf-gcc 15.2.0-1 (Linux x64)](https://github.com/xpack-dev-tools/riscv-none-elf-gcc-xpack/releases/download/v15.2.0-1/xpack-riscv-none-elf-gcc-15.2.0-1-linux-x64.tar.gz)

- **WCH USB/Serial Flash Tool:**  
  [wchisp v0.3.0 (Linux x64)](https://github.com/ch32-rs/wchisp/releases/download/v0.3.0/wchisp-v0.3.0-linux-x64.tar.gz)

---

## 2. System Requirements

Make sure you have a basic build environment installed (build-essentials, cmake, python etc.)

---

## 3. Installation & PATH Setup

Download both archives (toolchain and flash tool) — for example, to your **home directory**.  
Then, add the toolchain’s `bin` directory and the `wchisp` to your `PATH`:

```bash
export PATH=$PATH:[bin directory of the toolchain]:[path to wchisp]
```

> 💡 Replace `[bin directory of the toolchain]` and `[path to wchisp]` with the actual paths on your system.  
> You can make this change permanent by adding the line above to your `~/.bashrc` or `~/.zshrc`.

---

## 4. Clone and Build the Project

```bash
git clone --recurse-submodules https://codeberg.org/embedded-ideas/xgb2usb.git
cd xgb2usb/tinyusb/tools/
python get_deps.py ch32v30x
cd ../..
mkdir build
cd build
cmake ..
make
```

---

## 5. Flash the Firmware

After building, flash the firmware to the device:

```bash
wchisp flash xgb2usb.hex
```

---

## 6. Tools Used for Testing

- **qv4l2** — for video device testing  
- **OBS Studio** — for capture and streaming verification

---

