// Auto-generated RGB555 → YUV lookup table
// Each index = (B << 10) | (G << 5) | R

#ifndef RGB555_TO_YUV_H
#define RGB555_TO_YUV_H

#ifndef XGB_CAPTURE_C_
    #error This header is only allowed to be included once in dmg_capture.c
#endif

#include <stdint.h>

typedef struct __attribute__((packed)){
    uint8_t ucY;
    uint8_t ucU;
    uint8_t ucV;
} sYuv;

static const sYuv rgb555_to_yuv[32768] = {
    {  0, 128, 128},     {  2, 127, 132},     {  5, 125, 136},     {  7, 124, 140},
    { 10, 122, 144},     { 12, 121, 149},     { 15, 120, 153},     { 17, 118, 157},
    { 20, 117, 161},     { 22, 115, 165},     { 25, 114, 169},     { 27, 113, 173},
    { 30, 111, 177},     { 32, 110, 181},     { 34, 109, 186},     { 37, 107, 190},
    { 39, 106, 194},     { 42, 104, 198},     { 44, 103, 202},     { 47, 102, 206},
    { 49, 100, 210},     { 52,  99, 214},     { 54,  97, 218},     { 57,  96, 223},
    { 59,  95, 227},     { 61,  93, 231},     { 64,  92, 235},     { 66,  90, 239},
    { 69,  89, 243},     { 71,  88, 247},     { 74,  86, 251},     { 76,  85, 255},
    {  5, 125, 125},     {  7, 124, 129},     { 10, 122, 133},     { 12, 121, 137},
    { 15, 120, 141},     { 17, 118, 145},     { 20, 117, 149},     { 22, 116, 153},
    { 25, 114, 157},     { 27, 113, 162},     { 29, 111, 166},     { 32, 110, 170},
    { 34, 109, 174},     { 37, 107, 178},     { 39, 106, 182},     { 42, 104, 186},
    { 44, 103, 190},     { 47, 102, 194},     { 49, 100, 199},     { 52,  99, 203},
    { 54,  97, 207},     { 56,  96, 211},     { 59,  95, 215},     { 61,  93, 219},
    { 64,  92, 223},     { 66,  91, 227},     { 69,  89, 231},     { 71,  88, 236},
    { 74,  86, 240},     { 76,  85, 244},     { 79,  84, 248},     { 81,  82, 252},
    { 10, 123, 121},     { 12, 121, 125},     { 15, 120, 129},     { 17, 118, 133},
    { 19, 117, 138},     { 22, 116, 142},     { 24, 114, 146},     { 27, 113, 150},
    { 29, 111, 154},     { 32, 110, 158},     { 34, 109, 162},     { 37, 107, 166},
    { 39, 106, 170},     { 42, 104, 175},     { 44, 103, 179},     { 47, 102, 183},
    { 49, 100, 187},     { 51,  99, 191},     { 54,  98, 195},     { 56,  96, 199},
    { 59,  95, 203},     { 61,  93, 207},     { 64,  92, 212},     { 66,  91, 216},
    { 69,  89, 220},     { 71,  88, 224},     { 74,  86, 228},     { 76,  85, 232},
    { 79,  84, 236},     { 81,  82, 240},     { 83,  81, 244},     { 86,  79, 249},
    { 14, 120, 118},     { 17, 118, 122},     { 19, 117, 126},     { 22, 116, 130},
    { 24, 114, 134},     { 27, 113, 138},     { 29, 111, 142},     { 32, 110, 146},
    { 34, 109, 151},     { 37, 107, 155},     { 39, 106, 159},     { 42, 105, 163},
    { 44, 103, 167},     { 46, 102, 171},     { 49, 100, 175},     { 51,  99, 179},
    { 54,  98, 183},     { 56,  96, 188},     { 59,  95, 192},     { 61,  93, 196},
    { 64,  92, 200},     { 66,  91, 204},     { 69,  89, 208},     { 71,  88, 212},
    { 74,  86, 216},     { 76,  85, 220},     { 78,  84, 225},     { 81,  82, 229},
    { 83,  81, 233},     { 86,  80, 237},     { 88,  78, 241},     { 91,  77, 245},
    { 19, 117, 114},     { 22, 116, 118},     { 24, 114, 122},     { 27, 113, 127},
    { 29, 112, 131},     { 32, 110, 135},     { 34, 109, 139},     { 37, 107, 143},
    { 39, 106, 147},     { 41, 105, 151},     { 44, 103, 155},     { 46, 102, 159},
    { 49, 100, 164},     { 51,  99, 168},     { 54,  98, 172},     { 56,  96, 176},
    { 59,  95, 180},     { 61,  93, 184},     { 64,  92, 188},     { 66,  91, 192},
    { 69,  89, 196},     { 71,  88, 201},     { 73,  87, 205},     { 76,  85, 209},
    { 78,  84, 213},     { 81,  82, 217},     { 83,  81, 221},     { 86,  80, 225},
    { 88,  78, 229},     { 91,  77, 233},     { 93,  75, 238},     { 96,  74, 242},
    { 24, 114, 111},     { 27, 113, 115},     { 29, 112, 119},     { 32, 110, 123},
    { 34, 109, 127},     { 36, 107, 131},     { 39, 106, 135},     { 41, 105, 140},
    { 44, 103, 144},     { 46, 102, 148},     { 49, 100, 152},     { 51,  99, 156},
    { 54,  98, 160},     { 56,  96, 164},     { 59,  95, 168},     { 61,  94, 172},
    { 63,  92, 177},     { 66,  91, 181},     { 68,  89, 185},     { 71,  88, 189},
    { 73,  87, 193},     { 76,  85, 197},     { 78,  84, 201},     { 81,  82, 205},
    { 83,  81, 209},     { 86,  80, 214},     { 88,  78, 218},     { 91,  77, 222},
    { 93,  75, 226},     { 95,  74, 230},     { 98,  73, 234},     {100,  71, 238},
    { 29, 112, 107},     { 31, 110, 111},     { 34, 109, 116},     { 36, 107, 120},
    { 39, 106, 124},     { 41, 105, 128},     { 44, 103, 132},     { 46, 102, 136},
    { 49, 101, 140},     { 51,  99, 144},     { 54,  98, 148},     { 56,  96, 153},
    { 58,  95, 157},     { 61,  94, 161},     { 63,  92, 165},     { 66,  91, 169},
    { 68,  89, 173},     { 71,  88, 177},     { 73,  87, 181},     { 76,  85, 185},
    { 78,  84, 190},     { 81,  82, 194},     { 83,  81, 198},     { 86,  80, 202},
    { 88,  78, 206},     { 90,  77, 210},     { 93,  76, 214},     { 95,  74, 218},
    { 98,  73, 222},     {100,  71, 227},     {103,  70, 231},     {105,  69, 235},
    { 34, 109, 104},     { 36, 108, 108},     { 39, 106, 112},     { 41, 105, 116},
    { 44, 103, 120},     { 46, 102, 124},     { 49, 101, 129},     { 51,  99, 133},
    { 53,  98, 137},     { 56,  96, 141},     { 58,  95, 145},     { 61,  94, 149},
    { 63,  92, 153},     { 66,  91, 157},     { 68,  89, 161},     { 71,  88, 166},
    { 73,  87, 170},     { 76,  85, 174},     { 78,  84, 178},     { 81,  83, 182},
    { 83,  81, 186},     { 85,  80, 190},     { 88,  78, 194},     { 90,  77, 198},
    { 93,  76, 203},     { 95,  74, 207},     { 98,  73, 211},     {100,  71, 215},
    {103,  70, 219},     {105,  69, 223},     {108,  67, 227},     {110,  66, 231},
    { 39, 106, 100},     { 41, 105, 105},     { 44, 103, 109},     { 46, 102, 113},
    { 48, 101, 117},     { 51,  99, 121},     { 53,  98, 125},     { 56,  96, 129},
    { 58,  95, 133},     { 61,  94, 137},     { 63,  92, 142},     { 66,  91, 146},
    { 68,  90, 150},     { 71,  88, 154},     { 73,  87, 158},     { 76,  85, 162},
    { 78,  84, 166},     { 80,  83, 170},     { 83,  81, 174},     { 85,  80, 179},
    { 88,  78, 183},     { 90,  77, 187},     { 93,  76, 191},     { 95,  74, 195},
    { 98,  73, 199},     {100,  71, 203},     {103,  70, 207},     {105,  69, 211},
    {107,  67, 216},     {110,  66, 220},     {112,  65, 224},     {115,  63, 228},
    { 43, 103,  97},     { 46, 102, 101},     { 48, 101, 105},     { 51,  99, 109},
    { 53,  98, 113},     { 56,  97, 118},     { 58,  95, 122},     { 61,  94, 126},
    { 63,  92, 130},     { 66,  91, 134},     { 68,  90, 138},     { 71,  88, 142},
    { 73,  87, 146},     { 75,  85, 150},     { 78,  84, 155},     { 80,  83, 159},
    { 83,  81, 163},     { 85,  80, 167},     { 88,  78, 171},     { 90,  77, 175},
    { 93,  76, 179},     { 95,  74, 183},     { 98,  73, 187},     {100,  72, 192},
    {102,  70, 196},     {105,  69, 200},     {107,  67, 204},     {110,  66, 208},
    {112,  65, 212},     {115,  63, 216},     {117,  62, 220},     {120,  60, 224},
    { 48, 101,  94},     { 51,  99,  98},     { 53,  98, 102},     { 56,  97, 106},
    { 58,  95, 110},     { 61,  94, 114},     { 63,  92, 118},     { 66,  91, 122},
    { 68,  90, 126},     { 70,  88, 131},     { 73,  87, 135},     { 75,  85, 139},
    { 78,  84, 143},     { 80,  83, 147},     { 83,  81, 151},     { 85,  80, 155},
    { 88,  79, 159},     { 90,  77, 163},     { 93,  76, 168},     { 95,  74, 172},
    { 97,  73, 176},     {100,  72, 180},     {102,  70, 184},     {105,  69, 188},
    {107,  67, 192},     {110,  66, 196},     {112,  65, 200},     {115,  63, 205},
    {117,  62, 209},     {120,  60, 213},     {122,  59, 217},     {125,  58, 221},
    { 53,  98,  90},     { 56,  97,  94},     { 58,  95,  98},     { 60,  94, 102},
    { 63,  92, 107},     { 65,  91, 111},     { 68,  90, 115},     { 70,  88, 119},
    { 73,  87, 123},     { 75,  86, 127},     { 78,  84, 131},     { 80,  83, 135},
    { 83,  81, 139},     { 85,  80, 144},     { 88,  79, 148},     { 90,  77, 152},
    { 92,  76, 156},     { 95,  74, 160},     { 97,  73, 164},     {100,  72, 168},
    {102,  70, 172},     {105,  69, 176},     {107,  67, 181},     {110,  66, 185},
    {112,  65, 189},     {115,  63, 193},     {117,  62, 197},     {120,  61, 201},
    {122,  59, 205},     {124,  58, 209},     {127,  56, 213},     {129,  55, 218},
    { 58,  95,  87},     { 60,  94,  91},     { 63,  93,  95},     { 65,  91,  99},
    { 68,  90, 103},     { 70,  88, 107},     { 73,  87, 111},     { 75,  86, 115},
    { 78,  84, 120},     { 80,  83, 124},     { 83,  81, 128},     { 85,  80, 132},
    { 87,  79, 136},     { 90,  77, 140},     { 92,  76, 144},     { 95,  74, 148},
    { 97,  73, 152},     {100,  72, 157},     {102,  70, 161},     {105,  69, 165},
    {107,  68, 169},     {110,  66, 173},     {112,  65, 177},     {115,  63, 181},
    {117,  62, 185},     {119,  61, 189},     {122,  59, 194},     {124,  58, 198},
    {127,  56, 202},     {129,  55, 206},     {132,  54, 210},     {134,  52, 214},
    { 63,  93,  83},     { 65,  91,  87},     { 68,  90,  91},     { 70,  88,  96},
    { 73,  87, 100},     { 75,  86, 104},     { 78,  84, 108},     { 80,  83, 112},
    { 82,  81, 116},     { 85,  80, 120},     { 87,  79, 124},     { 90,  77, 128},
    { 92,  76, 133},     { 95,  75, 137},     { 97,  73, 141},     {100,  72, 145},
    {102,  70, 149},     {105,  69, 153},     {107,  68, 157},     {110,  66, 161},
    {112,  65, 165},     {114,  63, 170},     {117,  62, 174},     {119,  61, 178},
    {122,  59, 182},     {124,  58, 186},     {127,  56, 190},     {129,  55, 194},
    {132,  54, 198},     {134,  52, 202},     {137,  51, 207},     {139,  50, 211},
    { 68,  90,  80},     { 70,  88,  84},     { 73,  87,  88},     { 75,  86,  92},
    { 77,  84,  96},     { 80,  83, 100},     { 82,  82, 104},     { 85,  80, 109},
    { 87,  79, 113},     { 90,  77, 117},     { 92,  76, 121},     { 95,  75, 125},
    { 97,  73, 129},     {100,  72, 133},     {102,  70, 137},     {104,  69, 141},
    {107,  68, 146},     {109,  66, 150},     {112,  65, 154},     {114,  63, 158},
    {117,  62, 162},     {119,  61, 166},     {122,  59, 170},     {124,  58, 174},
    {127,  57, 178},     {129,  55, 183},     {132,  54, 187},     {134,  52, 191},
    {136,  51, 195},     {139,  50, 199},     {141,  48, 203},     {144,  47, 207},
    { 72,  87,  76},     { 75,  86,  80},     { 77,  84,  85},     { 80,  83,  89},
    { 82,  82,  93},     { 85,  80,  97},     { 87,  79, 101},     { 90,  77, 105},
    { 92,  76, 109},     { 95,  75, 113},     { 97,  73, 117},     { 99,  72, 122},
    {102,  70, 126},     {104,  69, 130},     {107,  68, 134},     {109,  66, 138},
    {112,  65, 142},     {114,  64, 146},     {117,  62, 150},     {119,  61, 154},
    {122,  59, 159},     {124,  58, 163},     {127,  57, 167},     {129,  55, 171},
    {131,  54, 175},     {134,  52, 179},     {136,  51, 183},     {139,  50, 187},
    {141,  48, 191},     {144,  47, 196},     {146,  45, 200},     {149,  44, 204},
    { 77,  84,  73},     { 80,  83,  77},     { 82,  82,  81},     { 85,  80,  85},
    { 87,  79,  89},     { 90,  77,  93},     { 92,  76,  98},     { 94,  75, 102},
    { 97,  73, 106},     { 99,  72, 110},     {102,  71, 114},     {104,  69, 118},
    {107,  68, 122},     {109,  66, 126},     {112,  65, 130},     {114,  64, 135},
    {117,  62, 139},     {119,  61, 143},     {122,  59, 147},     {124,  58, 151},
    {126,  57, 155},     {129,  55, 159},     {131,  54, 163},     {134,  52, 167},
    {136,  51, 172},     {139,  50, 176},     {141,  48, 180},     {144,  47, 184},
    {146,  46, 188},     {149,  44, 192},     {151,  43, 196},     {154,  41, 200},
    { 82,  82,  69},     { 85,  80,  74},     { 87,  79,  78},     { 89,  78,  82},
    { 92,  76,  86},     { 94,  75,  90},     { 97,  73,  94},     { 99,  72,  98},
    {102,  71, 102},     {104,  69, 106},     {107,  68, 111},     {109,  66, 115},
    {112,  65, 119},     {114,  64, 123},     {117,  62, 127},     {119,  61, 131},
    {121,  59, 135},     {124,  58, 139},     {126,  57, 143},     {129,  55, 148},
    {131,  54, 152},     {134,  53, 156},     {136,  51, 160},     {139,  50, 164},
    {141,  48, 168},     {144,  47, 172},     {146,  46, 176},     {148,  44, 180},
    {151,  43, 185},     {153,  41, 189},     {156,  40, 193},     {158,  39, 197},
    { 87,  79,  66},     { 89,  78,  70},     { 92,  76,  74},     { 94,  75,  78},
    { 97,  73,  82},     { 99,  72,  87},     {102,  71,  91},     {104,  69,  95},
    {107,  68,  99},     {109,  66, 103},     {112,  65, 107},     {114,  64, 111},
    {116,  62, 115},     {119,  61, 119},     {121,  60, 124},     {124,  58, 128},
    {126,  57, 132},     {129,  55, 136},     {131,  54, 140},     {134,  53, 144},
    {136,  51, 148},     {139,  50, 152},     {141,  48, 156},     {143,  47, 161},
    {146,  46, 165},     {148,  44, 169},     {151,  43, 173},     {153,  41, 177},
    {156,  40, 181},     {158,  39, 185},     {161,  37, 189},     {163,  36, 193},
    { 92,  76,  63},     { 94,  75,  67},     { 97,  73,  71},     { 99,  72,  75},
    {102,  71,  79},     {104,  69,  83},     {106,  68,  87},     {109,  67,  91},
    {111,  65,  95},     {114,  64, 100},     {116,  62, 104},     {119,  61, 108},
    {121,  60, 112},     {124,  58, 116},     {126,  57, 120},     {129,  55, 124},
    {131,  54, 128},     {134,  53, 132},     {136,  51, 137},     {138,  50, 141},
    {141,  48, 145},     {143,  47, 149},     {146,  46, 153},     {148,  44, 157},
    {151,  43, 161},     {153,  42, 165},     {156,  40, 169},     {158,  39, 174},
    {161,  37, 178},     {163,  36, 182},     {166,  35, 186},     {168,  33, 190},
    { 97,  74,  59},     { 99,  72,  63},     {101,  71,  67},     {104,  69,  71},
    {106,  68,  76},     {109,  67,  80},     {111,  65,  84},     {114,  64,  88},
    {116,  62,  92},     {119,  61,  96},     {121,  60, 100},     {124,  58, 104},
    {126,  57, 108},     {129,  55, 113},     {131,  54, 117},     {133,  53, 121},
    {136,  51, 125},     {138,  50, 129},     {141,  49, 133},     {143,  47, 137},
    {146,  46, 141},     {148,  44, 145},     {151,  43, 150},     {153,  42, 154},
    {156,  40, 158},     {158,  39, 162},     {161,  37, 166},     {163,  36, 170},
    {165,  35, 174},     {168,  33, 178},     {170,  32, 182},     {173,  30, 187},
    {101,  71,  56},     {104,  69,  60},     {106,  68,  64},     {109,  67,  68},
    {111,  65,  72},     {114,  64,  76},     {116,  62,  80},     {119,  61,  84},
    {121,  60,  89},     {124,  58,  93},     {126,  57,  97},     {128,  56, 101},
    {131,  54, 105},     {133,  53, 109},     {136,  51, 113},     {138,  50, 117},
    {141,  49, 121},     {143,  47, 126},     {146,  46, 130},     {148,  44, 134},
    {151,  43, 138},     {153,  42, 142},     {156,  40, 146},     {158,  39, 150},
    {160,  37, 154},     {163,  36, 158},     {165,  35, 163},     {168,  33, 167},
    {170,  32, 171},     {173,  31, 175},     {175,  29, 179},     {178,  28, 183},
    {106,  68,  52},     {109,  67,  56},     {111,  65,  60},     {114,  64,  65},
    {116,  63,  69},     {119,  61,  73},     {121,  60,  77},     {123,  58,  81},
    {126,  57,  85},     {128,  56,  89},     {131,  54,  93},     {133,  53,  97},
    {136,  51, 102},     {138,  50, 106},     {141,  49, 110},     {143,  47, 114},
    {146,  46, 118},     {148,  44, 122},     {150,  43, 126},     {153,  42, 130},
    {155,  40, 134},     {158,  39, 139},     {160,  38, 143},     {163,  36, 147},
    {165,  35, 151},     {168,  33, 155},     {170,  32, 159},     {173,  31, 163},
    {175,  29, 167},     {178,  28, 171},     {180,  26, 176},     {182,  25, 180},
    {111,  65,  49},     {114,  64,  53},     {116,  63,  57},     {118,  61,  61},
    {121,  60,  65},     {123,  58,  69},     {126,  57,  73},     {128,  56,  78},
    {131,  54,  82},     {133,  53,  86},     {136,  51,  90},     {138,  50,  94},
    {141,  49,  98},     {143,  47, 102},     {145,  46, 106},     {148,  45, 110},
    {150,  43, 115},     {153,  42, 119},     {155,  40, 123},     {158,  39, 127},
    {160,  38, 131},     {163,  36, 135},     {165,  35, 139},     {168,  33, 143},
    {170,  32, 147},     {173,  31, 152},     {175,  29, 156},     {177,  28, 160},
    {180,  26, 164},     {182,  25, 168},     {185,  24, 172},     {187,  22, 176},
    {116,  63,  45},     {118,  61,  49},     {121,  60,  54},     {123,  58,  58},
    {126,  57,  62},     {128,  56,  66},     {131,  54,  70},     {133,  53,  74},
    {136,  52,  78},     {138,  50,  82},     {140,  49,  86},     {143,  47,  91},
    {145,  46,  95},     {148,  45,  99},     {150,  43, 103},     {153,  42, 107},
    {155,  40, 111},     {158,  39, 115},     {160,  38, 119},     {163,  36, 123},
    {165,  35, 128},     {168,  33, 132},     {170,  32, 136},     {172,  31, 140},
    {175,  29, 144},     {177,  28, 148},     {180,  27, 152},     {182,  25, 156},
    {185,  24, 160},     {187,  22, 165},     {190,  21, 169},     {192,  20, 173},
    {121,  60,  42},     {123,  59,  46},     {126,  57,  50},     {128,  56,  54},
    {131,  54,  58},     {133,  53,  62},     {135,  52,  67},     {138,  50,  71},
    {140,  49,  75},     {143,  47,  79},     {145,  46,  83},     {148,  45,  87},
    {150,  43,  91},     {153,  42,  95},     {155,  40,  99},     {158,  39, 104},
    {160,  38, 108},     {163,  36, 112},     {165,  35, 116},     {167,  34, 120},
    {170,  32, 124},     {172,  31, 128},     {175,  29, 132},     {177,  28, 136},
    {180,  27, 141},     {182,  25, 145},     {185,  24, 149},     {187,  22, 153},
    {190,  21, 157},     {192,  20, 161},     {194,  18, 165},     {197,  17, 169},
    {126,  57,  38},     {128,  56,  43},     {130,  54,  47},     {133,  53,  51},
    {135,  52,  55},     {138,  50,  59},     {140,  49,  63},     {143,  47,  67},
    {145,  46,  71},     {148,  45,  75},     {150,  43,  80},     {153,  42,  84},
    {155,  41,  88},     {158,  39,  92},     {160,  38,  96},     {162,  36, 100},
    {165,  35, 104},     {167,  34, 108},     {170,  32, 112},     {172,  31, 117},
    {175,  29, 121},     {177,  28, 125},     {180,  27, 129},     {182,  25, 133},
    {185,  24, 137},     {187,  22, 141},     {189,  21, 145},     {192,  20, 149},
    {194,  18, 154},     {197,  17, 158},     {199,  16, 162},     {202,  14, 166},
    {130,  54,  35},     {133,  53,  39},     {135,  52,  43},     {138,  50,  47},
    {140,  49,  51},     {143,  48,  56},     {145,  46,  60},     {148,  45,  64},
    {150,  43,  68},     {153,  42,  72},     {155,  41,  76},     {157,  39,  80},
    {160,  38,  84},     {162,  36,  88},     {165,  35,  93},     {167,  34,  97},
    {170,  32, 101},     {172,  31, 105},     {175,  29, 109},     {177,  28, 113},
    {180,  27, 117},     {182,  25, 121},     {184,  24, 125},     {187,  23, 130},
    {189,  21, 134},     {192,  20, 138},     {194,  18, 142},     {197,  17, 146},
    {199,  16, 150},     {202,  14, 154},     {204,  13, 158},     {207,  11, 162},
    {135,  52,  31},     {138,  50,  36},     {140,  49,  40},     {143,  48,  44},
    {145,  46,  48},     {147,  45,  52},     {150,  43,  56},     {152,  42,  60},
    {155,  41,  64},     {157,  39,  69},     {160,  38,  73},     {162,  36,  77},
    {165,  35,  81},     {167,  34,  85},     {170,  32,  89},     {172,  31,  93},
    {175,  30,  97},     {177,  28, 101},     {179,  27, 106},     {182,  25, 110},
    {184,  24, 114},     {187,  23, 118},     {189,  21, 122},     {192,  20, 126},
    {194,  18, 130},     {197,  17, 134},     {199,  16, 138},     {202,  14, 143},
    {204,  13, 147},     {207,  11, 151},     {209,  10, 155},     {211,   9, 159},
    {140,  49,  28},     {142,  48,  32},     {145,  46,  36},     {147,  45,  40},
    {150,  43,  44},     {152,  42,  49},     {155,  41,  53},     {157,  39,  57},
    {160,  38,  61},     {162,  37,  65},     {165,  35,  69},     {167,  34,  73},
    {170,  32,  77},     {172,  31,  82},     {174,  30,  86},     {177,  28,  90},
    {179,  27,  94},     {182,  25,  98},     {184,  24, 102},     {187,  23, 106},
    {189,  21, 110},     {192,  20, 114},     {194,  18, 119},     {197,  17, 123},
    {199,  16, 127},     {202,  14, 131},     {204,  13, 135},     {206,  12, 139},
    {209,  10, 143},     {211,   9, 147},     {214,   7, 151},     {216,   6, 156},
    {145,  46,  25},     {147,  45,  29},     {150,  44,  33},     {152,  42,  37},
    {155,  41,  41},     {157,  39,  45},     {160,  38,  49},     {162,  37,  53},
    {165,  35,  58},     {167,  34,  62},     {169,  32,  66},     {172,  31,  70},
    {174,  30,  74},     {177,  28,  78},     {179,  27,  82},     {182,  25,  86},
    {184,  24,  90},     {187,  23,  95},     {189,  21,  99},     {192,  20, 103},
    {194,  19, 107},     {197,  17, 111},     {199,  16, 115},     {201,  14, 119},
    {204,  13, 123},     {206,  12, 127},     {209,  10, 132},     {211,   9, 136},
    {214,   7, 140},     {216,   6, 144},     {219,   5, 148},     {221,   3, 152},
    {150,  44,  21},     {152,  42,  25},     {155,  41,  29},     {157,  39,  33},
    {160,  38,  38},     {162,  37,  42},     {164,  35,  46},     {167,  34,  50},
    {169,  32,  54},     {172,  31,  58},     {174,  30,  62},     {177,  28,  66},
    {179,  27,  71},     {182,  26,  75},     {184,  24,  79},     {187,  23,  83},
    {189,  21,  87},     {191,  20,  91},     {194,  19,  95},     {196,  17,  99},
    {199,  16, 103},     {201,  14, 108},     {204,  13, 112},     {206,  12, 116},
    {209,  10, 120},     {211,   9, 124},     {214,   7, 128},     {216,   6, 132},
    {219,   5, 136},     {221,   3, 140},     {223,   2, 145},     {226,   0, 149},
    {  1, 132, 127},     {  3, 131, 131},     {  6, 129, 136},     {  8, 128, 140},
    { 11, 127, 144},     { 13, 125, 148},     { 16, 124, 152},     { 18, 122, 156},
    { 21, 121, 160},     { 23, 120, 164},     { 26, 118, 168},     { 28, 117, 173},
    { 30, 115, 177},     { 33, 114, 181},     { 35, 113, 185},     { 38, 111, 189},
    { 40, 110, 193},     { 43, 108, 197},     { 45, 107, 201},     { 48, 106, 205},
    { 50, 104, 210},     { 53, 103, 214},     { 55, 102, 218},     { 58, 100, 222},
    { 60,  99, 226},     { 62,  97, 230},     { 65,  96, 234},     { 67,  95, 238},
    { 70,  93, 242},     { 72,  92, 247},     { 75,  90, 251},     { 77,  89, 255},
    {  6, 129, 124},     {  8, 128, 128},     { 11, 127, 132},     { 13, 125, 136},
    { 16, 124, 140},     { 18, 122, 144},     { 21, 121, 149},     { 23, 120, 153},
    { 25, 118, 157},     { 28, 117, 161},     { 30, 115, 165},     { 33, 114, 169},
    { 35, 113, 173},     { 38, 111, 177},     { 40, 110, 181},     { 43, 109, 186},
    { 45, 107, 190},     { 48, 106, 194},     { 50, 104, 198},     { 52, 103, 202},
    { 55, 102, 206},     { 57, 100, 210},     { 60,  99, 214},     { 62,  97, 218},
    { 65,  96, 223},     { 67,  95, 227},     { 70,  93, 231},     { 72,  92, 235},
    { 75,  90, 239},     { 77,  89, 243},     { 80,  88, 247},     { 82,  86, 251},
    { 11, 127, 120},     { 13, 125, 125},     { 16, 124, 129},     { 18, 122, 133},
    { 20, 121, 137},     { 23, 120, 141},     { 25, 118, 145},     { 28, 117, 149},
    { 30, 116, 153},     { 33, 114, 157},     { 35, 113, 162},     { 38, 111, 166},
    { 40, 110, 170},     { 43, 109, 174},     { 45, 107, 178},     { 47, 106, 182},
    { 50, 104, 186},     { 52, 103, 190},     { 55, 102, 194},     { 57, 100, 199},
    { 60,  99, 203},     { 62,  97, 207},     { 65,  96, 211},     { 67,  95, 215},
    { 70,  93, 219},     { 72,  92, 223},     { 75,  91, 227},     { 77,  89, 231},
    { 79,  88, 236},     { 82,  86, 240},     { 84,  85, 244},     { 87,  84, 248},
    { 15, 124, 117},     { 18, 123, 121},     { 20, 121, 125},     { 23, 120, 129},
    { 25, 118, 133},     { 28, 117, 138},     { 30, 116, 142},     { 33, 114, 146},
    { 35, 113, 150},     { 38, 111, 154},     { 40, 110, 158},     { 42, 109, 162},
    { 45, 107, 166},     { 47, 106, 170},     { 50, 104, 175},     { 52, 103, 179},
    { 55, 102, 183},     { 57, 100, 187},     { 60,  99, 191},     { 62,  98, 195},
    { 65,  96, 199},     { 67,  95, 203},     { 70,  93, 207},     { 72,  92, 212},
    { 74,  91, 216},     { 77,  89, 220},     { 79,  88, 224},     { 82,  86, 228},
    { 84,  85, 232},     { 87,  84, 236},     { 89,  82, 240},     { 92,  81, 244},
    { 20, 121, 114},     { 23, 120, 118},     { 25, 118, 122},     { 28, 117, 126},
    { 30, 116, 130},     { 33, 114, 134},     { 35, 113, 138},     { 37, 111, 142},
    { 40, 110, 146},     { 42, 109, 151},     { 45, 107, 155},     { 47, 106, 159},
    { 50, 105, 163},     { 52, 103, 167},     { 55, 102, 171},     { 57, 100, 175},
    { 60,  99, 179},     { 62,  98, 183},     { 65,  96, 188},     { 67,  95, 192},
    { 69,  93, 196},     { 72,  92, 200},     { 74,  91, 204},     { 77,  89, 208},
    { 79,  88, 212},     { 82,  86, 216},     { 84,  85, 220},     { 87,  84, 225},
    { 89,  82, 229},     { 92,  81, 233},     { 94,  80, 237},     { 96,  78, 241},
    { 25, 118, 110},     { 28, 117, 114},     { 30, 116, 118},     { 32, 114, 122},
    { 35, 113, 127},     { 37, 112, 131},     { 40, 110, 135},     { 42, 109, 139},
    { 45, 107, 143},     { 47, 106, 147},     { 50, 105, 151},     { 52, 103, 155},
    { 55, 102, 159},     { 57, 100, 164},     { 60,  99, 168},     { 62,  98, 172},
    { 64,  96, 176},     { 67,  95, 180},     { 69,  93, 184},     { 72,  92, 188},
    { 74,  91, 192},     { 77,  89, 196},     { 79,  88, 201},     { 82,  87, 205},
    { 84,  85, 209},     { 87,  84, 213},     { 89,  82, 217},     { 91,  81, 221},
    { 94,  80, 225},     { 96,  78, 229},     { 99,  77, 233},     {101,  75, 238},
    { 30, 116, 107},     { 32, 114, 111},     { 35, 113, 115},     { 37, 112, 119},
    { 40, 110, 123},     { 42, 109, 127},     { 45, 107, 131},     { 47, 106, 135},
    { 50, 105, 140},     { 52, 103, 144},     { 55, 102, 148},     { 57, 100, 152},
    { 59,  99, 156},     { 62,  98, 160},     { 64,  96, 164},     { 67,  95, 168},
    { 69,  94, 172},     { 72,  92, 177},     { 74,  91, 181},     { 77,  89, 185},
    { 79,  88, 189},     { 82,  87, 193},     { 84,  85, 197},     { 86,  84, 201},
    { 89,  82, 205},     { 91,  81, 209},     { 94,  80, 214},     { 96,  78, 218},
    { 99,  77, 222},     {101,  75, 226},     {104,  74, 230},     {106,  73, 234},
    { 35, 113, 103},     { 37, 112, 107},     { 40, 110, 111},     { 42, 109, 116},
    { 45, 107, 120},     { 47, 106, 124},     { 49, 105, 128},     { 52, 103, 132},
    { 54, 102, 136},     { 57, 101, 140},     { 59,  99, 144},     { 62,  98, 148},
    { 64,  96, 153},     { 67,  95, 157},     { 69,  94, 161},     { 72,  92, 165},
    { 74,  91, 169},     { 77,  89, 173},     { 79,  88, 177},     { 81,  87, 181},
    { 84,  85, 185},     { 86,  84, 190},     { 89,  82, 194},     { 91,  81, 198},
    { 94,  80, 202},     { 96,  78, 206},     { 99,  77, 210},     {101,  76, 214},
    {104,  74, 218},     {106,  73, 222},     {109,  71, 227},     {111,  70, 231},
    { 40, 110, 100},     { 42, 109, 104},     { 44, 108, 108},     { 47, 106, 112},
    { 49, 105, 116},     { 52, 103, 120},     { 54, 102, 124},     { 57, 101, 129},
    { 59,  99, 133},     { 62,  98, 137},     { 64,  96, 141},     { 67,  95, 145},
    { 69,  94, 149},     { 72,  92, 153},     { 74,  91, 157},     { 76,  89, 161},
    { 79,  88, 166},     { 81,  87, 170},     { 84,  85, 174},     { 86,  84, 178},
    { 89,  83, 182},     { 91,  81, 186},     { 94,  80, 190},     { 96,  78, 194},
    { 99,  77, 198},     {101,  76, 203},     {104,  74, 207},     {106,  73, 211},
    {108,  71, 215},     {111,  70, 219},     {113,  69, 223},     {116,  67, 227},
    { 44, 108,  96},     { 47, 106, 100},     { 49, 105, 105},     { 52, 103, 109},
    { 54, 102, 113},     { 57, 101, 117},     { 59,  99, 121},     { 62,  98, 125},
    { 64,  96, 129},     { 67,  95, 133},     { 69,  94, 137},     { 71,  92, 142},
    { 74,  91, 146},     { 76,  90, 150},     { 79,  88, 154},     { 81,  87, 158},
    { 84,  85, 162},     { 86,  84, 166},     { 89,  83, 170},     { 91,  81, 174},
    { 94,  80, 179},     { 96,  78, 183},     { 99,  77, 187},     {101,  76, 191},
    {103,  74, 195},     {106,  73, 199},     {108,  71, 203},     {111,  70, 207},
    {113,  69, 211},     {116,  67, 216},     {118,  66, 220},     {121,  65, 224},
    { 49, 105,  93},     { 52, 103,  97},     { 54, 102, 101},     { 57, 101, 105},
    { 59,  99, 109},     { 62,  98, 113},     { 64,  97, 118},     { 66,  95, 122},
    { 69,  94, 126},     { 71,  92, 130},     { 74,  91, 134},     { 76,  90, 138},
    { 79,  88, 142},     { 81,  87, 146},     { 84,  85, 150},     { 86,  84, 155},
    { 89,  83, 159},     { 91,  81, 163},     { 93,  80, 167},     { 96,  78, 171},
    { 98,  77, 175},     {101,  76, 179},     {103,  74, 183},     {106,  73, 187},
    {108,  72, 192},     {111,  70, 196},     {113,  69, 200},     {116,  67, 204},
    {118,  66, 208},     {121,  65, 212},     {123,  63, 216},     {125,  62, 220},
    { 54, 102,  89},     { 57, 101,  94},     { 59,  99,  98},     { 61,  98, 102},
    { 64,  97, 106},     { 66,  95, 110},     { 69,  94, 114},     { 71,  92, 118},
    { 74,  91, 122},     { 76,  90, 126},     { 79,  88, 131},     { 81,  87, 135},
    { 84,  85, 139},     { 86,  84, 143},     { 88,  83, 147},     { 91,  81, 151},
    { 93,  80, 155},     { 96,  79, 159},     { 98,  77, 163},     {101,  76, 168},
    {103,  74, 172},     {106,  73, 176},     {108,  72, 180},     {111,  70, 184},
    {113,  69, 188},     {116,  67, 192},     {118,  66, 196},     {120,  65, 200},
    {123,  63, 205},     {125,  62, 209},     {128,  60, 213},     {130,  59, 217},
    { 59,  99,  86},     { 61,  98,  90},     { 64,  97,  94},     { 66,  95,  98},
    { 69,  94, 102},     { 71,  92, 107},     { 74,  91, 111},     { 76,  90, 115},
    { 79,  88, 119},     { 81,  87, 123},     { 83,  86, 127},     { 86,  84, 131},
    { 88,  83, 135},     { 91,  81, 139},     { 93,  80, 144},     { 96,  79, 148},
    { 98,  77, 152},     {101,  76, 156},     {103,  74, 160},     {106,  73, 164},
    {108,  72, 168},     {111,  70, 172},     {113,  69, 176},     {115,  67, 181},
    {118,  66, 185},     {120,  65, 189},     {123,  63, 193},     {125,  62, 197},
    {128,  61, 201},     {130,  59, 205},     {133,  58, 209},     {135,  56, 213},
    { 64,  97,  83},     { 66,  95,  87},     { 69,  94,  91},     { 71,  93,  95},
    { 74,  91,  99},     { 76,  90, 103},     { 78,  88, 107},     { 81,  87, 111},
    { 83,  86, 115},     { 86,  84, 120},     { 88,  83, 124},     { 91,  81, 128},
    { 93,  80, 132},     { 96,  79, 136},     { 98,  77, 140},     {101,  76, 144},
    {103,  74, 148},     {106,  73, 152},     {108,  72, 157},     {110,  70, 161},
    {113,  69, 165},     {115,  68, 169},     {118,  66, 173},     {120,  65, 177},
    {123,  63, 181},     {125,  62, 185},     {128,  61, 189},     {130,  59, 194},
    {133,  58, 198},     {135,  56, 202},     {137,  55, 206},     {140,  54, 210},
    { 69,  94,  79},     { 71,  93,  83},     { 73,  91,  87},     { 76,  90,  91},
    { 78,  88,  96},     { 81,  87, 100},     { 83,  86, 104},     { 86,  84, 108},
    { 88,  83, 112},     { 91,  81, 116},     { 93,  80, 120},     { 96,  79, 124},
    { 98,  77, 128},     {101,  76, 133},     {103,  75, 137},     {105,  73, 141},
    {108,  72, 145},     {110,  70, 149},     {113,  69, 153},     {115,  68, 157},
    {118,  66, 161},     {120,  65, 165},     {123,  63, 170},     {125,  62, 174},
    {128,  61, 178},     {130,  59, 182},     {132,  58, 186},     {135,  56, 190},
    {137,  55, 194},     {140,  54, 198},     {142,  52, 202},     {145,  51, 207},
    { 73,  91,  76},     { 76,  90,  80},     { 78,  88,  84},     { 81,  87,  88},
    { 83,  86,  92},     { 86,  84,  96},     { 88,  83, 100},     { 91,  82, 104},
    { 93,  80, 109},     { 96,  79, 113},     { 98,  77, 117},     {100,  76, 121},
    {103,  75, 125},     {105,  73, 129},     {108,  72, 133},     {110,  70, 137},
    {113,  69, 141},     {115,  68, 146},     {118,  66, 150},     {120,  65, 154},
    {123,  63, 158},     {125,  62, 162},     {127,  61, 166},     {130,  59, 170},
    {132,  58, 174},     {135,  57, 178},     {137,  55, 183},     {140,  54, 187},
    {142,  52, 191},     {145,  51, 195},     {147,  50, 199},     {150,  48, 203},
    { 78,  89,  72},     { 81,  87,  76},     { 83,  86,  80},     { 86,  84,  85},
    { 88,  83,  89},     { 90,  82,  93},     { 93,  80,  97},     { 95,  79, 101},
    { 98,  77, 105},     {100,  76, 109},     {103,  75, 113},     {105,  73, 117},
    {108,  72, 122},     {110,  70, 126},     {113,  69, 130},     {115,  68, 134},
    {118,  66, 138},     {120,  65, 142},     {122,  64, 146},     {125,  62, 150},
    {127,  61, 154},     {130,  59, 159},     {132,  58, 163},     {135,  57, 167},
    {137,  55, 171},     {140,  54, 175},     {142,  52, 179},     {145,  51, 183},
    {147,  50, 187},     {150,  48, 191},     {152,  47, 196},     {154,  45, 200},
    { 83,  86,  69},     { 85,  84,  73},     { 88,  83,  77},     { 90,  82,  81},
    { 93,  80,  85},     { 95,  79,  89},     { 98,  77,  93},     {100,  76,  98},
    {103,  75, 102},     {105,  73, 106},     {108,  72, 110},     {110,  71, 114},
    {113,  69, 118},     {115,  68, 122},     {117,  66, 126},     {120,  65, 130},
    {122,  64, 135},     {125,  62, 139},     {127,  61, 143},     {130,  59, 147},
    {132,  58, 151},     {135,  57, 155},     {137,  55, 159},     {140,  54, 163},
    {142,  52, 167},     {145,  51, 172},     {147,  50, 176},     {149,  48, 180},
    {152,  47, 184},     {154,  46, 188},     {157,  44, 192},     {159,  43, 196},
    { 88,  83,  65},     { 90,  82,  69},     { 93,  80,  74},     { 95,  79,  78},
    { 98,  78,  82},     {100,  76,  86},     {103,  75,  90},     {105,  73,  94},
    {108,  72,  98},     {110,  71, 102},     {112,  69, 106},     {115,  68, 111},
    {117,  66, 115},     {120,  65, 119},     {122,  64, 123},     {125,  62, 127},
    {127,  61, 131},     {130,  59, 135},     {132,  58, 139},     {135,  57, 143},
    {137,  55, 148},     {140,  54, 152},     {142,  53, 156},     {144,  51, 160},
    {147,  50, 164},     {149,  48, 168},     {152,  47, 172},     {154,  46, 176},
    {157,  44, 180},     {159,  43, 185},     {162,  41, 189},     {164,  40, 193},
    { 93,  80,  62},     { 95,  79,  66},     { 98,  78,  70},     {100,  76,  74},
    {103,  75,  78},     {105,  73,  82},     {107,  72,  87},     {110,  71,  91},
    {112,  69,  95},     {115,  68,  99},     {117,  66, 103},     {120,  65, 107},
    {122,  64, 111},     {125,  62, 115},     {127,  61, 119},     {130,  60, 124},
    {132,  58, 128},     {134,  57, 132},     {137,  55, 136},     {139,  54, 140},
    {142,  53, 144},     {144,  51, 148},     {147,  50, 152},     {149,  48, 156},
    {152,  47, 161},     {154,  46, 165},     {157,  44, 169},     {159,  43, 173},
    {162,  41, 177},     {164,  40, 181},     {166,  39, 185},     {169,  37, 189},
    { 98,  78,  58},     {100,  76,  63},     {102,  75,  67},     {105,  73,  71},
    {107,  72,  75},     {110,  71,  79},     {112,  69,  83},     {115,  68,  87},
    {117,  67,  91},     {120,  65,  95},     {122,  64, 100},     {125,  62, 104},
    {127,  61, 108},     {129,  60, 112},     {132,  58, 116},     {134,  57, 120},
    {137,  55, 124},     {139,  54, 128},     {142,  53, 132},     {144,  51, 137},
    {147,  50, 141},     {149,  48, 145},     {152,  47, 149},     {154,  46, 153},
    {157,  44, 157},     {159,  43, 161},     {161,  42, 165},     {164,  40, 169},
    {166,  39, 174},     {169,  37, 178},     {171,  36, 182},     {174,  35, 186},
    {102,  75,  55},     {105,  74,  59},     {107,  72,  63},     {110,  71,  67},
    {112,  69,  71},     {115,  68,  76},     {117,  67,  80},     {120,  65,  84},
    {122,  64,  88},     {124,  62,  92},     {127,  61,  96},     {129,  60, 100},
    {132,  58, 104},     {134,  57, 108},     {137,  55, 113},     {139,  54, 117},
    {142,  53, 121},     {144,  51, 125},     {147,  50, 129},     {149,  49, 133},
    {152,  47, 137},     {154,  46, 141},     {156,  44, 145},     {159,  43, 150},
    {161,  42, 154},     {164,  40, 158},     {166,  39, 162},     {169,  37, 166},
    {171,  36, 170},     {174,  35, 174},     {176,  33, 178},     {179,  32, 182},
    {107,  72,  52},     {110,  71,  56},     {112,  69,  60},     {115,  68,  64},
    {117,  67,  68},     {119,  65,  72},     {122,  64,  76},     {124,  62,  80},
    {127,  61,  84},     {129,  60,  89},     {132,  58,  93},     {134,  57,  97},
    {137,  56, 101},     {139,  54, 105},     {142,  53, 109},     {144,  51, 113},
    {147,  50, 117},     {149,  49, 121},     {151,  47, 126},     {154,  46, 130},
    {156,  44, 134},     {159,  43, 138},     {161,  42, 142},     {164,  40, 146},
    {166,  39, 150},     {169,  37, 154},     {171,  36, 158},     {174,  35, 163},
    {176,  33, 167},     {178,  32, 171},     {181,  31, 175},     {183,  29, 179},
    {112,  69,  48},     {114,  68,  52},     {117,  67,  56},     {119,  65,  60},
    {122,  64,  65},     {124,  63,  69},     {127,  61,  73},     {129,  60,  77},
    {132,  58,  81},     {134,  57,  85},     {137,  56,  89},     {139,  54,  93},
    {142,  53,  97},     {144,  51, 102},     {146,  50, 106},     {149,  49, 110},
    {151,  47, 114},     {154,  46, 118},     {156,  44, 122},     {159,  43, 126},
    {161,  42, 130},     {164,  40, 134},     {166,  39, 139},     {169,  38, 143},
    {171,  36, 147},     {173,  35, 151},     {176,  33, 155},     {178,  32, 159},
    {181,  31, 163},     {183,  29, 167},     {186,  28, 171},     {188,  26, 176},
    {117,  67,  45},     {119,  65,  49},     {122,  64,  53},     {124,  63,  57},
    {127,  61,  61},     {129,  60,  65},     {132,  58,  69},     {134,  57,  73},
    {136,  56,  78},     {139,  54,  82},     {141,  53,  86},     {144,  51,  90},
    {146,  50,  94},     {149,  49,  98},     {151,  47, 102},     {154,  46, 106},
    {156,  45, 110},     {159,  43, 115},     {161,  42, 119},     {164,  40, 123},
    {166,  39, 127},     {168,  38, 131},     {171,  36, 135},     {173,  35, 139},
    {176,  33, 143},     {178,  32, 147},     {181,  31, 152},     {183,  29, 156},
    {186,  28, 160},     {188,  26, 164},     {191,  25, 168},     {193,  24, 172},
    {122,  64,  41},     {124,  63,  45},     {127,  61,  49},     {129,  60,  54},
    {131,  58,  58},     {134,  57,  62},     {136,  56,  66},     {139,  54,  70},
    {141,  53,  74},     {144,  52,  78},     {146,  50,  82},     {149,  49,  86},
    {151,  47,  91},     {154,  46,  95},     {156,  45,  99},     {159,  43, 103},
    {161,  42, 107},     {163,  40, 111},     {166,  39, 115},     {168,  38, 119},
    {171,  36, 123},     {173,  35, 128},     {176,  33, 132},     {178,  32, 136},
    {181,  31, 140},     {183,  29, 144},     {186,  28, 148},     {188,  27, 152},
    {191,  25, 156},     {193,  24, 160},     {195,  22, 165},     {198,  21, 169},
    {126,  61,  38},     {129,  60,  42},     {131,  59,  46},     {134,  57,  50},
    {136,  56,  54},     {139,  54,  58},     {141,  53,  62},     {144,  52,  67},
    {146,  50,  71},     {149,  49,  75},     {151,  47,  79},     {154,  46,  83},
    {156,  45,  87},     {158,  43,  91},     {161,  42,  95},     {163,  40,  99},
    {166,  39, 104},     {168,  38, 108},     {171,  36, 112},     {173,  35, 116},
    {176,  34, 120},     {178,  32, 124},     {181,  31, 128},     {183,  29, 132},
    {186,  28, 136},     {188,  27, 141},     {190,  25, 145},     {193,  24, 149},
    {195,  22, 153},     {198,  21, 157},     {200,  20, 161},     {203,  18, 165},
    {131,  59,  34},     {134,  57,  38},     {136,  56,  43},     {139,  54,  47},
    {141,  53,  51},     {144,  52,  55},     {146,  50,  59},     {149,  49,  63},
    {151,  47,  67},     {153,  46,  71},     {156,  45,  75},     {158,  43,  80},
    {161,  42,  84},     {163,  41,  88},     {166,  39,  92},     {168,  38,  96},
    {171,  36, 100},     {173,  35, 104},     {176,  34, 108},     {178,  32, 112},
    {180,  31, 117},     {183,  29, 121},     {185,  28, 125},     {188,  27, 129},
    {190,  25, 133},     {193,  24, 137},     {195,  22, 141},     {198,  21, 145},
    {200,  20, 149},     {203,  18, 154},     {205,  17, 158},     {208,  16, 162},
    {136,  56,  31},     {139,  54,  35},     {141,  53,  39},     {144,  52,  43},
    {146,  50,  47},     {148,  49,  51},     {151,  48,  56},     {153,  46,  60},
    {156,  45,  64},     {158,  43,  68},     {161,  42,  72},     {163,  41,  76},
    {166,  39,  80},     {168,  38,  84},     {171,  36,  88},     {173,  35,  93},
    {175,  34,  97},     {178,  32, 101},     {180,  31, 105},     {183,  29, 109},
    {185,  28, 113},     {188,  27, 117},     {190,  25, 121},     {193,  24, 125},
    {195,  23, 130},     {198,  21, 134},     {200,  20, 138},     {203,  18, 142},
    {205,  17, 146},     {207,  16, 150},     {210,  14, 154},     {212,  13, 158},
    {141,  53,  27},     {143,  52,  31},     {146,  50,  36},     {148,  49,  40},
    {151,  48,  44},     {153,  46,  48},     {156,  45,  52},     {158,  43,  56},
    {161,  42,  60},     {163,  41,  64},     {166,  39,  69},     {168,  38,  73},
    {170,  36,  77},     {173,  35,  81},     {175,  34,  85},     {178,  32,  89},
    {180,  31,  93},     {183,  30,  97},     {185,  28, 101},     {188,  27, 106},
    {190,  25, 110},     {193,  24, 114},     {195,  23, 118},     {198,  21, 122},
    {200,  20, 126},     {202,  18, 130},     {205,  17, 134},     {207,  16, 138},
    {210,  14, 143},     {212,  13, 147},     {215,  11, 151},     {217,  10, 155},
    {146,  50,  24},     {148,  49,  28},     {151,  48,  32},     {153,  46,  36},
    {156,  45,  40},     {158,  43,  44},     {161,  42,  49},     {163,  41,  53},
    {165,  39,  57},     {168,  38,  61},     {170,  37,  65},     {173,  35,  69},
    {175,  34,  73},     {178,  32,  77},     {180,  31,  82},     {183,  30,  86},
    {185,  28,  90},     {188,  27,  94},     {190,  25,  98},     {193,  24, 102},
    {195,  23, 106},     {197,  21, 110},     {200,  20, 114},     {202,  18, 119},
    {205,  17, 123},     {207,  16, 127},     {210,  14, 131},     {212,  13, 135},
    {215,  12, 139},     {217,  10, 143},     {220,   9, 147},     {222,   7, 151},
    {151,  48,  20},     {153,  46,  25},     {156,  45,  29},     {158,  44,  33},
    {160,  42,  37},     {163,  41,  41},     {165,  39,  45},     {168,  38,  49},
    {170,  37,  53},     {173,  35,  58},     {175,  34,  62},     {178,  32,  66},
    {180,  31,  70},     {183,  30,  74},     {185,  28,  78},     {188,  27,  82},
    {190,  25,  86},     {192,  24,  90},     {195,  23,  95},     {197,  21,  99},
    {200,  20, 103},     {202,  19, 107},     {205,  17, 111},     {207,  16, 115},
    {210,  14, 119},     {212,  13, 123},     {215,  12, 127},     {217,  10, 132},
    {219,   9, 136},     {222,   7, 140},     {224,   6, 144},     {227,   5, 148},
    {  2, 136, 127},     {  4, 135, 131},     {  7, 133, 135},     {  9, 132, 139},
    { 12, 131, 143},     { 14, 129, 147},     { 17, 128, 151},     { 19, 126, 155},
    { 22, 125, 160},     { 24, 124, 164},     { 26, 122, 168},     { 29, 121, 172},
    { 31, 120, 176},     { 34, 118, 180},     { 36, 117, 184},     { 39, 115, 188},
    { 41, 114, 192},     { 44, 113, 197},     { 46, 111, 201},     { 49, 110, 205},
    { 51, 108, 209},     { 54, 107, 213},     { 56, 106, 217},     { 58, 104, 221},
    { 61, 103, 225},     { 63, 101, 229},     { 66, 100, 234},     { 68,  99, 238},
    { 71,  97, 242},     { 73,  96, 246},     { 76,  95, 250},     { 78,  93, 254},
    {  7, 134, 123},     {  9, 132, 127},     { 12, 131, 131},     { 14, 129, 136},
    { 17, 128, 140},     { 19, 127, 144},     { 21, 125, 148},     { 24, 124, 152},
    { 26, 122, 156},     { 29, 121, 160},     { 31, 120, 164},     { 34, 118, 168},
    { 36, 117, 173},     { 39, 115, 177},     { 41, 114, 181},     { 44, 113, 185},
    { 46, 111, 189},     { 49, 110, 193},     { 51, 108, 197},     { 53, 107, 201},
    { 56, 106, 205},     { 58, 104, 210},     { 61, 103, 214},     { 63, 102, 218},
    { 66, 100, 222},     { 68,  99, 226},     { 71,  97, 230},     { 73,  96, 234},
    { 76,  95, 238},     { 78,  93, 242},     { 80,  92, 247},     { 83,  90, 251},
    { 12, 131, 120},     { 14, 129, 124},     { 16, 128, 128},     { 19, 127, 132},
    { 21, 125, 136},     { 24, 124, 140},     { 26, 122, 144},     { 29, 121, 149},
    { 31, 120, 153},     { 34, 118, 157},     { 36, 117, 161},     { 39, 115, 165},
    { 41, 114, 169},     { 44, 113, 173},     { 46, 111, 177},     { 48, 110, 181},
    { 51, 109, 186},     { 53, 107, 190},     { 56, 106, 194},     { 58, 104, 198},
    { 61, 103, 202},     { 63, 102, 206},     { 66, 100, 210},     { 68,  99, 214},
    { 71,  97, 218},     { 73,  96, 223},     { 75,  95, 227},     { 78,  93, 231},
    { 80,  92, 235},     { 83,  90, 239},     { 85,  89, 243},     { 88,  88, 247},
    { 16, 128, 116},     { 19, 127, 120},     { 21, 125, 125},     { 24, 124, 129},
    { 26, 122, 133},     { 29, 121, 137},     { 31, 120, 141},     { 34, 118, 145},
    { 36, 117, 149},     { 38, 116, 153},     { 41, 114, 157},     { 43, 113, 162},
    { 46, 111, 166},     { 48, 110, 170},     { 51, 109, 174},     { 53, 107, 178},
    { 56, 106, 182},     { 58, 104, 186},     { 61, 103, 190},     { 63, 102, 194},
    { 66, 100, 199},     { 68,  99, 203},     { 70,  97, 207},     { 73,  96, 211},
    { 75,  95, 215},     { 78,  93, 219},     { 80,  92, 223},     { 83,  91, 227},
    { 85,  89, 231},     { 88,  88, 236},     { 90,  86, 240},     { 93,  85, 244},
    { 21, 125, 113},     { 24, 124, 117},     { 26, 123, 121},     { 29, 121, 125},
    { 31, 120, 129},     { 33, 118, 133},     { 36, 117, 138},     { 38, 116, 142},
    { 41, 114, 146},     { 43, 113, 150},     { 46, 111, 154},     { 48, 110, 158},
    { 51, 109, 162},     { 53, 107, 166},     { 56, 106, 170},     { 58, 104, 175},
    { 61, 103, 179},     { 63, 102, 183},     { 65, 100, 187},     { 68,  99, 191},
    { 70,  98, 195},     { 73,  96, 199},     { 75,  95, 203},     { 78,  93, 207},
    { 80,  92, 212},     { 83,  91, 216},     { 85,  89, 220},     { 88,  88, 224},
    { 90,  86, 228},     { 93,  85, 232},     { 95,  84, 236},     { 97,  82, 240},
    { 26, 123, 109},     { 28, 121, 114},     { 31, 120, 118},     { 33, 118, 122},
    { 36, 117, 126},     { 38, 116, 130},     { 41, 114, 134},     { 43, 113, 138},
    { 46, 111, 142},     { 48, 110, 146},     { 51, 109, 151},     { 53, 107, 155},
    { 56, 106, 159},     { 58, 105, 163},     { 60, 103, 167},     { 63, 102, 171},
    { 65, 100, 175},     { 68,  99, 179},     { 70,  98, 183},     { 73,  96, 188},
    { 75,  95, 192},     { 78,  93, 196},     { 80,  92, 200},     { 83,  91, 204},
    { 85,  89, 208},     { 88,  88, 212},     { 90,  86, 216},     { 92,  85, 220},
    { 95,  84, 225},     { 97,  82, 229},     {100,  81, 233},     {102,  80, 237},
    { 31, 120, 106},     { 33, 118, 110},     { 36, 117, 114},     { 38, 116, 118},
    { 41, 114, 122},     { 43, 113, 127},     { 46, 112, 131},     { 48, 110, 135},
    { 51, 109, 139},     { 53, 107, 143},     { 55, 106, 147},     { 58, 105, 151},
    { 60, 103, 155},     { 63, 102, 159},     { 65, 100, 164},     { 68,  99, 168},
    { 70,  98, 172},     { 73,  96, 176},     { 75,  95, 180},     { 78,  93, 184},
    { 80,  92, 188},     { 82,  91, 192},     { 85,  89, 196},     { 87,  88, 201},
    { 90,  87, 205},     { 92,  85, 209},     { 95,  84, 213},     { 97,  82, 217},
    {100,  81, 221},     {102,  80, 225},     {105,  78, 229},     {107,  77, 233},
    { 36, 117, 103},     { 38, 116, 107},     { 41, 114, 111},     { 43, 113, 115},
    { 46, 112, 119},     { 48, 110, 123},     { 50, 109, 127},     { 53, 107, 131},
    { 55, 106, 135},     { 58, 105, 140},     { 60, 103, 144},     { 63, 102, 148},
    { 65, 100, 152},     { 68,  99, 156},     { 70,  98, 160},     { 73,  96, 164},
    { 75,  95, 168},     { 77,  94, 172},     { 80,  92, 177},     { 82,  91, 181},
    { 85,  89, 185},     { 87,  88, 189},     { 90,  87, 193},     { 92,  85, 197},
    { 95,  84, 201},     { 97,  82, 205},     {100,  81, 209},     {102,  80, 214},
    {105,  78, 218},     {107,  77, 222},     {109,  75, 226},     {112,  74, 230},
    { 41, 114,  99},     { 43, 113, 103},     { 45, 112, 107},     { 48, 110, 111},
    { 50, 109, 116},     { 53, 107, 120},     { 55, 106, 124},     { 58, 105, 128},
    { 60, 103, 132},     { 63, 102, 136},     { 65, 101, 140},     { 68,  99, 144},
    { 70,  98, 148},     { 72,  96, 153},     { 75,  95, 157},     { 77,  94, 161},
    { 80,  92, 165},     { 82,  91, 169},     { 85,  89, 173},     { 87,  88, 177},
    { 90,  87, 181},     { 92,  85, 185},     { 95,  84, 190},     { 97,  82, 194},
    {100,  81, 198},     {102,  80, 202},     {104,  78, 206},     {107,  77, 210},
    {109,  76, 214},     {112,  74, 218},     {114,  73, 222},     {117,  71, 227},
    { 45, 112,  96},     { 48, 110, 100},     { 50, 109, 104},     { 53, 108, 108},
    { 55, 106, 112},     { 58, 105, 116},     { 60, 103, 120},     { 63, 102, 124},
    { 65, 101, 129},     { 67,  99, 133},     { 70,  98, 137},     { 72,  96, 141},
    { 75,  95, 145},     { 77,  94, 149},     { 80,  92, 153},     { 82,  91, 157},
    { 85,  89, 161},     { 87,  88, 166},     { 90,  87, 170},     { 92,  85, 174},
    { 95,  84, 178},     { 97,  83, 182},     { 99,  81, 186},     {102,  80, 190},
    {104,  78, 194},     {107,  77, 198},     {109,  76, 203},     {112,  74, 207},
    {114,  73, 211},     {117,  71, 215},     {119,  70, 219},     {122,  69, 223},
    { 50, 109,  92},     { 53, 108,  96},     { 55, 106, 100},     { 58, 105, 105},
    { 60, 103, 109},     { 62, 102, 113},     { 65, 101, 117},     { 67,  99, 121},
    { 70,  98, 125},     { 72,  96, 129},     { 75,  95, 133},     { 77,  94, 137},
    { 80,  92, 142},     { 82,  91, 146},     { 85,  90, 150},     { 87,  88, 154},
    { 90,  87, 158},     { 92,  85, 162},     { 94,  84, 166},     { 97,  83, 170},
    { 99,  81, 174},     {102,  80, 179},     {104,  78, 183},     {107,  77, 187},
    {109,  76, 191},     {112,  74, 195},     {114,  73, 199},     {117,  71, 203},
    {119,  70, 207},     {121,  69, 211},     {124,  67, 216},     {126,  66, 220},
    { 55, 106,  89},     { 57, 105,  93},     { 60, 103,  97},     { 62, 102, 101},
    { 65, 101, 105},     { 67,  99, 109},     { 70,  98, 113},     { 72,  97, 118},
    { 75,  95, 122},     { 77,  94, 126},     { 80,  92, 130},     { 82,  91, 134},
    { 85,  90, 138},     { 87,  88, 142},     { 89,  87, 146},     { 92,  85, 150},
    { 94,  84, 155},     { 97,  83, 159},     { 99,  81, 163},     {102,  80, 167},
    {104,  78, 171},     {107,  77, 175},     {109,  76, 179},     {112,  74, 183},
    {114,  73, 187},     {116,  72, 192},     {119,  70, 196},     {121,  69, 200},
    {124,  67, 204},     {126,  66, 208},     {129,  65, 212},     {131,  63, 216},
    { 60, 104,  85},     { 62, 102,  89},     { 65, 101,  94},     { 67,  99,  98},
    { 70,  98, 102},     { 72,  97, 106},     { 75,  95, 110},     { 77,  94, 114},
    { 79,  92, 118},     { 82,  91, 122},     { 84,  90, 126},     { 87,  88, 131},
    { 89,  87, 135},     { 92,  85, 139},     { 94,  84, 143},     { 97,  83, 147},
    { 99,  81, 151},     {102,  80, 155},     {104,  79, 159},     {107,  77, 163},
    {109,  76, 168},     {111,  74, 172},     {114,  73, 176},     {116,  72, 180},
    {119,  70, 184},     {121,  69, 188},     {124,  67, 192},     {126,  66, 196},
    {129,  65, 200},     {131,  63, 205},     {134,  62, 209},     {136,  60, 213},
    { 65, 101,  82},     { 67,  99,  86},     { 70,  98,  90},     { 72,  97,  94},
    { 74,  95,  98},     { 77,  94, 102},     { 79,  92, 107},     { 82,  91, 111},
    { 84,  90, 115},     { 87,  88, 119},     { 89,  87, 123},     { 92,  86, 127},
    { 94,  84, 131},     { 97,  83, 135},     { 99,  81, 139},     {102,  80, 144},
    {104,  79, 148},     {106,  77, 152},     {109,  76, 156},     {111,  74, 160},
    {114,  73, 164},     {116,  72, 168},     {119,  70, 172},     {121,  69, 176},
    {124,  67, 181},     {126,  66, 185},     {129,  65, 189},     {131,  63, 193},
    {134,  62, 197},     {136,  61, 201},     {138,  59, 205},     {141,  58, 209},
    { 69,  98,  78},     { 72,  97,  83},     { 74,  95,  87},     { 77,  94,  91},
    { 79,  93,  95},     { 82,  91,  99},     { 84,  90, 103},     { 87,  88, 107},
    { 89,  87, 111},     { 92,  86, 115},     { 94,  84, 120},     { 97,  83, 124},
    { 99,  81, 128},     {101,  80, 132},     {104,  79, 136},     {106,  77, 140},
    {109,  76, 144},     {111,  74, 148},     {114,  73, 152},     {116,  72, 157},
    {119,  70, 161},     {121,  69, 165},     {124,  68, 169},     {126,  66, 173},
    {129,  65, 177},     {131,  63, 181},     {133,  62, 185},     {136,  61, 189},
    {138,  59, 194},     {141,  58, 198},     {143,  56, 202},     {146,  55, 206},
    { 74,  95,  75},     { 77,  94,  79},     { 79,  93,  83},     { 82,  91,  87},
    { 84,  90,  91},     { 87,  88,  96},     { 89,  87, 100},     { 92,  86, 104},
    { 94,  84, 108},     { 96,  83, 112},     { 99,  81, 116},     {101,  80, 120},
    {104,  79, 124},     {106,  77, 128},     {109,  76, 133},     {111,  75, 137},
    {114,  73, 141},     {116,  72, 145},     {119,  70, 149},     {121,  69, 153},
    {123,  68, 157},     {126,  66, 161},     {128,  65, 165},     {131,  63, 170},
    {133,  62, 174},     {136,  61, 178},     {138,  59, 182},     {141,  58, 186},
    {143,  56, 190},     {146,  55, 194},     {148,  54, 198},     {151,  52, 202},
    { 79,  93,  72},     { 82,  91,  76},     { 84,  90,  80},     { 87,  88,  84},
    { 89,  87,  88},     { 91,  86,  92},     { 94,  84,  96},     { 96,  83, 100},
    { 99,  82, 104},     {101,  80, 109},     {104,  79, 113},     {106,  77, 117},
    {109,  76, 121},     {111,  75, 125},     {114,  73, 129},     {116,  72, 133},
    {118,  70, 137},     {121,  69, 141},     {123,  68, 146},     {126,  66, 150},
    {128,  65, 154},     {131,  63, 158},     {133,  62, 162},     {136,  61, 166},
    {138,  59, 170},     {141,  58, 174},     {143,  57, 178},     {146,  55, 183},
    {148,  54, 187},     {150,  52, 191},     {153,  51, 195},     {155,  50, 199},
    { 84,  90,  68},     { 86,  89,  72},     { 89,  87,  76},     { 91,  86,  80},
    { 94,  84,  85},     { 96,  83,  89},     { 99,  82,  93},     {101,  80,  97},
    {104,  79, 101},     {106,  77, 105},     {109,  76, 109},     {111,  75, 113},
    {113,  73, 117},     {116,  72, 122},     {118,  70, 126},     {121,  69, 130},
    {123,  68, 134},     {126,  66, 138},     {128,  65, 142},     {131,  64, 146},
    {133,  62, 150},     {136,  61, 154},     {138,  59, 159},     {141,  58, 163},
    {143,  57, 167},     {145,  55, 171},     {148,  54, 175},     {150,  52, 179},
    {153,  51, 183},     {155,  50, 187},     {158,  48, 191},     {160,  47, 196},
    { 89,  87,  65},     { 91,  86,  69},     { 94,  84,  73},     { 96,  83,  77},
    { 99,  82,  81},     {101,  80,  85},     {104,  79,  89},     {106,  77,  93},
    {108,  76,  98},     {111,  75, 102},     {113,  73, 106},     {116,  72, 110},
    {118,  71, 114},     {121,  69, 118},     {123,  68, 122},     {126,  66, 126},
    {128,  65, 130},     {131,  64, 135},     {133,  62, 139},     {136,  61, 143},
    {138,  59, 147},     {140,  58, 151},     {143,  57, 155},     {145,  55, 159},
    {148,  54, 163},     {150,  52, 167},     {153,  51, 172},     {155,  50, 176},
    {158,  48, 180},     {160,  47, 184},     {163,  46, 188},     {165,  44, 192},
    { 94,  84,  61},     { 96,  83,  65},     { 99,  82,  69},     {101,  80,  74},
    {103,  79,  78},     {106,  78,  82},     {108,  76,  86},     {111,  75,  90},
    {113,  73,  94},     {116,  72,  98},     {118,  71, 102},     {121,  69, 106},
    {123,  68, 111},     {126,  66, 115},     {128,  65, 119},     {131,  64, 123},
    {133,  62, 127},     {135,  61, 131},     {138,  59, 135},     {140,  58, 139},
    {143,  57, 143},     {145,  55, 148},     {148,  54, 152},     {150,  53, 156},
    {153,  51, 160},     {155,  50, 164},     {158,  48, 168},     {160,  47, 172},
    {162,  46, 176},     {165,  44, 180},     {167,  43, 185},     {170,  41, 189},
    { 98,  82,  58},     {101,  80,  62},     {103,  79,  66},     {106,  78,  70},
    {108,  76,  74},     {111,  75,  78},     {113,  73,  82},     {116,  72,  87},
    {118,  71,  91},     {121,  69,  95},     {123,  68,  99},     {126,  66, 103},
    {128,  65, 107},     {130,  64, 111},     {133,  62, 115},     {135,  61, 119},
    {138,  60, 124},     {140,  58, 128},     {143,  57, 132},     {145,  55, 136},
    {148,  54, 140},     {150,  53, 144},     {153,  51, 148},     {155,  50, 152},
    {157,  48, 156},     {160,  47, 161},     {162,  46, 165},     {165,  44, 169},
    {167,  43, 173},     {170,  41, 177},     {172,  40, 181},     {175,  39, 185},
    {103,  79,  54},     {106,  78,  58},     {108,  76,  63},     {111,  75,  67},
    {113,  73,  71},     {116,  72,  75},     {118,  71,  79},     {120,  69,  83},
    {123,  68,  87},     {125,  67,  91},     {128,  65,  95},     {130,  64, 100},
    {133,  62, 104},     {135,  61, 108},     {138,  60, 112},     {140,  58, 116},
    {143,  57, 120},     {145,  55, 124},     {148,  54, 128},     {150,  53, 132},
    {152,  51, 137},     {155,  50, 141},     {157,  48, 145},     {160,  47, 149},
    {162,  46, 153},     {165,  44, 157},     {167,  43, 161},     {170,  42, 165},
    {172,  40, 169},     {175,  39, 174},     {177,  37, 178},     {180,  36, 182},
    {108,  76,  51},     {111,  75,  55},     {113,  74,  59},     {115,  72,  63},
    {118,  71,  67},     {120,  69,  71},     {123,  68,  76},     {125,  67,  80},
    {128,  65,  84},     {130,  64,  88},     {133,  62,  92},     {135,  61,  96},
    {138,  60, 100},     {140,  58, 104},     {143,  57, 108},     {145,  55, 113},
    {147,  54, 117},     {150,  53, 121},     {152,  51, 125},     {155,  50, 129},
    {157,  49, 133},     {160,  47, 137},     {162,  46, 141},     {165,  44, 145},
    {167,  43, 150},     {170,  42, 154},     {172,  40, 158},     {175,  39, 162},
    {177,  37, 166},     {179,  36, 170},     {182,  35, 174},     {184,  33, 178},
    {113,  74,  47},     {115,  72,  52},     {118,  71,  56},     {120,  69,  60},
    {123,  68,  64},     {125,  67,  68},     {128,  65,  72},     {130,  64,  76},
    {133,  62,  80},     {135,  61,  84},     {138,  60,  89},     {140,  58,  93},
    {142,  57,  97},     {145,  56, 101},     {147,  54, 105},     {150,  53, 109},
    {152,  51, 113},     {155,  50, 117},     {157,  49, 121},     {160,  47, 126},
    {162,  46, 130},     {165,  44, 134},     {167,  43, 138},     {170,  42, 142},
    {172,  40, 146},     {174,  39, 150},     {177,  37, 154},     {179,  36, 158},
    {182,  35, 163},     {184,  33, 167},     {187,  32, 171},     {189,  31, 175},
    {118,  71,  44},     {120,  69,  48},     {123,  68,  52},     {125,  67,  56},
    {128,  65,  60},     {130,  64,  65},     {133,  63,  69},     {135,  61,  73},
    {137,  60,  77},     {140,  58,  81},     {142,  57,  85},     {145,  56,  89},
    {147,  54,  93},     {150,  53,  97},     {152,  51, 102},     {155,  50, 106},
    {157,  49, 110},     {160,  47, 114},     {162,  46, 118},     {164,  44, 122},
    {167,  43, 126},     {169,  42, 130},     {172,  40, 134},     {174,  39, 139},
    {177,  38, 143},     {179,  36, 147},     {182,  35, 151},     {184,  33, 155},
    {187,  32, 159},     {189,  31, 163},     {192,  29, 167},     {194,  28, 171},
    {123,  68,  41},     {125,  67,  45},     {128,  65,  49},     {130,  64,  53},
    {132,  63,  57},     {135,  61,  61},     {137,  60,  65},     {140,  58,  69},
    {142,  57,  73},     {145,  56,  78},     {147,  54,  82},     {150,  53,  86},
    {152,  51,  90},     {155,  50,  94},     {157,  49,  98},     {159,  47, 102},
    {162,  46, 106},     {164,  45, 110},     {167,  43, 115},     {169,  42, 119},
    {172,  40, 123},     {174,  39, 127},     {177,  38, 131},     {179,  36, 135},
    {182,  35, 139},     {184,  33, 143},     {187,  32, 147},     {189,  31, 152},
    {191,  29, 156},     {194,  28, 160},     {196,  26, 164},     {199,  25, 168},
    {127,  65,  37},     {130,  64,  41},     {132,  63,  45},     {135,  61,  49},
    {137,  60,  54},     {140,  58,  58},     {142,  57,  62},     {145,  56,  66},
    {147,  54,  70},     {150,  53,  74},     {152,  52,  78},     {154,  50,  82},
    {157,  49,  86},     {159,  47,  91},     {162,  46,  95},     {164,  45,  99},
    {167,  43, 103},     {169,  42, 107},     {172,  40, 111},     {174,  39, 115},
    {177,  38, 119},     {179,  36, 123},     {182,  35, 128},     {184,  33, 132},
    {186,  32, 136},     {189,  31, 140},     {191,  29, 144},     {194,  28, 148},
    {196,  27, 152},     {199,  25, 156},     {201,  24, 160},     {204,  22, 165},
    {132,  63,  34},     {135,  61,  38},     {137,  60,  42},     {140,  59,  46},
    {142,  57,  50},     {145,  56,  54},     {147,  54,  58},     {149,  53,  62},
    {152,  52,  67},     {154,  50,  71},     {157,  49,  75},     {159,  47,  79},
    {162,  46,  83},     {164,  45,  87},     {167,  43,  91},     {169,  42,  95},
    {172,  40,  99},     {174,  39, 104},     {177,  38, 108},     {179,  36, 112},
    {181,  35, 116},     {184,  34, 120},     {186,  32, 124},     {189,  31, 128},
    {191,  29, 132},     {194,  28, 136},     {196,  27, 141},     {199,  25, 145},
    {201,  24, 149},     {204,  22, 153},     {206,  21, 157},     {208,  20, 161},
    {137,  60,  30},     {140,  59,  34},     {142,  57,  38},     {144,  56,  43},
    {147,  54,  47},     {149,  53,  51},     {152,  52,  55},     {154,  50,  59},
    {157,  49,  63},     {159,  47,  67},     {162,  46,  71},     {164,  45,  75},
    {167,  43,  80},     {169,  42,  84},     {172,  41,  88},     {174,  39,  92},
    {176,  38,  96},     {179,  36, 100},     {181,  35, 104},     {184,  34, 108},
    {186,  32, 112},     {189,  31, 117},     {191,  29, 121},     {194,  28, 125},
    {196,  27, 129},     {199,  25, 133},     {201,  24, 137},     {203,  22, 141},
    {206,  21, 145},     {208,  20, 149},     {211,  18, 154},     {213,  17, 158},
    {142,  57,  27},     {144,  56,  31},     {147,  54,  35},     {149,  53,  39},
    {152,  52,  43},     {154,  50,  47},     {157,  49,  51},     {159,  48,  56},
    {162,  46,  60},     {164,  45,  64},     {166,  43,  68},     {169,  42,  72},
    {171,  41,  76},     {174,  39,  80},     {176,  38,  84},     {179,  36,  88},
    {181,  35,  93},     {184,  34,  97},     {186,  32, 101},     {189,  31, 105},
    {191,  29, 109},     {194,  28, 113},     {196,  27, 117},     {198,  25, 121},
    {201,  24, 125},     {203,  23, 130},     {206,  21, 134},     {208,  20, 138},
    {211,  18, 142},     {213,  17, 146},     {216,  16, 150},     {218,  14, 154},
    {147,  55,  23},     {149,  53,  27},     {152,  52,  31},     {154,  50,  36},
    {157,  49,  40},     {159,  48,  44},     {161,  46,  48},     {164,  45,  52},
    {166,  43,  56},     {169,  42,  60},     {171,  41,  64},     {174,  39,  69},
    {176,  38,  73},     {179,  36,  77},     {181,  35,  81},     {184,  34,  85},
    {186,  32,  89},     {189,  31,  93},     {191,  30,  97},     {193,  28, 101},
    {196,  27, 106},     {198,  25, 110},     {201,  24, 114},     {203,  23, 118},
    {206,  21, 122},     {208,  20, 126},     {211,  18, 130},     {213,  17, 134},
    {216,  16, 138},     {218,  14, 143},     {221,  13, 147},     {223,  11, 151},
    {152,  52,  20},     {154,  50,  24},     {156,  49,  28},     {159,  48,  32},
    {161,  46,  36},     {164,  45,  40},     {166,  43,  44},     {169,  42,  49},
    {171,  41,  53},     {174,  39,  57},     {176,  38,  61},     {179,  37,  65},
    {181,  35,  69},     {184,  34,  73},     {186,  32,  77},     {188,  31,  82},
    {191,  30,  86},     {193,  28,  90},     {196,  27,  94},     {198,  25,  98},
    {201,  24, 102},     {203,  23, 106},     {206,  21, 110},     {208,  20, 114},
    {211,  18, 119},     {213,  17, 123},     {216,  16, 127},     {218,  14, 131},
    {220,  13, 135},     {223,  12, 139},     {225,  10, 143},     {228,   9, 147},
    {  3, 140, 126},     {  5, 139, 130},     {  8, 138, 134},     { 10, 136, 138},
    { 13, 135, 142},     { 15, 133, 147},     { 18, 132, 151},     { 20, 131, 155},
    { 22, 129, 159},     { 25, 128, 163},     { 27, 126, 167},     { 30, 125, 171},
    { 32, 124, 175},     { 35, 122, 179},     { 37, 121, 184},     { 40, 119, 188},
    { 42, 118, 192},     { 45, 117, 196},     { 47, 115, 200},     { 50, 114, 204},
    { 52, 113, 208},     { 54, 111, 212},     { 57, 110, 216},     { 59, 108, 221},
    { 62, 107, 225},     { 64, 106, 229},     { 67, 104, 233},     { 69, 103, 237},
    { 72, 101, 241},     { 74, 100, 245},     { 77,  99, 249},     { 79,  97, 254},
    {  8, 138, 123},     { 10, 136, 127},     { 13, 135, 131},     { 15, 133, 135},
    { 17, 132, 139},     { 20, 131, 143},     { 22, 129, 147},     { 25, 128, 151},
    { 27, 126, 155},     { 30, 125, 160},     { 32, 124, 164},     { 35, 122, 168},
    { 37, 121, 172},     { 40, 120, 176},     { 42, 118, 180},     { 45, 117, 184},
    { 47, 115, 188},     { 49, 114, 192},     { 52, 113, 197},     { 54, 111, 201},
    { 57, 110, 205},     { 59, 108, 209},     { 62, 107, 213},     { 64, 106, 217},
    { 67, 104, 221},     { 69, 103, 225},     { 72, 101, 229},     { 74, 100, 234},
    { 77,  99, 238},     { 79,  97, 242},     { 81,  96, 246},     { 84,  95, 250},
    { 12, 135, 119},     { 15, 134, 123},     { 17, 132, 127},     { 20, 131, 131},
    { 22, 129, 136},     { 25, 128, 140},     { 27, 127, 144},     { 30, 125, 148},
    { 32, 124, 152},     { 35, 122, 156},     { 37, 121, 160},     { 40, 120, 164},
    { 42, 118, 168},     { 44, 117, 173},     { 47, 115, 177},     { 49, 114, 181},
    { 52, 113, 185},     { 54, 111, 189},     { 57, 110, 193},     { 59, 108, 197},
    { 62, 107, 201},     { 64, 106, 205},     { 67, 104, 210},     { 69, 103, 214},
    { 71, 102, 218},     { 74, 100, 222},     { 76,  99, 226},     { 79,  97, 230},
    { 81,  96, 234},     { 84,  95, 238},     { 86,  93, 242},     { 89,  92, 247},
    { 17, 132, 116},     { 20, 131, 120},     { 22, 129, 124},     { 25, 128, 128},
    { 27, 127, 132},     { 30, 125, 136},     { 32, 124, 140},     { 35, 122, 144},
    { 37, 121, 149},     { 39, 120, 153},     { 42, 118, 157},     { 44, 117, 161},
    { 47, 115, 165},     { 49, 114, 169},     { 52, 113, 173},     { 54, 111, 177},
    { 57, 110, 181},     { 59, 109, 186},     { 62, 107, 190},     { 64, 106, 194},
    { 66, 104, 198},     { 69, 103, 202},     { 71, 102, 206},     { 74, 100, 210},
    { 76,  99, 214},     { 79,  97, 218},     { 81,  96, 223},     { 84,  95, 227},
    { 86,  93, 231},     { 89,  92, 235},     { 91,  90, 239},     { 94,  89, 243},
    { 22, 129, 112},     { 25, 128, 116},     { 27, 127, 120},     { 30, 125, 125},
    { 32, 124, 129},     { 34, 122, 133},     { 37, 121, 137},     { 39, 120, 141},
    { 42, 118, 145},     { 44, 117, 149},     { 47, 116, 153},     { 49, 114, 157},
    { 52, 113, 162},     { 54, 111, 166},     { 57, 110, 170},     { 59, 109, 174},
    { 61, 107, 178},     { 64, 106, 182},     { 66, 104, 186},     { 69, 103, 190},
    { 71, 102, 194},     { 74, 100, 199},     { 76,  99, 203},     { 79,  97, 207},
    { 81,  96, 211},     { 84,  95, 215},     { 86,  93, 219},     { 89,  92, 223},
    { 91,  91, 227},     { 93,  89, 231},     { 96,  88, 236},     { 98,  86, 240},
    { 27, 127, 109},     { 29, 125, 113},     { 32, 124, 117},     { 34, 123, 121},
    { 37, 121, 125},     { 39, 120, 129},     { 42, 118, 133},     { 44, 117, 138},
    { 47, 116, 142},     { 49, 114, 146},     { 52, 113, 150},     { 54, 111, 154},
    { 56, 110, 158},     { 59, 109, 162},     { 61, 107, 166},     { 64, 106, 170},
    { 66, 104, 175},     { 69, 103, 179},     { 71, 102, 183},     { 74, 100, 187},
    { 76,  99, 191},     { 79,  98, 195},     { 81,  96, 199},     { 84,  95, 203},
    { 86,  93, 207},     { 88,  92, 212},     { 91,  91, 216},     { 93,  89, 220},
    { 96,  88, 224},     { 98,  86, 228},     {101,  85, 232},     {103,  84, 236},
    { 32, 124, 105},     { 34, 123, 109},     { 37, 121, 114},     { 39, 120, 118},
    { 42, 118, 122},     { 44, 117, 126},     { 47, 116, 130},     { 49, 114, 134},
    { 51, 113, 138},     { 54, 111, 142},     { 56, 110, 146},     { 59, 109, 151},
    { 61, 107, 155},     { 64, 106, 159},     { 66, 105, 163},     { 69, 103, 167},
    { 71, 102, 171},     { 74, 100, 175},     { 76,  99, 179},     { 79,  98, 183},
    { 81,  96, 188},     { 83,  95, 192},     { 86,  93, 196},     { 88,  92, 200},
    { 91,  91, 204},     { 93,  89, 208},     { 96,  88, 212},     { 98,  86, 216},
    {101,  85, 220},     {103,  84, 225},     {106,  82, 229},     {108,  81, 233},
    { 37, 121, 102},     { 39, 120, 106},     { 42, 118, 110},     { 44, 117, 114},
    { 46, 116, 118},     { 49, 114, 122},     { 51, 113, 127},     { 54, 112, 131},
    { 56, 110, 135},     { 59, 109, 139},     { 61, 107, 143},     { 64, 106, 147},
    { 66, 105, 151},     { 69, 103, 155},     { 71, 102, 159},     { 74, 100, 164},
    { 76,  99, 168},     { 78,  98, 172},     { 81,  96, 176},     { 83,  95, 180},
    { 86,  93, 184},     { 88,  92, 188},     { 91,  91, 192},     { 93,  89, 196},
    { 96,  88, 201},     { 98,  87, 205},     {101,  85, 209},     {103,  84, 213},
    {105,  82, 217},     {108,  81, 221},     {110,  80, 225},     {113,  78, 229},
    { 41, 119,  98},     { 44, 117, 103},     { 46, 116, 107},     { 49, 114, 111},
    { 51, 113, 115},     { 54, 112, 119},     { 56, 110, 123},     { 59, 109, 127},
    { 61, 107, 131},     { 64, 106, 135},     { 66, 105, 140},     { 68, 103, 144},
    { 71, 102, 148},     { 73, 100, 152},     { 76,  99, 156},     { 78,  98, 160},
    { 81,  96, 164},     { 83,  95, 168},     { 86,  94, 172},     { 88,  92, 177},
    { 91,  91, 181},     { 93,  89, 185},     { 96,  88, 189},     { 98,  87, 193},
    {100,  85, 197},     {103,  84, 201},     {105,  82, 205},     {108,  81, 209},
    {110,  80, 214},     {113,  78, 218},     {115,  77, 222},     {118,  75, 226},
    { 46, 116,  95},     { 49, 114,  99},     { 51, 113, 103},     { 54, 112, 107},
    { 56, 110, 111},     { 59, 109, 116},     { 61, 107, 120},     { 63, 106, 124},
    { 66, 105, 128},     { 68, 103, 132},     { 71, 102, 136},     { 73, 101, 140},
    { 76,  99, 144},     { 78,  98, 148},     { 81,  96, 153},     { 83,  95, 157},
    { 86,  94, 161},     { 88,  92, 165},     { 91,  91, 169},     { 93,  89, 173},
    { 95,  88, 177},     { 98,  87, 181},     {100,  85, 185},     {103,  84, 190},
    {105,  82, 194},     {108,  81, 198},     {110,  80, 202},     {113,  78, 206},
    {115,  77, 210},     {118,  76, 214},     {120,  74, 218},     {123,  73, 222},
    { 51, 113,  92},     { 54, 112,  96},     { 56, 110, 100},     { 58, 109, 104},
    { 61, 108, 108},     { 63, 106, 112},     { 66, 105, 116},     { 68, 103, 120},
    { 71, 102, 124},     { 73, 101, 129},     { 76,  99, 133},     { 78,  98, 137},
    { 81,  96, 141},     { 83,  95, 145},     { 86,  94, 149},     { 88,  92, 153},
    { 90,  91, 157},     { 93,  89, 161},     { 95,  88, 166},     { 98,  87, 170},
    {100,  85, 174},     {103,  84, 178},     {105,  83, 182},     {108,  81, 186},
    {110,  80, 190},     {113,  78, 194},     {115,  77, 198},     {118,  76, 203},
    {120,  74, 207},     {122,  73, 211},     {125,  71, 215},     {127,  70, 219},
    { 56, 110,  88},     { 58, 109,  92},     { 61, 108,  96},     { 63, 106, 100},
    { 66, 105, 105},     { 68, 103, 109},     { 71, 102, 113},     { 73, 101, 117},
    { 76,  99, 121},     { 78,  98, 125},     { 81,  96, 129},     { 83,  95, 133},
    { 85,  94, 137},     { 88,  92, 142},     { 90,  91, 146},     { 93,  90, 150},
    { 95,  88, 154},     { 98,  87, 158},     {100,  85, 162},     {103,  84, 166},
    {105,  83, 170},     {108,  81, 174},     {110,  80, 179},     {112,  78, 183},
    {115,  77, 187},     {117,  76, 191},     {120,  74, 195},     {122,  73, 199},
    {125,  71, 203},     {127,  70, 207},     {130,  69, 211},     {132,  67, 216},
    { 61, 108,  85},     { 63, 106,  89},     { 66, 105,  93},     { 68, 103,  97},
    { 71, 102, 101},     { 73, 101, 105},     { 76,  99, 109},     { 78,  98, 113},
    { 80,  97, 118},     { 83,  95, 122},     { 85,  94, 126},     { 88,  92, 130},
    { 90,  91, 134},     { 93,  90, 138},     { 95,  88, 142},     { 98,  87, 146},
    {100,  85, 150},     {103,  84, 155},     {105,  83, 159},     {107,  81, 163},
    {110,  80, 167},     {112,  78, 171},     {115,  77, 175},     {117,  76, 179},
    {120,  74, 183},     {122,  73, 187},     {125,  72, 192},     {127,  70, 196},
    {130,  69, 200},     {132,  67, 204},     {135,  66, 208},     {137,  65, 212},
    { 66, 105,  81},     { 68, 104,  85},     { 71, 102,  89},     { 73, 101,  94},
    { 75,  99,  98},     { 78,  98, 102},     { 80,  97, 106},     { 83,  95, 110},
    { 85,  94, 114},     { 88,  92, 118},     { 90,  91, 122},     { 93,  90, 126},
    { 95,  88, 131},     { 98,  87, 135},     {100,  85, 139},     {102,  84, 143},
    {105,  83, 147},     {107,  81, 151},     {110,  80, 155},     {112,  79, 159},
    {115,  77, 163},     {117,  76, 168},     {120,  74, 172},     {122,  73, 176},
    {125,  72, 180},     {127,  70, 184},     {130,  69, 188},     {132,  67, 192},
    {134,  66, 196},     {137,  65, 200},     {139,  63, 205},     {142,  62, 209},
    { 70, 102,  78},     { 73, 101,  82},     { 75,  99,  86},     { 78,  98,  90},
    { 80,  97,  94},     { 83,  95,  98},     { 85,  94, 102},     { 88,  92, 107},
    { 90,  91, 111},     { 93,  90, 115},     { 95,  88, 119},     { 97,  87, 123},
    {100,  86, 127},     {102,  84, 131},     {105,  83, 135},     {107,  81, 139},
    {110,  80, 144},     {112,  79, 148},     {115,  77, 152},     {117,  76, 156},
    {120,  74, 160},     {122,  73, 164},     {125,  72, 168},     {127,  70, 172},
    {129,  69, 176},     {132,  67, 181},     {134,  66, 185},     {137,  65, 189},
    {139,  63, 193},     {142,  62, 197},     {144,  61, 201},     {147,  59, 205},
    { 75,  99,  74},     { 78,  98,  78},     { 80,  97,  83},     { 83,  95,  87},
    { 85,  94,  91},     { 88,  93,  95},     { 90,  91,  99},     { 92,  90, 103},
    { 95,  88, 107},     { 97,  87, 111},     {100,  86, 115},     {102,  84, 120},
    {105,  83, 124},     {107,  81, 128},     {110,  80, 132},     {112,  79, 136},
    {115,  77, 140},     {117,  76, 144},     {120,  74, 148},     {122,  73, 152},
    {124,  72, 157},     {127,  70, 161},     {129,  69, 165},     {132,  68, 169},
    {134,  66, 173},     {137,  65, 177},     {139,  63, 181},     {142,  62, 185},
    {144,  61, 189},     {147,  59, 194},     {149,  58, 198},     {151,  56, 202},
    { 80,  97,  71},     { 83,  95,  75},     { 85,  94,  79},     { 87,  93,  83},
    { 90,  91,  87},     { 92,  90,  91},     { 95,  88,  96},     { 97,  87, 100},
    {100,  86, 104},     {102,  84, 108},     {105,  83, 112},     {107,  81, 116},
    {110,  80, 120},     {112,  79, 124},     {115,  77, 128},     {117,  76, 133},
    {119,  75, 137},     {122,  73, 141},     {124,  72, 145},     {127,  70, 149},
    {129,  69, 153},     {132,  68, 157},     {134,  66, 161},     {137,  65, 165},
    {139,  63, 170},     {142,  62, 174},     {144,  61, 178},     {146,  59, 182},
    {149,  58, 186},     {151,  56, 190},     {154,  55, 194},     {156,  54, 198},
    { 85,  94,  67},     { 87,  93,  72},     { 90,  91,  76},     { 92,  90,  80},
    { 95,  88,  84},     { 97,  87,  88},     {100,  86,  92},     {102,  84,  96},
    {105,  83, 100},     {107,  82, 104},     {109,  80, 109},     {112,  79, 113},
    {114,  77, 117},     {117,  76, 121},     {119,  75, 125},     {122,  73, 129},
    {124,  72, 133},     {127,  70, 137},     {129,  69, 141},     {132,  68, 146},
    {134,  66, 150},     {137,  65, 154},     {139,  63, 158},     {141,  62, 162},
    {144,  61, 166},     {146,  59, 170},     {149,  58, 174},     {151,  57, 178},
    {154,  55, 183},     {156,  54, 187},     {159,  52, 191},     {161,  51, 195},
    { 90,  91,  64},     { 92,  90,  68},     { 95,  89,  72},     { 97,  87,  76},
    {100,  86,  80},     {102,  84,  85},     {104,  83,  89},     {107,  82,  93},
    {109,  80,  97},     {112,  79, 101},     {114,  77, 105},     {117,  76, 109},
    {119,  75, 113},     {122,  73, 117},     {124,  72, 122},     {127,  70, 126},
    {129,  69, 130},     {132,  68, 134},     {134,  66, 138},     {136,  65, 142},
    {139,  64, 146},     {141,  62, 150},     {144,  61, 154},     {146,  59, 159},
    {149,  58, 163},     {151,  57, 167},     {154,  55, 171},     {156,  54, 175},
    {159,  52, 179},     {161,  51, 183},     {164,  50, 187},     {166,  48, 191},
    { 95,  89,  61},     { 97,  87,  65},     { 99,  86,  69},     {102,  84,  73},
    {104,  83,  77},     {107,  82,  81},     {109,  80,  85},     {112,  79,  89},
    {114,  77,  93},     {117,  76,  98},     {119,  75, 102},     {122,  73, 106},
    {124,  72, 110},     {127,  71, 114},     {129,  69, 118},     {131,  68, 122},
    {134,  66, 126},     {136,  65, 130},     {139,  64, 135},     {141,  62, 139},
    {144,  61, 143},     {146,  59, 147},     {149,  58, 151},     {151,  57, 155},
    {154,  55, 159},     {156,  54, 163},     {159,  52, 167},     {161,  51, 172},
    {163,  50, 176},     {166,  48, 180},     {168,  47, 184},     {171,  46, 188},
    { 99,  86,  57},     {102,  84,  61},     {104,  83,  65},     {107,  82,  69},
    {109,  80,  74},     {112,  79,  78},     {114,  78,  82},     {117,  76,  86},
    {119,  75,  90},     {122,  73,  94},     {124,  72,  98},     {126,  71, 102},
    {129,  69, 106},     {131,  68, 111},     {134,  66, 115},     {136,  65, 119},
    {139,  64, 123},     {141,  62, 127},     {144,  61, 131},     {146,  59, 135},
    {149,  58, 139},     {151,  57, 143},     {153,  55, 148},     {156,  54, 152},
    {158,  53, 156},     {161,  51, 160},     {163,  50, 164},     {166,  48, 168},
    {168,  47, 172},     {171,  46, 176},     {173,  44, 180},     {176,  43, 185},
    {104,  83,  54},     {107,  82,  58},     {109,  80,  62},     {112,  79,  66},
    {114,  78,  70},     {117,  76,  74},     {119,  75,  78},     {121,  73,  82},
    {124,  72,  87},     {126,  71,  91},     {129,  69,  95},     {131,  68,  99},
    {134,  66, 103},     {136,  65, 107},     {139,  64, 111},     {141,  62, 115},
    {144,  61, 119},     {146,  60, 124},     {148,  58, 128},     {151,  57, 132},
    {153,  55, 136},     {156,  54, 140},     {158,  53, 144},     {161,  51, 148},
    {163,  50, 152},     {166,  48, 156},     {168,  47, 161},     {171,  46, 165},
    {173,  44, 169},     {176,  43, 173},     {178,  41, 177},     {180,  40, 181},
    {109,  80,  50},     {112,  79,  54},     {114,  78,  58},     {116,  76,  63},
    {119,  75,  67},     {121,  73,  71},     {124,  72,  75},     {126,  71,  79},
    {129,  69,  83},     {131,  68,  87},     {134,  67,  91},     {136,  65,  95},
    {139,  64, 100},     {141,  62, 104},     {143,  61, 108},     {146,  60, 112},
    {148,  58, 116},     {151,  57, 120},     {153,  55, 124},     {156,  54, 128},
    {158,  53, 132},     {161,  51, 137},     {163,  50, 141},     {166,  48, 145},
    {168,  47, 149},     {171,  46, 153},     {173,  44, 157},     {175,  43, 161},
    {178,  42, 165},     {180,  40, 169},     {183,  39, 174},     {185,  37, 178},
    {114,  78,  47},     {116,  76,  51},     {119,  75,  55},     {121,  74,  59},
    {124,  72,  63},     {126,  71,  67},     {129,  69,  71},     {131,  68,  76},
    {134,  67,  80},     {136,  65,  84},     {138,  64,  88},     {141,  62,  92},
    {143,  61,  96},     {146,  60, 100},     {148,  58, 104},     {151,  57, 108},
    {153,  55, 113},     {156,  54, 117},     {158,  53, 121},     {161,  51, 125},
    {163,  50, 129},     {166,  49, 133},     {168,  47, 137},     {170,  46, 141},
    {173,  44, 145},     {175,  43, 150},     {178,  42, 154},     {180,  40, 158},
    {183,  39, 162},     {185,  37, 166},     {188,  36, 170},     {190,  35, 174},
    {119,  75,  43},     {121,  74,  47},     {124,  72,  52},     {126,  71,  56},
    {129,  69,  60},     {131,  68,  64},     {133,  67,  68},     {136,  65,  72},
    {138,  64,  76},     {141,  62,  80},     {143,  61,  84},     {146,  60,  89},
    {148,  58,  93},     {151,  57,  97},     {153,  56, 101},     {156,  54, 105},
    {158,  53, 109},     {161,  51, 113},     {163,  50, 117},     {165,  49, 121},
    {168,  47, 126},     {170,  46, 130},     {173,  44, 134},     {175,  43, 138},
    {178,  42, 142},     {180,  40, 146},     {183,  39, 150},     {185,  37, 154},
    {188,  36, 158},     {190,  35, 163},     {192,  33, 167},     {195,  32, 171},
    {124,  72,  40},     {126,  71,  44},     {128,  69,  48},     {131,  68,  52},
    {133,  67,  56},     {136,  65,  60},     {138,  64,  65},     {141,  63,  69},
    {143,  61,  73},     {146,  60,  77},     {148,  58,  81},     {151,  57,  85},
    {153,  56,  89},     {156,  54,  93},     {158,  53,  97},     {160,  51, 102},
    {163,  50, 106},     {165,  49, 110},     {168,  47, 114},     {170,  46, 118},
    {173,  44, 122},     {175,  43, 126},     {178,  42, 130},     {180,  40, 134},
    {183,  39, 139},     {185,  38, 143},     {187,  36, 147},     {190,  35, 151},
    {192,  33, 155},     {195,  32, 159},     {197,  31, 163},     {200,  29, 167},
    {128,  70,  36},     {131,  68,  41},     {133,  67,  45},     {136,  65,  49},
    {138,  64,  53},     {141,  63,  57},     {143,  61,  61},     {146,  60,  65},
    {148,  58,  69},     {150,  57,  73},     {153,  56,  78},     {155,  54,  82},
    {158,  53,  86},     {160,  51,  90},     {163,  50,  94},     {165,  49,  98},
    {168,  47, 102},     {170,  46, 106},     {173,  45, 110},     {175,  43, 115},
    {178,  42, 119},     {180,  40, 123},     {182,  39, 127},     {185,  38, 131},
    {187,  36, 135},     {190,  35, 139},     {192,  33, 143},     {195,  32, 147},
    {197,  31, 152},     {200,  29, 156},     {202,  28, 160},     {205,  26, 164},
    {133,  67,  33},     {136,  65,  37},     {138,  64,  41},     {141,  63,  45},
    {143,  61,  49},     {145,  60,  54},     {148,  58,  58},     {150,  57,  62},
    {153,  56,  66},     {155,  54,  70},     {158,  53,  74},     {160,  52,  78},
    {163,  50,  82},     {165,  49,  86},     {168,  47,  91},     {170,  46,  95},
    {173,  45,  99},     {175,  43, 103},     {177,  42, 107},     {180,  40, 111},
    {182,  39, 115},     {185,  38, 119},     {187,  36, 123},     {190,  35, 128},
    {192,  33, 132},     {195,  32, 136},     {197,  31, 140},     {200,  29, 144},
    {202,  28, 148},     {205,  27, 152},     {207,  25, 156},     {209,  24, 160},
    {138,  64,  29},     {140,  63,  34},     {143,  61,  38},     {145,  60,  42},
    {148,  59,  46},     {150,  57,  50},     {153,  56,  54},     {155,  54,  58},
    {158,  53,  62},     {160,  52,  67},     {163,  50,  71},     {165,  49,  75},
    {168,  47,  79},     {170,  46,  83},     {172,  45,  87},     {175,  43,  91},
    {177,  42,  95},     {180,  40,  99},     {182,  39, 104},     {185,  38, 108},
    {187,  36, 112},     {190,  35, 116},     {192,  34, 120},     {195,  32, 124},
    {197,  31, 128},     {200,  29, 132},     {202,  28, 136},     {204,  27, 141},
    {207,  25, 145},     {209,  24, 149},     {212,  22, 153},     {214,  21, 157},
    {143,  61,  26},     {145,  60,  30},     {148,  59,  34},     {150,  57,  38},
    {153,  56,  43},     {155,  54,  47},     {158,  53,  51},     {160,  52,  55},
    {163,  50,  59},     {165,  49,  63},     {167,  47,  67},     {170,  46,  71},
    {172,  45,  75},     {175,  43,  80},     {177,  42,  84},     {180,  41,  88},
    {182,  39,  92},     {185,  38,  96},     {187,  36, 100},     {190,  35, 104},
    {192,  34, 108},     {194,  32, 112},     {197,  31, 117},     {199,  29, 121},
    {202,  28, 125},     {204,  27, 129},     {207,  25, 133},     {209,  24, 137},
    {212,  22, 141},     {214,  21, 145},     {217,  20, 149},     {219,  18, 154},
    {148,  59,  23},     {150,  57,  27},     {153,  56,  31},     {155,  54,  35},
    {158,  53,  39},     {160,  52,  43},     {162,  50,  47},     {165,  49,  51},
    {167,  48,  56},     {170,  46,  60},     {172,  45,  64},     {175,  43,  68},
    {177,  42,  72},     {180,  41,  76},     {182,  39,  80},     {185,  38,  84},
    {187,  36,  88},     {189,  35,  93},     {192,  34,  97},     {194,  32, 101},
    {197,  31, 105},     {199,  29, 109},     {202,  28, 113},     {204,  27, 117},
    {207,  25, 121},     {209,  24, 125},     {212,  23, 130},     {214,  21, 134},
    {217,  20, 138},     {219,  18, 142},     {221,  17, 146},     {224,  16, 150},
    {152,  56,  19},     {155,  55,  23},     {157,  53,  27},     {160,  52,  31},
    {162,  50,  36},     {165,  49,  40},     {167,  48,  44},     {170,  46,  48},
    {172,  45,  52},     {175,  43,  56},     {177,  42,  60},     {180,  41,  64},
    {182,  39,  69},     {184,  38,  73},     {187,  36,  77},     {189,  35,  81},
    {192,  34,  85},     {194,  32,  89},     {197,  31,  93},     {199,  30,  97},
    {202,  28, 101},     {204,  27, 106},     {207,  25, 110},     {209,  24, 114},
    {212,  23, 118},     {214,  21, 122},     {216,  20, 126},     {219,  18, 130},
    {221,  17, 134},     {224,  16, 138},     {226,  14, 143},     {229,  13, 147},
    {  4, 144, 125},     {  6, 143, 129},     {  9, 142, 134},     { 11, 140, 138},
    { 14, 139, 142},     { 16, 138, 146},     { 19, 136, 150},     { 21, 135, 154},
    { 23, 133, 158},     { 26, 132, 162},     { 28, 131, 166},     { 31, 129, 171},
    { 33, 128, 175},     { 36, 126, 179},     { 38, 125, 183},     { 41, 124, 187},
    { 43, 122, 191},     { 46, 121, 195},     { 48, 119, 199},     { 50, 118, 203},
    { 53, 117, 208},     { 55, 115, 212},     { 58, 114, 216},     { 60, 112, 220},
    { 63, 111, 224},     { 65, 110, 228},     { 68, 108, 232},     { 70, 107, 236},
    { 73, 106, 240},     { 75, 104, 245},     { 78, 103, 249},     { 80, 101, 253},
    {  9, 142, 122},     { 11, 140, 126},     { 13, 139, 130},     { 16, 138, 134},
    { 18, 136, 138},     { 21, 135, 142},     { 23, 133, 147},     { 26, 132, 151},
    { 28, 131, 155},     { 31, 129, 159},     { 33, 128, 163},     { 36, 126, 167},
    { 38, 125, 171},     { 41, 124, 175},     { 43, 122, 179},     { 45, 121, 184},
    { 48, 119, 188},     { 50, 118, 192},     { 53, 117, 196},     { 55, 115, 200},
    { 58, 114, 204},     { 60, 113, 208},     { 63, 111, 212},     { 65, 110, 216},
    { 68, 108, 221},     { 70, 107, 225},     { 73, 106, 229},     { 75, 104, 233},
    { 77, 103, 237},     { 80, 101, 241},     { 82, 100, 245},     { 85,  99, 249},
    { 13, 139, 118},     { 16, 138, 123},     { 18, 136, 127},     { 21, 135, 131},
    { 23, 133, 135},     { 26, 132, 139},     { 28, 131, 143},     { 31, 129, 147},
    { 33, 128, 151},     { 36, 126, 155},     { 38, 125, 160},     { 40, 124, 164},
    { 43, 122, 168},     { 45, 121, 172},     { 48, 120, 176},     { 50, 118, 180},
    { 53, 117, 184},     { 55, 115, 188},     { 58, 114, 192},     { 60, 113, 197},
    { 63, 111, 201},     { 65, 110, 205},     { 68, 108, 209},     { 70, 107, 213},
    { 72, 106, 217},     { 75, 104, 221},     { 77, 103, 225},     { 80, 101, 229},
    { 82, 100, 234},     { 85,  99, 238},     { 87,  97, 242},     { 90,  96, 246},
    { 18, 136, 115},     { 21, 135, 119},     { 23, 134, 123},     { 26, 132, 127},
    { 28, 131, 131},     { 31, 129, 136},     { 33, 128, 140},     { 35, 127, 144},
    { 38, 125, 148},     { 40, 124, 152},     { 43, 122, 156},     { 45, 121, 160},
    { 48, 120, 164},     { 50, 118, 168},     { 53, 117, 173},     { 55, 115, 177},
    { 58, 114, 181},     { 60, 113, 185},     { 63, 111, 189},     { 65, 110, 193},
    { 67, 108, 197},     { 70, 107, 201},     { 72, 106, 205},     { 75, 104, 210},
    { 77, 103, 214},     { 80, 102, 218},     { 82, 100, 222},     { 85,  99, 226},
    { 87,  97, 230},     { 90,  96, 234},     { 92,  95, 238},     { 94,  93, 242},
    { 23, 134, 112},     { 26, 132, 116},     { 28, 131, 120},     { 30, 129, 124},
    { 33, 128, 128},     { 35, 127, 132},     { 38, 125, 136},     { 40, 124, 140},
    { 43, 122, 144},     { 45, 121, 149},     { 48, 120, 153},     { 50, 118, 157},
    { 53, 117, 161},     { 55, 115, 165},     { 57, 114, 169},     { 60, 113, 173},
    { 62, 111, 177},     { 65, 110, 181},     { 67, 109, 186},     { 70, 107, 190},
    { 72, 106, 194},     { 75, 104, 198},     { 77, 103, 202},     { 80, 102, 206},
    { 82, 100, 210},     { 85,  99, 214},     { 87,  97, 218},     { 89,  96, 223},
    { 92,  95, 227},     { 94,  93, 231},     { 97,  92, 235},     { 99,  90, 239},
    { 28, 131, 108},     { 30, 129, 112},     { 33, 128, 116},     { 35, 127, 120},
    { 38, 125, 125},     { 40, 124, 129},     { 43, 122, 133},     { 45, 121, 137},
    { 48, 120, 141},     { 50, 118, 145},     { 52, 117, 149},     { 55, 116, 153},
    { 57, 114, 157},     { 60, 113, 162},     { 62, 111, 166},     { 65, 110, 170},
    { 67, 109, 174},     { 70, 107, 178},     { 72, 106, 182},     { 75, 104, 186},
    { 77, 103, 190},     { 80, 102, 194},     { 82, 100, 199},     { 84,  99, 203},
    { 87,  97, 207},     { 89,  96, 211},     { 92,  95, 215},     { 94,  93, 219},
    { 97,  92, 223},     { 99,  91, 227},     {102,  89, 231},     {104,  88, 236},
    { 33, 128, 105},     { 35, 127, 109},     { 38, 125, 113},     { 40, 124, 117},
    { 43, 123, 121},     { 45, 121, 125},     { 47, 120, 129},     { 50, 118, 133},
    { 52, 117, 138},     { 55, 116, 142},     { 57, 114, 146},     { 60, 113, 150},
    { 62, 111, 154},     { 65, 110, 158},     { 67, 109, 162},     { 70, 107, 166},
    { 72, 106, 170},     { 75, 104, 175},     { 77, 103, 179},     { 79, 102, 183},
    { 82, 100, 187},     { 84,  99, 191},     { 87,  98, 195},     { 89,  96, 199},
    { 92,  95, 203},     { 94,  93, 207},     { 97,  92, 212},     { 99,  91, 216},
    {102,  89, 220},     {104,  88, 224},     {107,  86, 228},     {109,  85, 232},
    { 38, 125, 101},     { 40, 124, 105},     { 42, 123, 109},     { 45, 121, 114},
    { 47, 120, 118},     { 50, 118, 122},     { 52, 117, 126},     { 55, 116, 130},
    { 57, 114, 134},     { 60, 113, 138},     { 62, 111, 142},     { 65, 110, 146},
    { 67, 109, 151},     { 70, 107, 155},     { 72, 106, 159},     { 74, 105, 163},
    { 77, 103, 167},     { 79, 102, 171},     { 82, 100, 175},     { 84,  99, 179},
    { 87,  98, 183},     { 89,  96, 188},     { 92,  95, 192},     { 94,  93, 196},
    { 97,  92, 200},     { 99,  91, 204},     {101,  89, 208},     {104,  88, 212},
    {106,  86, 216},     {109,  85, 220},     {111,  84, 225},     {114,  82, 229},
    { 42, 123,  98},     { 45, 121, 102},     { 47, 120, 106},     { 50, 118, 110},
    { 52, 117, 114},     { 55, 116, 118},     { 57, 114, 122},     { 60, 113, 127},
    { 62, 112, 131},     { 65, 110, 135},     { 67, 109, 139},     { 69, 107, 143},
    { 72, 106, 147},     { 74, 105, 151},     { 77, 103, 155},     { 79, 102, 159},
    { 82, 100, 164},     { 84,  99, 168},     { 87,  98, 172},     { 89,  96, 176},
    { 92,  95, 180},     { 94,  93, 184},     { 96,  92, 188},     { 99,  91, 192},
    {101,  89, 196},     {104,  88, 201},     {106,  87, 205},     {109,  85, 209},
    {111,  84, 213},     {114,  82, 217},     {116,  81, 221},     {119,  80, 225},
    { 47, 120,  94},     { 50, 119,  98},     { 52, 117, 103},     { 55, 116, 107},
    { 57, 114, 111},     { 60, 113, 115},     { 62, 112, 119},     { 64, 110, 123},
    { 67, 109, 127},     { 69, 107, 131},     { 72, 106, 135},     { 74, 105, 140},
    { 77, 103, 144},     { 79, 102, 148},     { 82, 100, 152},     { 84,  99, 156},
    { 87,  98, 160},     { 89,  96, 164},     { 91,  95, 168},     { 94,  94, 172},
    { 96,  92, 177},     { 99,  91, 181},     {101,  89, 185},     {104,  88, 189},
    {106,  87, 193},     {109,  85, 197},     {111,  84, 201},     {114,  82, 205},
    {116,  81, 209},     {119,  80, 214},     {121,  78, 218},     {123,  77, 222},
    { 52, 117,  91},     { 54, 116,  95},     { 57, 114,  99},     { 59, 113, 103},
    { 62, 112, 107},     { 64, 110, 111},     { 67, 109, 116},     { 69, 107, 120},
    { 72, 106, 124},     { 74, 105, 128},     { 77, 103, 132},     { 79, 102, 136},
    { 82, 101, 140},     { 84,  99, 144},     { 86,  98, 148},     { 89,  96, 153},
    { 91,  95, 157},     { 94,  94, 161},     { 96,  92, 165},     { 99,  91, 169},
    {101,  89, 173},     {104,  88, 177},     {106,  87, 181},     {109,  85, 185},
    {111,  84, 190},     {114,  82, 194},     {116,  81, 198},     {118,  80, 202},
    {121,  78, 206},     {123,  77, 210},     {126,  76, 214},     {128,  74, 218},
    { 57, 115,  87},     { 59, 113,  92},     { 62, 112,  96},     { 64, 110, 100},
    { 67, 109, 104},     { 69, 108, 108},     { 72, 106, 112},     { 74, 105, 116},
    { 77, 103, 120},     { 79, 102, 124},     { 81, 101, 129},     { 84,  99, 133},
    { 86,  98, 137},     { 89,  96, 141},     { 91,  95, 145},     { 94,  94, 149},
    { 96,  92, 153},     { 99,  91, 157},     {101,  89, 161},     {104,  88, 166},
    {106,  87, 170},     {109,  85, 174},     {111,  84, 178},     {113,  83, 182},
    {116,  81, 186},     {118,  80, 190},     {121,  78, 194},     {123,  77, 198},
    {126,  76, 203},     {128,  74, 207},     {131,  73, 211},     {133,  71, 215},
    { 62, 112,  84},     { 64, 110,  88},     { 67, 109,  92},     { 69, 108,  96},
    { 72, 106, 100},     { 74, 105, 105},     { 76, 103, 109},     { 79, 102, 113},
    { 81, 101, 117},     { 84,  99, 121},     { 86,  98, 125},     { 89,  96, 129},
    { 91,  95, 133},     { 94,  94, 137},     { 96,  92, 142},     { 99,  91, 146},
    {101,  90, 150},     {104,  88, 154},     {106,  87, 158},     {108,  85, 162},
    {111,  84, 166},     {113,  83, 170},     {116,  81, 174},     {118,  80, 179},
    {121,  78, 183},     {123,  77, 187},     {126,  76, 191},     {128,  74, 195},
    {131,  73, 199},     {133,  71, 203},     {135,  70, 207},     {138,  69, 211},
    { 67, 109,  81},     { 69, 108,  85},     { 71, 106,  89},     { 74, 105,  93},
    { 76, 103,  97},     { 79, 102, 101},     { 81, 101, 105},     { 84,  99, 109},
    { 86,  98, 113},     { 89,  97, 118},     { 91,  95, 122},     { 94,  94, 126},
    { 96,  92, 130},     { 98,  91, 134},     {101,  90, 138},     {103,  88, 142},
    {106,  87, 146},     {108,  85, 150},     {111,  84, 155},     {113,  83, 159},
    {116,  81, 163},     {118,  80, 167},     {121,  78, 171},     {123,  77, 175},
    {126,  76, 179},     {128,  74, 183},     {130,  73, 187},     {133,  72, 192},
    {135,  70, 196},     {138,  69, 200},     {140,  67, 204},     {143,  66, 208},
    { 71, 106,  77},     { 74, 105,  81},     { 76, 104,  85},     { 79, 102,  89},
    { 81, 101,  94},     { 84,  99,  98},     { 86,  98, 102},     { 89,  97, 106},
    { 91,  95, 110},     { 93,  94, 114},     { 96,  92, 118},     { 98,  91, 122},
    {101,  90, 126},     {103,  88, 131},     {106,  87, 135},     {108,  85, 139},
    {111,  84, 143},     {113,  83, 147},     {116,  81, 151},     {118,  80, 155},
    {121,  79, 159},     {123,  77, 163},     {125,  76, 168},     {128,  74, 172},
    {130,  73, 176},     {133,  72, 180},     {135,  70, 184},     {138,  69, 188},
    {140,  67, 192},     {143,  66, 196},     {145,  65, 200},     {148,  63, 205},
    { 76, 104,  74},     { 79, 102,  78},     { 81, 101,  82},     { 84,  99,  86},
    { 86,  98,  90},     { 88,  97,  94},     { 91,  95,  98},     { 93,  94, 102},
    { 96,  92, 107},     { 98,  91, 111},     {101,  90, 115},     {103,  88, 119},
    {106,  87, 123},     {108,  86, 127},     {111,  84, 131},     {113,  83, 135},
    {116,  81, 139},     {118,  80, 144},     {120,  79, 148},     {123,  77, 152},
    {125,  76, 156},     {128,  74, 160},     {130,  73, 164},     {133,  72, 168},
    {135,  70, 172},     {138,  69, 176},     {140,  67, 181},     {143,  66, 185},
    {145,  65, 189},     {148,  63, 193},     {150,  62, 197},     {152,  61, 201},
    { 81, 101,  70},     { 83,  99,  74},     { 86,  98,  78},     { 88,  97,  83},
    { 91,  95,  87},     { 93,  94,  91},     { 96,  93,  95},     { 98,  91,  99},
    {101,  90, 103},     {103,  88, 107},     {106,  87, 111},     {108,  86, 115},
    {111,  84, 120},     {113,  83, 124},     {115,  81, 128},     {118,  80, 132},
    {120,  79, 136},     {123,  77, 140},     {125,  76, 144},     {128,  74, 148},
    {130,  73, 152},     {133,  72, 157},     {135,  70, 161},     {138,  69, 165},
    {140,  68, 169},     {142,  66, 173},     {145,  65, 177},     {147,  63, 181},
    {150,  62, 185},     {152,  61, 189},     {155,  59, 194},     {157,  58, 198},
    { 86,  98,  67},     { 88,  97,  71},     { 91,  95,  75},     { 93,  94,  79},
    { 96,  93,  83},     { 98,  91,  87},     {101,  90,  91},     {103,  88,  96},
    {106,  87, 100},     {108,  86, 104},     {110,  84, 108},     {113,  83, 112},
    {115,  81, 116},     {118,  80, 120},     {120,  79, 124},     {123,  77, 128},
    {125,  76, 133},     {128,  75, 137},     {130,  73, 141},     {133,  72, 145},
    {135,  70, 149},     {137,  69, 153},     {140,  68, 157},     {142,  66, 161},
    {145,  65, 165},     {147,  63, 170},     {150,  62, 174},     {152,  61, 178},
    {155,  59, 182},     {157,  58, 186},     {160,  56, 190},     {162,  55, 194},
    { 91,  95,  63},     { 93,  94,  67},     { 96,  93,  72},     { 98,  91,  76},
    {101,  90,  80},     {103,  88,  84},     {105,  87,  88},     {108,  86,  92},
    {110,  84,  96},     {113,  83, 100},     {115,  82, 104},     {118,  80, 109},
    {120,  79, 113},     {123,  77, 117},     {125,  76, 121},     {128,  75, 125},
    {130,  73, 129},     {132,  72, 133},     {135,  70, 137},     {137,  69, 141},
    {140,  68, 146},     {142,  66, 150},     {145,  65, 154},     {147,  63, 158},
    {150,  62, 162},     {152,  61, 166},     {155,  59, 170},     {157,  58, 174},
    {160,  57, 178},     {162,  55, 183},     {164,  54, 187},     {167,  52, 191},
    { 95,  93,  60},     { 98,  91,  64},     {100,  90,  68},     {103,  89,  72},
    {105,  87,  76},     {108,  86,  80},     {110,  84,  85},     {113,  83,  89},
    {115,  82,  93},     {118,  80,  97},     {120,  79, 101},     {123,  77, 105},
    {125,  76, 109},     {127,  75, 113},     {130,  73, 117},     {132,  72, 122},
    {135,  70, 126},     {137,  69, 130},     {140,  68, 134},     {142,  66, 138},
    {145,  65, 142},     {147,  64, 146},     {150,  62, 150},     {152,  61, 154},
    {155,  59, 159},     {157,  58, 163},     {159,  57, 167},     {162,  55, 171},
    {164,  54, 175},     {167,  52, 179},     {169,  51, 183},     {172,  50, 187},
    {100,  90,  56},     {103,  89,  61},     {105,  87,  65},     {108,  86,  69},
    {110,  84,  73},     {113,  83,  77},     {115,  82,  81},     {118,  80,  85},
    {120,  79,  89},     {122,  77,  93},     {125,  76,  98},     {127,  75, 102},
    {130,  73, 106},     {132,  72, 110},     {135,  71, 114},     {137,  69, 118},
    {140,  68, 122},     {142,  66, 126},     {145,  65, 130},     {147,  64, 135},
    {150,  62, 139},     {152,  61, 143},     {154,  59, 147},     {157,  58, 151},
    {159,  57, 155},     {162,  55, 159},     {164,  54, 163},     {167,  52, 167},
    {169,  51, 172},     {172,  50, 176},     {174,  48, 180},     {177,  47, 184},
    {105,  87,  53},     {108,  86,  57},     {110,  84,  61},     {113,  83,  65},
    {115,  82,  69},     {117,  80,  74},     {120,  79,  78},     {122,  78,  82},
    {125,  76,  86},     {127,  75,  90},     {130,  73,  94},     {132,  72,  98},
    {135,  71, 102},     {137,  69, 106},     {140,  68, 111},     {142,  66, 115},
    {145,  65, 119},     {147,  64, 123},     {149,  62, 127},     {152,  61, 131},
    {154,  59, 135},     {157,  58, 139},     {159,  57, 143},     {162,  55, 148},
    {164,  54, 152},     {167,  53, 156},     {169,  51, 160},     {172,  50, 164},
    {174,  48, 168},     {176,  47, 172},     {179,  46, 176},     {181,  44, 180},
    {110,  85,  50},     {112,  83,  54},     {115,  82,  58},     {117,  80,  62},
    {120,  79,  66},     {122,  78,  70},     {125,  76,  74},     {127,  75,  78},
    {130,  73,  82},     {132,  72,  87},     {135,  71,  91},     {137,  69,  95},
    {139,  68,  99},     {142,  66, 103},     {144,  65, 107},     {147,  64, 111},
    {149,  62, 115},     {152,  61, 119},     {154,  60, 124},     {157,  58, 128},
    {159,  57, 132},     {162,  55, 136},     {164,  54, 140},     {167,  53, 144},
    {169,  51, 148},     {171,  50, 152},     {174,  48, 156},     {176,  47, 161},
    {179,  46, 165},     {181,  44, 169},     {184,  43, 173},     {186,  41, 177},
    {115,  82,  46},     {117,  80,  50},     {120,  79,  54},     {122,  78,  58},
    {125,  76,  63},     {127,  75,  67},     {130,  73,  71},     {132,  72,  75},
    {134,  71,  79},     {137,  69,  83},     {139,  68,  87},     {142,  67,  91},
    {144,  65,  95},     {147,  64, 100},     {149,  62, 104},     {152,  61, 108},
    {154,  60, 112},     {157,  58, 116},     {159,  57, 120},     {162,  55, 124},
    {164,  54, 128},     {166,  53, 132},     {169,  51, 137},     {171,  50, 141},
    {174,  48, 145},     {176,  47, 149},     {179,  46, 153},     {181,  44, 157},
    {184,  43, 161},     {186,  42, 165},     {189,  40, 169},     {191,  39, 174},
    {120,  79,  43},     {122,  78,  47},     {125,  76,  51},     {127,  75,  55},
    {129,  74,  59},     {132,  72,  63},     {134,  71,  67},     {137,  69,  71},
    {139,  68,  76},     {142,  67,  80},     {144,  65,  84},     {147,  64,  88},
    {149,  62,  92},     {152,  61,  96},     {154,  60, 100},     {157,  58, 104},
    {159,  57, 108},     {161,  55, 113},     {164,  54, 117},     {166,  53, 121},
    {169,  51, 125},     {171,  50, 129},     {174,  49, 133},     {176,  47, 137},
    {179,  46, 141},     {181,  44, 145},     {184,  43, 150},     {186,  42, 154},
    {189,  40, 158},     {191,  39, 162},     {193,  37, 166},     {196,  36, 170},
    {124,  76,  39},     {127,  75,  43},     {129,  74,  47},     {132,  72,  52},
    {134,  71,  56},     {137,  69,  60},     {139,  68,  64},     {142,  67,  68},
    {144,  65,  72},     {147,  64,  76},     {149,  62,  80},     {152,  61,  84},
    {154,  60,  89},     {156,  58,  93},     {159,  57,  97},     {161,  56, 101},
    {164,  54, 105},     {166,  53, 109},     {169,  51, 113},     {171,  50, 117},
    {174,  49, 121},     {176,  47, 126},     {179,  46, 130},     {181,  44, 134},
    {183,  43, 138},     {186,  42, 142},     {188,  40, 146},     {191,  39, 150},
    {193,  37, 154},     {196,  36, 158},     {198,  35, 163},     {201,  33, 167},
    {129,  74,  36},     {132,  72,  40},     {134,  71,  44},     {137,  69,  48},
    {139,  68,  52},     {142,  67,  56},     {144,  65,  60},     {147,  64,  65},
    {149,  63,  69},     {151,  61,  73},     {154,  60,  77},     {156,  58,  81},
    {159,  57,  85},     {161,  56,  89},     {164,  54,  93},     {166,  53,  97},
    {169,  51, 102},     {171,  50, 106},     {174,  49, 110},     {176,  47, 114},
    {178,  46, 118},     {181,  44, 122},     {183,  43, 126},     {186,  42, 130},
    {188,  40, 134},     {191,  39, 139},     {193,  38, 143},     {196,  36, 147},
    {198,  35, 151},     {201,  33, 155},     {203,  32, 159},     {206,  31, 163},
    {134,  71,  32},     {137,  70,  36},     {139,  68,  41},     {142,  67,  45},
    {144,  65,  49},     {146,  64,  53},     {149,  63,  57},     {151,  61,  61},
    {154,  60,  65},     {156,  58,  69},     {159,  57,  73},     {161,  56,  78},
    {164,  54,  82},     {166,  53,  86},     {169,  51,  90},     {171,  50,  94},
    {173,  49,  98},     {176,  47, 102},     {178,  46, 106},     {181,  45, 110},
    {183,  43, 115},     {186,  42, 119},     {188,  40, 123},     {191,  39, 127},
    {193,  38, 131},     {196,  36, 135},     {198,  35, 139},     {201,  33, 143},
    {203,  32, 147},     {205,  31, 152},     {208,  29, 156},     {210,  28, 160},
    {139,  68,  29},     {141,  67,  33},     {144,  65,  37},     {146,  64,  41},
    {149,  63,  45},     {151,  61,  49},     {154,  60,  54},     {156,  58,  58},
    {159,  57,  62},     {161,  56,  66},     {164,  54,  70},     {166,  53,  74},
    {168,  52,  78},     {171,  50,  82},     {173,  49,  86},     {176,  47,  91},
    {178,  46,  95},     {181,  45,  99},     {183,  43, 103},     {186,  42, 107},
    {188,  40, 111},     {191,  39, 115},     {193,  38, 119},     {196,  36, 123},
    {198,  35, 128},     {200,  33, 132},     {203,  32, 136},     {205,  31, 140},
    {208,  29, 144},     {210,  28, 148},     {213,  27, 152},     {215,  25, 156},
    {144,  65,  25},     {146,  64,  29},     {149,  63,  34},     {151,  61,  38},
    {154,  60,  42},     {156,  59,  46},     {159,  57,  50},     {161,  56,  54},
    {163,  54,  58},     {166,  53,  62},     {168,  52,  67},     {171,  50,  71},
    {173,  49,  75},     {176,  47,  79},     {178,  46,  83},     {181,  45,  87},
    {183,  43,  91},     {186,  42,  95},     {188,  40,  99},     {191,  39, 104},
    {193,  38, 108},     {195,  36, 112},     {198,  35, 116},     {200,  34, 120},
    {203,  32, 124},     {205,  31, 128},     {208,  29, 132},     {210,  28, 136},
    {213,  27, 141},     {215,  25, 145},     {218,  24, 149},     {220,  22, 153},
    {149,  63,  22},     {151,  61,  26},     {154,  60,  30},     {156,  59,  34},
    {158,  57,  38},     {161,  56,  43},     {163,  54,  47},     {166,  53,  51},
    {168,  52,  55},     {171,  50,  59},     {173,  49,  63},     {176,  47,  67},
    {178,  46,  71},     {181,  45,  75},     {183,  43,  80},     {186,  42,  84},
    {188,  41,  88},     {190,  39,  92},     {193,  38,  96},     {195,  36, 100},
    {198,  35, 104},     {200,  34, 108},     {203,  32, 112},     {205,  31, 117},
    {208,  29, 121},     {210,  28, 125},     {213,  27, 129},     {215,  25, 133},
    {217,  24, 137},     {220,  22, 141},     {222,  21, 145},     {225,  20, 149},
    {153,  60,  18},     {156,  59,  23},     {158,  57,  27},     {161,  56,  31},
    {163,  54,  35},     {166,  53,  39},     {168,  52,  43},     {171,  50,  47},
    {173,  49,  51},     {176,  48,  56},     {178,  46,  60},     {180,  45,  64},
    {183,  43,  68},     {185,  42,  72},     {188,  41,  76},     {190,  39,  80},
    {193,  38,  84},     {195,  36,  88},     {198,  35,  93},     {200,  34,  97},
    {203,  32, 101},     {205,  31, 105},     {208,  29, 109},     {210,  28, 113},
    {212,  27, 117},     {215,  25, 121},     {217,  24, 125},     {220,  23, 130},
    {222,  21, 134},     {225,  20, 138},     {227,  18, 142},     {230,  17, 146},
    {  5, 149, 125},     {  7, 147, 129},     { 10, 146, 133},     { 12, 144, 137},
    { 15, 143, 141},     { 17, 142, 145},     { 19, 140, 149},     { 22, 139, 153},
    { 24, 137, 158},     { 27, 136, 162},     { 29, 135, 166},     { 32, 133, 170},
    { 34, 132, 174},     { 37, 130, 178},     { 39, 129, 182},     { 42, 128, 186},
    { 44, 126, 190},     { 47, 125, 195},     { 49, 124, 199},     { 51, 122, 203},
    { 54, 121, 207},     { 56, 119, 211},     { 59, 118, 215},     { 61, 117, 219},
    { 64, 115, 223},     { 66, 114, 227},     { 69, 112, 232},     { 71, 111, 236},
    { 74, 110, 240},     { 76, 108, 244},     { 78, 107, 248},     { 81, 105, 252},
    { 10, 146, 121},     { 12, 144, 125},     { 14, 143, 129},     { 17, 142, 134},
    { 19, 140, 138},     { 22, 139, 142},     { 24, 138, 146},     { 27, 136, 150},
    { 29, 135, 154},     { 32, 133, 158},     { 34, 132, 162},     { 37, 131, 166},
    { 39, 129, 171},     { 41, 128, 175},     { 44, 126, 179},     { 46, 125, 183},
    { 49, 124, 187},     { 51, 122, 191},     { 54, 121, 195},     { 56, 119, 199},
    { 59, 118, 203},     { 61, 117, 208},     { 64, 115, 212},     { 66, 114, 216},
    { 69, 112, 220},     { 71, 111, 224},     { 73, 110, 228},     { 76, 108, 232},
    { 78, 107, 236},     { 81, 106, 240},     { 83, 104, 245},     { 86, 103, 249},
    { 14, 143, 118},     { 17, 142, 122},     { 19, 140, 126},     { 22, 139, 130},
    { 24, 138, 134},     { 27, 136, 138},     { 29, 135, 142},     { 32, 133, 147},
    { 34, 132, 151},     { 36, 131, 155},     { 39, 129, 159},     { 41, 128, 163},
    { 44, 126, 167},     { 46, 125, 171},     { 49, 124, 175},     { 51, 122, 179},
    { 54, 121, 184},     { 56, 119, 188},     { 59, 118, 192},     { 61, 117, 196},
    { 64, 115, 200},     { 66, 114, 204},     { 68, 113, 208},     { 71, 111, 212},
    { 73, 110, 216},     { 76, 108, 221},     { 78, 107, 225},     { 81, 106, 229},
    { 83, 104, 233},     { 86, 103, 237},     { 88, 101, 241},     { 91, 100, 245},
    { 19, 140, 114},     { 22, 139, 118},     { 24, 138, 123},     { 27, 136, 127},
    { 29, 135, 131},     { 31, 133, 135},     { 34, 132, 139},     { 36, 131, 143},
    { 39, 129, 147},     { 41, 128, 151},     { 44, 126, 155},     { 46, 125, 160},
    { 49, 124, 164},     { 51, 122, 168},     { 54, 121, 172},     { 56, 120, 176},
    { 59, 118, 180},     { 61, 117, 184},     { 63, 115, 188},     { 66, 114, 192},
    { 68, 113, 197},     { 71, 111, 201},     { 73, 110, 205},     { 76, 108, 209},
    { 78, 107, 213},     { 81, 106, 217},     { 83, 104, 221},     { 86, 103, 225},
    { 88, 101, 229},     { 91, 100, 234},     { 93,  99, 238},     { 95,  97, 242},
    { 24, 138, 111},     { 26, 136, 115},     { 29, 135, 119},     { 31, 134, 123},
    { 34, 132, 127},     { 36, 131, 131},     { 39, 129, 136},     { 41, 128, 140},
    { 44, 127, 144},     { 46, 125, 148},     { 49, 124, 152},     { 51, 122, 156},
    { 54, 121, 160},     { 56, 120, 164},     { 58, 118, 168},     { 61, 117, 173},
    { 63, 115, 177},     { 66, 114, 181},     { 68, 113, 185},     { 71, 111, 189},
    { 73, 110, 193},     { 76, 108, 197},     { 78, 107, 201},     { 81, 106, 205},
    { 83, 104, 210},     { 85, 103, 214},     { 88, 102, 218},     { 90, 100, 222},
    { 93,  99, 226},     { 95,  97, 230},     { 98,  96, 234},     {100,  95, 238},
    { 29, 135, 107},     { 31, 134, 112},     { 34, 132, 116},     { 36, 131, 120},
    { 39, 129, 124},     { 41, 128, 128},     { 44, 127, 132},     { 46, 125, 136},
    { 49, 124, 140},     { 51, 122, 144},     { 53, 121, 149},     { 56, 120, 153},
    { 58, 118, 157},     { 61, 117, 161},     { 63, 115, 165},     { 66, 114, 169},
    { 68, 113, 173},     { 71, 111, 177},     { 73, 110, 181},     { 76, 109, 186},
    { 78, 107, 190},     { 80, 106, 194},     { 83, 104, 198},     { 85, 103, 202},
    { 88, 102, 206},     { 90, 100, 210},     { 93,  99, 214},     { 95,  97, 218},
    { 98,  96, 223},     {100,  95, 227},     {103,  93, 231},     {105,  92, 235},
    { 34, 132, 104},     { 36, 131, 108},     { 39, 129, 112},     { 41, 128, 116},
    { 43, 127, 120},     { 46, 125, 125},     { 48, 124, 129},     { 51, 122, 133},
    { 53, 121, 137},     { 56, 120, 141},     { 58, 118, 145},     { 61, 117, 149},
    { 63, 116, 153},     { 66, 114, 157},     { 68, 113, 162},     { 71, 111, 166},
    { 73, 110, 170},     { 75, 109, 174},     { 78, 107, 178},     { 80, 106, 182},
    { 83, 104, 186},     { 85, 103, 190},     { 88, 102, 194},     { 90, 100, 199},
    { 93,  99, 203},     { 95,  97, 207},     { 98,  96, 211},     {100,  95, 215},
    {103,  93, 219},     {105,  92, 223},     {107,  91, 227},     {110,  89, 231},
    { 38, 130, 101},     { 41, 128, 105},     { 43, 127, 109},     { 46, 125, 113},
    { 48, 124, 117},     { 51, 123, 121},     { 53, 121, 125},     { 56, 120, 129},
    { 58, 118, 133},     { 61, 117, 138},     { 63, 116, 142},     { 66, 114, 146},
    { 68, 113, 150},     { 70, 111, 154},     { 73, 110, 158},     { 75, 109, 162},
    { 78, 107, 166},     { 80, 106, 170},     { 83, 104, 175},     { 85, 103, 179},
    { 88, 102, 183},     { 90, 100, 187},     { 93,  99, 191},     { 95,  98, 195},
    { 98,  96, 199},     {100,  95, 203},     {102,  93, 207},     {105,  92, 212},
    {107,  91, 216},     {110,  89, 220},     {112,  88, 224},     {115,  86, 228},
    { 43, 127,  97},     { 46, 125, 101},     { 48, 124, 105},     { 51, 123, 109},
    { 53, 121, 114},     { 56, 120, 118},     { 58, 118, 122},     { 61, 117, 126},
    { 63, 116, 130},     { 65, 114, 134},     { 68, 113, 138},     { 70, 111, 142},
    { 73, 110, 146},     { 75, 109, 151},     { 78, 107, 155},     { 80, 106, 159},
    { 83, 105, 163},     { 85, 103, 167},     { 88, 102, 171},     { 90, 100, 175},
    { 93,  99, 179},     { 95,  98, 183},     { 97,  96, 188},     {100,  95, 192},
    {102,  93, 196},     {105,  92, 200},     {107,  91, 204},     {110,  89, 208},
    {112,  88, 212},     {115,  86, 216},     {117,  85, 220},     {120,  84, 225},
    { 48, 124,  94},     { 51, 123,  98},     { 53, 121, 102},     { 56, 120, 106},
    { 58, 118, 110},     { 60, 117, 114},     { 63, 116, 118},     { 65, 114, 122},
    { 68, 113, 127},     { 70, 112, 131},     { 73, 110, 135},     { 75, 109, 139},
    { 78, 107, 143},     { 80, 106, 147},     { 83, 105, 151},     { 85, 103, 155},
    { 87, 102, 159},     { 90, 100, 164},     { 92,  99, 168},     { 95,  98, 172},
    { 97,  96, 176},     {100,  95, 180},     {102,  93, 184},     {105,  92, 188},
    {107,  91, 192},     {110,  89, 196},     {112,  88, 201},     {115,  87, 205},
    {117,  85, 209},     {119,  84, 213},     {122,  82, 217},     {124,  81, 221},
    { 53, 121,  90},     { 55, 120,  94},     { 58, 119,  98},     { 60, 117, 103},
    { 63, 116, 107},     { 65, 114, 111},     { 68, 113, 115},     { 70, 112, 119},
    { 73, 110, 123},     { 75, 109, 127},     { 78, 107, 131},     { 80, 106, 135},
    { 82, 105, 140},     { 85, 103, 144},     { 87, 102, 148},     { 90, 100, 152},
    { 92,  99, 156},     { 95,  98, 160},     { 97,  96, 164},     {100,  95, 168},
    {102,  94, 172},     {105,  92, 177},     {107,  91, 181},     {110,  89, 185},
    {112,  88, 189},     {114,  87, 193},     {117,  85, 197},     {119,  84, 201},
    {122,  82, 205},     {124,  81, 209},     {127,  80, 214},     {129,  78, 218},
    { 58, 119,  87},     { 60, 117,  91},     { 63, 116,  95},     { 65, 114,  99},
    { 68, 113, 103},     { 70, 112, 107},     { 73, 110, 111},     { 75, 109, 116},
    { 77, 107, 120},     { 80, 106, 124},     { 82, 105, 128},     { 85, 103, 132},
    { 87, 102, 136},     { 90, 101, 140},     { 92,  99, 144},     { 95,  98, 148},
    { 97,  96, 153},     {100,  95, 157},     {102,  94, 161},     {105,  92, 165},
    {107,  91, 169},     {109,  89, 173},     {112,  88, 177},     {114,  87, 181},
    {117,  85, 185},     {119,  84, 190},     {122,  82, 194},     {124,  81, 198},
    {127,  80, 202},     {129,  78, 206},     {132,  77, 210},     {134,  76, 214},
    { 63, 116,  83},     { 65, 115,  87},     { 68, 113,  92},     { 70, 112,  96},
    { 72, 110, 100},     { 75, 109, 104},     { 77, 108, 108},     { 80, 106, 112},
    { 82, 105, 116},     { 85, 103, 120},     { 87, 102, 124},     { 90, 101, 129},
    { 92,  99, 133},     { 95,  98, 137},     { 97,  96, 141},     {100,  95, 145},
    {102,  94, 149},     {104,  92, 153},     {107,  91, 157},     {109,  89, 161},
    {112,  88, 166},     {114,  87, 170},     {117,  85, 174},     {119,  84, 178},
    {122,  83, 182},     {124,  81, 186},     {127,  80, 190},     {129,  78, 194},
    {131,  77, 198},     {134,  76, 203},     {136,  74, 207},     {139,  73, 211},
    { 67, 113,  80},     { 70, 112,  84},     { 72, 110,  88},     { 75, 109,  92},
    { 77, 108,  96},     { 80, 106, 100},     { 82, 105, 105},     { 85, 103, 109},
    { 87, 102, 113},     { 90, 101, 117},     { 92,  99, 121},     { 95,  98, 125},
    { 97,  96, 129},     { 99,  95, 133},     {102,  94, 137},     {104,  92, 142},
    {107,  91, 146},     {109,  90, 150},     {112,  88, 154},     {114,  87, 158},
    {117,  85, 162},     {119,  84, 166},     {122,  83, 170},     {124,  81, 174},
    {126,  80, 179},     {129,  78, 183},     {131,  77, 187},     {134,  76, 191},
    {136,  74, 195},     {139,  73, 199},     {141,  71, 203},     {144,  70, 207},
    { 72, 110,  76},     { 75, 109,  81},     { 77, 108,  85},     { 80, 106,  89},
    { 82, 105,  93},     { 85, 103,  97},     { 87, 102, 101},     { 90, 101, 105},
    { 92,  99, 109},     { 94,  98, 113},     { 97,  97, 118},     { 99,  95, 122},
    {102,  94, 126},     {104,  92, 130},     {107,  91, 134},     {109,  90, 138},
    {112,  88, 142},     {114,  87, 146},     {117,  85, 150},     {119,  84, 155},
    {121,  83, 159},     {124,  81, 163},     {126,  80, 167},     {129,  78, 171},
    {131,  77, 175},     {134,  76, 179},     {136,  74, 183},     {139,  73, 187},
    {141,  72, 192},     {144,  70, 196},     {146,  69, 200},     {149,  67, 204},
    { 77, 108,  73},     { 80, 106,  77},     { 82, 105,  81},     { 84, 104,  85},
    { 87, 102,  89},     { 89, 101,  94},     { 92,  99,  98},     { 94,  98, 102},
    { 97,  97, 106},     { 99,  95, 110},     {102,  94, 114},     {104,  92, 118},
    {107,  91, 122},     {109,  90, 126},     {112,  88, 131},     {114,  87, 135},
    {116,  85, 139},     {119,  84, 143},     {121,  83, 147},     {124,  81, 151},
    {126,  80, 155},     {129,  79, 159},     {131,  77, 163},     {134,  76, 168},
    {136,  74, 172},     {139,  73, 176},     {141,  72, 180},     {144,  70, 184},
    {146,  69, 188},     {148,  67, 192},     {151,  66, 196},     {153,  65, 200},
    { 82, 105,  70},     { 84, 104,  74},     { 87, 102,  78},     { 89, 101,  82},
    { 92,  99,  86},     { 94,  98,  90},     { 97,  97,  94},     { 99,  95,  98},
    {102,  94, 102},     {104,  92, 107},     {107,  91, 111},     {109,  90, 115},
    {111,  88, 119},     {114,  87, 123},     {116,  86, 127},     {119,  84, 131},
    {121,  83, 135},     {124,  81, 139},     {126,  80, 144},     {129,  79, 148},
    {131,  77, 152},     {134,  76, 156},     {136,  74, 160},     {139,  73, 164},
    {141,  72, 168},     {143,  70, 172},     {146,  69, 176},     {148,  67, 181},
    {151,  66, 185},     {153,  65, 189},     {156,  63, 193},     {158,  62, 197},
    { 87, 102,  66},     { 89, 101,  70},     { 92,  99,  74},     { 94,  98,  78},
    { 97,  97,  83},     { 99,  95,  87},     {102,  94,  91},     {104,  93,  95},
    {106,  91,  99},     {109,  90, 103},     {111,  88, 107},     {114,  87, 111},
    {116,  86, 115},     {119,  84, 120},     {121,  83, 124},     {124,  81, 128},
    {126,  80, 132},     {129,  79, 136},     {131,  77, 140},     {134,  76, 144},
    {136,  74, 148},     {138,  73, 152},     {141,  72, 157},     {143,  70, 161},
    {146,  69, 165},     {148,  68, 169},     {151,  66, 173},     {153,  65, 177},
    {156,  63, 181},     {158,  62, 185},     {161,  61, 189},     {163,  59, 194},
    { 92, 100,  63},     { 94,  98,  67},     { 97,  97,  71},     { 99,  95,  75},
    {101,  94,  79},     {104,  93,  83},     {106,  91,  87},     {109,  90,  91},
    {111,  88,  96},     {114,  87, 100},     {116,  86, 104},     {119,  84, 108},
    {121,  83, 112},     {124,  81, 116},     {126,  80, 120},     {128,  79, 124},
    {131,  77, 128},     {133,  76, 133},     {136,  75, 137},     {138,  73, 141},
    {141,  72, 145},     {143,  70, 149},     {146,  69, 153},     {148,  68, 157},
    {151,  66, 161},     {153,  65, 165},     {156,  63, 170},     {158,  62, 174},
    {160,  61, 178},     {163,  59, 182},     {165,  58, 186},     {168,  56, 190},
    { 96,  97,  59},     { 99,  95,  63},     {101,  94,  67},     {104,  93,  72},
    {106,  91,  76},     {109,  90,  80},     {111,  88,  84},     {114,  87,  88},
    {116,  86,  92},     {119,  84,  96},     {121,  83, 100},     {123,  82, 104},
    {126,  80, 109},     {128,  79, 113},     {131,  77, 117},     {133,  76, 121},
    {136,  75, 125},     {138,  73, 129},     {141,  72, 133},     {143,  70, 137},
    {146,  69, 141},     {148,  68, 146},     {151,  66, 150},     {153,  65, 154},
    {155,  63, 158},     {158,  62, 162},     {160,  61, 166},     {163,  59, 170},
    {165,  58, 174},     {168,  57, 178},     {170,  55, 183},     {173,  54, 187},
    {101,  94,  56},     {104,  93,  60},     {106,  91,  64},     {109,  90,  68},
    {111,  89,  72},     {114,  87,  76},     {116,  86,  80},     {118,  84,  85},
    {121,  83,  89},     {123,  82,  93},     {126,  80,  97},     {128,  79, 101},
    {131,  77, 105},     {133,  76, 109},     {136,  75, 113},     {138,  73, 117},
    {141,  72, 122},     {143,  70, 126},     {146,  69, 130},     {148,  68, 134},
    {150,  66, 138},     {153,  65, 142},     {155,  64, 146},     {158,  62, 150},
    {160,  61, 154},     {163,  59, 159},     {165,  58, 163},     {168,  57, 167},
    {170,  55, 171},     {173,  54, 175},     {175,  52, 179},     {178,  51, 183},
    {106,  91,  52},     {109,  90,  56},     {111,  89,  61},     {113,  87,  65},
    {116,  86,  69},     {118,  84,  73},     {121,  83,  77},     {123,  82,  81},
    {126,  80,  85},     {128,  79,  89},     {131,  77,  93},     {133,  76,  98},
    {136,  75, 102},     {138,  73, 106},     {141,  72, 110},     {143,  71, 114},
    {145,  69, 118},     {148,  68, 122},     {150,  66, 126},     {153,  65, 130},
    {155,  64, 135},     {158,  62, 139},     {160,  61, 143},     {163,  59, 147},
    {165,  58, 151},     {168,  57, 155},     {170,  55, 159},     {172,  54, 163},
    {175,  52, 167},     {177,  51, 172},     {180,  50, 176},     {182,  48, 180},
    {111,  89,  49},     {113,  87,  53},     {116,  86,  57},     {118,  84,  61},
    {121,  83,  65},     {123,  82,  69},     {126,  80,  74},     {128,  79,  78},
    {131,  78,  82},     {133,  76,  86},     {136,  75,  90},     {138,  73,  94},
    {140,  72,  98},     {143,  71, 102},     {145,  69, 106},     {148,  68, 111},
    {150,  66, 115},     {153,  65, 119},     {155,  64, 123},     {158,  62, 127},
    {160,  61, 131},     {163,  59, 135},     {165,  58, 139},     {167,  57, 143},
    {170,  55, 148},     {172,  54, 152},     {175,  53, 156},     {177,  51, 160},
    {180,  50, 164},     {182,  48, 168},     {185,  47, 172},     {187,  46, 176},
    {116,  86,  45},     {118,  85,  50},     {121,  83,  54},     {123,  82,  58},
    {126,  80,  62},     {128,  79,  66},     {131,  78,  70},     {133,  76,  74},
    {135,  75,  78},     {138,  73,  82},     {140,  72,  87},     {143,  71,  91},
    {145,  69,  95},     {148,  68,  99},     {150,  66, 103},     {153,  65, 107},
    {155,  64, 111},     {158,  62, 115},     {160,  61, 119},     {162,  60, 124},
    {165,  58, 128},     {167,  57, 132},     {170,  55, 136},     {172,  54, 140},
    {175,  53, 144},     {177,  51, 148},     {180,  50, 152},     {182,  48, 156},
    {185,  47, 161},     {187,  46, 165},     {190,  44, 169},     {192,  43, 173},
    {121,  83,  42},     {123,  82,  46},     {125,  80,  50},     {128,  79,  54},
    {130,  78,  58},     {133,  76,  63},     {135,  75,  67},     {138,  73,  71},
    {140,  72,  75},     {143,  71,  79},     {145,  69,  83},     {148,  68,  87},
    {150,  67,  91},     {153,  65,  95},     {155,  64, 100},     {157,  62, 104},
    {160,  61, 108},     {162,  60, 112},     {165,  58, 116},     {167,  57, 120},
    {170,  55, 124},     {172,  54, 128},     {175,  53, 132},     {177,  51, 137},
    {180,  50, 141},     {182,  48, 145},     {185,  47, 149},     {187,  46, 153},
    {189,  44, 157},     {192,  43, 161},     {194,  42, 165},     {197,  40, 169},
    {125,  80,  39},     {128,  79,  43},     {130,  78,  47},     {133,  76,  51},
    {135,  75,  55},     {138,  74,  59},     {140,  72,  63},     {143,  71,  67},
    {145,  69,  71},     {148,  68,  76},     {150,  67,  80},     {152,  65,  84},
    {155,  64,  88},     {157,  62,  92},     {160,  61,  96},     {162,  60, 100},
    {165,  58, 104},     {167,  57, 108},     {170,  55, 113},     {172,  54, 117},
    {175,  53, 121},     {177,  51, 125},     {180,  50, 129},     {182,  49, 133},
    {184,  47, 137},     {187,  46, 141},     {189,  44, 145},     {192,  43, 150},
    {194,  42, 154},     {197,  40, 158},     {199,  39, 162},     {202,  37, 166},
    {130,  78,  35},     {133,  76,  39},     {135,  75,  43},     {138,  74,  47},
    {140,  72,  52},     {143,  71,  56},     {145,  69,  60},     {147,  68,  64},
    {150,  67,  68},     {152,  65,  72},     {155,  64,  76},     {157,  62,  80},
    {160,  61,  84},     {162,  60,  89},     {165,  58,  93},     {167,  57,  97},
    {170,  56, 101},     {172,  54, 105},     {175,  53, 109},     {177,  51, 113},
    {179,  50, 117},     {182,  49, 121},     {184,  47, 126},     {187,  46, 130},
    {189,  44, 134},     {192,  43, 138},     {194,  42, 142},     {197,  40, 146},
    {199,  39, 150},     {202,  37, 154},     {204,  36, 158},     {206,  35, 163},
    {135,  75,  32},     {138,  74,  36},     {140,  72,  40},     {142,  71,  44},
    {145,  69,  48},     {147,  68,  52},     {150,  67,  56},     {152,  65,  60},
    {155,  64,  65},     {157,  63,  69},     {160,  61,  73},     {162,  60,  77},
    {165,  58,  81},     {167,  57,  85},     {169,  56,  89},     {172,  54,  93},
    {174,  53,  97},     {177,  51, 102},     {179,  50, 106},     {182,  49, 110},
    {184,  47, 114},     {187,  46, 118},     {189,  44, 122},     {192,  43, 126},
    {194,  42, 130},     {197,  40, 134},     {199,  39, 139},     {201,  38, 143},
    {204,  36, 147},     {206,  35, 151},     {209,  33, 155},     {211,  32, 159},
    {140,  72,  28},     {142,  71,  32},     {145,  70,  36},     {147,  68,  41},
    {150,  67,  45},     {152,  65,  49},     {155,  64,  53},     {157,  63,  57},
    {160,  61,  61},     {162,  60,  65},     {164,  58,  69},     {167,  57,  73},
    {169,  56,  78},     {172,  54,  82},     {174,  53,  86},     {177,  51,  90},
    {179,  50,  94},     {182,  49,  98},     {184,  47, 102},     {187,  46, 106},
    {189,  45, 110},     {192,  43, 115},     {194,  42, 119},     {196,  40, 123},
    {199,  39, 127},     {201,  38, 131},     {204,  36, 135},     {206,  35, 139},
    {209,  33, 143},     {211,  32, 147},     {214,  31, 152},     {216,  29, 156},
    {145,  70,  25},     {147,  68,  29},     {150,  67,  33},     {152,  65,  37},
    {155,  64,  41},     {157,  63,  45},     {159,  61,  49},     {162,  60,  54},
    {164,  58,  58},     {167,  57,  62},     {169,  56,  66},     {172,  54,  70},
    {174,  53,  74},     {177,  52,  78},     {179,  50,  82},     {182,  49,  86},
    {184,  47,  91},     {187,  46,  95},     {189,  45,  99},     {191,  43, 103},
    {194,  42, 107},     {196,  40, 111},     {199,  39, 115},     {201,  38, 119},
    {204,  36, 123},     {206,  35, 128},     {209,  33, 132},     {211,  32, 136},
    {214,  31, 140},     {216,  29, 144},     {219,  28, 148},     {221,  27, 152},
    {150,  67,  21},     {152,  65,  25},     {154,  64,  29},     {157,  63,  34},
    {159,  61,  38},     {162,  60,  42},     {164,  59,  46},     {167,  57,  50},
    {169,  56,  54},     {172,  54,  58},     {174,  53,  62},     {177,  52,  67},
    {179,  50,  71},     {182,  49,  75},     {184,  47,  79},     {186,  46,  83},
    {189,  45,  87},     {191,  43,  91},     {194,  42,  95},     {196,  40,  99},
    {199,  39, 104},     {201,  38, 108},     {204,  36, 112},     {206,  35, 116},
    {209,  34, 120},     {211,  32, 124},     {213,  31, 128},     {216,  29, 132},
    {218,  28, 136},     {221,  27, 141},     {223,  25, 145},     {226,  24, 149},
    {154,  64,  18},     {157,  63,  22},     {159,  61,  26},     {162,  60,  30},
    {164,  59,  34},     {167,  57,  38},     {169,  56,  43},     {172,  54,  47},
    {174,  53,  51},     {177,  52,  55},     {179,  50,  59},     {181,  49,  63},
    {184,  47,  67},     {186,  46,  71},     {189,  45,  75},     {191,  43,  80},
    {194,  42,  84},     {196,  41,  88},     {199,  39,  92},     {201,  38,  96},
    {204,  36, 100},     {206,  35, 104},     {208,  34, 108},     {211,  32, 112},
    {213,  31, 117},     {216,  29, 121},     {218,  28, 125},     {221,  27, 129},
    {223,  25, 133},     {226,  24, 137},     {228,  22, 141},     {231,  21, 145},
    {  6, 153, 124},     {  8, 151, 128},     { 11, 150, 132},     { 13, 149, 136},
    { 15, 147, 140},     { 18, 146, 145},     { 20, 144, 149},     { 23, 143, 153},
    { 25, 142, 157},     { 28, 140, 161},     { 30, 139, 165},     { 33, 137, 169},
    { 35, 136, 173},     { 38, 135, 177},     { 40, 133, 182},     { 43, 132, 186},
    { 45, 130, 190},     { 47, 129, 194},     { 50, 128, 198},     { 52, 126, 202},
    { 55, 125, 206},     { 57, 123, 210},     { 60, 122, 214},     { 62, 121, 219},
    { 65, 119, 223},     { 67, 118, 227},     { 70, 117, 231},     { 72, 115, 235},
    { 74, 114, 239},     { 77, 112, 243},     { 79, 111, 247},     { 82, 110, 252},
    { 10, 150, 121},     { 13, 149, 125},     { 15, 147, 129},     { 18, 146, 133},
    { 20, 144, 137},     { 23, 143, 141},     { 25, 142, 145},     { 28, 140, 149},
    { 30, 139, 153},     { 33, 137, 158},     { 35, 136, 162},     { 38, 135, 166},
    { 40, 133, 170},     { 42, 132, 174},     { 45, 130, 178},     { 47, 129, 182},
    { 50, 128, 186},     { 52, 126, 190},     { 55, 125, 195},     { 57, 124, 199},
    { 60, 122, 203},     { 62, 121, 207},     { 65, 119, 211},     { 67, 118, 215},
    { 69, 117, 219},     { 72, 115, 223},     { 74, 114, 227},     { 77, 112, 232},
    { 79, 111, 236},     { 82, 110, 240},     { 84, 108, 244},     { 87, 107, 248},
    { 15, 147, 117},     { 18, 146, 121},     { 20, 144, 125},     { 23, 143, 129},
    { 25, 142, 134},     { 28, 140, 138},     { 30, 139, 142},     { 33, 138, 146},
    { 35, 136, 150},     { 37, 135, 154},     { 40, 133, 158},     { 42, 132, 162},
    { 45, 131, 166},     { 47, 129, 171},     { 50, 128, 175},     { 52, 126, 179},
    { 55, 125, 183},     { 57, 124, 187},     { 60, 122, 191},     { 62, 121, 195},
    { 64, 119, 199},     { 67, 118, 203},     { 69, 117, 208},     { 72, 115, 212},
    { 74, 114, 216},     { 77, 112, 220},     { 79, 111, 224},     { 82, 110, 228},
    { 84, 108, 232},     { 87, 107, 236},     { 89, 106, 240},     { 92, 104, 245},
    { 20, 145, 114},     { 23, 143, 118},     { 25, 142, 122},     { 27, 140, 126},
    { 30, 139, 130},     { 32, 138, 134},     { 35, 136, 138},     { 37, 135, 142},
    { 40, 133, 147},     { 42, 132, 151},     { 45, 131, 155},     { 47, 129, 159},
    { 50, 128, 163},     { 52, 126, 167},     { 55, 125, 171},     { 57, 124, 175},
    { 59, 122, 179},     { 62, 121, 184},     { 64, 119, 188},     { 67, 118, 192},
    { 69, 117, 196},     { 72, 115, 200},     { 74, 114, 204},     { 77, 113, 208},
    { 79, 111, 212},     { 82, 110, 216},     { 84, 108, 221},     { 87, 107, 225},
    { 89, 106, 229},     { 91, 104, 233},     { 94, 103, 237},     { 96, 101, 241},
    { 25, 142, 110},     { 27, 140, 114},     { 30, 139, 118},     { 32, 138, 123},
    { 35, 136, 127},     { 37, 135, 131},     { 40, 133, 135},     { 42, 132, 139},
    { 45, 131, 143},     { 47, 129, 147},     { 50, 128, 151},     { 52, 126, 155},
    { 54, 125, 160},     { 57, 124, 164},     { 59, 122, 168},     { 62, 121, 172},
    { 64, 120, 176},     { 67, 118, 180},     { 69, 117, 184},     { 72, 115, 188},
    { 74, 114, 192},     { 77, 113, 197},     { 79, 111, 201},     { 82, 110, 205},
    { 84, 108, 209},     { 86, 107, 213},     { 89, 106, 217},     { 91, 104, 221},
    { 94, 103, 225},     { 96, 101, 229},     { 99, 100, 234},     {101,  99, 238},
    { 30, 139, 107},     { 32, 138, 111},     { 35, 136, 115},     { 37, 135, 119},
    { 40, 134, 123},     { 42, 132, 127},     { 45, 131, 131},     { 47, 129, 136},
    { 49, 128, 140},     { 52, 127, 144},     { 54, 125, 148},     { 57, 124, 152},
    { 59, 122, 156},     { 62, 121, 160},     { 64, 120, 164},     { 67, 118, 168},
    { 69, 117, 173},     { 72, 115, 177},     { 74, 114, 181},     { 76, 113, 185},
    { 79, 111, 189},     { 81, 110, 193},     { 84, 108, 197},     { 86, 107, 201},
    { 89, 106, 205},     { 91, 104, 210},     { 94, 103, 214},     { 96, 102, 218},
    { 99, 100, 222},     {101,  99, 226},     {104,  97, 230},     {106,  96, 234},
    { 35, 136, 103},     { 37, 135, 107},     { 40, 134, 112},     { 42, 132, 116},
    { 44, 131, 120},     { 47, 129, 124},     { 49, 128, 128},     { 52, 127, 132},
    { 54, 125, 136},     { 57, 124, 140},     { 59, 122, 144},     { 62, 121, 149},
    { 64, 120, 153},     { 67, 118, 157},     { 69, 117, 161},     { 71, 115, 165},
    { 74, 114, 169},     { 76, 113, 173},     { 79, 111, 177},     { 81, 110, 181},
    { 84, 109, 186},     { 86, 107, 190},     { 89, 106, 194},     { 91, 104, 198},
    { 94, 103, 202},     { 96, 102, 206},     { 99, 100, 210},     {101,  99, 214},
    {103,  97, 218},     {106,  96, 223},     {108,  95, 227},     {111,  93, 231},
    { 39, 134, 100},     { 42, 132, 104},     { 44, 131, 108},     { 47, 129, 112},
    { 49, 128, 116},     { 52, 127, 120},     { 54, 125, 125},     { 57, 124, 129},
    { 59, 122, 133},     { 62, 121, 137},     { 64, 120, 141},     { 66, 118, 145},
    { 69, 117, 149},     { 71, 116, 153},     { 74, 114, 157},     { 76, 113, 162},
    { 79, 111, 166},     { 81, 110, 170},     { 84, 109, 174},     { 86, 107, 178},
    { 89, 106, 182},     { 91, 104, 186},     { 94, 103, 190},     { 96, 102, 194},
    { 98, 100, 199},     {101,  99, 203},     {103,  97, 207},     {106,  96, 211},
    {108,  95, 215},     {111,  93, 219},     {113,  92, 223},     {116,  91, 227},
    { 44, 131,  96},     { 47, 130, 101},     { 49, 128, 105},     { 52, 127, 109},
    { 54, 125, 113},     { 57, 124, 117},     { 59, 123, 121},     { 61, 121, 125},
    { 64, 120, 129},     { 66, 118, 133},     { 69, 117, 138},     { 71, 116, 142},
    { 74, 114, 146},     { 76, 113, 150},     { 79, 111, 154},     { 81, 110, 158},
    { 84, 109, 162},     { 86, 107, 166},     { 89, 106, 170},     { 91, 104, 175},
    { 93, 103, 179},     { 96, 102, 183},     { 98, 100, 187},     {101,  99, 191},
    {103,  98, 195},     {106,  96, 199},     {108,  95, 203},     {111,  93, 207},
    {113,  92, 212},     {116,  91, 216},     {118,  89, 220},     {120,  88, 224},
    { 49, 128,  93},     { 52, 127,  97},     { 54, 125, 101},     { 56, 124, 105},
    { 59, 123, 109},     { 61, 121, 114},     { 64, 120, 118},     { 66, 118, 122},
    { 69, 117, 126},     { 71, 116, 130},     { 74, 114, 134},     { 76, 113, 138},
    { 79, 111, 142},     { 81, 110, 146},     { 84, 109, 151},     { 86, 107, 155},
    { 88, 106, 159},     { 91, 105, 163},     { 93, 103, 167},     { 96, 102, 171},
    { 98, 100, 175},     {101,  99, 179},     {103,  98, 183},     {106,  96, 188},
    {108,  95, 192},     {111,  93, 196},     {113,  92, 200},     {115,  91, 204},
    {118,  89, 208},     {120,  88, 212},     {123,  86, 216},     {125,  85, 220},
    { 54, 125,  90},     { 56, 124,  94},     { 59, 123,  98},     { 61, 121, 102},
    { 64, 120, 106},     { 66, 118, 110},     { 69, 117, 114},     { 71, 116, 118},
    { 74, 114, 122},     { 76, 113, 127},     { 79, 112, 131},     { 81, 110, 135},
    { 83, 109, 139},     { 86, 107, 143},     { 88, 106, 147},     { 91, 105, 151},
    { 93, 103, 155},     { 96, 102, 159},     { 98, 100, 164},     {101,  99, 168},
    {103,  98, 172},     {106,  96, 176},     {108,  95, 180},     {110,  93, 184},
    {113,  92, 188},     {115,  91, 192},     {118,  89, 196},     {120,  88, 201},
    {123,  87, 205},     {125,  85, 209},     {128,  84, 213},     {130,  82, 217},
    { 59, 123,  86},     { 61, 121,  90},     { 64, 120,  94},     { 66, 119,  98},
    { 69, 117, 103},     { 71, 116, 107},     { 73, 114, 111},     { 76, 113, 115},
    { 78, 112, 119},     { 81, 110, 123},     { 83, 109, 127},     { 86, 107, 131},
    { 88, 106, 135},     { 91, 105, 140},     { 93, 103, 144},     { 96, 102, 148},
    { 98, 100, 152},     {101,  99, 156},     {103,  98, 160},     {105,  96, 164},
    {108,  95, 168},     {110,  94, 172},     {113,  92, 177},     {115,  91, 181},
    {118,  89, 185},     {120,  88, 189},     {123,  87, 193},     {125,  85, 197},
    {128,  84, 201},     {130,  82, 205},     {133,  81, 209},     {135,  80, 214},
    { 64, 120,  83},     { 66, 119,  87},     { 68, 117,  91},     { 71, 116,  95},
    { 73, 114,  99},     { 76, 113, 103},     { 78, 112, 107},     { 81, 110, 111},
    { 83, 109, 116},     { 86, 107, 120},     { 88, 106, 124},     { 91, 105, 128},
    { 93, 103, 132},     { 96, 102, 136},     { 98, 101, 140},     {100,  99, 144},
    {103,  98, 148},     {105,  96, 153},     {108,  95, 157},     {110,  94, 161},
    {113,  92, 165},     {115,  91, 169},     {118,  89, 173},     {120,  88, 177},
    {123,  87, 181},     {125,  85, 185},     {128,  84, 190},     {130,  82, 194},
    {132,  81, 198},     {135,  80, 202},     {137,  78, 206},     {140,  77, 210},
    { 68, 117,  79},     { 71, 116,  83},     { 73, 115,  87},     { 76, 113,  92},
    { 78, 112,  96},     { 81, 110, 100},     { 83, 109, 104},     { 86, 108, 108},
    { 88, 106, 112},     { 91, 105, 116},     { 93, 103, 120},     { 95, 102, 124},
    { 98, 101, 129},     {100,  99, 133},     {103,  98, 137},     {105,  96, 141},
    {108,  95, 145},     {110,  94, 149},     {113,  92, 153},     {115,  91, 157},
    {118,  89, 161},     {120,  88, 166},     {123,  87, 170},     {125,  85, 174},
    {127,  84, 178},     {130,  83, 182},     {132,  81, 186},     {135,  80, 190},
    {137,  78, 194},     {140,  77, 198},     {142,  76, 203},     {145,  74, 207},
    { 73, 115,  76},     { 76, 113,  80},     { 78, 112,  84},     { 81, 110,  88},
    { 83, 109,  92},     { 86, 108,  96},     { 88, 106, 100},     { 90, 105, 105},
    { 93, 103, 109},     { 95, 102, 113},     { 98, 101, 117},     {100,  99, 121},
    {103,  98, 125},     {105,  96, 129},     {108,  95, 133},     {110,  94, 137},
    {113,  92, 142},     {115,  91, 146},     {117,  90, 150},     {120,  88, 154},
    {122,  87, 158},     {125,  85, 162},     {127,  84, 166},     {130,  83, 170},
    {132,  81, 174},     {135,  80, 179},     {137,  78, 183},     {140,  77, 187},
    {142,  76, 191},     {145,  74, 195},     {147,  73, 199},     {149,  71, 203},
    { 78, 112,  72},     { 81, 110,  76},     { 83, 109,  81},     { 85, 108,  85},
    { 88, 106,  89},     { 90, 105,  93},     { 93, 103,  97},     { 95, 102, 101},
    { 98, 101, 105},     {100,  99, 109},     {103,  98, 113},     {105,  97, 118},
    {108,  95, 122},     {110,  94, 126},     {112,  92, 130},     {115,  91, 134},
    {117,  90, 138},     {120,  88, 142},     {122,  87, 146},     {125,  85, 150},
    {127,  84, 155},     {130,  83, 159},     {132,  81, 163},     {135,  80, 167},
    {137,  78, 171},     {140,  77, 175},     {142,  76, 179},     {144,  74, 183},
    {147,  73, 187},     {149,  72, 192},     {152,  70, 196},     {154,  69, 200},
    { 83, 109,  69},     { 85, 108,  73},     { 88, 106,  77},     { 90, 105,  81},
    { 93, 104,  85},     { 95, 102,  89},     { 98, 101,  94},     {100,  99,  98},
    {103,  98, 102},     {105,  97, 106},     {107,  95, 110},     {110,  94, 114},
    {112,  92, 118},     {115,  91, 122},     {117,  90, 126},     {120,  88, 131},
    {122,  87, 135},     {125,  85, 139},     {127,  84, 143},     {130,  83, 147},
    {132,  81, 151},     {135,  80, 155},     {137,  79, 159},     {139,  77, 163},
    {142,  76, 168},     {144,  74, 172},     {147,  73, 176},     {149,  72, 180},
    {152,  70, 184},     {154,  69, 188},     {157,  67, 192},     {159,  66, 196},
    { 88, 106,  65},     { 90, 105,  70},     { 93, 104,  74},     { 95, 102,  78},
    { 98, 101,  82},     {100,  99,  86},     {102,  98,  90},     {105,  97,  94},
    {107,  95,  98},     {110,  94, 102},     {112,  92, 107},     {115,  91, 111},
    {117,  90, 115},     {120,  88, 119},     {122,  87, 123},     {125,  86, 127},
    {127,  84, 131},     {130,  83, 135},     {132,  81, 139},     {134,  80, 144},
    {137,  79, 148},     {139,  77, 152},     {142,  76, 156},     {144,  74, 160},
    {147,  73, 164},     {149,  72, 168},     {152,  70, 172},     {154,  69, 176},
    {157,  67, 181},     {159,  66, 185},     {161,  65, 189},     {164,  63, 193},
    { 93, 104,  62},     { 95, 102,  66},     { 97, 101,  70},     {100,  99,  74},
    {102,  98,  78},     {105,  97,  83},     {107,  95,  87},     {110,  94,  91},
    {112,  93,  95},     {115,  91,  99},     {117,  90, 103},     {120,  88, 107},
    {122,  87, 111},     {125,  86, 115},     {127,  84, 120},     {129,  83, 124},
    {132,  81, 128},     {134,  80, 132},     {137,  79, 136},     {139,  77, 140},
    {142,  76, 144},     {144,  74, 148},     {147,  73, 152},     {149,  72, 157},
    {152,  70, 161},     {154,  69, 165},     {156,  68, 169},     {159,  66, 173},
    {161,  65, 177},     {164,  63, 181},     {166,  62, 185},     {169,  61, 189},
    { 97, 101,  59},     {100, 100,  63},     {102,  98,  67},     {105,  97,  71},
    {107,  95,  75},     {110,  94,  79},     {112,  93,  83},     {115,  91,  87},
    {117,  90,  91},     {120,  88,  96},     {122,  87, 100},     {124,  86, 104},
    {127,  84, 108},     {129,  83, 112},     {132,  81, 116},     {134,  80, 120},
    {137,  79, 124},     {139,  77, 128},     {142,  76, 133},     {144,  75, 137},
    {147,  73, 141},     {149,  72, 145},     {151,  70, 149},     {154,  69, 153},
    {156,  68, 157},     {159,  66, 161},     {161,  65, 165},     {164,  63, 170},
    {166,  62, 174},     {169,  61, 178},     {171,  59, 182},     {174,  58, 186},
    {102,  98,  55},     {105,  97,  59},     {107,  95,  63},     {110,  94,  67},
    {112,  93,  72},     {114,  91,  76},     {117,  90,  80},     {119,  88,  84},
    {122,  87,  88},     {124,  86,  92},     {127,  84,  96},     {129,  83, 100},
    {132,  82, 104},     {134,  80, 109},     {137,  79, 113},     {139,  77, 117},
    {142,  76, 121},     {144,  75, 125},     {146,  73, 129},     {149,  72, 133},
    {151,  70, 137},     {154,  69, 141},     {156,  68, 146},     {159,  66, 150},
    {161,  65, 154},     {164,  63, 158},     {166,  62, 162},     {169,  61, 166},
    {171,  59, 170},     {174,  58, 174},     {176,  57, 178},     {178,  55, 183},
    {107,  95,  52},     {109,  94,  56},     {112,  93,  60},     {114,  91,  64},
    {117,  90,  68},     {119,  89,  72},     {122,  87,  76},     {124,  86,  80},
    {127,  84,  85},     {129,  83,  89},     {132,  82,  93},     {134,  80,  97},
    {137,  79, 101},     {139,  77, 105},     {141,  76, 109},     {144,  75, 113},
    {146,  73, 117},     {149,  72, 122},     {151,  70, 126},     {154,  69, 130},
    {156,  68, 134},     {159,  66, 138},     {161,  65, 142},     {164,  64, 146},
    {166,  62, 150},     {169,  61, 154},     {171,  59, 159},     {173,  58, 163},
    {176,  57, 167},     {178,  55, 171},     {181,  54, 175},     {183,  52, 179},
    {112,  93,  48},     {114,  91,  52},     {117,  90,  56},     {119,  89,  61},
    {122,  87,  65},     {124,  86,  69},     {127,  84,  73},     {129,  83,  77},
    {132,  82,  81},     {134,  80,  85},     {136,  79,  89},     {139,  77,  93},
    {141,  76,  98},     {144,  75, 102},     {146,  73, 106},     {149,  72, 110},
    {151,  71, 114},     {154,  69, 118},     {156,  68, 122},     {159,  66, 126},
    {161,  65, 130},     {164,  64, 135},     {166,  62, 139},     {168,  61, 143},
    {171,  59, 147},     {173,  58, 151},     {176,  57, 155},     {178,  55, 159},
    {181,  54, 163},     {183,  52, 167},     {186,  51, 172},     {188,  50, 176},
    {117,  90,  45},     {119,  89,  49},     {122,  87,  53},     {124,  86,  57},
    {127,  84,  61},     {129,  83,  65},     {131,  82,  69},     {134,  80,  74},
    {136,  79,  78},     {139,  78,  82},     {141,  76,  86},     {144,  75,  90},
    {146,  73,  94},     {149,  72,  98},     {151,  71, 102},     {154,  69, 106},
    {156,  68, 111},     {158,  66, 115},     {161,  65, 119},     {163,  64, 123},
    {166,  62, 127},     {168,  61, 131},     {171,  59, 135},     {173,  58, 139},
    {176,  57, 143},     {178,  55, 148},     {181,  54, 152},     {183,  53, 156},
    {186,  51, 160},     {188,  50, 164},     {190,  48, 168},     {193,  47, 172},
    {122,  87,  41},     {124,  86,  45},     {126,  85,  50},     {129,  83,  54},
    {131,  82,  58},     {134,  80,  62},     {136,  79,  66},     {139,  78,  70},
    {141,  76,  74},     {144,  75,  78},     {146,  73,  82},     {149,  72,  87},
    {151,  71,  91},     {153,  69,  95},     {156,  68,  99},     {158,  66, 103},
    {161,  65, 107},     {163,  64, 111},     {166,  62, 115},     {168,  61, 119},
    {171,  60, 124},     {173,  58, 128},     {176,  57, 132},     {178,  55, 136},
    {181,  54, 140},     {183,  53, 144},     {185,  51, 148},     {188,  50, 152},
    {190,  48, 156},     {193,  47, 161},     {195,  46, 165},     {198,  44, 169},
    {126,  85,  38},     {129,  83,  42},     {131,  82,  46},     {134,  80,  50},
    {136,  79,  54},     {139,  78,  58},     {141,  76,  63},     {144,  75,  67},
    {146,  73,  71},     {148,  72,  75},     {151,  71,  79},     {153,  69,  83},
    {156,  68,  87},     {158,  67,  91},     {161,  65,  95},     {163,  64, 100},
    {166,  62, 104},     {168,  61, 108},     {171,  60, 112},     {173,  58, 116},
    {176,  57, 120},     {178,  55, 124},     {180,  54, 128},     {183,  53, 132},
    {185,  51, 137},     {188,  50, 141},     {190,  48, 145},     {193,  47, 149},
    {195,  46, 153},     {198,  44, 157},     {200,  43, 161},     {203,  42, 165},
    {131,  82,  34},     {134,  80,  39},     {136,  79,  43},     {139,  78,  47},
    {141,  76,  51},     {143,  75,  55},     {146,  74,  59},     {148,  72,  63},
    {151,  71,  67},     {153,  69,  71},     {156,  68,  76},     {158,  67,  80},
    {161,  65,  84},     {163,  64,  88},     {166,  62,  92},     {168,  61,  96},
    {171,  60, 100},     {173,  58, 104},     {175,  57, 108},     {178,  55, 113},
    {180,  54, 117},     {183,  53, 121},     {185,  51, 125},     {188,  50, 129},
    {190,  49, 133},     {193,  47, 137},     {195,  46, 141},     {198,  44, 145},
    {200,  43, 150},     {202,  42, 154},     {205,  40, 158},     {207,  39, 162},
    {136,  79,  31},     {138,  78,  35},     {141,  76,  39},     {143,  75,  43},
    {146,  74,  47},     {148,  72,  52},     {151,  71,  56},     {153,  69,  60},
    {156,  68,  64},     {158,  67,  68},     {161,  65,  72},     {163,  64,  76},
    {166,  62,  80},     {168,  61,  84},     {170,  60,  89},     {173,  58,  93},
    {175,  57,  97},     {178,  56, 101},     {180,  54, 105},     {183,  53, 109},
    {185,  51, 113},     {188,  50, 117},     {190,  49, 121},     {193,  47, 126},
    {195,  46, 130},     {197,  44, 134},     {200,  43, 138},     {202,  42, 142},
    {205,  40, 146},     {207,  39, 150},     {210,  37, 154},     {212,  36, 158},
    {141,  76,  27},     {143,  75,  32},     {146,  74,  36},     {148,  72,  40},
    {151,  71,  44},     {153,  69,  48},     {156,  68,  52},     {158,  67,  56},
    {161,  65,  60},     {163,  64,  65},     {165,  63,  69},     {168,  61,  73},
    {170,  60,  77},     {173,  58,  81},     {175,  57,  85},     {178,  56,  89},
    {180,  54,  93},     {183,  53,  97},     {185,  51, 102},     {188,  50, 106},
    {190,  49, 110},     {192,  47, 114},     {195,  46, 118},     {197,  44, 122},
    {200,  43, 126},     {202,  42, 130},     {205,  40, 134},     {207,  39, 139},
    {210,  38, 143},     {212,  36, 147},     {215,  35, 151},     {217,  33, 155},
    {146,  74,  24},     {148,  72,  28},     {151,  71,  32},     {153,  70,  36},
    {155,  68,  41},     {158,  67,  45},     {160,  65,  49},     {163,  64,  53},
    {165,  63,  57},     {168,  61,  61},     {170,  60,  65},     {173,  58,  69},
    {175,  57,  73},     {178,  56,  78},     {180,  54,  82},     {183,  53,  86},
    {185,  51,  90},     {187,  50,  94},     {190,  49,  98},     {192,  47, 102},
    {195,  46, 106},     {197,  45, 110},     {200,  43, 115},     {202,  42, 119},
    {205,  40, 123},     {207,  39, 127},     {210,  38, 131},     {212,  36, 135},
    {215,  35, 139},     {217,  33, 143},     {219,  32, 147},     {222,  31, 152},
    {150,  71,  21},     {153,  70,  25},     {155,  68,  29},     {158,  67,  33},
    {160,  65,  37},     {163,  64,  41},     {165,  63,  45},     {168,  61,  49},
    {170,  60,  54},     {173,  58,  58},     {175,  57,  62},     {178,  56,  66},
    {180,  54,  70},     {182,  53,  74},     {185,  52,  78},     {187,  50,  82},
    {190,  49,  86},     {192,  47,  91},     {195,  46,  95},     {197,  45,  99},
    {200,  43, 103},     {202,  42, 107},     {205,  40, 111},     {207,  39, 115},
    {210,  38, 119},     {212,  36, 123},     {214,  35, 128},     {217,  33, 132},
    {219,  32, 136},     {222,  31, 140},     {224,  29, 144},     {227,  28, 148},
    {155,  68,  17},     {158,  67,  21},     {160,  65,  25},     {163,  64,  29},
    {165,  63,  34},     {168,  61,  38},     {170,  60,  42},     {173,  59,  46},
    {175,  57,  50},     {177,  56,  54},     {180,  54,  58},     {182,  53,  62},
    {185,  52,  67},     {187,  50,  71},     {190,  49,  75},     {192,  47,  79},
    {195,  46,  83},     {197,  45,  87},     {200,  43,  91},     {202,  42,  95},
    {205,  40,  99},     {207,  39, 104},     {209,  38, 108},     {212,  36, 112},
    {214,  35, 116},     {217,  34, 120},     {219,  32, 124},     {222,  31, 128},
    {224,  29, 132},     {227,  28, 136},     {229,  27, 141},     {232,  25, 145},
    {  7, 157, 123},     {  9, 155, 127},     { 11, 154, 132},     { 14, 153, 136},
    { 16, 151, 140},     { 19, 150, 144},     { 21, 148, 148},     { 24, 147, 152},
    { 26, 146, 156},     { 29, 144, 160},     { 31, 143, 164},     { 34, 141, 169},
    { 36, 140, 173},     { 39, 139, 177},     { 41, 137, 181},     { 43, 136, 185},
    { 46, 135, 189},     { 48, 133, 193},     { 51, 132, 197},     { 53, 130, 201},
    { 56, 129, 206},     { 58, 128, 210},     { 61, 126, 214},     { 63, 125, 218},
    { 66, 123, 222},     { 68, 122, 226},     { 71, 121, 230},     { 73, 119, 234},
    { 75, 118, 238},     { 78, 116, 243},     { 80, 115, 247},     { 83, 114, 251},
    { 11, 154, 120},     { 14, 153, 124},     { 16, 151, 128},     { 19, 150, 132},
    { 21, 149, 136},     { 24, 147, 140},     { 26, 146, 145},     { 29, 144, 149},
    { 31, 143, 153},     { 34, 142, 157},     { 36, 140, 161},     { 38, 139, 165},
    { 41, 137, 169},     { 43, 136, 173},     { 46, 135, 177},     { 48, 133, 182},
    { 51, 132, 186},     { 53, 130, 190},     { 56, 129, 194},     { 58, 128, 198},
    { 61, 126, 202},     { 63, 125, 206},     { 66, 123, 210},     { 68, 122, 214},
    { 70, 121, 219},     { 73, 119, 223},     { 75, 118, 227},     { 78, 117, 231},
    { 80, 115, 235},     { 83, 114, 239},     { 85, 112, 243},     { 88, 111, 247},
    { 16, 151, 116},     { 19, 150, 121},     { 21, 149, 125},     { 24, 147, 129},
    { 26, 146, 133},     { 29, 144, 137},     { 31, 143, 141},     { 33, 142, 145},
    { 36, 140, 149},     { 38, 139, 153},     { 41, 137, 158},     { 43, 136, 162},
    { 46, 135, 166},     { 48, 133, 170},     { 51, 132, 174},     { 53, 130, 178},
    { 56, 129, 182},     { 58, 128, 186},     { 60, 126, 190},     { 63, 125, 195},
    { 65, 124, 199},     { 68, 122, 203},     { 70, 121, 207},     { 73, 119, 211},
    { 75, 118, 215},     { 78, 117, 219},     { 80, 115, 223},     { 83, 114, 227},
    { 85, 112, 232},     { 88, 111, 236},     { 90, 110, 240},     { 92, 108, 244},
    { 21, 149, 113},     { 24, 147, 117},     { 26, 146, 121},     { 28, 144, 125},
    { 31, 143, 129},     { 33, 142, 134},     { 36, 140, 138},     { 38, 139, 142},
    { 41, 138, 146},     { 43, 136, 150},     { 46, 135, 154},     { 48, 133, 158},
    { 51, 132, 162},     { 53, 131, 166},     { 55, 129, 171},     { 58, 128, 175},
    { 60, 126, 179},     { 63, 125, 183},     { 65, 124, 187},     { 68, 122, 191},
    { 70, 121, 195},     { 73, 119, 199},     { 75, 118, 203},     { 78, 117, 208},
    { 80, 115, 212},     { 83, 114, 216},     { 85, 112, 220},     { 87, 111, 224},
    { 90, 110, 228},     { 92, 108, 232},     { 95, 107, 236},     { 97, 106, 240},
    { 26, 146, 110},     { 28, 145, 114},     { 31, 143, 118},     { 33, 142, 122},
    { 36, 140, 126},     { 38, 139, 130},     { 41, 138, 134},     { 43, 136, 138},
    { 46, 135, 142},     { 48, 133, 147},     { 50, 132, 151},     { 53, 131, 155},
    { 55, 129, 159},     { 58, 128, 163},     { 60, 126, 167},     { 63, 125, 171},
    { 65, 124, 175},     { 68, 122, 179},     { 70, 121, 184},     { 73, 119, 188},
    { 75, 118, 192},     { 78, 117, 196},     { 80, 115, 200},     { 82, 114, 204},
    { 85, 113, 208},     { 87, 111, 212},     { 90, 110, 216},     { 92, 108, 221},
    { 95, 107, 225},     { 97, 106, 229},     {100, 104, 233},     {102, 103, 237},
    { 31, 143, 106},     { 33, 142, 110},     { 36, 140, 114},     { 38, 139, 118},
    { 41, 138, 123},     { 43, 136, 127},     { 45, 135, 131},     { 48, 133, 135},
    { 50, 132, 139},     { 53, 131, 143},     { 55, 129, 147},     { 58, 128, 151},
    { 60, 126, 155},     { 63, 125, 160},     { 65, 124, 164},     { 68, 122, 168},
    { 70, 121, 172},     { 73, 120, 176},     { 75, 118, 180},     { 77, 117, 184},
    { 80, 115, 188},     { 82, 114, 192},     { 85, 113, 197},     { 87, 111, 201},
    { 90, 110, 205},     { 92, 108, 209},     { 95, 107, 213},     { 97, 106, 217},
    {100, 104, 221},     {102, 103, 225},     {104, 101, 229},     {107, 100, 234},
    { 36, 140, 103},     { 38, 139, 107},     { 40, 138, 111},     { 43, 136, 115},
    { 45, 135, 119},     { 48, 134, 123},     { 50, 132, 127},     { 53, 131, 131},
    { 55, 129, 136},     { 58, 128, 140},     { 60, 127, 144},     { 63, 125, 148},
    { 65, 124, 152},     { 68, 122, 156},     { 70, 121, 160},     { 72, 120, 164},
    { 75, 118, 168},     { 77, 117, 173},     { 80, 115, 177},     { 82, 114, 181},
    { 85, 113, 185},     { 87, 111, 189},     { 90, 110, 193},     { 92, 108, 197},
    { 95, 107, 201},     { 97, 106, 205},     { 99, 104, 210},     {102, 103, 214},
    {104, 102, 218},     {107, 100, 222},     {109,  99, 226},     {112,  97, 230},
    { 40, 138,  99},     { 43, 136, 103},     { 45, 135, 107},     { 48, 134, 112},
    { 50, 132, 116},     { 53, 131, 120},     { 55, 129, 124},     { 58, 128, 128},
    { 60, 127, 132},     { 62, 125, 136},     { 65, 124, 140},     { 67, 122, 144},
    { 70, 121, 149},     { 72, 120, 153},     { 75, 118, 157},     { 77, 117, 161},
    { 80, 115, 165},     { 82, 114, 169},     { 85, 113, 173},     { 87, 111, 177},
    { 90, 110, 181},     { 92, 109, 186},     { 94, 107, 190},     { 97, 106, 194},
    { 99, 104, 198},     {102, 103, 202},     {104, 102, 206},     {107, 100, 210},
    {109,  99, 214},     {112,  97, 218},     {114,  96, 223},     {117,  95, 227},
    { 45, 135,  96},     { 48, 134, 100},     { 50, 132, 104},     { 53, 131, 108},
    { 55, 129, 112},     { 57, 128, 116},     { 60, 127, 120},     { 62, 125, 125},
    { 65, 124, 129},     { 67, 122, 133},     { 70, 121, 137},     { 72, 120, 141},
    { 75, 118, 145},     { 77, 117, 149},     { 80, 116, 153},     { 82, 114, 157},
    { 85, 113, 162},     { 87, 111, 166},     { 89, 110, 170},     { 92, 109, 174},
    { 94, 107, 178},     { 97, 106, 182},     { 99, 104, 186},     {102, 103, 190},
    {104, 102, 194},     {107, 100, 199},     {109,  99, 203},     {112,  97, 207},
    {114,  96, 211},     {117,  95, 215},     {119,  93, 219},     {121,  92, 223},
    { 50, 132,  92},     { 52, 131,  96},     { 55, 130, 101},     { 57, 128, 105},
    { 60, 127, 109},     { 62, 125, 113},     { 65, 124, 117},     { 67, 123, 121},
    { 70, 121, 125},     { 72, 120, 129},     { 75, 118, 133},     { 77, 117, 138},
    { 80, 116, 142},     { 82, 114, 146},     { 84, 113, 150},     { 87, 111, 154},
    { 89, 110, 158},     { 92, 109, 162},     { 94, 107, 166},     { 97, 106, 170},
    { 99, 104, 175},     {102, 103, 179},     {104, 102, 183},     {107, 100, 187},
    {109,  99, 191},     {112,  98, 195},     {114,  96, 199},     {116,  95, 203},
    {119,  93, 207},     {121,  92, 212},     {124,  91, 216},     {126,  89, 220},
    { 55, 130,  89},     { 57, 128,  93},     { 60, 127,  97},     { 62, 125, 101},
    { 65, 124, 105},     { 67, 123, 109},     { 70, 121, 114},     { 72, 120, 118},
    { 75, 118, 122},     { 77, 117, 126},     { 79, 116, 130},     { 82, 114, 134},
    { 84, 113, 138},     { 87, 111, 142},     { 89, 110, 146},     { 92, 109, 151},
    { 94, 107, 155},     { 97, 106, 159},     { 99, 105, 163},     {102, 103, 167},
    {104, 102, 171},     {106, 100, 175},     {109,  99, 179},     {111,  98, 183},
    {114,  96, 188},     {116,  95, 192},     {119,  93, 196},     {121,  92, 200},
    {124,  91, 204},     {126,  89, 208},     {129,  88, 212},     {131,  86, 216},
    { 60, 127,  85},     { 62, 125,  90},     { 65, 124,  94},     { 67, 123,  98},
    { 70, 121, 102},     { 72, 120, 106},     { 74, 118, 110},     { 77, 117, 114},
    { 79, 116, 118},     { 82, 114, 122},     { 84, 113, 127},     { 87, 112, 131},
    { 89, 110, 135},     { 92, 109, 139},     { 94, 107, 143},     { 97, 106, 147},
    { 99, 105, 151},     {101, 103, 155},     {104, 102, 159},     {106, 100, 164},
    {109,  99, 168},     {111,  98, 172},     {114,  96, 176},     {116,  95, 180},
    {119,  93, 184},     {121,  92, 188},     {124,  91, 192},     {126,  89, 196},
    {129,  88, 201},     {131,  87, 205},     {133,  85, 209},     {136,  84, 213},
    { 65, 124,  82},     { 67, 123,  86},     { 69, 121,  90},     { 72, 120,  94},
    { 74, 119,  98},     { 77, 117, 103},     { 79, 116, 107},     { 82, 114, 111},
    { 84, 113, 115},     { 87, 112, 119},     { 89, 110, 123},     { 92, 109, 127},
    { 94, 107, 131},     { 96, 106, 135},     { 99, 105, 140},     {101, 103, 144},
    {104, 102, 148},     {106, 100, 152},     {109,  99, 156},     {111,  98, 160},
    {114,  96, 164},     {116,  95, 168},     {119,  94, 172},     {121,  92, 177},
    {124,  91, 181},     {126,  89, 185},     {128,  88, 189},     {131,  87, 193},
    {133,  85, 197},     {136,  84, 201},     {138,  82, 205},     {141,  81, 209},
    { 69, 121,  79},     { 72, 120,  83},     { 74, 119,  87},     { 77, 117,  91},
    { 79, 116,  95},     { 82, 114,  99},     { 84, 113, 103},     { 87, 112, 107},
    { 89, 110, 111},     { 91, 109, 116},     { 94, 107, 120},     { 96, 106, 124},
    { 99, 105, 128},     {101, 103, 132},     {104, 102, 136},     {106, 101, 140},
    {109,  99, 144},     {111,  98, 148},     {114,  96, 153},     {116,  95, 157},
    {119,  94, 161},     {121,  92, 165},     {123,  91, 169},     {126,  89, 173},
    {128,  88, 177},     {131,  87, 181},     {133,  85, 185},     {136,  84, 190},
    {138,  82, 194},     {141,  81, 198},     {143,  80, 202},     {146,  78, 206},
    { 74, 119,  75},     { 77, 117,  79},     { 79, 116,  83},     { 82, 115,  87},
    { 84, 113,  92},     { 86, 112,  96},     { 89, 110, 100},     { 91, 109, 104},
    { 94, 108, 108},     { 96, 106, 112},     { 99, 105, 116},     {101, 103, 120},
    {104, 102, 124},     {106, 101, 129},     {109,  99, 133},     {111,  98, 137},
    {114,  96, 141},     {116,  95, 145},     {118,  94, 149},     {121,  92, 153},
    {123,  91, 157},     {126,  89, 161},     {128,  88, 166},     {131,  87, 170},
    {133,  85, 174},     {136,  84, 178},     {138,  83, 182},     {141,  81, 186},
    {143,  80, 190},     {145,  78, 194},     {148,  77, 198},     {150,  76, 203},
    { 79, 116,  72},     { 81, 115,  76},     { 84, 113,  80},     { 86, 112,  84},
    { 89, 110,  88},     { 91, 109,  92},     { 94, 108,  96},     { 96, 106, 100},
    { 99, 105, 105},     {101, 103, 109},     {104, 102, 113},     {106, 101, 117},
    {109,  99, 121},     {111,  98, 125},     {113,  96, 129},     {116,  95, 133},
    {118,  94, 137},     {121,  92, 142},     {123,  91, 146},     {126,  90, 150},
    {128,  88, 154},     {131,  87, 158},     {133,  85, 162},     {136,  84, 166},
    {138,  83, 170},     {140,  81, 174},     {143,  80, 179},     {145,  78, 183},
    {148,  77, 187},     {150,  76, 191},     {153,  74, 195},     {155,  73, 199},
    { 84, 113,  68},     { 86, 112,  72},     { 89, 110,  76},     { 91, 109,  81},
    { 94, 108,  85},     { 96, 106,  89},     { 99, 105,  93},     {101, 103,  97},
    {103, 102, 101},     {106, 101, 105},     {108,  99, 109},     {111,  98, 113},
    {113,  97, 118},     {116,  95, 122},     {118,  94, 126},     {121,  92, 130},
    {123,  91, 134},     {126,  90, 138},     {128,  88, 142},     {131,  87, 146},
    {133,  85, 150},     {135,  84, 155},     {138,  83, 159},     {140,  81, 163},
    {143,  80, 167},     {145,  78, 171},     {148,  77, 175},     {150,  76, 179},
    {153,  74, 183},     {155,  73, 187},     {158,  72, 192},     {160,  70, 196},
    { 89, 111,  65},     { 91, 109,  69},     { 94, 108,  73},     { 96, 106,  77},
    { 98, 105,  81},     {101, 104,  85},     {103, 102,  89},     {106, 101,  94},
    {108,  99,  98},     {111,  98, 102},     {113,  97, 106},     {116,  95, 110},
    {118,  94, 114},     {121,  92, 118},     {123,  91, 122},     {126,  90, 126},
    {128,  88, 131},     {130,  87, 135},     {133,  85, 139},     {135,  84, 143},
    {138,  83, 147},     {140,  81, 151},     {143,  80, 155},     {145,  79, 159},
    {148,  77, 163},     {150,  76, 168},     {153,  74, 172},     {155,  73, 176},
    {158,  72, 180},     {160,  70, 184},     {162,  69, 188},     {165,  67, 192},
    { 93, 108,  61},     { 96, 106,  65},     { 98, 105,  70},     {101, 104,  74},
    {103, 102,  78},     {106, 101,  82},     {108,  99,  86},     {111,  98,  90},
    {113,  97,  94},     {116,  95,  98},     {118,  94, 102},     {121,  92, 107},
    {123,  91, 111},     {125,  90, 115},     {128,  88, 119},     {130,  87, 123},
    {133,  86, 127},     {135,  84, 131},     {138,  83, 135},     {140,  81, 139},
    {143,  80, 144},     {145,  79, 148},     {148,  77, 152},     {150,  76, 156},
    {153,  74, 160},     {155,  73, 164},     {157,  72, 168},     {160,  70, 172},
    {162,  69, 176},     {165,  67, 181},     {167,  66, 185},     {170,  65, 189},
    { 98, 105,  58},     {101, 104,  62},     {103, 102,  66},     {106, 101,  70},
    {108,  99,  74},     {111,  98,  78},     {113,  97,  83},     {116,  95,  87},
    {118,  94,  91},     {120,  93,  95},     {123,  91,  99},     {125,  90, 103},
    {128,  88, 107},     {130,  87, 111},     {133,  86, 115},     {135,  84, 120},
    {138,  83, 124},     {140,  81, 128},     {143,  80, 132},     {145,  79, 136},
    {147,  77, 140},     {150,  76, 144},     {152,  74, 148},     {155,  73, 152},
    {157,  72, 157},     {160,  70, 161},     {162,  69, 165},     {165,  68, 169},
    {167,  66, 173},     {170,  65, 177},     {172,  63, 181},     {175,  62, 185},
    {103, 102,  54},     {106, 101,  59},     {108, 100,  63},     {111,  98,  67},
    {113,  97,  71},     {115,  95,  75},     {118,  94,  79},     {120,  93,  83},
    {123,  91,  87},     {125,  90,  91},     {128,  88,  96},     {130,  87, 100},
    {133,  86, 104},     {135,  84, 108},     {138,  83, 112},     {140,  81, 116},
    {142,  80, 120},     {145,  79, 124},     {147,  77, 128},     {150,  76, 133},
    {152,  75, 137},     {155,  73, 141},     {157,  72, 145},     {160,  70, 149},
    {162,  69, 153},     {165,  68, 157},     {167,  66, 161},     {170,  65, 165},
    {172,  63, 170},     {174,  62, 174},     {177,  61, 178},     {179,  59, 182},
    {108, 100,  51},     {110,  98,  55},     {113,  97,  59},     {115,  95,  63},
    {118,  94,  67},     {120,  93,  72},     {123,  91,  76},     {125,  90,  80},
    {128,  88,  84},     {130,  87,  88},     {133,  86,  92},     {135,  84,  96},
    {137,  83, 100},     {140,  82, 104},     {142,  80, 109},     {145,  79, 113},
    {147,  77, 117},     {150,  76, 121},     {152,  75, 125},     {155,  73, 129},
    {157,  72, 133},     {160,  70, 137},     {162,  69, 141},     {165,  68, 146},
    {167,  66, 150},     {169,  65, 154},     {172,  63, 158},     {174,  62, 162},
    {177,  61, 166},     {179,  59, 170},     {182,  58, 174},     {184,  57, 178},
    {113,  97,  48},     {115,  95,  52},     {118,  94,  56},     {120,  93,  60},
    {123,  91,  64},     {125,  90,  68},     {128,  89,  72},     {130,  87,  76},
    {132,  86,  80},     {135,  84,  85},     {137,  83,  89},     {140,  82,  93},
    {142,  80,  97},     {145,  79, 101},     {147,  77, 105},     {150,  76, 109},
    {152,  75, 113},     {155,  73, 117},     {157,  72, 122},     {160,  70, 126},
    {162,  69, 130},     {164,  68, 134},     {167,  66, 138},     {169,  65, 142},
    {172,  64, 146},     {174,  62, 150},     {177,  61, 154},     {179,  59, 159},
    {182,  58, 163},     {184,  57, 167},     {187,  55, 171},     {189,  54, 175},
    {118,  94,  44},     {120,  93,  48},     {123,  91,  52},     {125,  90,  56},
    {127,  89,  61},     {130,  87,  65},     {132,  86,  69},     {135,  84,  73},
    {137,  83,  77},     {140,  82,  81},     {142,  80,  85},     {145,  79,  89},
    {147,  77,  93},     {150,  76,  98},     {152,  75, 102},     {155,  73, 106},
    {157,  72, 110},     {159,  71, 114},     {162,  69, 118},     {164,  68, 122},
    {167,  66, 126},     {169,  65, 130},     {172,  64, 135},     {174,  62, 139},
    {177,  61, 143},     {179,  59, 147},     {182,  58, 151},     {184,  57, 155},
    {186,  55, 159},     {189,  54, 163},     {191,  52, 167},     {194,  51, 172},
    {122,  91,  41},     {125,  90,  45},     {127,  89,  49},     {130,  87,  53},
    {132,  86,  57},     {135,  84,  61},     {137,  83,  65},     {140,  82,  69},
    {142,  80,  74},     {145,  79,  78},     {147,  78,  82},     {150,  76,  86},
    {152,  75,  90},     {154,  73,  94},     {157,  72,  98},     {159,  71, 102},
    {162,  69, 106},     {164,  68, 111},     {167,  66, 115},     {169,  65, 119},
    {172,  64, 123},     {174,  62, 127},     {177,  61, 131},     {179,  59, 135},
    {181,  58, 139},     {184,  57, 143},     {186,  55, 148},     {189,  54, 152},
    {191,  53, 156},     {194,  51, 160},     {196,  50, 164},     {199,  48, 168},
    {127,  89,  37},     {130,  87,  41},     {132,  86,  45},     {135,  85,  50},
    {137,  83,  54},     {140,  82,  58},     {142,  80,  62},     {144,  79,  66},
    {147,  78,  70},     {149,  76,  74},     {152,  75,  78},     {154,  73,  82},
    {157,  72,  87},     {159,  71,  91},     {162,  69,  95},     {164,  68,  99},
    {167,  66, 103},     {169,  65, 107},     {172,  64, 111},     {174,  62, 115},
    {176,  61, 119},     {179,  60, 124},     {181,  58, 128},     {184,  57, 132},
    {186,  55, 136},     {189,  54, 140},     {191,  53, 144},     {194,  51, 148},
    {196,  50, 152},     {199,  48, 156},     {201,  47, 161},     {204,  46, 165},
    {132,  86,  34},     {135,  85,  38},     {137,  83,  42},     {139,  82,  46},
    {142,  80,  50},     {144,  79,  54},     {147,  78,  58},     {149,  76,  63},
    {152,  75,  67},     {154,  73,  71},     {157,  72,  75},     {159,  71,  79},
    {162,  69,  83},     {164,  68,  87},     {167,  67,  91},     {169,  65,  95},
    {171,  64, 100},     {174,  62, 104},     {176,  61, 108},     {179,  60, 112},
    {181,  58, 116},     {184,  57, 120},     {186,  55, 124},     {189,  54, 128},
    {191,  53, 132},     {194,  51, 137},     {196,  50, 141},     {199,  48, 145},
    {201,  47, 149},     {203,  46, 153},     {206,  44, 157},     {208,  43, 161},
    {137,  83,  30},     {139,  82,  34},     {142,  80,  39},     {144,  79,  43},
    {147,  78,  47},     {149,  76,  51},     {152,  75,  55},     {154,  74,  59},
    {157,  72,  63},     {159,  71,  67},     {162,  69,  71},     {164,  68,  76},
    {166,  67,  80},     {169,  65,  84},     {171,  64,  88},     {174,  62,  92},
    {176,  61,  96},     {179,  60, 100},     {181,  58, 104},     {184,  57, 108},
    {186,  55, 113},     {189,  54, 117},     {191,  53, 121},     {194,  51, 125},
    {196,  50, 129},     {198,  49, 133},     {201,  47, 137},     {203,  46, 141},
    {206,  44, 145},     {208,  43, 150},     {211,  42, 154},     {213,  40, 158},
    {142,  81,  27},     {144,  79,  31},     {147,  78,  35},     {149,  76,  39},
    {152,  75,  43},     {154,  74,  47},     {157,  72,  52},     {159,  71,  56},
    {161,  69,  60},     {164,  68,  64},     {166,  67,  68},     {169,  65,  72},
    {171,  64,  76},     {174,  62,  80},     {176,  61,  84},     {179,  60,  89},
    {181,  58,  93},     {184,  57,  97},     {186,  56, 101},     {188,  54, 105},
    {191,  53, 109},     {193,  51, 113},     {196,  50, 117},     {198,  49, 121},
    {201,  47, 126},     {203,  46, 130},     {206,  44, 134},     {208,  43, 138},
    {211,  42, 142},     {213,  40, 146},     {216,  39, 150},     {218,  37, 154},
    {147,  78,  23},     {149,  76,  27},     {152,  75,  32},     {154,  74,  36},
    {156,  72,  40},     {159,  71,  44},     {161,  69,  48},     {164,  68,  52},
    {166,  67,  56},     {169,  65,  60},     {171,  64,  65},     {174,  63,  69},
    {176,  61,  73},     {179,  60,  77},     {181,  58,  81},     {183,  57,  85},
    {186,  56,  89},     {188,  54,  93},     {191,  53,  97},     {193,  51, 102},
    {196,  50, 106},     {198,  49, 110},     {201,  47, 114},     {203,  46, 118},
    {206,  44, 122},     {208,  43, 126},     {211,  42, 130},     {213,  40, 134},
    {215,  39, 139},     {218,  38, 143},     {220,  36, 147},     {223,  35, 151},
    {151,  75,  20},     {154,  74,  24},     {156,  72,  28},     {159,  71,  32},
    {161,  70,  36},     {164,  68,  41},     {166,  67,  45},     {169,  65,  49},
    {171,  64,  53},     {174,  63,  57},     {176,  61,  61},     {178,  60,  65},
    {181,  58,  69},     {183,  57,  73},     {186,  56,  78},     {188,  54,  82},
    {191,  53,  86},     {193,  51,  90},     {196,  50,  94},     {198,  49,  98},
    {201,  47, 102},     {203,  46, 106},     {206,  45, 110},     {208,  43, 115},
    {210,  42, 119},     {213,  40, 123},     {215,  39, 127},     {218,  38, 131},
    {220,  36, 135},     {223,  35, 139},     {225,  33, 143},     {228,  32, 147},
    {156,  72,  16},     {159,  71,  21},     {161,  70,  25},     {164,  68,  29},
    {166,  67,  33},     {169,  65,  37},     {171,  64,  41},     {173,  63,  45},
    {176,  61,  49},     {178,  60,  54},     {181,  58,  58},     {183,  57,  62},
    {186,  56,  66},     {188,  54,  70},     {191,  53,  74},     {193,  52,  78},
    {196,  50,  82},     {198,  49,  86},     {201,  47,  91},     {203,  46,  95},
    {205,  45,  99},     {208,  43, 103},     {210,  42, 107},     {213,  40, 111},
    {215,  39, 115},     {218,  38, 119},     {220,  36, 123},     {223,  35, 128},
    {225,  33, 132},     {228,  32, 136},     {230,  31, 140},     {232,  29, 144},
    {  8, 161, 123},     { 10, 160, 127},     { 12, 158, 131},     { 15, 157, 135},
    { 17, 155, 139},     { 20, 154, 143},     { 22, 153, 147},     { 25, 151, 151},
    { 27, 150, 156},     { 30, 148, 160},     { 32, 147, 164},     { 35, 146, 168},
    { 37, 144, 172},     { 39, 143, 176},     { 42, 141, 180},     { 44, 140, 184},
    { 47, 139, 188},     { 49, 137, 193},     { 52, 136, 197},     { 54, 134, 201},
    { 57, 133, 205},     { 59, 132, 209},     { 62, 130, 213},     { 64, 129, 217},
    { 67, 128, 221},     { 69, 126, 225},     { 71, 125, 230},     { 74, 123, 234},
    { 76, 122, 238},     { 79, 121, 242},     { 81, 119, 246},     { 84, 118, 250},
    { 12, 158, 119},     { 15, 157, 123},     { 17, 155, 127},     { 20, 154, 132},
    { 22, 153, 136},     { 25, 151, 140},     { 27, 150, 144},     { 30, 148, 148},
    { 32, 147, 152},     { 34, 146, 156},     { 37, 144, 160},     { 39, 143, 164},
    { 42, 141, 169},     { 44, 140, 173},     { 47, 139, 177},     { 49, 137, 181},
    { 52, 136, 185},     { 54, 135, 189},     { 57, 133, 193},     { 59, 132, 197},
    { 62, 130, 201},     { 64, 129, 206},     { 66, 128, 210},     { 69, 126, 214},
    { 71, 125, 218},     { 74, 123, 222},     { 76, 122, 226},     { 79, 121, 230},
    { 81, 119, 234},     { 84, 118, 238},     { 86, 116, 243},     { 89, 115, 247},
    { 17, 155, 116},     { 20, 154, 120},     { 22, 153, 124},     { 25, 151, 128},
    { 27, 150, 132},     { 29, 149, 136},     { 32, 147, 140},     { 34, 146, 145},
    { 37, 144, 149},     { 39, 143, 153},     { 42, 142, 157},     { 44, 140, 161},
    { 47, 139, 165},     { 49, 137, 169},     { 52, 136, 173},     { 54, 135, 177},
    { 57, 133, 182},     { 59, 132, 186},     { 61, 130, 190},     { 64, 129, 194},
    { 66, 128, 198},     { 69, 126, 202},     { 71, 125, 206},     { 74, 123, 210},
    { 76, 122, 214},     { 79, 121, 219},     { 81, 119, 223},     { 84, 118, 227},
    { 86, 117, 231},     { 88, 115, 235},     { 91, 114, 239},     { 93, 112, 243},
    { 22, 153, 112},     { 24, 151, 116},     { 27, 150, 121},     { 29, 149, 125},
    { 32, 147, 129},     { 34, 146, 133},     { 37, 144, 137},     { 39, 143, 141},
    { 42, 142, 145},     { 44, 140, 149},     { 47, 139, 153},     { 49, 137, 158},
    { 52, 136, 162},     { 54, 135, 166},     { 56, 133, 170},     { 59, 132, 174},
    { 61, 130, 178},     { 64, 129, 182},     { 66, 128, 186},     { 69, 126, 190},
    { 71, 125, 195},     { 74, 124, 199},     { 76, 122, 203},     { 79, 121, 207},
    { 81, 119, 211},     { 83, 118, 215},     { 86, 117, 219},     { 88, 115, 223},
    { 91, 114, 227},     { 93, 112, 232},     { 96, 111, 236},     { 98, 110, 240},
    { 27, 150, 109},     { 29, 149, 113},     { 32, 147, 117},     { 34, 146, 121},
    { 37, 144, 125},     { 39, 143, 129},     { 42, 142, 134},     { 44, 140, 138},
    { 46, 139, 142},     { 49, 138, 146},     { 51, 136, 150},     { 54, 135, 154},
    { 56, 133, 158},     { 59, 132, 162},     { 61, 131, 166},     { 64, 129, 171},
    { 66, 128, 175},     { 69, 126, 179},     { 71, 125, 183},     { 74, 124, 187},
    { 76, 122, 191},     { 78, 121, 195},     { 81, 119, 199},     { 83, 118, 203},
    { 86, 117, 208},     { 88, 115, 212},     { 91, 114, 216},     { 93, 112, 220},
    { 96, 111, 224},     { 98, 110, 228},     {101, 108, 232},     {103, 107, 236},
    { 32, 147, 105},     { 34, 146, 110},     { 37, 145, 114},     { 39, 143, 118},
    { 41, 142, 122},     { 44, 140, 126},     { 46, 139, 130},     { 49, 138, 134},
    { 51, 136, 138},     { 54, 135, 142},     { 56, 133, 147},     { 59, 132, 151},
    { 61, 131, 155},     { 64, 129, 159},     { 66, 128, 163},     { 69, 126, 167},
    { 71, 125, 171},     { 73, 124, 175},     { 76, 122, 179},     { 78, 121, 184},
    { 81, 119, 188},     { 83, 118, 192},     { 86, 117, 196},     { 88, 115, 200},
    { 91, 114, 204},     { 93, 113, 208},     { 96, 111, 212},     { 98, 110, 216},
    {101, 108, 221},     {103, 107, 225},     {105, 106, 229},     {108, 104, 233},
    { 36, 145, 102},     { 39, 143, 106},     { 41, 142, 110},     { 44, 140, 114},
    { 46, 139, 118},     { 49, 138, 123},     { 51, 136, 127},     { 54, 135, 131},
    { 56, 133, 135},     { 59, 132, 139},     { 61, 131, 143},     { 64, 129, 147},
    { 66, 128, 151},     { 68, 126, 155},     { 71, 125, 160},     { 73, 124, 164},
    { 76, 122, 168},     { 78, 121, 172},     { 81, 120, 176},     { 83, 118, 180},
    { 86, 117, 184},     { 88, 115, 188},     { 91, 114, 192},     { 93, 113, 197},
    { 96, 111, 201},     { 98, 110, 205},     {100, 108, 209},     {103, 107, 213},
    {105, 106, 217},     {108, 104, 221},     {110, 103, 225},     {113, 101, 229},
    { 41, 142,  99},     { 44, 140, 103},     { 46, 139, 107},     { 49, 138, 111},
    { 51, 136, 115},     { 54, 135, 119},     { 56, 134, 123},     { 59, 132, 127},
    { 61, 131, 131},     { 63, 129, 136},     { 66, 128, 140},     { 68, 127, 144},
    { 71, 125, 148},     { 73, 124, 152},     { 76, 122, 156},     { 78, 121, 160},
    { 81, 120, 164},     { 83, 118, 168},     { 86, 117, 173},     { 88, 115, 177},
    { 90, 114, 181},     { 93, 113, 185},     { 95, 111, 189},     { 98, 110, 193},
    {100, 108, 197},     {103, 107, 201},     {105, 106, 205},     {108, 104, 210},
    {110, 103, 214},     {113, 102, 218},     {115, 100, 222},     {118,  99, 226},
    { 46, 139,  95},     { 49, 138,  99},     { 51, 136, 103},     { 54, 135, 107},
    { 56, 134, 112},     { 58, 132, 116},     { 61, 131, 120},     { 63, 129, 124},
    { 66, 128, 128},     { 68, 127, 132},     { 71, 125, 136},     { 73, 124, 140},
    { 76, 122, 144},     { 78, 121, 149},     { 81, 120, 153},     { 83, 118, 157},
    { 85, 117, 161},     { 88, 115, 165},     { 90, 114, 169},     { 93, 113, 173},
    { 95, 111, 177},     { 98, 110, 181},     {100, 109, 186},     {103, 107, 190},
    {105, 106, 194},     {108, 104, 198},     {110, 103, 202},     {113, 102, 206},
    {115, 100, 210},     {117,  99, 214},     {120,  97, 218},     {122,  96, 223},
    { 51, 136,  92},     { 53, 135,  96},     { 56, 134, 100},     { 58, 132, 104},
    { 61, 131, 108},     { 63, 129, 112},     { 66, 128, 116},     { 68, 127, 120},
    { 71, 125, 125},     { 73, 124, 129},     { 76, 122, 133},     { 78, 121, 137},
    { 80, 120, 141},     { 83, 118, 145},     { 85, 117, 149},     { 88, 116, 153},
    { 90, 114, 157},     { 93, 113, 162},     { 95, 111, 166},     { 98, 110, 170},
    {100, 109, 174},     {103, 107, 178},     {105, 106, 182},     {108, 104, 186},
    {110, 103, 190},     {112, 102, 194},     {115, 100, 199},     {117,  99, 203},
    {120,  97, 207},     {122,  96, 211},     {125,  95, 215},     {127,  93, 219},
    { 56, 134,  88},     { 58, 132,  92},     { 61, 131,  96},     { 63, 130, 101},
    { 66, 128, 105},     { 68, 127, 109},     { 71, 125, 113},     { 73, 124, 117},
    { 75, 123, 121},     { 78, 121, 125},     { 80, 120, 129},     { 83, 118, 133},
    { 85, 117, 138},     { 88, 116, 142},     { 90, 114, 146},     { 93, 113, 150},
    { 95, 111, 154},     { 98, 110, 158},     {100, 109, 162},     {103, 107, 166},
    {105, 106, 170},     {107, 104, 175},     {110, 103, 179},     {112, 102, 183},
    {115, 100, 187},     {117,  99, 191},     {120,  98, 195},     {122,  96, 199},
    {125,  95, 203},     {127,  93, 207},     {130,  92, 212},     {132,  91, 216},
    { 61, 131,  85},     { 63, 130,  89},     { 66, 128,  93},     { 68, 127,  97},
    { 70, 125, 101},     { 73, 124, 105},     { 75, 123, 109},     { 78, 121, 114},
    { 80, 120, 118},     { 83, 118, 122},     { 85, 117, 126},     { 88, 116, 130},
    { 90, 114, 134},     { 93, 113, 138},     { 95, 111, 142},     { 98, 110, 146},
    {100, 109, 151},     {102, 107, 155},     {105, 106, 159},     {107, 105, 163},
    {110, 103, 167},     {112, 102, 171},     {115, 100, 175},     {117,  99, 179},
    {120,  98, 183},     {122,  96, 188},     {125,  95, 192},     {127,  93, 196},
    {129,  92, 200},     {132,  91, 204},     {134,  89, 208},     {137,  88, 212},
    { 65, 128,  81},     { 68, 127,  85},     { 70, 125,  90},     { 73, 124,  94},
    { 75, 123,  98},     { 78, 121, 102},     { 80, 120, 106},     { 83, 118, 110},
    { 85, 117, 114},     { 88, 116, 118},     { 90, 114, 122},     { 92, 113, 127},
    { 95, 112, 131},     { 97, 110, 135},     {100, 109, 139},     {102, 107, 143},
    {105, 106, 147},     {107, 105, 151},     {110, 103, 155},     {112, 102, 159},
    {115, 100, 164},     {117,  99, 168},     {120,  98, 172},     {122,  96, 176},
    {124,  95, 180},     {127,  93, 184},     {129,  92, 188},     {132,  91, 192},
    {134,  89, 196},     {137,  88, 201},     {139,  87, 205},     {142,  85, 209},
    { 70, 126,  78},     { 73, 124,  82},     { 75, 123,  86},     { 78, 121,  90},
    { 80, 120,  94},     { 83, 119,  98},     { 85, 117, 103},     { 87, 116, 107},
    { 90, 114, 111},     { 92, 113, 115},     { 95, 112, 119},     { 97, 110, 123},
    {100, 109, 127},     {102, 107, 131},     {105, 106, 135},     {107, 105, 140},
    {110, 103, 144},     {112, 102, 148},     {115, 100, 152},     {117,  99, 156},
    {119,  98, 160},     {122,  96, 164},     {124,  95, 168},     {127,  94, 172},
    {129,  92, 177},     {132,  91, 181},     {134,  89, 185},     {137,  88, 189},
    {139,  87, 193},     {142,  85, 197},     {144,  84, 201},     {147,  82, 205},
    { 75, 123,  74},     { 78, 121,  79},     { 80, 120,  83},     { 82, 119,  87},
    { 85, 117,  91},     { 87, 116,  95},     { 90, 114,  99},     { 92, 113, 103},
    { 95, 112, 107},     { 97, 110, 111},     {100, 109, 116},     {102, 107, 120},
    {105, 106, 124},     {107, 105, 128},     {110, 103, 132},     {112, 102, 136},
    {114, 101, 140},     {117,  99, 144},     {119,  98, 148},     {122,  96, 153},
    {124,  95, 157},     {127,  94, 161},     {129,  92, 165},     {132,  91, 169},
    {134,  89, 173},     {137,  88, 177},     {139,  87, 181},     {142,  85, 185},
    {144,  84, 190},     {146,  82, 194},     {149,  81, 198},     {151,  80, 202},
    { 80, 120,  71},     { 82, 119,  75},     { 85, 117,  79},     { 87, 116,  83},
    { 90, 115,  87},     { 92, 113,  92},     { 95, 112,  96},     { 97, 110, 100},
    {100, 109, 104},     {102, 108, 108},     {105, 106, 112},     {107, 105, 116},
    {109, 103, 120},     {112, 102, 124},     {114, 101, 129},     {117,  99, 133},
    {119,  98, 137},     {122,  96, 141},     {124,  95, 145},     {127,  94, 149},
    {129,  92, 153},     {132,  91, 157},     {134,  89, 161},     {136,  88, 166},
    {139,  87, 170},     {141,  85, 174},     {144,  84, 178},     {146,  83, 182},
    {149,  81, 186},     {151,  80, 190},     {154,  78, 194},     {156,  77, 198},
    { 85, 117,  68},     { 87, 116,  72},     { 90, 115,  76},     { 92, 113,  80},
    { 95, 112,  84},     { 97, 110,  88},     {100, 109,  92},     {102, 108,  96},
    {104, 106, 100},     {107, 105, 105},     {109, 103, 109},     {112, 102, 113},
    {114, 101, 117},     {117,  99, 121},     {119,  98, 125},     {122,  96, 129},
    {124,  95, 133},     {127,  94, 137},     {129,  92, 142},     {131,  91, 146},
    {134,  90, 150},     {136,  88, 154},     {139,  87, 158},     {141,  85, 162},
    {144,  84, 166},     {146,  83, 170},     {149,  81, 174},     {151,  80, 179},
    {154,  78, 183},     {156,  77, 187},     {159,  76, 191},     {161,  74, 195},
    { 90, 115,  64},     { 92, 113,  68},     { 95, 112,  72},     { 97, 110,  76},
    { 99, 109,  81},     {102, 108,  85},     {104, 106,  89},     {107, 105,  93},
    {109, 103,  97},     {112, 102, 101},     {114, 101, 105},     {117,  99, 109},
    {119,  98, 113},     {122,  97, 118},     {124,  95, 122},     {126,  94, 126},
    {129,  92, 130},     {131,  91, 134},     {134,  90, 138},     {136,  88, 142},
    {139,  87, 146},     {141,  85, 150},     {144,  84, 155},     {146,  83, 159},
    {149,  81, 163},     {151,  80, 167},     {154,  78, 171},     {156,  77, 175},
    {158,  76, 179},     {161,  74, 183},     {163,  73, 187},     {166,  72, 192},
    { 94, 112,  61},     { 97, 111,  65},     { 99, 109,  69},     {102, 108,  73},
    {104, 106,  77},     {107, 105,  81},     {109, 104,  85},     {112, 102,  89},
    {114, 101,  94},     {117,  99,  98},     {119,  98, 102},     {121,  97, 106},
    {124,  95, 110},     {126,  94, 114},     {129,  92, 118},     {131,  91, 122},
    {134,  90, 126},     {136,  88, 131},     {139,  87, 135},     {141,  85, 139},
    {144,  84, 143},     {146,  83, 147},     {149,  81, 151},     {151,  80, 155},
    {153,  79, 159},     {156,  77, 163},     {158,  76, 168},     {161,  74, 172},
    {163,  73, 176},     {166,  72, 180},     {168,  70, 184},     {171,  69, 188},
    { 99, 109,  57},     {102, 108,  61},     {104, 106,  65},     {107, 105,  70},
    {109, 104,  74},     {112, 102,  78},     {114, 101,  82},     {116,  99,  86},
    {119,  98,  90},     {121,  97,  94},     {124,  95,  98},     {126,  94, 102},
    {129,  92, 107},     {131,  91, 111},     {134,  90, 115},     {136,  88, 119},
    {139,  87, 123},     {141,  86, 127},     {144,  84, 131},     {146,  83, 135},
    {148,  81, 139},     {151,  80, 144},     {153,  79, 148},     {156,  77, 152},
    {158,  76, 156},     {161,  74, 160},     {163,  73, 164},     {166,  72, 168},
    {168,  70, 172},     {171,  69, 176},     {173,  67, 181},     {175,  66, 185},
    {104, 106,  54},     {107, 105,  58},     {109, 104,  62},     {111, 102,  66},
    {114, 101,  70},     {116,  99,  74},     {119,  98,  78},     {121,  97,  83},
    {124,  95,  87},     {126,  94,  91},     {129,  93,  95},     {131,  91,  99},
    {134,  90, 103},     {136,  88, 107},     {139,  87, 111},     {141,  86, 115},
    {143,  84, 120},     {146,  83, 124},     {148,  81, 128},     {151,  80, 132},
    {153,  79, 136},     {156,  77, 140},     {158,  76, 144},     {161,  74, 148},
    {163,  73, 152},     {166,  72, 157},     {168,  70, 161},     {170,  69, 165},
    {173,  68, 169},     {175,  66, 173},     {178,  65, 177},     {180,  63, 181},
    {109, 104,  50},     {111, 102,  54},     {114, 101,  59},     {116, 100,  63},
    {119,  98,  67},     {121,  97,  71},     {124,  95,  75},     {126,  94,  79},
    {129,  93,  83},     {131,  91,  87},     {133,  90,  91},     {136,  88,  96},
    {138,  87, 100},     {141,  86, 104},     {143,  84, 108},     {146,  83, 112},
    {148,  81, 116},     {151,  80, 120},     {153,  79, 124},     {156,  77, 128},
    {158,  76, 133},     {161,  75, 137},     {163,  73, 141},     {165,  72, 145},
    {168,  70, 149},     {170,  69, 153},     {173,  68, 157},     {175,  66, 161},
    {178,  65, 165},     {180,  63, 170},     {183,  62, 174},     {185,  61, 178},
    {114, 101,  47},     {116, 100,  51},     {119,  98,  55},     {121,  97,  59},
    {124,  95,  63},     {126,  94,  67},     {128,  93,  72},     {131,  91,  76},
    {133,  90,  80},     {136,  88,  84},     {138,  87,  88},     {141,  86,  92},
    {143,  84,  96},     {146,  83, 100},     {148,  82, 104},     {151,  80, 109},
    {153,  79, 113},     {156,  77, 117},     {158,  76, 121},     {160,  75, 125},
    {163,  73, 129},     {165,  72, 133},     {168,  70, 137},     {170,  69, 141},
    {173,  68, 146},     {175,  66, 150},     {178,  65, 154},     {180,  63, 158},
    {183,  62, 162},     {185,  61, 166},     {188,  59, 170},     {190,  58, 174},
    {119,  98,  43},     {121,  97,  48},     {123,  95,  52},     {126,  94,  56},
    {128,  93,  60},     {131,  91,  64},     {133,  90,  68},     {136,  89,  72},
    {138,  87,  76},     {141,  86,  80},     {143,  84,  85},     {146,  83,  89},
    {148,  82,  93},     {151,  80,  97},     {153,  79, 101},     {155,  77, 105},
    {158,  76, 109},     {160,  75, 113},     {163,  73, 117},     {165,  72, 122},
    {168,  70, 126},     {170,  69, 130},     {173,  68, 134},     {175,  66, 138},
    {178,  65, 142},     {180,  64, 146},     {183,  62, 150},     {185,  61, 154},
    {187,  59, 159},     {190,  58, 163},     {192,  57, 167},     {195,  55, 171},
    {123,  96,  40},     {126,  94,  44},     {128,  93,  48},     {131,  91,  52},
    {133,  90,  56},     {136,  89,  61},     {138,  87,  65},     {141,  86,  69},
    {143,  84,  73},     {146,  83,  77},     {148,  82,  81},     {150,  80,  85},
    {153,  79,  89},     {155,  77,  93},     {158,  76,  98},     {160,  75, 102},
    {163,  73, 106},     {165,  72, 110},     {168,  71, 114},     {170,  69, 118},
    {173,  68, 122},     {175,  66, 126},     {177,  65, 130},     {180,  64, 135},
    {182,  62, 139},     {185,  61, 143},     {187,  59, 147},     {190,  58, 151},
    {192,  57, 155},     {195,  55, 159},     {197,  54, 163},     {200,  52, 167},
    {128,  93,  37},     {131,  91,  41},     {133,  90,  45},     {136,  89,  49},
    {138,  87,  53},     {141,  86,  57},     {143,  84,  61},     {145,  83,  65},
    {148,  82,  69},     {150,  80,  74},     {153,  79,  78},     {155,  78,  82},
    {158,  76,  86},     {160,  75,  90},     {163,  73,  94},     {165,  72,  98},
    {168,  71, 102},     {170,  69, 106},     {172,  68, 111},     {175,  66, 115},
    {177,  65, 119},     {180,  64, 123},     {182,  62, 127},     {185,  61, 131},
    {187,  59, 135},     {190,  58, 139},     {192,  57, 143},     {195,  55, 148},
    {197,  54, 152},     {200,  53, 156},     {202,  51, 160},     {204,  50, 164},
    {133,  90,  33},     {136,  89,  37},     {138,  87,  41},     {140,  86,  45},
    {143,  85,  50},     {145,  83,  54},     {148,  82,  58},     {150,  80,  62},
    {153,  79,  66},     {155,  78,  70},     {158,  76,  74},     {160,  75,  78},
    {163,  73,  82},     {165,  72,  87},     {167,  71,  91},     {170,  69,  95},
    {172,  68,  99},     {175,  66, 103},     {177,  65, 107},     {180,  64, 111},
    {182,  62, 115},     {185,  61, 119},     {187,  60, 124},     {190,  58, 128},
    {192,  57, 132},     {195,  55, 136},     {197,  54, 140},     {199,  53, 144},
    {202,  51, 148},     {204,  50, 152},     {207,  48, 156},     {209,  47, 161},
    {138,  87,  30},     {140,  86,  34},     {143,  85,  38},     {145,  83,  42},
    {148,  82,  46},     {150,  80,  50},     {153,  79,  54},     {155,  78,  58},
    {158,  76,  63},     {160,  75,  67},     {162,  73,  71},     {165,  72,  75},
    {167,  71,  79},     {170,  69,  83},     {172,  68,  87},     {175,  67,  91},
    {177,  65,  95},     {180,  64, 100},     {182,  62, 104},     {185,  61, 108},
    {187,  60, 112},     {190,  58, 116},     {192,  57, 120},     {194,  55, 124},
    {197,  54, 128},     {199,  53, 132},     {202,  51, 137},     {204,  50, 141},
    {207,  48, 145},     {209,  47, 149},     {212,  46, 153},     {214,  44, 157},
    {143,  85,  26},     {145,  83,  30},     {148,  82,  34},     {150,  80,  39},
    {153,  79,  43},     {155,  78,  47},     {157,  76,  51},     {160,  75,  55},
    {162,  74,  59},     {165,  72,  63},     {167,  71,  67},     {170,  69,  71},
    {172,  68,  76},     {175,  67,  80},     {177,  65,  84},     {180,  64,  88},
    {182,  62,  92},     {185,  61,  96},     {187,  60, 100},     {189,  58, 104},
    {192,  57, 108},     {194,  55, 113},     {197,  54, 117},     {199,  53, 121},
    {202,  51, 125},     {204,  50, 129},     {207,  49, 133},     {209,  47, 137},
    {212,  46, 141},     {214,  44, 145},     {216,  43, 150},     {219,  42, 154},
    {148,  82,  23},     {150,  81,  27},     {152,  79,  31},     {155,  78,  35},
    {157,  76,  39},     {160,  75,  43},     {162,  74,  47},     {165,  72,  52},
    {167,  71,  56},     {170,  69,  60},     {172,  68,  64},     {175,  67,  68},
    {177,  65,  72},     {180,  64,  76},     {182,  62,  80},     {184,  61,  84},
    {187,  60,  89},     {189,  58,  93},     {192,  57,  97},     {194,  56, 101},
    {197,  54, 105},     {199,  53, 109},     {202,  51, 113},     {204,  50, 117},
    {207,  49, 121},     {209,  47, 126},     {211,  46, 130},     {214,  44, 134},
    {216,  43, 138},     {219,  42, 142},     {221,  40, 146},     {224,  39, 150},
    {152,  79,  19},     {155,  78,  23},     {157,  76,  27},     {160,  75,  32},
    {162,  74,  36},     {165,  72,  40},     {167,  71,  44},     {170,  69,  48},
    {172,  68,  52},     {174,  67,  56},     {177,  65,  60},     {179,  64,  65},
    {182,  63,  69},     {184,  61,  73},     {187,  60,  77},     {189,  58,  81},
    {192,  57,  85},     {194,  56,  89},     {197,  54,  93},     {199,  53,  97},
    {202,  51, 102},     {204,  50, 106},     {206,  49, 110},     {209,  47, 114},
    {211,  46, 118},     {214,  44, 122},     {216,  43, 126},     {219,  42, 130},
    {221,  40, 134},     {224,  39, 139},     {226,  38, 143},     {229,  36, 147},
    {157,  76,  16},     {160,  75,  20},     {162,  74,  24},     {165,  72,  28},
    {167,  71,  32},     {169,  70,  36},     {172,  68,  41},     {174,  67,  45},
    {177,  65,  49},     {179,  64,  53},     {182,  63,  57},     {184,  61,  61},
    {187,  60,  65},     {189,  58,  69},     {192,  57,  73},     {194,  56,  78},
    {197,  54,  82},     {199,  53,  86},     {201,  51,  90},     {204,  50,  94},
    {206,  49,  98},     {209,  47, 102},     {211,  46, 106},     {214,  45, 110},
    {216,  43, 115},     {219,  42, 119},     {221,  40, 123},     {224,  39, 127},
    {226,  38, 131},     {229,  36, 135},     {231,  35, 139},     {233,  33, 143},
    {  8, 165, 122},     { 11, 164, 126},     { 13, 162, 130},     { 16, 161, 134},
    { 18, 159, 138},     { 21, 158, 143},     { 23, 157, 147},     { 26, 155, 151},
    { 28, 154, 155},     { 31, 153, 159},     { 33, 151, 163},     { 35, 150, 167},
    { 38, 148, 171},     { 40, 147, 175},     { 43, 146, 180},     { 45, 144, 184},
    { 48, 143, 188},     { 50, 141, 192},     { 53, 140, 196},     { 55, 139, 200},
    { 58, 137, 204},     { 60, 136, 208},     { 63, 134, 212},     { 65, 133, 217},
    { 67, 132, 221},     { 70, 130, 225},     { 72, 129, 229},     { 75, 127, 233},
    { 77, 126, 237},     { 80, 125, 241},     { 82, 123, 245},     { 85, 122, 250},
    { 13, 162, 119},     { 16, 161, 123},     { 18, 160, 127},     { 21, 158, 131},
    { 23, 157, 135},     { 26, 155, 139},     { 28, 154, 143},     { 30, 153, 147},
    { 33, 151, 151},     { 35, 150, 156},     { 38, 148, 160},     { 40, 147, 164},
    { 43, 146, 168},     { 45, 144, 172},     { 48, 143, 176},     { 50, 141, 180},
    { 53, 140, 184},     { 55, 139, 188},     { 58, 137, 193},     { 60, 136, 197},
    { 62, 134, 201},     { 65, 133, 205},     { 67, 132, 209},     { 70, 130, 213},
    { 72, 129, 217},     { 75, 128, 221},     { 77, 126, 225},     { 80, 125, 230},
    { 82, 123, 234},     { 85, 122, 238},     { 87, 121, 242},     { 90, 119, 246},
    { 18, 160, 115},     { 21, 158, 119},     { 23, 157, 123},     { 25, 155, 127},
    { 28, 154, 132},     { 30, 153, 136},     { 33, 151, 140},     { 35, 150, 144},
    { 38, 148, 148},     { 40, 147, 152},     { 43, 146, 156},     { 45, 144, 160},
    { 48, 143, 164},     { 50, 141, 169},     { 53, 140, 173},     { 55, 139, 177},
    { 57, 137, 181},     { 60, 136, 185},     { 62, 135, 189},     { 65, 133, 193},
    { 67, 132, 197},     { 70, 130, 201},     { 72, 129, 206},     { 75, 128, 210},
    { 77, 126, 214},     { 80, 125, 218},     { 82, 123, 222},     { 85, 122, 226},
    { 87, 121, 230},     { 89, 119, 234},     { 92, 118, 238},     { 94, 116, 243},
    { 23, 157, 112},     { 25, 155, 116},     { 28, 154, 120},     { 30, 153, 124},
    { 33, 151, 128},     { 35, 150, 132},     { 38, 149, 136},     { 40, 147, 140},
    { 43, 146, 145},     { 45, 144, 149},     { 48, 143, 153},     { 50, 142, 157},
    { 52, 140, 161},     { 55, 139, 165},     { 57, 137, 169},     { 60, 136, 173},
    { 62, 135, 177},     { 65, 133, 182},     { 67, 132, 186},     { 70, 130, 190},
    { 72, 129, 194},     { 75, 128, 198},     { 77, 126, 202},     { 79, 125, 206},
    { 82, 123, 210},     { 84, 122, 214},     { 87, 121, 219},     { 89, 119, 223},
    { 92, 118, 227},     { 94, 117, 231},     { 97, 115, 235},     { 99, 114, 239},
    { 28, 154, 108},     { 30, 153, 112},     { 33, 151, 116},     { 35, 150, 121},
    { 38, 149, 125},     { 40, 147, 129},     { 43, 146, 133},     { 45, 144, 137},
    { 47, 143, 141},     { 50, 142, 145},     { 52, 140, 149},     { 55, 139, 153},
    { 57, 137, 158},     { 60, 136, 162},     { 62, 135, 166},     { 65, 133, 170},
    { 67, 132, 174},     { 70, 130, 178},     { 72, 129, 182},     { 74, 128, 186},
    { 77, 126, 190},     { 79, 125, 195},     { 82, 124, 199},     { 84, 122, 203},
    { 87, 121, 207},     { 89, 119, 211},     { 92, 118, 215},     { 94, 117, 219},
    { 97, 115, 223},     { 99, 114, 227},     {102, 112, 232},     {104, 111, 236},
    { 33, 151, 105},     { 35, 150, 109},     { 38, 149, 113},     { 40, 147, 117},
    { 42, 146, 121},     { 45, 144, 125},     { 47, 143, 129},     { 50, 142, 134},
    { 52, 140, 138},     { 55, 139, 142},     { 57, 138, 146},     { 60, 136, 150},
    { 62, 135, 154},     { 65, 133, 158},     { 67, 132, 162},     { 69, 131, 166},
    { 72, 129, 171},     { 74, 128, 175},     { 77, 126, 179},     { 79, 125, 183},
    { 82, 124, 187},     { 84, 122, 191},     { 87, 121, 195},     { 89, 119, 199},
    { 92, 118, 203},     { 94, 117, 208},     { 97, 115, 212},     { 99, 114, 216},
    {101, 112, 220},     {104, 111, 224},     {106, 110, 228},     {109, 108, 232},
    { 37, 149, 101},     { 40, 147, 105},     { 42, 146, 110},     { 45, 145, 114},
    { 47, 143, 118},     { 50, 142, 122},     { 52, 140, 126},     { 55, 139, 130},
    { 57, 138, 134},     { 60, 136, 138},     { 62, 135, 142},     { 64, 133, 147},
    { 67, 132, 151},     { 69, 131, 155},     { 72, 129, 159},     { 74, 128, 163},
    { 77, 126, 167},     { 79, 125, 171},     { 82, 124, 175},     { 84, 122, 179},
    { 87, 121, 184},     { 89, 119, 188},     { 92, 118, 192},     { 94, 117, 196},
    { 96, 115, 200},     { 99, 114, 204},     {101, 113, 208},     {104, 111, 212},
    {106, 110, 216},     {109, 108, 221},     {111, 107, 225},     {114, 106, 229},
    { 42, 146,  98},     { 45, 145, 102},     { 47, 143, 106},     { 50, 142, 110},
    { 52, 140, 114},     { 55, 139, 118},     { 57, 138, 123},     { 59, 136, 127},
    { 62, 135, 131},     { 64, 133, 135},     { 67, 132, 139},     { 69, 131, 143},
    { 72, 129, 147},     { 74, 128, 151},     { 77, 126, 155},     { 79, 125, 160},
    { 82, 124, 164},     { 84, 122, 168},     { 87, 121, 172},     { 89, 120, 176},
    { 91, 118, 180},     { 94, 117, 184},     { 96, 115, 188},     { 99, 114, 192},
    {101, 113, 197},     {104, 111, 201},     {106, 110, 205},     {109, 108, 209},
    {111, 107, 213},     {114, 106, 217},     {116, 104, 221},     {118, 103, 225},
    { 47, 143,  94},     { 50, 142,  99},     { 52, 140, 103},     { 54, 139, 107},
    { 57, 138, 111},     { 59, 136, 115},     { 62, 135, 119},     { 64, 134, 123},
    { 67, 132, 127},     { 69, 131, 131},     { 72, 129, 136},     { 74, 128, 140},
    { 77, 127, 144},     { 79, 125, 148},     { 82, 124, 152},     { 84, 122, 156},
    { 86, 121, 160},     { 89, 120, 164},     { 91, 118, 168},     { 94, 117, 173},
    { 96, 115, 177},     { 99, 114, 181},     {101, 113, 185},     {104, 111, 189},
    {106, 110, 193},     {109, 108, 197},     {111, 107, 201},     {113, 106, 205},
    {116, 104, 210},     {118, 103, 214},     {121, 102, 218},     {123, 100, 222},
    { 52, 141,  91},     { 54, 139,  95},     { 57, 138,  99},     { 59, 136, 103},
    { 62, 135, 107},     { 64, 134, 112},     { 67, 132, 116},     { 69, 131, 120},
    { 72, 129, 124},     { 74, 128, 128},     { 76, 127, 132},     { 79, 125, 136},
    { 81, 124, 140},     { 84, 122, 144},     { 86, 121, 149},     { 89, 120, 153},
    { 91, 118, 157},     { 94, 117, 161},     { 96, 115, 165},     { 99, 114, 169},
    {101, 113, 173},     {104, 111, 177},     {106, 110, 181},     {108, 109, 186},
    {111, 107, 190},     {113, 106, 194},     {116, 104, 198},     {118, 103, 202},
    {121, 102, 206},     {123, 100, 210},     {126,  99, 214},     {128,  97, 218},
    { 57, 138,  88},     { 59, 136,  92},     { 62, 135,  96},     { 64, 134, 100},
    { 67, 132, 104},     { 69, 131, 108},     { 71, 129, 112},     { 74, 128, 116},
    { 76, 127, 120},     { 79, 125, 125},     { 81, 124, 129},     { 84, 122, 133},
    { 86, 121, 137},     { 89, 120, 141},     { 91, 118, 145},     { 94, 117, 149},
    { 96, 116, 153},     { 99, 114, 157},     {101, 113, 162},     {103, 111, 166},
    {106, 110, 170},     {108, 109, 174},     {111, 107, 178},     {113, 106, 182},
    {116, 104, 186},     {118, 103, 190},     {121, 102, 194},     {123, 100, 199},
    {126,  99, 203},     {128,  97, 207},     {131,  96, 211},     {133,  95, 215},
    { 62, 135,  84},     { 64, 134,  88},     { 66, 132,  92},     { 69, 131,  96},
    { 71, 130, 101},     { 74, 128, 105},     { 76, 127, 109},     { 79, 125, 113},
    { 81, 124, 117},     { 84, 123, 121},     { 86, 121, 125},     { 89, 120, 129},
    { 91, 118, 133},     { 94, 117, 138},     { 96, 116, 142},     { 98, 114, 146},
    {101, 113, 150},     {103, 111, 154},     {106, 110, 158},     {108, 109, 162},
    {111, 107, 166},     {113, 106, 170},     {116, 104, 175},     {118, 103, 179},
    {121, 102, 183},     {123, 100, 187},     {126,  99, 191},     {128,  98, 195},
    {130,  96, 199},     {133,  95, 203},     {135,  93, 207},     {138,  92, 212},
    { 66, 132,  81},     { 69, 131,  85},     { 71, 130,  89},     { 74, 128,  93},
    { 76, 127,  97},     { 79, 125, 101},     { 81, 124, 105},     { 84, 123, 109},
    { 86, 121, 114},     { 89, 120, 118},     { 91, 118, 122},     { 93, 117, 126},
    { 96, 116, 130},     { 98, 114, 134},     {101, 113, 138},     {103, 111, 142},
    {106, 110, 146},     {108, 109, 151},     {111, 107, 155},     {113, 106, 159},
    {116, 105, 163},     {118, 103, 167},     {120, 102, 171},     {123, 100, 175},
    {125,  99, 179},     {128,  98, 183},     {130,  96, 188},     {133,  95, 192},
    {135,  93, 196},     {138,  92, 200},     {140,  91, 204},     {143,  89, 208},
    { 71, 130,  77},     { 74, 128,  81},     { 76, 127,  85},     { 79, 125,  90},
    { 81, 124,  94},     { 84, 123,  98},     { 86, 121, 102},     { 88, 120, 106},
    { 91, 118, 110},     { 93, 117, 114},     { 96, 116, 118},     { 98, 114, 122},
    {101, 113, 127},     {103, 112, 131},     {106, 110, 135},     {108, 109, 139},
    {111, 107, 143},     {113, 106, 147},     {115, 105, 151},     {118, 103, 155},
    {120, 102, 159},     {123, 100, 164},     {125,  99, 168},     {128,  98, 172},
    {130,  96, 176},     {133,  95, 180},     {135,  93, 184},     {138,  92, 188},
    {140,  91, 192},     {143,  89, 196},     {145,  88, 201},     {147,  87, 205},
    { 76, 127,  74},     { 78, 126,  78},     { 81, 124,  82},     { 83, 123,  86},
    { 86, 121,  90},     { 88, 120,  94},     { 91, 119,  98},     { 93, 117, 103},
    { 96, 116, 107},     { 98, 114, 111},     {101, 113, 115},     {103, 112, 119},
    {106, 110, 123},     {108, 109, 127},     {110, 107, 131},     {113, 106, 135},
    {115, 105, 140},     {118, 103, 144},     {120, 102, 148},     {123, 100, 152},
    {125,  99, 156},     {128,  98, 160},     {130,  96, 164},     {133,  95, 168},
    {135,  94, 172},     {138,  92, 177},     {140,  91, 181},     {142,  89, 185},
    {145,  88, 189},     {147,  87, 193},     {150,  85, 197},     {152,  84, 201},
    { 81, 124,  70},     { 83, 123,  74},     { 86, 121,  79},     { 88, 120,  83},
    { 91, 119,  87},     { 93, 117,  91},     { 96, 116,  95},     { 98, 114,  99},
    {101, 113, 103},     {103, 112, 107},     {105, 110, 111},     {108, 109, 116},
    {110, 107, 120},     {113, 106, 124},     {115, 105, 128},     {118, 103, 132},
    {120, 102, 136},     {123, 101, 140},     {125,  99, 144},     {128,  98, 148},
    {130,  96, 153},     {133,  95, 157},     {135,  94, 161},     {137,  92, 165},
    {140,  91, 169},     {142,  89, 173},     {145,  88, 177},     {147,  87, 181},
    {150,  85, 185},     {152,  84, 190},     {155,  82, 194},     {157,  81, 198},
    { 86, 121,  67},     { 88, 120,  71},     { 91, 119,  75},     { 93, 117,  79},
    { 96, 116,  83},     { 98, 115,  87},     {100, 113,  92},     {103, 112,  96},
    {105, 110, 100},     {108, 109, 104},     {110, 108, 108},     {113, 106, 112},
    {115, 105, 116},     {118, 103, 120},     {120, 102, 124},     {123, 101, 129},
    {125,  99, 133},     {128,  98, 137},     {130,  96, 141},     {132,  95, 145},
    {135,  94, 149},     {137,  92, 153},     {140,  91, 157},     {142,  89, 161},
    {145,  88, 166},     {147,  87, 170},     {150,  85, 174},     {152,  84, 178},
    {155,  83, 182},     {157,  81, 186},     {159,  80, 190},     {162,  78, 194},
    { 91, 119,  63},     { 93, 117,  68},     { 95, 116,  72},     { 98, 115,  76},
    {100, 113,  80},     {103, 112,  84},     {105, 110,  88},     {108, 109,  92},
    {110, 108,  96},     {113, 106, 100},     {115, 105, 105},     {118, 103, 109},
    {120, 102, 113},     {122, 101, 117},     {125,  99, 121},     {127,  98, 125},
    {130,  96, 129},     {132,  95, 133},     {135,  94, 137},     {137,  92, 142},
    {140,  91, 146},     {142,  90, 150},     {145,  88, 154},     {147,  87, 158},
    {150,  85, 162},     {152,  84, 166},     {154,  83, 170},     {157,  81, 174},
    {159,  80, 179},     {162,  78, 183},     {164,  77, 187},     {167,  76, 191},
    { 95, 116,  60},     { 98, 115,  64},     {100, 113,  68},     {103, 112,  72},
    {105, 110,  76},     {108, 109,  81},     {110, 108,  85},     {113, 106,  89},
    {115, 105,  93},     {117, 103,  97},     {120, 102, 101},     {122, 101, 105},
    {125,  99, 109},     {127,  98, 113},     {130,  97, 118},     {132,  95, 122},
    {135,  94, 126},     {137,  92, 130},     {140,  91, 134},     {142,  90, 138},
    {145,  88, 142},     {147,  87, 146},     {149,  85, 150},     {152,  84, 155},
    {154,  83, 159},     {157,  81, 163},     {159,  80, 167},     {162,  78, 171},
    {164,  77, 175},     {167,  76, 179},     {169,  74, 183},     {172,  73, 187},
    {100, 113,  57},     {103, 112,  61},     {105, 111,  65},     {108, 109,  69},
    {110, 108,  73},     {112, 106,  77},     {115, 105,  81},     {117, 104,  85},
    {120, 102,  89},     {122, 101,  94},     {125,  99,  98},     {127,  98, 102},
    {130,  97, 106},     {132,  95, 110},     {135,  94, 114},     {137,  92, 118},
    {140,  91, 122},     {142,  90, 126},     {144,  88, 131},     {147,  87, 135},
    {149,  85, 139},     {152,  84, 143},     {154,  83, 147},     {157,  81, 151},
    {159,  80, 155},     {162,  79, 159},     {164,  77, 163},     {167,  76, 168},
    {169,  74, 172},     {172,  73, 176},     {174,  72, 180},     {176,  70, 184},
    {105, 111,  53},     {107, 109,  57},     {110, 108,  61},     {112, 106,  65},
    {115, 105,  70},     {117, 104,  74},     {120, 102,  78},     {122, 101,  82},
    {125,  99,  86},     {127,  98,  90},     {130,  97,  94},     {132,  95,  98},
    {135,  94, 102},     {137,  92, 107},     {139,  91, 111},     {142,  90, 115},
    {144,  88, 119},     {147,  87, 123},     {149,  86, 127},     {152,  84, 131},
    {154,  83, 135},     {157,  81, 139},     {159,  80, 144},     {162,  79, 148},
    {164,  77, 152},     {166,  76, 156},     {169,  74, 160},     {171,  73, 164},
    {174,  72, 168},     {176,  70, 172},     {179,  69, 176},     {181,  67, 181},
    {110, 108,  50},     {112, 106,  54},     {115, 105,  58},     {117, 104,  62},
    {120, 102,  66},     {122, 101,  70},     {125,  99,  74},     {127,  98,  78},
    {130,  97,  83},     {132,  95,  87},     {134,  94,  91},     {137,  93,  95},
    {139,  91,  99},     {142,  90, 103},     {144,  88, 107},     {147,  87, 111},
    {149,  86, 115},     {152,  84, 120},     {154,  83, 124},     {157,  81, 128},
    {159,  80, 132},     {161,  79, 136},     {164,  77, 140},     {166,  76, 144},
    {169,  74, 148},     {171,  73, 152},     {174,  72, 157},     {176,  70, 161},
    {179,  69, 165},     {181,  68, 169},     {184,  66, 173},     {186,  65, 177},
    {115, 105,  46},     {117, 104,  50},     {120, 102,  54},     {122, 101,  59},
    {125, 100,  63},     {127,  98,  67},     {129,  97,  71},     {132,  95,  75},
    {134,  94,  79},     {137,  93,  83},     {139,  91,  87},     {142,  90,  91},
    {144,  88,  96},     {147,  87, 100},     {149,  86, 104},     {152,  84, 108},
    {154,  83, 112},     {156,  81, 116},     {159,  80, 120},     {161,  79, 124},
    {164,  77, 128},     {166,  76, 133},     {169,  75, 137},     {171,  73, 141},
    {174,  72, 145},     {176,  70, 149},     {179,  69, 153},     {181,  68, 157},
    {184,  66, 161},     {186,  65, 165},     {188,  63, 170},     {191,  62, 174},
    {119, 102,  43},     {122, 101,  47},     {124, 100,  51},     {127,  98,  55},
    {129,  97,  59},     {132,  95,  63},     {134,  94,  67},     {137,  93,  72},
    {139,  91,  76},     {142,  90,  80},     {144,  88,  84},     {147,  87,  88},
    {149,  86,  92},     {151,  84,  96},     {154,  83, 100},     {156,  82, 104},
    {159,  80, 109},     {161,  79, 113},     {164,  77, 117},     {166,  76, 121},
    {169,  75, 125},     {171,  73, 129},     {174,  72, 133},     {176,  70, 137},
    {179,  69, 141},     {181,  68, 146},     {183,  66, 150},     {186,  65, 154},
    {188,  63, 158},     {191,  62, 162},     {193,  61, 166},     {196,  59, 170},
    {124, 100,  39},     {127,  98,  43},     {129,  97,  48},     {132,  95,  52},
    {134,  94,  56},     {137,  93,  60},     {139,  91,  64},     {142,  90,  68},
    {144,  89,  72},     {146,  87,  76},     {149,  86,  80},     {151,  84,  85},
    {154,  83,  89},     {156,  82,  93},     {159,  80,  97},     {161,  79, 101},
    {164,  77, 105},     {166,  76, 109},     {169,  75, 113},     {171,  73, 117},
    {174,  72, 122},     {176,  70, 126},     {178,  69, 130},     {181,  68, 134},
    {183,  66, 138},     {186,  65, 142},     {188,  64, 146},     {191,  62, 150},
    {193,  61, 154},     {196,  59, 159},     {198,  58, 163},     {201,  57, 167},
    {129,  97,  36},     {132,  96,  40},     {134,  94,  44},     {137,  93,  48},
    {139,  91,  52},     {141,  90,  56},     {144,  89,  61},     {146,  87,  65},
    {149,  86,  69},     {151,  84,  73},     {154,  83,  77},     {156,  82,  81},
    {159,  80,  85},     {161,  79,  89},     {164,  77,  93},     {166,  76,  98},
    {169,  75, 102},     {171,  73, 106},     {173,  72, 110},     {176,  71, 114},
    {178,  69, 118},     {181,  68, 122},     {183,  66, 126},     {186,  65, 130},
    {188,  64, 135},     {191,  62, 139},     {193,  61, 143},     {196,  59, 147},
    {198,  58, 151},     {200,  57, 155},     {203,  55, 159},     {205,  54, 163},
    {134,  94,  32},     {136,  93,  37},     {139,  91,  41},     {141,  90,  45},
    {144,  89,  49},     {146,  87,  53},     {149,  86,  57},     {151,  84,  61},
    {154,  83,  65},     {156,  82,  69},     {159,  80,  74},     {161,  79,  78},
    {163,  78,  82},     {166,  76,  86},     {168,  75,  90},     {171,  73,  94},
    {173,  72,  98},     {176,  71, 102},     {178,  69, 106},     {181,  68, 111},
    {183,  66, 115},     {186,  65, 119},     {188,  64, 123},     {191,  62, 127},
    {193,  61, 131},     {195,  59, 135},     {198,  58, 139},     {200,  57, 143},
    {203,  55, 148},     {205,  54, 152},     {208,  53, 156},     {210,  51, 160},
    {139,  92,  29},     {141,  90,  33},     {144,  89,  37},     {146,  87,  41},
    {149,  86,  45},     {151,  85,  50},     {154,  83,  54},     {156,  82,  58},
    {158,  80,  62},     {161,  79,  66},     {163,  78,  70},     {166,  76,  74},
    {168,  75,  78},     {171,  73,  82},     {173,  72,  87},     {176,  71,  91},
    {178,  69,  95},     {181,  68,  99},     {183,  66, 103},     {186,  65, 107},
    {188,  64, 111},     {190,  62, 115},     {193,  61, 119},     {195,  60, 124},
    {198,  58, 128},     {200,  57, 132},     {203,  55, 136},     {205,  54, 140},
    {208,  53, 144},     {210,  51, 148},     {213,  50, 152},     {215,  48, 156},
    {144,  89,  25},     {146,  87,  30},     {149,  86,  34},     {151,  85,  38},
    {153,  83,  42},     {156,  82,  46},     {158,  80,  50},     {161,  79,  54},
    {163,  78,  58},     {166,  76,  63},     {168,  75,  67},     {171,  73,  71},
    {173,  72,  75},     {176,  71,  79},     {178,  69,  83},     {181,  68,  87},
    {183,  67,  91},     {185,  65,  95},     {188,  64, 100},     {190,  62, 104},
    {193,  61, 108},     {195,  60, 112},     {198,  58, 116},     {200,  57, 120},
    {203,  55, 124},     {205,  54, 128},     {208,  53, 132},     {210,  51, 137},
    {213,  50, 141},     {215,  48, 145},     {217,  47, 149},     {220,  46, 153},
    {148,  86,  22},     {151,  85,  26},     {153,  83,  30},     {156,  82,  34},
    {158,  80,  39},     {161,  79,  43},     {163,  78,  47},     {166,  76,  51},
    {168,  75,  55},     {171,  74,  59},     {173,  72,  63},     {176,  71,  67},
    {178,  69,  71},     {180,  68,  76},     {183,  67,  80},     {185,  65,  84},
    {188,  64,  88},     {190,  62,  92},     {193,  61,  96},     {195,  60, 100},
    {198,  58, 104},     {200,  57, 108},     {203,  55, 113},     {205,  54, 117},
    {207,  53, 121},     {210,  51, 125},     {212,  50, 129},     {215,  49, 133},
    {217,  47, 137},     {220,  46, 141},     {222,  44, 145},     {225,  43, 150},
    {153,  83,  19},     {156,  82,  23},     {158,  81,  27},     {161,  79,  31},
    {163,  78,  35},     {166,  76,  39},     {168,  75,  43},     {171,  74,  47},
    {173,  72,  52},     {175,  71,  56},     {178,  69,  60},     {180,  68,  64},
    {183,  67,  68},     {185,  65,  72},     {188,  64,  76},     {190,  62,  80},
    {193,  61,  84},     {195,  60,  89},     {198,  58,  93},     {200,  57,  97},
    {202,  56, 101},     {205,  54, 105},     {207,  53, 109},     {210,  51, 113},
    {212,  50, 117},     {215,  49, 121},     {217,  47, 126},     {220,  46, 130},
    {222,  44, 134},     {225,  43, 138},     {227,  42, 142},     {230,  40, 146},
    {158,  81,  15},     {161,  79,  19},     {163,  78,  23},     {166,  76,  27},
    {168,  75,  32},     {170,  74,  36},     {173,  72,  40},     {175,  71,  44},
    {178,  69,  48},     {180,  68,  52},     {183,  67,  56},     {185,  65,  60},
    {188,  64,  65},     {190,  63,  69},     {193,  61,  73},     {195,  60,  77},
    {197,  58,  81},     {200,  57,  85},     {202,  56,  89},     {205,  54,  93},
    {207,  53,  97},     {210,  51, 102},     {212,  50, 106},     {215,  49, 110},
    {217,  47, 114},     {220,  46, 118},     {222,  44, 122},     {225,  43, 126},
    {227,  42, 130},     {229,  40, 134},     {232,  39, 139},     {234,  38, 143},
    {  9, 169, 121},     { 12, 168, 125},     { 14, 166, 130},     { 17, 165, 134},
    { 19, 164, 138},     { 22, 162, 142},     { 24, 161, 146},     { 27, 159, 150},
    { 29, 158, 154},     { 32, 157, 158},     { 34, 155, 162},     { 36, 154, 167},
    { 39, 152, 171},     { 41, 151, 175},     { 44, 150, 179},     { 46, 148, 183},
    { 49, 147, 187},     { 51, 145, 191},     { 54, 144, 195},     { 56, 143, 199},
    { 59, 141, 204},     { 61, 140, 208},     { 63, 139, 212},     { 66, 137, 216},
    { 68, 136, 220},     { 71, 134, 224},     { 73, 133, 228},     { 76, 132, 232},
    { 78, 130, 236},     { 81, 129, 241},     { 83, 127, 245},     { 86, 126, 249},
    { 14, 166, 118},     { 17, 165, 122},     { 19, 164, 126},     { 22, 162, 130},
    { 24, 161, 134},     { 27, 159, 138},     { 29, 158, 143},     { 31, 157, 147},
    { 34, 155, 151},     { 36, 154, 155},     { 39, 153, 159},     { 41, 151, 163},
    { 44, 150, 167},     { 46, 148, 171},     { 49, 147, 175},     { 51, 146, 180},
    { 54, 144, 184},     { 56, 143, 188},     { 58, 141, 192},     { 61, 140, 196},
    { 63, 139, 200},     { 66, 137, 204},     { 68, 136, 208},     { 71, 134, 212},
    { 73, 133, 217},     { 76, 132, 221},     { 78, 130, 225},     { 81, 129, 229},
    { 83, 127, 233},     { 86, 126, 237},     { 88, 125, 241},     { 90, 123, 245},
    { 19, 164, 114},     { 21, 162, 119},     { 24, 161, 123},     { 26, 160, 127},
    { 29, 158, 131},     { 31, 157, 135},     { 34, 155, 139},     { 36, 154, 143},
    { 39, 153, 147},     { 41, 151, 151},     { 44, 150, 156},     { 46, 148, 160},
    { 49, 147, 164},     { 51, 146, 168},     { 53, 144, 172},     { 56, 143, 176},
    { 58, 141, 180},     { 61, 140, 184},     { 63, 139, 188},     { 66, 137, 193},
    { 68, 136, 197},     { 71, 134, 201},     { 73, 133, 205},     { 76, 132, 209},
    { 78, 130, 213},     { 81, 129, 217},     { 83, 128, 221},     { 85, 126, 225},
    { 88, 125, 230},     { 90, 123, 234},     { 93, 122, 238},     { 95, 121, 242},
    { 24, 161, 111},     { 26, 160, 115},     { 29, 158, 119},     { 31, 157, 123},
    { 34, 155, 127},     { 36, 154, 132},     { 39, 153, 136},     { 41, 151, 140},
    { 44, 150, 144},     { 46, 148, 148},     { 48, 147, 152},     { 51, 146, 156},
    { 53, 144, 160},     { 56, 143, 164},     { 58, 141, 169},     { 61, 140, 173},
    { 63, 139, 177},     { 66, 137, 181},     { 68, 136, 185},     { 71, 135, 189},
    { 73, 133, 193},     { 76, 132, 197},     { 78, 130, 201},     { 80, 129, 206},
    { 83, 128, 210},     { 85, 126, 214},     { 88, 125, 218},     { 90, 123, 222},
    { 93, 122, 226},     { 95, 121, 230},     { 98, 119, 234},     {100, 118, 238},
    { 29, 158, 108},     { 31, 157, 112},     { 34, 155, 116},     { 36, 154, 120},
    { 39, 153, 124},     { 41, 151, 128},     { 43, 150, 132},     { 46, 149, 136},
    { 48, 147, 140},     { 51, 146, 145},     { 53, 144, 149},     { 56, 143, 153},
    { 58, 142, 157},     { 61, 140, 161},     { 63, 139, 165},     { 66, 137, 169},
    { 68, 136, 173},     { 71, 135, 177},     { 73, 133, 182},     { 75, 132, 186},
    { 78, 130, 190},     { 80, 129, 194},     { 83, 128, 198},     { 85, 126, 202},
    { 88, 125, 206},     { 90, 123, 210},     { 93, 122, 214},     { 95, 121, 219},
    { 98, 119, 223},     {100, 118, 227},     {102, 117, 231},     {105, 115, 235},
    { 34, 156, 104},     { 36, 154, 108},     { 38, 153, 112},     { 41, 151, 116},
    { 43, 150, 121},     { 46, 149, 125},     { 48, 147, 129},     { 51, 146, 133},
    { 53, 144, 137},     { 56, 143, 141},     { 58, 142, 145},     { 61, 140, 149},
    { 63, 139, 153},     { 65, 137, 158},     { 68, 136, 162},     { 70, 135, 166},
    { 73, 133, 170},     { 75, 132, 174},     { 78, 130, 178},     { 80, 129, 182},
    { 83, 128, 186},     { 85, 126, 190},     { 88, 125, 195},     { 90, 124, 199},
    { 93, 122, 203},     { 95, 121, 207},     { 97, 119, 211},     {100, 118, 215},
    {102, 117, 219},     {105, 115, 223},     {107, 114, 227},     {110, 112, 232},
    { 38, 153, 101},     { 41, 151, 105},     { 43, 150, 109},     { 46, 149, 113},
    { 48, 147, 117},     { 51, 146, 121},     { 53, 144, 125},     { 56, 143, 129},
    { 58, 142, 134},     { 60, 140, 138},     { 63, 139, 142},     { 65, 138, 146},
    { 68, 136, 150},     { 70, 135, 154},     { 73, 133, 158},     { 75, 132, 162},
    { 78, 131, 166},     { 80, 129, 171},     { 83, 128, 175},     { 85, 126, 179},
    { 88, 125, 183},     { 90, 124, 187},     { 92, 122, 191},     { 95, 121, 195},
    { 97, 119, 199},     {100, 118, 203},     {102, 117, 208},     {105, 115, 212},
    {107, 114, 216},     {110, 112, 220},     {112, 111, 224},     {115, 110, 228},
    { 43, 150,  97},     { 46, 149, 101},     { 48, 147, 105},     { 51, 146, 110},
    { 53, 145, 114},     { 55, 143, 118},     { 58, 142, 122},     { 60, 140, 126},
    { 63, 139, 130},     { 65, 138, 134},     { 68, 136, 138},     { 70, 135, 142},
    { 73, 133, 147},     { 75, 132, 151},     { 78, 131, 155},     { 80, 129, 159},
    { 83, 128, 163},     { 85, 126, 167},     { 87, 125, 171},     { 90, 124, 175},
    { 92, 122, 179},     { 95, 121, 184},     { 97, 119, 188},     {100, 118, 192},
    {102, 117, 196},     {105, 115, 200},     {107, 114, 204},     {110, 113, 208},
    {112, 111, 212},     {115, 110, 216},     {117, 108, 221},     {119, 107, 225},
    { 48, 147,  94},     { 50, 146,  98},     { 53, 145, 102},     { 55, 143, 106},
    { 58, 142, 110},     { 60, 140, 114},     { 63, 139, 118},     { 65, 138, 123},
    { 68, 136, 127},     { 70, 135, 131},     { 73, 133, 135},     { 75, 132, 139},
    { 78, 131, 143},     { 80, 129, 147},     { 82, 128, 151},     { 85, 126, 155},
    { 87, 125, 160},     { 90, 124, 164},     { 92, 122, 168},     { 95, 121, 172},
    { 97, 120, 176},     {100, 118, 180},     {102, 117, 184},     {105, 115, 188},
    {107, 114, 192},     {109, 113, 197},     {112, 111, 201},     {114, 110, 205},
    {117, 108, 209},     {119, 107, 213},     {122, 106, 217},     {124, 104, 221},
    { 53, 145,  90},     { 55, 143,  94},     { 58, 142,  99},     { 60, 140, 103},
    { 63, 139, 107},     { 65, 138, 111},     { 68, 136, 115},     { 70, 135, 119},
    { 73, 134, 123},     { 75, 132, 127},     { 77, 131, 131},     { 80, 129, 136},
    { 82, 128, 140},     { 85, 127, 144},     { 87, 125, 148},     { 90, 124, 152},
    { 92, 122, 156},     { 95, 121, 160},     { 97, 120, 164},     {100, 118, 168},
    {102, 117, 173},     {104, 115, 177},     {107, 114, 181},     {109, 113, 185},
    {112, 111, 189},     {114, 110, 193},     {117, 108, 197},     {119, 107, 201},
    {122, 106, 205},     {124, 104, 210},     {127, 103, 214},     {129, 102, 218},
    { 58, 142,  87},     { 60, 141,  91},     { 63, 139,  95},     { 65, 138,  99},
    { 68, 136, 103},     { 70, 135, 107},     { 72, 134, 112},     { 75, 132, 116},
    { 77, 131, 120},     { 80, 129, 124},     { 82, 128, 128},     { 85, 127, 132},
    { 87, 125, 136},     { 90, 124, 140},     { 92, 122, 144},     { 95, 121, 149},
    { 97, 120, 153},     { 99, 118, 157},     {102, 117, 161},     {104, 115, 165},
    {107, 114, 169},     {109, 113, 173},     {112, 111, 177},     {114, 110, 181},
    {117, 109, 186},     {119, 107, 190},     {122, 106, 194},     {124, 104, 198},
    {127, 103, 202},     {129, 102, 206},     {131, 100, 210},     {134,  99, 214},
    { 62, 139,  83},     { 65, 138,  88},     { 67, 136,  92},     { 70, 135,  96},
    { 72, 134, 100},     { 75, 132, 104},     { 77, 131, 108},     { 80, 129, 112},
    { 82, 128, 116},     { 85, 127, 120},     { 87, 125, 125},     { 90, 124, 129},
    { 92, 122, 133},     { 94, 121, 137},     { 97, 120, 141},     { 99, 118, 145},
    {102, 117, 149},     {104, 116, 153},     {107, 114, 157},     {109, 113, 162},
    {112, 111, 166},     {114, 110, 170},     {117, 109, 174},     {119, 107, 178},
    {122, 106, 182},     {124, 104, 186},     {126, 103, 190},     {129, 102, 194},
    {131, 100, 199},     {134,  99, 203},     {136,  97, 207},     {139,  96, 211},
    { 67, 136,  80},     { 70, 135,  84},     { 72, 134,  88},     { 75, 132,  92},
    { 77, 131,  96},     { 80, 130, 101},     { 82, 128, 105},     { 85, 127, 109},
    { 87, 125, 113},     { 89, 124, 117},     { 92, 123, 121},     { 94, 121, 125},
    { 97, 120, 129},     { 99, 118, 133},     {102, 117, 138},     {104, 116, 142},
    {107, 114, 146},     {109, 113, 150},     {112, 111, 154},     {114, 110, 158},
    {117, 109, 162},     {119, 107, 166},     {121, 106, 170},     {124, 104, 175},
    {126, 103, 179},     {129, 102, 183},     {131, 100, 187},     {134,  99, 191},
    {136,  98, 195},     {139,  96, 199},     {141,  95, 203},     {144,  93, 207},
    { 72, 134,  77},     { 75, 132,  81},     { 77, 131,  85},     { 80, 130,  89},
    { 82, 128,  93},     { 84, 127,  97},     { 87, 125, 101},     { 89, 124, 105},
    { 92, 123, 109},     { 94, 121, 114},     { 97, 120, 118},     { 99, 118, 122},
    {102, 117, 126},     {104, 116, 130},     {107, 114, 134},     {109, 113, 138},
    {112, 111, 142},     {114, 110, 146},     {116, 109, 151},     {119, 107, 155},
    {121, 106, 159},     {124, 105, 163},     {126, 103, 167},     {129, 102, 171},
    {131, 100, 175},     {134,  99, 179},     {136,  98, 183},     {139,  96, 188},
    {141,  95, 192},     {143,  93, 196},     {146,  92, 200},     {148,  91, 204},
    { 77, 131,  73},     { 79, 130,  77},     { 82, 128,  81},     { 84, 127,  85},
    { 87, 125,  90},     { 89, 124,  94},     { 92, 123,  98},     { 94, 121, 102},
    { 97, 120, 106},     { 99, 118, 110},     {102, 117, 114},     {104, 116, 118},
    {106, 114, 122},     {109, 113, 127},     {111, 112, 131},     {114, 110, 135},
    {116, 109, 139},     {119, 107, 143},     {121, 106, 147},     {124, 105, 151},
    {126, 103, 155},     {129, 102, 159},     {131, 100, 164},     {134,  99, 168},
    {136,  98, 172},     {138,  96, 176},     {141,  95, 180},     {143,  93, 184},
    {146,  92, 188},     {148,  91, 192},     {151,  89, 196},     {153,  88, 201},
    { 82, 128,  70},     { 84, 127,  74},     { 87, 126,  78},     { 89, 124,  82},
    { 92, 123,  86},     { 94, 121,  90},     { 97, 120,  94},     { 99, 119,  98},
    {101, 117, 103},     {104, 116, 107},     {106, 114, 111},     {109, 113, 115},
    {111, 112, 119},     {114, 110, 123},     {116, 109, 127},     {119, 107, 131},
    {121, 106, 135},     {124, 105, 140},     {126, 103, 144},     {129, 102, 148},
    {131, 100, 152},     {133,  99, 156},     {136,  98, 160},     {138,  96, 164},
    {141,  95, 168},     {143,  94, 172},     {146,  92, 177},     {148,  91, 181},
    {151,  89, 185},     {153,  88, 189},     {156,  87, 193},     {158,  85, 197},
    { 87, 126,  66},     { 89, 124,  70},     { 92, 123,  74},     { 94, 121,  79},
    { 96, 120,  83},     { 99, 119,  87},     {101, 117,  91},     {104, 116,  95},
    {106, 114,  99},     {109, 113, 103},     {111, 112, 107},     {114, 110, 111},
    {116, 109, 116},     {119, 107, 120},     {121, 106, 124},     {124, 105, 128},
    {126, 103, 132},     {128, 102, 136},     {131, 101, 140},     {133,  99, 144},
    {136,  98, 148},     {138,  96, 153},     {141,  95, 157},     {143,  94, 161},
    {146,  92, 165},     {148,  91, 169},     {151,  89, 173},     {153,  88, 177},
    {156,  87, 181},     {158,  85, 185},     {160,  84, 190},     {163,  82, 194},
    { 91, 123,  63},     { 94, 121,  67},     { 96, 120,  71},     { 99, 119,  75},
    {101, 117,  79},     {104, 116,  83},     {106, 115,  87},     {109, 113,  92},
    {111, 112,  96},     {114, 110, 100},     {116, 109, 104},     {119, 108, 108},
    {121, 106, 112},     {123, 105, 116},     {126, 103, 120},     {128, 102, 124},
    {131, 101, 129},     {133,  99, 133},     {136,  98, 137},     {138,  96, 141},
    {141,  95, 145},     {143,  94, 149},     {146,  92, 153},     {148,  91, 157},
    {150,  89, 161},     {153,  88, 166},     {155,  87, 170},     {158,  85, 174},
    {160,  84, 178},     {163,  83, 182},     {165,  81, 186},     {168,  80, 190},
    { 96, 120,  59},     { 99, 119,  63},     {101, 117,  68},     {104, 116,  72},
    {106, 115,  76},     {109, 113,  80},     {111, 112,  84},     {114, 110,  88},
    {116, 109,  92},     {118, 108,  96},     {121, 106, 100},     {123, 105, 105},
    {126, 103, 109},     {128, 102, 113},     {131, 101, 117},     {133,  99, 121},
    {136,  98, 125},     {138,  96, 129},     {141,  95, 133},     {143,  94, 137},
    {145,  92, 142},     {148,  91, 146},     {150,  90, 150},     {153,  88, 154},
    {155,  87, 158},     {158,  85, 162},     {160,  84, 166},     {163,  83, 170},
    {165,  81, 174},     {168,  80, 179},     {170,  78, 183},     {173,  77, 187},
    {101, 117,  56},     {104, 116,  60},     {106, 115,  64},     {108, 113,  68},
    {111, 112,  72},     {113, 110,  76},     {116, 109,  81},     {118, 108,  85},
    {121, 106,  89},     {123, 105,  93},     {126, 103,  97},     {128, 102, 101},
    {131, 101, 105},     {133,  99, 109},     {136,  98, 113},     {138,  97, 118},
    {140,  95, 122},     {143,  94, 126},     {145,  92, 130},     {148,  91, 134},
    {150,  90, 138},     {153,  88, 142},     {155,  87, 146},     {158,  85, 150},
    {160,  84, 155},     {163,  83, 159},     {165,  81, 163},     {168,  80, 167},
    {170,  78, 171},     {172,  77, 175},     {175,  76, 179},     {177,  74, 183},
    {106, 115,  52},     {108, 113,  57},     {111, 112,  61},     {113, 111,  65},
    {116, 109,  69},     {118, 108,  73},     {121, 106,  77},     {123, 105,  81},
    {126, 104,  85},     {128, 102,  89},     {131, 101,  94},     {133,  99,  98},
    {135,  98, 102},     {138,  97, 106},     {140,  95, 110},     {143,  94, 114},
    {145,  92, 118},     {148,  91, 122},     {150,  90, 126},     {153,  88, 131},
    {155,  87, 135},     {158,  85, 139},     {160,  84, 143},     {163,  83, 147},
    {165,  81, 151},     {167,  80, 155},     {170,  79, 159},     {172,  77, 163},
    {175,  76, 168},     {177,  74, 172},     {180,  73, 176},     {182,  72, 180},
    {111, 112,  49},     {113, 111,  53},     {116, 109,  57},     {118, 108,  61},
    {121, 106,  65},     {123, 105,  70},     {126, 104,  74},     {128, 102,  78},
    {130, 101,  82},     {133,  99,  86},     {135,  98,  90},     {138,  97,  94},
    {140,  95,  98},     {143,  94, 102},     {145,  92, 107},     {148,  91, 111},
    {150,  90, 115},     {153,  88, 119},     {155,  87, 123},     {158,  86, 127},
    {160,  84, 131},     {162,  83, 135},     {165,  81, 139},     {167,  80, 144},
    {170,  79, 148},     {172,  77, 152},     {175,  76, 156},     {177,  74, 160},
    {180,  73, 164},     {182,  72, 168},     {185,  70, 172},     {187,  69, 176},
    {116, 109,  46},     {118, 108,  50},     {121, 106,  54},     {123, 105,  58},
    {125, 104,  62},     {128, 102,  66},     {130, 101,  70},     {133,  99,  74},
    {135,  98,  78},     {138,  97,  83},     {140,  95,  87},     {143,  94,  91},
    {145,  93,  95},     {148,  91,  99},     {150,  90, 103},     {152,  88, 107},
    {155,  87, 111},     {157,  86, 115},     {160,  84, 120},     {162,  83, 124},
    {165,  81, 128},     {167,  80, 132},     {170,  79, 136},     {172,  77, 140},
    {175,  76, 144},     {177,  74, 148},     {180,  73, 152},     {182,  72, 157},
    {184,  70, 161},     {187,  69, 165},     {189,  68, 169},     {192,  66, 173},
    {120, 107,  42},     {123, 105,  46},     {125, 104,  50},     {128, 102,  54},
    {130, 101,  59},     {133, 100,  63},     {135,  98,  67},     {138,  97,  71},
    {140,  95,  75},     {143,  94,  79},     {145,  93,  83},     {147,  91,  87},
    {150,  90,  91},     {152,  88,  96},     {155,  87, 100},     {157,  86, 104},
    {160,  84, 108},     {162,  83, 112},     {165,  81, 116},     {167,  80, 120},
    {170,  79, 124},     {172,  77, 128},     {175,  76, 133},     {177,  75, 137},
    {179,  73, 141},     {182,  72, 145},     {184,  70, 149},     {187,  69, 153},
    {189,  68, 157},     {192,  66, 161},     {194,  65, 165},     {197,  63, 170},
    {125, 104,  39},     {128, 102,  43},     {130, 101,  47},     {133, 100,  51},
    {135,  98,  55},     {138,  97,  59},     {140,  95,  63},     {142,  94,  67},
    {145,  93,  72},     {147,  91,  76},     {150,  90,  80},     {152,  88,  84},
    {155,  87,  88},     {157,  86,  92},     {160,  84,  96},     {162,  83, 100},
    {165,  82, 104},     {167,  80, 109},     {170,  79, 113},     {172,  77, 117},
    {174,  76, 121},     {177,  75, 125},     {179,  73, 129},     {182,  72, 133},
    {184,  70, 137},     {187,  69, 141},     {189,  68, 146},     {192,  66, 150},
    {194,  65, 154},     {197,  63, 158},     {199,  62, 162},     {202,  61, 166},
    {130, 101,  35},     {133, 100,  39},     {135,  98,  43},     {137,  97,  48},
    {140,  95,  52},     {142,  94,  56},     {145,  93,  60},     {147,  91,  64},
    {150,  90,  68},     {152,  89,  72},     {155,  87,  76},     {157,  86,  80},
    {160,  84,  85},     {162,  83,  89},     {165,  82,  93},     {167,  80,  97},
    {169,  79, 101},     {172,  77, 105},     {174,  76, 109},     {177,  75, 113},
    {179,  73, 117},     {182,  72, 122},     {184,  70, 126},     {187,  69, 130},
    {189,  68, 134},     {192,  66, 138},     {194,  65, 142},     {196,  64, 146},
    {199,  62, 150},     {201,  61, 154},     {204,  59, 159},     {206,  58, 163},
    {135,  98,  32},     {137,  97,  36},     {140,  96,  40},     {142,  94,  44},
    {145,  93,  48},     {147,  91,  52},     {150,  90,  56},     {152,  89,  61},
    {155,  87,  65},     {157,  86,  69},     {160,  84,  73},     {162,  83,  77},
    {164,  82,  81},     {167,  80,  85},     {169,  79,  89},     {172,  77,  93},
    {174,  76,  98},     {177,  75, 102},     {179,  73, 106},     {182,  72, 110},
    {184,  71, 114},     {187,  69, 118},     {189,  68, 122},     {191,  66, 126},
    {194,  65, 130},     {196,  64, 135},     {199,  62, 139},     {201,  61, 143},
    {204,  59, 147},     {206,  58, 151},     {209,  57, 155},     {211,  55, 159},
    {140,  96,  28},     {142,  94,  32},     {145,  93,  37},     {147,  91,  41},
    {150,  90,  45},     {152,  89,  49},     {155,  87,  53},     {157,  86,  57},
    {159,  84,  61},     {162,  83,  65},     {164,  82,  69},     {167,  80,  74},
    {169,  79,  78},     {172,  78,  82},     {174,  76,  86},     {177,  75,  90},
    {179,  73,  94},     {182,  72,  98},     {184,  71, 102},     {186,  69, 106},
    {189,  68, 111},     {191,  66, 115},     {194,  65, 119},     {196,  64, 123},
    {199,  62, 127},     {201,  61, 131},     {204,  59, 135},     {206,  58, 139},
    {209,  57, 143},     {211,  55, 148},     {214,  54, 152},     {216,  53, 156},
    {145,  93,  25},     {147,  92,  29},     {149,  90,  33},     {152,  89,  37},
    {154,  87,  41},     {157,  86,  45},     {159,  85,  50},     {162,  83,  54},
    {164,  82,  58},     {167,  80,  62},     {169,  79,  66},     {172,  78,  70},
    {174,  76,  74},     {177,  75,  78},     {179,  73,  82},     {181,  72,  87},
    {184,  71,  91},     {186,  69,  95},     {189,  68,  99},     {191,  66, 103},
    {194,  65, 107},     {196,  64, 111},     {199,  62, 115},     {201,  61, 119},
    {204,  60, 124},     {206,  58, 128},     {209,  57, 132},     {211,  55, 136},
    {213,  54, 140},     {216,  53, 144},     {218,  51, 148},     {221,  50, 152},
    {149,  90,  21},     {152,  89,  25},     {154,  87,  30},     {157,  86,  34},
    {159,  85,  38},     {162,  83,  42},     {164,  82,  46},     {167,  80,  50},
    {169,  79,  54},     {172,  78,  58},     {174,  76,  63},     {176,  75,  67},
    {179,  73,  71},     {181,  72,  75},     {184,  71,  79},     {186,  69,  83},
    {189,  68,  87},     {191,  67,  91},     {194,  65,  95},     {196,  64, 100},
    {199,  62, 104},     {201,  61, 108},     {204,  60, 112},     {206,  58, 116},
    {208,  57, 120},     {211,  55, 124},     {213,  54, 128},     {216,  53, 132},
    {218,  51, 137},     {221,  50, 141},     {223,  48, 145},     {226,  47, 149},
    {154,  87,  18},     {157,  86,  22},     {159,  85,  26},     {162,  83,  30},
    {164,  82,  34},     {167,  80,  39},     {169,  79,  43},     {171,  78,  47},
    {174,  76,  51},     {176,  75,  55},     {179,  74,  59},     {181,  72,  63},
    {184,  71,  67},     {186,  69,  71},     {189,  68,  76},     {191,  67,  80},
    {194,  65,  84},     {196,  64,  88},     {199,  62,  92},     {201,  61,  96},
    {203,  60, 100},     {206,  58, 104},     {208,  57, 108},     {211,  55, 113},
    {213,  54, 117},     {216,  53, 121},     {218,  51, 125},     {221,  50, 129},
    {223,  49, 133},     {226,  47, 137},     {228,  46, 141},     {230,  44, 145},
    {159,  85,  14},     {162,  83,  19},     {164,  82,  23},     {166,  81,  27},
    {169,  79,  31},     {171,  78,  35},     {174,  76,  39},     {176,  75,  43},
    {179,  74,  47},     {181,  72,  52},     {184,  71,  56},     {186,  69,  60},
    {189,  68,  64},     {191,  67,  68},     {193,  65,  72},     {196,  64,  76},
    {198,  62,  80},     {201,  61,  84},     {203,  60,  89},     {206,  58,  93},
    {208,  57,  97},     {211,  56, 101},     {213,  54, 105},     {216,  53, 109},
    {218,  51, 113},     {221,  50, 117},     {223,  49, 121},     {225,  47, 126},
    {228,  46, 130},     {230,  44, 134},     {233,  43, 138},     {235,  42, 142},
    { 10, 173, 121},     { 13, 172, 125},     { 15, 170, 129},     { 18, 169, 133},
    { 20, 168, 137},     { 23, 166, 141},     { 25, 165, 145},     { 28, 164, 149},
    { 30, 162, 154},     { 32, 161, 158},     { 35, 159, 162},     { 37, 158, 166},
    { 40, 157, 170},     { 42, 155, 174},     { 45, 154, 178},     { 47, 152, 182},
    { 50, 151, 186},     { 52, 150, 191},     { 55, 148, 195},     { 57, 147, 199},
    { 60, 145, 203},     { 62, 144, 207},     { 64, 143, 211},     { 67, 141, 215},
    { 69, 140, 219},     { 72, 138, 223},     { 74, 137, 228},     { 77, 136, 232},
    { 79, 134, 236},     { 82, 133, 240},     { 84, 132, 244},     { 87, 130, 248},
    { 15, 171, 117},     { 18, 169, 121},     { 20, 168, 125},     { 23, 166, 130},
    { 25, 165, 134},     { 27, 164, 138},     { 30, 162, 142},     { 32, 161, 146},
    { 35, 159, 150},     { 37, 158, 154},     { 40, 157, 158},     { 42, 155, 162},
    { 45, 154, 167},     { 47, 152, 171},     { 50, 151, 175},     { 52, 150, 179},
    { 54, 148, 183},     { 57, 147, 187},     { 59, 145, 191},     { 62, 144, 195},
    { 64, 143, 199},     { 67, 141, 204},     { 69, 140, 208},     { 72, 139, 212},
    { 74, 137, 216},     { 77, 136, 220},     { 79, 134, 224},     { 82, 133, 228},
    { 84, 132, 232},     { 86, 130, 236},     { 89, 129, 241},     { 91, 127, 245},
    { 20, 168, 114},     { 22, 166, 118},     { 25, 165, 122},     { 27, 164, 126},
    { 30, 162, 130},     { 32, 161, 134},     { 35, 159, 138},     { 37, 158, 143},
    { 40, 157, 147},     { 42, 155, 151},     { 45, 154, 155},     { 47, 153, 159},
    { 49, 151, 163},     { 52, 150, 167},     { 54, 148, 171},     { 57, 147, 175},
    { 59, 146, 180},     { 62, 144, 184},     { 64, 143, 188},     { 67, 141, 192},
    { 69, 140, 196},     { 72, 139, 200},     { 74, 137, 204},     { 77, 136, 208},
    { 79, 134, 212},     { 81, 133, 217},     { 84, 132, 221},     { 86, 130, 225},
    { 89, 129, 229},     { 91, 127, 233},     { 94, 126, 237},     { 96, 125, 241},
    { 25, 165, 110},     { 27, 164, 114},     { 30, 162, 119},     { 32, 161, 123},
    { 35, 160, 127},     { 37, 158, 131},     { 40, 157, 135},     { 42, 155, 139},
    { 44, 154, 143},     { 47, 153, 147},     { 49, 151, 151},     { 52, 150, 156},
    { 54, 148, 160},     { 57, 147, 164},     { 59, 146, 168},     { 62, 144, 172},
    { 64, 143, 176},     { 67, 141, 180},     { 69, 140, 184},     { 72, 139, 188},
    { 74, 137, 193},     { 76, 136, 197},     { 79, 134, 201},     { 81, 133, 205},
    { 84, 132, 209},     { 86, 130, 213},     { 89, 129, 217},     { 91, 128, 221},
    { 94, 126, 225},     { 96, 125, 230},     { 99, 123, 234},     {101, 122, 238},
    { 30, 162, 107},     { 32, 161, 111},     { 35, 160, 115},     { 37, 158, 119},
    { 39, 157, 123},     { 42, 155, 127},     { 44, 154, 132},     { 47, 153, 136},
    { 49, 151, 140},     { 52, 150, 144},     { 54, 148, 148},     { 57, 147, 152},
    { 59, 146, 156},     { 62, 144, 160},     { 64, 143, 164},     { 67, 141, 169},
    { 69, 140, 173},     { 71, 139, 177},     { 74, 137, 181},     { 76, 136, 185},
    { 79, 135, 189},     { 81, 133, 193},     { 84, 132, 197},     { 86, 130, 201},
    { 89, 129, 206},     { 91, 128, 210},     { 94, 126, 214},     { 96, 125, 218},
    { 98, 123, 222},     {101, 122, 226},     {103, 121, 230},     {106, 119, 234},
    { 34, 160, 103},     { 37, 158, 108},     { 39, 157, 112},     { 42, 155, 116},
    { 44, 154, 120},     { 47, 153, 124},     { 49, 151, 128},     { 52, 150, 132},
    { 54, 149, 136},     { 57, 147, 140},     { 59, 146, 145},     { 62, 144, 149},
    { 64, 143, 153},     { 66, 142, 157},     { 69, 140, 161},     { 71, 139, 165},
    { 74, 137, 169},     { 76, 136, 173},     { 79, 135, 177},     { 81, 133, 182},
    { 84, 132, 186},     { 86, 130, 190},     { 89, 129, 194},     { 91, 128, 198},
    { 93, 126, 202},     { 96, 125, 206},     { 98, 123, 210},     {101, 122, 214},
    {103, 121, 219},     {106, 119, 223},     {108, 118, 227},     {111, 117, 231},
    { 39, 157, 100},     { 42, 156, 104},     { 44, 154, 108},     { 47, 153, 112},
    { 49, 151, 116},     { 52, 150, 121},     { 54, 149, 125},     { 57, 147, 129},
    { 59, 146, 133},     { 61, 144, 137},     { 64, 143, 141},     { 66, 142, 145},
    { 69, 140, 149},     { 71, 139, 153},     { 74, 137, 158},     { 76, 136, 162},
    { 79, 135, 166},     { 81, 133, 170},     { 84, 132, 174},     { 86, 130, 178},
    { 88, 129, 182},     { 91, 128, 186},     { 93, 126, 190},     { 96, 125, 195},
    { 98, 124, 199},     {101, 122, 203},     {103, 121, 207},     {106, 119, 211},
    {108, 118, 215},     {111, 117, 219},     {113, 115, 223},     {116, 114, 227},
    { 44, 154,  97},     { 47, 153, 101},     { 49, 151, 105},     { 51, 150, 109},
    { 54, 149, 113},     { 56, 147, 117},     { 59, 146, 121},     { 61, 144, 125},
    { 64, 143, 129},     { 66, 142, 134},     { 69, 140, 138},     { 71, 139, 142},
    { 74, 138, 146},     { 76, 136, 150},     { 79, 135, 154},     { 81, 133, 158},
    { 83, 132, 162},     { 86, 131, 166},     { 88, 129, 171},     { 91, 128, 175},
    { 93, 126, 179},     { 96, 125, 183},     { 98, 124, 187},     {101, 122, 191},
    {103, 121, 195},     {106, 119, 199},     {108, 118, 203},     {111, 117, 208},
    {113, 115, 212},     {115, 114, 216},     {118, 112, 220},     {120, 111, 224},
    { 49, 151,  93},     { 51, 150,  97},     { 54, 149, 101},     { 56, 147, 105},
    { 59, 146, 110},     { 61, 145, 114},     { 64, 143, 118},     { 66, 142, 122},
    { 69, 140, 126},     { 71, 139, 130},     { 74, 138, 134},     { 76, 136, 138},
    { 78, 135, 142},     { 81, 133, 147},     { 83, 132, 151},     { 86, 131, 155},
    { 88, 129, 159},     { 91, 128, 163},     { 93, 126, 167},     { 96, 125, 171},
    { 98, 124, 175},     {101, 122, 179},     {103, 121, 184},     {106, 119, 188},
    {108, 118, 192},     {110, 117, 196},     {113, 115, 200},     {115, 114, 204},
    {118, 113, 208},     {120, 111, 212},     {123, 110, 216},     {125, 108, 221},
    { 54, 149,  90},     { 56, 147,  94},     { 59, 146,  98},     { 61, 145, 102},
    { 64, 143, 106},     { 66, 142, 110},     { 69, 140, 114},     { 71, 139, 118},
    { 73, 138, 123},     { 76, 136, 127},     { 78, 135, 131},     { 81, 133, 135},
    { 83, 132, 139},     { 86, 131, 143},     { 88, 129, 147},     { 91, 128, 151},
    { 93, 126, 155},     { 96, 125, 160},     { 98, 124, 164},     {101, 122, 168},
    {103, 121, 172},     {105, 120, 176},     {108, 118, 180},     {110, 117, 184},
    {113, 115, 188},     {115, 114, 192},     {118, 113, 197},     {120, 111, 201},
    {123, 110, 205},     {125, 108, 209},     {128, 107, 213},     {130, 106, 217},
    { 59, 146,  86},     { 61, 145,  90},     { 64, 143,  94},     { 66, 142,  99},
    { 68, 140, 103},     { 71, 139, 107},     { 73, 138, 111},     { 76, 136, 115},
    { 78, 135, 119},     { 81, 134, 123},     { 83, 132, 127},     { 86, 131, 131},
    { 88, 129, 136},     { 91, 128, 140},     { 93, 127, 144},     { 95, 125, 148},
    { 98, 124, 152},     {100, 122, 156},     {103, 121, 160},     {105, 120, 164},
    {108, 118, 168},     {110, 117, 173},     {113, 115, 177},     {115, 114, 181},
    {118, 113, 185},     {120, 111, 189},     {123, 110, 193},     {125, 108, 197},
    {127, 107, 201},     {130, 106, 205},     {132, 104, 210},     {135, 103, 214},
    { 63, 143,  83},     { 66, 142,  87},     { 68, 141,  91},     { 71, 139,  95},
    { 73, 138,  99},     { 76, 136, 103},     { 78, 135, 107},     { 81, 134, 112},
    { 83, 132, 116},     { 86, 131, 120},     { 88, 129, 124},     { 90, 128, 128},
    { 93, 127, 132},     { 95, 125, 136},     { 98, 124, 140},     {100, 122, 144},
    {103, 121, 149},     {105, 120, 153},     {108, 118, 157},     {110, 117, 161},
    {113, 115, 165},     {115, 114, 169},     {118, 113, 173},     {120, 111, 177},
    {122, 110, 181},     {125, 109, 186},     {127, 107, 190},     {130, 106, 194},
    {132, 104, 198},     {135, 103, 202},     {137, 102, 206},     {140, 100, 210},
    { 68, 141,  79},     { 71, 139,  83},     { 73, 138,  88},     { 76, 136,  92},
    { 78, 135,  96},     { 81, 134, 100},     { 83, 132, 104},     { 85, 131, 108},
    { 88, 129, 112},     { 90, 128, 116},     { 93, 127, 120},     { 95, 125, 125},
    { 98, 124, 129},     {100, 122, 133},     {103, 121, 137},     {105, 120, 141},
    {108, 118, 145},     {110, 117, 149},     {113, 116, 153},     {115, 114, 157},
    {117, 113, 162},     {120, 111, 166},     {122, 110, 170},     {125, 109, 174},
    {127, 107, 178},     {130, 106, 182},     {132, 104, 186},     {135, 103, 190},
    {137, 102, 194},     {140, 100, 199},     {142,  99, 203},     {145,  97, 207},
    { 73, 138,  76},     { 76, 136,  80},     { 78, 135,  84},     { 80, 134,  88},
    { 83, 132,  92},     { 85, 131,  96},     { 88, 130, 101},     { 90, 128, 105},
    { 93, 127, 109},     { 95, 125, 113},     { 98, 124, 117},     {100, 123, 121},
    {103, 121, 125},     {105, 120, 129},     {108, 118, 133},     {110, 117, 138},
    {112, 116, 142},     {115, 114, 146},     {117, 113, 150},     {120, 111, 154},
    {122, 110, 158},     {125, 109, 162},     {127, 107, 166},     {130, 106, 170},
    {132, 104, 175},     {135, 103, 179},     {137, 102, 183},     {139, 100, 187},
    {142,  99, 191},     {144,  98, 195},     {147,  96, 199},     {149,  95, 203},
    { 78, 135,  72},     { 80, 134,  77},     { 83, 132,  81},     { 85, 131,  85},
    { 88, 130,  89},     { 90, 128,  93},     { 93, 127,  97},     { 95, 125, 101},
    { 98, 124, 105},     {100, 123, 109},     {103, 121, 114},     {105, 120, 118},
    {107, 118, 122},     {110, 117, 126},     {112, 116, 130},     {115, 114, 134},
    {117, 113, 138},     {120, 111, 142},     {122, 110, 146},     {125, 109, 151},
    {127, 107, 155},     {130, 106, 159},     {132, 105, 163},     {134, 103, 167},
    {137, 102, 171},     {139, 100, 175},     {142,  99, 179},     {144,  98, 183},
    {147,  96, 188},     {149,  95, 192},     {152,  93, 196},     {154,  92, 200},
    { 83, 132,  69},     { 85, 131,  73},     { 88, 130,  77},     { 90, 128,  81},
    { 93, 127,  85},     { 95, 125,  90},     { 98, 124,  94},     {100, 123,  98},
    {102, 121, 102},     {105, 120, 106},     {107, 118, 110},     {110, 117, 114},
    {112, 116, 118},     {115, 114, 122},     {117, 113, 127},     {120, 112, 131},
    {122, 110, 135},     {125, 109, 139},     {127, 107, 143},     {129, 106, 147},
    {132, 105, 151},     {134, 103, 155},     {137, 102, 159},     {139, 100, 164},
    {142,  99, 168},     {144,  98, 172},     {147,  96, 176},     {149,  95, 180},
    {152,  93, 184},     {154,  92, 188},     {157,  91, 192},     {159,  89, 196},
    { 88, 130,  66},     { 90, 128,  70},     { 92, 127,  74},     { 95, 126,  78},
    { 97, 124,  82},     {100, 123,  86},     {102, 121,  90},     {105, 120,  94},
    {107, 119,  98},     {110, 117, 103},     {112, 116, 107},     {115, 114, 111},
    {117, 113, 115},     {120, 112, 119},     {122, 110, 123},     {124, 109, 127},
    {127, 107, 131},     {129, 106, 135},     {132, 105, 140},     {134, 103, 144},
    {137, 102, 148},     {139, 100, 152},     {142,  99, 156},     {144,  98, 160},
    {147,  96, 164},     {149,  95, 168},     {152,  94, 172},     {154,  92, 177},
    {156,  91, 181},     {159,  89, 185},     {161,  88, 189},     {164,  87, 193},
    { 92, 127,  62},     { 95, 126,  66},     { 97, 124,  70},     {100, 123,  74},
    {102, 121,  79},     {105, 120,  83},     {107, 119,  87},     {110, 117,  91},
    {112, 116,  95},     {115, 114,  99},     {117, 113, 103},     {119, 112, 107},
    {122, 110, 111},     {124, 109, 116},     {127, 107, 120},     {129, 106, 124},
    {132, 105, 128},     {134, 103, 132},     {137, 102, 136},     {139, 101, 140},
    {142,  99, 144},     {144,  98, 148},     {147,  96, 153},     {149,  95, 157},
    {151,  94, 161},     {154,  92, 165},     {156,  91, 169},     {159,  89, 173},
    {161,  88, 177},     {164,  87, 181},     {166,  85, 185},     {169,  84, 190},
    { 97, 124,  59},     {100, 123,  63},     {102, 121,  67},     {105, 120,  71},
    {107, 119,  75},     {110, 117,  79},     {112, 116,  83},     {114, 115,  87},
    {117, 113,  92},     {119, 112,  96},     {122, 110, 100},     {124, 109, 104},
    {127, 108, 108},     {129, 106, 112},     {132, 105, 116},     {134, 103, 120},
    {137, 102, 124},     {139, 101, 129},     {142,  99, 133},     {144,  98, 137},
    {146,  96, 141},     {149,  95, 145},     {151,  94, 149},     {154,  92, 153},
    {156,  91, 157},     {159,  89, 161},     {161,  88, 166},     {164,  87, 170},
    {166,  85, 174},     {169,  84, 178},     {171,  83, 182},     {173,  81, 186},
    {102, 122,  55},     {105, 120,  59},     {107, 119,  63},     {109, 117,  68},
    {112, 116,  72},     {114, 115,  76},     {117, 113,  80},     {119, 112,  84},
    {122, 110,  88},     {124, 109,  92},     {127, 108,  96},     {129, 106, 100},
    {132, 105, 105},     {134, 103, 109},     {136, 102, 113},     {139, 101, 117},
    {141,  99, 121},     {144,  98, 125},     {146,  96, 129},     {149,  95, 133},
    {151,  94, 137},     {154,  92, 142},     {156,  91, 146},     {159,  90, 150},
    {161,  88, 154},     {164,  87, 158},     {166,  85, 162},     {168,  84, 166},
    {171,  83, 170},     {173,  81, 174},     {176,  80, 179},     {178,  78, 183},
    {107, 119,  52},     {109, 117,  56},     {112, 116,  60},     {114, 115,  64},
    {117, 113,  68},     {119, 112,  72},     {122, 110,  76},     {124, 109,  81},
    {127, 108,  85},     {129, 106,  89},     {131, 105,  93},     {134, 103,  97},
    {136, 102, 101},     {139, 101, 105},     {141,  99, 109},     {144,  98, 113},
    {146,  97, 118},     {149,  95, 122},     {151,  94, 126},     {154,  92, 130},
    {156,  91, 134},     {159,  90, 138},     {161,  88, 142},     {163,  87, 146},
    {166,  85, 150},     {168,  84, 155},     {171,  83, 159},     {173,  81, 163},
    {176,  80, 167},     {178,  78, 171},     {181,  77, 175},     {183,  76, 179},
    {112, 116,  48},     {114, 115,  52},     {117, 113,  57},     {119, 112,  61},
    {122, 111,  65},     {124, 109,  69},     {126, 108,  73},     {129, 106,  77},
    {131, 105,  81},     {134, 104,  85},     {136, 102,  89},     {139, 101,  94},
    {141,  99,  98},     {144,  98, 102},     {146,  97, 106},     {149,  95, 110},
    {151,  94, 114},     {154,  92, 118},     {156,  91, 122},     {158,  90, 126},
    {161,  88, 131},     {163,  87, 135},     {166,  85, 139},     {168,  84, 143},
    {171,  83, 147},     {173,  81, 151},     {176,  80, 155},     {178,  79, 159},
    {181,  77, 163},     {183,  76, 168},     {186,  74, 172},     {188,  73, 176},
    {117, 113,  45},     {119, 112,  49},     {121, 111,  53},     {124, 109,  57},
    {126, 108,  61},     {129, 106,  65},     {131, 105,  70},     {134, 104,  74},
    {136, 102,  78},     {139, 101,  82},     {141,  99,  86},     {144,  98,  90},
    {146,  97,  94},     {149,  95,  98},     {151,  94, 102},     {153,  92, 107},
    {156,  91, 111},     {158,  90, 115},     {161,  88, 119},     {163,  87, 123},
    {166,  86, 127},     {168,  84, 131},     {171,  83, 135},     {173,  81, 139},
    {176,  80, 144},     {178,  79, 148},     {180,  77, 152},     {183,  76, 156},
    {185,  74, 160},     {188,  73, 164},     {190,  72, 168},     {193,  70, 172},
    {121, 111,  41},     {124, 109,  46},     {126, 108,  50},     {129, 106,  54},
    {131, 105,  58},     {134, 104,  62},     {136, 102,  66},     {139, 101,  70},
    {141,  99,  74},     {144,  98,  78},     {146,  97,  83},     {148,  95,  87},
    {151,  94,  91},     {153,  93,  95},     {156,  91,  99},     {158,  90, 103},
    {161,  88, 107},     {163,  87, 111},     {166,  86, 115},     {168,  84, 120},
    {171,  83, 124},     {173,  81, 128},     {175,  80, 132},     {178,  79, 136},
    {180,  77, 140},     {183,  76, 144},     {185,  74, 148},     {188,  73, 152},
    {190,  72, 157},     {193,  70, 161},     {195,  69, 165},     {198,  68, 169},
    {126, 108,  38},     {129, 107,  42},     {131, 105,  46},     {134, 104,  50},
    {136, 102,  54},     {138, 101,  59},     {141, 100,  63},     {143,  98,  67},
    {146,  97,  71},     {148,  95,  75},     {151,  94,  79},     {153,  93,  83},
    {156,  91,  87},     {158,  90,  91},     {161,  88,  96},     {163,  87, 100},
    {166,  86, 104},     {168,  84, 108},     {170,  83, 112},     {173,  81, 116},
    {175,  80, 120},     {178,  79, 124},     {180,  77, 128},     {183,  76, 133},
    {185,  75, 137},     {188,  73, 141},     {190,  72, 145},     {193,  70, 149},
    {195,  69, 153},     {198,  68, 157},     {200,  66, 161},     {202,  65, 165},
    {131, 105,  35},     {133, 104,  39},     {136, 102,  43},     {138, 101,  47},
    {141, 100,  51},     {143,  98,  55},     {146,  97,  59},     {148,  95,  63},
    {151,  94,  67},     {153,  93,  72},     {156,  91,  76},     {158,  90,  80},
    {161,  88,  84},     {163,  87,  88},     {165,  86,  92},     {168,  84,  96},
    {170,  83, 100},     {173,  82, 104},     {175,  80, 109},     {178,  79, 113},
    {180,  77, 117},     {183,  76, 121},     {185,  75, 125},     {188,  73, 129},
    {190,  72, 133},     {193,  70, 137},     {195,  69, 141},     {197,  68, 146},
    {200,  66, 150},     {202,  65, 154},     {205,  63, 158},     {207,  62, 162},
    {136, 102,  31},     {138, 101,  35},     {141, 100,  39},     {143,  98,  43},
    {146,  97,  48},     {148,  95,  52},     {151,  94,  56},     {153,  93,  60},
    {156,  91,  64},     {158,  90,  68},     {160,  89,  72},     {163,  87,  76},
    {165,  86,  80},     {168,  84,  85},     {170,  83,  89},     {173,  82,  93},
    {175,  80,  97},     {178,  79, 101},     {180,  77, 105},     {183,  76, 109},
    {185,  75, 113},     {188,  73, 117},     {190,  72, 122},     {192,  70, 126},
    {195,  69, 130},     {197,  68, 134},     {200,  66, 138},     {202,  65, 142},
    {205,  64, 146},     {207,  62, 150},     {210,  61, 154},     {212,  59, 159},
    {141, 100,  28},     {143,  98,  32},     {146,  97,  36},     {148,  96,  40},
    {151,  94,  44},     {153,  93,  48},     {155,  91,  52},     {158,  90,  56},
    {160,  89,  61},     {163,  87,  65},     {165,  86,  69},     {168,  84,  73},
    {170,  83,  77},     {173,  82,  81},     {175,  80,  85},     {178,  79,  89},
    {180,  77,  93},     {182,  76,  98},     {185,  75, 102},     {187,  73, 106},
    {190,  72, 110},     {192,  71, 114},     {195,  69, 118},     {197,  68, 122},
    {200,  66, 126},     {202,  65, 130},     {205,  64, 135},     {207,  62, 139},
    {210,  61, 143},     {212,  59, 147},     {214,  58, 151},     {217,  57, 155},
    {146,  97,  24},     {148,  96,  28},     {150,  94,  32},     {153,  93,  37},
    {155,  91,  41},     {158,  90,  45},     {160,  89,  49},     {163,  87,  53},
    {165,  86,  57},     {168,  84,  61},     {170,  83,  65},     {173,  82,  69},
    {175,  80,  74},     {177,  79,  78},     {180,  78,  82},     {182,  76,  86},
    {185,  75,  90},     {187,  73,  94},     {190,  72,  98},     {192,  71, 102},
    {195,  69, 106},     {197,  68, 111},     {200,  66, 115},     {202,  65, 119},
    {205,  64, 123},     {207,  62, 127},     {209,  61, 131},     {212,  59, 135},
    {214,  58, 139},     {217,  57, 143},     {219,  55, 148},     {222,  54, 152},
    {150,  94,  21},     {153,  93,  25},     {155,  92,  29},     {158,  90,  33},
    {160,  89,  37},     {163,  87,  41},     {165,  86,  45},     {168,  85,  50},
    {170,  83,  54},     {172,  82,  58},     {175,  80,  62},     {177,  79,  66},
    {180,  78,  70},     {182,  76,  74},     {185,  75,  78},     {187,  73,  82},
    {190,  72,  87},     {192,  71,  91},     {195,  69,  95},     {197,  68,  99},
    {200,  66, 103},     {202,  65, 107},     {204,  64, 111},     {207,  62, 115},
    {209,  61, 119},     {212,  60, 124},     {214,  58, 128},     {217,  57, 132},
    {219,  55, 136},     {222,  54, 140},     {224,  53, 144},     {227,  51, 148},
    {155,  92,  17},     {158,  90,  21},     {160,  89,  25},     {163,  87,  30},
    {165,  86,  34},     {167,  85,  38},     {170,  83,  42},     {172,  82,  46},
    {175,  80,  50},     {177,  79,  54},     {180,  78,  58},     {182,  76,  63},
    {185,  75,  67},     {187,  73,  71},     {190,  72,  75},     {192,  71,  79},
    {195,  69,  83},     {197,  68,  87},     {199,  67,  91},     {202,  65,  95},
    {204,  64, 100},     {207,  62, 104},     {209,  61, 108},     {212,  60, 112},
    {214,  58, 116},     {217,  57, 120},     {219,  55, 124},     {222,  54, 128},
    {224,  53, 132},     {226,  51, 137},     {229,  50, 141},     {231,  48, 145},
    {160,  89,  14},     {162,  87,  18},     {165,  86,  22},     {167,  85,  26},
    {170,  83,  30},     {172,  82,  34},     {175,  80,  39},     {177,  79,  43},
    {180,  78,  47},     {182,  76,  51},     {185,  75,  55},     {187,  74,  59},
    {190,  72,  63},     {192,  71,  67},     {194,  69,  71},     {197,  68,  76},
    {199,  67,  80},     {202,  65,  84},     {204,  64,  88},     {207,  62,  92},
    {209,  61,  96},     {212,  60, 100},     {214,  58, 104},     {217,  57, 108},
    {219,  55, 113},     {221,  54, 117},     {224,  53, 121},     {226,  51, 125},
    {229,  50, 129},     {231,  49, 133},     {234,  47, 137},     {236,  46, 141},
    { 11, 177, 120},     { 14, 176, 124},     { 16, 175, 128},     { 19, 173, 132},
    { 21, 172, 136},     { 24, 170, 141},     { 26, 169, 145},     { 28, 168, 149},
    { 31, 166, 153},     { 33, 165, 157},     { 36, 163, 161},     { 38, 162, 165},
    { 41, 161, 169},     { 43, 159, 173},     { 46, 158, 178},     { 48, 157, 182},
    { 51, 155, 186},     { 53, 154, 190},     { 56, 152, 194},     { 58, 151, 198},
    { 60, 150, 202},     { 63, 148, 206},     { 65, 147, 210},     { 68, 145, 215},
    { 70, 144, 219},     { 73, 143, 223},     { 75, 141, 227},     { 78, 140, 231},
    { 80, 138, 235},     { 83, 137, 239},     { 85, 136, 243},     { 87, 134, 248},
    { 16, 175, 117},     { 19, 173, 121},     { 21, 172, 125},     { 23, 170, 129},
    { 26, 169, 133},     { 28, 168, 137},     { 31, 166, 141},     { 33, 165, 145},
    { 36, 164, 149},     { 38, 162, 154},     { 41, 161, 158},     { 43, 159, 162},
    { 46, 158, 166},     { 48, 157, 170},     { 51, 155, 174},     { 53, 154, 178},
    { 55, 152, 182},     { 58, 151, 186},     { 60, 150, 191},     { 63, 148, 195},
    { 65, 147, 199},     { 68, 145, 203},     { 70, 144, 207},     { 73, 143, 211},
    { 75, 141, 215},     { 78, 140, 219},     { 80, 138, 223},     { 82, 137, 228},
    { 85, 136, 232},     { 87, 134, 236},     { 90, 133, 240},     { 92, 132, 244},
    { 21, 172, 113},     { 23, 171, 117},     { 26, 169, 121},     { 28, 168, 125},
    { 31, 166, 130},     { 33, 165, 134},     { 36, 164, 138},     { 38, 162, 142},
    { 41, 161, 146},     { 43, 159, 150},     { 46, 158, 154},     { 48, 157, 158},
    { 50, 155, 162},     { 53, 154, 167},     { 55, 152, 171},     { 58, 151, 175},
    { 60, 150, 179},     { 63, 148, 183},     { 65, 147, 187},     { 68, 145, 191},
    { 70, 144, 195},     { 73, 143, 199},     { 75, 141, 204},     { 77, 140, 208},
    { 80, 139, 212},     { 82, 137, 216},     { 85, 136, 220},     { 87, 134, 224},
    { 90, 133, 228},     { 92, 132, 232},     { 95, 130, 236},     { 97, 129, 241},
    { 26, 169, 110},     { 28, 168, 114},     { 31, 166, 118},     { 33, 165, 122},
    { 36, 164, 126},     { 38, 162, 130},     { 40, 161, 134},     { 43, 159, 138},
    { 45, 158, 143},     { 48, 157, 147},     { 50, 155, 151},     { 53, 154, 155},
    { 55, 153, 159},     { 58, 151, 163},     { 60, 150, 167},     { 63, 148, 171},
    { 65, 147, 175},     { 68, 146, 180},     { 70, 144, 184},     { 72, 143, 188},
    { 75, 141, 192},     { 77, 140, 196},     { 80, 139, 200},     { 82, 137, 204},
    { 85, 136, 208},     { 87, 134, 212},     { 90, 133, 217},     { 92, 132, 221},
    { 95, 130, 225},     { 97, 129, 229},     {100, 127, 233},     {102, 126, 237},
    { 31, 166, 106},     { 33, 165, 110},     { 35, 164, 114},     { 38, 162, 119},
    { 40, 161, 123},     { 43, 160, 127},     { 45, 158, 131},     { 48, 157, 135},
    { 50, 155, 139},     { 53, 154, 143},     { 55, 153, 147},     { 58, 151, 151},
    { 60, 150, 156},     { 63, 148, 160},     { 65, 147, 164},     { 67, 146, 168},
    { 70, 144, 172},     { 72, 143, 176},     { 75, 141, 180},     { 77, 140, 184},
    { 80, 139, 188},     { 82, 137, 193},     { 85, 136, 197},     { 87, 134, 201},
    { 90, 133, 205},     { 92, 132, 209},     { 95, 130, 213},     { 97, 129, 217},
    { 99, 128, 221},     {102, 126, 225},     {104, 125, 230},     {107, 123, 234},
    { 35, 164, 103},     { 38, 162, 107},     { 40, 161, 111},     { 43, 160, 115},
    { 45, 158, 119},     { 48, 157, 123},     { 50, 155, 127},     { 53, 154, 132},
    { 55, 153, 136},     { 58, 151, 140},     { 60, 150, 144},     { 62, 148, 148},
    { 65, 147, 152},     { 67, 146, 156},     { 70, 144, 160},     { 72, 143, 164},
    { 75, 141, 169},     { 77, 140, 173},     { 80, 139, 177},     { 82, 137, 181},
    { 85, 136, 185},     { 87, 135, 189},     { 90, 133, 193},     { 92, 132, 197},
    { 94, 130, 201},     { 97, 129, 206},     { 99, 128, 210},     {102, 126, 214},
    {104, 125, 218},     {107, 123, 222},     {109, 122, 226},     {112, 121, 230},
    { 40, 161,  99},     { 43, 160, 103},     { 45, 158, 108},     { 48, 157, 112},
    { 50, 155, 116},     { 53, 154, 120},     { 55, 153, 124},     { 57, 151, 128},
    { 60, 150, 132},     { 62, 149, 136},     { 65, 147, 140},     { 67, 146, 145},
    { 70, 144, 149},     { 72, 143, 153},     { 75, 142, 157},     { 77, 140, 161},
    { 80, 139, 165},     { 82, 137, 169},     { 84, 136, 173},     { 87, 135, 177},
    { 89, 133, 182},     { 92, 132, 186},     { 94, 130, 190},     { 97, 129, 194},
    { 99, 128, 198},     {102, 126, 202},     {104, 125, 206},     {107, 123, 210},
    {109, 122, 214},     {112, 121, 219},     {114, 119, 223},     {116, 118, 227},
    { 45, 158,  96},     { 48, 157, 100},     { 50, 156, 104},     { 52, 154, 108},
    { 55, 153, 112},     { 57, 151, 116},     { 60, 150, 121},     { 62, 149, 125},
    { 65, 147, 129},     { 67, 146, 133},     { 70, 144, 137},     { 72, 143, 141},
    { 75, 142, 145},     { 77, 140, 149},     { 79, 139, 153},     { 82, 137, 158},
    { 84, 136, 162},     { 87, 135, 166},     { 89, 133, 170},     { 92, 132, 174},
    { 94, 130, 178},     { 97, 129, 182},     { 99, 128, 186},     {102, 126, 190},
    {104, 125, 195},     {107, 124, 199},     {109, 122, 203},     {111, 121, 207},
    {114, 119, 211},     {116, 118, 215},     {119, 117, 219},     {121, 115, 223},
    { 50, 156,  92},     { 52, 154,  97},     { 55, 153, 101},     { 57, 151, 105},
    { 60, 150, 109},     { 62, 149, 113},     { 65, 147, 117},     { 67, 146, 121},
    { 70, 144, 125},     { 72, 143, 129},     { 74, 142, 134},     { 77, 140, 138},
    { 79, 139, 142},     { 82, 138, 146},     { 84, 136, 150},     { 87, 135, 154},
    { 89, 133, 158},     { 92, 132, 162},     { 94, 131, 166},     { 97, 129, 171},
    { 99, 128, 175},     {102, 126, 179},     {104, 125, 183},     {106, 124, 187},
    {109, 122, 191},     {111, 121, 195},     {114, 119, 199},     {116, 118, 203},
    {119, 117, 208},     {121, 115, 212},     {124, 114, 216},     {126, 112, 220},
    { 55, 153,  89},     { 57, 151,  93},     { 60, 150,  97},     { 62, 149, 101},
    { 65, 147, 105},     { 67, 146, 110},     { 69, 145, 114},     { 72, 143, 118},
    { 74, 142, 122},     { 77, 140, 126},     { 79, 139, 130},     { 82, 138, 134},
    { 84, 136, 138},     { 87, 135, 142},     { 89, 133, 147},     { 92, 132, 151},
    { 94, 131, 155},     { 97, 129, 159},     { 99, 128, 163},     {101, 126, 167},
    {104, 125, 171},     {106, 124, 175},     {109, 122, 179},     {111, 121, 184},
    {114, 119, 188},     {116, 118, 192},     {119, 117, 196},     {121, 115, 200},
    {124, 114, 204},     {126, 113, 208},     {128, 111, 212},     {131, 110, 216},
    { 60, 150,  86},     { 62, 149,  90},     { 64, 147,  94},     { 67, 146,  98},
    { 69, 145, 102},     { 72, 143, 106},     { 74, 142, 110},     { 77, 140, 114},
    { 79, 139, 118},     { 82, 138, 123},     { 84, 136, 127},     { 87, 135, 131},
    { 89, 133, 135},     { 92, 132, 139},     { 94, 131, 143},     { 96, 129, 147},
    { 99, 128, 151},     {101, 126, 155},     {104, 125, 160},     {106, 124, 164},
    {109, 122, 168},     {111, 121, 172},     {114, 120, 176},     {116, 118, 180},
    {119, 117, 184},     {121, 115, 188},     {123, 114, 192},     {126, 113, 197},
    {128, 111, 201},     {131, 110, 205},     {133, 108, 209},     {136, 107, 213},
    { 64, 147,  82},     { 67, 146,  86},     { 69, 145,  90},     { 72, 143,  94},
    { 74, 142,  99},     { 77, 140, 103},     { 79, 139, 107},     { 82, 138, 111},
    { 84, 136, 115},     { 87, 135, 119},     { 89, 134, 123},     { 91, 132, 127},
    { 94, 131, 131},     { 96, 129, 136},     { 99, 128, 140},     {101, 127, 144},
    {104, 125, 148},     {106, 124, 152},     {109, 122, 156},     {111, 121, 160},
    {114, 120, 164},     {116, 118, 168},     {118, 117, 173},     {121, 115, 177},
    {123, 114, 181},     {126, 113, 185},     {128, 111, 189},     {131, 110, 193},
    {133, 108, 197},     {136, 107, 201},     {138, 106, 205},     {141, 104, 210},
    { 69, 145,  79},     { 72, 143,  83},     { 74, 142,  87},     { 77, 141,  91},
    { 79, 139,  95},     { 81, 138,  99},     { 84, 136, 103},     { 86, 135, 107},
    { 89, 134, 112},     { 91, 132, 116},     { 94, 131, 120},     { 96, 129, 124},
    { 99, 128, 128},     {101, 127, 132},     {104, 125, 136},     {106, 124, 140},
    {109, 122, 144},     {111, 121, 149},     {113, 120, 153},     {116, 118, 157},
    {118, 117, 161},     {121, 115, 165},     {123, 114, 169},     {126, 113, 173},
    {128, 111, 177},     {131, 110, 181},     {133, 109, 186},     {136, 107, 190},
    {138, 106, 194},     {141, 104, 198},     {143, 103, 202},     {145, 102, 206},
    { 74, 142,  75},     { 76, 141,  79},     { 79, 139,  83},     { 81, 138,  88},
    { 84, 136,  92},     { 86, 135,  96},     { 89, 134, 100},     { 91, 132, 104},
    { 94, 131, 108},     { 96, 129, 112},     { 99, 128, 116},     {101, 127, 120},
    {104, 125, 125},     {106, 124, 129},     {108, 122, 133},     {111, 121, 137},
    {113, 120, 141},     {116, 118, 145},     {118, 117, 149},     {121, 116, 153},
    {123, 114, 157},     {126, 113, 162},     {128, 111, 166},     {131, 110, 170},
    {133, 109, 174},     {136, 107, 178},     {138, 106, 182},     {140, 104, 186},
    {143, 103, 190},     {145, 102, 194},     {148, 100, 199},     {150,  99, 203},
    { 79, 139,  72},     { 81, 138,  76},     { 84, 136,  80},     { 86, 135,  84},
    { 89, 134,  88},     { 91, 132,  92},     { 94, 131,  96},     { 96, 130, 101},
    { 99, 128, 105},     {101, 127, 109},     {103, 125, 113},     {106, 124, 117},
    {108, 123, 121},     {111, 121, 125},     {113, 120, 129},     {116, 118, 133},
    {118, 117, 138},     {121, 116, 142},     {123, 114, 146},     {126, 113, 150},
    {128, 111, 154},     {131, 110, 158},     {133, 109, 162},     {135, 107, 166},
    {138, 106, 170},     {140, 104, 175},     {143, 103, 179},     {145, 102, 183},
    {148, 100, 187},     {150,  99, 191},     {153,  98, 195},     {155,  96, 199},
    { 84, 137,  68},     { 86, 135,  72},     { 89, 134,  77},     { 91, 132,  81},
    { 94, 131,  85},     { 96, 130,  89},     { 98, 128,  93},     {101, 127,  97},
    {103, 125, 101},     {106, 124, 105},     {108, 123, 109},     {111, 121, 114},
    {113, 120, 118},     {116, 118, 122},     {118, 117, 126},     {121, 116, 130},
    {123, 114, 134},     {125, 113, 138},     {128, 111, 142},     {130, 110, 146},
    {133, 109, 151},     {135, 107, 155},     {138, 106, 159},     {140, 105, 163},
    {143, 103, 167},     {145, 102, 171},     {148, 100, 175},     {150,  99, 179},
    {153,  98, 183},     {155,  96, 188},     {157,  95, 192},     {160,  93, 196},
    { 89, 134,  65},     { 91, 132,  69},     { 93, 131,  73},     { 96, 130,  77},
    { 98, 128,  81},     {101, 127,  85},     {103, 125,  90},     {106, 124,  94},
    {108, 123,  98},     {111, 121, 102},     {113, 120, 106},     {116, 118, 110},
    {118, 117, 114},     {120, 116, 118},     {123, 114, 122},     {125, 113, 127},
    {128, 112, 131},     {130, 110, 135},     {133, 109, 139},     {135, 107, 143},
    {138, 106, 147},     {140, 105, 151},     {143, 103, 155},     {145, 102, 159},
    {148, 100, 164},     {150,  99, 168},     {152,  98, 172},     {155,  96, 176},
    {157,  95, 180},     {160,  93, 184},     {162,  92, 188},     {165,  91, 192},
    { 93, 131,  61},     { 96, 130,  66},     { 98, 128,  70},     {101, 127,  74},
    {103, 126,  78},     {106, 124,  82},     {108, 123,  86},     {111, 121,  90},
    {113, 120,  94},     {115, 119,  98},     {118, 117, 103},     {120, 116, 107},
    {123, 114, 111},     {125, 113, 115},     {128, 112, 119},     {130, 110, 123},
    {133, 109, 127},     {135, 107, 131},     {138, 106, 135},     {140, 105, 140},
    {143, 103, 144},     {145, 102, 148},     {147, 100, 152},     {150,  99, 156},
    {152,  98, 160},     {155,  96, 164},     {157,  95, 168},     {160,  94, 172},
    {162,  92, 177},     {165,  91, 181},     {167,  89, 185},     {170,  88, 189},
    { 98, 128,  58},     {101, 127,  62},     {103, 126,  66},     {106, 124,  70},
    {108, 123,  74},     {110, 121,  79},     {113, 120,  83},     {115, 119,  87},
    {118, 117,  91},     {120, 116,  95},     {123, 114,  99},     {125, 113, 103},
    {128, 112, 107},     {130, 110, 111},     {133, 109, 116},     {135, 107, 120},
    {138, 106, 124},     {140, 105, 128},     {142, 103, 132},     {145, 102, 136},
    {147, 101, 140},     {150,  99, 144},     {152,  98, 148},     {155,  96, 153},
    {157,  95, 157},     {160,  94, 161},     {162,  92, 165},     {165,  91, 169},
    {167,  89, 173},     {169,  88, 177},     {172,  87, 181},     {174,  85, 185},
    {103, 126,  55},     {105, 124,  59},     {108, 123,  63},     {110, 121,  67},
    {113, 120,  71},     {115, 119,  75},     {118, 117,  79},     {120, 116,  83},
    {123, 115,  87},     {125, 113,  92},     {128, 112,  96},     {130, 110, 100},
    {133, 109, 104},     {135, 108, 108},     {137, 106, 112},     {140, 105, 116},
    {142, 103, 120},     {145, 102, 124},     {147, 101, 129},     {150,  99, 133},
    {152,  98, 137},     {155,  96, 141},     {157,  95, 145},     {160,  94, 149},
    {162,  92, 153},     {164,  91, 157},     {167,  89, 161},     {169,  88, 166},
    {172,  87, 170},     {174,  85, 174},     {177,  84, 178},     {179,  83, 182},
    {108, 123,  51},     {110, 122,  55},     {113, 120,  59},     {115, 119,  63},
    {118, 117,  68},     {120, 116,  72},     {123, 115,  76},     {125, 113,  80},
    {128, 112,  84},     {130, 110,  88},     {132, 109,  92},     {135, 108,  96},
    {137, 106, 100},     {140, 105, 105},     {142, 103, 109},     {145, 102, 113},
    {147, 101, 117},     {150,  99, 121},     {152,  98, 125},     {155,  96, 129},
    {157,  95, 133},     {159,  94, 137},     {162,  92, 142},     {164,  91, 146},
    {167,  90, 150},     {169,  88, 154},     {172,  87, 158},     {174,  85, 162},
    {177,  84, 166},     {179,  83, 170},     {182,  81, 174},     {184,  80, 179},
    {113, 120,  48},     {115, 119,  52},     {118, 117,  56},     {120, 116,  60},
    {122, 115,  64},     {125, 113,  68},     {127, 112,  72},     {130, 110,  76},
    {132, 109,  81},     {135, 108,  85},     {137, 106,  89},     {140, 105,  93},
    {142, 103,  97},     {145, 102, 101},     {147, 101, 105},     {150,  99, 109},
    {152,  98, 113},     {154,  97, 118},     {157,  95, 122},     {159,  94, 126},
    {162,  92, 130},     {164,  91, 134},     {167,  90, 138},     {169,  88, 142},
    {172,  87, 146},     {174,  85, 150},     {177,  84, 155},     {179,  83, 159},
    {182,  81, 163},     {184,  80, 167},     {186,  78, 171},     {189,  77, 175},
    {117, 117,  44},     {120, 116,  48},     {122, 115,  52},     {125, 113,  57},
    {127, 112,  61},     {130, 111,  65},     {132, 109,  69},     {135, 108,  73},
    {137, 106,  77},     {140, 105,  81},     {142, 104,  85},     {145, 102,  89},
    {147, 101,  94},     {149,  99,  98},     {152,  98, 102},     {154,  97, 106},
    {157,  95, 110},     {159,  94, 114},     {162,  92, 118},     {164,  91, 122},
    {167,  90, 126},     {169,  88, 131},     {172,  87, 135},     {174,  85, 139},
    {177,  84, 143},     {179,  83, 147},     {181,  81, 151},     {184,  80, 155},
    {186,  79, 159},     {189,  77, 163},     {191,  76, 168},     {194,  74, 172},
    {122, 115,  41},     {125, 113,  45},     {127, 112,  49},     {130, 111,  53},
    {132, 109,  57},     {135, 108,  61},     {137, 106,  65},     {140, 105,  70},
    {142, 104,  74},     {144, 102,  78},     {147, 101,  82},     {149,  99,  86},
    {152,  98,  90},     {154,  97,  94},     {157,  95,  98},     {159,  94, 102},
    {162,  92, 107},     {164,  91, 111},     {167,  90, 115},     {169,  88, 119},
    {171,  87, 123},     {174,  86, 127},     {176,  84, 131},     {179,  83, 135},
    {181,  81, 139},     {184,  80, 144},     {186,  79, 148},     {189,  77, 152},
    {191,  76, 156},     {194,  74, 160},     {196,  73, 164},     {199,  72, 168},
    {127, 112,  37},     {130, 111,  41},     {132, 109,  46},     {135, 108,  50},
    {137, 106,  54},     {139, 105,  58},     {142, 104,  62},     {144, 102,  66},
    {147, 101,  70},     {149,  99,  74},     {152,  98,  78},     {154,  97,  83},
    {157,  95,  87},     {159,  94,  91},     {162,  93,  95},     {164,  91,  99},
    {166,  90, 103},     {169,  88, 107},     {171,  87, 111},     {174,  86, 115},
    {176,  84, 120},     {179,  83, 124},     {181,  81, 128},     {184,  80, 132},
    {186,  79, 136},     {189,  77, 140},     {191,  76, 144},     {194,  74, 148},
    {196,  73, 152},     {198,  72, 157},     {201,  70, 161},     {203,  69, 165},
    {132, 109,  34},     {134, 108,  38},     {137, 107,  42},     {139, 105,  46},
    {142, 104,  50},     {144, 102,  54},     {147, 101,  59},     {149, 100,  63},
    {152,  98,  67},     {154,  97,  71},     {157,  95,  75},     {159,  94,  79},
    {161,  93,  83},     {164,  91,  87},     {166,  90,  91},     {169,  88,  96},
    {171,  87, 100},     {174,  86, 104},     {176,  84, 108},     {179,  83, 112},
    {181,  81, 116},     {184,  80, 120},     {186,  79, 124},     {189,  77, 128},
    {191,  76, 133},     {193,  75, 137},     {196,  73, 141},     {198,  72, 145},
    {201,  70, 149},     {203,  69, 153},     {206,  68, 157},     {208,  66, 161},
    {137, 107,  30},     {139, 105,  35},     {142, 104,  39},     {144, 102,  43},
    {147, 101,  47},     {149, 100,  51},     {152,  98,  55},     {154,  97,  59},
    {156,  95,  63},     {159,  94,  67},     {161,  93,  72},     {164,  91,  76},
    {166,  90,  80},     {169,  88,  84},     {171,  87,  88},     {174,  86,  92},
    {176,  84,  96},     {179,  83, 100},     {181,  82, 104},     {184,  80, 109},
    {186,  79, 113},     {188,  77, 117},     {191,  76, 121},     {193,  75, 125},
    {196,  73, 129},     {198,  72, 133},     {201,  70, 137},     {203,  69, 141},
    {206,  68, 146},     {208,  66, 150},     {211,  65, 154},     {213,  63, 158},
    {142, 104,  27},     {144, 102,  31},     {147, 101,  35},     {149, 100,  39},
    {151,  98,  43},     {154,  97,  48},     {156,  95,  52},     {159,  94,  56},
    {161,  93,  60},     {164,  91,  64},     {166,  90,  68},     {169,  89,  72},
    {171,  87,  76},     {174,  86,  80},     {176,  84,  85},     {179,  83,  89},
    {181,  82,  93},     {183,  80,  97},     {186,  79, 101},     {188,  77, 105},
    {191,  76, 109},     {193,  75, 113},     {196,  73, 117},     {198,  72, 122},
    {201,  70, 126},     {203,  69, 130},     {206,  68, 134},     {208,  66, 138},
    {210,  65, 142},     {213,  64, 146},     {215,  62, 150},     {218,  61, 154},
    {146, 101,  23},     {149, 100,  28},     {151,  98,  32},     {154,  97,  36},
    {156,  96,  40},     {159,  94,  44},     {161,  93,  48},     {164,  91,  52},
    {166,  90,  56},     {169,  89,  61},     {171,  87,  65},     {174,  86,  69},
    {176,  84,  73},     {178,  83,  77},     {181,  82,  81},     {183,  80,  85},
    {186,  79,  89},     {188,  77,  93},     {191,  76,  98},     {193,  75, 102},
    {196,  73, 106},     {198,  72, 110},     {201,  71, 114},     {203,  69, 118},
    {205,  68, 122},     {208,  66, 126},     {210,  65, 130},     {213,  64, 135},
    {215,  62, 139},     {218,  61, 143},     {220,  59, 147},     {223,  58, 151},
    {151,  98,  20},     {154,  97,  24},     {156,  96,  28},     {159,  94,  32},
    {161,  93,  37},     {164,  91,  41},     {166,  90,  45},     {168,  89,  49},
    {171,  87,  53},     {173,  86,  57},     {176,  84,  61},     {178,  83,  65},
    {181,  82,  69},     {183,  80,  74},     {186,  79,  78},     {188,  78,  82},
    {191,  76,  86},     {193,  75,  90},     {196,  73,  94},     {198,  72,  98},
    {200,  71, 102},     {203,  69, 106},     {205,  68, 111},     {208,  66, 115},
    {210,  65, 119},     {213,  64, 123},     {215,  62, 127},     {218,  61, 131},
    {220,  59, 135},     {223,  58, 139},     {225,  57, 143},     {228,  55, 148},
    {156,  96,  17},     {159,  94,  21},     {161,  93,  25},     {163,  92,  29},
    {166,  90,  33},     {168,  89,  37},     {171,  87,  41},     {173,  86,  45},
    {176,  85,  50},     {178,  83,  54},     {181,  82,  58},     {183,  80,  62},
    {186,  79,  66},     {188,  78,  70},     {191,  76,  74},     {193,  75,  78},
    {195,  73,  82},     {198,  72,  87},     {200,  71,  91},     {203,  69,  95},
    {205,  68,  99},     {208,  66, 103},     {210,  65, 107},     {213,  64, 111},
    {215,  62, 115},     {218,  61, 119},     {220,  60, 124},     {223,  58, 128},
    {225,  57, 132},     {227,  55, 136},     {230,  54, 140},     {232,  53, 144},
    {161,  93,  13},     {163,  92,  17},     {166,  90,  21},     {168,  89,  25},
    {171,  87,  30},     {173,  86,  34},     {176,  85,  38},     {178,  83,  42},
    {181,  82,  46},     {183,  80,  50},     {186,  79,  54},     {188,  78,  58},
    {190,  76,  63},     {193,  75,  67},     {195,  73,  71},     {198,  72,  75},
    {200,  71,  79},     {203,  69,  83},     {205,  68,  87},     {208,  67,  91},
    {210,  65,  95},     {213,  64, 100},     {215,  62, 104},     {218,  61, 108},
    {220,  60, 112},     {222,  58, 116},     {225,  57, 120},     {227,  55, 124},
    {230,  54, 128},     {232,  53, 132},     {235,  51, 137},     {237,  50, 141},
    { 12, 181, 119},     { 15, 180, 123},     { 17, 179, 128},     { 20, 177, 132},
    { 22, 176, 136},     { 24, 175, 140},     { 27, 173, 144},     { 29, 172, 148},
    { 32, 170, 152},     { 34, 169, 156},     { 37, 168, 160},     { 39, 166, 165},
    { 42, 165, 169},     { 44, 163, 173},     { 47, 162, 177},     { 49, 161, 181},
    { 52, 159, 185},     { 54, 158, 189},     { 56, 156, 193},     { 59, 155, 197},
    { 61, 154, 202},     { 64, 152, 206},     { 66, 151, 210},     { 69, 149, 214},
    { 71, 148, 218},     { 74, 147, 222},     { 76, 145, 226},     { 79, 144, 230},
    { 81, 143, 234},     { 84, 141, 239},     { 86, 140, 243},     { 88, 138, 247},
    { 17, 179, 116},     { 19, 177, 120},     { 22, 176, 124},     { 24, 175, 128},
    { 27, 173, 132},     { 29, 172, 136},     { 32, 170, 141},     { 34, 169, 145},
    { 37, 168, 149},     { 39, 166, 153},     { 42, 165, 157},     { 44, 163, 161},
    { 47, 162, 165},     { 49, 161, 169},     { 51, 159, 173},     { 54, 158, 178},
    { 56, 157, 182},     { 59, 155, 186},     { 61, 154, 190},     { 64, 152, 194},
    { 66, 151, 198},     { 69, 150, 202},     { 71, 148, 206},     { 74, 147, 210},
    { 76, 145, 215},     { 79, 144, 219},     { 81, 143, 223},     { 83, 141, 227},
    { 86, 140, 231},     { 88, 138, 235},     { 91, 137, 239},     { 93, 136, 243},
    { 22, 176, 112},     { 24, 175, 117},     { 27, 173, 121},     { 29, 172, 125},
    { 32, 170, 129},     { 34, 169, 133},     { 37, 168, 137},     { 39, 166, 141},
    { 42, 165, 145},     { 44, 164, 149},     { 46, 162, 154},     { 49, 161, 158},
    { 51, 159, 162},     { 54, 158, 166},     { 56, 157, 170},     { 59, 155, 174},
    { 61, 154, 178},     { 64, 152, 182},     { 66, 151, 186},     { 69, 150, 191},
    { 71, 148, 195},     { 73, 147, 199},     { 76, 145, 203},     { 78, 144, 207},
    { 81, 143, 211},     { 83, 141, 215},     { 86, 140, 219},     { 88, 138, 223},
    { 91, 137, 228},     { 93, 136, 232},     { 96, 134, 236},     { 98, 133, 240},
    { 27, 173, 109},     { 29, 172, 113},     { 32, 171, 117},     { 34, 169, 121},
    { 37, 168, 125},     { 39, 166, 130},     { 41, 165, 134},     { 44, 164, 138},
    { 46, 162, 142},     { 49, 161, 146},     { 51, 159, 150},     { 54, 158, 154},
    { 56, 157, 158},     { 59, 155, 162},     { 61, 154, 167},     { 64, 152, 171},
    { 66, 151, 175},     { 68, 150, 179},     { 71, 148, 183},     { 73, 147, 187},
    { 76, 145, 191},     { 78, 144, 195},     { 81, 143, 199},     { 83, 141, 204},
    { 86, 140, 208},     { 88, 139, 212},     { 91, 137, 216},     { 93, 136, 220},
    { 96, 134, 224},     { 98, 133, 228},     {100, 132, 232},     {103, 130, 236},
    { 32, 171, 106},     { 34, 169, 110},     { 36, 168, 114},     { 39, 166, 118},
    { 41, 165, 122},     { 44, 164, 126},     { 46, 162, 130},     { 49, 161, 134},
    { 51, 159, 138},     { 54, 158, 143},     { 56, 157, 147},     { 59, 155, 151},
    { 61, 154, 155},     { 63, 153, 159},     { 66, 151, 163},     { 68, 150, 167},
    { 71, 148, 171},     { 73, 147, 175},     { 76, 146, 180},     { 78, 144, 184},
    { 81, 143, 188},     { 83, 141, 192},     { 86, 140, 196},     { 88, 139, 200},
    { 91, 137, 204},     { 93, 136, 208},     { 95, 134, 212},     { 98, 133, 217},
    {100, 132, 221},     {103, 130, 225},     {105, 129, 229},     {108, 127, 233},
    { 36, 168, 102},     { 39, 166, 106},     { 41, 165, 110},     { 44, 164, 114},
    { 46, 162, 119},     { 49, 161, 123},     { 51, 160, 127},     { 54, 158, 131},
    { 56, 157, 135},     { 58, 155, 139},     { 61, 154, 143},     { 63, 153, 147},
    { 66, 151, 151},     { 68, 150, 156},     { 71, 148, 160},     { 73, 147, 164},
    { 76, 146, 168},     { 78, 144, 172},     { 81, 143, 176},     { 83, 141, 180},
    { 86, 140, 184},     { 88, 139, 188},     { 90, 137, 193},     { 93, 136, 197},
    { 95, 134, 201},     { 98, 133, 205},     {100, 132, 209},     {103, 130, 213},
    {105, 129, 217},     {108, 128, 221},     {110, 126, 225},     {113, 125, 230},
    { 41, 165,  99},     { 44, 164, 103},     { 46, 162, 107},     { 49, 161, 111},
    { 51, 160, 115},     { 53, 158, 119},     { 56, 157, 123},     { 58, 155, 127},
    { 61, 154, 132},     { 63, 153, 136},     { 66, 151, 140},     { 68, 150, 144},
    { 71, 148, 148},     { 73, 147, 152},     { 76, 146, 156},     { 78, 144, 160},
    { 81, 143, 164},     { 83, 141, 169},     { 85, 140, 173},     { 88, 139, 177},
    { 90, 137, 181},     { 93, 136, 185},     { 95, 135, 189},     { 98, 133, 193},
    {100, 132, 197},     {103, 130, 201},     {105, 129, 206},     {108, 128, 210},
    {110, 126, 214},     {112, 125, 218},     {115, 123, 222},     {117, 122, 226},
    { 46, 162,  95},     { 48, 161,  99},     { 51, 160, 103},     { 53, 158, 108},
    { 56, 157, 112},     { 58, 155, 116},     { 61, 154, 120},     { 63, 153, 124},
    { 66, 151, 128},     { 68, 150, 132},     { 71, 149, 136},     { 73, 147, 140},
    { 76, 146, 145},     { 78, 144, 149},     { 80, 143, 153},     { 83, 142, 157},
    { 85, 140, 161},     { 88, 139, 165},     { 90, 137, 169},     { 93, 136, 173},
    { 95, 135, 177},     { 98, 133, 182},     {100, 132, 186},     {103, 130, 190},
    {105, 129, 194},     {107, 128, 198},     {110, 126, 202},     {112, 125, 206},
    {115, 123, 210},     {117, 122, 214},     {120, 121, 219},     {122, 119, 223},
    { 51, 160,  92},     { 53, 158,  96},     { 56, 157, 100},     { 58, 156, 104},
    { 61, 154, 108},     { 63, 153, 112},     { 66, 151, 116},     { 68, 150, 121},
    { 70, 149, 125},     { 73, 147, 129},     { 75, 146, 133},     { 78, 144, 137},
    { 80, 143, 141},     { 83, 142, 145},     { 85, 140, 149},     { 88, 139, 153},
    { 90, 137, 158},     { 93, 136, 162},     { 95, 135, 166},     { 98, 133, 170},
    {100, 132, 174},     {102, 130, 178},     {105, 129, 182},     {107, 128, 186},
    {110, 126, 190},     {112, 125, 195},     {115, 124, 199},     {117, 122, 203},
    {120, 121, 207},     {122, 119, 211},     {125, 118, 215},     {127, 117, 219},
    { 56, 157,  88},     { 58, 156,  92},     { 61, 154,  97},     { 63, 153, 101},
    { 65, 151, 105},     { 68, 150, 109},     { 70, 149, 113},     { 73, 147, 117},
    { 75, 146, 121},     { 78, 144, 125},     { 80, 143, 129},     { 83, 142, 134},
    { 85, 140, 138},     { 88, 139, 142},     { 90, 138, 146},     { 93, 136, 150},
    { 95, 135, 154},     { 97, 133, 158},     {100, 132, 162},     {102, 131, 166},
    {105, 129, 171},     {107, 128, 175},     {110, 126, 179},     {112, 125, 183},
    {115, 124, 187},     {117, 122, 191},     {120, 121, 195},     {122, 119, 199},
    {125, 118, 203},     {127, 117, 208},     {129, 115, 212},     {132, 114, 216},
    { 60, 154,  85},     { 63, 153,  89},     { 65, 151,  93},     { 68, 150,  97},
    { 70, 149, 101},     { 73, 147, 105},     { 75, 146, 110},     { 78, 145, 114},
    { 80, 143, 118},     { 83, 142, 122},     { 85, 140, 126},     { 88, 139, 130},
    { 90, 138, 134},     { 92, 136, 138},     { 95, 135, 142},     { 97, 133, 147},
    {100, 132, 151},     {102, 131, 155},     {105, 129, 159},     {107, 128, 163},
    {110, 126, 167},     {112, 125, 171},     {115, 124, 175},     {117, 122, 179},
    {120, 121, 184},     {122, 119, 188},     {124, 118, 192},     {127, 117, 196},
    {129, 115, 200},     {132, 114, 204},     {134, 113, 208},     {137, 111, 212},
    { 65, 152,  81},     { 68, 150,  86},     { 70, 149,  90},     { 73, 147,  94},
    { 75, 146,  98},     { 78, 145, 102},     { 80, 143, 106},     { 83, 142, 110},
    { 85, 140, 114},     { 87, 139, 118},     { 90, 138, 123},     { 92, 136, 127},
    { 95, 135, 131},     { 97, 133, 135},     {100, 132, 139},     {102, 131, 143},
    {105, 129, 147},     {107, 128, 151},     {110, 126, 155},     {112, 125, 160},
    {114, 124, 164},     {117, 122, 168},     {119, 121, 172},     {122, 120, 176},
    {124, 118, 180},     {127, 117, 184},     {129, 115, 188},     {132, 114, 192},
    {134, 113, 197},     {137, 111, 201},     {139, 110, 205},     {142, 108, 209},
    { 70, 149,  78},     { 73, 147,  82},     { 75, 146,  86},     { 78, 145,  90},
    { 80, 143,  94},     { 82, 142,  99},     { 85, 140, 103},     { 87, 139, 107},
    { 90, 138, 111},     { 92, 136, 115},     { 95, 135, 119},     { 97, 134, 123},
    {100, 132, 127},     {102, 131, 131},     {105, 129, 136},     {107, 128, 140},
    {109, 127, 144},     {112, 125, 148},     {114, 124, 152},     {117, 122, 156},
    {119, 121, 160},     {122, 120, 164},     {124, 118, 168},     {127, 117, 173},
    {129, 115, 177},     {132, 114, 181},     {134, 113, 185},     {137, 111, 189},
    {139, 110, 193},     {141, 108, 197},     {144, 107, 201},     {146, 106, 205},
    { 75, 146,  75},     { 77, 145,  79},     { 80, 143,  83},     { 82, 142,  87},
    { 85, 141,  91},     { 87, 139,  95},     { 90, 138,  99},     { 92, 136, 103},
    { 95, 135, 107},     { 97, 134, 112},     {100, 132, 116},     {102, 131, 120},
    {104, 129, 124},     {107, 128, 128},     {109, 127, 132},     {112, 125, 136},
    {114, 124, 140},     {117, 122, 144},     {119, 121, 149},     {122, 120, 153},
    {124, 118, 157},     {127, 117, 161},     {129, 115, 165},     {132, 114, 169},
    {134, 113, 173},     {136, 111, 177},     {139, 110, 181},     {141, 109, 186},
    {144, 107, 190},     {146, 106, 194},     {149, 104, 198},     {151, 103, 202},
    { 80, 143,  71},     { 82, 142,  75},     { 85, 141,  79},     { 87, 139,  83},
    { 90, 138,  88},     { 92, 136,  92},     { 95, 135,  96},     { 97, 134, 100},
    { 99, 132, 104},     {102, 131, 108},     {104, 129, 112},     {107, 128, 116},
    {109, 127, 120},     {112, 125, 125},     {114, 124, 129},     {117, 122, 133},
    {119, 121, 137},     {122, 120, 141},     {124, 118, 145},     {127, 117, 149},
    {129, 116, 153},     {131, 114, 157},     {134, 113, 162},     {136, 111, 166},
    {139, 110, 170},     {141, 109, 174},     {144, 107, 178},     {146, 106, 182},
    {149, 104, 186},     {151, 103, 190},     {154, 102, 194},     {156, 100, 199},
    { 85, 141,  68},     { 87, 139,  72},     { 90, 138,  76},     { 92, 136,  80},
    { 94, 135,  84},     { 97, 134,  88},     { 99, 132,  92},     {102, 131,  96},
    {104, 130, 101},     {107, 128, 105},     {109, 127, 109},     {112, 125, 113},
    {114, 124, 117},     {117, 123, 121},     {119, 121, 125},     {122, 120, 129},
    {124, 118, 133},     {126, 117, 138},     {129, 116, 142},     {131, 114, 146},
    {134, 113, 150},     {136, 111, 154},     {139, 110, 158},     {141, 109, 162},
    {144, 107, 166},     {146, 106, 170},     {149, 104, 175},     {151, 103, 179},
    {153, 102, 183},     {156, 100, 187},     {158,  99, 191},     {161,  98, 195},
    { 89, 138,  64},     { 92, 137,  68},     { 94, 135,  72},     { 97, 134,  77},
    { 99, 132,  81},     {102, 131,  85},     {104, 130,  89},     {107, 128,  93},
    {109, 127,  97},     {112, 125, 101},     {114, 124, 105},     {117, 123, 109},
    {119, 121, 114},     {121, 120, 118},     {124, 118, 122},     {126, 117, 126},
    {129, 116, 130},     {131, 114, 134},     {134, 113, 138},     {136, 111, 142},
    {139, 110, 146},     {141, 109, 151},     {144, 107, 155},     {146, 106, 159},
    {148, 105, 163},     {151, 103, 167},     {153, 102, 171},     {156, 100, 175},
    {158,  99, 179},     {161,  98, 183},     {163,  96, 188},     {166,  95, 192},
    { 94, 135,  61},     { 97, 134,  65},     { 99, 132,  69},     {102, 131,  73},
    {104, 130,  77},     {107, 128,  81},     {109, 127,  85},     {111, 125,  90},
    {114, 124,  94},     {116, 123,  98},     {119, 121, 102},     {121, 120, 106},
    {124, 118, 110},     {126, 117, 114},     {129, 116, 118},     {131, 114, 122},
    {134, 113, 127},     {136, 112, 131},     {139, 110, 135},     {141, 109, 139},
    {143, 107, 143},     {146, 106, 147},     {148, 105, 151},     {151, 103, 155},
    {153, 102, 159},     {156, 100, 164},     {158,  99, 168},     {161,  98, 172},
    {163,  96, 176},     {166,  95, 180},     {168,  93, 184},     {171,  92, 188},
    { 99, 132,  57},     {102, 131,  61},     {104, 130,  66},     {106, 128,  70},
    {109, 127,  74},     {111, 126,  78},     {114, 124,  82},     {116, 123,  86},
    {119, 121,  90},     {121, 120,  94},     {124, 119,  98},     {126, 117, 103},
    {129, 116, 107},     {131, 114, 111},     {134, 113, 115},     {136, 112, 119},
    {138, 110, 123},     {141, 109, 127},     {143, 107, 131},     {146, 106, 135},
    {148, 105, 140},     {151, 103, 144},     {153, 102, 148},     {156, 100, 152},
    {158,  99, 156},     {161,  98, 160},     {163,  96, 164},     {166,  95, 168},
    {168,  94, 172},     {170,  92, 177},     {173,  91, 181},     {175,  89, 185},
    {104, 130,  54},     {106, 128,  58},     {109, 127,  62},     {111, 126,  66},
    {114, 124,  70},     {116, 123,  74},     {119, 121,  79},     {121, 120,  83},
    {124, 119,  87},     {126, 117,  91},     {129, 116,  95},     {131, 114,  99},
    {133, 113, 103},     {136, 112, 107},     {138, 110, 111},     {141, 109, 116},
    {143, 107, 120},     {146, 106, 124},     {148, 105, 128},     {151, 103, 132},
    {153, 102, 136},     {156, 101, 140},     {158,  99, 144},     {161,  98, 148},
    {163,  96, 153},     {165,  95, 157},     {168,  94, 161},     {170,  92, 165},
    {173,  91, 169},     {175,  89, 173},     {178,  88, 177},     {180,  87, 181},
    {109, 127,  50},     {111, 126,  55},     {114, 124,  59},     {116, 123,  63},
    {119, 121,  67},     {121, 120,  71},     {124, 119,  75},     {126, 117,  79},
    {128, 116,  83},     {131, 115,  87},     {133, 113,  92},     {136, 112,  96},
    {138, 110, 100},     {141, 109, 104},     {143, 108, 108},     {146, 106, 112},
    {148, 105, 116},     {151, 103, 120},     {153, 102, 124},     {155, 101, 129},
    {158,  99, 133},     {160,  98, 137},     {163,  96, 141},     {165,  95, 145},
    {168,  94, 149},     {170,  92, 153},     {173,  91, 157},     {175,  89, 161},
    {178,  88, 166},     {180,  87, 170},     {183,  85, 174},     {185,  84, 178},
    {114, 124,  47},     {116, 123,  51},     {119, 122,  55},     {121, 120,  59},
    {123, 119,  63},     {126, 117,  68},     {128, 116,  72},     {131, 115,  76},
    {133, 113,  80},     {136, 112,  84},     {138, 110,  88},     {141, 109,  92},
    {143, 108,  96},     {146, 106, 100},     {148, 105, 105},     {150, 103, 109},
    {153, 102, 113},     {155, 101, 117},     {158,  99, 121},     {160,  98, 125},
    {163,  96, 129},     {165,  95, 133},     {168,  94, 137},     {170,  92, 142},
    {173,  91, 146},     {175,  90, 150},     {178,  88, 154},     {180,  87, 158},
    {182,  85, 162},     {185,  84, 166},     {187,  83, 170},     {190,  81, 174},
    {118, 122,  44},     {121, 120,  48},     {123, 119,  52},     {126, 117,  56},
    {128, 116,  60},     {131, 115,  64},     {133, 113,  68},     {136, 112,  72},
    {138, 110,  76},     {141, 109,  81},     {143, 108,  85},     {145, 106,  89},
    {148, 105,  93},     {150, 103,  97},     {153, 102, 101},     {155, 101, 105},
    {158,  99, 109},     {160,  98, 113},     {163,  97, 118},     {165,  95, 122},
    {168,  94, 126},     {170,  92, 130},     {173,  91, 134},     {175,  90, 138},
    {177,  88, 142},     {180,  87, 146},     {182,  85, 150},     {185,  84, 155},
    {187,  83, 159},     {190,  81, 163},     {192,  80, 167},     {195,  78, 171},
    {123, 119,  40},     {126, 117,  44},     {128, 116,  48},     {131, 115,  52},
    {133, 113,  57},     {136, 112,  61},     {138, 111,  65},     {140, 109,  69},
    {143, 108,  73},     {145, 106,  77},     {148, 105,  81},     {150, 104,  85},
    {153, 102,  89},     {155, 101,  94},     {158,  99,  98},     {160,  98, 102},
    {163,  97, 106},     {165,  95, 110},     {168,  94, 114},     {170,  92, 118},
    {172,  91, 122},     {175,  90, 126},     {177,  88, 131},     {180,  87, 135},
    {182,  85, 139},     {185,  84, 143},     {187,  83, 147},     {190,  81, 151},
    {192,  80, 155},     {195,  79, 159},     {197,  77, 163},     {199,  76, 168},
    {128, 116,  37},     {131, 115,  41},     {133, 113,  45},     {135, 112,  49},
    {138, 111,  53},     {140, 109,  57},     {143, 108,  61},     {145, 106,  65},
    {148, 105,  70},     {150, 104,  74},     {153, 102,  78},     {155, 101,  82},
    {158,  99,  86},     {160,  98,  90},     {163,  97,  94},     {165,  95,  98},
    {167,  94, 102},     {170,  92, 107},     {172,  91, 111},     {175,  90, 115},
    {177,  88, 119},     {180,  87, 123},     {182,  86, 127},     {185,  84, 131},
    {187,  83, 135},     {190,  81, 139},     {192,  80, 144},     {194,  79, 148},
    {197,  77, 152},     {199,  76, 156},     {202,  74, 160},     {204,  73, 164},
    {133, 113,  33},     {135, 112,  37},     {138, 111,  41},     {140, 109,  46},
    {143, 108,  50},     {145, 106,  54},     {148, 105,  58},     {150, 104,  62},
    {153, 102,  66},     {155, 101,  70},     {157,  99,  74},     {160,  98,  78},
    {162,  97,  83},     {165,  95,  87},     {167,  94,  91},     {170,  93,  95},
    {172,  91,  99},     {175,  90, 103},     {177,  88, 107},     {180,  87, 111},
    {182,  86, 115},     {185,  84, 120},     {187,  83, 124},     {189,  81, 128},
    {192,  80, 132},     {194,  79, 136},     {197,  77, 140},     {199,  76, 144},
    {202,  74, 148},     {204,  73, 152},     {207,  72, 157},     {209,  70, 161},
    {138, 111,  30},     {140, 109,  34},     {143, 108,  38},     {145, 107,  42},
    {148, 105,  46},     {150, 104,  50},     {152, 102,  54},     {155, 101,  59},
    {157, 100,  63},     {160,  98,  67},     {162,  97,  71},     {165,  95,  75},
    {167,  94,  79},     {170,  93,  83},     {172,  91,  87},     {175,  90,  91},
    {177,  88,  96},     {180,  87, 100},     {182,  86, 104},     {184,  84, 108},
    {187,  83, 112},     {189,  81, 116},     {192,  80, 120},     {194,  79, 124},
    {197,  77, 128},     {199,  76, 133},     {202,  75, 137},     {204,  73, 141},
    {207,  72, 145},     {209,  70, 149},     {212,  69, 153},     {214,  68, 157},
    {143, 108,  26},     {145, 107,  30},     {147, 105,  35},     {150, 104,  39},
    {152, 102,  43},     {155, 101,  47},     {157, 100,  51},     {160,  98,  55},
    {162,  97,  59},     {165,  95,  63},     {167,  94,  67},     {170,  93,  72},
    {172,  91,  76},     {175,  90,  80},     {177,  88,  84},     {179,  87,  88},
    {182,  86,  92},     {184,  84,  96},     {187,  83, 100},     {189,  82, 104},
    {192,  80, 109},     {194,  79, 113},     {197,  77, 117},     {199,  76, 121},
    {202,  75, 125},     {204,  73, 129},     {207,  72, 133},     {209,  70, 137},
    {211,  69, 141},     {214,  68, 146},     {216,  66, 150},     {219,  65, 154},
    {147, 105,  23},     {150, 104,  27},     {152, 102,  31},     {155, 101,  35},
    {157, 100,  39},     {160,  98,  43},     {162,  97,  48},     {165,  95,  52},
    {167,  94,  56},     {170,  93,  60},     {172,  91,  64},     {174,  90,  68},
    {177,  89,  72},     {179,  87,  76},     {182,  86,  80},     {184,  84,  85},
    {187,  83,  89},     {189,  82,  93},     {192,  80,  97},     {194,  79, 101},
    {197,  77, 105},     {199,  76, 109},     {201,  75, 113},     {204,  73, 117},
    {206,  72, 122},     {209,  70, 126},     {211,  69, 130},     {214,  68, 134},
    {216,  66, 138},     {219,  65, 142},     {221,  64, 146},     {224,  62, 150},
    {152, 103,  19},     {155, 101,  23},     {157, 100,  28},     {160,  98,  32},
    {162,  97,  36},     {165,  96,  40},     {167,  94,  44},     {169,  93,  48},
    {172,  91,  52},     {174,  90,  56},     {177,  89,  61},     {179,  87,  65},
    {182,  86,  69},     {184,  84,  73},     {187,  83,  77},     {189,  82,  81},
    {192,  80,  85},     {194,  79,  89},     {196,  77,  93},     {199,  76,  98},
    {201,  75, 102},     {204,  73, 106},     {206,  72, 110},     {209,  71, 114},
    {211,  69, 118},     {214,  68, 122},     {216,  66, 126},     {219,  65, 130},
    {221,  64, 135},     {224,  62, 139},     {226,  61, 143},     {228,  59, 147},
    {157, 100,  16},     {160,  98,  20},     {162,  97,  24},     {164,  96,  28},
    {167,  94,  32},     {169,  93,  37},     {172,  91,  41},     {174,  90,  45},
    {177,  89,  49},     {179,  87,  53},     {182,  86,  57},     {184,  84,  61},
    {187,  83,  65},     {189,  82,  69},     {191,  80,  74},     {194,  79,  78},
    {196,  78,  82},     {199,  76,  86},     {201,  75,  90},     {204,  73,  94},
    {206,  72,  98},     {209,  71, 102},     {211,  69, 106},     {214,  68, 111},
    {216,  66, 115},     {219,  65, 119},     {221,  64, 123},     {223,  62, 127},
    {226,  61, 131},     {228,  59, 135},     {231,  58, 139},     {233,  57, 143},
    {162,  97,  12},     {164,  96,  17},     {167,  94,  21},     {169,  93,  25},
    {172,  92,  29},     {174,  90,  33},     {177,  89,  37},     {179,  87,  41},
    {182,  86,  45},     {184,  85,  50},     {186,  83,  54},     {189,  82,  58},
    {191,  80,  62},     {194,  79,  66},     {196,  78,  70},     {199,  76,  74},
    {201,  75,  78},     {204,  73,  82},     {206,  72,  87},     {209,  71,  91},
    {211,  69,  95},     {214,  68,  99},     {216,  66, 103},     {218,  65, 107},
    {221,  64, 111},     {223,  62, 115},     {226,  61, 119},     {228,  60, 124},
    {231,  58, 128},     {233,  57, 132},     {236,  55, 136},     {238,  54, 140},
    { 13, 186, 119},     { 16, 184, 123},     { 18, 183, 127},     { 21, 181, 131},
    { 23, 180, 135},     { 25, 179, 139},     { 28, 177, 143},     { 30, 176, 147},
    { 33, 174, 152},     { 35, 173, 156},     { 38, 172, 160},     { 40, 170, 164},
    { 43, 169, 168},     { 45, 168, 172},     { 48, 166, 176},     { 50, 165, 180},
    { 52, 163, 184},     { 55, 162, 189},     { 57, 161, 193},     { 60, 159, 197},
    { 62, 158, 201},     { 65, 156, 205},     { 67, 155, 209},     { 70, 154, 213},
    { 72, 152, 217},     { 75, 151, 221},     { 77, 149, 226},     { 80, 148, 230},
    { 82, 147, 234},     { 84, 145, 238},     { 87, 144, 242},     { 89, 142, 246},
    { 18, 183, 115},     { 20, 181, 119},     { 23, 180, 123},     { 25, 179, 128},
    { 28, 177, 132},     { 30, 176, 136},     { 33, 175, 140},     { 35, 173, 144},
    { 38, 172, 148},     { 40, 170, 152},     { 43, 169, 156},     { 45, 168, 160},
    { 47, 166, 165},     { 50, 165, 169},     { 52, 163, 173},     { 55, 162, 177},
    { 57, 161, 181},     { 60, 159, 185},     { 62, 158, 189},     { 65, 156, 193},
    { 67, 155, 197},     { 70, 154, 202},     { 72, 152, 206},     { 75, 151, 210},
    { 77, 149, 214},     { 79, 148, 218},     { 82, 147, 222},     { 84, 145, 226},
    { 87, 144, 230},     { 89, 143, 234},     { 92, 141, 239},     { 94, 140, 243},
    { 23, 180, 112},     { 25, 179, 116},     { 28, 177, 120},     { 30, 176, 124},
    { 33, 175, 128},     { 35, 173, 132},     { 38, 172, 136},     { 40, 170, 141},
    { 42, 169, 145},     { 45, 168, 149},     { 47, 166, 153},     { 50, 165, 157},
    { 52, 163, 161},     { 55, 162, 165},     { 57, 161, 169},     { 60, 159, 173},
    { 62, 158, 178},     { 65, 157, 182},     { 67, 155, 186},     { 70, 154, 190},
    { 72, 152, 194},     { 74, 151, 198},     { 77, 150, 202},     { 79, 148, 206},
    { 82, 147, 210},     { 84, 145, 215},     { 87, 144, 219},     { 89, 143, 223},
    { 92, 141, 227},     { 94, 140, 231},     { 97, 138, 235},     { 99, 137, 239},
    { 28, 177, 108},     { 30, 176, 112},     { 33, 175, 117},     { 35, 173, 121},
    { 37, 172, 125},     { 40, 170, 129},     { 42, 169, 133},     { 45, 168, 137},
    { 47, 166, 141},     { 50, 165, 145},     { 52, 164, 149},     { 55, 162, 154},
    { 57, 161, 158},     { 60, 159, 162},     { 62, 158, 166},     { 65, 157, 170},
    { 67, 155, 174},     { 69, 154, 178},     { 72, 152, 182},     { 74, 151, 186},
    { 77, 150, 191},     { 79, 148, 195},     { 82, 147, 199},     { 84, 145, 203},
    { 87, 144, 207},     { 89, 143, 211},     { 92, 141, 215},     { 94, 140, 219},
    { 96, 138, 223},     { 99, 137, 228},     {101, 136, 232},     {104, 134, 236},
    { 32, 175, 105},     { 35, 173, 109},     { 37, 172, 113},     { 40, 171, 117},
    { 42, 169, 121},     { 45, 168, 125},     { 47, 166, 130},     { 50, 165, 134},
    { 52, 164, 138},     { 55, 162, 142},     { 57, 161, 146},     { 59, 159, 150},
    { 62, 158, 154},     { 64, 157, 158},     { 67, 155, 162},     { 69, 154, 167},
    { 72, 152, 171},     { 74, 151, 175},     { 77, 150, 179},     { 79, 148, 183},
    { 82, 147, 187},     { 84, 145, 191},     { 87, 144, 195},     { 89, 143, 199},
    { 91, 141, 204},     { 94, 140, 208},     { 96, 139, 212},     { 99, 137, 216},
    {101, 136, 220},     {104, 134, 224},     {106, 133, 228},     {109, 132, 232},
    { 37, 172, 101},     { 40, 171, 106},     { 42, 169, 110},     { 45, 168, 114},
    { 47, 166, 118},     { 50, 165, 122},     { 52, 164, 126},     { 54, 162, 130},
    { 57, 161, 134},     { 59, 159, 138},     { 62, 158, 143},     { 64, 157, 147},
    { 67, 155, 151},     { 69, 154, 155},     { 72, 153, 159},     { 74, 151, 163},
    { 77, 150, 167},     { 79, 148, 171},     { 82, 147, 175},     { 84, 146, 180},
    { 86, 144, 184},     { 89, 143, 188},     { 91, 141, 192},     { 94, 140, 196},
    { 96, 139, 200},     { 99, 137, 204},     {101, 136, 208},     {104, 134, 212},
    {106, 133, 217},     {109, 132, 221},     {111, 130, 225},     {114, 129, 229},
    { 42, 169,  98},     { 45, 168, 102},     { 47, 166, 106},     { 49, 165, 110},
    { 52, 164, 114},     { 54, 162, 119},     { 57, 161, 123},     { 59, 160, 127},
    { 62, 158, 131},     { 64, 157, 135},     { 67, 155, 139},     { 69, 154, 143},
    { 72, 153, 147},     { 74, 151, 151},     { 77, 150, 156},     { 79, 148, 160},
    { 81, 147, 164},     { 84, 146, 168},     { 86, 144, 172},     { 89, 143, 176},
    { 91, 141, 180},     { 94, 140, 184},     { 96, 139, 188},     { 99, 137, 193},
    {101, 136, 197},     {104, 134, 201},     {106, 133, 205},     {109, 132, 209},
    {111, 130, 213},     {113, 129, 217},     {116, 128, 221},     {118, 126, 225},
    { 47, 167,  95},     { 49, 165,  99},     { 52, 164, 103},     { 54, 162, 107},
    { 57, 161, 111},     { 59, 160, 115},     { 62, 158, 119},     { 64, 157, 123},
    { 67, 155, 127},     { 69, 154, 132},     { 72, 153, 136},     { 74, 151, 140},
    { 76, 150, 144},     { 79, 148, 148},     { 81, 147, 152},     { 84, 146, 156},
    { 86, 144, 160},     { 89, 143, 164},     { 91, 141, 169},     { 94, 140, 173},
    { 96, 139, 177},     { 99, 137, 181},     {101, 136, 185},     {103, 135, 189},
    {106, 133, 193},     {108, 132, 197},     {111, 130, 201},     {113, 129, 206},
    {116, 128, 210},     {118, 126, 214},     {121, 125, 218},     {123, 123, 222},
    { 52, 164,  91},     { 54, 162,  95},     { 57, 161,  99},     { 59, 160, 103},
    { 62, 158, 108},     { 64, 157, 112},     { 67, 155, 116},     { 69, 154, 120},
    { 71, 153, 124},     { 74, 151, 128},     { 76, 150, 132},     { 79, 149, 136},
    { 81, 147, 140},     { 84, 146, 145},     { 86, 144, 149},     { 89, 143, 153},
    { 91, 142, 157},     { 94, 140, 161},     { 96, 139, 165},     { 98, 137, 169},
    {101, 136, 173},     {103, 135, 177},     {106, 133, 182},     {108, 132, 186},
    {111, 130, 190},     {113, 129, 194},     {116, 128, 198},     {118, 126, 202},
    {121, 125, 206},     {123, 123, 210},     {126, 122, 214},     {128, 121, 219},
    { 57, 161,  88},     { 59, 160,  92},     { 62, 158,  96},     { 64, 157, 100},
    { 66, 156, 104},     { 69, 154, 108},     { 71, 153, 112},     { 74, 151, 116},
    { 76, 150, 121},     { 79, 149, 125},     { 81, 147, 129},     { 84, 146, 133},
    { 86, 144, 137},     { 89, 143, 141},     { 91, 142, 145},     { 93, 140, 149},
    { 96, 139, 153},     { 98, 137, 158},     {101, 136, 162},     {103, 135, 166},
    {106, 133, 170},     {108, 132, 174},     {111, 130, 178},     {113, 129, 182},
    {116, 128, 186},     {118, 126, 190},     {121, 125, 195},     {123, 124, 199},
    {125, 122, 203},     {128, 121, 207},     {130, 119, 211},     {133, 118, 215},
    { 61, 158,  84},     { 64, 157,  88},     { 66, 156,  92},     { 69, 154,  97},
    { 71, 153, 101},     { 74, 151, 105},     { 76, 150, 109},     { 79, 149, 113},
    { 81, 147, 117},     { 84, 146, 121},     { 86, 144, 125},     { 88, 143, 129},
    { 91, 142, 134},     { 93, 140, 138},     { 96, 139, 142},     { 98, 138, 146},
    {101, 136, 150},     {103, 135, 154},     {106, 133, 158},     {108, 132, 162},
    {111, 131, 166},     {113, 129, 171},     {116, 128, 175},     {118, 126, 179},
    {120, 125, 183},     {123, 124, 187},     {125, 122, 191},     {128, 121, 195},
    {130, 119, 199},     {133, 118, 203},     {135, 117, 208},     {138, 115, 212},
    { 66, 156,  81},     { 69, 154,  85},     { 71, 153,  89},     { 74, 151,  93},
    { 76, 150,  97},     { 79, 149, 101},     { 81, 147, 105},     { 83, 146, 110},
    { 86, 145, 114},     { 88, 143, 118},     { 91, 142, 122},     { 93, 140, 126},
    { 96, 139, 130},     { 98, 138, 134},     {101, 136, 138},     {103, 135, 142},
    {106, 133, 147},     {108, 132, 151},     {111, 131, 155},     {113, 129, 159},
    {115, 128, 163},     {118, 126, 167},     {120, 125, 171},     {123, 124, 175},
    {125, 122, 179},     {128, 121, 184},     {130, 119, 188},     {133, 118, 192},
    {135, 117, 196},     {138, 115, 200},     {140, 114, 204},     {142, 113, 208},
    { 71, 153,  77},     { 74, 152,  81},     { 76, 150,  86},     { 78, 149,  90},
    { 81, 147,  94},     { 83, 146,  98},     { 86, 145, 102},     { 88, 143, 106},
    { 91, 142, 110},     { 93, 140, 114},     { 96, 139, 118},     { 98, 138, 123},
    {101, 136, 127},     {103, 135, 131},     {106, 133, 135},     {108, 132, 139},
    {110, 131, 143},     {113, 129, 147},     {115, 128, 151},     {118, 126, 155},
    {120, 125, 160},     {123, 124, 164},     {125, 122, 168},     {128, 121, 172},
    {130, 120, 176},     {133, 118, 180},     {135, 117, 184},     {137, 115, 188},
    {140, 114, 192},     {142, 113, 197},     {145, 111, 201},     {147, 110, 205},
    { 76, 150,  74},     { 78, 149,  78},     { 81, 147,  82},     { 83, 146,  86},
    { 86, 145,  90},     { 88, 143,  94},     { 91, 142,  99},     { 93, 140, 103},
    { 96, 139, 107},     { 98, 138, 111},     {100, 136, 115},     {103, 135, 119},
    {105, 134, 123},     {108, 132, 127},     {110, 131, 131},     {113, 129, 136},
    {115, 128, 140},     {118, 127, 144},     {120, 125, 148},     {123, 124, 152},
    {125, 122, 156},     {128, 121, 160},     {130, 120, 164},     {132, 118, 168},
    {135, 117, 173},     {137, 115, 177},     {140, 114, 181},     {142, 113, 185},
    {145, 111, 189},     {147, 110, 193},     {150, 108, 197},     {152, 107, 201},
    { 81, 147,  70},     { 83, 146,  75},     { 86, 145,  79},     { 88, 143,  83},
    { 91, 142,  87},     { 93, 141,  91},     { 95, 139,  95},     { 98, 138,  99},
    {100, 136, 103},     {103, 135, 107},     {105, 134, 112},     {108, 132, 116},
    {110, 131, 120},     {113, 129, 124},     {115, 128, 128},     {118, 127, 132},
    {120, 125, 136},     {123, 124, 140},     {125, 122, 144},     {127, 121, 149},
    {130, 120, 153},     {132, 118, 157},     {135, 117, 161},     {137, 115, 165},
    {140, 114, 169},     {142, 113, 173},     {145, 111, 177},     {147, 110, 181},
    {150, 109, 186},     {152, 107, 190},     {155, 106, 194},     {157, 104, 198},
    { 86, 145,  67},     { 88, 143,  71},     { 90, 142,  75},     { 93, 141,  79},
    { 95, 139,  83},     { 98, 138,  88},     {100, 136,  92},     {103, 135,  96},
    {105, 134, 100},     {108, 132, 104},     {110, 131, 108},     {113, 129, 112},
    {115, 128, 116},     {118, 127, 120},     {120, 125, 125},     {122, 124, 129},
    {125, 122, 133},     {127, 121, 137},     {130, 120, 141},     {132, 118, 145},
    {135, 117, 149},     {137, 116, 153},     {140, 114, 157},     {142, 113, 162},
    {145, 111, 166},     {147, 110, 170},     {150, 109, 174},     {152, 107, 178},
    {154, 106, 182},     {157, 104, 186},     {159, 103, 190},     {162, 102, 194},
    { 90, 142,  64},     { 93, 141,  68},     { 95, 139,  72},     { 98, 138,  76},
    {100, 136,  80},     {103, 135,  84},     {105, 134,  88},     {108, 132,  92},
    {110, 131,  96},     {113, 130, 101},     {115, 128, 105},     {117, 127, 109},
    {120, 125, 113},     {122, 124, 117},     {125, 123, 121},     {127, 121, 125},
    {130, 120, 129},     {132, 118, 133},     {135, 117, 138},     {137, 116, 142},
    {140, 114, 146},     {142, 113, 150},     {144, 111, 154},     {147, 110, 158},
    {149, 109, 162},     {152, 107, 166},     {154, 106, 170},     {157, 104, 175},
    {159, 103, 179},     {162, 102, 183},     {164, 100, 187},     {167,  99, 191},
    { 95, 139,  60},     { 98, 138,  64},     {100, 137,  68},     {103, 135,  72},
    {105, 134,  77},     {108, 132,  81},     {110, 131,  85},     {112, 130,  89},
    {115, 128,  93},     {117, 127,  97},     {120, 125, 101},     {122, 124, 105},
    {125, 123, 109},     {127, 121, 114},     {130, 120, 118},     {132, 118, 122},
    {135, 117, 126},     {137, 116, 130},     {139, 114, 134},     {142, 113, 138},
    {144, 111, 142},     {147, 110, 146},     {149, 109, 151},     {152, 107, 155},
    {154, 106, 159},     {157, 105, 163},     {159, 103, 167},     {162, 102, 171},
    {164, 100, 175},     {167,  99, 179},     {169,  98, 183},     {171,  96, 188},
    {100, 137,  57},     {103, 135,  61},     {105, 134,  65},     {107, 132,  69},
    {110, 131,  73},     {112, 130,  77},     {115, 128,  81},     {117, 127,  85},
    {120, 125,  90},     {122, 124,  94},     {125, 123,  98},     {127, 121, 102},
    {130, 120, 106},     {132, 118, 110},     {134, 117, 114},     {137, 116, 118},
    {139, 114, 122},     {142, 113, 127},     {144, 112, 131},     {147, 110, 135},
    {149, 109, 139},     {152, 107, 143},     {154, 106, 147},     {157, 105, 151},
    {159, 103, 155},     {162, 102, 159},     {164, 100, 164},     {166,  99, 168},
    {169,  98, 172},     {171,  96, 176},     {174,  95, 180},     {176,  93, 184},
    {105, 134,  53},     {107, 132,  57},     {110, 131,  61},     {112, 130,  66},
    {115, 128,  70},     {117, 127,  74},     {120, 126,  78},     {122, 124,  82},
    {125, 123,  86},     {127, 121,  90},     {129, 120,  94},     {132, 119,  98},
    {134, 117, 103},     {137, 116, 107},     {139, 114, 111},     {142, 113, 115},
    {144, 112, 119},     {147, 110, 123},     {149, 109, 127},     {152, 107, 131},
    {154, 106, 135},     {157, 105, 140},     {159, 103, 144},     {161, 102, 148},
    {164, 100, 152},     {166,  99, 156},     {169,  98, 160},     {171,  96, 164},
    {174,  95, 168},     {176,  94, 172},     {179,  92, 177},     {181,  91, 181},
    {110, 131,  50},     {112, 130,  54},     {115, 128,  58},     {117, 127,  62},
    {120, 126,  66},     {122, 124,  70},     {124, 123,  74},     {127, 121,  79},
    {129, 120,  83},     {132, 119,  87},     {134, 117,  91},     {137, 116,  95},
    {139, 114,  99},     {142, 113, 103},     {144, 112, 107},     {147, 110, 111},
    {149, 109, 116},     {152, 107, 120},     {154, 106, 124},     {156, 105, 128},
    {159, 103, 132},     {161, 102, 136},     {164, 101, 140},     {166,  99, 144},
    {169,  98, 148},     {171,  96, 153},     {174,  95, 157},     {176,  94, 161},
    {179,  92, 165},     {181,  91, 169},     {183,  89, 173},     {186,  88, 177},
    {115, 128,  46},     {117, 127,  50},     {119, 126,  55},     {122, 124,  59},
    {124, 123,  63},     {127, 121,  67},     {129, 120,  71},     {132, 119,  75},
    {134, 117,  79},     {137, 116,  83},     {139, 115,  87},     {142, 113,  92},
    {144, 112,  96},     {147, 110, 100},     {149, 109, 104},     {151, 108, 108},
    {154, 106, 112},     {156, 105, 116},     {159, 103, 120},     {161, 102, 124},
    {164, 101, 129},     {166,  99, 133},     {169,  98, 137},     {171,  96, 141},
    {174,  95, 145},     {176,  94, 149},     {178,  92, 153},     {181,  91, 157},
    {183,  89, 161},     {186,  88, 166},     {188,  87, 170},     {191,  85, 174},
    {119, 126,  43},     {122, 124,  47},     {124, 123,  51},     {127, 122,  55},
    {129, 120,  59},     {132, 119,  63},     {134, 117,  68},     {137, 116,  72},
    {139, 115,  76},     {141, 113,  80},     {144, 112,  84},     {146, 110,  88},
    {149, 109,  92},     {151, 108,  96},     {154, 106, 100},     {156, 105, 105},
    {159, 103, 109},     {161, 102, 113},     {164, 101, 117},     {166,  99, 121},
    {169,  98, 125},     {171,  96, 129},     {173,  95, 133},     {176,  94, 137},
    {178,  92, 142},     {181,  91, 146},     {183,  90, 150},     {186,  88, 154},
    {188,  87, 158},     {191,  85, 162},     {193,  84, 166},     {196,  83, 170},
    {124, 123,  39},     {127, 122,  44},     {129, 120,  48},     {132, 119,  52},
    {134, 117,  56},     {136, 116,  60},     {139, 115,  64},     {141, 113,  68},
    {144, 112,  72},     {146, 110,  76},     {149, 109,  81},     {151, 108,  85},
    {154, 106,  89},     {156, 105,  93},     {159, 103,  97},     {161, 102, 101},
    {164, 101, 105},     {166,  99, 109},     {168,  98, 113},     {171,  97, 118},
    {173,  95, 122},     {176,  94, 126},     {178,  92, 130},     {181,  91, 134},
    {183,  90, 138},     {186,  88, 142},     {188,  87, 146},     {191,  85, 150},
    {193,  84, 155},     {196,  83, 159},     {198,  81, 163},     {200,  80, 167},
    {129, 120,  36},     {131, 119,  40},     {134, 117,  44},     {136, 116,  48},
    {139, 115,  52},     {141, 113,  57},     {144, 112,  61},     {146, 111,  65},
    {149, 109,  69},     {151, 108,  73},     {154, 106,  77},     {156, 105,  81},
    {159, 104,  85},     {161, 102,  89},     {163, 101,  94},     {166,  99,  98},
    {168,  98, 102},     {171,  97, 106},     {173,  95, 110},     {176,  94, 114},
    {178,  92, 118},     {181,  91, 122},     {183,  90, 126},     {186,  88, 131},
    {188,  87, 135},     {191,  85, 139},     {193,  84, 143},     {195,  83, 147},
    {198,  81, 151},     {200,  80, 155},     {203,  79, 159},     {205,  77, 163},
    {134, 118,  33},     {136, 116,  37},     {139, 115,  41},     {141, 113,  45},
    {144, 112,  49},     {146, 111,  53},     {149, 109,  57},     {151, 108,  61},
    {154, 106,  65},     {156, 105,  70},     {158, 104,  74},     {161, 102,  78},
    {163, 101,  82},     {166,  99,  86},     {168,  98,  90},     {171,  97,  94},
    {173,  95,  98},     {176,  94, 102},     {178,  92, 107},     {181,  91, 111},
    {183,  90, 115},     {185,  88, 119},     {188,  87, 123},     {190,  86, 127},
    {193,  84, 131},     {195,  83, 135},     {198,  81, 139},     {200,  80, 144},
    {203,  79, 148},     {205,  77, 152},     {208,  76, 156},     {210,  74, 160},
    {139, 115,  29},     {141, 113,  33},     {144, 112,  37},     {146, 111,  41},
    {149, 109,  46},     {151, 108,  50},     {153, 106,  54},     {156, 105,  58},
    {158, 104,  62},     {161, 102,  66},     {163, 101,  70},     {166,  99,  74},
    {168,  98,  78},     {171,  97,  83},     {173,  95,  87},     {176,  94,  91},
    {178,  93,  95},     {180,  91,  99},     {183,  90, 103},     {185,  88, 107},
    {188,  87, 111},     {190,  86, 115},     {193,  84, 120},     {195,  83, 124},
    {198,  81, 128},     {200,  80, 132},     {203,  79, 136},     {205,  77, 140},
    {208,  76, 144},     {210,  74, 148},     {212,  73, 152},     {215,  72, 157},
    {143, 112,  26},     {146, 111,  30},     {148, 109,  34},     {151, 108,  38},
    {153, 107,  42},     {156, 105,  46},     {158, 104,  50},     {161, 102,  54},
    {163, 101,  59},     {166, 100,  63},     {168,  98,  67},     {171,  97,  71},
    {173,  95,  75},     {175,  94,  79},     {178,  93,  83},     {180,  91,  87},
    {183,  90,  91},     {185,  88,  96},     {188,  87, 100},     {190,  86, 104},
    {193,  84, 108},     {195,  83, 112},     {198,  81, 116},     {200,  80, 120},
    {203,  79, 124},     {205,  77, 128},     {207,  76, 133},     {210,  75, 137},
    {212,  73, 141},     {215,  72, 145},     {217,  70, 149},     {220,  69, 153},
    {148, 109,  22},     {151, 108,  26},     {153, 107,  30},     {156, 105,  35},
    {158, 104,  39},     {161, 102,  43},     {163, 101,  47},     {166, 100,  51},
    {168,  98,  55},     {170,  97,  59},     {173,  95,  63},     {175,  94,  67},
    {178,  93,  72},     {180,  91,  76},     {183,  90,  80},     {185,  88,  84},
    {188,  87,  88},     {190,  86,  92},     {193,  84,  96},     {195,  83, 100},
    {198,  82, 104},     {200,  80, 109},     {202,  79, 113},     {205,  77, 117},
    {207,  76, 121},     {210,  75, 125},     {212,  73, 129},     {215,  72, 133},
    {217,  70, 137},     {220,  69, 141},     {222,  68, 146},     {225,  66, 150},
    {153, 107,  19},     {156, 105,  23},     {158, 104,  27},     {161, 102,  31},
    {163, 101,  35},     {165, 100,  39},     {168,  98,  43},     {170,  97,  48},
    {173,  95,  52},     {175,  94,  56},     {178,  93,  60},     {180,  91,  64},
    {183,  90,  68},     {185,  89,  72},     {188,  87,  76},     {190,  86,  80},
    {193,  84,  85},     {195,  83,  89},     {197,  82,  93},     {200,  80,  97},
    {202,  79, 101},     {205,  77, 105},     {207,  76, 109},     {210,  75, 113},
    {212,  73, 117},     {215,  72, 122},     {217,  70, 126},     {220,  69, 130},
    {222,  68, 134},     {224,  66, 138},     {227,  65, 142},     {229,  64, 146},
    {158, 104,  15},     {160, 103,  19},     {163, 101,  23},     {165, 100,  28},
    {168,  98,  32},     {170,  97,  36},     {173,  96,  40},     {175,  94,  44},
    {178,  93,  48},     {180,  91,  52},     {183,  90,  56},     {185,  89,  61},
    {187,  87,  65},     {190,  86,  69},     {192,  84,  73},     {195,  83,  77},
    {197,  82,  81},     {200,  80,  85},     {202,  79,  89},     {205,  77,  93},
    {207,  76,  98},     {210,  75, 102},     {212,  73, 106},     {215,  72, 110},
    {217,  71, 114},     {219,  69, 118},     {222,  68, 122},     {224,  66, 126},
    {227,  65, 130},     {229,  64, 135},     {232,  62, 139},     {234,  61, 143},
    {163, 101,  12},     {165, 100,  16},     {168,  98,  20},     {170,  97,  24},
    {173,  96,  28},     {175,  94,  32},     {178,  93,  37},     {180,  91,  41},
    {182,  90,  45},     {185,  89,  49},     {187,  87,  53},     {190,  86,  57},
    {192,  84,  61},     {195,  83,  65},     {197,  82,  69},     {200,  80,  74},
    {202,  79,  78},     {205,  78,  82},     {207,  76,  86},     {210,  75,  90},
    {212,  73,  94},     {214,  72,  98},     {217,  71, 102},     {219,  69, 106},
    {222,  68, 111},     {224,  66, 115},     {227,  65, 119},     {229,  64, 123},
    {232,  62, 127},     {234,  61, 131},     {237,  59, 135},     {239,  58, 139},
    { 14, 190, 118},     { 17, 188, 122},     { 19, 187, 126},     { 21, 186, 130},
    { 24, 184, 134},     { 26, 183, 139},     { 29, 181, 143},     { 31, 180, 147},
    { 34, 179, 151},     { 36, 177, 155},     { 39, 176, 159},     { 41, 174, 163},
    { 44, 173, 167},     { 46, 172, 171},     { 48, 170, 176},     { 51, 169, 180},
    { 53, 167, 184},     { 56, 166, 188},     { 58, 165, 192},     { 61, 163, 196},
    { 63, 162, 200},     { 66, 161, 204},     { 68, 159, 208},     { 71, 158, 213},
    { 73, 156, 217},     { 76, 155, 221},     { 78, 154, 225},     { 80, 152, 229},
    { 83, 151, 233},     { 85, 149, 237},     { 88, 148, 241},     { 90, 147, 246},
    { 19, 187, 115},     { 21, 186, 119},     { 24, 184, 123},     { 26, 183, 127},
    { 29, 181, 131},     { 31, 180, 135},     { 34, 179, 139},     { 36, 177, 143},
    { 39, 176, 147},     { 41, 174, 152},     { 43, 173, 156},     { 46, 172, 160},
    { 48, 170, 164},     { 51, 169, 168},     { 53, 168, 172},     { 56, 166, 176},
    { 58, 165, 180},     { 61, 163, 184},     { 63, 162, 189},     { 66, 161, 193},
    { 68, 159, 197},     { 71, 158, 201},     { 73, 156, 205},     { 75, 155, 209},
    { 78, 154, 213},     { 80, 152, 217},     { 83, 151, 221},     { 85, 149, 226},
    { 88, 148, 230},     { 90, 147, 234},     { 93, 145, 238},     { 95, 144, 242},
    { 24, 184, 111},     { 26, 183, 115},     { 29, 181, 119},     { 31, 180, 123},
    { 34, 179, 128},     { 36, 177, 132},     { 38, 176, 136},     { 41, 175, 140},
    { 43, 173, 144},     { 46, 172, 148},     { 48, 170, 152},     { 51, 169, 156},
    { 53, 168, 160},     { 56, 166, 165},     { 58, 165, 169},     { 61, 163, 173},
    { 63, 162, 177},     { 66, 161, 181},     { 68, 159, 185},     { 70, 158, 189},
    { 73, 156, 193},     { 75, 155, 197},     { 78, 154, 202},     { 80, 152, 206},
    { 83, 151, 210},     { 85, 149, 214},     { 88, 148, 218},     { 90, 147, 222},
    { 93, 145, 226},     { 95, 144, 230},     { 98, 143, 234},     {100, 141, 239},
    { 29, 182, 108},     { 31, 180, 112},     { 33, 179, 116},     { 36, 177, 120},
    { 38, 176, 124},     { 41, 175, 128},     { 43, 173, 132},     { 46, 172, 136},
    { 48, 170, 141},     { 51, 169, 145},     { 53, 168, 149},     { 56, 166, 153},
    { 58, 165, 157},     { 61, 163, 161},     { 63, 162, 165},     { 65, 161, 169},
    { 68, 159, 173},     { 70, 158, 178},     { 73, 157, 182},     { 75, 155, 186},
    { 78, 154, 190},     { 80, 152, 194},     { 83, 151, 198},     { 85, 150, 202},
    { 88, 148, 206},     { 90, 147, 210},     { 92, 145, 215},     { 95, 144, 219},
    { 97, 143, 223},     {100, 141, 227},     {102, 140, 231},     {105, 138, 235},
    { 33, 179, 104},     { 36, 177, 108},     { 38, 176, 112},     { 41, 175, 117},
    { 43, 173, 121},     { 46, 172, 125},     { 48, 170, 129},     { 51, 169, 133},
    { 53, 168, 137},     { 56, 166, 141},     { 58, 165, 145},     { 60, 164, 149},
    { 63, 162, 154},     { 65, 161, 158},     { 68, 159, 162},     { 70, 158, 166},
    { 73, 157, 170},     { 75, 155, 174},     { 78, 154, 178},     { 80, 152, 182},
    { 83, 151, 186},     { 85, 150, 191},     { 87, 148, 195},     { 90, 147, 199},
    { 92, 145, 203},     { 95, 144, 207},     { 97, 143, 211},     {100, 141, 215},
    {102, 140, 219},     {105, 138, 223},     {107, 137, 228},     {110, 136, 232},
    { 38, 176, 101},     { 41, 175, 105},     { 43, 173, 109},     { 46, 172, 113},
    { 48, 171, 117},     { 51, 169, 121},     { 53, 168, 125},     { 55, 166, 130},
    { 58, 165, 134},     { 60, 164, 138},     { 63, 162, 142},     { 65, 161, 146},
    { 68, 159, 150},     { 70, 158, 154},     { 73, 157, 158},     { 75, 155, 162},
    { 78, 154, 167},     { 80, 152, 171},     { 82, 151, 175},     { 85, 150, 179},
    { 87, 148, 183},     { 90, 147, 187},     { 92, 145, 191},     { 95, 144, 195},
    { 97, 143, 199},     {100, 141, 204},     {102, 140, 208},     {105, 139, 212},
    {107, 137, 216},     {110, 136, 220},     {112, 134, 224},     {114, 133, 228},
    { 43, 173,  97},     { 45, 172, 101},     { 48, 171, 106},     { 50, 169, 110},
    { 53, 168, 114},     { 55, 166, 118},     { 58, 165, 122},     { 60, 164, 126},
    { 63, 162, 130},     { 65, 161, 134},     { 68, 159, 138},     { 70, 158, 143},
    { 73, 157, 147},     { 75, 155, 151},     { 77, 154, 155},     { 80, 153, 159},
    { 82, 151, 163},     { 85, 150, 167},     { 87, 148, 171},     { 90, 147, 175},
    { 92, 146, 180},     { 95, 144, 184},     { 97, 143, 188},     {100, 141, 192},
    {102, 140, 196},     {105, 139, 200},     {107, 137, 204},     {109, 136, 208},
    {112, 134, 212},     {114, 133, 217},     {117, 132, 221},     {119, 130, 225},
    { 48, 171,  94},     { 50, 169,  98},     { 53, 168, 102},     { 55, 166, 106},
    { 58, 165, 110},     { 60, 164, 114},     { 63, 162, 119},     { 65, 161, 123},
    { 68, 160, 127},     { 70, 158, 131},     { 72, 157, 135},     { 75, 155, 139},
    { 77, 154, 143},     { 80, 153, 147},     { 82, 151, 151},     { 85, 150, 156},
    { 87, 148, 160},     { 90, 147, 164},     { 92, 146, 168},     { 95, 144, 172},
    { 97, 143, 176},     {100, 141, 180},     {102, 140, 184},     {104, 139, 188},
    {107, 137, 193},     {109, 136, 197},     {112, 134, 201},     {114, 133, 205},
    {117, 132, 209},     {119, 130, 213},     {122, 129, 217},     {124, 128, 221},
    { 53, 168,  90},     { 55, 167,  95},     { 58, 165,  99},     { 60, 164, 103},
    { 63, 162, 107},     { 65, 161, 111},     { 67, 160, 115},     { 70, 158, 119},
    { 72, 157, 123},     { 75, 155, 127},     { 77, 154, 132},     { 80, 153, 136},
    { 82, 151, 140},     { 85, 150, 144},     { 87, 148, 148},     { 90, 147, 152},
    { 92, 146, 156},     { 95, 144, 160},     { 97, 143, 164},     { 99, 141, 169},
    {102, 140, 173},     {104, 139, 177},     {107, 137, 181},     {109, 136, 185},
    {112, 135, 189},     {114, 133, 193},     {117, 132, 197},     {119, 130, 201},
    {122, 129, 206},     {124, 128, 210},     {126, 126, 214},     {129, 125, 218},
    { 58, 165,  87},     { 60, 164,  91},     { 62, 162,  95},     { 65, 161,  99},
    { 67, 160, 103},     { 70, 158, 108},     { 72, 157, 112},     { 75, 155, 116},
    { 77, 154, 120},     { 80, 153, 124},     { 82, 151, 128},     { 85, 150, 132},
    { 87, 149, 136},     { 89, 147, 140},     { 92, 146, 145},     { 94, 144, 149},
    { 97, 143, 153},     { 99, 142, 157},     {102, 140, 161},     {104, 139, 165},
    {107, 137, 169},     {109, 136, 173},     {112, 135, 177},     {114, 133, 182},
    {117, 132, 186},     {119, 130, 190},     {121, 129, 194},     {124, 128, 198},
    {126, 126, 202},     {129, 125, 206},     {131, 123, 210},     {134, 122, 214},
    { 62, 162,  84},     { 65, 161,  88},     { 67, 160,  92},     { 70, 158,  96},
    { 72, 157, 100},     { 75, 156, 104},     { 77, 154, 108},     { 80, 153, 112},
    { 82, 151, 116},     { 84, 150, 121},     { 87, 149, 125},     { 89, 147, 129},
    { 92, 146, 133},     { 94, 144, 137},     { 97, 143, 141},     { 99, 142, 145},
    {102, 140, 149},     {104, 139, 153},     {107, 137, 158},     {109, 136, 162},
    {112, 135, 166},     {114, 133, 170},     {116, 132, 174},     {119, 130, 178},
    {121, 129, 182},     {124, 128, 186},     {126, 126, 190},     {129, 125, 195},
    {131, 124, 199},     {134, 122, 203},     {136, 121, 207},     {139, 119, 211},
    { 67, 160,  80},     { 70, 158,  84},     { 72, 157,  88},     { 75, 156,  92},
    { 77, 154,  97},     { 79, 153, 101},     { 82, 151, 105},     { 84, 150, 109},
    { 87, 149, 113},     { 89, 147, 117},     { 92, 146, 121},     { 94, 144, 125},
    { 97, 143, 129},     { 99, 142, 134},     {102, 140, 138},     {104, 139, 142},
    {107, 138, 146},     {109, 136, 150},     {111, 135, 154},     {114, 133, 158},
    {116, 132, 162},     {119, 131, 166},     {121, 129, 171},     {124, 128, 175},
    {126, 126, 179},     {129, 125, 183},     {131, 124, 187},     {134, 122, 191},
    {136, 121, 195},     {139, 119, 199},     {141, 118, 203},     {143, 117, 208},
    { 72, 157,  77},     { 74, 156,  81},     { 77, 154,  85},     { 79, 153,  89},
    { 82, 151,  93},     { 84, 150,  97},     { 87, 149, 101},     { 89, 147, 105},
    { 92, 146, 110},     { 94, 145, 114},     { 97, 143, 118},     { 99, 142, 122},
    {102, 140, 126},     {104, 139, 130},     {106, 138, 134},     {109, 136, 138},
    {111, 135, 142},     {114, 133, 147},     {116, 132, 151},     {119, 131, 155},
    {121, 129, 159},     {124, 128, 163},     {126, 126, 167},     {129, 125, 171},
    {131, 124, 175},     {133, 122, 179},     {136, 121, 184},     {138, 119, 188},
    {141, 118, 192},     {143, 117, 196},     {146, 115, 200},     {148, 114, 204},
    { 77, 154,  73},     { 79, 153,  77},     { 82, 152,  81},     { 84, 150,  86},
    { 87, 149,  90},     { 89, 147,  94},     { 92, 146,  98},     { 94, 145, 102},
    { 97, 143, 106},     { 99, 142, 110},     {101, 140, 114},     {104, 139, 118},
    {106, 138, 123},     {109, 136, 127},     {111, 135, 131},     {114, 133, 135},
    {116, 132, 139},     {119, 131, 143},     {121, 129, 147},     {124, 128, 151},
    {126, 126, 155},     {128, 125, 160},     {131, 124, 164},     {133, 122, 168},
    {136, 121, 172},     {138, 120, 176},     {141, 118, 180},     {143, 117, 184},
    {146, 115, 188},     {148, 114, 192},     {151, 113, 197},     {153, 111, 201},
    { 82, 152,  70},     { 84, 150,  74},     { 87, 149,  78},     { 89, 147,  82},
    { 92, 146,  86},     { 94, 145,  90},     { 96, 143,  94},     { 99, 142,  99},
    {101, 140, 103},     {104, 139, 107},     {106, 138, 111},     {109, 136, 115},
    {111, 135, 119},     {114, 134, 123},     {116, 132, 127},     {119, 131, 131},
    {121, 129, 136},     {123, 128, 140},     {126, 127, 144},     {128, 125, 148},
    {131, 124, 152},     {133, 122, 156},     {136, 121, 160},     {138, 120, 164},
    {141, 118, 168},     {143, 117, 173},     {146, 115, 177},     {148, 114, 181},
    {151, 113, 185},     {153, 111, 189},     {155, 110, 193},     {158, 108, 197},
    { 86, 149,  66},     { 89, 147,  70},     { 91, 146,  75},     { 94, 145,  79},
    { 96, 143,  83},     { 99, 142,  87},     {101, 141,  91},     {104, 139,  95},
    {106, 138,  99},     {109, 136, 103},     {111, 135, 107},     {114, 134, 112},
    {116, 132, 116},     {118, 131, 120},     {121, 129, 124},     {123, 128, 128},
    {126, 127, 132},     {128, 125, 136},     {131, 124, 140},     {133, 122, 144},
    {136, 121, 149},     {138, 120, 153},     {141, 118, 157},     {143, 117, 161},
    {146, 115, 165},     {148, 114, 169},     {150, 113, 173},     {153, 111, 177},
    {155, 110, 181},     {158, 109, 186},     {160, 107, 190},     {163, 106, 194},
    { 91, 146,  63},     { 94, 145,  67},     { 96, 143,  71},     { 99, 142,  75},
    {101, 141,  79},     {104, 139,  83},     {106, 138,  88},     {109, 136,  92},
    {111, 135,  96},     {113, 134, 100},     {116, 132, 104},     {118, 131, 108},
    {121, 129, 112},     {123, 128, 116},     {126, 127, 120},     {128, 125, 125},
    {131, 124, 129},     {133, 122, 133},     {136, 121, 137},     {138, 120, 141},
    {141, 118, 145},     {143, 117, 149},     {145, 116, 153},     {148, 114, 157},
    {150, 113, 162},     {153, 111, 166},     {155, 110, 170},     {158, 109, 174},
    {160, 107, 178},     {163, 106, 182},     {165, 104, 186},     {168, 103, 190},
    { 96, 143,  59},     { 99, 142,  64},     {101, 141,  68},     {104, 139,  72},
    {106, 138,  76},     {108, 136,  80},     {111, 135,  84},     {113, 134,  88},
    {116, 132,  92},     {118, 131,  96},     {121, 130, 101},     {123, 128, 105},
    {126, 127, 109},     {128, 125, 113},     {131, 124, 117},     {133, 123, 121},
    {136, 121, 125},     {138, 120, 129},     {140, 118, 133},     {143, 117, 138},
    {145, 116, 142},     {148, 114, 146},     {150, 113, 150},     {153, 111, 154},
    {155, 110, 158},     {158, 109, 162},     {160, 107, 166},     {163, 106, 170},
    {165, 104, 175},     {167, 103, 179},     {170, 102, 183},     {172, 100, 187},
    {101, 141,  56},     {103, 139,  60},     {106, 138,  64},     {108, 137,  68},
    {111, 135,  72},     {113, 134,  77},     {116, 132,  81},     {118, 131,  85},
    {121, 130,  89},     {123, 128,  93},     {126, 127,  97},     {128, 125, 101},
    {130, 124, 105},     {133, 123, 109},     {135, 121, 114},     {138, 120, 118},
    {140, 118, 122},     {143, 117, 126},     {145, 116, 130},     {148, 114, 134},
    {150, 113, 138},     {153, 111, 142},     {155, 110, 146},     {158, 109, 151},
    {160, 107, 155},     {162, 106, 159},     {165, 105, 163},     {167, 103, 167},
    {170, 102, 171},     {172, 100, 175},     {175,  99, 179},     {177,  98, 183},
    {106, 138,  53},     {108, 137,  57},     {111, 135,  61},     {113, 134,  65},
    {116, 132,  69},     {118, 131,  73},     {121, 130,  77},     {123, 128,  81},
    {125, 127,  85},     {128, 125,  90},     {130, 124,  94},     {133, 123,  98},
    {135, 121, 102},     {138, 120, 106},     {140, 118, 110},     {143, 117, 114},
    {145, 116, 118},     {148, 114, 122},     {150, 113, 127},     {153, 112, 131},
    {155, 110, 135},     {157, 109, 139},     {160, 107, 143},     {162, 106, 147},
    {165, 105, 151},     {167, 103, 155},     {170, 102, 159},     {172, 100, 164},
    {175,  99, 168},     {177,  98, 172},     {180,  96, 176},     {182,  95, 180},
    {111, 135,  49},     {113, 134,  53},     {116, 132,  57},     {118, 131,  61},
    {120, 130,  66},     {123, 128,  70},     {125, 127,  74},     {128, 126,  78},
    {130, 124,  82},     {133, 123,  86},     {135, 121,  90},     {138, 120,  94},
    {140, 119,  98},     {143, 117, 103},     {145, 116, 107},     {148, 114, 111},
    {150, 113, 115},     {152, 112, 119},     {155, 110, 123},     {157, 109, 127},
    {160, 107, 131},     {162, 106, 135},     {165, 105, 140},     {167, 103, 144},
    {170, 102, 148},     {172, 100, 152},     {175,  99, 156},     {177,  98, 160},
    {180,  96, 164},     {182,  95, 168},     {184,  94, 172},     {187,  92, 177},
    {115, 133,  46},     {118, 131,  50},     {120, 130,  54},     {123, 128,  58},
    {125, 127,  62},     {128, 126,  66},     {130, 124,  70},     {133, 123,  74},
    {135, 121,  79},     {138, 120,  83},     {140, 119,  87},     {143, 117,  91},
    {145, 116,  95},     {147, 114,  99},     {150, 113, 103},     {152, 112, 107},
    {155, 110, 111},     {157, 109, 116},     {160, 107, 120},     {162, 106, 124},
    {165, 105, 128},     {167, 103, 132},     {170, 102, 136},     {172, 101, 140},
    {174,  99, 144},     {177,  98, 148},     {179,  96, 153},     {182,  95, 157},
    {184,  94, 161},     {187,  92, 165},     {189,  91, 169},     {192,  89, 173},
    {120, 130,  42},     {123, 128,  46},     {125, 127,  50},     {128, 126,  55},
    {130, 124,  59},     {133, 123,  63},     {135, 121,  67},     {138, 120,  71},
    {140, 119,  75},     {142, 117,  79},     {145, 116,  83},     {147, 115,  87},
    {150, 113,  92},     {152, 112,  96},     {155, 110, 100},     {157, 109, 104},
    {160, 108, 108},     {162, 106, 112},     {165, 105, 116},     {167, 103, 120},
    {169, 102, 124},     {172, 101, 129},     {174,  99, 133},     {177,  98, 137},
    {179,  96, 141},     {182,  95, 145},     {184,  94, 149},     {187,  92, 153},
    {189,  91, 157},     {192,  89, 161},     {194,  88, 166},     {197,  87, 170},
    {125, 127,  39},     {128, 126,  43},     {130, 124,  47},     {133, 123,  51},
    {135, 122,  55},     {137, 120,  59},     {140, 119,  63},     {142, 117,  68},
    {145, 116,  72},     {147, 115,  76},     {150, 113,  80},     {152, 112,  84},
    {155, 110,  88},     {157, 109,  92},     {160, 108,  96},     {162, 106, 100},
    {164, 105, 105},     {167, 103, 109},     {169, 102, 113},     {172, 101, 117},
    {174,  99, 121},     {177,  98, 125},     {179,  96, 129},     {182,  95, 133},
    {184,  94, 137},     {187,  92, 142},     {189,  91, 146},     {192,  90, 150},
    {194,  88, 154},     {196,  87, 158},     {199,  85, 162},     {201,  84, 166},
    {130, 124,  35},     {132, 123,  39},     {135, 122,  44},     {137, 120,  48},
    {140, 119,  52},     {142, 117,  56},     {145, 116,  60},     {147, 115,  64},
    {150, 113,  68},     {152, 112,  72},     {155, 110,  76},     {157, 109,  81},
    {159, 108,  85},     {162, 106,  89},     {164, 105,  93},     {167, 103,  97},
    {169, 102, 101},     {172, 101, 105},     {174,  99, 109},     {177,  98, 113},
    {179,  97, 118},     {182,  95, 122},     {184,  94, 126},     {187,  92, 130},
    {189,  91, 134},     {191,  90, 138},     {194,  88, 142},     {196,  87, 146},
    {199,  85, 150},     {201,  84, 155},     {204,  83, 159},     {206,  81, 163},
    {135, 122,  32},     {137, 120,  36},     {140, 119,  40},     {142, 117,  44},
    {145, 116,  48},     {147, 115,  52},     {150, 113,  57},     {152, 112,  61},
    {154, 111,  65},     {157, 109,  69},     {159, 108,  73},     {162, 106,  77},
    {164, 105,  81},     {167, 104,  85},     {169, 102,  89},     {172, 101,  94},
    {174,  99,  98},     {177,  98, 102},     {179,  97, 106},     {182,  95, 110},
    {184,  94, 114},     {186,  92, 118},     {189,  91, 122},     {191,  90, 126},
    {194,  88, 131},     {196,  87, 135},     {199,  85, 139},     {201,  84, 143},
    {204,  83, 147},     {206,  81, 151},     {209,  80, 155},     {211,  79, 159},
    {140, 119,  28},     {142, 118,  33},     {145, 116,  37},     {147, 115,  41},
    {149, 113,  45},     {152, 112,  49},     {154, 111,  53},     {157, 109,  57},
    {159, 108,  61},     {162, 106,  65},     {164, 105,  70},     {167, 104,  74},
    {169, 102,  78},     {172, 101,  82},     {174,  99,  86},     {177,  98,  90},
    {179,  97,  94},     {181,  95,  98},     {184,  94, 102},     {186,  92, 107},
    {189,  91, 111},     {191,  90, 115},     {194,  88, 119},     {196,  87, 123},
    {199,  86, 127},     {201,  84, 131},     {204,  83, 135},     {206,  81, 139},
    {208,  80, 144},     {211,  79, 148},     {213,  77, 152},     {216,  76, 156},
    {144, 116,  25},     {147, 115,  29},     {149, 113,  33},     {152, 112,  37},
    {154, 111,  41},     {157, 109,  46},     {159, 108,  50},     {162, 106,  54},
    {164, 105,  58},     {167, 104,  62},     {169, 102,  66},     {171, 101,  70},
    {174,  99,  74},     {176,  98,  78},     {179,  97,  83},     {181,  95,  87},
    {184,  94,  91},     {186,  93,  95},     {189,  91,  99},     {191,  90, 103},
    {194,  88, 107},     {196,  87, 111},     {199,  86, 115},     {201,  84, 120},
    {203,  83, 124},     {206,  81, 128},     {208,  80, 132},     {211,  79, 136},
    {213,  77, 140},     {216,  76, 144},     {218,  74, 148},     {221,  73, 152},
    {149, 113,  22},     {152, 112,  26},     {154, 111,  30},     {157, 109,  34},
    {159, 108,  38},     {162, 107,  42},     {164, 105,  46},     {166, 104,  50},
    {169, 102,  54},     {171, 101,  59},     {174, 100,  63},     {176,  98,  67},
    {179,  97,  71},     {181,  95,  75},     {184,  94,  79},     {186,  93,  83},
    {189,  91,  87},     {191,  90,  91},     {194,  88,  96},     {196,  87, 100},
    {198,  86, 104},     {201,  84, 108},     {203,  83, 112},     {206,  81, 116},
    {208,  80, 120},     {211,  79, 124},     {213,  77, 128},     {216,  76, 133},
    {218,  75, 137},     {221,  73, 141},     {223,  72, 145},     {226,  70, 149},
    {154, 111,  18},     {157, 109,  22},     {159, 108,  26},     {161, 107,  30},
    {164, 105,  35},     {166, 104,  39},     {169, 102,  43},     {171, 101,  47},
    {174, 100,  51},     {176,  98,  55},     {179,  97,  59},     {181,  95,  63},
    {184,  94,  67},     {186,  93,  72},     {189,  91,  76},     {191,  90,  80},
    {193,  88,  84},     {196,  87,  88},     {198,  86,  92},     {201,  84,  96},
    {203,  83, 100},     {206,  82, 104},     {208,  80, 109},     {211,  79, 113},
    {213,  77, 117},     {216,  76, 121},     {218,  75, 125},     {221,  73, 129},
    {223,  72, 133},     {225,  70, 137},     {228,  69, 141},     {230,  68, 146},
    {159, 108,  15},     {161, 107,  19},     {164, 105,  23},     {166, 104,  27},
    {169, 102,  31},     {171, 101,  35},     {174, 100,  39},     {176,  98,  43},
    {179,  97,  48},     {181,  95,  52},     {184,  94,  56},     {186,  93,  60},
    {188,  91,  64},     {191,  90,  68},     {193,  89,  72},     {196,  87,  76},
    {198,  86,  80},     {201,  84,  85},     {203,  83,  89},     {206,  82,  93},
    {208,  80,  97},     {211,  79, 101},     {213,  77, 105},     {215,  76, 109},
    {218,  75, 113},     {220,  73, 117},     {223,  72, 122},     {225,  70, 126},
    {228,  69, 130},     {230,  68, 134},     {233,  66, 138},     {235,  65, 142},
    {164, 105,  11},     {166, 104,  15},     {169, 103,  19},     {171, 101,  23},
    {174, 100,  28},     {176,  98,  32},     {179,  97,  36},     {181,  96,  40},
    {183,  94,  44},     {186,  93,  48},     {188,  91,  52},     {191,  90,  56},
    {193,  89,  61},     {196,  87,  65},     {198,  86,  69},     {201,  84,  73},
    {203,  83,  77},     {206,  82,  81},     {208,  80,  85},     {210,  79,  89},
    {213,  77,  93},     {215,  76,  98},     {218,  75, 102},     {220,  73, 106},
    {223,  72, 110},     {225,  71, 114},     {228,  69, 118},     {230,  68, 122},
    {233,  66, 126},     {235,  65, 130},     {238,  64, 135},     {240,  62, 139},
    { 15, 194, 117},     { 17, 192, 121},     { 20, 191, 126},     { 22, 190, 130},
    { 25, 188, 134},     { 27, 187, 138},     { 30, 185, 142},     { 32, 184, 146},
    { 35, 183, 150},     { 37, 181, 154},     { 40, 180, 158},     { 42, 179, 163},
    { 45, 177, 167},     { 47, 176, 171},     { 49, 174, 175},     { 52, 173, 179},
    { 54, 172, 183},     { 57, 170, 187},     { 59, 169, 191},     { 62, 167, 195},
    { 64, 166, 200},     { 67, 165, 204},     { 69, 163, 208},     { 72, 162, 212},
    { 74, 160, 216},     { 76, 159, 220},     { 79, 158, 224},     { 81, 156, 228},
    { 84, 155, 233},     { 86, 153, 237},     { 89, 152, 241},     { 91, 151, 245},
    { 20, 191, 114},     { 22, 190, 118},     { 25, 188, 122},     { 27, 187, 126},
    { 30, 186, 130},     { 32, 184, 134},     { 35, 183, 139},     { 37, 181, 143},
    { 40, 180, 147},     { 42, 179, 151},     { 44, 177, 155},     { 47, 176, 159},
    { 49, 174, 163},     { 52, 173, 167},     { 54, 172, 171},     { 57, 170, 176},
    { 59, 169, 180},     { 62, 167, 184},     { 64, 166, 188},     { 67, 165, 192},
    { 69, 163, 196},     { 71, 162, 200},     { 74, 161, 204},     { 76, 159, 208},
    { 79, 158, 213},     { 81, 156, 217},     { 84, 155, 221},     { 86, 154, 225},
    { 89, 152, 229},     { 91, 151, 233},     { 94, 149, 237},     { 96, 148, 241},
    { 25, 188, 110},     { 27, 187, 115},     { 30, 186, 119},     { 32, 184, 123},
    { 34, 183, 127},     { 37, 181, 131},     { 39, 180, 135},     { 42, 179, 139},
    { 44, 177, 143},     { 47, 176, 147},     { 49, 174, 152},     { 52, 173, 156},
    { 54, 172, 160},     { 57, 170, 164},     { 59, 169, 168},     { 62, 168, 172},
    { 64, 166, 176},     { 66, 165, 180},     { 69, 163, 184},     { 71, 162, 189},
    { 74, 161, 193},     { 76, 159, 197},     { 79, 158, 201},     { 81, 156, 205},
    { 84, 155, 209},     { 86, 154, 213},     { 89, 152, 217},     { 91, 151, 221},
    { 94, 149, 226},     { 96, 148, 230},     { 98, 147, 234},     {101, 145, 238},
    { 29, 186, 107},     { 32, 184, 111},     { 34, 183, 115},     { 37, 181, 119},
    { 39, 180, 123},     { 42, 179, 128},     { 44, 177, 132},     { 47, 176, 136},
    { 49, 175, 140},     { 52, 173, 144},     { 54, 172, 148},     { 57, 170, 152},
    { 59, 169, 156},     { 61, 168, 160},     { 64, 166, 165},     { 66, 165, 169},
    { 69, 163, 173},     { 71, 162, 177},     { 74, 161, 181},     { 76, 159, 185},
    { 79, 158, 189},     { 81, 156, 193},     { 84, 155, 197},     { 86, 154, 202},
    { 89, 152, 206},     { 91, 151, 210},     { 93, 149, 214},     { 96, 148, 218},
    { 98, 147, 222},     {101, 145, 226},     {103, 144, 230},     {106, 143, 234},
    { 34, 183, 104},     { 37, 182, 108},     { 39, 180, 112},     { 42, 179, 116},
    { 44, 177, 120},     { 47, 176, 124},     { 49, 175, 128},     { 52, 173, 132},
    { 54, 172, 136},     { 56, 170, 141},     { 59, 169, 145},     { 61, 168, 149},
    { 64, 166, 153},     { 66, 165, 157},     { 69, 163, 161},     { 71, 162, 165},
    { 74, 161, 169},     { 76, 159, 173},     { 79, 158, 178},     { 81, 157, 182},
    { 84, 155, 186},     { 86, 154, 190},     { 88, 152, 194},     { 91, 151, 198},
    { 93, 150, 202},     { 96, 148, 206},     { 98, 147, 210},     {101, 145, 215},
    {103, 144, 219},     {106, 143, 223},     {108, 141, 227},     {111, 140, 231},
    { 39, 180, 100},     { 42, 179, 104},     { 44, 177, 108},     { 47, 176, 112},
    { 49, 175, 117},     { 51, 173, 121},     { 54, 172, 125},     { 56, 170, 129},
    { 59, 169, 133},     { 61, 168, 137},     { 64, 166, 141},     { 66, 165, 145},
    { 69, 164, 149},     { 71, 162, 154},     { 74, 161, 158},     { 76, 159, 162},
    { 78, 158, 166},     { 81, 157, 170},     { 83, 155, 174},     { 86, 154, 178},
    { 88, 152, 182},     { 91, 151, 186},     { 93, 150, 191},     { 96, 148, 195},
    { 98, 147, 199},     {101, 145, 203},     {103, 144, 207},     {106, 143, 211},
    {108, 141, 215},     {110, 140, 219},     {113, 138, 223},     {115, 137, 228},
    { 44, 177,  97},     { 46, 176, 101},     { 49, 175, 105},     { 51, 173, 109},
    { 54, 172, 113},     { 56, 171, 117},     { 59, 169, 121},     { 61, 168, 125},
    { 64, 166, 130},     { 66, 165, 134},     { 69, 164, 138},     { 71, 162, 142},
    { 73, 161, 146},     { 76, 159, 150},     { 78, 158, 154},     { 81, 157, 158},
    { 83, 155, 162},     { 86, 154, 167},     { 88, 152, 171},     { 91, 151, 175},
    { 93, 150, 179},     { 96, 148, 183},     { 98, 147, 187},     {101, 145, 191},
    {103, 144, 195},     {105, 143, 199},     {108, 141, 204},     {110, 140, 208},
    {113, 139, 212},     {115, 137, 216},     {118, 136, 220},     {120, 134, 224},
    { 49, 175,  93},     { 51, 173,  97},     { 54, 172, 101},     { 56, 171, 106},
    { 59, 169, 110},     { 61, 168, 114},     { 64, 166, 118},     { 66, 165, 122},
    { 68, 164, 126},     { 71, 162, 130},     { 73, 161, 134},     { 76, 159, 138},
    { 78, 158, 143},     { 81, 157, 147},     { 83, 155, 151},     { 86, 154, 155},
    { 88, 153, 159},     { 91, 151, 163},     { 93, 150, 167},     { 96, 148, 171},
    { 98, 147, 175},     {100, 146, 180},     {103, 144, 184},     {105, 143, 188},
    {108, 141, 192},     {110, 140, 196},     {113, 139, 200},     {115, 137, 204},
    {118, 136, 208},     {120, 134, 212},     {123, 133, 217},     {125, 132, 221},
    { 54, 172,  90},     { 56, 171,  94},     { 59, 169,  98},     { 61, 168, 102},
    { 63, 166, 106},     { 66, 165, 110},     { 68, 164, 114},     { 71, 162, 119},
    { 73, 161, 123},     { 76, 160, 127},     { 78, 158, 131},     { 81, 157, 135},
    { 83, 155, 139},     { 86, 154, 143},     { 88, 153, 147},     { 91, 151, 151},
    { 93, 150, 156},     { 95, 148, 160},     { 98, 147, 164},     {100, 146, 168},
    {103, 144, 172},     {105, 143, 176},     {108, 141, 180},     {110, 140, 184},
    {113, 139, 188},     {115, 137, 193},     {118, 136, 197},     {120, 134, 201},
    {122, 133, 205},     {125, 132, 209},     {127, 130, 213},     {130, 129, 217},
    { 58, 169,  86},     { 61, 168,  90},     { 63, 167,  95},     { 66, 165,  99},
    { 68, 164, 103},     { 71, 162, 107},     { 73, 161, 111},     { 76, 160, 115},
    { 78, 158, 119},     { 81, 157, 123},     { 83, 155, 127},     { 86, 154, 132},
    { 88, 153, 136},     { 90, 151, 140},     { 93, 150, 144},     { 95, 148, 148},
    { 98, 147, 152},     {100, 146, 156},     {103, 144, 160},     {105, 143, 164},
    {108, 141, 169},     {110, 140, 173},     {113, 139, 177},     {115, 137, 181},
    {117, 136, 185},     {120, 135, 189},     {122, 133, 193},     {125, 132, 197},
    {127, 130, 201},     {130, 129, 206},     {132, 128, 210},     {135, 126, 214},
    { 63, 167,  83},     { 66, 165,  87},     { 68, 164,  91},     { 71, 162,  95},
    { 73, 161,  99},     { 76, 160, 103},     { 78, 158, 108},     { 81, 157, 112},
    { 83, 155, 116},     { 85, 154, 120},     { 88, 153, 124},     { 90, 151, 128},
    { 93, 150, 132},     { 95, 149, 136},     { 98, 147, 140},     {100, 146, 145},
    {103, 144, 149},     {105, 143, 153},     {108, 142, 157},     {110, 140, 161},
    {112, 139, 165},     {115, 137, 169},     {117, 136, 173},     {120, 135, 177},
    {122, 133, 182},     {125, 132, 186},     {127, 130, 190},     {130, 129, 194},
    {132, 128, 198},     {135, 126, 202},     {137, 125, 206},     {140, 123, 210},
    { 68, 164,  79},     { 71, 162,  84},     { 73, 161,  88},     { 75, 160,  92},
    { 78, 158,  96},     { 80, 157, 100},     { 83, 156, 104},     { 85, 154, 108},
    { 88, 153, 112},     { 90, 151, 116},     { 93, 150, 121},     { 95, 149, 125},
    { 98, 147, 129},     {100, 146, 133},     {103, 144, 137},     {105, 143, 141},
    {107, 142, 145},     {110, 140, 149},     {112, 139, 153},     {115, 137, 158},
    {117, 136, 162},     {120, 135, 166},     {122, 133, 170},     {125, 132, 174},
    {127, 130, 178},     {130, 129, 182},     {132, 128, 186},     {135, 126, 190},
    {137, 125, 195},     {139, 124, 199},     {142, 122, 203},     {144, 121, 207},
    { 73, 161,  76},     { 75, 160,  80},     { 78, 158,  84},     { 80, 157,  88},
    { 83, 156,  92},     { 85, 154,  97},     { 88, 153, 101},     { 90, 151, 105},
    { 93, 150, 109},     { 95, 149, 113},     { 98, 147, 117},     {100, 146, 121},
    {102, 144, 125},     {105, 143, 129},     {107, 142, 134},     {110, 140, 138},
    {112, 139, 142},     {115, 138, 146},     {117, 136, 150},     {120, 135, 154},
    {122, 133, 158},     {125, 132, 162},     {127, 131, 166},     {130, 129, 171},
    {132, 128, 175},     {134, 126, 179},     {137, 125, 183},     {139, 124, 187},
    {142, 122, 191},     {144, 121, 195},     {147, 119, 199},     {149, 118, 203},
    { 78, 158,  73},     { 80, 157,  77},     { 83, 156,  81},     { 85, 154,  85},
    { 88, 153,  89},     { 90, 151,  93},     { 93, 150,  97},     { 95, 149, 101},
    { 97, 147, 105},     {100, 146, 110},     {102, 145, 114},     {105, 143, 118},
    {107, 142, 122},     {110, 140, 126},     {112, 139, 130},     {115, 138, 134},
    {117, 136, 138},     {120, 135, 142},     {122, 133, 147},     {125, 132, 151},
    {127, 131, 155},     {129, 129, 159},     {132, 128, 163},     {134, 126, 167},
    {137, 125, 171},     {139, 124, 175},     {142, 122, 179},     {144, 121, 184},
    {147, 119, 188},     {149, 118, 192},     {152, 117, 196},     {154, 115, 200},
    { 83, 156,  69},     { 85, 154,  73},     { 88, 153,  77},     { 90, 152,  81},
    { 92, 150,  86},     { 95, 149,  90},     { 97, 147,  94},     {100, 146,  98},
    {102, 145, 102},     {105, 143, 106},     {107, 142, 110},     {110, 140, 114},
    {112, 139, 118},     {115, 138, 123},     {117, 136, 127},     {119, 135, 131},
    {122, 133, 135},     {124, 132, 139},     {127, 131, 143},     {129, 129, 147},
    {132, 128, 151},     {134, 126, 155},     {137, 125, 160},     {139, 124, 164},
    {142, 122, 168},     {144, 121, 172},     {147, 120, 176},     {149, 118, 180},
    {151, 117, 184},     {154, 115, 188},     {156, 114, 192},     {159, 113, 197},
    { 87, 153,  66},     { 90, 152,  70},     { 92, 150,  74},     { 95, 149,  78},
    { 97, 147,  82},     {100, 146,  86},     {102, 145,  90},     {105, 143,  94},
    {107, 142,  99},     {110, 140, 103},     {112, 139, 107},     {114, 138, 111},
    {117, 136, 115},     {119, 135, 119},     {122, 134, 123},     {124, 132, 127},
    {127, 131, 131},     {129, 129, 136},     {132, 128, 140},     {134, 127, 144},
    {137, 125, 148},     {139, 124, 152},     {142, 122, 156},     {144, 121, 160},
    {146, 120, 164},     {149, 118, 168},     {151, 117, 173},     {154, 115, 177},
    {156, 114, 181},     {159, 113, 185},     {161, 111, 189},     {164, 110, 193},
    { 92, 150,  62},     { 95, 149,  66},     { 97, 147,  70},     {100, 146,  75},
    {102, 145,  79},     {105, 143,  83},     {107, 142,  87},     {109, 141,  91},
    {112, 139,  95},     {114, 138,  99},     {117, 136, 103},     {119, 135, 107},
    {122, 134, 112},     {124, 132, 116},     {127, 131, 120},     {129, 129, 124},
    {132, 128, 128},     {134, 127, 132},     {137, 125, 136},     {139, 124, 140},
    {141, 122, 144},     {144, 121, 149},     {146, 120, 153},     {149, 118, 157},
    {151, 117, 161},     {154, 115, 165},     {156, 114, 169},     {159, 113, 173},
    {161, 111, 177},     {164, 110, 181},     {166, 109, 186},     {169, 107, 190},
    { 97, 148,  59},     {100, 146,  63},     {102, 145,  67},     {104, 143,  71},
    {107, 142,  75},     {109, 141,  79},     {112, 139,  83},     {114, 138,  88},
    {117, 136,  92},     {119, 135,  96},     {122, 134, 100},     {124, 132, 104},
    {127, 131, 108},     {129, 129, 112},     {132, 128, 116},     {134, 127, 120},
    {136, 125, 125},     {139, 124, 129},     {141, 122, 133},     {144, 121, 137},
    {146, 120, 141},     {149, 118, 145},     {151, 117, 149},     {154, 116, 153},
    {156, 114, 157},     {159, 113, 162},     {161, 111, 166},     {163, 110, 170},
    {166, 109, 174},     {168, 107, 178},     {171, 106, 182},     {173, 104, 186},
    {102, 145,  55},     {104, 143,  59},     {107, 142,  64},     {109, 141,  68},
    {112, 139,  72},     {114, 138,  76},     {117, 136,  80},     {119, 135,  84},
    {122, 134,  88},     {124, 132,  92},     {127, 131,  96},     {129, 130, 101},
    {131, 128, 105},     {134, 127, 109},     {136, 125, 113},     {139, 124, 117},
    {141, 123, 121},     {144, 121, 125},     {146, 120, 129},     {149, 118, 133},
    {151, 117, 138},     {154, 116, 142},     {156, 114, 146},     {158, 113, 150},
    {161, 111, 154},     {163, 110, 158},     {166, 109, 162},     {168, 107, 166},
    {171, 106, 170},     {173, 104, 175},     {176, 103, 179},     {178, 102, 183},
    {107, 142,  52},     {109, 141,  56},     {112, 139,  60},     {114, 138,  64},
    {117, 137,  68},     {119, 135,  72},     {122, 134,  77},     {124, 132,  81},
    {126, 131,  85},     {129, 130,  89},     {131, 128,  93},     {134, 127,  97},
    {136, 125, 101},     {139, 124, 105},     {141, 123, 109},     {144, 121, 114},
    {146, 120, 118},     {149, 118, 122},     {151, 117, 126},     {153, 116, 130},
    {156, 114, 134},     {158, 113, 138},     {161, 111, 142},     {163, 110, 146},
    {166, 109, 151},     {168, 107, 155},     {171, 106, 159},     {173, 105, 163},
    {176, 103, 167},     {178, 102, 171},     {181, 100, 175},     {183,  99, 179},
    {112, 139,  48},     {114, 138,  53},     {116, 137,  57},     {119, 135,  61},
    {121, 134,  65},     {124, 132,  69},     {126, 131,  73},     {129, 130,  77},
    {131, 128,  81},     {134, 127,  85},     {136, 125,  90},     {139, 124,  94},
    {141, 123,  98},     {144, 121, 102},     {146, 120, 106},     {148, 118, 110},
    {151, 117, 114},     {153, 116, 118},     {156, 114, 122},     {158, 113, 127},
    {161, 112, 131},     {163, 110, 135},     {166, 109, 139},     {168, 107, 143},
    {171, 106, 147},     {173, 105, 151},     {176, 103, 155},     {178, 102, 159},
    {180, 100, 164},     {183,  99, 168},     {185,  98, 172},     {188,  96, 176},
    {116, 137,  45},     {119, 135,  49},     {121, 134,  53},     {124, 132,  57},
    {126, 131,  61},     {129, 130,  66},     {131, 128,  70},     {134, 127,  74},
    {136, 126,  78},     {139, 124,  82},     {141, 123,  86},     {143, 121,  90},
    {146, 120,  94},     {148, 119,  98},     {151, 117, 103},     {153, 116, 107},
    {156, 114, 111},     {158, 113, 115},     {161, 112, 119},     {163, 110, 123},
    {166, 109, 127},     {168, 107, 131},     {171, 106, 135},     {173, 105, 140},
    {175, 103, 144},     {178, 102, 148},     {180, 100, 152},     {183,  99, 156},
    {185,  98, 160},     {188,  96, 164},     {190,  95, 168},     {193,  94, 172},
    {121, 134,  42},     {124, 133,  46},     {126, 131,  50},     {129, 130,  54},
    {131, 128,  58},     {134, 127,  62},     {136, 126,  66},     {138, 124,  70},
    {141, 123,  74},     {143, 121,  79},     {146, 120,  83},     {148, 119,  87},
    {151, 117,  91},     {153, 116,  95},     {156, 114,  99},     {158, 113, 103},
    {161, 112, 107},     {163, 110, 111},     {166, 109, 116},     {168, 107, 120},
    {170, 106, 124},     {173, 105, 128},     {175, 103, 132},     {178, 102, 136},
    {180, 101, 140},     {183,  99, 144},     {185,  98, 148},     {188,  96, 153},
    {190,  95, 157},     {193,  94, 161},     {195,  92, 165},     {197,  91, 169},
    {126, 131,  38},     {129, 130,  42},     {131, 128,  46},     {133, 127,  50},
    {136, 126,  55},     {138, 124,  59},     {141, 123,  63},     {143, 121,  67},
    {146, 120,  71},     {148, 119,  75},     {151, 117,  79},     {153, 116,  83},
    {156, 115,  87},     {158, 113,  92},     {160, 112,  96},     {163, 110, 100},
    {165, 109, 104},     {168, 108, 108},     {170, 106, 112},     {173, 105, 116},
    {175, 103, 120},     {178, 102, 124},     {180, 101, 129},     {183,  99, 133},
    {185,  98, 137},     {188,  96, 141},     {190,  95, 145},     {192,  94, 149},
    {195,  92, 153},     {197,  91, 157},     {200,  89, 161},     {202,  88, 166},
    {131, 128,  35},     {133, 127,  39},     {136, 126,  43},     {138, 124,  47},
    {141, 123,  51},     {143, 122,  55},     {146, 120,  59},     {148, 119,  63},
    {151, 117,  68},     {153, 116,  72},     {155, 115,  76},     {158, 113,  80},
    {160, 112,  84},     {163, 110,  88},     {165, 109,  92},     {168, 108,  96},
    {170, 106, 100},     {173, 105, 105},     {175, 103, 109},     {178, 102, 113},
    {180, 101, 117},     {183,  99, 121},     {185,  98, 125},     {187,  96, 129},
    {190,  95, 133},     {192,  94, 137},     {195,  92, 142},     {197,  91, 146},
    {200,  90, 150},     {202,  88, 154},     {205,  87, 158},     {207,  85, 162},
    {136, 126,  31},     {138, 124,  35},     {141, 123,  39},     {143, 122,  44},
    {146, 120,  48},     {148, 119,  52},     {150, 117,  56},     {153, 116,  60},
    {155, 115,  64},     {158, 113,  68},     {160, 112,  72},     {163, 110,  76},
    {165, 109,  81},     {168, 108,  85},     {170, 106,  89},     {173, 105,  93},
    {175, 103,  97},     {178, 102, 101},     {180, 101, 105},     {182,  99, 109},
    {185,  98, 113},     {187,  97, 118},     {190,  95, 122},     {192,  94, 126},
    {195,  92, 130},     {197,  91, 134},     {200,  90, 138},     {202,  88, 142},
    {205,  87, 146},     {207,  85, 150},     {210,  84, 155},     {212,  83, 159},
    {141, 123,  28},     {143, 122,  32},     {145, 120,  36},     {148, 119,  40},
    {150, 117,  44},     {153, 116,  48},     {155, 115,  52},     {158, 113,  57},
    {160, 112,  61},     {163, 111,  65},     {165, 109,  69},     {168, 108,  73},
    {170, 106,  77},     {173, 105,  81},     {175, 104,  85},     {177, 102,  89},
    {180, 101,  94},     {182,  99,  98},     {185,  98, 102},     {187,  97, 106},
    {190,  95, 110},     {192,  94, 114},     {195,  92, 118},     {197,  91, 122},
    {200,  90, 126},     {202,  88, 131},     {204,  87, 135},     {207,  85, 139},
    {209,  84, 143},     {212,  83, 147},     {214,  81, 151},     {217,  80, 155},
    {145, 120,  24},     {148, 119,  28},     {150, 118,  33},     {153, 116,  37},
    {155, 115,  41},     {158, 113,  45},     {160, 112,  49},     {163, 111,  53},
    {165, 109,  57},     {168, 108,  61},     {170, 106,  65},     {172, 105,  70},
    {175, 104,  74},     {177, 102,  78},     {180, 101,  82},     {182,  99,  86},
    {185,  98,  90},     {187,  97,  94},     {190,  95,  98},     {192,  94, 102},
    {195,  92, 107},     {197,  91, 111},     {199,  90, 115},     {202,  88, 119},
    {204,  87, 123},     {207,  86, 127},     {209,  84, 131},     {212,  83, 135},
    {214,  81, 139},     {217,  80, 144},     {219,  79, 148},     {222,  77, 152},
    {150, 118,  21},     {153, 116,  25},     {155, 115,  29},     {158, 113,  33},
    {160, 112,  37},     {163, 111,  41},     {165, 109,  46},     {167, 108,  50},
    {170, 106,  54},     {172, 105,  58},     {175, 104,  62},     {177, 102,  66},
    {180, 101,  70},     {182,  99,  74},     {185,  98,  78},     {187,  97,  83},
    {190,  95,  87},     {192,  94,  91},     {194,  93,  95},     {197,  91,  99},
    {199,  90, 103},     {202,  88, 107},     {204,  87, 111},     {207,  86, 115},
    {209,  84, 120},     {212,  83, 124},     {214,  81, 128},     {217,  80, 132},
    {219,  79, 136},     {222,  77, 140},     {224,  76, 144},     {226,  74, 148},
    {155, 115,  17},     {157, 113,  22},     {160, 112,  26},     {162, 111,  30},
    {165, 109,  34},     {167, 108,  38},     {170, 107,  42},     {172, 105,  46},
    {175, 104,  50},     {177, 102,  54},     {180, 101,  59},     {182, 100,  63},
    {185,  98,  67},     {187,  97,  71},     {189,  95,  75},     {192,  94,  79},
    {194,  93,  83},     {197,  91,  87},     {199,  90,  91},     {202,  88,  96},
    {204,  87, 100},     {207,  86, 104},     {209,  84, 108},     {212,  83, 112},
    {214,  81, 116},     {217,  80, 120},     {219,  79, 124},     {221,  77, 128},
    {224,  76, 133},     {226,  75, 137},     {229,  73, 141},     {231,  72, 145},
    {160, 112,  14},     {162, 111,  18},     {165, 109,  22},     {167, 108,  26},
    {170, 107,  30},     {172, 105,  35},     {175, 104,  39},     {177, 102,  43},
    {180, 101,  47},     {182, 100,  51},     {184,  98,  55},     {187,  97,  59},
    {189,  95,  63},     {192,  94,  67},     {194,  93,  72},     {197,  91,  76},
    {199,  90,  80},     {202,  88,  84},     {204,  87,  88},     {207,  86,  92},
    {209,  84,  96},     {212,  83, 100},     {214,  82, 104},     {216,  80, 109},
    {219,  79, 113},     {221,  77, 117},     {224,  76, 121},     {226,  75, 125},
    {229,  73, 129},     {231,  72, 133},     {234,  70, 137},     {236,  69, 141},
    {165, 109,  10},     {167, 108,  15},     {170, 107,  19},     {172, 105,  23},
    {175, 104,  27},     {177, 102,  31},     {179, 101,  35},     {182, 100,  39},
    {184,  98,  43},     {187,  97,  48},     {189,  95,  52},     {192,  94,  56},
    {194,  93,  60},     {197,  91,  64},     {199,  90,  68},     {202,  89,  72},
    {204,  87,  76},     {207,  86,  80},     {209,  84,  85},     {211,  83,  89},
    {214,  82,  93},     {216,  80,  97},     {219,  79, 101},     {221,  77, 105},
    {224,  76, 109},     {226,  75, 113},     {229,  73, 117},     {231,  72, 122},
    {234,  70, 126},     {236,  69, 130},     {238,  68, 134},     {241,  66, 138},
    { 16, 198, 117},     { 18, 197, 121},     { 21, 195, 125},     { 23, 194, 129},
    { 26, 192, 133},     { 28, 191, 137},     { 31, 190, 141},     { 33, 188, 145},
    { 36, 187, 150},     { 38, 185, 154},     { 41, 184, 158},     { 43, 183, 162},
    { 45, 181, 166},     { 48, 180, 170},     { 50, 178, 174},     { 53, 177, 178},
    { 55, 176, 182},     { 58, 174, 187},     { 60, 173, 191},     { 63, 172, 195},
    { 65, 170, 199},     { 68, 169, 203},     { 70, 167, 207},     { 73, 166, 211},
    { 75, 165, 215},     { 77, 163, 219},     { 80, 162, 224},     { 82, 160, 228},
    { 85, 159, 232},     { 87, 158, 236},     { 90, 156, 240},     { 92, 155, 244},
    { 21, 195, 113},     { 23, 194, 117},     { 26, 192, 121},     { 28, 191, 126},
    { 31, 190, 130},     { 33, 188, 134},     { 36, 187, 138},     { 38, 185, 142},
    { 40, 184, 146},     { 43, 183, 150},     { 45, 181, 154},     { 48, 180, 158},
    { 50, 179, 163},     { 53, 177, 167},     { 55, 176, 171},     { 58, 174, 175},
    { 60, 173, 179},     { 63, 172, 183},     { 65, 170, 187},     { 68, 169, 191},
    { 70, 167, 195},     { 72, 166, 200},     { 75, 165, 204},     { 77, 163, 208},
    { 80, 162, 212},     { 82, 160, 216},     { 85, 159, 220},     { 87, 158, 224},
    { 90, 156, 228},     { 92, 155, 233},     { 95, 153, 237},     { 97, 152, 241},
    { 26, 192, 110},     { 28, 191, 114},     { 31, 190, 118},     { 33, 188, 122},
    { 35, 187, 126},     { 38, 186, 130},     { 40, 184, 134},     { 43, 183, 139},
    { 45, 181, 143},     { 48, 180, 147},     { 50, 179, 151},     { 53, 177, 155},
    { 55, 176, 159},     { 58, 174, 163},     { 60, 173, 167},     { 62, 172, 171},
    { 65, 170, 176},     { 67, 169, 180},     { 70, 167, 184},     { 72, 166, 188},
    { 75, 165, 192},     { 77, 163, 196},     { 80, 162, 200},     { 82, 161, 204},
    { 85, 159, 208},     { 87, 158, 213},     { 90, 156, 217},     { 92, 155, 221},
    { 94, 154, 225},     { 97, 152, 229},     { 99, 151, 233},     {102, 149, 237},
    { 30, 190, 106},     { 33, 188, 110},     { 35, 187, 115},     { 38, 186, 119},
    { 40, 184, 123},     { 43, 183, 127},     { 45, 181, 131},     { 48, 180, 135},
    { 50, 179, 139},     { 53, 177, 143},     { 55, 176, 147},     { 57, 174, 152},
    { 60, 173, 156},     { 62, 172, 160},     { 65, 170, 164},     { 67, 169, 168},
    { 70, 168, 172},     { 72, 166, 176},     { 75, 165, 180},     { 77, 163, 184},
    { 80, 162, 189},     { 82, 161, 193},     { 85, 159, 197},     { 87, 158, 201},
    { 89, 156, 205},     { 92, 155, 209},     { 94, 154, 213},     { 97, 152, 217},
    { 99, 151, 221},     {102, 149, 226},     {104, 148, 230},     {107, 147, 234},
    { 35, 187, 103},     { 38, 186, 107},     { 40, 184, 111},     { 43, 183, 115},
    { 45, 181, 119},     { 48, 180, 123},     { 50, 179, 128},     { 52, 177, 132},
    { 55, 176, 136},     { 57, 175, 140},     { 60, 173, 144},     { 62, 172, 148},
    { 65, 170, 152},     { 67, 169, 156},     { 70, 168, 160},     { 72, 166, 165},
    { 75, 165, 169},     { 77, 163, 173},     { 80, 162, 177},     { 82, 161, 181},
    { 84, 159, 185},     { 87, 158, 189},     { 89, 156, 193},     { 92, 155, 197},
    { 94, 154, 202},     { 97, 152, 206},     { 99, 151, 210},     {102, 149, 214},
    {104, 148, 218},     {107, 147, 222},     {109, 145, 226},     {112, 144, 230},
    { 40, 184,  99},     { 43, 183, 104},     { 45, 182, 108},     { 47, 180, 112},
    { 50, 179, 116},     { 52, 177, 120},     { 55, 176, 124},     { 57, 175, 128},
    { 60, 173, 132},     { 62, 172, 136},     { 65, 170, 141},     { 67, 169, 145},
    { 70, 168, 149},     { 72, 166, 153},     { 75, 165, 157},     { 77, 163, 161},
    { 79, 162, 165},     { 82, 161, 169},     { 84, 159, 173},     { 87, 158, 178},
    { 89, 157, 182},     { 92, 155, 186},     { 94, 154, 190},     { 97, 152, 194},
    { 99, 151, 198},     {102, 150, 202},     {104, 148, 206},     {106, 147, 210},
    {109, 145, 215},     {111, 144, 219},     {114, 143, 223},     {116, 141, 227},
    { 45, 182,  96},     { 47, 180, 100},     { 50, 179, 104},     { 52, 177, 108},
    { 55, 176, 112},     { 57, 175, 117},     { 60, 173, 121},     { 62, 172, 125},
    { 65, 170, 129},     { 67, 169, 133},     { 70, 168, 137},     { 72, 166, 141},
    { 74, 165, 145},     { 77, 164, 149},     { 79, 162, 154},     { 82, 161, 158},
    { 84, 159, 162},     { 87, 158, 166},     { 89, 157, 170},     { 92, 155, 174},
    { 94, 154, 178},     { 97, 152, 182},     { 99, 151, 186},     {101, 150, 191},
    {104, 148, 195},     {106, 147, 199},     {109, 145, 203},     {111, 144, 207},
    {114, 143, 211},     {116, 141, 215},     {119, 140, 219},     {121, 138, 223},
    { 50, 179,  93},     { 52, 177,  97},     { 55, 176, 101},     { 57, 175, 105},
    { 60, 173, 109},     { 62, 172, 113},     { 64, 171, 117},     { 67, 169, 121},
    { 69, 168, 125},     { 72, 166, 130},     { 74, 165, 134},     { 77, 164, 138},
    { 79, 162, 142},     { 82, 161, 146},     { 84, 159, 150},     { 87, 158, 154},
    { 89, 157, 158},     { 92, 155, 162},     { 94, 154, 167},     { 96, 152, 171},
    { 99, 151, 175},     {101, 150, 179},     {104, 148, 183},     {106, 147, 187},
    {109, 145, 191},     {111, 144, 195},     {114, 143, 199},     {116, 141, 204},
    {119, 140, 208},     {121, 139, 212},     {124, 137, 216},     {126, 136, 220},
    { 55, 176,  89},     { 57, 175,  93},     { 59, 173,  97},     { 62, 172, 101},
    { 64, 171, 106},     { 67, 169, 110},     { 69, 168, 114},     { 72, 166, 118},
    { 74, 165, 122},     { 77, 164, 126},     { 79, 162, 130},     { 82, 161, 134},
    { 84, 159, 138},     { 87, 158, 143},     { 89, 157, 147},     { 91, 155, 151},
    { 94, 154, 155},     { 96, 153, 159},     { 99, 151, 163},     {101, 150, 167},
    {104, 148, 171},     {106, 147, 175},     {109, 146, 180},     {111, 144, 184},
    {114, 143, 188},     {116, 141, 192},     {119, 140, 196},     {121, 139, 200},
    {123, 137, 204},     {126, 136, 208},     {128, 134, 212},     {131, 133, 217},
    { 59, 173,  86},     { 62, 172,  90},     { 64, 171,  94},     { 67, 169,  98},
    { 69, 168, 102},     { 72, 166, 106},     { 74, 165, 110},     { 77, 164, 114},
    { 79, 162, 119},     { 82, 161, 123},     { 84, 160, 127},     { 86, 158, 131},
    { 89, 157, 135},     { 91, 155, 139},     { 94, 154, 143},     { 96, 153, 147},
    { 99, 151, 151},     {101, 150, 156},     {104, 148, 160},     {106, 147, 164},
    {109, 146, 168},     {111, 144, 172},     {114, 143, 176},     {116, 141, 180},
    {118, 140, 184},     {121, 139, 188},     {123, 137, 193},     {126, 136, 197},
    {128, 134, 201},     {131, 133, 205},     {133, 132, 209},     {136, 130, 213},
    { 64, 171,  82},     { 67, 169,  86},     { 69, 168,  90},     { 72, 167,  95},
    { 74, 165,  99},     { 77, 164, 103},     { 79, 162, 107},     { 81, 161, 111},
    { 84, 160, 115},     { 86, 158, 119},     { 89, 157, 123},     { 91, 155, 127},
    { 94, 154, 132},     { 96, 153, 136},     { 99, 151, 140},     {101, 150, 144},
    {104, 148, 148},     {106, 147, 152},     {108, 146, 156},     {111, 144, 160},
    {113, 143, 164},     {116, 141, 169},     {118, 140, 173},     {121, 139, 177},
    {123, 137, 181},     {126, 136, 185},     {128, 135, 189},     {131, 133, 193},
    {133, 132, 197},     {136, 130, 201},     {138, 129, 206},     {140, 128, 210},
    { 69, 168,  79},     { 72, 167,  83},     { 74, 165,  87},     { 76, 164,  91},
    { 79, 162,  95},     { 81, 161,  99},     { 84, 160, 103},     { 86, 158, 108},
    { 89, 157, 112},     { 91, 155, 116},     { 94, 154, 120},     { 96, 153, 124},
    { 99, 151, 128},     {101, 150, 132},     {103, 149, 136},     {106, 147, 140},
    {108, 146, 145},     {111, 144, 149},     {113, 143, 153},     {116, 142, 157},
    {118, 140, 161},     {121, 139, 165},     {123, 137, 169},     {126, 136, 173},
    {128, 135, 177},     {131, 133, 182},     {133, 132, 186},     {135, 130, 190},
    {138, 129, 194},     {140, 128, 198},     {143, 126, 202},     {145, 125, 206},
    { 74, 165,  75},     { 76, 164,  79},     { 79, 162,  84},     { 81, 161,  88},
    { 84, 160,  92},     { 86, 158,  96},     { 89, 157, 100},     { 91, 156, 104},
    { 94, 154, 108},     { 96, 153, 112},     { 98, 151, 116},     {101, 150, 121},
    {103, 149, 125},     {106, 147, 129},     {108, 146, 133},     {111, 144, 137},
    {113, 143, 141},     {116, 142, 145},     {118, 140, 149},     {121, 139, 153},
    {123, 137, 158},     {126, 136, 162},     {128, 135, 166},     {130, 133, 170},
    {133, 132, 174},     {135, 130, 178},     {138, 129, 182},     {140, 128, 186},
    {143, 126, 190},     {145, 125, 195},     {148, 124, 199},     {150, 122, 203},
    { 79, 163,  72},     { 81, 161,  76},     { 84, 160,  80},     { 86, 158,  84},
    { 89, 157,  88},     { 91, 156,  92},     { 93, 154,  97},     { 96, 153, 101},
    { 98, 151, 105},     {101, 150, 109},     {103, 149, 113},     {106, 147, 117},
    {108, 146, 121},     {111, 144, 125},     {113, 143, 129},     {116, 142, 134},
    {118, 140, 138},     {121, 139, 142},     {123, 138, 146},     {125, 136, 150},
    {128, 135, 154},     {130, 133, 158},     {133, 132, 162},     {135, 131, 166},
    {138, 129, 171},     {140, 128, 175},     {143, 126, 179},     {145, 125, 183},
    {148, 124, 187},     {150, 122, 191},     {152, 121, 195},     {155, 119, 199},
    { 84, 160,  68},     { 86, 158,  73},     { 88, 157,  77},     { 91, 156,  81},
    { 93, 154,  85},     { 96, 153,  89},     { 98, 151,  93},     {101, 150,  97},
    {103, 149, 101},     {106, 147, 105},     {108, 146, 110},     {111, 145, 114},
    {113, 143, 118},     {116, 142, 122},     {118, 140, 126},     {120, 139, 130},
    {123, 138, 134},     {125, 136, 138},     {128, 135, 142},     {130, 133, 147},
    {133, 132, 151},     {135, 131, 155},     {138, 129, 159},     {140, 128, 163},
    {143, 126, 167},     {145, 125, 171},     {147, 124, 175},     {150, 122, 179},
    {152, 121, 184},     {155, 119, 188},     {157, 118, 192},     {160, 117, 196},
    { 88, 157,  65},     { 91, 156,  69},     { 93, 154,  73},     { 96, 153,  77},
    { 98, 152,  81},     {101, 150,  86},     {103, 149,  90},     {106, 147,  94},
    {108, 146,  98},     {111, 145, 102},     {113, 143, 106},     {115, 142, 110},
    {118, 140, 114},     {120, 139, 118},     {123, 138, 123},     {125, 136, 127},
    {128, 135, 131},     {130, 133, 135},     {133, 132, 139},     {135, 131, 143},
    {138, 129, 147},     {140, 128, 151},     {142, 126, 155},     {145, 125, 160},
    {147, 124, 164},     {150, 122, 168},     {152, 121, 172},     {155, 120, 176},
    {157, 118, 180},     {160, 117, 184},     {162, 115, 188},     {165, 114, 192},
    { 93, 154,  62},     { 96, 153,  66},     { 98, 152,  70},     {101, 150,  74},
    {103, 149,  78},     {105, 147,  82},     {108, 146,  86},     {110, 145,  90},
    {113, 143,  94},     {115, 142,  99},     {118, 140, 103},     {120, 139, 107},
    {123, 138, 111},     {125, 136, 115},     {128, 135, 119},     {130, 134, 123},
    {133, 132, 127},     {135, 131, 131},     {137, 129, 136},     {140, 128, 140},
    {142, 127, 144},     {145, 125, 148},     {147, 124, 152},     {150, 122, 156},
    {152, 121, 160},     {155, 120, 164},     {157, 118, 168},     {160, 117, 173},
    {162, 115, 177},     {165, 114, 181},     {167, 113, 185},     {169, 111, 189},
    { 98, 152,  58},     {100, 150,  62},     {103, 149,  66},     {105, 147,  70},
    {108, 146,  75},     {110, 145,  79},     {113, 143,  83},     {115, 142,  87},
    {118, 141,  91},     {120, 139,  95},     {123, 138,  99},     {125, 136, 103},
    {128, 135, 107},     {130, 134, 112},     {132, 132, 116},     {135, 131, 120},
    {137, 129, 124},     {140, 128, 128},     {142, 127, 132},     {145, 125, 136},
    {147, 124, 140},     {150, 122, 144},     {152, 121, 149},     {155, 120, 153},
    {157, 118, 157},     {160, 117, 161},     {162, 115, 165},     {164, 114, 169},
    {167, 113, 173},     {169, 111, 177},     {172, 110, 181},     {174, 109, 186},
    {103, 149,  55},     {105, 148,  59},     {108, 146,  63},     {110, 145,  67},
    {113, 143,  71},     {115, 142,  75},     {118, 141,  79},     {120, 139,  83},
    {123, 138,  88},     {125, 136,  92},     {127, 135,  96},     {130, 134, 100},
    {132, 132, 104},     {135, 131, 108},     {137, 129, 112},     {140, 128, 116},
    {142, 127, 120},     {145, 125, 125},     {147, 124, 129},     {150, 122, 133},
    {152, 121, 137},     {155, 120, 141},     {157, 118, 145},     {159, 117, 149},
    {162, 116, 153},     {164, 114, 157},     {167, 113, 162},     {169, 111, 166},
    {172, 110, 170},     {174, 109, 174},     {177, 107, 178},     {179, 106, 182},
    {108, 146,  51},     {110, 145,  55},     {113, 143,  59},     {115, 142,  64},
    {118, 141,  68},     {120, 139,  72},     {122, 138,  76},     {125, 136,  80},
    {127, 135,  84},     {130, 134,  88},     {132, 132,  92},     {135, 131,  96},
    {137, 130, 101},     {140, 128, 105},     {142, 127, 109},     {145, 125, 113},
    {147, 124, 117},     {149, 123, 121},     {152, 121, 125},     {154, 120, 129},
    {157, 118, 133},     {159, 117, 138},     {162, 116, 142},     {164, 114, 146},
    {167, 113, 150},     {169, 111, 154},     {172, 110, 158},     {174, 109, 162},
    {177, 107, 166},     {179, 106, 170},     {181, 104, 175},     {184, 103, 179},
    {113, 143,  48},     {115, 142,  52},     {117, 141,  56},     {120, 139,  60},
    {122, 138,  64},     {125, 137,  68},     {127, 135,  72},     {130, 134,  77},
    {132, 132,  81},     {135, 131,  85},     {137, 130,  89},     {140, 128,  93},
    {142, 127,  97},     {144, 125, 101},     {147, 124, 105},     {149, 123, 109},
    {152, 121, 114},     {154, 120, 118},     {157, 118, 122},     {159, 117, 126},
    {162, 116, 130},     {164, 114, 134},     {167, 113, 138},     {169, 111, 142},
    {172, 110, 146},     {174, 109, 151},     {176, 107, 155},     {179, 106, 159},
    {181, 105, 163},     {184, 103, 167},     {186, 102, 171},     {189, 100, 175},
    {117, 141,  44},     {120, 139,  48},     {122, 138,  53},     {125, 137,  57},
    {127, 135,  61},     {130, 134,  65},     {132, 132,  69},     {135, 131,  73},
    {137, 130,  77},     {139, 128,  81},     {142, 127,  85},     {144, 125,  90},
    {147, 124,  94},     {149, 123,  98},     {152, 121, 102},     {154, 120, 106},
    {157, 118, 110},     {159, 117, 114},     {162, 116, 118},     {164, 114, 122},
    {167, 113, 127},     {169, 112, 131},     {171, 110, 135},     {174, 109, 139},
    {176, 107, 143},     {179, 106, 147},     {181, 105, 151},     {184, 103, 155},
    {186, 102, 159},     {189, 100, 164},     {191,  99, 168},     {194,  98, 172},
    {122, 138,  41},     {125, 137,  45},     {127, 135,  49},     {130, 134,  53},
    {132, 132,  57},     {134, 131,  61},     {137, 130,  66},     {139, 128,  70},
    {142, 127,  74},     {144, 126,  78},     {147, 124,  82},     {149, 123,  86},
    {152, 121,  90},     {154, 120,  94},     {157, 119,  98},     {159, 117, 103},
    {162, 116, 107},     {164, 114, 111},     {166, 113, 115},     {169, 112, 119},
    {171, 110, 123},     {174, 109, 127},     {176, 107, 131},     {179, 106, 135},
    {181, 105, 140},     {184, 103, 144},     {186, 102, 148},     {189, 100, 152},
    {191,  99, 156},     {193,  98, 160},     {196,  96, 164},     {198,  95, 168},
    {127, 135,  37},     {129, 134,  42},     {132, 133,  46},     {134, 131,  50},
    {137, 130,  54},     {139, 128,  58},     {142, 127,  62},     {144, 126,  66},
    {147, 124,  70},     {149, 123,  74},     {152, 121,  79},     {154, 120,  83},
    {157, 119,  87},     {159, 117,  91},     {161, 116,  95},     {164, 114,  99},
    {166, 113, 103},     {169, 112, 107},     {171, 110, 111},     {174, 109, 116},
    {176, 107, 120},     {179, 106, 124},     {181, 105, 128},     {184, 103, 132},
    {186, 102, 136},     {188, 101, 140},     {191,  99, 144},     {193,  98, 148},
    {196,  96, 153},     {198,  95, 157},     {201,  94, 161},     {203,  92, 165},
    {132, 133,  34},     {134, 131,  38},     {137, 130,  42},     {139, 128,  46},
    {142, 127,  50},     {144, 126,  55},     {147, 124,  59},     {149, 123,  63},
    {152, 121,  67},     {154, 120,  71},     {156, 119,  75},     {159, 117,  79},
    {161, 116,  83},     {164, 115,  87},     {166, 113,  92},     {169, 112,  96},
    {171, 110, 100},     {174, 109, 104},     {176, 108, 108},     {179, 106, 112},
    {181, 105, 116},     {183, 103, 120},     {186, 102, 124},     {188, 101, 129},
    {191,  99, 133},     {193,  98, 137},     {196,  96, 141},     {198,  95, 145},
    {201,  94, 149},     {203,  92, 153},     {206,  91, 157},     {208,  89, 161},
    {137, 130,  31},     {139, 128,  35},     {142, 127,  39},     {144, 126,  43},
    {146, 124,  47},     {149, 123,  51},     {151, 122,  55},     {154, 120,  59},
    {156, 119,  63},     {159, 117,  68},     {161, 116,  72},     {164, 115,  76},
    {166, 113,  80},     {169, 112,  84},     {171, 110,  88},     {174, 109,  92},
    {176, 108,  96},     {178, 106, 100},     {181, 105, 105},     {183, 103, 109},
    {186, 102, 113},     {188, 101, 117},     {191,  99, 121},     {193,  98, 125},
    {196,  96, 129},     {198,  95, 133},     {201,  94, 137},     {203,  92, 142},
    {206,  91, 146},     {208,  90, 150},     {210,  88, 154},     {213,  87, 158},
    {141, 127,  27},     {144, 126,  31},     {146, 124,  35},     {149, 123,  39},
    {151, 122,  44},     {154, 120,  48},     {156, 119,  52},     {159, 117,  56},
    {161, 116,  60},     {164, 115,  64},     {166, 113,  68},     {169, 112,  72},
    {171, 110,  76},     {173, 109,  81},     {176, 108,  85},     {178, 106,  89},
    {181, 105,  93},     {183, 103,  97},     {186, 102, 101},     {188, 101, 105},
    {191,  99, 109},     {193,  98, 113},     {196,  97, 118},     {198,  95, 122},
    {201,  94, 126},     {203,  92, 130},     {205,  91, 134},     {208,  90, 138},
    {210,  88, 142},     {213,  87, 146},     {215,  85, 150},     {218,  84, 155},
    {146, 124,  24},     {149, 123,  28},     {151, 122,  32},     {154, 120,  36},
    {156, 119,  40},     {159, 117,  44},     {161, 116,  48},     {164, 115,  52},
    {166, 113,  57},     {168, 112,  61},     {171, 111,  65},     {173, 109,  69},
    {176, 108,  73},     {178, 106,  77},     {181, 105,  81},     {183, 104,  85},
    {186, 102,  89},     {188, 101,  94},     {191,  99,  98},     {193,  98, 102},
    {196,  97, 106},     {198,  95, 110},     {200,  94, 114},     {203,  92, 118},
    {205,  91, 122},     {208,  90, 126},     {210,  88, 131},     {213,  87, 135},
    {215,  85, 139},     {218,  84, 143},     {220,  83, 147},     {223,  81, 151},
    {151, 122,  20},     {154, 120,  24},     {156, 119,  28},     {159, 118,  33},
    {161, 116,  37},     {163, 115,  41},     {166, 113,  45},     {168, 112,  49},
    {171, 111,  53},     {173, 109,  57},     {176, 108,  61},     {178, 106,  65},
    {181, 105,  70},     {183, 104,  74},     {186, 102,  78},     {188, 101,  82},
    {190,  99,  86},     {193,  98,  90},     {195,  97,  94},     {198,  95,  98},
    {200,  94, 102},     {203,  92, 107},     {205,  91, 111},     {208,  90, 115},
    {210,  88, 119},     {213,  87, 123},     {215,  86, 127},     {218,  84, 131},
    {220,  83, 135},     {222,  81, 139},     {225,  80, 144},     {227,  79, 148},
    {156, 119,  17},     {158, 118,  21},     {161, 116,  25},     {163, 115,  29},
    {166, 113,  33},     {168, 112,  37},     {171, 111,  41},     {173, 109,  46},
    {176, 108,  50},     {178, 106,  54},     {181, 105,  58},     {183, 104,  62},
    {185, 102,  66},     {188, 101,  70},     {190,  99,  74},     {193,  98,  78},
    {195,  97,  83},     {198,  95,  87},     {200,  94,  91},     {203,  93,  95},
    {205,  91,  99},     {208,  90, 103},     {210,  88, 107},     {213,  87, 111},
    {215,  86, 115},     {217,  84, 120},     {220,  83, 124},     {222,  81, 128},
    {225,  80, 132},     {227,  79, 136},     {230,  77, 140},     {232,  76, 144},
    {161, 116,  13},     {163, 115,  17},     {166, 113,  22},     {168, 112,  26},
    {171, 111,  30},     {173, 109,  34},     {176, 108,  38},     {178, 107,  42},
    {180, 105,  46},     {183, 104,  50},     {185, 102,  54},     {188, 101,  59},
    {190, 100,  63},     {193,  98,  67},     {195,  97,  71},     {198,  95,  75},
    {200,  94,  79},     {203,  93,  83},     {205,  91,  87},     {208,  90,  91},
    {210,  88,  96},     {212,  87, 100},     {215,  86, 104},     {217,  84, 108},
    {220,  83, 112},     {222,  81, 116},     {225,  80, 120},     {227,  79, 124},
    {230,  77, 128},     {232,  76, 133},     {235,  75, 137},     {237,  73, 141},
    {166, 114,  10},     {168, 112,  14},     {171, 111,  18},     {173, 109,  22},
    {175, 108,  26},     {178, 107,  30},     {180, 105,  35},     {183, 104,  39},
    {185, 102,  43},     {188, 101,  47},     {190, 100,  51},     {193,  98,  55},
    {195,  97,  59},     {198,  95,  63},     {200,  94,  67},     {203,  93,  72},
    {205,  91,  76},     {207,  90,  80},     {210,  88,  84},     {212,  87,  88},
    {215,  86,  92},     {217,  84,  96},     {220,  83, 100},     {222,  82, 104},
    {225,  80, 109},     {227,  79, 113},     {230,  77, 117},     {232,  76, 121},
    {234,  75, 125},     {237,  73, 129},     {239,  72, 133},     {242,  70, 137},
    { 17, 202, 116},     { 19, 201, 120},     { 22, 199, 124},     { 24, 198, 128},
    { 27, 196, 132},     { 29, 195, 137},     { 32, 194, 141},     { 34, 192, 145},
    { 37, 191, 149},     { 39, 190, 153},     { 41, 188, 157},     { 44, 187, 161},
    { 46, 185, 165},     { 49, 184, 169},     { 51, 183, 174},     { 54, 181, 178},
    { 56, 180, 182},     { 59, 178, 186},     { 61, 177, 190},     { 64, 176, 194},
    { 66, 174, 198},     { 69, 173, 202},     { 71, 171, 206},     { 73, 170, 211},
    { 76, 169, 215},     { 78, 167, 219},     { 81, 166, 223},     { 83, 164, 227},
    { 86, 163, 231},     { 88, 162, 235},     { 91, 160, 239},     { 93, 159, 244},
    { 22, 199, 113},     { 24, 198, 117},     { 27, 197, 121},     { 29, 195, 125},
    { 32, 194, 129},     { 34, 192, 133},     { 36, 191, 137},     { 39, 190, 141},
    { 41, 188, 145},     { 44, 187, 150},     { 46, 185, 154},     { 49, 184, 158},
    { 51, 183, 162},     { 54, 181, 166},     { 56, 180, 170},     { 59, 178, 174},
    { 61, 177, 178},     { 64, 176, 182},     { 66, 174, 187},     { 68, 173, 191},
    { 71, 172, 195},     { 73, 170, 199},     { 76, 169, 203},     { 78, 167, 207},
    { 81, 166, 211},     { 83, 165, 215},     { 86, 163, 219},     { 88, 162, 224},
    { 91, 160, 228},     { 93, 159, 232},     { 95, 158, 236},     { 98, 156, 240},
    { 27, 197, 109},     { 29, 195, 113},     { 31, 194, 117},     { 34, 192, 121},
    { 36, 191, 126},     { 39, 190, 130},     { 41, 188, 134},     { 44, 187, 138},
    { 46, 185, 142},     { 49, 184, 146},     { 51, 183, 150},     { 54, 181, 154},
    { 56, 180, 158},     { 59, 179, 163},     { 61, 177, 167},     { 63, 176, 171},
    { 66, 174, 175},     { 68, 173, 179},     { 71, 172, 183},     { 73, 170, 187},
    { 76, 169, 191},     { 78, 167, 195},     { 81, 166, 200},     { 83, 165, 204},
    { 86, 163, 208},     { 88, 162, 212},     { 90, 160, 216},     { 93, 159, 220},
    { 95, 158, 224},     { 98, 156, 228},     {100, 155, 233},     {103, 153, 237},
    { 31, 194, 106},     { 34, 192, 110},     { 36, 191, 114},     { 39, 190, 118},
    { 41, 188, 122},     { 44, 187, 126},     { 46, 186, 130},     { 49, 184, 134},
    { 51, 183, 139},     { 54, 181, 143},     { 56, 180, 147},     { 58, 179, 151},
    { 61, 177, 155},     { 63, 176, 159},     { 66, 174, 163},     { 68, 173, 167},
    { 71, 172, 171},     { 73, 170, 176},     { 76, 169, 180},     { 78, 167, 184},
    { 81, 166, 188},     { 83, 165, 192},     { 85, 163, 196},     { 88, 162, 200},
    { 90, 161, 204},     { 93, 159, 208},     { 95, 158, 213},     { 98, 156, 217},
    {100, 155, 221},     {103, 154, 225},     {105, 152, 229},     {108, 151, 233},
    { 36, 191, 102},     { 39, 190, 106},     { 41, 188, 110},     { 44, 187, 115},
    { 46, 186, 119},     { 48, 184, 123},     { 51, 183, 127},     { 53, 181, 131},
    { 56, 180, 135},     { 58, 179, 139},     { 61, 177, 143},     { 63, 176, 147},
    { 66, 174, 152},     { 68, 173, 156},     { 71, 172, 160},     { 73, 170, 164},
    { 76, 169, 168},     { 78, 168, 172},     { 80, 166, 176},     { 83, 165, 180},
    { 85, 163, 184},     { 88, 162, 189},     { 90, 161, 193},     { 93, 159, 197},
    { 95, 158, 201},     { 98, 156, 205},     {100, 155, 209},     {103, 154, 213},
    {105, 152, 217},     {108, 151, 221},     {110, 149, 226},     {112, 148, 230},
    { 41, 188,  99},     { 43, 187, 103},     { 46, 186, 107},     { 48, 184, 111},
    { 51, 183, 115},     { 53, 181, 119},     { 56, 180, 123},     { 58, 179, 128},
    { 61, 177, 132},     { 63, 176, 136},     { 66, 175, 140},     { 68, 173, 144},
    { 71, 172, 148},     { 73, 170, 152},     { 75, 169, 156},     { 78, 168, 160},
    { 80, 166, 165},     { 83, 165, 169},     { 85, 163, 173},     { 88, 162, 177},
    { 90, 161, 181},     { 93, 159, 185},     { 95, 158, 189},     { 98, 156, 193},
    {100, 155, 197},     {103, 154, 202},     {105, 152, 206},     {107, 151, 210},
    {110, 149, 214},     {112, 148, 218},     {115, 147, 222},     {117, 145, 226},
    { 46, 186,  95},     { 48, 184,  99},     { 51, 183, 104},     { 53, 182, 108},
    { 56, 180, 112},     { 58, 179, 116},     { 61, 177, 120},     { 63, 176, 124},
    { 66, 175, 128},     { 68, 173, 132},     { 70, 172, 136},     { 73, 170, 141},
    { 75, 169, 145},     { 78, 168, 149},     { 80, 166, 153},     { 83, 165, 157},
    { 85, 163, 161},     { 88, 162, 165},     { 90, 161, 169},     { 93, 159, 173},
    { 95, 158, 178},     { 98, 157, 182},     {100, 155, 186},     {102, 154, 190},
    {105, 152, 194},     {107, 151, 198},     {110, 150, 202},     {112, 148, 206},
    {115, 147, 210},     {117, 145, 215},     {120, 144, 219},     {122, 143, 223},
    { 51, 183,  92},     { 53, 182,  96},     { 56, 180, 100},     { 58, 179, 104},
    { 61, 177, 108},     { 63, 176, 112},     { 65, 175, 117},     { 68, 173, 121},
    { 70, 172, 125},     { 73, 170, 129},     { 75, 169, 133},     { 78, 168, 137},
    { 80, 166, 141},     { 83, 165, 145},     { 85, 164, 149},     { 88, 162, 154},
    { 90, 161, 158},     { 92, 159, 162},     { 95, 158, 166},     { 97, 157, 170},
    {100, 155, 174},     {102, 154, 178},     {105, 152, 182},     {107, 151, 186},
    {110, 150, 191},     {112, 148, 195},     {115, 147, 199},     {117, 145, 203},
    {120, 144, 207},     {122, 143, 211},     {124, 141, 215},     {127, 140, 219},
    { 56, 180,  88},     { 58, 179,  93},     { 60, 177,  97},     { 63, 176, 101},
    { 65, 175, 105},     { 68, 173, 109},     { 70, 172, 113},     { 73, 171, 117},
    { 75, 169, 121},     { 78, 168, 125},     { 80, 166, 130},     { 83, 165, 134},
    { 85, 164, 138},     { 87, 162, 142},     { 90, 161, 146},     { 92, 159, 150},
    { 95, 158, 154},     { 97, 157, 158},     {100, 155, 162},     {102, 154, 167},
    {105, 152, 171},     {107, 151, 175},     {110, 150, 179},     {112, 148, 183},
    {115, 147, 187},     {117, 145, 191},     {119, 144, 195},     {122, 143, 199},
    {124, 141, 204},     {127, 140, 208},     {129, 139, 212},     {132, 137, 216},
    { 60, 178,  85},     { 63, 176,  89},     { 65, 175,  93},     { 68, 173,  97},
    { 70, 172, 101},     { 73, 171, 106},     { 75, 169, 110},     { 78, 168, 114},
    { 80, 166, 118},     { 82, 165, 122},     { 85, 164, 126},     { 87, 162, 130},
    { 90, 161, 134},     { 92, 159, 138},     { 95, 158, 143},     { 97, 157, 147},
    {100, 155, 151},     {102, 154, 155},     {105, 153, 159},     {107, 151, 163},
    {110, 150, 167},     {112, 148, 171},     {114, 147, 175},     {117, 146, 180},
    {119, 144, 184},     {122, 143, 188},     {124, 141, 192},     {127, 140, 196},
    {129, 139, 200},     {132, 137, 204},     {134, 136, 208},     {137, 134, 212},
    { 65, 175,  82},     { 68, 173,  86},     { 70, 172,  90},     { 73, 171,  94},
    { 75, 169,  98},     { 77, 168, 102},     { 80, 166, 106},     { 82, 165, 110},
    { 85, 164, 114},     { 87, 162, 119},     { 90, 161, 123},     { 92, 160, 127},
    { 95, 158, 131},     { 97, 157, 135},     {100, 155, 139},     {102, 154, 143},
    {105, 153, 147},     {107, 151, 151},     {109, 150, 156},     {112, 148, 160},
    {114, 147, 164},     {117, 146, 168},     {119, 144, 172},     {122, 143, 176},
    {124, 141, 180},     {127, 140, 184},     {129, 139, 188},     {132, 137, 193},
    {134, 136, 197},     {136, 134, 201},     {139, 133, 205},     {141, 132, 209},
    { 70, 172,  78},     { 72, 171,  82},     { 75, 169,  86},     { 77, 168,  90},
    { 80, 167,  95},     { 82, 165,  99},     { 85, 164, 103},     { 87, 162, 107},
    { 90, 161, 111},     { 92, 160, 115},     { 95, 158, 119},     { 97, 157, 123},
    {100, 155, 127},     {102, 154, 132},     {104, 153, 136},     {107, 151, 140},
    {109, 150, 144},     {112, 148, 148},     {114, 147, 152},     {117, 146, 156},
    {119, 144, 160},     {122, 143, 164},     {124, 141, 169},     {127, 140, 173},
    {129, 139, 177},     {131, 137, 181},     {134, 136, 185},     {136, 135, 189},
    {139, 133, 193},     {141, 132, 197},     {144, 130, 201},     {146, 129, 206},
    { 75, 169,  75},     { 77, 168,  79},     { 80, 167,  83},     { 82, 165,  87},
    { 85, 164,  91},     { 87, 162,  95},     { 90, 161,  99},     { 92, 160, 103},
    { 94, 158, 108},     { 97, 157, 112},     { 99, 155, 116},     {102, 154, 120},
    {104, 153, 124},     {107, 151, 128},     {109, 150, 132},     {112, 149, 136},
    {114, 147, 140},     {117, 146, 145},     {119, 144, 149},     {122, 143, 153},
    {124, 142, 157},     {126, 140, 161},     {129, 139, 165},     {131, 137, 169},
    {134, 136, 173},     {136, 135, 177},     {139, 133, 182},     {141, 132, 186},
    {144, 130, 190},     {146, 129, 194},     {149, 128, 198},     {151, 126, 202},
    { 80, 167,  71},     { 82, 165,  75},     { 85, 164,  79},     { 87, 162,  84},
    { 89, 161,  88},     { 92, 160,  92},     { 94, 158,  96},     { 97, 157, 100},
    { 99, 156, 104},     {102, 154, 108},     {104, 153, 112},     {107, 151, 116},
    {109, 150, 121},     {112, 149, 125},     {114, 147, 129},     {117, 146, 133},
    {119, 144, 137},     {121, 143, 141},     {124, 142, 145},     {126, 140, 149},
    {129, 139, 153},     {131, 137, 158},     {134, 136, 162},     {136, 135, 166},
    {139, 133, 170},     {141, 132, 174},     {144, 130, 178},     {146, 129, 182},
    {149, 128, 186},     {151, 126, 190},     {153, 125, 195},     {156, 124, 199},
    { 84, 164,  68},     { 87, 163,  72},     { 89, 161,  76},     { 92, 160,  80},
    { 94, 158,  84},     { 97, 157,  88},     { 99, 156,  92},     {102, 154,  97},
    {104, 153, 101},     {107, 151, 105},     {109, 150, 109},     {112, 149, 113},
    {114, 147, 117},     {116, 146, 121},     {119, 144, 125},     {121, 143, 129},
    {124, 142, 134},     {126, 140, 138},     {129, 139, 142},     {131, 138, 146},
    {134, 136, 150},     {136, 135, 154},     {139, 133, 158},     {141, 132, 162},
    {144, 131, 166},     {146, 129, 171},     {148, 128, 175},     {151, 126, 179},
    {153, 125, 183},     {156, 124, 187},     {158, 122, 191},     {161, 121, 195},
    { 89, 161,  64},     { 92, 160,  68},     { 94, 158,  73},     { 97, 157,  77},
    { 99, 156,  81},     {102, 154,  85},     {104, 153,  89},     {107, 151,  93},
    {109, 150,  97},     {111, 149, 101},     {114, 147, 105},     {116, 146, 110},
    {119, 145, 114},     {121, 143, 118},     {124, 142, 122},     {126, 140, 126},
    {129, 139, 130},     {131, 138, 134},     {134, 136, 138},     {136, 135, 142},
    {138, 133, 147},     {141, 132, 151},     {143, 131, 155},     {146, 129, 159},
    {148, 128, 163},     {151, 126, 167},     {153, 125, 171},     {156, 124, 175},
    {158, 122, 179},     {161, 121, 184},     {163, 119, 188},     {166, 118, 192},
    { 94, 158,  61},     { 97, 157,  65},     { 99, 156,  69},     {102, 154,  73},
    {104, 153,  77},     {106, 152,  81},     {109, 150,  86},     {111, 149,  90},
    {114, 147,  94},     {116, 146,  98},     {119, 145, 102},     {121, 143, 106},
    {124, 142, 110},     {126, 140, 114},     {129, 139, 118},     {131, 138, 123},
    {133, 136, 127},     {136, 135, 131},     {138, 133, 135},     {141, 132, 139},
    {143, 131, 143},     {146, 129, 147},     {148, 128, 151},     {151, 126, 155},
    {153, 125, 160},     {156, 124, 164},     {158, 122, 168},     {161, 121, 172},
    {163, 120, 176},     {165, 118, 180},     {168, 117, 184},     {170, 115, 188},
    { 99, 156,  57},     {101, 154,  62},     {104, 153,  66},     {106, 152,  70},
    {109, 150,  74},     {111, 149,  78},     {114, 147,  82},     {116, 146,  86},
    {119, 145,  90},     {121, 143,  94},     {124, 142,  99},     {126, 140, 103},
    {128, 139, 107},     {131, 138, 111},     {133, 136, 115},     {136, 135, 119},
    {138, 134, 123},     {141, 132, 127},     {143, 131, 131},     {146, 129, 136},
    {148, 128, 140},     {151, 127, 144},     {153, 125, 148},     {156, 124, 152},
    {158, 122, 156},     {160, 121, 160},     {163, 120, 164},     {165, 118, 168},
    {168, 117, 173},     {170, 115, 177},     {173, 114, 181},     {175, 113, 185},
    {104, 153,  54},     {106, 152,  58},     {109, 150,  62},     {111, 149,  66},
    {114, 147,  70},     {116, 146,  75},     {119, 145,  79},     {121, 143,  83},
    {123, 142,  87},     {126, 141,  91},     {128, 139,  95},     {131, 138,  99},
    {133, 136, 103},     {136, 135, 107},     {138, 134, 112},     {141, 132, 116},
    {143, 131, 120},     {146, 129, 124},     {148, 128, 128},     {151, 127, 132},
    {153, 125, 136},     {155, 124, 140},     {158, 122, 144},     {160, 121, 149},
    {163, 120, 153},     {165, 118, 157},     {168, 117, 161},     {170, 115, 165},
    {173, 114, 169},     {175, 113, 173},     {178, 111, 177},     {180, 110, 181},
    {109, 150,  51},     {111, 149,  55},     {114, 148,  59},     {116, 146,  63},
    {118, 145,  67},     {121, 143,  71},     {123, 142,  75},     {126, 141,  79},
    {128, 139,  83},     {131, 138,  88},     {133, 136,  92},     {136, 135,  96},
    {138, 134, 100},     {141, 132, 104},     {143, 131, 108},     {146, 129, 112},
    {148, 128, 116},     {150, 127, 120},     {153, 125, 125},     {155, 124, 129},
    {158, 122, 133},     {160, 121, 137},     {163, 120, 141},     {165, 118, 145},
    {168, 117, 149},     {170, 116, 153},     {173, 114, 157},     {175, 113, 162},
    {177, 111, 166},     {180, 110, 170},     {182, 109, 174},     {185, 107, 178},
    {113, 148,  47},     {116, 146,  51},     {118, 145,  55},     {121, 143,  59},
    {123, 142,  64},     {126, 141,  68},     {128, 139,  72},     {131, 138,  76},
    {133, 136,  80},     {136, 135,  84},     {138, 134,  88},     {141, 132,  92},
    {143, 131,  96},     {145, 130, 101},     {148, 128, 105},     {150, 127, 109},
    {153, 125, 113},     {155, 124, 117},     {158, 123, 121},     {160, 121, 125},
    {163, 120, 129},     {165, 118, 133},     {168, 117, 138},     {170, 116, 142},
    {172, 114, 146},     {175, 113, 150},     {177, 111, 154},     {180, 110, 158},
    {182, 109, 162},     {185, 107, 166},     {187, 106, 170},     {190, 104, 175},
    {118, 145,  44},     {121, 143,  48},     {123, 142,  52},     {126, 141,  56},
    {128, 139,  60},     {131, 138,  64},     {133, 137,  68},     {135, 135,  72},
    {138, 134,  77},     {140, 132,  81},     {143, 131,  85},     {145, 130,  89},
    {148, 128,  93},     {150, 127,  97},     {153, 125, 101},     {155, 124, 105},
    {158, 123, 109},     {160, 121, 114},     {163, 120, 118},     {165, 118, 122},
    {167, 117, 126},     {170, 116, 130},     {172, 114, 134},     {175, 113, 138},
    {177, 111, 142},     {180, 110, 146},     {182, 109, 151},     {185, 107, 155},
    {187, 106, 159},     {190, 105, 163},     {192, 103, 167},     {195, 102, 171},
    {123, 142,  40},     {126, 141,  44},     {128, 139,  48},     {130, 138,  53},
    {133, 137,  57},     {135, 135,  61},     {138, 134,  65},     {140, 132,  69},
    {143, 131,  73},     {145, 130,  77},     {148, 128,  81},     {150, 127,  85},
    {153, 125,  90},     {155, 124,  94},     {158, 123,  98},     {160, 121, 102},
    {162, 120, 106},     {165, 118, 110},     {167, 117, 114},     {170, 116, 118},
    {172, 114, 122},     {175, 113, 127},     {177, 112, 131},     {180, 110, 135},
    {182, 109, 139},     {185, 107, 143},     {187, 106, 147},     {190, 105, 151},
    {192, 103, 155},     {194, 102, 159},     {197, 100, 164},     {199,  99, 168},
    {128, 139,  37},     {130, 138,  41},     {133, 137,  45},     {135, 135,  49},
    {138, 134,  53},     {140, 132,  57},     {143, 131,  61},     {145, 130,  66},
    {148, 128,  70},     {150, 127,  74},     {153, 126,  78},     {155, 124,  82},
    {157, 123,  86},     {160, 121,  90},     {162, 120,  94},     {165, 119,  98},
    {167, 117, 103},     {170, 116, 107},     {172, 114, 111},     {175, 113, 115},
    {177, 112, 119},     {180, 110, 123},     {182, 109, 127},     {185, 107, 131},
    {187, 106, 135},     {189, 105, 140},     {192, 103, 144},     {194, 102, 148},
    {197, 100, 152},     {199,  99, 156},     {202,  98, 160},     {204,  96, 164},
    {133, 137,  33},     {135, 135,  37},     {138, 134,  42},     {140, 133,  46},
    {143, 131,  50},     {145, 130,  54},     {148, 128,  58},     {150, 127,  62},
    {152, 126,  66},     {155, 124,  70},     {157, 123,  74},     {160, 121,  79},
    {162, 120,  83},     {165, 119,  87},     {167, 117,  91},     {170, 116,  95},
    {172, 114,  99},     {175, 113, 103},     {177, 112, 107},     {179, 110, 111},
    {182, 109, 116},     {184, 107, 120},     {187, 106, 124},     {189, 105, 128},
    {192, 103, 132},     {194, 102, 136},     {197, 101, 140},     {199,  99, 144},
    {202,  98, 148},     {204,  96, 153},     {207,  95, 157},     {209,  94, 161},
    {138, 134,  30},     {140, 133,  34},     {143, 131,  38},     {145, 130,  42},
    {147, 128,  46},     {150, 127,  50},     {152, 126,  55},     {155, 124,  59},
    {157, 123,  63},     {160, 121,  67},     {162, 120,  71},     {165, 119,  75},
    {167, 117,  79},     {170, 116,  83},     {172, 115,  87},     {174, 113,  92},
    {177, 112,  96},     {179, 110, 100},     {182, 109, 104},     {184, 108, 108},
    {187, 106, 112},     {189, 105, 116},     {192, 103, 120},     {194, 102, 124},
    {197, 101, 129},     {199,  99, 133},     {202,  98, 137},     {204,  96, 141},
    {206,  95, 145},     {209,  94, 149},     {211,  92, 153},     {214,  91, 157},
    {142, 131,  26},     {145, 130,  31},     {147, 128,  35},     {150, 127,  39},
    {152, 126,  43},     {155, 124,  47},     {157, 123,  51},     {160, 122,  55},
    {162, 120,  59},     {165, 119,  63},     {167, 117,  68},     {169, 116,  72},
    {172, 115,  76},     {174, 113,  80},     {177, 112,  84},     {179, 110,  88},
    {182, 109,  92},     {184, 108,  96},     {187, 106, 100},     {189, 105, 105},
    {192, 103, 109},     {194, 102, 113},     {197, 101, 117},     {199,  99, 121},
    {201,  98, 125},     {204,  96, 129},     {206,  95, 133},     {209,  94, 137},
    {211,  92, 142},     {214,  91, 146},     {216,  90, 150},     {219,  88, 154},
    {147, 129,  23},     {150, 127,  27},     {152, 126,  31},     {155, 124,  35},
    {157, 123,  39},     {160, 122,  44},     {162, 120,  48},     {164, 119,  52},
    {167, 117,  56},     {169, 116,  60},     {172, 115,  64},     {174, 113,  68},
    {177, 112,  72},     {179, 110,  76},     {182, 109,  81},     {184, 108,  85},
    {187, 106,  89},     {189, 105,  93},     {192, 103,  97},     {194, 102, 101},
    {196, 101, 105},     {199,  99, 109},     {201,  98, 113},     {204,  97, 118},
    {206,  95, 122},     {209,  94, 126},     {211,  92, 130},     {214,  91, 134},
    {216,  90, 138},     {219,  88, 142},     {221,  87, 146},     {223,  85, 150},
    {152, 126,  20},     {155, 124,  24},     {157, 123,  28},     {159, 122,  32},
    {162, 120,  36},     {164, 119,  40},     {167, 117,  44},     {169, 116,  48},
    {172, 115,  52},     {174, 113,  57},     {177, 112,  61},     {179, 111,  65},
    {182, 109,  69},     {184, 108,  73},     {187, 106,  77},     {189, 105,  81},
    {191, 104,  85},     {194, 102,  89},     {196, 101,  94},     {199,  99,  98},
    {201,  98, 102},     {204,  97, 106},     {206,  95, 110},     {209,  94, 114},
    {211,  92, 118},     {214,  91, 122},     {216,  90, 126},     {218,  88, 131},
    {221,  87, 135},     {223,  85, 139},     {226,  84, 143},     {228,  83, 147},
    {157, 123,  16},     {159, 122,  20},     {162, 120,  24},     {164, 119,  28},
    {167, 118,  33},     {169, 116,  37},     {172, 115,  41},     {174, 113,  45},
    {177, 112,  49},     {179, 111,  53},     {182, 109,  57},     {184, 108,  61},
    {186, 106,  65},     {189, 105,  70},     {191, 104,  74},     {194, 102,  78},
    {196, 101,  82},     {199,  99,  86},     {201,  98,  90},     {204,  97,  94},
    {206,  95,  98},     {209,  94, 102},     {211,  92, 107},     {213,  91, 111},
    {216,  90, 115},     {218,  88, 119},     {221,  87, 123},     {223,  86, 127},
    {226,  84, 131},     {228,  83, 135},     {231,  81, 139},     {233,  80, 144},
    {162, 120,  13},     {164, 119,  17},     {167, 118,  21},     {169, 116,  25},
    {172, 115,  29},     {174, 113,  33},     {176, 112,  37},     {179, 111,  41},
    {181, 109,  46},     {184, 108,  50},     {186, 106,  54},     {189, 105,  58},
    {191, 104,  62},     {194, 102,  66},     {196, 101,  70},     {199,  99,  74},
    {201,  98,  78},     {204,  97,  83},     {206,  95,  87},     {208,  94,  91},
    {211,  93,  95},     {213,  91,  99},     {216,  90, 103},     {218,  88, 107},
    {221,  87, 111},     {223,  86, 115},     {226,  84, 120},     {228,  83, 124},
    {231,  81, 128},     {233,  80, 132},     {236,  79, 136},     {238,  77, 140},
    {167, 118,   9},     {169, 116,  13},     {171, 115,  17},     {174, 113,  22},
    {176, 112,  26},     {179, 111,  30},     {181, 109,  34},     {184, 108,  38},
    {186, 107,  42},     {189, 105,  46},     {191, 104,  50},     {194, 102,  54},
    {196, 101,  59},     {199, 100,  63},     {201,  98,  67},     {203,  97,  71},
    {206,  95,  75},     {208,  94,  79},     {211,  93,  83},     {213,  91,  87},
    {216,  90,  91},     {218,  88,  96},     {221,  87, 100},     {223,  86, 104},
    {226,  84, 108},     {228,  83, 112},     {231,  81, 116},     {233,  80, 120},
    {235,  79, 124},     {238,  77, 128},     {240,  76, 133},     {243,  75, 137},
    { 18, 206, 115},     { 20, 205, 119},     { 23, 203, 124},     { 25, 202, 128},
    { 28, 201, 132},     { 30, 199, 136},     { 33, 198, 140},     { 35, 196, 144},
    { 37, 195, 148},     { 40, 194, 152},     { 42, 192, 156},     { 45, 191, 161},
    { 47, 189, 165},     { 50, 188, 169},     { 52, 187, 173},     { 55, 185, 177},
    { 57, 184, 181},     { 60, 183, 185},     { 62, 181, 189},     { 65, 180, 193},
    { 67, 178, 198},     { 69, 177, 202},     { 72, 176, 206},     { 74, 174, 210},
    { 77, 173, 214},     { 79, 171, 218},     { 82, 170, 222},     { 84, 169, 226},
    { 87, 167, 231},     { 89, 166, 235},     { 92, 164, 239},     { 94, 163, 243},
    { 23, 203, 112},     { 25, 202, 116},     { 28, 201, 120},     { 30, 199, 124},
    { 32, 198, 128},     { 35, 196, 132},     { 37, 195, 137},     { 40, 194, 141},
    { 42, 192, 145},     { 45, 191, 149},     { 47, 190, 153},     { 50, 188, 157},
    { 52, 187, 161},     { 55, 185, 165},     { 57, 184, 169},     { 60, 183, 174},
    { 62, 181, 178},     { 64, 180, 182},     { 67, 178, 186},     { 69, 177, 190},
    { 72, 176, 194},     { 74, 174, 198},     { 77, 173, 202},     { 79, 171, 206},
    { 82, 170, 211},     { 84, 169, 215},     { 87, 167, 219},     { 89, 166, 223},
    { 92, 164, 227},     { 94, 163, 231},     { 96, 162, 235},     { 99, 160, 239},
    { 27, 201, 108},     { 30, 199, 113},     { 32, 198, 117},     { 35, 197, 121},
    { 37, 195, 125},     { 40, 194, 129},     { 42, 192, 133},     { 45, 191, 137},
    { 47, 190, 141},     { 50, 188, 145},     { 52, 187, 150},     { 55, 185, 154},
    { 57, 184, 158},     { 59, 183, 162},     { 62, 181, 166},     { 64, 180, 170},
    { 67, 178, 174},     { 69, 177, 178},     { 72, 176, 182},     { 74, 174, 187},
    { 77, 173, 191},     { 79, 172, 195},     { 82, 170, 199},     { 84, 169, 203},
    { 87, 167, 207},     { 89, 166, 211},     { 91, 165, 215},     { 94, 163, 219},
    { 96, 162, 224},     { 99, 160, 228},     {101, 159, 232},     {104, 158, 236},
    { 32, 198, 105},     { 35, 197, 109},     { 37, 195, 113},     { 40, 194, 117},
    { 42, 192, 121},     { 45, 191, 126},     { 47, 190, 130},     { 50, 188, 134},
    { 52, 187, 138},     { 54, 185, 142},     { 57, 184, 146},     { 59, 183, 150},
    { 62, 181, 154},     { 64, 180, 158},     { 67, 179, 163},     { 69, 177, 167},
    { 72, 176, 171},     { 74, 174, 175},     { 77, 173, 179},     { 79, 172, 183},
    { 81, 170, 187},     { 84, 169, 191},     { 86, 167, 195},     { 89, 166, 200},
    { 91, 165, 204},     { 94, 163, 208},     { 96, 162, 212},     { 99, 160, 216},
    {101, 159, 220},     {104, 158, 224},     {106, 156, 228},     {109, 155, 233},
    { 37, 195, 102},     { 40, 194, 106},     { 42, 192, 110},     { 45, 191, 114},
    { 47, 190, 118},     { 49, 188, 122},     { 52, 187, 126},     { 54, 186, 130},
    { 57, 184, 134},     { 59, 183, 139},     { 62, 181, 143},     { 64, 180, 147},
    { 67, 179, 151},     { 69, 177, 155},     { 72, 176, 159},     { 74, 174, 163},
    { 76, 173, 167},     { 79, 172, 171},     { 81, 170, 176},     { 84, 169, 180},
    { 86, 167, 184},     { 89, 166, 188},     { 91, 165, 192},     { 94, 163, 196},
    { 96, 162, 200},     { 99, 161, 204},     {101, 159, 208},     {104, 158, 213},
    {106, 156, 217},     {108, 155, 221},     {111, 154, 225},     {113, 152, 229},
    { 42, 193,  98},     { 44, 191, 102},     { 47, 190, 106},     { 49, 188, 110},
    { 52, 187, 115},     { 54, 186, 119},     { 57, 184, 123},     { 59, 183, 127},
    { 62, 181, 131},     { 64, 180, 135},     { 67, 179, 139},     { 69, 177, 143},
    { 71, 176, 147},     { 74, 174, 152},     { 76, 173, 156},     { 79, 172, 160},
    { 81, 170, 164},     { 84, 169, 168},     { 86, 168, 172},     { 89, 166, 176},
    { 91, 165, 180},     { 94, 163, 184},     { 96, 162, 189},     { 99, 161, 193},
    {101, 159, 197},     {103, 158, 201},     {106, 156, 205},     {108, 155, 209},
    {111, 154, 213},     {113, 152, 217},     {116, 151, 221},     {118, 149, 226},
    { 47, 190,  95},     { 49, 188,  99},     { 52, 187, 103},     { 54, 186, 107},
    { 57, 184, 111},     { 59, 183, 115},     { 62, 181, 119},     { 64, 180, 123},
    { 66, 179, 128},     { 69, 177, 132},     { 71, 176, 136},     { 74, 175, 140},
    { 76, 173, 144},     { 79, 172, 148},     { 81, 170, 152},     { 84, 169, 156},
    { 86, 168, 160},     { 89, 166, 165},     { 91, 165, 169},     { 94, 163, 173},
    { 96, 162, 177},     { 98, 161, 181},     {101, 159, 185},     {103, 158, 189},
    {106, 156, 193},     {108, 155, 197},     {111, 154, 202},     {113, 152, 206},
    {116, 151, 210},     {118, 149, 214},     {121, 148, 218},     {123, 147, 222},
    { 52, 187,  91},     { 54, 186,  95},     { 57, 184,  99},     { 59, 183, 104},
    { 61, 182, 108},     { 64, 180, 112},     { 66, 179, 116},     { 69, 177, 120},
    { 71, 176, 124},     { 74, 175, 128},     { 76, 173, 132},     { 79, 172, 136},
    { 81, 170, 141},     { 84, 169, 145},     { 86, 168, 149},     { 89, 166, 153},
    { 91, 165, 157},     { 93, 163, 161},     { 96, 162, 165},     { 98, 161, 169},
    {101, 159, 173},     {103, 158, 178},     {106, 157, 182},     {108, 155, 186},
    {111, 154, 190},     {113, 152, 194},     {116, 151, 198},     {118, 150, 202},
    {120, 148, 206},     {123, 147, 210},     {125, 145, 215},     {128, 144, 219},
    { 56, 184,  88},     { 59, 183,  92},     { 61, 182,  96},     { 64, 180, 100},
    { 66, 179, 104},     { 69, 177, 108},     { 71, 176, 112},     { 74, 175, 117},
    { 76, 173, 121},     { 79, 172, 125},     { 81, 170, 129},     { 84, 169, 133},
    { 86, 168, 137},     { 88, 166, 141},     { 91, 165, 145},     { 93, 164, 149},
    { 96, 162, 154},     { 98, 161, 158},     {101, 159, 162},     {103, 158, 166},
    {106, 157, 170},     {108, 155, 174},     {111, 154, 178},     {113, 152, 182},
    {115, 151, 186},     {118, 150, 191},     {120, 148, 195},     {123, 147, 199},
    {125, 145, 203},     {128, 144, 207},     {130, 143, 211},     {133, 141, 215},
    { 61, 182,  84},     { 64, 180,  88},     { 66, 179,  93},     { 69, 177,  97},
    { 71, 176, 101},     { 74, 175, 105},     { 76, 173, 109},     { 78, 172, 113},
    { 81, 171, 117},     { 83, 169, 121},     { 86, 168, 125},     { 88, 166, 130},
    { 91, 165, 134},     { 93, 164, 138},     { 96, 162, 142},     { 98, 161, 146},
    {101, 159, 150},     {103, 158, 154},     {106, 157, 158},     {108, 155, 162},
    {110, 154, 167},     {113, 152, 171},     {115, 151, 175},     {118, 150, 179},
    {120, 148, 183},     {123, 147, 187},     {125, 145, 191},     {128, 144, 195},
    {130, 143, 199},     {133, 141, 204},     {135, 140, 208},     {138, 139, 212},
    { 66, 179,  81},     { 69, 178,  85},     { 71, 176,  89},     { 73, 175,  93},
    { 76, 173,  97},     { 78, 172, 101},     { 81, 171, 106},     { 83, 169, 110},
    { 86, 168, 114},     { 88, 166, 118},     { 91, 165, 122},     { 93, 164, 126},
    { 96, 162, 130},     { 98, 161, 134},     {101, 159, 138},     {103, 158, 143},
    {105, 157, 147},     {108, 155, 151},     {110, 154, 155},     {113, 153, 159},
    {115, 151, 163},     {118, 150, 167},     {120, 148, 171},     {123, 147, 175},
    {125, 146, 180},     {128, 144, 184},     {130, 143, 188},     {133, 141, 192},
    {135, 140, 196},     {137, 139, 200},     {140, 137, 204},     {142, 136, 208},
    { 71, 176,  77},     { 73, 175,  82},     { 76, 173,  86},     { 78, 172,  90},
    { 81, 171,  94},     { 83, 169,  98},     { 86, 168, 102},     { 88, 166, 106},
    { 91, 165, 110},     { 93, 164, 114},     { 96, 162, 119},     { 98, 161, 123},
    {100, 160, 127},     {103, 158, 131},     {105, 157, 135},     {108, 155, 139},
    {110, 154, 143},     {113, 153, 147},     {115, 151, 151},     {118, 150, 156},
    {120, 148, 160},     {123, 147, 164},     {125, 146, 168},     {127, 144, 172},
    {130, 143, 176},     {132, 141, 180},     {135, 140, 184},     {137, 139, 188},
    {140, 137, 193},     {142, 136, 197},     {145, 134, 201},     {147, 133, 205},
    { 76, 173,  74},     { 78, 172,  78},     { 81, 171,  82},     { 83, 169,  86},
    { 86, 168,  90},     { 88, 167,  95},     { 91, 165,  99},     { 93, 164, 103},
    { 95, 162, 107},     { 98, 161, 111},     {100, 160, 115},     {103, 158, 119},
    {105, 157, 123},     {108, 155, 127},     {110, 154, 132},     {113, 153, 136},
    {115, 151, 140},     {118, 150, 144},     {120, 148, 148},     {122, 147, 152},
    {125, 146, 156},     {127, 144, 160},     {130, 143, 164},     {132, 141, 169},
    {135, 140, 173},     {137, 139, 177},     {140, 137, 181},     {142, 136, 185},
    {145, 135, 189},     {147, 133, 193},     {150, 132, 197},     {152, 130, 201},
    { 81, 171,  71},     { 83, 169,  75},     { 86, 168,  79},     { 88, 167,  83},
    { 90, 165,  87},     { 93, 164,  91},     { 95, 162,  95},     { 98, 161,  99},
    {100, 160, 103},     {103, 158, 108},     {105, 157, 112},     {108, 155, 116},
    {110, 154, 120},     {113, 153, 124},     {115, 151, 128},     {117, 150, 132},
    {120, 149, 136},     {122, 147, 140},     {125, 146, 145},     {127, 144, 149},
    {130, 143, 153},     {132, 142, 157},     {135, 140, 161},     {137, 139, 165},
    {140, 137, 169},     {142, 136, 173},     {145, 135, 177},     {147, 133, 182},
    {149, 132, 186},     {152, 130, 190},     {154, 129, 194},     {157, 128, 198},
    { 85, 168,  67},     { 88, 167,  71},     { 90, 165,  75},     { 93, 164,  79},
    { 95, 162,  84},     { 98, 161,  88},     {100, 160,  92},     {103, 158,  96},
    {105, 157, 100},     {108, 156, 104},     {110, 154, 108},     {112, 153, 112},
    {115, 151, 116},     {117, 150, 121},     {120, 149, 125},     {122, 147, 129},
    {125, 146, 133},     {127, 144, 137},     {130, 143, 141},     {132, 142, 145},
    {135, 140, 149},     {137, 139, 153},     {140, 137, 158},     {142, 136, 162},
    {144, 135, 166},     {147, 133, 170},     {149, 132, 174},     {152, 130, 178},
    {154, 129, 182},     {157, 128, 186},     {159, 126, 190},     {162, 125, 195},
    { 90, 165,  64},     { 93, 164,  68},     { 95, 163,  72},     { 98, 161,  76},
    {100, 160,  80},     {103, 158,  84},     {105, 157,  88},     {107, 156,  92},
    {110, 154,  97},     {112, 153, 101},     {115, 151, 105},     {117, 150, 109},
    {120, 149, 113},     {122, 147, 117},     {125, 146, 121},     {127, 144, 125},
    {130, 143, 129},     {132, 142, 134},     {135, 140, 138},     {137, 139, 142},
    {139, 138, 146},     {142, 136, 150},     {144, 135, 154},     {147, 133, 158},
    {149, 132, 162},     {152, 131, 166},     {154, 129, 171},     {157, 128, 175},
    {159, 126, 179},     {162, 125, 183},     {164, 124, 187},     {166, 122, 191},
    { 95, 163,  60},     { 98, 161,  64},     {100, 160,  68},     {102, 158,  73},
    {105, 157,  77},     {107, 156,  81},     {110, 154,  85},     {112, 153,  89},
    {115, 151,  93},     {117, 150,  97},     {120, 149, 101},     {122, 147, 105},
    {125, 146, 110},     {127, 145, 114},     {130, 143, 118},     {132, 142, 122},
    {134, 140, 126},     {137, 139, 130},     {139, 138, 134},     {142, 136, 138},
    {144, 135, 142},     {147, 133, 147},     {149, 132, 151},     {152, 131, 155},
    {154, 129, 159},     {157, 128, 163},     {159, 126, 167},     {161, 125, 171},
    {164, 124, 175},     {166, 122, 179},     {169, 121, 184},     {171, 119, 188},
    {100, 160,  57},     {102, 158,  61},     {105, 157,  65},     {107, 156,  69},
    {110, 154,  73},     {112, 153,  77},     {115, 152,  81},     {117, 150,  86},
    {120, 149,  90},     {122, 147,  94},     {124, 146,  98},     {127, 145, 102},
    {129, 143, 106},     {132, 142, 110},     {134, 140, 114},     {137, 139, 118},
    {139, 138, 123},     {142, 136, 127},     {144, 135, 131},     {147, 133, 135},
    {149, 132, 139},     {152, 131, 143},     {154, 129, 147},     {156, 128, 151},
    {159, 126, 155},     {161, 125, 160},     {164, 124, 164},     {166, 122, 168},
    {169, 121, 172},     {171, 120, 176},     {174, 118, 180},     {176, 117, 184},
    {105, 157,  53},     {107, 156,  57},     {110, 154,  62},     {112, 153,  66},
    {115, 152,  70},     {117, 150,  74},     {119, 149,  78},     {122, 147,  82},
    {124, 146,  86},     {127, 145,  90},     {129, 143,  94},     {132, 142,  99},
    {134, 140, 103},     {137, 139, 107},     {139, 138, 111},     {142, 136, 115},
    {144, 135, 119},     {147, 134, 123},     {149, 132, 127},     {151, 131, 131},
    {154, 129, 136},     {156, 128, 140},     {159, 127, 144},     {161, 125, 148},
    {164, 124, 152},     {166, 122, 156},     {169, 121, 160},     {171, 120, 164},
    {174, 118, 168},     {176, 117, 173},     {179, 115, 177},     {181, 114, 181},
    {110, 154,  50},     {112, 153,  54},     {114, 152,  58},     {117, 150,  62},
    {119, 149,  66},     {122, 147,  70},     {124, 146,  75},     {127, 145,  79},
    {129, 143,  83},     {132, 142,  87},     {134, 141,  91},     {137, 139,  95},
    {139, 138,  99},     {142, 136, 103},     {144, 135, 107},     {146, 134, 112},
    {149, 132, 116},     {151, 131, 120},     {154, 129, 124},     {156, 128, 128},
    {159, 127, 132},     {161, 125, 136},     {164, 124, 140},     {166, 122, 144},
    {169, 121, 149},     {171, 120, 153},     {174, 118, 157},     {176, 117, 161},
    {178, 115, 165},     {181, 114, 169},     {183, 113, 173},     {186, 111, 177},
    {114, 152,  46},     {117, 150,  51},     {119, 149,  55},     {122, 148,  59},
    {124, 146,  63},     {127, 145,  67},     {129, 143,  71},     {132, 142,  75},
    {134, 141,  79},     {137, 139,  83},     {139, 138,  88},     {141, 136,  92},
    {144, 135,  96},     {146, 134, 100},     {149, 132, 104},     {151, 131, 108},
    {154, 129, 112},     {156, 128, 116},     {159, 127, 120},     {161, 125, 125},
    {164, 124, 129},     {166, 122, 133},     {168, 121, 137},     {171, 120, 141},
    {173, 118, 145},     {176, 117, 149},     {178, 116, 153},     {181, 114, 157},
    {183, 113, 162},     {186, 111, 166},     {188, 110, 170},     {191, 109, 174},
    {119, 149,  43},     {122, 148,  47},     {124, 146,  51},     {127, 145,  55},
    {129, 143,  59},     {132, 142,  64},     {134, 141,  68},     {136, 139,  72},
    {139, 138,  76},     {141, 136,  80},     {144, 135,  84},     {146, 134,  88},
    {149, 132,  92},     {151, 131,  96},     {154, 130, 101},     {156, 128, 105},
    {159, 127, 109},     {161, 125, 113},     {163, 124, 117},     {166, 123, 121},
    {168, 121, 125},     {171, 120, 129},     {173, 118, 133},     {176, 117, 138},
    {178, 116, 142},     {181, 114, 146},     {183, 113, 150},     {186, 111, 154},
    {188, 110, 158},     {191, 109, 162},     {193, 107, 166},     {195, 106, 170},
    {124, 146,  40},     {127, 145,  44},     {129, 143,  48},     {131, 142,  52},
    {134, 141,  56},     {136, 139,  60},     {139, 138,  64},     {141, 137,  68},
    {144, 135,  72},     {146, 134,  77},     {149, 132,  81},     {151, 131,  85},
    {154, 130,  89},     {156, 128,  93},     {158, 127,  97},     {161, 125, 101},
    {163, 124, 105},     {166, 123, 109},     {168, 121, 114},     {171, 120, 118},
    {173, 118, 122},     {176, 117, 126},     {178, 116, 130},     {181, 114, 134},
    {183, 113, 138},     {186, 111, 142},     {188, 110, 146},     {190, 109, 151},
    {193, 107, 155},     {195, 106, 159},     {198, 105, 163},     {200, 103, 167},
    {129, 144,  36},     {131, 142,  40},     {134, 141,  44},     {136, 139,  48},
    {139, 138,  53},     {141, 137,  57},     {144, 135,  61},     {146, 134,  65},
    {149, 132,  69},     {151, 131,  73},     {153, 130,  77},     {156, 128,  81},
    {158, 127,  85},     {161, 125,  90},     {163, 124,  94},     {166, 123,  98},
    {168, 121, 102},     {171, 120, 106},     {173, 118, 110},     {176, 117, 114},
    {178, 116, 118},     {181, 114, 122},     {183, 113, 127},     {185, 112, 131},
    {188, 110, 135},     {190, 109, 139},     {193, 107, 143},     {195, 106, 147},
    {198, 105, 151},     {200, 103, 155},     {203, 102, 159},     {205, 100, 164},
    {134, 141,  33},     {136, 139,  37},     {139, 138,  41},     {141, 137,  45},
    {144, 135,  49},     {146, 134,  53},     {148, 132,  57},     {151, 131,  61},
    {153, 130,  66},     {156, 128,  70},     {158, 127,  74},     {161, 126,  78},
    {163, 124,  82},     {166, 123,  86},     {168, 121,  90},     {171, 120,  94},
    {173, 119,  98},     {176, 117, 103},     {178, 116, 107},     {180, 114, 111},
    {183, 113, 115},     {185, 112, 119},     {188, 110, 123},     {190, 109, 127},
    {193, 107, 131},     {195, 106, 135},     {198, 105, 140},     {200, 103, 144},
    {203, 102, 148},     {205, 100, 152},     {207,  99, 156},     {210,  98, 160},
    {139, 138,  29},     {141, 137,  33},     {143, 135,  37},     {146, 134,  42},
    {148, 133,  46},     {151, 131,  50},     {153, 130,  54},     {156, 128,  58},
    {158, 127,  62},     {161, 126,  66},     {163, 124,  70},     {166, 123,  74},
    {168, 121,  79},     {171, 120,  83},     {173, 119,  87},     {175, 117,  91},
    {178, 116,  95},     {180, 114,  99},     {183, 113, 103},     {185, 112, 107},
    {188, 110, 111},     {190, 109, 116},     {193, 107, 120},     {195, 106, 124},
    {198, 105, 128},     {200, 103, 132},     {202, 102, 136},     {205, 101, 140},
    {207,  99, 144},     {210,  98, 148},     {212,  96, 153},     {215,  95, 157},
    {143, 135,  26},     {146, 134,  30},     {148, 133,  34},     {151, 131,  38},
    {153, 130,  42},     {156, 128,  46},     {158, 127,  50},     {161, 126,  55},
    {163, 124,  59},     {165, 123,  63},     {168, 121,  67},     {170, 120,  71},
    {173, 119,  75},     {175, 117,  79},     {178, 116,  83},     {180, 115,  87},
    {183, 113,  92},     {185, 112,  96},     {188, 110, 100},     {190, 109, 104},
    {193, 108, 108},     {195, 106, 112},     {197, 105, 116},     {200, 103, 120},
    {202, 102, 124},     {205, 101, 129},     {207,  99, 133},     {210,  98, 137},
    {212,  96, 141},     {215,  95, 145},     {217,  94, 149},     {220,  92, 153},
    {148, 133,  22},     {151, 131,  26},     {153, 130,  31},     {156, 128,  35},
    {158, 127,  39},     {160, 126,  43},     {163, 124,  47},     {165, 123,  51},
    {168, 122,  55},     {170, 120,  59},     {173, 119,  63},     {175, 117,  68},
    {178, 116,  72},     {180, 115,  76},     {183, 113,  80},     {185, 112,  84},
    {188, 110,  88},     {190, 109,  92},     {192, 108,  96},     {195, 106, 100},
    {197, 105, 105},     {200, 103, 109},     {202, 102, 113},     {205, 101, 117},
    {207,  99, 121},     {210,  98, 125},     {212,  96, 129},     {215,  95, 133},
    {217,  94, 137},     {220,  92, 142},     {222,  91, 146},     {224,  90, 150},
    {153, 130,  19},     {155, 129,  23},     {158, 127,  27},     {160, 126,  31},
    {163, 124,  35},     {165, 123,  39},     {168, 122,  44},     {170, 120,  48},
    {173, 119,  52},     {175, 117,  56},     {178, 116,  60},     {180, 115,  64},
    {183, 113,  68},     {185, 112,  72},     {187, 110,  76},     {190, 109,  81},
    {192, 108,  85},     {195, 106,  89},     {197, 105,  93},     {200, 103,  97},
    {202, 102, 101},     {205, 101, 105},     {207,  99, 109},     {210,  98, 113},
    {212,  97, 118},     {215,  95, 122},     {217,  94, 126},     {219,  92, 130},
    {222,  91, 134},     {224,  90, 138},     {227,  88, 142},     {229,  87, 146},
    {158, 127,  15},     {160, 126,  20},     {163, 124,  24},     {165, 123,  28},
    {168, 122,  32},     {170, 120,  36},     {173, 119,  40},     {175, 117,  44},
    {178, 116,  48},     {180, 115,  52},     {182, 113,  57},     {185, 112,  61},
    {187, 111,  65},     {190, 109,  69},     {192, 108,  73},     {195, 106,  77},
    {197, 105,  81},     {200, 104,  85},     {202, 102,  89},     {205, 101,  94},
    {207,  99,  98},     {209,  98, 102},     {212,  97, 106},     {214,  95, 110},
    {217,  94, 114},     {219,  92, 118},     {222,  91, 122},     {224,  90, 126},
    {227,  88, 131},     {229,  87, 135},     {232,  85, 139},     {234,  84, 143},
    {163, 124,  12},     {165, 123,  16},     {168, 122,  20},     {170, 120,  24},
    {173, 119,  28},     {175, 118,  33},     {177, 116,  37},     {180, 115,  41},
    {182, 113,  45},     {185, 112,  49},     {187, 111,  53},     {190, 109,  57},
    {192, 108,  61},     {195, 106,  65},     {197, 105,  70},     {200, 104,  74},
    {202, 102,  78},     {204, 101,  82},     {207,  99,  86},     {209,  98,  90},
    {212,  97,  94},     {214,  95,  98},     {217,  94, 102},     {219,  92, 107},
    {222,  91, 111},     {224,  90, 115},     {227,  88, 119},     {229,  87, 123},
    {232,  86, 127},     {234,  84, 131},     {236,  83, 135},     {239,  81, 139},
    {168, 122,   8},     {170, 120,  13},     {172, 119,  17},     {175, 118,  21},
    {177, 116,  25},     {180, 115,  29},     {182, 113,  33},     {185, 112,  37},
    {187, 111,  41},     {190, 109,  46},     {192, 108,  50},     {195, 106,  54},
    {197, 105,  58},     {199, 104,  62},     {202, 102,  66},     {204, 101,  70},
    {207,  99,  74},     {209,  98,  78},     {212,  97,  83},     {214,  95,  87},
    {217,  94,  91},     {219,  93,  95},     {222,  91,  99},     {224,  90, 103},
    {227,  88, 107},     {229,  87, 111},     {231,  86, 115},     {234,  84, 120},
    {236,  83, 124},     {239,  81, 128},     {241,  80, 132},     {244,  79, 136},
    { 19, 210, 115},     { 21, 209, 119},     { 24, 207, 123},     { 26, 206, 127},
    { 29, 205, 131},     { 31, 203, 135},     { 34, 202, 139},     { 36, 201, 143},
    { 38, 199, 148},     { 41, 198, 152},     { 43, 196, 156},     { 46, 195, 160},
    { 48, 194, 164},     { 51, 192, 168},     { 53, 191, 172},     { 56, 189, 176},
    { 58, 188, 180},     { 61, 187, 185},     { 63, 185, 189},     { 65, 184, 193},
    { 68, 182, 197},     { 70, 181, 201},     { 73, 180, 205},     { 75, 178, 209},
    { 78, 177, 213},     { 80, 176, 217},     { 83, 174, 222},     { 85, 173, 226},
    { 88, 171, 230},     { 90, 170, 234},     { 93, 169, 238},     { 95, 167, 242},
    { 24, 208, 111},     { 26, 206, 115},     { 29, 205, 119},     { 31, 203, 124},
    { 33, 202, 128},     { 36, 201, 132},     { 38, 199, 136},     { 41, 198, 140},
    { 43, 196, 144},     { 46, 195, 148},     { 48, 194, 152},     { 51, 192, 156},
    { 53, 191, 161},     { 56, 189, 165},     { 58, 188, 169},     { 60, 187, 173},
    { 63, 185, 177},     { 65, 184, 181},     { 68, 183, 185},     { 70, 181, 189},
    { 73, 180, 193},     { 75, 178, 198},     { 78, 177, 202},     { 80, 176, 206},
    { 83, 174, 210},     { 85, 173, 214},     { 88, 171, 218},     { 90, 170, 222},
    { 92, 169, 226},     { 95, 167, 231},     { 97, 166, 235},     {100, 164, 239},
    { 28, 205, 108},     { 31, 203, 112},     { 33, 202, 116},     { 36, 201, 120},
    { 38, 199, 124},     { 41, 198, 128},     { 43, 196, 132},     { 46, 195, 137},
    { 48, 194, 141},     { 51, 192, 145},     { 53, 191, 149},     { 55, 190, 153},
    { 58, 188, 157},     { 60, 187, 161},     { 63, 185, 165},     { 65, 184, 169},
    { 68, 183, 174},     { 70, 181, 178},     { 73, 180, 182},     { 75, 178, 186},
    { 78, 177, 190},     { 80, 176, 194},     { 83, 174, 198},     { 85, 173, 202},
    { 87, 171, 206},     { 90, 170, 211},     { 92, 169, 215},     { 95, 167, 219},
    { 97, 166, 223},     {100, 164, 227},     {102, 163, 231},     {105, 162, 235},
    { 33, 202, 104},     { 36, 201, 108},     { 38, 199, 113},     { 41, 198, 117},
    { 43, 197, 121},     { 46, 195, 125},     { 48, 194, 129},     { 50, 192, 133},
    { 53, 191, 137},     { 55, 190, 141},     { 58, 188, 145},     { 60, 187, 150},
    { 63, 185, 154},     { 65, 184, 158},     { 68, 183, 162},     { 70, 181, 166},
    { 73, 180, 170},     { 75, 178, 174},     { 78, 177, 178},     { 80, 176, 182},
    { 82, 174, 187},     { 85, 173, 191},     { 87, 172, 195},     { 90, 170, 199},
    { 92, 169, 203},     { 95, 167, 207},     { 97, 166, 211},     {100, 165, 215},
    {102, 163, 219},     {105, 162, 224},     {107, 160, 228},     {109, 159, 232},
    { 38, 199, 101},     { 41, 198, 105},     { 43, 197, 109},     { 45, 195, 113},
    { 48, 194, 117},     { 50, 192, 121},     { 53, 191, 126},     { 55, 190, 130},
    { 58, 188, 134},     { 60, 187, 138},     { 63, 185, 142},     { 65, 184, 146},
    { 68, 183, 150},     { 70, 181, 154},     { 73, 180, 158},     { 75, 179, 163},
    { 77, 177, 167},     { 80, 176, 171},     { 82, 174, 175},     { 85, 173, 179},
    { 87, 172, 183},     { 90, 170, 187},     { 92, 169, 191},     { 95, 167, 195},
    { 97, 166, 200},     {100, 165, 204},     {102, 163, 208},     {104, 162, 212},
    {107, 160, 216},     {109, 159, 220},     {112, 158, 224},     {114, 156, 228},
    { 43, 197,  97},     { 45, 195, 102},     { 48, 194, 106},     { 50, 192, 110},
    { 53, 191, 114},     { 55, 190, 118},     { 58, 188, 122},     { 60, 187, 126},
    { 63, 186, 130},     { 65, 184, 134},     { 67, 183, 139},     { 70, 181, 143},
    { 72, 180, 147},     { 75, 179, 151},     { 77, 177, 155},     { 80, 176, 159},
    { 82, 174, 163},     { 85, 173, 167},     { 87, 172, 171},     { 90, 170, 176},
    { 92, 169, 180},     { 95, 167, 184},     { 97, 166, 188},     { 99, 165, 192},
    {102, 163, 196},     {104, 162, 200},     {107, 161, 204},     {109, 159, 208},
    {112, 158, 213},     {114, 156, 217},     {117, 155, 221},     {119, 154, 225},
    { 48, 194,  94},     { 50, 193,  98},     { 53, 191, 102},     { 55, 190, 106},
    { 58, 188, 110},     { 60, 187, 115},     { 62, 186, 119},     { 65, 184, 123},
    { 67, 183, 127},     { 70, 181, 131},     { 72, 180, 135},     { 75, 179, 139},
    { 77, 177, 143},     { 80, 176, 147},     { 82, 174, 152},     { 85, 173, 156},
    { 87, 172, 160},     { 90, 170, 164},     { 92, 169, 168},     { 94, 168, 172},
    { 97, 166, 176},     { 99, 165, 180},     {102, 163, 184},     {104, 162, 189},
    {107, 161, 193},     {109, 159, 197},     {112, 158, 201},     {114, 156, 205},
    {117, 155, 209},     {119, 154, 213},     {122, 152, 217},     {124, 151, 221},
    { 53, 191,  91},     { 55, 190,  95},     { 57, 188,  99},     { 60, 187, 103},
    { 62, 186, 107},     { 65, 184, 111},     { 67, 183, 115},     { 70, 181, 119},
    { 72, 180, 123},     { 75, 179, 128},     { 77, 177, 132},     { 80, 176, 136},
    { 82, 175, 140},     { 85, 173, 144},     { 87, 172, 148},     { 89, 170, 152},
    { 92, 169, 156},     { 94, 168, 160},     { 97, 166, 165},     { 99, 165, 169},
    {102, 163, 173},     {104, 162, 177},     {107, 161, 181},     {109, 159, 185},
    {112, 158, 189},     {114, 156, 193},     {117, 155, 197},     {119, 154, 202},
    {121, 152, 206},     {124, 151, 210},     {126, 149, 214},     {129, 148, 218},
    { 57, 188,  87},     { 60, 187,  91},     { 62, 186,  95},     { 65, 184,  99},
    { 67, 183, 104},     { 70, 182, 108},     { 72, 180, 112},     { 75, 179, 116},
    { 77, 177, 120},     { 80, 176, 124},     { 82, 175, 128},     { 84, 173, 132},
    { 87, 172, 136},     { 89, 170, 141},     { 92, 169, 145},     { 94, 168, 149},
    { 97, 166, 153},     { 99, 165, 157},     {102, 163, 161},     {104, 162, 165},
    {107, 161, 169},     {109, 159, 173},     {111, 158, 178},     {114, 157, 182},
    {116, 155, 186},     {119, 154, 190},     {121, 152, 194},     {124, 151, 198},
    {126, 150, 202},     {129, 148, 206},     {131, 147, 210},     {134, 145, 215},
    { 62, 186,  84},     { 65, 184,  88},     { 67, 183,  92},     { 70, 182,  96},
    { 72, 180, 100},     { 75, 179, 104},     { 77, 177, 108},     { 79, 176, 112},
    { 82, 175, 117},     { 84, 173, 121},     { 87, 172, 125},     { 89, 170, 129},
    { 92, 169, 133},     { 94, 168, 137},     { 97, 166, 141},     { 99, 165, 145},
    {102, 164, 149},     {104, 162, 154},     {106, 161, 158},     {109, 159, 162},
    {111, 158, 166},     {114, 157, 170},     {116, 155, 174},     {119, 154, 178},
    {121, 152, 182},     {124, 151, 186},     {126, 150, 191},     {129, 148, 195},
    {131, 147, 199},     {134, 145, 203},     {136, 144, 207},     {138, 143, 211},
    { 67, 183,  80},     { 69, 182,  84},     { 72, 180,  88},     { 74, 179,  93},
    { 77, 177,  97},     { 79, 176, 101},     { 82, 175, 105},     { 84, 173, 109},
    { 87, 172, 113},     { 89, 171, 117},     { 92, 169, 121},     { 94, 168, 125},
    { 97, 166, 130},     { 99, 165, 134},     {101, 164, 138},     {104, 162, 142},
    {106, 161, 146},     {109, 159, 150},     {111, 158, 154},     {114, 157, 158},
    {116, 155, 162},     {119, 154, 167},     {121, 152, 171},     {124, 151, 175},
    {126, 150, 179},     {129, 148, 183},     {131, 147, 187},     {133, 145, 191},
    {136, 144, 195},     {138, 143, 199},     {141, 141, 204},     {143, 140, 208},
    { 72, 180,  77},     { 74, 179,  81},     { 77, 178,  85},     { 79, 176,  89},
    { 82, 175,  93},     { 84, 173,  97},     { 87, 172, 101},     { 89, 171, 106},
    { 92, 169, 110},     { 94, 168, 114},     { 96, 166, 118},     { 99, 165, 122},
    {101, 164, 126},     {104, 162, 130},     {106, 161, 134},     {109, 159, 138},
    {111, 158, 143},     {114, 157, 147},     {116, 155, 151},     {119, 154, 155},
    {121, 153, 159},     {124, 151, 163},     {126, 150, 167},     {128, 148, 171},
    {131, 147, 175},     {133, 146, 180},     {136, 144, 184},     {138, 143, 188},
    {141, 141, 192},     {143, 140, 196},     {146, 139, 200},     {148, 137, 204},
    { 77, 178,  73},     { 79, 176,  77},     { 82, 175,  82},     { 84, 173,  86},
    { 87, 172,  90},     { 89, 171,  94},     { 91, 169,  98},     { 94, 168, 102},
    { 96, 166, 106},     { 99, 165, 110},     {101, 164, 114},     {104, 162, 119},
    {106, 161, 123},     {109, 160, 127},     {111, 158, 131},     {114, 157, 135},
    {116, 155, 139},     {119, 154, 143},     {121, 153, 147},     {123, 151, 151},
    {126, 150, 156},     {128, 148, 160},     {131, 147, 164},     {133, 146, 168},
    {136, 144, 172},     {138, 143, 176},     {141, 141, 180},     {143, 140, 184},
    {146, 139, 188},     {148, 137, 193},     {150, 136, 197},     {153, 134, 201},
    { 82, 175,  70},     { 84, 173,  74},     { 86, 172,  78},     { 89, 171,  82},
    { 91, 169,  86},     { 94, 168,  90},     { 96, 167,  95},     { 99, 165,  99},
    {101, 164, 103},     {104, 162, 107},     {106, 161, 111},     {109, 160, 115},
    {111, 158, 119},     {113, 157, 123},     {116, 155, 127},     {118, 154, 132},
    {121, 153, 136},     {123, 151, 140},     {126, 150, 144},     {128, 148, 148},
    {131, 147, 152},     {133, 146, 156},     {136, 144, 160},     {138, 143, 164},
    {141, 141, 169},     {143, 140, 173},     {145, 139, 177},     {148, 137, 181},
    {150, 136, 185},     {153, 135, 189},     {155, 133, 193},     {158, 132, 197},
    { 86, 172,  66},     { 89, 171,  71},     { 91, 169,  75},     { 94, 168,  79},
    { 96, 167,  83},     { 99, 165,  87},     {101, 164,  91},     {104, 162,  95},
    {106, 161,  99},     {108, 160, 103},     {111, 158, 108},     {113, 157, 112},
    {116, 155, 116},     {118, 154, 120},     {121, 153, 124},     {123, 151, 128},
    {126, 150, 132},     {128, 149, 136},     {131, 147, 140},     {133, 146, 145},
    {136, 144, 149},     {138, 143, 153},     {140, 142, 157},     {143, 140, 161},
    {145, 139, 165},     {148, 137, 169},     {150, 136, 173},     {153, 135, 177},
    {155, 133, 182},     {158, 132, 186},     {160, 130, 190},     {163, 129, 194},
    { 91, 169,  63},     { 94, 168,  67},     { 96, 167,  71},     { 99, 165,  75},
    {101, 164,  79},     {103, 162,  84},     {106, 161,  88},     {108, 160,  92},
    {111, 158,  96},     {113, 157, 100},     {116, 156, 104},     {118, 154, 108},
    {121, 153, 112},     {123, 151, 116},     {126, 150, 121},     {128, 149, 125},
    {131, 147, 129},     {133, 146, 133},     {135, 144, 137},     {138, 143, 141},
    {140, 142, 145},     {143, 140, 149},     {145, 139, 153},     {148, 137, 158},
    {150, 136, 162},     {153, 135, 166},     {155, 133, 170},     {158, 132, 174},
    {160, 130, 178},     {163, 129, 182},     {165, 128, 186},     {167, 126, 190},
    { 96, 167,  60},     { 98, 165,  64},     {101, 164,  68},     {103, 163,  72},
    {106, 161,  76},     {108, 160,  80},     {111, 158,  84},     {113, 157,  88},
    {116, 156,  92},     {118, 154,  97},     {121, 153, 101},     {123, 151, 105},
    {126, 150, 109},     {128, 149, 113},     {130, 147, 117},     {133, 146, 121},
    {135, 144, 125},     {138, 143, 129},     {140, 142, 134},     {143, 140, 138},
    {145, 139, 142},     {148, 138, 146},     {150, 136, 150},     {153, 135, 154},
    {155, 133, 158},     {157, 132, 162},     {160, 131, 166},     {162, 129, 171},
    {165, 128, 175},     {167, 126, 179},     {170, 125, 183},     {172, 124, 187},
    {101, 164,  56},     {103, 163,  60},     {106, 161,  64},     {108, 160,  68},
    {111, 158,  73},     {113, 157,  77},     {116, 156,  81},     {118, 154,  85},
    {121, 153,  89},     {123, 151,  93},     {125, 150,  97},     {128, 149, 101},
    {130, 147, 105},     {133, 146, 110},     {135, 145, 114},     {138, 143, 118},
    {140, 142, 122},     {143, 140, 126},     {145, 139, 130},     {148, 138, 134},
    {150, 136, 138},     {152, 135, 142},     {155, 133, 147},     {157, 132, 151},
    {160, 131, 155},     {162, 129, 159},     {165, 128, 163},     {167, 126, 167},
    {170, 125, 171},     {172, 124, 175},     {175, 122, 179},     {177, 121, 184},
    {106, 161,  53},     {108, 160,  57},     {111, 158,  61},     {113, 157,  65},
    {116, 156,  69},     {118, 154,  73},     {120, 153,  77},     {123, 152,  81},
    {125, 150,  86},     {128, 149,  90},     {130, 147,  94},     {133, 146,  98},
    {135, 145, 102},     {138, 143, 106},     {140, 142, 110},     {143, 140, 114},
    {145, 139, 118},     {147, 138, 123},     {150, 136, 127},     {152, 135, 131},
    {155, 133, 135},     {157, 132, 139},     {160, 131, 143},     {162, 129, 147},
    {165, 128, 151},     {167, 126, 155},     {170, 125, 160},     {172, 124, 164},
    {175, 122, 168},     {177, 121, 172},     {179, 120, 176},     {182, 118, 180},
    {110, 159,  49},     {113, 157,  53},     {115, 156,  57},     {118, 154,  62},
    {120, 153,  66},     {123, 152,  70},     {125, 150,  74},     {128, 149,  78},
    {130, 147,  82},     {133, 146,  86},     {135, 145,  90},     {138, 143,  94},
    {140, 142,  99},     {142, 140, 103},     {145, 139, 107},     {147, 138, 111},
    {150, 136, 115},     {152, 135, 119},     {155, 134, 123},     {157, 132, 127},
    {160, 131, 131},     {162, 129, 136},     {165, 128, 140},     {167, 127, 144},
    {170, 125, 148},     {172, 124, 152},     {174, 122, 156},     {177, 121, 160},
    {179, 120, 164},     {182, 118, 168},     {184, 117, 173},     {187, 115, 177},
    {115, 156,  46},     {118, 154,  50},     {120, 153,  54},     {123, 152,  58},
    {125, 150,  62},     {128, 149,  66},     {130, 147,  70},     {133, 146,  75},
    {135, 145,  79},     {137, 143,  83},     {140, 142,  87},     {142, 141,  91},
    {145, 139,  95},     {147, 138,  99},     {150, 136, 103},     {152, 135, 107},
    {155, 134, 112},     {157, 132, 116},     {160, 131, 120},     {162, 129, 124},
    {165, 128, 128},     {167, 127, 132},     {169, 125, 136},     {172, 124, 140},
    {174, 122, 144},     {177, 121, 149},     {179, 120, 153},     {182, 118, 157},
    {184, 117, 161},     {187, 115, 165},     {189, 114, 169},     {192, 113, 173},
    {120, 153,  42},     {123, 152,  46},     {125, 150,  51},     {128, 149,  55},
    {130, 148,  59},     {132, 146,  63},     {135, 145,  67},     {137, 143,  71},
    {140, 142,  75},     {142, 141,  79},     {145, 139,  83},     {147, 138,  88},
    {150, 136,  92},     {152, 135,  96},     {155, 134, 100},     {157, 132, 104},
    {160, 131, 108},     {162, 129, 112},     {164, 128, 116},     {167, 127, 120},
    {169, 125, 125},     {172, 124, 129},     {174, 122, 133},     {177, 121, 137},
    {179, 120, 141},     {182, 118, 145},     {184, 117, 149},     {187, 116, 153},
    {189, 114, 157},     {191, 113, 162},     {194, 111, 166},     {196, 110, 170},
    {125, 150,  39},     {127, 149,  43},     {130, 148,  47},     {132, 146,  51},
    {135, 145,  55},     {137, 143,  59},     {140, 142,  64},     {142, 141,  68},
    {145, 139,  72},     {147, 138,  76},     {150, 136,  80},     {152, 135,  84},
    {154, 134,  88},     {157, 132,  92},     {159, 131,  96},     {162, 130, 101},
    {164, 128, 105},     {167, 127, 109},     {169, 125, 113},     {172, 124, 117},
    {174, 123, 121},     {177, 121, 125},     {179, 120, 129},     {182, 118, 133},
    {184, 117, 138},     {186, 116, 142},     {189, 114, 146},     {191, 113, 150},
    {194, 111, 154},     {196, 110, 158},     {199, 109, 162},     {201, 107, 166},
    {130, 148,  35},     {132, 146,  40},     {135, 145,  44},     {137, 143,  48},
    {140, 142,  52},     {142, 141,  56},     {145, 139,  60},     {147, 138,  64},
    {149, 137,  68},     {152, 135,  72},     {154, 134,  77},     {157, 132,  81},
    {159, 131,  85},     {162, 130,  89},     {164, 128,  93},     {167, 127,  97},
    {169, 125, 101},     {172, 124, 105},     {174, 123, 109},     {177, 121, 114},
    {179, 120, 118},     {181, 118, 122},     {184, 117, 126},     {186, 116, 130},
    {189, 114, 134},     {191, 113, 138},     {194, 111, 142},     {196, 110, 146},
    {199, 109, 151},     {201, 107, 155},     {204, 106, 159},     {206, 105, 163},
    {135, 145,  32},     {137, 144,  36},     {140, 142,  40},     {142, 141,  44},
    {144, 139,  48},     {147, 138,  53},     {149, 137,  57},     {152, 135,  61},
    {154, 134,  65},     {157, 132,  69},     {159, 131,  73},     {162, 130,  77},
    {164, 128,  81},     {167, 127,  85},     {169, 125,  90},     {172, 124,  94},
    {174, 123,  98},     {176, 121, 102},     {179, 120, 106},     {181, 118, 110},
    {184, 117, 114},     {186, 116, 118},     {189, 114, 122},     {191, 113, 127},
    {194, 112, 131},     {196, 110, 135},     {199, 109, 139},     {201, 107, 143},
    {204, 106, 147},     {206, 105, 151},     {208, 103, 155},     {211, 102, 159},
    {139, 142,  29},     {142, 141,  33},     {144, 139,  37},     {147, 138,  41},
    {149, 137,  45},     {152, 135,  49},     {154, 134,  53},     {157, 132,  57},
    {159, 131,  61},     {162, 130,  66},     {164, 128,  70},     {167, 127,  74},
    {169, 126,  78},     {171, 124,  82},     {174, 123,  86},     {176, 121,  90},
    {179, 120,  94},     {181, 119,  98},     {184, 117, 103},     {186, 116, 107},
    {189, 114, 111},     {191, 113, 115},     {194, 112, 119},     {196, 110, 123},
    {198, 109, 127},     {201, 107, 131},     {203, 106, 135},     {206, 105, 140},
    {208, 103, 144},     {211, 102, 148},     {213, 100, 152},     {216,  99, 156},
    {144, 139,  25},     {147, 138,  29},     {149, 137,  33},     {152, 135,  37},
    {154, 134,  42},     {157, 133,  46},     {159, 131,  50},     {162, 130,  54},
    {164, 128,  58},     {166, 127,  62},     {169, 126,  66},     {171, 124,  70},
    {174, 123,  74},     {176, 121,  79},     {179, 120,  83},     {181, 119,  87},
    {184, 117,  91},     {186, 116,  95},     {189, 114,  99},     {191, 113, 103},
    {193, 112, 107},     {196, 110, 111},     {198, 109, 116},     {201, 107, 120},
    {203, 106, 124},     {206, 105, 128},     {208, 103, 132},     {211, 102, 136},
    {213, 101, 140},     {216,  99, 144},     {218,  98, 148},     {221,  96, 153},
    {149, 137,  22},     {152, 135,  26},     {154, 134,  30},     {157, 133,  34},
    {159, 131,  38},     {161, 130,  42},     {164, 128,  46},     {166, 127,  50},
    {169, 126,  55},     {171, 124,  59},     {174, 123,  63},     {176, 121,  67},
    {179, 120,  71},     {181, 119,  75},     {184, 117,  79},     {186, 116,  83},
    {188, 115,  87},     {191, 113,  92},     {193, 112,  96},     {196, 110, 100},
    {198, 109, 104},     {201, 108, 108},     {203, 106, 112},     {206, 105, 116},
    {208, 103, 120},     {211, 102, 124},     {213, 101, 129},     {216,  99, 133},
    {218,  98, 137},     {220,  96, 141},     {223,  95, 145},     {225,  94, 149},
    {154, 134,  18},     {156, 133,  22},     {159, 131,  26},     {161, 130,  31},
    {164, 128,  35},     {166, 127,  39},     {169, 126,  43},     {171, 124,  47},
    {174, 123,  51},     {176, 122,  55},     {179, 120,  59},     {181, 119,  63},
    {183, 117,  68},     {186, 116,  72},     {188, 115,  76},     {191, 113,  80},
    {193, 112,  84},     {196, 110,  88},     {198, 109,  92},     {201, 108,  96},
    {203, 106, 100},     {206, 105, 105},     {208, 103, 109},     {211, 102, 113},
    {213, 101, 117},     {215,  99, 121},     {218,  98, 125},     {220,  96, 129},
    {223,  95, 133},     {225,  94, 137},     {228,  92, 142},     {230,  91, 146},
    {159, 131,  15},     {161, 130,  19},     {164, 129,  23},     {166, 127,  27},
    {169, 126,  31},     {171, 124,  35},     {174, 123,  39},     {176, 122,  44},
    {178, 120,  48},     {181, 119,  52},     {183, 117,  56},     {186, 116,  60},
    {188, 115,  64},     {191, 113,  68},     {193, 112,  72},     {196, 110,  76},
    {198, 109,  81},     {201, 108,  85},     {203, 106,  89},     {206, 105,  93},
    {208, 103,  97},     {210, 102, 101},     {213, 101, 105},     {215,  99, 109},
    {218,  98, 113},     {220,  97, 118},     {223,  95, 122},     {225,  94, 126},
    {228,  92, 130},     {230,  91, 134},     {233,  90, 138},     {235,  88, 142},
    {164, 129,  11},     {166, 127,  15},     {169, 126,  20},     {171, 124,  24},
    {173, 123,  28},     {176, 122,  32},     {178, 120,  36},     {181, 119,  40},
    {183, 117,  44},     {186, 116,  48},     {188, 115,  52},     {191, 113,  57},
    {193, 112,  61},     {196, 111,  65},     {198, 109,  69},     {201, 108,  73},
    {203, 106,  77},     {205, 105,  81},     {208, 104,  85},     {210, 102,  89},
    {213, 101,  94},     {215,  99,  98},     {218,  98, 102},     {220,  97, 106},
    {223,  95, 110},     {225,  94, 114},     {228,  92, 118},     {230,  91, 122},
    {232,  90, 126},     {235,  88, 131},     {237,  87, 135},     {240,  85, 139},
    {168, 126,   8},     {171, 124,  12},     {173, 123,  16},     {176, 122,  20},
    {178, 120,  24},     {181, 119,  28},     {183, 118,  33},     {186, 116,  37},
    {188, 115,  41},     {191, 113,  45},     {193, 112,  49},     {195, 111,  53},
    {198, 109,  57},     {200, 108,  61},     {203, 106,  65},     {205, 105,  70},
    {208, 104,  74},     {210, 102,  78},     {213, 101,  82},     {215,  99,  86},
    {218,  98,  90},     {220,  97,  94},     {223,  95,  98},     {225,  94, 102},
    {227,  92, 107},     {230,  91, 111},     {232,  90, 115},     {235,  88, 119},
    {237,  87, 123},     {240,  86, 127},     {242,  84, 131},     {245,  83, 135},
    { 20, 214, 114},     { 22, 213, 118},     { 25, 212, 122},     { 27, 210, 126},
    { 30, 209, 130},     { 32, 207, 135},     { 34, 206, 139},     { 37, 205, 143},
    { 39, 203, 147},     { 42, 202, 151},     { 44, 200, 155},     { 47, 199, 159},
    { 49, 198, 163},     { 52, 196, 167},     { 54, 195, 172},     { 57, 194, 176},
    { 59, 192, 180},     { 62, 191, 184},     { 64, 189, 188},     { 66, 188, 192},
    { 69, 187, 196},     { 71, 185, 200},     { 74, 184, 204},     { 76, 182, 209},
    { 79, 181, 213},     { 81, 180, 217},     { 84, 178, 221},     { 86, 177, 225},
    { 89, 175, 229},     { 91, 174, 233},     { 93, 173, 237},     { 96, 171, 242},
    { 25, 212, 111},     { 27, 210, 115},     { 29, 209, 119},     { 32, 207, 123},
    { 34, 206, 127},     { 37, 205, 131},     { 39, 203, 135},     { 42, 202, 139},
    { 44, 201, 143},     { 47, 199, 148},     { 49, 198, 152},     { 52, 196, 156},
    { 54, 195, 160},     { 56, 194, 164},     { 59, 192, 168},     { 61, 191, 172},
    { 64, 189, 176},     { 66, 188, 180},     { 69, 187, 185},     { 71, 185, 189},
    { 74, 184, 193},     { 76, 182, 197},     { 79, 181, 201},     { 81, 180, 205},
    { 84, 178, 209},     { 86, 177, 213},     { 88, 176, 217},     { 91, 174, 222},
    { 93, 173, 226},     { 96, 171, 230},     { 98, 170, 234},     {101, 169, 238},
    { 29, 209, 107},     { 32, 208, 111},     { 34, 206, 115},     { 37, 205, 119},
    { 39, 203, 124},     { 42, 202, 128},     { 44, 201, 132},     { 47, 199, 136},
    { 49, 198, 140},     { 51, 196, 144},     { 54, 195, 148},     { 56, 194, 152},
    { 59, 192, 156},     { 61, 191, 161},     { 64, 189, 165},     { 66, 188, 169},
    { 69, 187, 173},     { 71, 185, 177},     { 74, 184, 181},     { 76, 183, 185},
    { 79, 181, 189},     { 81, 180, 193},     { 83, 178, 198},     { 86, 177, 202},
    { 88, 176, 206},     { 91, 174, 210},     { 93, 173, 214},     { 96, 171, 218},
    { 98, 170, 222},     {101, 169, 226},     {103, 167, 231},     {106, 166, 235},
    { 34, 206, 104},     { 37, 205, 108},     { 39, 203, 112},     { 42, 202, 116},
    { 44, 201, 120},     { 46, 199, 124},     { 49, 198, 128},     { 51, 196, 132},
    { 54, 195, 137},     { 56, 194, 141},     { 59, 192, 145},     { 61, 191, 149},
    { 64, 190, 153},     { 66, 188, 157},     { 69, 187, 161},     { 71, 185, 165},
    { 74, 184, 169},     { 76, 183, 174},     { 78, 181, 178},     { 81, 180, 182},
    { 83, 178, 186},     { 86, 177, 190},     { 88, 176, 194},     { 91, 174, 198},
    { 93, 173, 202},     { 96, 171, 206},     { 98, 170, 211},     {101, 169, 215},
    {103, 167, 219},     {106, 166, 223},     {108, 164, 227},     {110, 163, 231},
    { 39, 203, 100},     { 41, 202, 104},     { 44, 201, 108},     { 46, 199, 113},
    { 49, 198, 117},     { 51, 197, 121},     { 54, 195, 125},     { 56, 194, 129},
    { 59, 192, 133},     { 61, 191, 137},     { 64, 190, 141},     { 66, 188, 145},
    { 69, 187, 150},     { 71, 185, 154},     { 73, 184, 158},     { 76, 183, 162},
    { 78, 181, 166},     { 81, 180, 170},     { 83, 178, 174},     { 86, 177, 178},
    { 88, 176, 182},     { 91, 174, 187},     { 93, 173, 191},     { 96, 172, 195},
    { 98, 170, 199},     {100, 169, 203},     {103, 167, 207},     {105, 166, 211},
    {108, 165, 215},     {110, 163, 219},     {113, 162, 224},     {115, 160, 228},
    { 44, 201,  97},     { 46, 199, 101},     { 49, 198, 105},     { 51, 197, 109},
    { 54, 195, 113},     { 56, 194, 117},     { 59, 192, 121},     { 61, 191, 126},
    { 64, 190, 130},     { 66, 188, 134},     { 68, 187, 138},     { 71, 185, 142},
    { 73, 184, 146},     { 76, 183, 150},     { 78, 181, 154},     { 81, 180, 158},
    { 83, 179, 163},     { 86, 177, 167},     { 88, 176, 171},     { 91, 174, 175},
    { 93, 173, 179},     { 95, 172, 183},     { 98, 170, 187},     {100, 169, 191},
    {103, 167, 195},     {105, 166, 200},     {108, 165, 204},     {110, 163, 208},
    {113, 162, 212},     {115, 160, 216},     {118, 159, 220},     {120, 158, 224},
    { 49, 198,  93},     { 51, 197,  97},     { 54, 195, 102},     { 56, 194, 106},
    { 59, 192, 110},     { 61, 191, 114},     { 63, 190, 118},     { 66, 188, 122},
    { 68, 187, 126},     { 71, 186, 130},     { 73, 184, 134},     { 76, 183, 139},
    { 78, 181, 143},     { 81, 180, 147},     { 83, 179, 151},     { 86, 177, 155},
    { 88, 176, 159},     { 90, 174, 163},     { 93, 173, 167},     { 95, 172, 171},
    { 98, 170, 176},     {100, 169, 180},     {103, 167, 184},     {105, 166, 188},
    {108, 165, 192},     {110, 163, 196},     {113, 162, 200},     {115, 161, 204},
    {118, 159, 208},     {120, 158, 213},     {122, 156, 217},     {125, 155, 221},
    { 53, 195,  90},     { 56, 194,  94},     { 58, 193,  98},     { 61, 191, 102},
    { 63, 190, 106},     { 66, 188, 110},     { 68, 187, 115},     { 71, 186, 119},
    { 73, 184, 123},     { 76, 183, 127},     { 78, 181, 131},     { 81, 180, 135},
    { 83, 179, 139},     { 85, 177, 143},     { 88, 176, 147},     { 90, 174, 152},
    { 93, 173, 156},     { 95, 172, 160},     { 98, 170, 164},     {100, 169, 168},
    {103, 168, 172},     {105, 166, 176},     {108, 165, 180},     {110, 163, 184},
    {113, 162, 189},     {115, 161, 193},     {117, 159, 197},     {120, 158, 201},
    {122, 156, 205},     {125, 155, 209},     {127, 154, 213},     {130, 152, 217},
    { 58, 193,  86},     { 61, 191,  91},     { 63, 190,  95},     { 66, 188,  99},
    { 68, 187, 103},     { 71, 186, 107},     { 73, 184, 111},     { 76, 183, 115},
    { 78, 181, 119},     { 80, 180, 123},     { 83, 179, 128},     { 85, 177, 132},
    { 88, 176, 136},     { 90, 175, 140},     { 93, 173, 144},     { 95, 172, 148},
    { 98, 170, 152},     {100, 169, 156},     {103, 168, 160},     {105, 166, 165},
    {108, 165, 169},     {110, 163, 173},     {112, 162, 177},     {115, 161, 181},
    {117, 159, 185},     {120, 158, 189},     {122, 156, 193},     {125, 155, 197},
    {127, 154, 202},     {130, 152, 206},     {132, 151, 210},     {135, 149, 214},
    { 63, 190,  83},     { 66, 188,  87},     { 68, 187,  91},     { 71, 186,  95},
    { 73, 184,  99},     { 75, 183, 104},     { 78, 182, 108},     { 80, 180, 112},
    { 83, 179, 116},     { 85, 177, 120},     { 88, 176, 124},     { 90, 175, 128},
    { 93, 173, 132},     { 95, 172, 136},     { 98, 170, 141},     {100, 169, 145},
    {103, 168, 149},     {105, 166, 153},     {107, 165, 157},     {110, 163, 161},
    {112, 162, 165},     {115, 161, 169},     {117, 159, 173},     {120, 158, 178},
    {122, 157, 182},     {125, 155, 186},     {127, 154, 190},     {130, 152, 194},
    {132, 151, 198},     {134, 150, 202},     {137, 148, 206},     {139, 147, 210},
    { 68, 187,  80},     { 70, 186,  84},     { 73, 184,  88},     { 75, 183,  92},
    { 78, 182,  96},     { 80, 180, 100},     { 83, 179, 104},     { 85, 177, 108},
    { 88, 176, 112},     { 90, 175, 117},     { 93, 173, 121},     { 95, 172, 125},
    { 97, 170, 129},     {100, 169, 133},     {102, 168, 137},     {105, 166, 141},
    {107, 165, 145},     {110, 164, 149},     {112, 162, 154},     {115, 161, 158},
    {117, 159, 162},     {120, 158, 166},     {122, 157, 170},     {125, 155, 174},
    {127, 154, 178},     {129, 152, 182},     {132, 151, 186},     {134, 150, 191},
    {137, 148, 195},     {139, 147, 199},     {142, 145, 203},     {144, 144, 207},
    { 73, 184,  76},     { 75, 183,  80},     { 78, 182,  84},     { 80, 180,  88},
    { 83, 179,  93},     { 85, 177,  97},     { 88, 176, 101},     { 90, 175, 105},
    { 92, 173, 109},     { 95, 172, 113},     { 97, 171, 117},     {100, 169, 121},
    {102, 168, 125},     {105, 166, 130},     {107, 165, 134},     {110, 164, 138},
    {112, 162, 142},     {115, 161, 146},     {117, 159, 150},     {120, 158, 154},
    {122, 157, 158},     {124, 155, 162},     {127, 154, 167},     {129, 152, 171},
    {132, 151, 175},     {134, 150, 179},     {137, 148, 183},     {139, 147, 187},
    {142, 145, 191},     {144, 144, 195},     {147, 143, 199},     {149, 141, 204},
    { 78, 182,  73},     { 80, 180,  77},     { 83, 179,  81},     { 85, 178,  85},
    { 87, 176,  89},     { 90, 175,  93},     { 92, 173,  97},     { 95, 172, 101},
    { 97, 171, 106},     {100, 169, 110},     {102, 168, 114},     {105, 166, 118},
    {107, 165, 122},     {110, 164, 126},     {112, 162, 130},     {115, 161, 134},
    {117, 159, 138},     {119, 158, 143},     {122, 157, 147},     {124, 155, 151},
    {127, 154, 155},     {129, 153, 159},     {132, 151, 163},     {134, 150, 167},
    {137, 148, 171},     {139, 147, 175},     {142, 146, 180},     {144, 144, 184},
    {147, 143, 188},     {149, 141, 192},     {151, 140, 196},     {154, 139, 200},
    { 82, 179,  69},     { 85, 178,  73},     { 87, 176,  77},     { 90, 175,  82},
    { 92, 173,  86},     { 95, 172,  90},     { 97, 171,  94},     {100, 169,  98},
    {102, 168, 102},     {105, 166, 106},     {107, 165, 110},     {110, 164, 114},
    {112, 162, 119},     {114, 161, 123},     {117, 160, 127},     {119, 158, 131},
    {122, 157, 135},     {124, 155, 139},     {127, 154, 143},     {129, 153, 147},
    {132, 151, 151},     {134, 150, 156},     {137, 148, 160},     {139, 147, 164},
    {141, 146, 168},     {144, 144, 172},     {146, 143, 176},     {149, 141, 180},
    {151, 140, 184},     {154, 139, 188},     {156, 137, 193},     {159, 136, 197},
    { 87, 176,  66},     { 90, 175,  70},     { 92, 173,  74},     { 95, 172,  78},
    { 97, 171,  82},     {100, 169,  86},     {102, 168,  90},     {105, 167,  95},
    {107, 165,  99},     {109, 164, 103},     {112, 162, 107},     {114, 161, 111},
    {117, 160, 115},     {119, 158, 119},     {122, 157, 123},     {124, 155, 127},
    {127, 154, 132},     {129, 153, 136},     {132, 151, 140},     {134, 150, 144},
    {136, 148, 148},     {139, 147, 152},     {141, 146, 156},     {144, 144, 160},
    {146, 143, 164},     {149, 141, 169},     {151, 140, 173},     {154, 139, 177},
    {156, 137, 181},     {159, 136, 185},     {161, 135, 189},     {164, 133, 193},
    { 92, 174,  62},     { 95, 172,  66},     { 97, 171,  71},     { 99, 169,  75},
    {102, 168,  79},     {104, 167,  83},     {107, 165,  87},     {109, 164,  91},
    {112, 162,  95},     {114, 161,  99},     {117, 160, 103},     {119, 158, 108},
    {122, 157, 112},     {124, 155, 116},     {127, 154, 120},     {129, 153, 124},
    {131, 151, 128},     {134, 150, 132},     {136, 149, 136},     {139, 147, 140},
    {141, 146, 145},     {144, 144, 149},     {146, 143, 153},     {149, 142, 157},
    {151, 140, 161},     {154, 139, 165},     {156, 137, 169},     {159, 136, 173},
    {161, 135, 177},     {163, 133, 182},     {166, 132, 186},     {168, 130, 190},
    { 97, 171,  59},     { 99, 169,  63},     {102, 168,  67},     {104, 167,  71},
    {107, 165,  75},     {109, 164,  79},     {112, 162,  84},     {114, 161,  88},
    {117, 160,  92},     {119, 158,  96},     {122, 157, 100},     {124, 156, 104},
    {126, 154, 108},     {129, 153, 112},     {131, 151, 116},     {134, 150, 121},
    {136, 149, 125},     {139, 147, 129},     {141, 146, 133},     {144, 144, 137},
    {146, 143, 141},     {149, 142, 145},     {151, 140, 149},     {154, 139, 153},
    {156, 137, 158},     {158, 136, 162},     {161, 135, 166},     {163, 133, 170},
    {166, 132, 174},     {168, 130, 178},     {171, 129, 182},     {173, 128, 186},
    {102, 168,  55},     {104, 167,  60},     {107, 165,  64},     {109, 164,  68},
    {112, 163,  72},     {114, 161,  76},     {117, 160,  80},     {119, 158,  84},
    {121, 157,  88},     {124, 156,  92},     {126, 154,  97},     {129, 153, 101},
    {131, 151, 105},     {134, 150, 109},     {136, 149, 113},     {139, 147, 117},
    {141, 146, 121},     {144, 144, 125},     {146, 143, 129},     {149, 142, 134},
    {151, 140, 138},     {153, 139, 142},     {156, 138, 146},     {158, 136, 150},
    {161, 135, 154},     {163, 133, 158},     {166, 132, 162},     {168, 131, 166},
    {171, 129, 171},     {173, 128, 175},     {176, 126, 179},     {178, 125, 183},
    {107, 165,  52},     {109, 164,  56},     {112, 163,  60},     {114, 161,  64},
    {116, 160,  68},     {119, 158,  73},     {121, 157,  77},     {124, 156,  81},
    {126, 154,  85},     {129, 153,  89},     {131, 151,  93},     {134, 150,  97},
    {136, 149, 101},     {139, 147, 105},     {141, 146, 110},     {143, 145, 114},
    {146, 143, 118},     {148, 142, 122},     {151, 140, 126},     {153, 139, 130},
    {156, 138, 134},     {158, 136, 138},     {161, 135, 142},     {163, 133, 147},
    {166, 132, 151},     {168, 131, 155},     {171, 129, 159},     {173, 128, 163},
    {175, 126, 167},     {178, 125, 171},     {180, 124, 175},     {183, 122, 179},
    {111, 163,  49},     {114, 161,  53},     {116, 160,  57},     {119, 158,  61},
    {121, 157,  65},     {124, 156,  69},     {126, 154,  73},     {129, 153,  77},
    {131, 152,  81},     {134, 150,  86},     {136, 149,  90},     {138, 147,  94},
    {141, 146,  98},     {143, 145, 102},     {146, 143, 106},     {148, 142, 110},
    {151, 140, 114},     {153, 139, 118},     {156, 138, 123},     {158, 136, 127},
    {161, 135, 131},     {163, 133, 135},     {166, 132, 139},     {168, 131, 143},
    {170, 129, 147},     {173, 128, 151},     {175, 126, 155},     {178, 125, 160},
    {180, 124, 164},     {183, 122, 168},     {185, 121, 172},     {188, 120, 176},
    {116, 160,  45},     {119, 159,  49},     {121, 157,  53},     {124, 156,  57},
    {126, 154,  62},     {129, 153,  66},     {131, 152,  70},     {133, 150,  74},
    {136, 149,  78},     {138, 147,  82},     {141, 146,  86},     {143, 145,  90},
    {146, 143,  94},     {148, 142,  99},     {151, 140, 103},     {153, 139, 107},
    {156, 138, 111},     {158, 136, 115},     {161, 135, 119},     {163, 134, 123},
    {165, 132, 127},     {168, 131, 131},     {170, 129, 136},     {173, 128, 140},
    {175, 127, 144},     {178, 125, 148},     {180, 124, 152},     {183, 122, 156},
    {185, 121, 160},     {188, 120, 164},     {190, 118, 168},     {193, 117, 173},
    {121, 157,  42},     {124, 156,  46},     {126, 154,  50},     {128, 153,  54},
    {131, 152,  58},     {133, 150,  62},     {136, 149,  66},     {138, 147,  70},
    {141, 146,  75},     {143, 145,  79},     {146, 143,  83},     {148, 142,  87},
    {151, 141,  91},     {153, 139,  95},     {156, 138,  99},     {158, 136, 103},
    {160, 135, 107},     {163, 134, 112},     {165, 132, 116},     {168, 131, 120},
    {170, 129, 124},     {173, 128, 128},     {175, 127, 132},     {178, 125, 136},
    {180, 124, 140},     {183, 122, 144},     {185, 121, 149},     {187, 120, 153},
    {190, 118, 157},     {192, 117, 161},     {195, 115, 165},     {197, 114, 169},
    {126, 154,  38},     {128, 153,  42},     {131, 152,  46},     {133, 150,  51},
    {136, 149,  55},     {138, 148,  59},     {141, 146,  63},     {143, 145,  67},
    {146, 143,  71},     {148, 142,  75},     {151, 141,  79},     {153, 139,  83},
    {155, 138,  88},     {158, 136,  92},     {160, 135,  96},     {163, 134, 100},
    {165, 132, 104},     {168, 131, 108},     {170, 129, 112},     {173, 128, 116},
    {175, 127, 120},     {178, 125, 125},     {180, 124, 129},     {182, 122, 133},
    {185, 121, 137},     {187, 120, 141},     {190, 118, 145},     {192, 117, 149},
    {195, 116, 153},     {197, 114, 157},     {200, 113, 162},     {202, 111, 166},
    {131, 152,  35},     {133, 150,  39},     {136, 149,  43},     {138, 148,  47},
    {141, 146,  51},     {143, 145,  55},     {146, 143,  59},     {148, 142,  64},
    {150, 141,  68},     {153, 139,  72},     {155, 138,  76},     {158, 136,  80},
    {160, 135,  84},     {163, 134,  88},     {165, 132,  92},     {168, 131,  96},
    {170, 130, 101},     {173, 128, 105},     {175, 127, 109},     {177, 125, 113},
    {180, 124, 117},     {182, 123, 121},     {185, 121, 125},     {187, 120, 129},
    {190, 118, 133},     {192, 117, 138},     {195, 116, 142},     {197, 114, 146},
    {200, 113, 150},     {202, 111, 154},     {205, 110, 158},     {207, 109, 162},
    {136, 149,  31},     {138, 148,  35},     {140, 146,  40},     {143, 145,  44},
    {145, 143,  48},     {148, 142,  52},     {150, 141,  56},     {153, 139,  60},
    {155, 138,  64},     {158, 137,  68},     {160, 135,  72},     {163, 134,  77},
    {165, 132,  81},     {168, 131,  85},     {170, 130,  89},     {172, 128,  93},
    {175, 127,  97},     {177, 125, 101},     {180, 124, 105},     {182, 123, 109},
    {185, 121, 114},     {187, 120, 118},     {190, 118, 122},     {192, 117, 126},
    {195, 116, 130},     {197, 114, 134},     {200, 113, 138},     {202, 111, 142},
    {204, 110, 146},     {207, 109, 151},     {209, 107, 155},     {212, 106, 159},
    {140, 146,  28},     {143, 145,  32},     {145, 144,  36},     {148, 142,  40},
    {150, 141,  44},     {153, 139,  48},     {155, 138,  53},     {158, 137,  57},
    {160, 135,  61},     {163, 134,  65},     {165, 132,  69},     {167, 131,  73},
    {170, 130,  77},     {172, 128,  81},     {175, 127,  85},     {177, 125,  90},
    {180, 124,  94},     {182, 123,  98},     {185, 121, 102},     {187, 120, 106},
    {190, 118, 110},     {192, 117, 114},     {195, 116, 118},     {197, 114, 122},
    {199, 113, 127},     {202, 112, 131},     {204, 110, 135},     {207, 109, 139},
    {209, 107, 143},     {212, 106, 147},     {214, 105, 151},     {217, 103, 155},
    {145, 144,  24},     {148, 142,  29},     {150, 141,  33},     {153, 139,  37},
    {155, 138,  41},     {158, 137,  45},     {160, 135,  49},     {162, 134,  53},
    {165, 132,  57},     {167, 131,  61},     {170, 130,  66},     {172, 128,  70},
    {175, 127,  74},     {177, 126,  78},     {180, 124,  82},     {182, 123,  86},
    {185, 121,  90},     {187, 120,  94},     {190, 119,  98},     {192, 117, 103},
    {194, 116, 107},     {197, 114, 111},     {199, 113, 115},     {202, 112, 119},
    {204, 110, 123},     {207, 109, 127},     {209, 107, 131},     {212, 106, 135},
    {214, 105, 140},     {217, 103, 144},     {219, 102, 148},     {221, 100, 152},
    {150, 141,  21},     {153, 139,  25},     {155, 138,  29},     {157, 137,  33},
    {160, 135,  37},     {162, 134,  42},     {165, 133,  46},     {167, 131,  50},
    {170, 130,  54},     {172, 128,  58},     {175, 127,  62},     {177, 126,  66},
    {180, 124,  70},     {182, 123,  74},     {184, 121,  79},     {187, 120,  83},
    {189, 119,  87},     {192, 117,  91},     {194, 116,  95},     {197, 114,  99},
    {199, 113, 103},     {202, 112, 107},     {204, 110, 111},     {207, 109, 116},
    {209, 107, 120},     {212, 106, 124},     {214, 105, 128},     {216, 103, 132},
    {219, 102, 136},     {221, 101, 140},     {224,  99, 144},     {226,  98, 148},
    {155, 138,  18},     {157, 137,  22},     {160, 135,  26},     {162, 134,  30},
    {165, 133,  34},     {167, 131,  38},     {170, 130,  42},     {172, 128,  46},
    {175, 127,  50},     {177, 126,  55},     {179, 124,  59},     {182, 123,  63},
    {184, 121,  67},     {187, 120,  71},     {189, 119,  75},     {192, 117,  79},
    {194, 116,  83},     {197, 115,  87},     {199, 113,  92},     {202, 112,  96},
    {204, 110, 100},     {207, 109, 104},     {209, 108, 108},     {211, 106, 112},
    {214, 105, 116},     {216, 103, 120},     {219, 102, 124},     {221, 101, 129},
    {224,  99, 133},     {226,  98, 137},     {229,  96, 141},     {231,  95, 145},
    {160, 135,  14},     {162, 134,  18},     {165, 133,  22},     {167, 131,  26},
    {170, 130,  31},     {172, 128,  35},     {174, 127,  39},     {177, 126,  43},
    {179, 124,  47},     {182, 123,  51},     {184, 122,  55},     {187, 120,  59},
    {189, 119,  63},     {192, 117,  68},     {194, 116,  72},     {197, 115,  76},
    {199, 113,  80},     {202, 112,  84},     {204, 110,  88},     {206, 109,  92},
    {209, 108,  96},     {211, 106, 100},     {214, 105, 105},     {216, 103, 109},
    {219, 102, 113},     {221, 101, 117},     {224,  99, 121},     {226,  98, 125},
    {229,  96, 129},     {231,  95, 133},     {234,  94, 137},     {236,  92, 142},
    {165, 133,  11},     {167, 131,  15},     {169, 130,  19},     {172, 129,  23},
    {174, 127,  27},     {177, 126,  31},     {179, 124,  35},     {182, 123,  39},
    {184, 122,  44},     {187, 120,  48},     {189, 119,  52},     {192, 117,  56},
    {194, 116,  60},     {197, 115,  64},     {199, 113,  68},     {201, 112,  72},
    {204, 110,  76},     {206, 109,  81},     {209, 108,  85},     {211, 106,  89},
    {214, 105,  93},     {216, 103,  97},     {219, 102, 101},     {221, 101, 105},
    {224,  99, 109},     {226,  98, 113},     {228,  97, 118},     {231,  95, 122},
    {233,  94, 126},     {236,  92, 130},     {238,  91, 134},     {241,  90, 138},
    {169, 130,   7},     {172, 129,  11},     {174, 127,  15},     {177, 126,  20},
    {179, 124,  24},     {182, 123,  28},     {184, 122,  32},     {187, 120,  36},
    {189, 119,  40},     {192, 117,  44},     {194, 116,  48},     {196, 115,  52},
    {199, 113,  57},     {201, 112,  61},     {204, 111,  65},     {206, 109,  69},
    {209, 108,  73},     {211, 106,  77},     {214, 105,  81},     {216, 104,  85},
    {219, 102,  89},     {221, 101,  94},     {223,  99,  98},     {226,  98, 102},
    {228,  97, 106},     {231,  95, 110},     {233,  94, 114},     {236,  92, 118},
    {238,  91, 122},     {241,  90, 126},     {243,  88, 131},     {246,  87, 135},
    { 21, 218, 113},     { 23, 217, 117},     { 26, 216, 122},     { 28, 214, 126},
    { 30, 213, 130},     { 33, 212, 134},     { 35, 210, 138},     { 38, 209, 142},
    { 40, 207, 146},     { 43, 206, 150},     { 45, 205, 154},     { 48, 203, 159},
    { 50, 202, 163},     { 53, 200, 167},     { 55, 199, 171},     { 58, 198, 175},
    { 60, 196, 179},     { 62, 195, 183},     { 65, 193, 187},     { 67, 192, 191},
    { 70, 191, 196},     { 72, 189, 200},     { 75, 188, 204},     { 77, 187, 208},
    { 80, 185, 212},     { 82, 184, 216},     { 85, 182, 220},     { 87, 181, 224},
    { 89, 180, 229},     { 92, 178, 233},     { 94, 177, 237},     { 97, 175, 241},
    { 25, 216, 110},     { 28, 214, 114},     { 30, 213, 118},     { 33, 212, 122},
    { 35, 210, 126},     { 38, 209, 130},     { 40, 207, 135},     { 43, 206, 139},
    { 45, 205, 143},     { 48, 203, 147},     { 50, 202, 151},     { 53, 200, 155},
    { 55, 199, 159},     { 57, 198, 163},     { 60, 196, 167},     { 62, 195, 172},
    { 65, 194, 176},     { 67, 192, 180},     { 70, 191, 184},     { 72, 189, 188},
    { 75, 188, 192},     { 77, 187, 196},     { 80, 185, 200},     { 82, 184, 204},
    { 84, 182, 209},     { 87, 181, 213},     { 89, 180, 217},     { 92, 178, 221},
    { 94, 177, 225},     { 97, 175, 229},     { 99, 174, 233},     {102, 173, 237},
    { 30, 213, 106},     { 33, 212, 111},     { 35, 210, 115},     { 38, 209, 119},
    { 40, 207, 123},     { 43, 206, 127},     { 45, 205, 131},     { 48, 203, 135},
    { 50, 202, 139},     { 52, 201, 143},     { 55, 199, 148},     { 57, 198, 152},
    { 60, 196, 156},     { 62, 195, 160},     { 65, 194, 164},     { 67, 192, 168},
    { 70, 191, 172},     { 72, 189, 176},     { 75, 188, 180},     { 77, 187, 185},
    { 79, 185, 189},     { 82, 184, 193},     { 84, 182, 197},     { 87, 181, 201},
    { 89, 180, 205},     { 92, 178, 209},     { 94, 177, 213},     { 97, 176, 217},
    { 99, 174, 222},     {102, 173, 226},     {104, 171, 230},     {107, 170, 234},
    { 35, 210, 103},     { 38, 209, 107},     { 40, 208, 111},     { 42, 206, 115},
    { 45, 205, 119},     { 47, 203, 124},     { 50, 202, 128},     { 52, 201, 132},
    { 55, 199, 136},     { 57, 198, 140},     { 60, 196, 144},     { 62, 195, 148},
    { 65, 194, 152},     { 67, 192, 156},     { 70, 191, 161},     { 72, 189, 165},
    { 74, 188, 169},     { 77, 187, 173},     { 79, 185, 177},     { 82, 184, 181},
    { 84, 183, 185},     { 87, 181, 189},     { 89, 180, 193},     { 92, 178, 198},
    { 94, 177, 202},     { 97, 176, 206},     { 99, 174, 210},     {102, 173, 214},
    {104, 171, 218},     {106, 170, 222},     {109, 169, 226},     {111, 167, 231},
    { 40, 208, 100},     { 42, 206, 104},     { 45, 205, 108},     { 47, 203, 112},
    { 50, 202, 116},     { 52, 201, 120},     { 55, 199, 124},     { 57, 198, 128},
    { 60, 196, 132},     { 62, 195, 137},     { 65, 194, 141},     { 67, 192, 145},
    { 69, 191, 149},     { 72, 190, 153},     { 74, 188, 157},     { 77, 187, 161},
    { 79, 185, 165},     { 82, 184, 169},     { 84, 183, 174},     { 87, 181, 178},
    { 89, 180, 182},     { 92, 178, 186},     { 94, 177, 190},     { 97, 176, 194},
    { 99, 174, 198},     {101, 173, 202},     {104, 171, 206},     {106, 170, 211},
    {109, 169, 215},     {111, 167, 219},     {114, 166, 223},     {116, 164, 227},
    { 45, 205,  96},     { 47, 203, 100},     { 50, 202, 104},     { 52, 201, 108},
    { 55, 199, 113},     { 57, 198, 117},     { 60, 197, 121},     { 62, 195, 125},
    { 64, 194, 129},     { 67, 192, 133},     { 69, 191, 137},     { 72, 190, 141},
    { 74, 188, 145},     { 77, 187, 150},     { 79, 185, 154},     { 82, 184, 158},
    { 84, 183, 162},     { 87, 181, 166},     { 89, 180, 170},     { 92, 178, 174},
    { 94, 177, 178},     { 96, 176, 182},     { 99, 174, 187},     {101, 173, 191},
    {104, 172, 195},     {106, 170, 199},     {109, 169, 203},     {111, 167, 207},
    {114, 166, 211},     {116, 165, 215},     {119, 163, 219},     {121, 162, 224},
    { 50, 202,  93},     { 52, 201,  97},     { 55, 199, 101},     { 57, 198, 105},
    { 59, 197, 109},     { 62, 195, 113},     { 64, 194, 117},     { 67, 192, 121},
    { 69, 191, 126},     { 72, 190, 130},     { 74, 188, 134},     { 77, 187, 138},
    { 79, 185, 142},     { 82, 184, 146},     { 84, 183, 150},     { 86, 181, 154},
    { 89, 180, 158},     { 91, 179, 163},     { 94, 177, 167},     { 96, 176, 171},
    { 99, 174, 175},     {101, 173, 179},     {104, 172, 183},     {106, 170, 187},
    {109, 169, 191},     {111, 167, 195},     {114, 166, 200},     {116, 165, 204},
    {118, 163, 208},     {121, 162, 212},     {123, 160, 216},     {126, 159, 220},
    { 54, 199,  89},     { 57, 198,  93},     { 59, 197,  97},     { 62, 195, 102},
    { 64, 194, 106},     { 67, 192, 110},     { 69, 191, 114},     { 72, 190, 118},
    { 74, 188, 122},     { 77, 187, 126},     { 79, 186, 130},     { 81, 184, 134},
    { 84, 183, 139},     { 86, 181, 143},     { 89, 180, 147},     { 91, 179, 151},
    { 94, 177, 155},     { 96, 176, 159},     { 99, 174, 163},     {101, 173, 167},
    {104, 172, 171},     {106, 170, 176},     {109, 169, 180},     {111, 167, 184},
    {113, 166, 188},     {116, 165, 192},     {118, 163, 196},     {121, 162, 200},
    {123, 161, 204},     {126, 159, 208},     {128, 158, 213},     {131, 156, 217},
    { 59, 197,  86},     { 62, 195,  90},     { 64, 194,  94},     { 67, 193,  98},
    { 69, 191, 102},     { 72, 190, 106},     { 74, 188, 110},     { 76, 187, 115},
    { 79, 186, 119},     { 81, 184, 123},     { 84, 183, 127},     { 86, 181, 131},
    { 89, 180, 135},     { 91, 179, 139},     { 94, 177, 143},     { 96, 176, 147},
    { 99, 174, 152},     {101, 173, 156},     {104, 172, 160},     {106, 170, 164},
    {108, 169, 168},     {111, 168, 172},     {113, 166, 176},     {116, 165, 180},
    {118, 163, 184},     {121, 162, 189},     {123, 161, 193},     {126, 159, 197},
    {128, 158, 201},     {131, 156, 205},     {133, 155, 209},     {136, 154, 213},
    { 64, 194,  82},     { 67, 193,  86},     { 69, 191,  91},     { 71, 190,  95},
    { 74, 188,  99},     { 76, 187, 103},     { 79, 186, 107},     { 81, 184, 111},
    { 84, 183, 115},     { 86, 181, 119},     { 89, 180, 123},     { 91, 179, 128},
    { 94, 177, 132},     { 96, 176, 136},     { 99, 175, 140},     {101, 173, 144},
    {103, 172, 148},     {106, 170, 152},     {108, 169, 156},     {111, 168, 160},
    {113, 166, 165},     {116, 165, 169},     {118, 163, 173},     {121, 162, 177},
    {123, 161, 181},     {126, 159, 185},     {128, 158, 189},     {130, 156, 193},
    {133, 155, 197},     {135, 154, 202},     {138, 152, 206},     {140, 151, 210},
    { 69, 191,  79},     { 71, 190,  83},     { 74, 188,  87},     { 76, 187,  91},
    { 79, 186,  95},     { 81, 184,  99},     { 84, 183, 104},     { 86, 182, 108},
    { 89, 180, 112},     { 91, 179, 116},     { 94, 177, 120},     { 96, 176, 124},
    { 98, 175, 128},     {101, 173, 132},     {103, 172, 136},     {106, 170, 141},
    {108, 169, 145},     {111, 168, 149},     {113, 166, 153},     {116, 165, 157},
    {118, 163, 161},     {121, 162, 165},     {123, 161, 169},     {125, 159, 173},
    {128, 158, 178},     {130, 157, 182},     {133, 155, 186},     {135, 154, 190},
    {138, 152, 194},     {140, 151, 198},     {143, 150, 202},     {145, 148, 206},
    { 74, 189,  75},     { 76, 187,  80},     { 79, 186,  84},     { 81, 184,  88},
    { 84, 183,  92},     { 86, 182,  96},     { 89, 180, 100},     { 91, 179, 104},
    { 93, 177, 108},     { 96, 176, 112},     { 98, 175, 117},     {101, 173, 121},
    {103, 172, 125},     {106, 170, 129},     {108, 169, 133},     {111, 168, 137},
    {113, 166, 141},     {116, 165, 145},     {118, 164, 149},     {120, 162, 154},
    {123, 161, 158},     {125, 159, 162},     {128, 158, 166},     {130, 157, 170},
    {133, 155, 174},     {135, 154, 178},     {138, 152, 182},     {140, 151, 186},
    {143, 150, 191},     {145, 148, 195},     {148, 147, 199},     {150, 145, 203},
    { 79, 186,  72},     { 81, 184,  76},     { 83, 183,  80},     { 86, 182,  84},
    { 88, 180,  88},     { 91, 179,  93},     { 93, 177,  97},     { 96, 176, 101},
    { 98, 175, 105},     {101, 173, 109},     {103, 172, 113},     {106, 171, 117},
    {108, 169, 121},     {111, 168, 125},     {113, 166, 130},     {115, 165, 134},
    {118, 164, 138},     {120, 162, 142},     {123, 161, 146},     {125, 159, 150},
    {128, 158, 154},     {130, 157, 158},     {133, 155, 162},     {135, 154, 167},
    {138, 152, 171},     {140, 151, 175},     {143, 150, 179},     {145, 148, 183},
    {147, 147, 187},     {150, 145, 191},     {152, 144, 195},     {155, 143, 199},
    { 83, 183,  69},     { 86, 182,  73},     { 88, 180,  77},     { 91, 179,  81},
    { 93, 178,  85},     { 96, 176,  89},     { 98, 175,  93},     {101, 173,  97},
    {103, 172, 101},     {106, 171, 106},     {108, 169, 110},     {110, 168, 114},
    {113, 166, 118},     {115, 165, 122},     {118, 164, 126},     {120, 162, 130},
    {123, 161, 134},     {125, 159, 138},     {128, 158, 143},     {130, 157, 147},
    {133, 155, 151},     {135, 154, 155},     {138, 153, 159},     {140, 151, 163},
    {142, 150, 167},     {145, 148, 171},     {147, 147, 175},     {150, 146, 180},
    {152, 144, 184},     {155, 143, 188},     {157, 141, 192},     {160, 140, 196},
    { 88, 180,  65},     { 91, 179,  69},     { 93, 178,  73},     { 96, 176,  77},
    { 98, 175,  82},     {101, 173,  86},     {103, 172,  90},     {105, 171,  94},
    {108, 169,  98},     {110, 168, 102},     {113, 166, 106},     {115, 165, 110},
    {118, 164, 114},     {120, 162, 119},     {123, 161, 123},     {125, 160, 127},
    {128, 158, 131},     {130, 157, 135},     {133, 155, 139},     {135, 154, 143},
    {137, 153, 147},     {140, 151, 151},     {142, 150, 156},     {145, 148, 160},
    {147, 147, 164},     {150, 146, 168},     {152, 144, 172},     {155, 143, 176},
    {157, 141, 180},     {160, 140, 184},     {162, 139, 188},     {164, 137, 193},
    { 93, 178,  62},     { 96, 176,  66},     { 98, 175,  70},     {100, 173,  74},
    {103, 172,  78},     {105, 171,  82},     {108, 169,  86},     {110, 168,  90},
    {113, 167,  95},     {115, 165,  99},     {118, 164, 103},     {120, 162, 107},
    {123, 161, 111},     {125, 160, 115},     {127, 158, 119},     {130, 157, 123},
    {132, 155, 127},     {135, 154, 132},     {137, 153, 136},     {140, 151, 140},
    {142, 150, 144},     {145, 148, 148},     {147, 147, 152},     {150, 146, 156},
    {152, 144, 160},     {155, 143, 164},     {157, 141, 169},     {159, 140, 173},
    {162, 139, 177},     {164, 137, 181},     {167, 136, 185},     {169, 135, 189},
    { 98, 175,  58},     {100, 174,  62},     {103, 172,  66},     {105, 171,  71},
    {108, 169,  75},     {110, 168,  79},     {113, 167,  83},     {115, 165,  87},
    {118, 164,  91},     {120, 162,  95},     {122, 161,  99},     {125, 160, 103},
    {127, 158, 108},     {130, 157, 112},     {132, 155, 116},     {135, 154, 120},
    {137, 153, 124},     {140, 151, 128},     {142, 150, 132},     {145, 149, 136},
    {147, 147, 140},     {150, 146, 145},     {152, 144, 149},     {154, 143, 153},
    {157, 142, 157},     {159, 140, 161},     {162, 139, 165},     {164, 137, 169},
    {167, 136, 173},     {169, 135, 177},     {172, 133, 182},     {174, 132, 186},
    {103, 172,  55},     {105, 171,  59},     {108, 169,  63},     {110, 168,  67},
    {113, 167,  71},     {115, 165,  75},     {117, 164,  79},     {120, 162,  84},
    {122, 161,  88},     {125, 160,  92},     {127, 158,  96},     {130, 157, 100},
    {132, 156, 104},     {135, 154, 108},     {137, 153, 112},     {140, 151, 116},
    {142, 150, 121},     {145, 149, 125},     {147, 147, 129},     {149, 146, 133},
    {152, 144, 137},     {154, 143, 141},     {157, 142, 145},     {159, 140, 149},
    {162, 139, 153},     {164, 137, 158},     {167, 136, 162},     {169, 135, 166},
    {172, 133, 170},     {174, 132, 174},     {177, 130, 178},     {179, 129, 182},
    {108, 169,  51},     {110, 168,  55},     {112, 167,  60},     {115, 165,  64},
    {117, 164,  68},     {120, 163,  72},     {122, 161,  76},     {125, 160,  80},
    {127, 158,  84},     {130, 157,  88},     {132, 156,  92},     {135, 154,  97},
    {137, 153, 101},     {140, 151, 105},     {142, 150, 109},     {144, 149, 113},
    {147, 147, 117},     {149, 146, 121},     {152, 144, 125},     {154, 143, 129},
    {157, 142, 134},     {159, 140, 138},     {162, 139, 142},     {164, 138, 146},
    {167, 136, 150},     {169, 135, 154},     {171, 133, 158},     {174, 132, 162},
    {176, 131, 166},     {179, 129, 171},     {181, 128, 175},     {184, 126, 179},
    {112, 167,  48},     {115, 165,  52},     {117, 164,  56},     {120, 163,  60},
    {122, 161,  64},     {125, 160,  68},     {127, 158,  73},     {130, 157,  77},
    {132, 156,  81},     {135, 154,  85},     {137, 153,  89},     {139, 151,  93},
    {142, 150,  97},     {144, 149, 101},     {147, 147, 105},     {149, 146, 110},
    {152, 145, 114},     {154, 143, 118},     {157, 142, 122},     {159, 140, 126},
    {162, 139, 130},     {164, 138, 134},     {166, 136, 138},     {169, 135, 142},
    {171, 133, 147},     {174, 132, 151},     {176, 131, 155},     {179, 129, 159},
    {181, 128, 163},     {184, 126, 167},     {186, 125, 171},     {189, 124, 175},
    {117, 164,  44},     {120, 163,  49},     {122, 161,  53},     {125, 160,  57},
    {127, 158,  61},     {129, 157,  65},     {132, 156,  69},     {134, 154,  73},
    {137, 153,  77},     {139, 152,  81},     {142, 150,  86},     {144, 149,  90},
    {147, 147,  94},     {149, 146,  98},     {152, 145, 102},     {154, 143, 106},
    {157, 142, 110},     {159, 140, 114},     {161, 139, 118},     {164, 138, 123},
    {166, 136, 127},     {169, 135, 131},     {171, 133, 135},     {174, 132, 139},
    {176, 131, 143},     {179, 129, 147},     {181, 128, 151},     {184, 126, 155},
    {186, 125, 160},     {189, 124, 164},     {191, 122, 168},     {193, 121, 172},
    {122, 161,  41},     {124, 160,  45},     {127, 159,  49},     {129, 157,  53},
    {132, 156,  57},     {134, 154,  62},     {137, 153,  66},     {139, 152,  70},
    {142, 150,  74},     {144, 149,  78},     {147, 147,  82},     {149, 146,  86},
    {152, 145,  90},     {154, 143,  94},     {156, 142,  99},     {159, 140, 103},
    {161, 139, 107},     {164, 138, 111},     {166, 136, 115},     {169, 135, 119},
    {171, 134, 123},     {174, 132, 127},     {176, 131, 131},     {179, 129, 136},
    {181, 128, 140},     {184, 127, 144},     {186, 125, 148},     {188, 124, 152},
    {191, 122, 156},     {193, 121, 160},     {196, 120, 164},     {198, 118, 168},
    {127, 159,  38},     {129, 157,  42},     {132, 156,  46},     {134, 154,  50},
    {137, 153,  54},     {139, 152,  58},     {142, 150,  62},     {144, 149,  66},
    {147, 147,  70},     {149, 146,  75},     {151, 145,  79},     {154, 143,  83},
    {156, 142,  87},     {159, 141,  91},     {161, 139,  95},     {164, 138,  99},
    {166, 136, 103},     {169, 135, 107},     {171, 134, 112},     {174, 132, 116},
    {176, 131, 120},     {179, 129, 124},     {181, 128, 128},     {183, 127, 132},
    {186, 125, 136},     {188, 124, 140},     {191, 122, 144},     {193, 121, 149},
    {196, 120, 153},     {198, 118, 157},     {201, 117, 161},     {203, 115, 165},
    {132, 156,  34},     {134, 154,  38},     {137, 153,  42},     {139, 152,  46},
    {142, 150,  51},     {144, 149,  55},     {146, 148,  59},     {149, 146,  63},
    {151, 145,  67},     {154, 143,  71},     {156, 142,  75},     {159, 141,  79},
    {161, 139,  83},     {164, 138,  88},     {166, 136,  92},     {169, 135,  96},
    {171, 134, 100},     {173, 132, 104},     {176, 131, 108},     {178, 129, 112},
    {181, 128, 116},     {183, 127, 120},     {186, 125, 125},     {188, 124, 129},
    {191, 122, 133},     {193, 121, 137},     {196, 120, 141},     {198, 118, 145},
    {201, 117, 149},     {203, 116, 153},     {205, 114, 157},     {208, 113, 162},
    {137, 153,  31},     {139, 152,  35},     {141, 150,  39},     {144, 149,  43},
    {146, 148,  47},     {149, 146,  51},     {151, 145,  55},     {154, 143,  59},
    {156, 142,  64},     {159, 141,  68},     {161, 139,  72},     {164, 138,  76},
    {166, 136,  80},     {168, 135,  84},     {171, 134,  88},     {173, 132,  92},
    {176, 131,  96},     {178, 130, 101},     {181, 128, 105},     {183, 127, 109},
    {186, 125, 113},     {188, 124, 117},     {191, 123, 121},     {193, 121, 125},
    {196, 120, 129},     {198, 118, 133},     {200, 117, 138},     {203, 116, 142},
    {205, 114, 146},     {208, 113, 150},     {210, 111, 154},     {213, 110, 158},
    {141, 150,  27},     {144, 149,  31},     {146, 148,  35},     {149, 146,  40},
    {151, 145,  44},     {154, 143,  48},     {156, 142,  52},     {159, 141,  56},
    {161, 139,  60},     {163, 138,  64},     {166, 137,  68},     {168, 135,  72},
    {171, 134,  77},     {173, 132,  81},     {176, 131,  85},     {178, 130,  89},
    {181, 128,  93},     {183, 127,  97},     {186, 125, 101},     {188, 124, 105},
    {191, 123, 109},     {193, 121, 114},     {195, 120, 118},     {198, 118, 122},
    {200, 117, 126},     {203, 116, 130},     {205, 114, 134},     {208, 113, 138},
    {210, 111, 142},     {213, 110, 146},     {215, 109, 151},     {218, 107, 155},
    {146, 148,  24},     {149, 146,  28},     {151, 145,  32},     {154, 144,  36},
    {156, 142,  40},     {158, 141,  44},     {161, 139,  48},     {163, 138,  53},
    {166, 137,  57},     {168, 135,  61},     {171, 134,  65},     {173, 132,  69},
    {176, 131,  73},     {178, 130,  77},     {181, 128,  81},     {183, 127,  85},
    {186, 125,  90},     {188, 124,  94},     {190, 123,  98},     {193, 121, 102},
    {195, 120, 106},     {198, 118, 110},     {200, 117, 114},     {203, 116, 118},
    {205, 114, 122},     {208, 113, 127},     {210, 112, 131},     {213, 110, 135},
    {215, 109, 139},     {217, 107, 143},     {220, 106, 147},     {222, 105, 151},
    {151, 145,  20},     {153, 144,  24},     {156, 142,  29},     {158, 141,  33},
    {161, 139,  37},     {163, 138,  41},     {166, 137,  45},     {168, 135,  49},
    {171, 134,  53},     {173, 132,  57},     {176, 131,  61},     {178, 130,  66},
    {181, 128,  70},     {183, 127,  74},     {185, 126,  78},     {188, 124,  82},
    {190, 123,  86},     {193, 121,  90},     {195, 120,  94},     {198, 119,  98},
    {200, 117, 103},     {203, 116, 107},     {205, 114, 111},     {208, 113, 115},
    {210, 112, 119},     {212, 110, 123},     {215, 109, 127},     {217, 107, 131},
    {220, 106, 135},     {222, 105, 140},     {225, 103, 144},     {227, 102, 148},
    {156, 142,  17},     {158, 141,  21},     {161, 139,  25},     {163, 138,  29},
    {166, 137,  33},     {168, 135,  37},     {171, 134,  42},     {173, 133,  46},
    {176, 131,  50},     {178, 130,  54},     {180, 128,  58},     {183, 127,  62},
    {185, 126,  66},     {188, 124,  70},     {190, 123,  74},     {193, 121,  79},
    {195, 120,  83},     {198, 119,  87},     {200, 117,  91},     {203, 116,  95},
    {205, 114,  99},     {207, 113, 103},     {210, 112, 107},     {212, 110, 111},
    {215, 109, 116},     {217, 107, 120},     {220, 106, 124},     {222, 105, 128},
    {225, 103, 132},     {227, 102, 136},     {230, 101, 140},     {232,  99, 144},
    {161, 140,  13},     {163, 138,  18},     {166, 137,  22},     {168, 135,  26},
    {170, 134,  30},     {173, 133,  34},     {175, 131,  38},     {178, 130,  42},
    {180, 128,  46},     {183, 127,  50},     {185, 126,  55},     {188, 124,  59},
    {190, 123,  63},     {193, 121,  67},     {195, 120,  71},     {198, 119,  75},
    {200, 117,  79},     {202, 116,  83},     {205, 115,  87},     {207, 113,  92},
    {210, 112,  96},     {212, 110, 100},     {215, 109, 104},     {217, 108, 108},
    {220, 106, 112},     {222, 105, 116},     {225, 103, 120},     {227, 102, 124},
    {230, 101, 129},     {232,  99, 133},     {234,  98, 137},     {237,  96, 141},
    {165, 137,  10},     {168, 135,  14},     {170, 134,  18},     {173, 133,  22},
    {175, 131,  26},     {178, 130,  31},     {180, 128,  35},     {183, 127,  39},
    {185, 126,  43},     {188, 124,  47},     {190, 123,  51},     {193, 122,  55},
    {195, 120,  59},     {197, 119,  63},     {200, 117,  68},     {202, 116,  72},
    {205, 115,  76},     {207, 113,  80},     {210, 112,  84},     {212, 110,  88},
    {215, 109,  92},     {217, 108,  96},     {220, 106, 100},     {222, 105, 105},
    {225, 103, 109},     {227, 102, 113},     {229, 101, 117},     {232,  99, 121},
    {234,  98, 125},     {237,  96, 129},     {239,  95, 133},     {242,  94, 137},
    {170, 134,   6},     {173, 133,  11},     {175, 131,  15},     {178, 130,  19},
    {180, 129,  23},     {183, 127,  27},     {185, 126,  31},     {188, 124,  35},
    {190, 123,  39},     {192, 122,  44},     {195, 120,  48},     {197, 119,  52},
    {200, 117,  56},     {202, 116,  60},     {205, 115,  64},     {207, 113,  68},
    {210, 112,  72},     {212, 110,  76},     {215, 109,  81},     {217, 108,  85},
    {220, 106,  89},     {222, 105,  93},     {224, 103,  97},     {227, 102, 101},
    {229, 101, 105},     {232,  99, 109},     {234,  98, 113},     {237,  97, 118},
    {239,  95, 122},     {242,  94, 126},     {244,  92, 130},     {247,  91, 134},
    { 22, 223, 113},     { 24, 221, 117},     { 26, 220, 121},     { 29, 218, 125},
    { 31, 217, 129},     { 34, 216, 133},     { 36, 214, 137},     { 39, 213, 141},
    { 41, 211, 146},     { 44, 210, 150},     { 46, 209, 154},     { 49, 207, 158},
    { 51, 206, 162},     { 54, 205, 166},     { 56, 203, 170},     { 58, 202, 174},
    { 61, 200, 178},     { 63, 199, 183},     { 66, 198, 187},     { 68, 196, 191},
    { 71, 195, 195},     { 73, 193, 199},     { 76, 192, 203},     { 78, 191, 207},
    { 81, 189, 211},     { 83, 188, 215},     { 86, 186, 220},     { 88, 185, 224},
    { 90, 184, 228},     { 93, 182, 232},     { 95, 181, 236},     { 98, 180, 240},
    { 26, 220, 109},     { 29, 218, 113},     { 31, 217, 117},     { 34, 216, 122},
    { 36, 214, 126},     { 39, 213, 130},     { 41, 212, 134},     { 44, 210, 138},
    { 46, 209, 142},     { 49, 207, 146},     { 51, 206, 150},     { 53, 205, 154},
    { 56, 203, 159},     { 58, 202, 163},     { 61, 200, 167},     { 63, 199, 171},
    { 66, 198, 175},     { 68, 196, 179},     { 71, 195, 183},     { 73, 193, 187},
    { 76, 192, 191},     { 78, 191, 196},     { 81, 189, 200},     { 83, 188, 204},
    { 85, 187, 208},     { 88, 185, 212},     { 90, 184, 216},     { 93, 182, 220},
    { 95, 181, 224},     { 98, 180, 229},     {100, 178, 233},     {103, 177, 237},
    { 31, 217, 106},     { 34, 216, 110},     { 36, 214, 114},     { 39, 213, 118},
    { 41, 212, 122},     { 44, 210, 126},     { 46, 209, 130},     { 48, 207, 135},
    { 51, 206, 139},     { 53, 205, 143},     { 56, 203, 147},     { 58, 202, 151},
    { 61, 200, 155},     { 63, 199, 159},     { 66, 198, 163},     { 68, 196, 167},
    { 71, 195, 172},     { 73, 194, 176},     { 75, 192, 180},     { 78, 191, 184},
    { 80, 189, 188},     { 83, 188, 192},     { 85, 187, 196},     { 88, 185, 200},
    { 90, 184, 204},     { 93, 182, 209},     { 95, 181, 213},     { 98, 180, 217},
    {100, 178, 221},     {103, 177, 225},     {105, 175, 229},     {107, 174, 233},
    { 36, 214, 102},     { 39, 213, 106},     { 41, 212, 111},     { 43, 210, 115},
    { 46, 209, 119},     { 48, 207, 123},     { 51, 206, 127},     { 53, 205, 131},
    { 56, 203, 135},     { 58, 202, 139},     { 61, 201, 143},     { 63, 199, 148},
    { 66, 198, 152},     { 68, 196, 156},     { 70, 195, 160},     { 73, 194, 164},
    { 75, 192, 168},     { 78, 191, 172},     { 80, 189, 176},     { 83, 188, 180},
    { 85, 187, 185},     { 88, 185, 189},     { 90, 184, 193},     { 93, 182, 197},
    { 95, 181, 201},     { 98, 180, 205},     {100, 178, 209},     {102, 177, 213},
    {105, 176, 217},     {107, 174, 222},     {110, 173, 226},     {112, 171, 230},
    { 41, 212,  99},     { 43, 210, 103},     { 46, 209, 107},     { 48, 208, 111},
    { 51, 206, 115},     { 53, 205, 119},     { 56, 203, 124},     { 58, 202, 128},
    { 61, 201, 132},     { 63, 199, 136},     { 65, 198, 140},     { 68, 196, 144},
    { 70, 195, 148},     { 73, 194, 152},     { 75, 192, 156},     { 78, 191, 161},
    { 80, 189, 165},     { 83, 188, 169},     { 85, 187, 173},     { 88, 185, 177},
    { 90, 184, 181},     { 93, 183, 185},     { 95, 181, 189},     { 97, 180, 193},
    {100, 178, 198},     {102, 177, 202},     {105, 176, 206},     {107, 174, 210},
    {110, 173, 214},     {112, 171, 218},     {115, 170, 222},     {117, 169, 226},
    { 46, 209,  95},     { 48, 208, 100},     { 51, 206, 104},     { 53, 205, 108},
    { 56, 203, 112},     { 58, 202, 116},     { 60, 201, 120},     { 63, 199, 124},
    { 65, 198, 128},     { 68, 196, 132},     { 70, 195, 137},     { 73, 194, 141},
    { 75, 192, 145},     { 78, 191, 149},     { 80, 190, 153},     { 83, 188, 157},
    { 85, 187, 161},     { 88, 185, 165},     { 90, 184, 169},     { 92, 183, 174},
    { 95, 181, 178},     { 97, 180, 182},     {100, 178, 186},     {102, 177, 190},
    {105, 176, 194},     {107, 174, 198},     {110, 173, 202},     {112, 171, 206},
    {115, 170, 211},     {117, 169, 215},     {119, 167, 219},     {122, 166, 223},
    { 51, 206,  92},     { 53, 205,  96},     { 55, 203, 100},     { 58, 202, 104},
    { 60, 201, 108},     { 63, 199, 113},     { 65, 198, 117},     { 68, 197, 121},
    { 70, 195, 125},     { 73, 194, 129},     { 75, 192, 133},     { 78, 191, 137},
    { 80, 190, 141},     { 83, 188, 145},     { 85, 187, 150},     { 87, 185, 154},
    { 90, 184, 158},     { 92, 183, 162},     { 95, 181, 166},     { 97, 180, 170},
    {100, 178, 174},     {102, 177, 178},     {105, 176, 182},     {107, 174, 187},
    {110, 173, 191},     {112, 172, 195},     {114, 170, 199},     {117, 169, 203},
    {119, 167, 207},     {122, 166, 211},     {124, 165, 215},     {127, 163, 219},
    { 55, 204,  89},     { 58, 202,  93},     { 60, 201,  97},     { 63, 199, 101},
    { 65, 198, 105},     { 68, 197, 109},     { 70, 195, 113},     { 73, 194, 117},
    { 75, 192, 121},     { 78, 191, 126},     { 80, 190, 130},     { 82, 188, 134},
    { 85, 187, 138},     { 87, 185, 142},     { 90, 184, 146},     { 92, 183, 150},
    { 95, 181, 154},     { 97, 180, 158},     {100, 179, 163},     {102, 177, 167},
    {105, 176, 171},     {107, 174, 175},     {109, 173, 179},     {112, 172, 183},
    {114, 170, 187},     {117, 169, 191},     {119, 167, 195},     {122, 166, 200},
    {124, 165, 204},     {127, 163, 208},     {129, 162, 212},     {132, 160, 216},
    { 60, 201,  85},     { 63, 199,  89},     { 65, 198,  93},     { 68, 197,  97},
    { 70, 195, 102},     { 72, 194, 106},     { 75, 192, 110},     { 77, 191, 114},
    { 80, 190, 118},     { 82, 188, 122},     { 85, 187, 126},     { 87, 186, 130},
    { 90, 184, 134},     { 92, 183, 139},     { 95, 181, 143},     { 97, 180, 147},
    {100, 179, 151},     {102, 177, 155},     {104, 176, 159},     {107, 174, 163},
    {109, 173, 167},     {112, 172, 171},     {114, 170, 176},     {117, 169, 180},
    {119, 167, 184},     {122, 166, 188},     {124, 165, 192},     {127, 163, 196},
    {129, 162, 200},     {132, 161, 204},     {134, 159, 208},     {136, 158, 213},
    { 65, 198,  82},     { 67, 197,  86},     { 70, 195,  90},     { 72, 194,  94},
    { 75, 193,  98},     { 77, 191, 102},     { 80, 190, 106},     { 82, 188, 110},
    { 85, 187, 115},     { 87, 186, 119},     { 90, 184, 123},     { 92, 183, 127},
    { 95, 181, 131},     { 97, 180, 135},     { 99, 179, 139},     {102, 177, 143},
    {104, 176, 147},     {107, 174, 152},     {109, 173, 156},     {112, 172, 160},
    {114, 170, 164},     {117, 169, 168},     {119, 168, 172},     {122, 166, 176},
    {124, 165, 180},     {127, 163, 184},     {129, 162, 189},     {131, 161, 193},
    {134, 159, 197},     {136, 158, 201},     {139, 156, 205},     {141, 155, 209},
    { 70, 195,  78},     { 72, 194,  82},     { 75, 193,  86},     { 77, 191,  91},
    { 80, 190,  95},     { 82, 188,  99},     { 85, 187, 103},     { 87, 186, 107},
    { 90, 184, 111},     { 92, 183, 115},     { 94, 181, 119},     { 97, 180, 123},
    { 99, 179, 128},     {102, 177, 132},     {104, 176, 136},     {107, 175, 140},
    {109, 173, 144},     {112, 172, 148},     {114, 170, 152},     {117, 169, 156},
    {119, 168, 160},     {122, 166, 165},     {124, 165, 169},     {126, 163, 173},
    {129, 162, 177},     {131, 161, 181},     {134, 159, 185},     {136, 158, 189},
    {139, 156, 193},     {141, 155, 197},     {144, 154, 202},     {146, 152, 206},
    { 75, 193,  75},     { 77, 191,  79},     { 80, 190,  83},     { 82, 188,  87},
    { 85, 187,  91},     { 87, 186,  95},     { 89, 184,  99},     { 92, 183, 104},
    { 94, 182, 108},     { 97, 180, 112},     { 99, 179, 116},     {102, 177, 120},
    {104, 176, 124},     {107, 175, 128},     {109, 173, 132},     {112, 172, 136},
    {114, 170, 141},     {116, 169, 145},     {119, 168, 149},     {121, 166, 153},
    {124, 165, 157},     {126, 163, 161},     {129, 162, 165},     {131, 161, 169},
    {134, 159, 173},     {136, 158, 178},     {139, 157, 182},     {141, 155, 186},
    {144, 154, 190},     {146, 152, 194},     {148, 151, 198},     {151, 150, 202},
    { 80, 190,  71},     { 82, 189,  75},     { 84, 187,  80},     { 87, 186,  84},
    { 89, 184,  88},     { 92, 183,  92},     { 94, 182,  96},     { 97, 180, 100},
    { 99, 179, 104},     {102, 177, 108},     {104, 176, 112},     {107, 175, 117},
    {109, 173, 121},     {111, 172, 125},     {114, 170, 129},     {116, 169, 133},
    {119, 168, 137},     {121, 166, 141},     {124, 165, 145},     {126, 164, 149},
    {129, 162, 154},     {131, 161, 158},     {134, 159, 162},     {136, 158, 166},
    {139, 157, 170},     {141, 155, 174},     {143, 154, 178},     {146, 152, 182},
    {148, 151, 186},     {151, 150, 191},     {153, 148, 195},     {156, 147, 199},
    { 84, 187,  68},     { 87, 186,  72},     { 89, 184,  76},     { 92, 183,  80},
    { 94, 182,  84},     { 97, 180,  88},     { 99, 179,  93},     {102, 177,  97},
    {104, 176, 101},     {106, 175, 105},     {109, 173, 109},     {111, 172, 113},
    {114, 171, 117},     {116, 169, 121},     {119, 168, 125},     {121, 166, 130},
    {124, 165, 134},     {126, 164, 138},     {129, 162, 142},     {131, 161, 146},
    {134, 159, 150},     {136, 158, 154},     {138, 157, 158},     {141, 155, 162},
    {143, 154, 167},     {146, 152, 171},     {148, 151, 175},     {151, 150, 179},
    {153, 148, 183},     {156, 147, 187},     {158, 145, 191},     {161, 144, 195},
    { 89, 184,  64},     { 92, 183,  69},     { 94, 182,  73},     { 97, 180,  77},
    { 99, 179,  81},     {101, 178,  85},     {104, 176,  89},     {106, 175,  93},
    {109, 173,  97},     {111, 172, 101},     {114, 171, 106},     {116, 169, 110},
    {119, 168, 114},     {121, 166, 118},     {124, 165, 122},     {126, 164, 126},
    {129, 162, 130},     {131, 161, 134},     {133, 159, 138},     {136, 158, 143},
    {138, 157, 147},     {141, 155, 151},     {143, 154, 155},     {146, 153, 159},
    {148, 151, 163},     {151, 150, 167},     {153, 148, 171},     {156, 147, 175},
    {158, 146, 180},     {160, 144, 184},     {163, 143, 188},     {165, 141, 192},
    { 94, 182,  61},     { 96, 180,  65},     { 99, 179,  69},     {101, 178,  73},
    {104, 176,  77},     {106, 175,  82},     {109, 173,  86},     {111, 172,  90},
    {114, 171,  94},     {116, 169,  98},     {119, 168, 102},     {121, 166, 106},
    {124, 165, 110},     {126, 164, 114},     {128, 162, 119},     {131, 161, 123},
    {133, 160, 127},     {136, 158, 131},     {138, 157, 135},     {141, 155, 139},
    {143, 154, 143},     {146, 153, 147},     {148, 151, 151},     {151, 150, 156},
    {153, 148, 160},     {155, 147, 164},     {158, 146, 168},     {160, 144, 172},
    {163, 143, 176},     {165, 141, 180},     {168, 140, 184},     {170, 139, 188},
    { 99, 179,  58},     {101, 178,  62},     {104, 176,  66},     {106, 175,  70},
    {109, 173,  74},     {111, 172,  78},     {114, 171,  82},     {116, 169,  86},
    {119, 168,  90},     {121, 167,  95},     {123, 165,  99},     {126, 164, 103},
    {128, 162, 107},     {131, 161, 111},     {133, 160, 115},     {136, 158, 119},
    {138, 157, 123},     {141, 155, 127},     {143, 154, 132},     {146, 153, 136},
    {148, 151, 140},     {150, 150, 144},     {153, 148, 148},     {155, 147, 152},
    {158, 146, 156},     {160, 144, 160},     {163, 143, 164},     {165, 141, 169},
    {168, 140, 173},     {170, 139, 177},     {173, 137, 181},     {175, 136, 185},
    {104, 176,  54},     {106, 175,  58},     {109, 174,  62},     {111, 172,  66},
    {113, 171,  71},     {116, 169,  75},     {118, 168,  79},     {121, 167,  83},
    {123, 165,  87},     {126, 164,  91},     {128, 162,  95},     {131, 161,  99},
    {133, 160, 103},     {136, 158, 108},     {138, 157, 112},     {141, 155, 116},
    {143, 154, 120},     {145, 153, 124},     {148, 151, 128},     {150, 150, 132},
    {153, 149, 136},     {155, 147, 140},     {158, 146, 145},     {160, 144, 149},
    {163, 143, 153},     {165, 142, 157},     {168, 140, 161},     {170, 139, 165},
    {173, 137, 169},     {175, 136, 173},     {177, 135, 177},     {180, 133, 182},
    {108, 174,  51},     {111, 172,  55},     {113, 171,  59},     {116, 169,  63},
    {118, 168,  67},     {121, 167,  71},     {123, 165,  75},     {126, 164,  79},
    {128, 162,  84},     {131, 161,  88},     {133, 160,  92},     {136, 158,  96},
    {138, 157, 100},     {140, 156, 104},     {143, 154, 108},     {145, 153, 112},
    {148, 151, 116},     {150, 150, 121},     {153, 149, 125},     {155, 147, 129},
    {158, 146, 133},     {160, 144, 137},     {163, 143, 141},     {165, 142, 145},
    {168, 140, 149},     {170, 139, 153},     {172, 137, 158},     {175, 136, 162},
    {177, 135, 166},     {180, 133, 170},     {182, 132, 174},     {185, 130, 178},
    {113, 171,  47},     {116, 169,  51},     {118, 168,  55},     {121, 167,  60},
    {123, 165,  64},     {126, 164,  68},     {128, 163,  72},     {131, 161,  76},
    {133, 160,  80},     {135, 158,  84},     {138, 157,  88},     {140, 156,  92},
    {143, 154,  97},     {145, 153, 101},     {148, 151, 105},     {150, 150, 109},
    {153, 149, 113},     {155, 147, 117},     {158, 146, 121},     {160, 144, 125},
    {163, 143, 129},     {165, 142, 134},     {167, 140, 138},     {170, 139, 142},
    {172, 138, 146},     {175, 136, 150},     {177, 135, 154},     {180, 133, 158},
    {182, 132, 162},     {185, 131, 166},     {187, 129, 171},     {190, 128, 175},
    {118, 168,  44},     {121, 167,  48},     {123, 165,  52},     {126, 164,  56},
    {128, 163,  60},     {130, 161,  64},     {133, 160,  68},     {135, 158,  73},
    {138, 157,  77},     {140, 156,  81},     {143, 154,  85},     {145, 153,  89},
    {148, 151,  93},     {150, 150,  97},     {153, 149, 101},     {155, 147, 105},
    {157, 146, 110},     {160, 145, 114},     {162, 143, 118},     {165, 142, 122},
    {167, 140, 126},     {170, 139, 130},     {172, 138, 134},     {175, 136, 138},
    {177, 135, 142},     {180, 133, 147},     {182, 132, 151},     {185, 131, 155},
    {187, 129, 159},     {189, 128, 163},     {192, 126, 167},     {194, 125, 171},
    {123, 165,  40},     {125, 164,  44},     {128, 163,  49},     {130, 161,  53},
    {133, 160,  57},     {135, 158,  61},     {138, 157,  65},     {140, 156,  69},
    {143, 154,  73},     {145, 153,  77},     {148, 152,  81},     {150, 150,  86},
    {152, 149,  90},     {155, 147,  94},     {157, 146,  98},     {160, 145, 102},
    {162, 143, 106},     {165, 142, 110},     {167, 140, 114},     {170, 139, 118},
    {172, 138, 123},     {175, 136, 127},     {177, 135, 131},     {180, 133, 135},
    {182, 132, 139},     {184, 131, 143},     {187, 129, 147},     {189, 128, 151},
    {192, 126, 155},     {194, 125, 160},     {197, 124, 164},     {199, 122, 168},
    {128, 163,  37},     {130, 161,  41},     {133, 160,  45},     {135, 159,  49},
    {138, 157,  53},     {140, 156,  57},     {143, 154,  62},     {145, 153,  66},
    {147, 152,  70},     {150, 150,  74},     {152, 149,  78},     {155, 147,  82},
    {157, 146,  86},     {160, 145,  90},     {162, 143,  94},     {165, 142,  99},
    {167, 140, 103},     {170, 139, 107},     {172, 138, 111},     {175, 136, 115},
    {177, 135, 119},     {179, 134, 123},     {182, 132, 127},     {184, 131, 131},
    {187, 129, 136},     {189, 128, 140},     {192, 127, 144},     {194, 125, 148},
    {197, 124, 152},     {199, 122, 156},     {202, 121, 160},     {204, 120, 164},
    {133, 160,  33},     {135, 159,  38},     {138, 157,  42},     {140, 156,  46},
    {142, 154,  50},     {145, 153,  54},     {147, 152,  58},     {150, 150,  62},
    {152, 149,  66},     {155, 147,  70},     {157, 146,  75},     {160, 145,  79},
    {162, 143,  83},     {165, 142,  87},     {167, 141,  91},     {170, 139,  95},
    {172, 138,  99},     {174, 136, 103},     {177, 135, 107},     {179, 134, 112},
    {182, 132, 116},     {184, 131, 120},     {187, 129, 124},     {189, 128, 128},
    {192, 127, 132},     {194, 125, 136},     {197, 124, 140},     {199, 122, 144},
    {201, 121, 149},     {204, 120, 153},     {206, 118, 157},     {209, 117, 161},
    {137, 157,  30},     {140, 156,  34},     {142, 154,  38},     {145, 153,  42},
    {147, 152,  46},     {150, 150,  51},     {152, 149,  55},     {155, 148,  59},
    {157, 146,  63},     {160, 145,  67},     {162, 143,  71},     {165, 142,  75},
    {167, 141,  79},     {169, 139,  83},     {172, 138,  88},     {174, 136,  92},
    {177, 135,  96},     {179, 134, 100},     {182, 132, 104},     {184, 131, 108},
    {187, 129, 112},     {189, 128, 116},     {192, 127, 120},     {194, 125, 125},
    {196, 124, 129},     {199, 122, 133},     {201, 121, 137},     {204, 120, 141},
    {206, 118, 145},     {209, 117, 149},     {211, 116, 153},     {214, 114, 157},
    {142, 155,  27},     {145, 153,  31},     {147, 152,  35},     {150, 150,  39},
    {152, 149,  43},     {155, 148,  47},     {157, 146,  51},     {159, 145,  55},
    {162, 143,  59},     {164, 142,  64},     {167, 141,  68},     {169, 139,  72},
    {172, 138,  76},     {174, 136,  80},     {177, 135,  84},     {179, 134,  88},
    {182, 132,  92},     {184, 131,  96},     {187, 130, 101},     {189, 128, 105},
    {191, 127, 109},     {194, 125, 113},     {196, 124, 117},     {199, 123, 121},
    {201, 121, 125},     {204, 120, 129},     {206, 118, 133},     {209, 117, 138},
    {211, 116, 142},     {214, 114, 146},     {216, 113, 150},     {219, 111, 154},
    {147, 152,  23},     {150, 150,  27},     {152, 149,  31},     {154, 148,  35},
    {157, 146,  40},     {159, 145,  44},     {162, 143,  48},     {164, 142,  52},
    {167, 141,  56},     {169, 139,  60},     {172, 138,  64},     {174, 137,  68},
    {177, 135,  72},     {179, 134,  77},     {182, 132,  81},     {184, 131,  85},
    {186, 130,  89},     {189, 128,  93},     {191, 127,  97},     {194, 125, 101},
    {196, 124, 105},     {199, 123, 109},     {201, 121, 114},     {204, 120, 118},
    {206, 118, 122},     {209, 117, 126},     {211, 116, 130},     {214, 114, 134},
    {216, 113, 138},     {218, 111, 142},     {221, 110, 146},     {223, 109, 151},
    {152, 149,  20},     {154, 148,  24},     {157, 146,  28},     {159, 145,  32},
    {162, 144,  36},     {164, 142,  40},     {167, 141,  44},     {169, 139,  48},
    {172, 138,  53},     {174, 137,  57},     {177, 135,  61},     {179, 134,  65},
    {181, 132,  69},     {184, 131,  73},     {186, 130,  77},     {189, 128,  81},
    {191, 127,  85},     {194, 125,  90},     {196, 124,  94},     {199, 123,  98},
    {201, 121, 102},     {204, 120, 106},     {206, 118, 110},     {209, 117, 114},
    {211, 116, 118},     {213, 114, 122},     {216, 113, 127},     {218, 112, 131},
    {221, 110, 135},     {223, 109, 139},     {226, 107, 143},     {228, 106, 147},
    {157, 146,  16},     {159, 145,  20},     {162, 144,  24},     {164, 142,  29},
    {167, 141,  33},     {169, 139,  37},     {172, 138,  41},     {174, 137,  45},
    {176, 135,  49},     {179, 134,  53},     {181, 132,  57},     {184, 131,  61},
    {186, 130,  66},     {189, 128,  70},     {191, 127,  74},     {194, 126,  78},
    {196, 124,  82},     {199, 123,  86},     {201, 121,  90},     {203, 120,  94},
    {206, 119,  98},     {208, 117, 103},     {211, 116, 107},     {213, 114, 111},
    {216, 113, 115},     {218, 112, 119},     {221, 110, 123},     {223, 109, 127},
    {226, 107, 131},     {228, 106, 135},     {231, 105, 140},     {233, 103, 144},
    {162, 144,  13},     {164, 142,  17},     {167, 141,  21},     {169, 139,  25},
    {171, 138,  29},     {174, 137,  33},     {176, 135,  37},     {179, 134,  42},
    {181, 133,  46},     {184, 131,  50},     {186, 130,  54},     {189, 128,  58},
    {191, 127,  62},     {194, 126,  66},     {196, 124,  70},     {198, 123,  74},
    {201, 121,  79},     {203, 120,  83},     {206, 119,  87},     {208, 117,  91},
    {211, 116,  95},     {213, 114,  99},     {216, 113, 103},     {218, 112, 107},
    {221, 110, 111},     {223, 109, 116},     {226, 107, 120},     {228, 106, 124},
    {230, 105, 128},     {233, 103, 132},     {235, 102, 136},     {238, 101, 140},
    {166, 141,   9},     {169, 140,  13},     {171, 138,  18},     {174, 137,  22},
    {176, 135,  26},     {179, 134,  30},     {181, 133,  34},     {184, 131,  38},
    {186, 130,  42},     {189, 128,  46},     {191, 127,  50},     {193, 126,  55},
    {196, 124,  59},     {198, 123,  63},     {201, 121,  67},     {203, 120,  71},
    {206, 119,  75},     {208, 117,  79},     {211, 116,  83},     {213, 115,  87},
    {216, 113,  92},     {218, 112,  96},     {221, 110, 100},     {223, 109, 104},
    {225, 108, 108},     {228, 106, 112},     {230, 105, 116},     {233, 103, 120},
    {235, 102, 124},     {238, 101, 129},     {240,  99, 133},     {243,  98, 137},
    {171, 138,   6},     {174, 137,  10},     {176, 135,  14},     {179, 134,  18},
    {181, 133,  22},     {184, 131,  26},     {186, 130,  31},     {188, 128,  35},
    {191, 127,  39},     {193, 126,  43},     {196, 124,  47},     {198, 123,  51},
    {201, 122,  55},     {203, 120,  59},     {206, 119,  63},     {208, 117,  68},
    {211, 116,  72},     {213, 115,  76},     {216, 113,  80},     {218, 112,  84},
    {220, 110,  88},     {223, 109,  92},     {225, 108,  96},     {228, 106, 100},
    {230, 105, 105},     {233, 103, 109},     {235, 102, 113},     {238, 101, 117},
    {240,  99, 121},     {243,  98, 125},     {245,  96, 129},     {247,  95, 133},
    { 23, 227, 112},     { 25, 225, 116},     { 27, 224, 120},     { 30, 223, 124},
    { 32, 221, 128},     { 35, 220, 133},     { 37, 218, 137},     { 40, 217, 141},
    { 42, 216, 145},     { 45, 214, 149},     { 47, 213, 153},     { 50, 211, 157},
    { 52, 210, 161},     { 54, 209, 165},     { 57, 207, 170},     { 59, 206, 174},
    { 62, 204, 178},     { 64, 203, 182},     { 67, 202, 186},     { 69, 200, 190},
    { 72, 199, 194},     { 74, 198, 198},     { 77, 196, 202},     { 79, 195, 207},
    { 82, 193, 211},     { 84, 192, 215},     { 86, 191, 219},     { 89, 189, 223},
    { 91, 188, 227},     { 94, 186, 231},     { 96, 185, 235},     { 99, 184, 240},
    { 27, 224, 109},     { 30, 223, 113},     { 32, 221, 117},     { 35, 220, 121},
    { 37, 218, 125},     { 40, 217, 129},     { 42, 216, 133},     { 45, 214, 137},
    { 47, 213, 141},     { 49, 211, 146},     { 52, 210, 150},     { 54, 209, 154},
    { 57, 207, 158},     { 59, 206, 162},     { 62, 205, 166},     { 64, 203, 170},
    { 67, 202, 174},     { 69, 200, 178},     { 72, 199, 183},     { 74, 198, 187},
    { 77, 196, 191},     { 79, 195, 195},     { 81, 193, 199},     { 84, 192, 203},
    { 86, 191, 207},     { 89, 189, 211},     { 91, 188, 215},     { 94, 186, 220},
    { 96, 185, 224},     { 99, 184, 228},     {101, 182, 232},     {104, 181, 236},
    { 32, 221, 105},     { 35, 220, 109},     { 37, 218, 113},     { 40, 217, 117},
    { 42, 216, 122},     { 44, 214, 126},     { 47, 213, 130},     { 49, 212, 134},
    { 52, 210, 138},     { 54, 209, 142},     { 57, 207, 146},     { 59, 206, 150},
    { 62, 205, 154},     { 64, 203, 159},     { 67, 202, 163},     { 69, 200, 167},
    { 72, 199, 171},     { 74, 198, 175},     { 76, 196, 179},     { 79, 195, 183},
    { 81, 193, 187},     { 84, 192, 191},     { 86, 191, 196},     { 89, 189, 200},
    { 91, 188, 204},     { 94, 187, 208},     { 96, 185, 212},     { 99, 184, 216},
    {101, 182, 220},     {103, 181, 224},     {106, 180, 229},     {108, 178, 233},
    { 37, 219, 102},     { 39, 217, 106},     { 42, 216, 110},     { 44, 214, 114},
    { 47, 213, 118},     { 49, 212, 122},     { 52, 210, 126},     { 54, 209, 130},
    { 57, 207, 135},     { 59, 206, 139},     { 62, 205, 143},     { 64, 203, 147},
    { 67, 202, 151},     { 69, 200, 155},     { 71, 199, 159},     { 74, 198, 163},
    { 76, 196, 167},     { 79, 195, 172},     { 81, 194, 176},     { 84, 192, 180},
    { 86, 191, 184},     { 89, 189, 188},     { 91, 188, 192},     { 94, 187, 196},
    { 96, 185, 200},     { 98, 184, 204},     {101, 182, 209},     {103, 181, 213},
    {106, 180, 217},     {108, 178, 221},     {111, 177, 225},     {113, 175, 229},
    { 42, 216,  98},     { 44, 214, 102},     { 47, 213, 106},     { 49, 212, 111},
    { 52, 210, 115},     { 54, 209, 119},     { 57, 207, 123},     { 59, 206, 127},
    { 61, 205, 131},     { 64, 203, 135},     { 66, 202, 139},     { 69, 201, 143},
    { 71, 199, 148},     { 74, 198, 152},     { 76, 196, 156},     { 79, 195, 160},
    { 81, 194, 164},     { 84, 192, 168},     { 86, 191, 172},     { 89, 189, 176},
    { 91, 188, 180},     { 93, 187, 185},     { 96, 185, 189},     { 98, 184, 193},
    {101, 182, 197},     {103, 181, 201},     {106, 180, 205},     {108, 178, 209},
    {111, 177, 213},     {113, 176, 217},     {116, 174, 222},     {118, 173, 226},
    { 47, 213,  95},     { 49, 212,  99},     { 52, 210, 103},     { 54, 209, 107},
    { 56, 208, 111},     { 59, 206, 115},     { 61, 205, 119},     { 64, 203, 124},
    { 66, 202, 128},     { 69, 201, 132},     { 71, 199, 136},     { 74, 198, 140},
    { 76, 196, 144},     { 79, 195, 148},     { 81, 194, 152},     { 84, 192, 156},
    { 86, 191, 161},     { 88, 189, 165},     { 91, 188, 169},     { 93, 187, 173},
    { 96, 185, 177},     { 98, 184, 181},     {101, 183, 185},     {103, 181, 189},
    {106, 180, 193},     {108, 178, 198},     {111, 177, 202},     {113, 176, 206},
    {116, 174, 210},     {118, 173, 214},     {120, 171, 218},     {123, 170, 222},
    { 51, 210,  91},     { 54, 209,  95},     { 56, 208, 100},     { 59, 206, 104},
    { 61, 205, 108},     { 64, 203, 112},     { 66, 202, 116},     { 69, 201, 120},
    { 71, 199, 124},     { 74, 198, 128},     { 76, 196, 132},     { 79, 195, 137},
    { 81, 194, 141},     { 83, 192, 145},     { 86, 191, 149},     { 88, 190, 153},
    { 91, 188, 157},     { 93, 187, 161},     { 96, 185, 165},     { 98, 184, 169},
    {101, 183, 174},     {103, 181, 178},     {106, 180, 182},     {108, 178, 186},
    {111, 177, 190},     {113, 176, 194},     {115, 174, 198},     {118, 173, 202},
    {120, 171, 206},     {123, 170, 211},     {125, 169, 215},     {128, 167, 219},
    { 56, 208,  88},     { 59, 206,  92},     { 61, 205,  96},     { 64, 203, 100},
    { 66, 202, 104},     { 69, 201, 108},     { 71, 199, 113},     { 74, 198, 117},
    { 76, 197, 121},     { 78, 195, 125},     { 81, 194, 129},     { 83, 192, 133},
    { 86, 191, 137},     { 88, 190, 141},     { 91, 188, 145},     { 93, 187, 150},
    { 96, 185, 154},     { 98, 184, 158},     {101, 183, 162},     {103, 181, 166},
    {105, 180, 170},     {108, 178, 174},     {110, 177, 178},     {113, 176, 182},
    {115, 174, 187},     {118, 173, 191},     {120, 172, 195},     {123, 170, 199},
    {125, 169, 203},     {128, 167, 207},     {130, 166, 211},     {133, 165, 215},
    { 61, 205,  84},     { 64, 204,  89},     { 66, 202,  93},     { 69, 201,  97},
    { 71, 199, 101},     { 73, 198, 105},     { 76, 197, 109},     { 78, 195, 113},
    { 81, 194, 117},     { 83, 192, 121},     { 86, 191, 126},     { 88, 190, 130},
    { 91, 188, 134},     { 93, 187, 138},     { 96, 185, 142},     { 98, 184, 146},
    {100, 183, 150},     {103, 181, 154},     {105, 180, 158},     {108, 179, 163},
    {110, 177, 167},     {113, 176, 171},     {115, 174, 175},     {118, 173, 179},
    {120, 172, 183},     {123, 170, 187},     {125, 169, 191},     {128, 167, 195},
    {130, 166, 200},     {132, 165, 204},     {135, 163, 208},     {137, 162, 212},
    { 66, 202,  81},     { 68, 201,  85},     { 71, 199,  89},     { 73, 198,  93},
    { 76, 197,  97},     { 78, 195, 102},     { 81, 194, 106},     { 83, 192, 110},
    { 86, 191, 114},     { 88, 190, 118},     { 91, 188, 122},     { 93, 187, 126},
    { 95, 186, 130},     { 98, 184, 134},     {100, 183, 139},     {103, 181, 143},
    {105, 180, 147},     {108, 179, 151},     {110, 177, 155},     {113, 176, 159},
    {115, 174, 163},     {118, 173, 167},     {120, 172, 171},     {123, 170, 176},
    {125, 169, 180},     {127, 167, 184},     {130, 166, 188},     {132, 165, 192},
    {135, 163, 196},     {137, 162, 200},     {140, 161, 204},     {142, 159, 208},
    { 71, 199,  78},     { 73, 198,  82},     { 76, 197,  86},     { 78, 195,  90},
    { 81, 194,  94},     { 83, 193,  98},     { 86, 191, 102},     { 88, 190, 106},
    { 90, 188, 110},     { 93, 187, 115},     { 95, 186, 119},     { 98, 184, 123},
    {100, 183, 127},     {103, 181, 131},     {105, 180, 135},     {108, 179, 139},
    {110, 177, 143},     {113, 176, 147},     {115, 174, 152},     {118, 173, 156},
    {120, 172, 160},     {122, 170, 164},     {125, 169, 168},     {127, 168, 172},
    {130, 166, 176},     {132, 165, 180},     {135, 163, 184},     {137, 162, 189},
    {140, 161, 193},     {142, 159, 197},     {145, 158, 201},     {147, 156, 205},
    { 76, 197,  74},     { 78, 195,  78},     { 81, 194,  82},     { 83, 193,  86},
    { 85, 191,  91},     { 88, 190,  95},     { 90, 188,  99},     { 93, 187, 103},
    { 95, 186, 107},     { 98, 184, 111},     {100, 183, 115},     {103, 181, 119},
    {105, 180, 123},     {108, 179, 128},     {110, 177, 132},     {113, 176, 136},
    {115, 175, 140},     {117, 173, 144},     {120, 172, 148},     {122, 170, 152},
    {125, 169, 156},     {127, 168, 160},     {130, 166, 165},     {132, 165, 169},
    {135, 163, 173},     {137, 162, 177},     {140, 161, 181},     {142, 159, 185},
    {144, 158, 189},     {147, 156, 193},     {149, 155, 197},     {152, 154, 202},
    { 80, 194,  71},     { 83, 193,  75},     { 85, 191,  79},     { 88, 190,  83},
    { 90, 188,  87},     { 93, 187,  91},     { 95, 186,  95},     { 98, 184,  99},
    {100, 183, 104},     {103, 182, 108},     {105, 180, 112},     {108, 179, 116},
    {110, 177, 120},     {112, 176, 124},     {115, 175, 128},     {117, 173, 132},
    {120, 172, 136},     {122, 170, 141},     {125, 169, 145},     {127, 168, 149},
    {130, 166, 153},     {132, 165, 157},     {135, 163, 161},     {137, 162, 165},
    {139, 161, 169},     {142, 159, 173},     {144, 158, 178},     {147, 157, 182},
    {149, 155, 186},     {152, 154, 190},     {154, 152, 194},     {157, 151, 198},
    { 85, 191,  67},     { 88, 190,  71},     { 90, 189,  75},     { 93, 187,  80},
    { 95, 186,  84},     { 98, 184,  88},     {100, 183,  92},     {102, 182,  96},
    {105, 180, 100},     {107, 179, 104},     {110, 177, 108},     {112, 176, 112},
    {115, 175, 117},     {117, 173, 121},     {120, 172, 125},     {122, 170, 129},
    {125, 169, 133},     {127, 168, 137},     {130, 166, 141},     {132, 165, 145},
    {134, 164, 149},     {137, 162, 154},     {139, 161, 158},     {142, 159, 162},
    {144, 158, 166},     {147, 157, 170},     {149, 155, 174},     {152, 154, 178},
    {154, 152, 182},     {157, 151, 186},     {159, 150, 191},     {162, 148, 195},
    { 90, 189,  64},     { 93, 187,  68},     { 95, 186,  72},     { 97, 184,  76},
    {100, 183,  80},     {102, 182,  84},     {105, 180,  88},     {107, 179,  93},
    {110, 177,  97},     {112, 176, 101},     {115, 175, 105},     {117, 173, 109},
    {120, 172, 113},     {122, 171, 117},     {125, 169, 121},     {127, 168, 125},
    {129, 166, 130},     {132, 165, 134},     {134, 164, 138},     {137, 162, 142},
    {139, 161, 146},     {142, 159, 150},     {144, 158, 154},     {147, 157, 158},
    {149, 155, 162},     {152, 154, 167},     {154, 152, 171},     {157, 151, 175},
    {159, 150, 179},     {161, 148, 183},     {164, 147, 187},     {166, 145, 191},
    { 95, 186,  60},     { 97, 184,  64},     {100, 183,  69},     {102, 182,  73},
    {105, 180,  77},     {107, 179,  81},     {110, 178,  85},     {112, 176,  89},
    {115, 175,  93},     {117, 173,  97},     {120, 172, 101},     {122, 171, 106},
    {124, 169, 110},     {127, 168, 114},     {129, 166, 118},     {132, 165, 122},
    {134, 164, 126},     {137, 162, 130},     {139, 161, 134},     {142, 159, 138},
    {144, 158, 143},     {147, 157, 147},     {149, 155, 151},     {152, 154, 155},
    {154, 153, 159},     {156, 151, 163},     {159, 150, 167},     {161, 148, 171},
    {164, 147, 175},     {166, 146, 180},     {169, 144, 184},     {171, 143, 188},
    {100, 183,  57},     {102, 182,  61},     {105, 180,  65},     {107, 179,  69},
    {110, 178,  73},     {112, 176,  77},     {115, 175,  82},     {117, 173,  86},
    {119, 172,  90},     {122, 171,  94},     {124, 169,  98},     {127, 168, 102},
    {129, 166, 106},     {132, 165, 110},     {134, 164, 114},     {137, 162, 119},
    {139, 161, 123},     {142, 160, 127},     {144, 158, 131},     {146, 157, 135},
    {149, 155, 139},     {151, 154, 143},     {154, 153, 147},     {156, 151, 151},
    {159, 150, 156},     {161, 148, 160},     {164, 147, 164},     {166, 146, 168},
    {169, 144, 172},     {171, 143, 176},     {174, 141, 180},     {176, 140, 184},
    {105, 180,  53},     {107, 179,  58},     {110, 178,  62},     {112, 176,  66},
    {114, 175,  70},     {117, 173,  74},     {119, 172,  78},     {122, 171,  82},
    {124, 169,  86},     {127, 168,  90},     {129, 167,  95},     {132, 165,  99},
    {134, 164, 103},     {137, 162, 107},     {139, 161, 111},     {141, 160, 115},
    {144, 158, 119},     {146, 157, 123},     {149, 155, 127},     {151, 154, 132},
    {154, 153, 136},     {156, 151, 140},     {159, 150, 144},     {161, 148, 148},
    {164, 147, 152},     {166, 146, 156},     {169, 144, 160},     {171, 143, 164},
    {173, 141, 169},     {176, 140, 173},     {178, 139, 177},     {181, 137, 181},
    {109, 178,  50},     {112, 176,  54},     {114, 175,  58},     {117, 174,  62},
    {119, 172,  66},     {122, 171,  71},     {124, 169,  75},     {127, 168,  79},
    {129, 167,  83},     {132, 165,  87},     {134, 164,  91},     {136, 162,  95},
    {139, 161,  99},     {141, 160, 103},     {144, 158, 108},     {146, 157, 112},
    {149, 155, 116},     {151, 154, 120},     {154, 153, 124},     {156, 151, 128},
    {159, 150, 132},     {161, 149, 136},     {164, 147, 140},     {166, 146, 145},
    {168, 144, 149},     {171, 143, 153},     {173, 142, 157},     {176, 140, 161},
    {178, 139, 165},     {181, 137, 169},     {183, 136, 173},     {186, 135, 177},
    {114, 175,  47},     {117, 174,  51},     {119, 172,  55},     {122, 171,  59},
    {124, 169,  63},     {127, 168,  67},     {129, 167,  71},     {131, 165,  75},
    {134, 164,  79},     {136, 162,  84},     {139, 161,  88},     {141, 160,  92},
    {144, 158,  96},     {146, 157, 100},     {149, 156, 104},     {151, 154, 108},
    {154, 153, 112},     {156, 151, 116},     {159, 150, 121},     {161, 149, 125},
    {163, 147, 129},     {166, 146, 133},     {168, 144, 137},     {171, 143, 141},
    {173, 142, 145},     {176, 140, 149},     {178, 139, 153},     {181, 137, 158},
    {183, 136, 162},     {186, 135, 166},     {188, 133, 170},     {190, 132, 174},
    {119, 172,  43},     {122, 171,  47},     {124, 169,  51},     {126, 168,  55},
    {129, 167,  60},     {131, 165,  64},     {134, 164,  68},     {136, 163,  72},
    {139, 161,  76},     {141, 160,  80},     {144, 158,  84},     {146, 157,  88},
    {149, 156,  92},     {151, 154,  97},     {154, 153, 101},     {156, 151, 105},
    {158, 150, 109},     {161, 149, 113},     {163, 147, 117},     {166, 146, 121},
    {168, 144, 125},     {171, 143, 129},     {173, 142, 134},     {176, 140, 138},
    {178, 139, 142},     {181, 138, 146},     {183, 136, 150},     {185, 135, 154},
    {188, 133, 158},     {190, 132, 162},     {193, 131, 166},     {195, 129, 171},
    {124, 170,  40},     {126, 168,  44},     {129, 167,  48},     {131, 165,  52},
    {134, 164,  56},     {136, 163,  60},     {139, 161,  64},     {141, 160,  68},
    {144, 158,  73},     {146, 157,  77},     {149, 156,  81},     {151, 154,  85},
    {153, 153,  89},     {156, 151,  93},     {158, 150,  97},     {161, 149, 101},
    {163, 147, 105},     {166, 146, 110},     {168, 145, 114},     {171, 143, 118},
    {173, 142, 122},     {176, 140, 126},     {178, 139, 130},     {180, 138, 134},
    {183, 136, 138},     {185, 135, 142},     {188, 133, 147},     {190, 132, 151},
    {193, 131, 155},     {195, 129, 159},     {198, 128, 163},     {200, 126, 167},
    {129, 167,  36},     {131, 165,  40},     {134, 164,  44},     {136, 163,  49},
    {139, 161,  53},     {141, 160,  57},     {143, 158,  61},     {146, 157,  65},
    {148, 156,  69},     {151, 154,  73},     {153, 153,  77},     {156, 152,  81},
    {158, 150,  86},     {161, 149,  90},     {163, 147,  94},     {166, 146,  98},
    {168, 145, 102},     {171, 143, 106},     {173, 142, 110},     {175, 140, 114},
    {178, 139, 118},     {180, 138, 123},     {183, 136, 127},     {185, 135, 131},
    {188, 133, 135},     {190, 132, 139},     {193, 131, 143},     {195, 129, 147},
    {198, 128, 151},     {200, 126, 155},     {203, 125, 160},     {205, 124, 164},
    {134, 164,  33},     {136, 163,  37},     {138, 161,  41},     {141, 160,  45},
    {143, 159,  49},     {146, 157,  53},     {148, 156,  57},     {151, 154,  62},
    {153, 153,  66},     {156, 152,  70},     {158, 150,  74},     {161, 149,  78},
    {163, 147,  82},     {166, 146,  86},     {168, 145,  90},     {170, 143,  94},
    {173, 142,  99},     {175, 140, 103},     {178, 139, 107},     {180, 138, 111},
    {183, 136, 115},     {185, 135, 119},     {188, 134, 123},     {190, 132, 127},
    {193, 131, 131},     {195, 129, 136},     {198, 128, 140},     {200, 127, 144},
    {202, 125, 148},     {205, 124, 152},     {207, 122, 156},     {210, 121, 160},
    {138, 161,  29},     {141, 160,  33},     {143, 159,  38},     {146, 157,  42},
    {148, 156,  46},     {151, 154,  50},     {153, 153,  54},     {156, 152,  58},
    {158, 150,  62},     {161, 149,  66},     {163, 147,  70},     {165, 146,  75},
    {168, 145,  79},     {170, 143,  83},     {173, 142,  87},     {175, 141,  91},
    {178, 139,  95},     {180, 138,  99},     {183, 136, 103},     {185, 135, 107},
    {188, 134, 112},     {190, 132, 116},     {193, 131, 120},     {195, 129, 124},
    {197, 128, 128},     {200, 127, 132},     {202, 125, 136},     {205, 124, 140},
    {207, 122, 144},     {210, 121, 149},     {212, 120, 153},     {215, 118, 157},
    {143, 159,  26},     {146, 157,  30},     {148, 156,  34},     {151, 154,  38},
    {153, 153,  42},     {156, 152,  46},     {158, 150,  51},     {160, 149,  55},
    {163, 148,  59},     {165, 146,  63},     {168, 145,  67},     {170, 143,  71},
    {173, 142,  75},     {175, 141,  79},     {178, 139,  83},     {180, 138,  88},
    {183, 136,  92},     {185, 135,  96},     {187, 134, 100},     {190, 132, 104},
    {192, 131, 108},     {195, 129, 112},     {197, 128, 116},     {200, 127, 120},
    {202, 125, 125},     {205, 124, 129},     {207, 122, 133},     {210, 121, 137},
    {212, 120, 141},     {215, 118, 145},     {217, 117, 149},     {219, 116, 153},
    {148, 156,  22},     {151, 155,  27},     {153, 153,  31},     {155, 152,  35},
    {158, 150,  39},     {160, 149,  43},     {163, 148,  47},     {165, 146,  51},
    {168, 145,  55},     {170, 143,  59},     {173, 142,  64},     {175, 141,  68},
    {178, 139,  72},     {180, 138,  76},     {182, 136,  80},     {185, 135,  84},
    {187, 134,  88},     {190, 132,  92},     {192, 131,  96},     {195, 130, 101},
    {197, 128, 105},     {200, 127, 109},     {202, 125, 113},     {205, 124, 117},
    {207, 123, 121},     {210, 121, 125},     {212, 120, 129},     {214, 118, 133},
    {217, 117, 138},     {219, 116, 142},     {222, 114, 146},     {224, 113, 150},
    {153, 153,  19},     {155, 152,  23},     {158, 150,  27},     {160, 149,  31},
    {163, 148,  35},     {165, 146,  40},     {168, 145,  44},     {170, 143,  48},
    {173, 142,  52},     {175, 141,  56},     {177, 139,  60},     {180, 138,  64},
    {182, 137,  68},     {185, 135,  72},     {187, 134,  77},     {190, 132,  81},
    {192, 131,  85},     {195, 130,  89},     {197, 128,  93},     {200, 127,  97},
    {202, 125, 101},     {205, 124, 105},     {207, 123, 109},     {209, 121, 114},
    {212, 120, 118},     {214, 118, 122},     {217, 117, 126},     {219, 116, 130},
    {222, 114, 134},     {224, 113, 138},     {227, 111, 142},     {229, 110, 146},
    {158, 150,  16},     {160, 149,  20},     {163, 148,  24},     {165, 146,  28},
    {168, 145,  32},     {170, 144,  36},     {172, 142,  40},     {175, 141,  44},
    {177, 139,  48},     {180, 138,  53},     {182, 137,  57},     {185, 135,  61},
    {187, 134,  65},     {190, 132,  69},     {192, 131,  73},     {195, 130,  77},
    {197, 128,  81},     {200, 127,  85},     {202, 125,  90},     {204, 124,  94},
    {207, 123,  98},     {209, 121, 102},     {212, 120, 106},     {214, 118, 110},
    {217, 117, 114},     {219, 116, 118},     {222, 114, 122},     {224, 113, 127},
    {227, 112, 131},     {229, 110, 135},     {231, 109, 139},     {234, 107, 143},
    {163, 148,  12},     {165, 146,  16},     {167, 145,  20},     {170, 144,  24},
    {172, 142,  29},     {175, 141,  33},     {177, 139,  37},     {180, 138,  41},
    {182, 137,  45},     {185, 135,  49},     {187, 134,  53},     {190, 132,  57},
    {192, 131,  61},     {195, 130,  66},     {197, 128,  70},     {199, 127,  74},
    {202, 126,  78},     {204, 124,  82},     {207, 123,  86},     {209, 121,  90},
    {212, 120,  94},     {214, 119,  98},     {217, 117, 103},     {219, 116, 107},
    {222, 114, 111},     {224, 113, 115},     {226, 112, 119},     {229, 110, 123},
    {231, 109, 127},     {234, 107, 131},     {236, 106, 135},     {239, 105, 140},
    {167, 145,   9},     {170, 144,  13},     {172, 142,  17},     {175, 141,  21},
    {177, 139,  25},     {180, 138,  29},     {182, 137,  33},     {185, 135,  37},
    {187, 134,  42},     {189, 133,  46},     {192, 131,  50},     {194, 130,  54},
    {197, 128,  58},     {199, 127,  62},     {202, 126,  66},     {204, 124,  70},
    {207, 123,  74},     {209, 121,  79},     {212, 120,  83},     {214, 119,  87},
    {217, 117,  91},     {219, 116,  95},     {221, 114,  99},     {224, 113, 103},
    {226, 112, 107},     {229, 110, 111},     {231, 109, 116},     {234, 107, 120},
    {236, 106, 124},     {239, 105, 128},     {241, 103, 132},     {244, 102, 136},
    {172, 142,   5},     {175, 141,   9},     {177, 140,  13},     {180, 138,  18},
    {182, 137,  22},     {184, 135,  26},     {187, 134,  30},     {189, 133,  34},
    {192, 131,  38},     {194, 130,  42},     {197, 128,  46},     {199, 127,  50},
    {202, 126,  55},     {204, 124,  59},     {207, 123,  63},     {209, 121,  67},
    {212, 120,  71},     {214, 119,  75},     {216, 117,  79},     {219, 116,  83},
    {221, 115,  87},     {224, 113,  92},     {226, 112,  96},     {229, 110, 100},
    {231, 109, 104},     {234, 108, 108},     {236, 106, 112},     {239, 105, 116},
    {241, 103, 120},     {244, 102, 124},     {246, 101, 129},     {248,  99, 133},
    { 23, 231, 111},     { 26, 229, 115},     { 28, 228, 120},     { 31, 227, 124},
    { 33, 225, 128},     { 36, 224, 132},     { 38, 222, 136},     { 41, 221, 140},
    { 43, 220, 144},     { 46, 218, 148},     { 48, 217, 152},     { 50, 216, 157},
    { 53, 214, 161},     { 55, 213, 165},     { 58, 211, 169},     { 60, 210, 173},
    { 63, 209, 177},     { 65, 207, 181},     { 68, 206, 185},     { 70, 204, 189},
    { 73, 203, 194},     { 75, 202, 198},     { 78, 200, 202},     { 80, 199, 206},
    { 82, 197, 210},     { 85, 196, 214},     { 87, 195, 218},     { 90, 193, 222},
    { 92, 192, 227},     { 95, 191, 231},     { 97, 189, 235},     {100, 188, 239},
    { 28, 228, 108},     { 31, 227, 112},     { 33, 225, 116},     { 36, 224, 120},
    { 38, 223, 124},     { 41, 221, 128},     { 43, 220, 133},     { 45, 218, 137},
    { 48, 217, 141},     { 50, 216, 145},     { 53, 214, 149},     { 55, 213, 153},
    { 58, 211, 157},     { 60, 210, 161},     { 63, 209, 165},     { 65, 207, 170},
    { 68, 206, 174},     { 70, 204, 178},     { 73, 203, 182},     { 75, 202, 186},
    { 77, 200, 190},     { 80, 199, 194},     { 82, 198, 198},     { 85, 196, 202},
    { 87, 195, 207},     { 90, 193, 211},     { 92, 192, 215},     { 95, 191, 219},
    { 97, 189, 223},     {100, 188, 227},     {102, 186, 231},     {105, 185, 235},
    { 33, 225, 104},     { 36, 224, 109},     { 38, 223, 113},     { 40, 221, 117},
    { 43, 220, 121},     { 45, 218, 125},     { 48, 217, 129},     { 50, 216, 133},
    { 53, 214, 137},     { 55, 213, 141},     { 58, 211, 146},     { 60, 210, 150},
    { 63, 209, 154},     { 65, 207, 158},     { 68, 206, 162},     { 70, 205, 166},
    { 72, 203, 170},     { 75, 202, 174},     { 77, 200, 178},     { 80, 199, 183},
    { 82, 198, 187},     { 85, 196, 191},     { 87, 195, 195},     { 90, 193, 199},
    { 92, 192, 203},     { 95, 191, 207},     { 97, 189, 211},     {100, 188, 215},
    {102, 186, 220},     {104, 185, 224},     {107, 184, 228},     {109, 182, 232},
    { 38, 223, 101},     { 40, 221, 105},     { 43, 220, 109},     { 45, 218, 113},
    { 48, 217, 117},     { 50, 216, 122},     { 53, 214, 126},     { 55, 213, 130},
    { 58, 212, 134},     { 60, 210, 138},     { 63, 209, 142},     { 65, 207, 146},
    { 67, 206, 150},     { 70, 205, 154},     { 72, 203, 159},     { 75, 202, 163},
    { 77, 200, 167},     { 80, 199, 171},     { 82, 198, 175},     { 85, 196, 179},
    { 87, 195, 183},     { 90, 193, 187},     { 92, 192, 191},     { 94, 191, 196},
    { 97, 189, 200},     { 99, 188, 204},     {102, 187, 208},     {104, 185, 212},
    {107, 184, 216},     {109, 182, 220},     {112, 181, 224},     {114, 180, 229},
    { 43, 220,  98},     { 45, 219, 102},     { 48, 217, 106},     { 50, 216, 110},
    { 53, 214, 114},     { 55, 213, 118},     { 58, 212, 122},     { 60, 210, 126},
    { 62, 209, 130},     { 65, 207, 135},     { 67, 206, 139},     { 70, 205, 143},
    { 72, 203, 147},     { 75, 202, 151},     { 77, 200, 155},     { 80, 199, 159},
    { 82, 198, 163},     { 85, 196, 167},     { 87, 195, 172},     { 89, 194, 176},
    { 92, 192, 180},     { 94, 191, 184},     { 97, 189, 188},     { 99, 188, 192},
    {102, 187, 196},     {104, 185, 200},     {107, 184, 204},     {109, 182, 209},
    {112, 181, 213},     {114, 180, 217},     {117, 178, 221},     {119, 177, 225},
    { 48, 217,  94},     { 50, 216,  98},     { 53, 214, 102},     { 55, 213, 106},
    { 57, 212, 111},     { 60, 210, 115},     { 62, 209, 119},     { 65, 207, 123},
    { 67, 206, 127},     { 70, 205, 131},     { 72, 203, 135},     { 75, 202, 139},
    { 77, 201, 143},     { 80, 199, 148},     { 82, 198, 152},     { 84, 196, 156},
    { 87, 195, 160},     { 89, 194, 164},     { 92, 192, 168},     { 94, 191, 172},
    { 97, 189, 176},     { 99, 188, 180},     {102, 187, 185},     {104, 185, 189},
    {107, 184, 193},     {109, 182, 197},     {112, 181, 201},     {114, 180, 205},
    {116, 178, 209},     {119, 177, 213},     {121, 176, 217},     {124, 174, 222},
    { 52, 214,  91},     { 55, 213,  95},     { 57, 212,  99},     { 60, 210, 103},
    { 62, 209, 107},     { 65, 208, 111},     { 67, 206, 115},     { 70, 205, 119},
    { 72, 203, 124},     { 75, 202, 128},     { 77, 201, 132},     { 79, 199, 136},
    { 82, 198, 140},     { 84, 196, 144},     { 87, 195, 148},     { 89, 194, 152},
    { 92, 192, 156},     { 94, 191, 161},     { 97, 189, 165},     { 99, 188, 169},
    {102, 187, 173},     {104, 185, 177},     {107, 184, 181},     {109, 183, 185},
    {111, 181, 189},     {114, 180, 193},     {116, 178, 198},     {119, 177, 202},
    {121, 176, 206},     {124, 174, 210},     {126, 173, 214},     {129, 171, 218},
    { 57, 212,  87},     { 60, 210,  91},     { 62, 209,  95},     { 65, 208, 100},
    { 67, 206, 104},     { 70, 205, 108},     { 72, 203, 112},     { 74, 202, 116},
    { 77, 201, 120},     { 79, 199, 124},     { 82, 198, 128},     { 84, 196, 132},
    { 87, 195, 137},     { 89, 194, 141},     { 92, 192, 145},     { 94, 191, 149},
    { 97, 190, 153},     { 99, 188, 157},     {102, 187, 161},     {104, 185, 165},
    {106, 184, 169},     {109, 183, 174},     {111, 181, 178},     {114, 180, 182},
    {116, 178, 186},     {119, 177, 190},     {121, 176, 194},     {124, 174, 198},
    {126, 173, 202},     {129, 171, 206},     {131, 170, 211},     {133, 169, 215},
    { 62, 209,  84},     { 65, 208,  88},     { 67, 206,  92},     { 69, 205,  96},
    { 72, 203, 100},     { 74, 202, 104},     { 77, 201, 108},     { 79, 199, 113},
    { 82, 198, 117},     { 84, 197, 121},     { 87, 195, 125},     { 89, 194, 129},
    { 92, 192, 133},     { 94, 191, 137},     { 97, 190, 141},     { 99, 188, 145},
    {101, 187, 150},     {104, 185, 154},     {106, 184, 158},     {109, 183, 162},
    {111, 181, 166},     {114, 180, 170},     {116, 178, 174},     {119, 177, 178},
    {121, 176, 182},     {124, 174, 187},     {126, 173, 191},     {128, 172, 195},
    {131, 170, 199},     {133, 169, 203},     {136, 167, 207},     {138, 166, 211},
    { 67, 206,  80},     { 69, 205,  84},     { 72, 204,  89},     { 74, 202,  93},
    { 77, 201,  97},     { 79, 199, 101},     { 82, 198, 105},     { 84, 197, 109},
    { 87, 195, 113},     { 89, 194, 117},     { 91, 192, 121},     { 94, 191, 126},
    { 96, 190, 130},     { 99, 188, 134},     {101, 187, 138},     {104, 185, 142},
    {106, 184, 146},     {109, 183, 150},     {111, 181, 154},     {114, 180, 158},
    {116, 179, 163},     {119, 177, 167},     {121, 176, 171},     {123, 174, 175},
    {126, 173, 179},     {128, 172, 183},     {131, 170, 187},     {133, 169, 191},
    {136, 167, 195},     {138, 166, 200},     {141, 165, 204},     {143, 163, 208},
    { 72, 204,  77},     { 74, 202,  81},     { 77, 201,  85},     { 79, 199,  89},
    { 82, 198,  93},     { 84, 197,  97},     { 86, 195, 102},     { 89, 194, 106},
    { 91, 192, 110},     { 94, 191, 114},     { 96, 190, 118},     { 99, 188, 122},
    {101, 187, 126},     {104, 186, 130},     {106, 184, 134},     {109, 183, 139},
    {111, 181, 143},     {114, 180, 147},     {116, 179, 151},     {118, 177, 155},
    {121, 176, 159},     {123, 174, 163},     {126, 173, 167},     {128, 172, 171},
    {131, 170, 176},     {133, 169, 180},     {136, 167, 184},     {138, 166, 188},
    {141, 165, 192},     {143, 163, 196},     {146, 162, 200},     {148, 161, 204},
    { 77, 201,  73},     { 79, 199,  78},     { 81, 198,  82},     { 84, 197,  86},
    { 86, 195,  90},     { 89, 194,  94},     { 91, 193,  98},     { 94, 191, 102},
    { 96, 190, 106},     { 99, 188, 110},     {101, 187, 115},     {104, 186, 119},
    {106, 184, 123},     {109, 183, 127},     {111, 181, 131},     {113, 180, 135},
    {116, 179, 139},     {118, 177, 143},     {121, 176, 147},     {123, 174, 152},
    {126, 173, 156},     {128, 172, 160},     {131, 170, 164},     {133, 169, 168},
    {136, 168, 172},     {138, 166, 176},     {141, 165, 180},     {143, 163, 184},
    {145, 162, 189},     {148, 161, 193},     {150, 159, 197},     {153, 158, 201},
    { 81, 198,  70},     { 84, 197,  74},     { 86, 195,  78},     { 89, 194,  82},
    { 91, 193,  86},     { 94, 191,  91},     { 96, 190,  95},     { 99, 188,  99},
    {101, 187, 103},     {104, 186, 107},     {106, 184, 111},     {108, 183, 115},
    {111, 181, 119},     {113, 180, 123},     {116, 179, 128},     {118, 177, 132},
    {121, 176, 136},     {123, 175, 140},     {126, 173, 144},     {128, 172, 148},
    {131, 170, 152},     {133, 169, 156},     {135, 168, 160},     {138, 166, 165},
    {140, 165, 169},     {143, 163, 173},     {145, 162, 177},     {148, 161, 181},
    {150, 159, 185},     {153, 158, 189},     {155, 156, 193},     {158, 155, 197},
    { 86, 195,  67},     { 89, 194,  71},     { 91, 193,  75},     { 94, 191,  79},
    { 96, 190,  83},     { 99, 188,  87},     {101, 187,  91},     {103, 186,  95},
    {106, 184,  99},     {108, 183, 104},     {111, 182, 108},     {113, 180, 112},
    {116, 179, 116},     {118, 177, 120},     {121, 176, 124},     {123, 175, 128},
    {126, 173, 132},     {128, 172, 136},     {130, 170, 141},     {133, 169, 145},
    {135, 168, 149},     {138, 166, 153},     {140, 165, 157},     {143, 163, 161},
    {145, 162, 165},     {148, 161, 169},     {150, 159, 173},     {153, 158, 178},
    {155, 157, 182},     {158, 155, 186},     {160, 154, 190},     {162, 152, 194},
    { 91, 193,  63},     { 94, 191,  67},     { 96, 190,  71},     { 98, 189,  75},
    {101, 187,  80},     {103, 186,  84},     {106, 184,  88},     {108, 183,  92},
    {111, 182,  96},     {113, 180, 100},     {116, 179, 104},     {118, 177, 108},
    {121, 176, 112},     {123, 175, 117},     {125, 173, 121},     {128, 172, 125},
    {130, 170, 129},     {133, 169, 133},     {135, 168, 137},     {138, 166, 141},
    {140, 165, 145},     {143, 164, 149},     {145, 162, 154},     {148, 161, 158},
    {150, 159, 162},     {153, 158, 166},     {155, 157, 170},     {157, 155, 174},
    {160, 154, 178},     {162, 152, 182},     {165, 151, 186},     {167, 150, 191},
    { 96, 190,  60},     { 98, 189,  64},     {101, 187,  68},     {103, 186,  72},
    {106, 184,  76},     {108, 183,  80},     {111, 182,  84},     {113, 180,  88},
    {116, 179,  93},     {118, 177,  97},     {120, 176, 101},     {123, 175, 105},
    {125, 173, 109},     {128, 172, 113},     {130, 171, 117},     {133, 169, 121},
    {135, 168, 125},     {138, 166, 130},     {140, 165, 134},     {143, 164, 138},
    {145, 162, 142},     {148, 161, 146},     {150, 159, 150},     {152, 158, 154},
    {155, 157, 158},     {157, 155, 162},     {160, 154, 167},     {162, 152, 171},
    {165, 151, 175},     {167, 150, 179},     {170, 148, 183},     {172, 147, 187},
    {101, 187,  56},     {103, 186,  60},     {106, 184,  64},     {108, 183,  69},
    {111, 182,  73},     {113, 180,  77},     {115, 179,  81},     {118, 178,  85},
    {120, 176,  89},     {123, 175,  93},     {125, 173,  97},     {128, 172, 101},
    {130, 171, 106},     {133, 169, 110},     {135, 168, 114},     {138, 166, 118},
    {140, 165, 122},     {143, 164, 126},     {145, 162, 130},     {147, 161, 134},
    {150, 159, 138},     {152, 158, 143},     {155, 157, 147},     {157, 155, 151},
    {160, 154, 155},     {162, 153, 159},     {165, 151, 163},     {167, 150, 167},
    {170, 148, 171},     {172, 147, 175},     {174, 146, 180},     {177, 144, 184},
    {106, 185,  53},     {108, 183,  57},     {110, 182,  61},     {113, 180,  65},
    {115, 179,  69},     {118, 178,  73},     {120, 176,  77},     {123, 175,  82},
    {125, 173,  86},     {128, 172,  90},     {130, 171,  94},     {133, 169,  98},
    {135, 168, 102},     {138, 166, 106},     {140, 165, 110},     {142, 164, 114},
    {145, 162, 119},     {147, 161, 123},     {150, 160, 127},     {152, 158, 131},
    {155, 157, 135},     {157, 155, 139},     {160, 154, 143},     {162, 153, 147},
    {165, 151, 151},     {167, 150, 156},     {169, 148, 160},     {172, 147, 164},
    {174, 146, 168},     {177, 144, 172},     {179, 143, 176},     {182, 141, 180},
    {110, 182,  49},     {113, 180,  53},     {115, 179,  58},     {118, 178,  62},
    {120, 176,  66},     {123, 175,  70},     {125, 173,  74},     {128, 172,  78},
    {130, 171,  82},     {132, 169,  86},     {135, 168,  90},     {137, 167,  95},
    {140, 165,  99},     {142, 164, 103},     {145, 162, 107},     {147, 161, 111},
    {150, 160, 115},     {152, 158, 119},     {155, 157, 123},     {157, 155, 127},
    {160, 154, 132},     {162, 153, 136},     {164, 151, 140},     {167, 150, 144},
    {169, 148, 148},     {172, 147, 152},     {174, 146, 156},     {177, 144, 160},
    {179, 143, 164},     {182, 141, 169},     {184, 140, 173},     {187, 139, 177},
    {115, 179,  46},     {118, 178,  50},     {120, 176,  54},     {123, 175,  58},
    {125, 174,  62},     {127, 172,  66},     {130, 171,  71},     {132, 169,  75},
    {135, 168,  79},     {137, 167,  83},     {140, 165,  87},     {142, 164,  91},
    {145, 162,  95},     {147, 161,  99},     {150, 160, 103},     {152, 158, 108},
    {155, 157, 112},     {157, 155, 116},     {159, 154, 120},     {162, 153, 124},
    {164, 151, 128},     {167, 150, 132},     {169, 149, 136},     {172, 147, 140},
    {174, 146, 145},     {177, 144, 149},     {179, 143, 153},     {182, 142, 157},
    {184, 140, 161},     {187, 139, 165},     {189, 137, 169},     {191, 136, 173},
    {120, 176,  42},     {122, 175,  47},     {125, 174,  51},     {127, 172,  55},
    {130, 171,  59},     {132, 169,  63},     {135, 168,  67},     {137, 167,  71},
    {140, 165,  75},     {142, 164,  79},     {145, 162,  84},     {147, 161,  88},
    {150, 160,  92},     {152, 158,  96},     {154, 157, 100},     {157, 156, 104},
    {159, 154, 108},     {162, 153, 112},     {164, 151, 116},     {167, 150, 121},
    {169, 149, 125},     {172, 147, 129},     {174, 146, 133},     {177, 144, 137},
    {179, 143, 141},     {182, 142, 145},     {184, 140, 149},     {186, 139, 153},
    {189, 137, 158},     {191, 136, 162},     {194, 135, 166},     {196, 133, 170},
    {125, 174,  39},     {127, 172,  43},     {130, 171,  47},     {132, 169,  51},
    {135, 168,  55},     {137, 167,  60},     {140, 165,  64},     {142, 164,  68},
    {145, 163,  72},     {147, 161,  76},     {149, 160,  80},     {152, 158,  84},
    {154, 157,  88},     {157, 156,  92},     {159, 154,  97},     {162, 153, 101},
    {164, 151, 105},     {167, 150, 109},     {169, 149, 113},     {172, 147, 117},
    {174, 146, 121},     {176, 144, 125},     {179, 143, 129},     {181, 142, 134},
    {184, 140, 138},     {186, 139, 142},     {189, 138, 146},     {191, 136, 150},
    {194, 135, 154},     {196, 133, 158},     {199, 132, 162},     {201, 131, 166},
    {130, 171,  36},     {132, 170,  40},     {135, 168,  44},     {137, 167,  48},
    {140, 165,  52},     {142, 164,  56},     {144, 163,  60},     {147, 161,  64},
    {149, 160,  68},     {152, 158,  73},     {154, 157,  77},     {157, 156,  81},
    {159, 154,  85},     {162, 153,  89},     {164, 151,  93},     {167, 150,  97},
    {169, 149, 101},     {171, 147, 105},     {174, 146, 110},     {176, 145, 114},
    {179, 143, 118},     {181, 142, 122},     {184, 140, 126},     {186, 139, 130},
    {189, 138, 134},     {191, 136, 138},     {194, 135, 142},     {196, 133, 147},
    {199, 132, 151},     {201, 131, 155},     {203, 129, 159},     {206, 128, 163},
    {135, 168,  32},     {137, 167,  36},     {139, 165,  40},     {142, 164,  44},
    {144, 163,  49},     {147, 161,  53},     {149, 160,  57},     {152, 158,  61},
    {154, 157,  65},     {157, 156,  69},     {159, 154,  73},     {162, 153,  77},
    {164, 152,  81},     {166, 150,  86},     {169, 149,  90},     {171, 147,  94},
    {174, 146,  98},     {176, 145, 102},     {179, 143, 106},     {181, 142, 110},
    {184, 140, 114},     {186, 139, 118},     {189, 138, 123},     {191, 136, 127},
    {194, 135, 131},     {196, 133, 135},     {198, 132, 139},     {201, 131, 143},
    {203, 129, 147},     {206, 128, 151},     {208, 126, 155},     {211, 125, 160},
    {139, 165,  29},     {142, 164,  33},     {144, 163,  37},     {147, 161,  41},
    {149, 160,  45},     {152, 159,  49},     {154, 157,  53},     {157, 156,  57},
    {159, 154,  62},     {161, 153,  66},     {164, 152,  70},     {166, 150,  74},
    {169, 149,  78},     {171, 147,  82},     {174, 146,  86},     {176, 145,  90},
    {179, 143,  94},     {181, 142,  99},     {184, 140, 103},     {186, 139, 107},
    {189, 138, 111},     {191, 136, 115},     {193, 135, 119},     {196, 134, 123},
    {198, 132, 127},     {201, 131, 131},     {203, 129, 136},     {206, 128, 140},
    {208, 127, 144},     {211, 125, 148},     {213, 124, 152},     {216, 122, 156},
    {144, 163,  25},     {147, 161,  29},     {149, 160,  33},     {152, 159,  38},
    {154, 157,  42},     {156, 156,  46},     {159, 154,  50},     {161, 153,  54},
    {164, 152,  58},     {166, 150,  62},     {169, 149,  66},     {171, 147,  70},
    {174, 146,  75},     {176, 145,  79},     {179, 143,  83},     {181, 142,  87},
    {184, 141,  91},     {186, 139,  95},     {188, 138,  99},     {191, 136, 103},
    {193, 135, 107},     {196, 134, 112},     {198, 132, 116},     {201, 131, 120},
    {203, 129, 124},     {206, 128, 128},     {208, 127, 132},     {211, 125, 136},
    {213, 124, 140},     {215, 122, 144},     {218, 121, 149},     {220, 120, 153},
    {149, 160,  22},     {151, 159,  26},     {154, 157,  30},     {156, 156,  34},
    {159, 154,  38},     {161, 153,  42},     {164, 152,  46},     {166, 150,  51},
    {169, 149,  55},     {171, 148,  59},     {174, 146,  63},     {176, 145,  67},
    {178, 143,  71},     {181, 142,  75},     {183, 141,  79},     {186, 139,  83},
    {188, 138,  88},     {191, 136,  92},     {193, 135,  96},     {196, 134, 100},
    {198, 132, 104},     {201, 131, 108},     {203, 129, 112},     {206, 128, 116},
    {208, 127, 120},     {210, 125, 125},     {213, 124, 129},     {215, 122, 133},
    {218, 121, 137},     {220, 120, 141},     {223, 118, 145},     {225, 117, 149},
    {154, 157,  18},     {156, 156,  22},     {159, 155,  27},     {161, 153,  31},
    {164, 152,  35},     {166, 150,  39},     {169, 149,  43},     {171, 148,  47},
    {173, 146,  51},     {176, 145,  55},     {178, 143,  59},     {181, 142,  64},
    {183, 141,  68},     {186, 139,  72},     {188, 138,  76},     {191, 136,  80},
    {193, 135,  84},     {196, 134,  88},     {198, 132,  92},     {201, 131,  96},
    {203, 130, 101},     {205, 128, 105},     {208, 127, 109},     {210, 125, 113},
    {213, 124, 117},     {215, 123, 121},     {218, 121, 125},     {220, 120, 129},
    {223, 118, 133},     {225, 117, 138},     {228, 116, 142},     {230, 114, 146},
    {159, 155,  15},     {161, 153,  19},     {164, 152,  23},     {166, 150,  27},
    {168, 149,  31},     {171, 148,  35},     {173, 146,  40},     {176, 145,  44},
    {178, 143,  48},     {181, 142,  52},     {183, 141,  56},     {186, 139,  60},
    {188, 138,  64},     {191, 137,  68},     {193, 135,  72},     {196, 134,  77},
    {198, 132,  81},     {200, 131,  85},     {203, 130,  89},     {205, 128,  93},
    {208, 127,  97},     {210, 125, 101},     {213, 124, 105},     {215, 123, 109},
    {218, 121, 114},     {220, 120, 118},     {223, 118, 122},     {225, 117, 126},
    {228, 116, 130},     {230, 114, 134},     {232, 113, 138},     {235, 111, 142},
    {163, 152,  11},     {166, 150,  16},     {168, 149,  20},     {171, 148,  24},
    {173, 146,  28},     {176, 145,  32},     {178, 144,  36},     {181, 142,  40},
    {183, 141,  44},     {186, 139,  48},     {188, 138,  53},     {191, 137,  57},
    {193, 135,  61},     {195, 134,  65},     {198, 132,  69},     {200, 131,  73},
    {203, 130,  77},     {205, 128,  81},     {208, 127,  85},     {210, 125,  90},
    {213, 124,  94},     {215, 123,  98},     {218, 121, 102},     {220, 120, 106},
    {222, 118, 110},     {225, 117, 114},     {227, 116, 118},     {230, 114, 122},
    {232, 113, 127},     {235, 112, 131},     {237, 110, 135},     {240, 109, 139},
    {168, 149,   8},     {171, 148,  12},     {173, 146,  16},     {176, 145,  20},
    {178, 144,  24},     {181, 142,  29},     {183, 141,  33},     {186, 139,  37},
    {188, 138,  41},     {190, 137,  45},     {193, 135,  49},     {195, 134,  53},
    {198, 132,  57},     {200, 131,  61},     {203, 130,  66},     {205, 128,  70},
    {208, 127,  74},     {210, 126,  78},     {213, 124,  82},     {215, 123,  86},
    {217, 121,  90},     {220, 120,  94},     {222, 119,  98},     {225, 117, 103},
    {227, 116, 107},     {230, 114, 111},     {232, 113, 115},     {235, 112, 119},
    {237, 110, 123},     {240, 109, 127},     {242, 107, 131},     {245, 106, 135},
    {173, 146,   4},     {176, 145,   9},     {178, 144,  13},     {181, 142,  17},
    {183, 141,  21},     {185, 139,  25},     {188, 138,  29},     {190, 137,  33},
    {193, 135,  37},     {195, 134,  42},     {198, 133,  46},     {200, 131,  50},
    {203, 130,  54},     {205, 128,  58},     {208, 127,  62},     {210, 126,  66},
    {212, 124,  70},     {215, 123,  74},     {217, 121,  79},     {220, 120,  83},
    {222, 119,  87},     {225, 117,  91},     {227, 116,  95},     {230, 114,  99},
    {232, 113, 103},     {235, 112, 107},     {237, 110, 111},     {240, 109, 116},
    {242, 107, 120},     {244, 106, 124},     {247, 105, 128},     {249, 103, 132},
    { 24, 235, 111},     { 27, 234, 115},     { 29, 232, 119},     { 32, 231, 123},
    { 34, 229, 127},     { 37, 228, 131},     { 39, 227, 135},     { 42, 225, 139},
    { 44, 224, 144},     { 47, 222, 148},     { 49, 221, 152},     { 51, 220, 156},
    { 54, 218, 160},     { 56, 217, 164},     { 59, 215, 168},     { 61, 214, 172},
    { 64, 213, 176},     { 66, 211, 181},     { 69, 210, 185},     { 71, 209, 189},
    { 74, 207, 193},     { 76, 206, 197},     { 78, 204, 201},     { 81, 203, 205},
    { 83, 202, 209},     { 86, 200, 213},     { 88, 199, 218},     { 91, 197, 222},
    { 93, 196, 226},     { 96, 195, 230},     { 98, 193, 234},     {101, 192, 238},
    { 29, 232, 107},     { 32, 231, 111},     { 34, 229, 115},     { 37, 228, 120},
    { 39, 227, 124},     { 42, 225, 128},     { 44, 224, 132},     { 46, 222, 136},
    { 49, 221, 140},     { 51, 220, 144},     { 54, 218, 148},     { 56, 217, 152},
    { 59, 216, 157},     { 61, 214, 161},     { 64, 213, 165},     { 66, 211, 169},
    { 69, 210, 173},     { 71, 209, 177},     { 73, 207, 181},     { 76, 206, 185},
    { 78, 204, 189},     { 81, 203, 194},     { 83, 202, 198},     { 86, 200, 202},
    { 88, 199, 206},     { 91, 197, 210},     { 93, 196, 214},     { 96, 195, 218},
    { 98, 193, 222},     {101, 192, 227},     {103, 191, 231},     {105, 189, 235},
    { 34, 229, 104},     { 36, 228, 108},     { 39, 227, 112},     { 41, 225, 116},
    { 44, 224, 120},     { 46, 223, 124},     { 49, 221, 128},     { 51, 220, 133},
    { 54, 218, 137},     { 56, 217, 141},     { 59, 216, 145},     { 61, 214, 149},
    { 64, 213, 153},     { 66, 211, 157},     { 68, 210, 161},     { 71, 209, 165},
    { 73, 207, 170},     { 76, 206, 174},     { 78, 204, 178},     { 81, 203, 182},
    { 83, 202, 186},     { 86, 200, 190},     { 88, 199, 194},     { 91, 198, 198},
    { 93, 196, 202},     { 96, 195, 207},     { 98, 193, 211},     {100, 192, 215},
    {103, 191, 219},     {105, 189, 223},     {108, 188, 227},     {110, 186, 231},
    { 39, 227, 100},     { 41, 225, 104},     { 44, 224, 109},     { 46, 223, 113},
    { 49, 221, 117},     { 51, 220, 121},     { 54, 218, 125},     { 56, 217, 129},
    { 59, 216, 133},     { 61, 214, 137},     { 63, 213, 141},     { 66, 211, 146},
    { 68, 210, 150},     { 71, 209, 154},     { 73, 207, 158},     { 76, 206, 162},
    { 78, 205, 166},     { 81, 203, 170},     { 83, 202, 174},     { 86, 200, 178},
    { 88, 199, 183},     { 91, 198, 187},     { 93, 196, 191},     { 95, 195, 195},
    { 98, 193, 199},     {100, 192, 203},     {103, 191, 207},     {105, 189, 211},
    {108, 188, 215},     {110, 186, 220},     {113, 185, 224},     {115, 184, 228},
    { 44, 224,  97},     { 46, 223, 101},     { 49, 221, 105},     { 51, 220, 109},
    { 54, 218, 113},     { 56, 217, 117},     { 58, 216, 122},     { 61, 214, 126},
    { 63, 213, 130},     { 66, 212, 134},     { 68, 210, 138},     { 71, 209, 142},
    { 73, 207, 146},     { 76, 206, 150},     { 78, 205, 154},     { 81, 203, 159},
    { 83, 202, 163},     { 86, 200, 167},     { 88, 199, 171},     { 90, 198, 175},
    { 93, 196, 179},     { 95, 195, 183},     { 98, 193, 187},     {100, 192, 191},
    {103, 191, 196},     {105, 189, 200},     {108, 188, 204},     {110, 187, 208},
    {113, 185, 212},     {115, 184, 216},     {117, 182, 220},     {120, 181, 224},
    { 49, 221,  93},     { 51, 220,  98},     { 53, 219, 102},     { 56, 217, 106},
    { 58, 216, 110},     { 61, 214, 114},     { 63, 213, 118},     { 66, 212, 122},
    { 68, 210, 126},     { 71, 209, 130},     { 73, 207, 135},     { 76, 206, 139},
    { 78, 205, 143},     { 80, 203, 147},     { 83, 202, 151},     { 85, 200, 155},
    { 88, 199, 159},     { 90, 198, 163},     { 93, 196, 167},     { 95, 195, 172},
    { 98, 194, 176},     {100, 192, 180},     {103, 191, 184},     {105, 189, 188},
    {108, 188, 192},     {110, 187, 196},     {112, 185, 200},     {115, 184, 204},
    {117, 182, 209},     {120, 181, 213},     {122, 180, 217},     {125, 178, 221},
    { 53, 219,  90},     { 56, 217,  94},     { 58, 216,  98},     { 61, 214, 102},
    { 63, 213, 106},     { 66, 212, 111},     { 68, 210, 115},     { 71, 209, 119},
    { 73, 207, 123},     { 75, 206, 127},     { 78, 205, 131},     { 80, 203, 135},
    { 83, 202, 139},     { 85, 201, 143},     { 88, 199, 148},     { 90, 198, 152},
    { 93, 196, 156},     { 95, 195, 160},     { 98, 194, 164},     {100, 192, 168},
    {103, 191, 172},     {105, 189, 176},     {107, 188, 180},     {110, 187, 185},
    {112, 185, 189},     {115, 184, 193},     {117, 182, 197},     {120, 181, 201},
    {122, 180, 205},     {125, 178, 209},     {127, 177, 213},     {130, 176, 217},
    { 58, 216,  87},     { 61, 214,  91},     { 63, 213,  95},     { 66, 212,  99},
    { 68, 210, 103},     { 70, 209, 107},     { 73, 208, 111},     { 75, 206, 115},
    { 78, 205, 119},     { 80, 203, 124},     { 83, 202, 128},     { 85, 201, 132},
    { 88, 199, 136},     { 90, 198, 140},     { 93, 196, 144},     { 95, 195, 148},
    { 98, 194, 152},     {100, 192, 156},     {102, 191, 161},     {105, 189, 165},
    {107, 188, 169},     {110, 187, 173},     {112, 185, 177},     {115, 184, 181},
    {117, 183, 185},     {120, 181, 189},     {122, 180, 193},     {125, 178, 198},
    {127, 177, 202},     {130, 176, 206},     {132, 174, 210},     {134, 173, 214},
    { 63, 213,  83},     { 65, 212,  87},     { 68, 210,  91},     { 70, 209,  95},
    { 73, 208, 100},     { 75, 206, 104},     { 78, 205, 108},     { 80, 203, 112},
    { 83, 202, 116},     { 85, 201, 120},     { 88, 199, 124},     { 90, 198, 128},
    { 93, 196, 132},     { 95, 195, 137},     { 97, 194, 141},     {100, 192, 145},
    {102, 191, 149},     {105, 190, 153},     {107, 188, 157},     {110, 187, 161},
    {112, 185, 165},     {115, 184, 169},     {117, 183, 174},     {120, 181, 178},
    {122, 180, 182},     {124, 178, 186},     {127, 177, 190},     {129, 176, 194},
    {132, 174, 198},     {134, 173, 202},     {137, 171, 206},     {139, 170, 211},
    { 68, 210,  80},     { 70, 209,  84},     { 73, 208,  88},     { 75, 206,  92},
    { 78, 205,  96},     { 80, 203, 100},     { 83, 202, 104},     { 85, 201, 108},
    { 88, 199, 113},     { 90, 198, 117},     { 92, 197, 121},     { 95, 195, 125},
    { 97, 194, 129},     {100, 192, 133},     {102, 191, 137},     {105, 190, 141},
    {107, 188, 145},     {110, 187, 150},     {112, 185, 154},     {115, 184, 158},
    {117, 183, 162},     {119, 181, 166},     {122, 180, 170},     {124, 178, 174},
    {127, 177, 178},     {129, 176, 182},     {132, 174, 187},     {134, 173, 191},
    {137, 172, 195},     {139, 170, 199},     {142, 169, 203},     {144, 167, 207},
    { 73, 208,  76},     { 75, 206,  80},     { 78, 205,  84},     { 80, 204,  89},
    { 83, 202,  93},     { 85, 201,  97},     { 87, 199, 101},     { 90, 198, 105},
    { 92, 197, 109},     { 95, 195, 113},     { 97, 194, 117},     {100, 192, 121},
    {102, 191, 126},     {105, 190, 130},     {107, 188, 134},     {110, 187, 138},
    {112, 185, 142},     {114, 184, 146},     {117, 183, 150},     {119, 181, 154},
    {122, 180, 158},     {124, 179, 163},     {127, 177, 167},     {129, 176, 171},
    {132, 174, 175},     {134, 173, 179},     {137, 172, 183},     {139, 170, 187},
    {142, 169, 191},     {144, 167, 195},     {146, 166, 200},     {149, 165, 204},
    { 77, 205,  73},     { 80, 204,  77},     { 82, 202,  81},     { 85, 201,  85},
    { 87, 199,  89},     { 90, 198,  93},     { 92, 197,  97},     { 95, 195, 102},
    { 97, 194, 106},     {100, 192, 110},     {102, 191, 114},     {105, 190, 118},
    {107, 188, 122},     {109, 187, 126},     {112, 186, 130},     {114, 184, 134},
    {117, 183, 139},     {119, 181, 143},     {122, 180, 147},     {124, 179, 151},
    {127, 177, 155},     {129, 176, 159},     {132, 174, 163},     {134, 173, 167},
    {137, 172, 171},     {139, 170, 176},     {141, 169, 180},     {144, 167, 184},
    {146, 166, 188},     {149, 165, 192},     {151, 163, 196},     {154, 162, 200},
    { 82, 202,  69},     { 85, 201,  73},     { 87, 199,  78},     { 90, 198,  82},
    { 92, 197,  86},     { 95, 195,  90},     { 97, 194,  94},     {100, 193,  98},
    {102, 191, 102},     {104, 190, 106},     {107, 188, 110},     {109, 187, 115},
    {112, 186, 119},     {114, 184, 123},     {117, 183, 127},     {119, 181, 131},
    {122, 180, 135},     {124, 179, 139},     {127, 177, 143},     {129, 176, 147},
    {132, 174, 152},     {134, 173, 156},     {136, 172, 160},     {139, 170, 164},
    {141, 169, 168},     {144, 168, 172},     {146, 166, 176},     {149, 165, 180},
    {151, 163, 184},     {154, 162, 189},     {156, 161, 193},     {159, 159, 197},
    { 87, 200,  66},     { 90, 198,  70},     { 92, 197,  74},     { 95, 195,  78},
    { 97, 194,  82},     { 99, 193,  86},     {102, 191,  91},     {104, 190,  95},
    {107, 188,  99},     {109, 187, 103},     {112, 186, 107},     {114, 184, 111},
    {117, 183, 115},     {119, 181, 119},     {122, 180, 123},     {124, 179, 128},
    {127, 177, 132},     {129, 176, 136},     {131, 175, 140},     {134, 173, 144},
    {136, 172, 148},     {139, 170, 152},     {141, 169, 156},     {144, 168, 160},
    {146, 166, 165},     {149, 165, 169},     {151, 163, 173},     {154, 162, 177},
    {156, 161, 181},     {158, 159, 185},     {161, 158, 189},     {163, 156, 193},
    { 92, 197,  62},     { 94, 195,  67},     { 97, 194,  71},     { 99, 193,  75},
    {102, 191,  79},     {104, 190,  83},     {107, 188,  87},     {109, 187,  91},
    {112, 186,  95},     {114, 184,  99},     {117, 183, 104},     {119, 182, 108},
    {121, 180, 112},     {124, 179, 116},     {126, 177, 120},     {129, 176, 124},
    {131, 175, 128},     {134, 173, 132},     {136, 172, 136},     {139, 170, 141},
    {141, 169, 145},     {144, 168, 149},     {146, 166, 153},     {149, 165, 157},
    {151, 163, 161},     {153, 162, 165},     {156, 161, 169},     {158, 159, 173},
    {161, 158, 178},     {163, 157, 182},     {166, 155, 186},     {168, 154, 190},
    { 97, 194,  59},     { 99, 193,  63},     {102, 191,  67},     {104, 190,  71},
    {107, 189,  75},     {109, 187,  80},     {112, 186,  84},     {114, 184,  88},
    {116, 183,  92},     {119, 182,  96},     {121, 180, 100},     {124, 179, 104},
    {126, 177, 108},     {129, 176, 112},     {131, 175, 117},     {134, 173, 121},
    {136, 172, 125},     {139, 170, 129},     {141, 169, 133},     {144, 168, 137},
    {146, 166, 141},     {148, 165, 145},     {151, 164, 149},     {153, 162, 154},
    {156, 161, 158},     {158, 159, 162},     {161, 158, 166},     {163, 157, 170},
    {166, 155, 174},     {168, 154, 178},     {171, 152, 182},     {173, 151, 186},
    {102, 191,  56},     {104, 190,  60},     {107, 189,  64},     {109, 187,  68},
    {111, 186,  72},     {114, 184,  76},     {116, 183,  80},     {119, 182,  84},
    {121, 180,  88},     {124, 179,  93},     {126, 177,  97},     {129, 176, 101},
    {131, 175, 105},     {134, 173, 109},     {136, 172, 113},     {139, 171, 117},
    {141, 169, 121},     {143, 168, 125},     {146, 166, 130},     {148, 165, 134},
    {151, 164, 138},     {153, 162, 142},     {156, 161, 146},     {158, 159, 150},
    {161, 158, 154},     {163, 157, 158},     {166, 155, 162},     {168, 154, 167},
    {171, 152, 171},     {173, 151, 175},     {175, 150, 179},     {178, 148, 183},
    {106, 189,  52},     {109, 187,  56},     {111, 186,  60},     {114, 184,  64},
    {116, 183,  69},     {119, 182,  73},     {121, 180,  77},     {124, 179,  81},
    {126, 178,  85},     {129, 176,  89},     {131, 175,  93},     {134, 173,  97},
    {136, 172, 101},     {138, 171, 106},     {141, 169, 110},     {143, 168, 114},
    {146, 166, 118},     {148, 165, 122},     {151, 164, 126},     {153, 162, 130},
    {156, 161, 134},     {158, 159, 138},     {161, 158, 143},     {163, 157, 147},
    {165, 155, 151},     {168, 154, 155},     {170, 153, 159},     {173, 151, 163},
    {175, 150, 167},     {178, 148, 171},     {180, 147, 175},     {183, 146, 180},
    {111, 186,  49},     {114, 185,  53},     {116, 183,  57},     {119, 182,  61},
    {121, 180,  65},     {124, 179,  69},     {126, 178,  73},     {129, 176,  77},
    {131, 175,  82},     {133, 173,  86},     {136, 172,  90},     {138, 171,  94},
    {141, 169,  98},     {143, 168, 102},     {146, 166, 106},     {148, 165, 110},
    {151, 164, 114},     {153, 162, 119},     {156, 161, 123},     {158, 160, 127},
    {160, 158, 131},     {163, 157, 135},     {165, 155, 139},     {168, 154, 143},
    {170, 153, 147},     {173, 151, 151},     {175, 150, 156},     {178, 148, 160},
    {180, 147, 164},     {183, 146, 168},     {185, 144, 172},     {188, 143, 176},
    {116, 183,  45},     {119, 182,  49},     {121, 180,  53},     {124, 179,  58},
    {126, 178,  62},     {128, 176,  66},     {131, 175,  70},     {133, 173,  74},
    {136, 172,  78},     {138, 171,  82},     {141, 169,  86},     {143, 168,  90},
    {146, 167,  95},     {148, 165,  99},     {151, 164, 103},     {153, 162, 107},
    {155, 161, 111},     {158, 160, 115},     {160, 158, 119},     {163, 157, 123},
    {165, 155, 127},     {168, 154, 132},     {170, 153, 136},     {173, 151, 140},
    {175, 150, 144},     {178, 148, 148},     {180, 147, 152},     {183, 146, 156},
    {185, 144, 160},     {187, 143, 164},     {190, 141, 169},     {192, 140, 173},
    {121, 180,  42},     {123, 179,  46},     {126, 178,  50},     {128, 176,  54},
    {131, 175,  58},     {133, 174,  62},     {136, 172,  66},     {138, 171,  71},
    {141, 169,  75},     {143, 168,  79},     {146, 167,  83},     {148, 165,  87},
    {150, 164,  91},     {153, 162,  95},     {155, 161,  99},     {158, 160, 103},
    {160, 158, 108},     {163, 157, 112},     {165, 155, 116},     {168, 154, 120},
    {170, 153, 124},     {173, 151, 128},     {175, 150, 132},     {178, 149, 136},
    {180, 147, 140},     {182, 146, 145},     {185, 144, 149},     {187, 143, 153},
    {190, 142, 157},     {192, 140, 161},     {195, 139, 165},     {197, 137, 169},
    {126, 178,  38},     {128, 176,  42},     {131, 175,  47},     {133, 174,  51},
    {136, 172,  55},     {138, 171,  59},     {141, 169,  63},     {143, 168,  67},
    {145, 167,  71},     {148, 165,  75},     {150, 164,  79},     {153, 162,  84},
    {155, 161,  88},     {158, 160,  92},     {160, 158,  96},     {163, 157, 100},
    {165, 156, 104},     {168, 154, 108},     {170, 153, 112},     {173, 151, 116},
    {175, 150, 121},     {177, 149, 125},     {180, 147, 129},     {182, 146, 133},
    {185, 144, 137},     {187, 143, 141},     {190, 142, 145},     {192, 140, 149},
    {195, 139, 153},     {197, 137, 158},     {200, 136, 162},     {202, 135, 166},
    {131, 175,  35},     {133, 174,  39},     {136, 172,  43},     {138, 171,  47},
    {140, 169,  51},     {143, 168,  55},     {145, 167,  60},     {148, 165,  64},
    {150, 164,  68},     {153, 163,  72},     {155, 161,  76},     {158, 160,  80},
    {160, 158,  84},     {163, 157,  88},     {165, 156,  92},     {168, 154,  97},
    {170, 153, 101},     {172, 151, 105},     {175, 150, 109},     {177, 149, 113},
    {180, 147, 117},     {182, 146, 121},     {185, 144, 125},     {187, 143, 129},
    {190, 142, 134},     {192, 140, 138},     {195, 139, 142},     {197, 138, 146},
    {199, 136, 150},     {202, 135, 154},     {204, 133, 158},     {207, 132, 162},
    {135, 172,  31},     {138, 171,  36},     {140, 170,  40},     {143, 168,  44},
    {145, 167,  48},     {148, 165,  52},     {150, 164,  56},     {153, 163,  60},
    {155, 161,  64},     {158, 160,  68},     {160, 158,  73},     {162, 157,  77},
    {165, 156,  81},     {167, 154,  85},     {170, 153,  89},     {172, 151,  93},
    {175, 150,  97},     {177, 149, 101},     {180, 147, 105},     {182, 146, 110},
    {185, 145, 114},     {187, 143, 118},     {190, 142, 122},     {192, 140, 126},
    {194, 139, 130},     {197, 138, 134},     {199, 136, 138},     {202, 135, 142},
    {204, 133, 147},     {207, 132, 151},     {209, 131, 155},     {212, 129, 159},
    {140, 170,  28},     {143, 168,  32},     {145, 167,  36},     {148, 165,  40},
    {150, 164,  44},     {153, 163,  49},     {155, 161,  53},     {157, 160,  57},
    {160, 158,  61},     {162, 157,  65},     {165, 156,  69},     {167, 154,  73},
    {170, 153,  77},     {172, 152,  81},     {175, 150,  86},     {177, 149,  90},
    {180, 147,  94},     {182, 146,  98},     {185, 145, 102},     {187, 143, 106},
    {189, 142, 110},     {192, 140, 114},     {194, 139, 118},     {197, 138, 123},
    {199, 136, 127},     {202, 135, 131},     {204, 133, 135},     {207, 132, 139},
    {209, 131, 143},     {212, 129, 147},     {214, 128, 151},     {217, 126, 155},
    {145, 167,  25},     {148, 165,  29},     {150, 164,  33},     {152, 163,  37},
    {155, 161,  41},     {157, 160,  45},     {160, 159,  49},     {162, 157,  53},
    {165, 156,  57},     {167, 154,  62},     {170, 153,  66},     {172, 152,  70},
    {175, 150,  74},     {177, 149,  78},     {180, 147,  82},     {182, 146,  86},
    {184, 145,  90},     {187, 143,  94},     {189, 142,  99},     {192, 140, 103},
    {194, 139, 107},     {197, 138, 111},     {199, 136, 115},     {202, 135, 119},
    {204, 134, 123},     {207, 132, 127},     {209, 131, 131},     {212, 129, 136},
    {214, 128, 140},     {216, 127, 144},     {219, 125, 148},     {221, 124, 152},
    {150, 164,  21},     {152, 163,  25},     {155, 161,  29},     {157, 160,  33},
    {160, 159,  38},     {162, 157,  42},     {165, 156,  46},     {167, 154,  50},
    {170, 153,  54},     {172, 152,  58},     {175, 150,  62},     {177, 149,  66},
    {179, 147,  70},     {182, 146,  75},     {184, 145,  79},     {187, 143,  83},
    {189, 142,  87},     {192, 141,  91},     {194, 139,  95},     {197, 138,  99},
    {199, 136, 103},     {202, 135, 107},     {204, 134, 112},     {206, 132, 116},
    {209, 131, 120},     {211, 129, 124},     {214, 128, 128},     {216, 127, 132},
    {219, 125, 136},     {221, 124, 140},     {224, 122, 144},     {226, 121, 149},
    {155, 161,  18},     {157, 160,  22},     {160, 159,  26},     {162, 157,  30},
    {165, 156,  34},     {167, 154,  38},     {170, 153,  42},     {172, 152,  46},
    {174, 150,  51},     {177, 149,  55},     {179, 148,  59},     {182, 146,  63},
    {184, 145,  67},     {187, 143,  71},     {189, 142,  75},     {192, 141,  79},
    {194, 139,  83},     {197, 138,  88},     {199, 136,  92},     {201, 135,  96},
    {204, 134, 100},     {206, 132, 104},     {209, 131, 108},     {211, 129, 112},
    {214, 128, 116},     {216, 127, 120},     {219, 125, 125},     {221, 124, 129},
    {224, 122, 133},     {226, 121, 137},     {229, 120, 141},     {231, 118, 145},
    {160, 159,  14},     {162, 157,  18},     {164, 156,  22},     {167, 155,  27},
    {169, 153,  31},     {172, 152,  35},     {174, 150,  39},     {177, 149,  43},
    {179, 148,  47},     {182, 146,  51},     {184, 145,  55},     {187, 143,  59},
    {189, 142,  64},     {192, 141,  68},     {194, 139,  72},     {196, 138,  76},
    {199, 136,  80},     {201, 135,  84},     {204, 134,  88},     {206, 132,  92},
    {209, 131,  96},     {211, 130, 101},     {214, 128, 105},     {216, 127, 109},
    {219, 125, 113},     {221, 124, 117},     {224, 123, 121},     {226, 121, 125},
    {228, 120, 129},     {231, 118, 133},     {233, 117, 138},     {236, 116, 142},
    {164, 156,  11},     {167, 155,  15},     {169, 153,  19},     {172, 152,  23},
    {174, 150,  27},     {177, 149,  31},     {179, 148,  35},     {182, 146,  40},
    {184, 145,  44},     {187, 143,  48},     {189, 142,  52},     {191, 141,  56},
    {194, 139,  60},     {196, 138,  64},     {199, 137,  68},     {201, 135,  72},
    {204, 134,  77},     {206, 132,  81},     {209, 131,  85},     {211, 130,  89},
    {214, 128,  93},     {216, 127,  97},     {219, 125, 101},     {221, 124, 105},
    {223, 123, 109},     {226, 121, 114},     {228, 120, 118},     {231, 118, 122},
    {233, 117, 126},     {236, 116, 130},     {238, 114, 134},     {241, 113, 138},
    {169, 153,   7},     {172, 152,  11},     {174, 150,  16},     {177, 149,  20},
    {179, 148,  24},     {182, 146,  28},     {184, 145,  32},     {186, 144,  36},
    {189, 142,  40},     {191, 141,  44},     {194, 139,  48},     {196, 138,  53},
    {199, 137,  57},     {201, 135,  61},     {204, 134,  65},     {206, 132,  69},
    {209, 131,  73},     {211, 130,  77},     {214, 128,  81},     {216, 127,  85},
    {218, 125,  90},     {221, 124,  94},     {223, 123,  98},     {226, 121, 102},
    {228, 120, 106},     {231, 118, 110},     {233, 117, 114},     {236, 116, 118},
    {238, 114, 122},     {241, 113, 127},     {243, 112, 131},     {245, 110, 135},
    {174, 151,   4},     {177, 149,   8},     {179, 148,  12},     {181, 146,  16},
    {184, 145,  20},     {186, 144,  24},     {189, 142,  29},     {191, 141,  33},
    {194, 139,  37},     {196, 138,  41},     {199, 137,  45},     {201, 135,  49},
    {204, 134,  53},     {206, 132,  57},     {208, 131,  61},     {211, 130,  66},
    {213, 128,  70},     {216, 127,  74},     {218, 126,  78},     {221, 124,  82},
    {223, 123,  86},     {226, 121,  90},     {228, 120,  94},     {231, 119,  98},
    {233, 117, 103},     {236, 116, 107},     {238, 114, 111},     {240, 113, 115},
    {243, 112, 119},     {245, 110, 123},     {248, 109, 127},     {250, 107, 131},
    { 25, 239, 110},     { 28, 238, 114},     { 30, 236, 118},     { 33, 235, 122},
    { 35, 233, 126},     { 38, 232, 131},     { 40, 231, 135},     { 43, 229, 139},
    { 45, 228, 143},     { 47, 227, 147},     { 50, 225, 151},     { 52, 224, 155},
    { 55, 222, 159},     { 57, 221, 163},     { 60, 220, 168},     { 62, 218, 172},
    { 65, 217, 176},     { 67, 215, 180},     { 70, 214, 184},     { 72, 213, 188},
    { 75, 211, 192},     { 77, 210, 196},     { 79, 208, 200},     { 82, 207, 205},
    { 84, 206, 209},     { 87, 204, 213},     { 89, 203, 217},     { 92, 202, 221},
    { 94, 200, 225},     { 97, 199, 229},     { 99, 197, 233},     {102, 196, 238},
    { 30, 236, 107},     { 33, 235, 111},     { 35, 234, 115},     { 38, 232, 119},
    { 40, 231, 123},     { 42, 229, 127},     { 45, 228, 131},     { 47, 227, 135},
    { 50, 225, 139},     { 52, 224, 144},     { 55, 222, 148},     { 57, 221, 152},
    { 60, 220, 156},     { 62, 218, 160},     { 65, 217, 164},     { 67, 215, 168},
    { 69, 214, 172},     { 72, 213, 176},     { 74, 211, 181},     { 77, 210, 185},
    { 79, 209, 189},     { 82, 207, 193},     { 84, 206, 197},     { 87, 204, 201},
    { 89, 203, 205},     { 92, 202, 209},     { 94, 200, 213},     { 97, 199, 218},
    { 99, 197, 222},     {101, 196, 226},     {104, 195, 230},     {106, 193, 234},
    { 35, 234, 103},     { 37, 232, 107},     { 40, 231, 111},     { 42, 229, 115},
    { 45, 228, 120},     { 47, 227, 124},     { 50, 225, 128},     { 52, 224, 132},
    { 55, 222, 136},     { 57, 221, 140},     { 60, 220, 144},     { 62, 218, 148},
    { 64, 217, 152},     { 67, 216, 157},     { 69, 214, 161},     { 72, 213, 165},
    { 74, 211, 169},     { 77, 210, 173},     { 79, 209, 177},     { 82, 207, 181},
    { 84, 206, 185},     { 87, 204, 189},     { 89, 203, 194},     { 92, 202, 198},
    { 94, 200, 202},     { 96, 199, 206},     { 99, 197, 210},     {101, 196, 214},
    {104, 195, 218},     {106, 193, 222},     {109, 192, 227},     {111, 191, 231},
    { 40, 231, 100},     { 42, 229, 104},     { 45, 228, 108},     { 47, 227, 112},
    { 50, 225, 116},     { 52, 224, 120},     { 55, 223, 124},     { 57, 221, 128},
    { 59, 220, 133},     { 62, 218, 137},     { 64, 217, 141},     { 67, 216, 145},
    { 69, 214, 149},     { 72, 213, 153},     { 74, 211, 157},     { 77, 210, 161},
    { 79, 209, 165},     { 82, 207, 170},     { 84, 206, 174},     { 87, 204, 178},
    { 89, 203, 182},     { 91, 202, 186},     { 94, 200, 190},     { 96, 199, 194},
    { 99, 198, 198},     {101, 196, 202},     {104, 195, 207},     {106, 193, 211},
    {109, 192, 215},     {111, 191, 219},     {114, 189, 223},     {116, 188, 227},
    { 45, 228,  96},     { 47, 227, 100},     { 50, 225, 104},     { 52, 224, 109},
    { 54, 223, 113},     { 57, 221, 117},     { 59, 220, 121},     { 62, 218, 125},
    { 64, 217, 129},     { 67, 216, 133},     { 69, 214, 137},     { 72, 213, 141},
    { 74, 211, 146},     { 77, 210, 150},     { 79, 209, 154},     { 82, 207, 158},
    { 84, 206, 162},     { 86, 205, 166},     { 89, 203, 170},     { 91, 202, 174},
    { 94, 200, 178},     { 96, 199, 183},     { 99, 198, 187},     {101, 196, 191},
    {104, 195, 195},     {106, 193, 199},     {109, 192, 203},     {111, 191, 207},
    {113, 189, 211},     {116, 188, 215},     {118, 186, 220},     {121, 185, 224},
    { 49, 225,  93},     { 52, 224,  97},     { 54, 223, 101},     { 57, 221, 105},
    { 59, 220, 109},     { 62, 218, 113},     { 64, 217, 117},     { 67, 216, 122},
    { 69, 214, 126},     { 72, 213, 130},     { 74, 212, 134},     { 77, 210, 138},
    { 79, 209, 142},     { 81, 207, 146},     { 84, 206, 150},     { 86, 205, 154},
    { 89, 203, 159},     { 91, 202, 163},     { 94, 200, 167},     { 96, 199, 171},
    { 99, 198, 175},     {101, 196, 179},     {104, 195, 183},     {106, 193, 187},
    {108, 192, 191},     {111, 191, 196},     {113, 189, 200},     {116, 188, 204},
    {118, 187, 208},     {121, 185, 212},     {123, 184, 216},     {126, 182, 220},
    { 54, 223,  89},     { 57, 221,  93},     { 59, 220,  98},     { 62, 219, 102},
    { 64, 217, 106},     { 67, 216, 110},     { 69, 214, 114},     { 72, 213, 118},
    { 74, 212, 122},     { 76, 210, 126},     { 79, 209, 130},     { 81, 207, 135},
    { 84, 206, 139},     { 86, 205, 143},     { 89, 203, 147},     { 91, 202, 151},
    { 94, 200, 155},     { 96, 199, 159},     { 99, 198, 163},     {101, 196, 167},
    {103, 195, 172},     {106, 194, 176},     {108, 192, 180},     {111, 191, 184},
    {113, 189, 188},     {116, 188, 192},     {118, 187, 196},     {121, 185, 200},
    {123, 184, 204},     {126, 182, 209},     {128, 181, 213},     {131, 180, 217},
    { 59, 220,  86},     { 62, 219,  90},     { 64, 217,  94},     { 66, 216,  98},
    { 69, 214, 102},     { 71, 213, 106},     { 74, 212, 111},     { 76, 210, 115},
    { 79, 209, 119},     { 81, 207, 123},     { 84, 206, 127},     { 86, 205, 131},
    { 89, 203, 135},     { 91, 202, 139},     { 94, 201, 143},     { 96, 199, 148},
    { 98, 198, 152},     {101, 196, 156},     {103, 195, 160},     {106, 194, 164},
    {108, 192, 168},     {111, 191, 172},     {113, 189, 176},     {116, 188, 180},
    {118, 187, 185},     {121, 185, 189},     {123, 184, 193},     {126, 182, 197},
    {128, 181, 201},     {130, 180, 205},     {133, 178, 209},     {135, 177, 213},
    { 64, 217,  82},     { 66, 216,  87},     { 69, 214,  91},     { 71, 213,  95},
    { 74, 212,  99},     { 76, 210, 103},     { 79, 209, 107},     { 81, 208, 111},
    { 84, 206, 115},     { 86, 205, 119},     { 89, 203, 124},     { 91, 202, 128},
    { 93, 201, 132},     { 96, 199, 136},     { 98, 198, 140},     {101, 196, 144},
    {103, 195, 148},     {106, 194, 152},     {108, 192, 156},     {111, 191, 161},
    {113, 189, 165},     {116, 188, 169},     {118, 187, 173},     {121, 185, 177},
    {123, 184, 181},     {125, 183, 185},     {128, 181, 189},     {130, 180, 193},
    {133, 178, 198},     {135, 177, 202},     {138, 176, 206},     {140, 174, 210},
    { 69, 215,  79},     { 71, 213,  83},     { 74, 212,  87},     { 76, 210,  91},
    { 79, 209,  95},     { 81, 208, 100},     { 84, 206, 104},     { 86, 205, 108},
    { 88, 203, 112},     { 91, 202, 116},     { 93, 201, 120},     { 96, 199, 124},
    { 98, 198, 128},     {101, 196, 132},     {103, 195, 137},     {106, 194, 141},
    {108, 192, 145},     {111, 191, 149},     {113, 190, 153},     {116, 188, 157},
    {118, 187, 161},     {120, 185, 165},     {123, 184, 169},     {125, 183, 174},
    {128, 181, 178},     {130, 180, 182},     {133, 178, 186},     {135, 177, 190},
    {138, 176, 194},     {140, 174, 198},     {143, 173, 202},     {145, 171, 206},
    { 74, 212,  76},     { 76, 210,  80},     { 79, 209,  84},     { 81, 208,  88},
    { 83, 206,  92},     { 86, 205,  96},     { 88, 203, 100},     { 91, 202, 104},
    { 93, 201, 108},     { 96, 199, 113},     { 98, 198, 117},     {101, 197, 121},
    {103, 195, 125},     {106, 194, 129},     {108, 192, 133},     {110, 191, 137},
    {113, 190, 141},     {115, 188, 145},     {118, 187, 150},     {120, 185, 154},
    {123, 184, 158},     {125, 183, 162},     {128, 181, 166},     {130, 180, 170},
    {133, 178, 174},     {135, 177, 178},     {138, 176, 182},     {140, 174, 187},
    {142, 173, 191},     {145, 172, 195},     {147, 170, 199},     {150, 169, 203},
    { 78, 209,  72},     { 81, 208,  76},     { 83, 206,  80},     { 86, 205,  84},
    { 88, 204,  89},     { 91, 202,  93},     { 93, 201,  97},     { 96, 199, 101},
    { 98, 198, 105},     {101, 197, 109},     {103, 195, 113},     {105, 194, 117},
    {108, 192, 121},     {110, 191, 126},     {113, 190, 130},     {115, 188, 134},
    {118, 187, 138},     {120, 185, 142},     {123, 184, 146},     {125, 183, 150},
    {128, 181, 154},     {130, 180, 158},     {133, 179, 163},     {135, 177, 167},
    {137, 176, 171},     {140, 174, 175},     {142, 173, 179},     {145, 172, 183},
    {147, 170, 187},     {150, 169, 191},     {152, 167, 195},     {155, 166, 200},
    { 83, 206,  69},     { 86, 205,  73},     { 88, 204,  77},     { 91, 202,  81},
    { 93, 201,  85},     { 96, 199,  89},     { 98, 198,  93},     {100, 197,  97},
    {103, 195, 102},     {105, 194, 106},     {108, 192, 110},     {110, 191, 114},
    {113, 190, 118},     {115, 188, 122},     {118, 187, 126},     {120, 186, 130},
    {123, 184, 134},     {125, 183, 139},     {128, 181, 143},     {130, 180, 147},
    {132, 179, 151},     {135, 177, 155},     {137, 176, 159},     {140, 174, 163},
    {142, 173, 167},     {145, 172, 171},     {147, 170, 176},     {150, 169, 180},
    {152, 167, 184},     {155, 166, 188},     {157, 165, 192},     {160, 163, 196},
    { 88, 204,  65},     { 91, 202,  69},     { 93, 201,  73},     { 95, 199,  78},
    { 98, 198,  82},     {100, 197,  86},     {103, 195,  90},     {105, 194,  94},
    {108, 193,  98},     {110, 191, 102},     {113, 190, 106},     {115, 188, 110},
    {118, 187, 115},     {120, 186, 119},     {123, 184, 123},     {125, 183, 127},
    {127, 181, 131},     {130, 180, 135},     {132, 179, 139},     {135, 177, 143},
    {137, 176, 147},     {140, 174, 152},     {142, 173, 156},     {145, 172, 160},
    {147, 170, 164},     {150, 169, 168},     {152, 168, 172},     {154, 166, 176},
    {157, 165, 180},     {159, 163, 184},     {162, 162, 189},     {164, 161, 193},
    { 93, 201,  62},     { 95, 200,  66},     { 98, 198,  70},     {100, 197,  74},
    {103, 195,  78},     {105, 194,  82},     {108, 193,  86},     {110, 191,  91},
    {113, 190,  95},     {115, 188,  99},     {118, 187, 103},     {120, 186, 107},
    {122, 184, 111},     {125, 183, 115},     {127, 181, 119},     {130, 180, 123},
    {132, 179, 128},     {135, 177, 132},     {137, 176, 136},     {140, 175, 140},
    {142, 173, 144},     {145, 172, 148},     {147, 170, 152},     {149, 169, 156},
    {152, 168, 160},     {154, 166, 165},     {157, 165, 169},     {159, 163, 173},
    {162, 162, 177},     {164, 161, 181},     {167, 159, 185},     {169, 158, 189},
    { 98, 198,  58},     {100, 197,  62},     {103, 195,  67},     {105, 194,  71},
    {108, 193,  75},     {110, 191,  79},     {113, 190,  83},     {115, 188,  87},
    {117, 187,  91},     {120, 186,  95},     {122, 184,  99},     {125, 183, 104},
    {127, 182, 108},     {130, 180, 112},     {132, 179, 116},     {135, 177, 120},
    {137, 176, 124},     {140, 175, 128},     {142, 173, 132},     {144, 172, 136},
    {147, 170, 141},     {149, 169, 145},     {152, 168, 149},     {154, 166, 153},
    {157, 165, 157},     {159, 163, 161},     {162, 162, 165},     {164, 161, 169},
    {167, 159, 173},     {169, 158, 178},     {172, 157, 182},     {174, 155, 186},
    {103, 195,  55},     {105, 194,  59},     {107, 193,  63},     {110, 191,  67},
    {112, 190,  71},     {115, 189,  75},     {117, 187,  80},     {120, 186,  84},
    {122, 184,  88},     {125, 183,  92},     {127, 182,  96},     {130, 180, 100},
    {132, 179, 104},     {135, 177, 108},     {137, 176, 112},     {139, 175, 117},
    {142, 173, 121},     {144, 172, 125},     {147, 170, 129},     {149, 169, 133},
    {152, 168, 137},     {154, 166, 141},     {157, 165, 145},     {159, 164, 149},
    {162, 162, 154},     {164, 161, 158},     {167, 159, 162},     {169, 158, 166},
    {171, 157, 170},     {174, 155, 174},     {176, 154, 178},     {179, 152, 182},
    {107, 193,  51},     {110, 191,  56},     {112, 190,  60},     {115, 189,  64},
    {117, 187,  68},     {120, 186,  72},     {122, 184,  76},     {125, 183,  80},
    {127, 182,  84},     {130, 180,  88},     {132, 179,  93},     {134, 177,  97},
    {137, 176, 101},     {139, 175, 105},     {142, 173, 109},     {144, 172, 113},
    {147, 171, 117},     {149, 169, 121},     {152, 168, 125},     {154, 166, 130},
    {157, 165, 134},     {159, 164, 138},     {162, 162, 142},     {164, 161, 146},
    {166, 159, 150},     {169, 158, 154},     {171, 157, 158},     {174, 155, 162},
    {176, 154, 167},     {179, 152, 171},     {181, 151, 175},     {184, 150, 179},
    {112, 190,  48},     {115, 189,  52},     {117, 187,  56},     {120, 186,  60},
    {122, 184,  64},     {125, 183,  69},     {127, 182,  73},     {129, 180,  77},
    {132, 179,  81},     {134, 178,  85},     {137, 176,  89},     {139, 175,  93},
    {142, 173,  97},     {144, 172, 101},     {147, 171, 106},     {149, 169, 110},
    {152, 168, 114},     {154, 166, 118},     {157, 165, 122},     {159, 164, 126},
    {161, 162, 130},     {164, 161, 134},     {166, 159, 138},     {169, 158, 143},
    {171, 157, 147},     {174, 155, 151},     {176, 154, 155},     {179, 153, 159},
    {181, 151, 163},     {184, 150, 167},     {186, 148, 171},     {188, 147, 175},
    {117, 187,  45},     {120, 186,  49},     {122, 185,  53},     {124, 183,  57},
    {127, 182,  61},     {129, 180,  65},     {132, 179,  69},     {134, 178,  73},
    {137, 176,  77},     {139, 175,  82},     {142, 173,  86},     {144, 172,  90},
    {147, 171,  94},     {149, 169,  98},     {151, 168, 102},     {154, 166, 106},
    {156, 165, 110},     {159, 164, 114},     {161, 162, 119},     {164, 161, 123},
    {166, 160, 127},     {169, 158, 131},     {171, 157, 135},     {174, 155, 139},
    {176, 154, 143},     {179, 153, 147},     {181, 151, 151},     {183, 150, 156},
    {186, 148, 160},     {188, 147, 164},     {191, 146, 168},     {193, 144, 172},
    {122, 185,  41},     {124, 183,  45},     {127, 182,  49},     {129, 180,  53},
    {132, 179,  58},     {134, 178,  62},     {137, 176,  66},     {139, 175,  70},
    {142, 173,  74},     {144, 172,  78},     {146, 171,  82},     {149, 169,  86},
    {151, 168,  90},     {154, 167,  95},     {156, 165,  99},     {159, 164, 103},
    {161, 162, 107},     {164, 161, 111},     {166, 160, 115},     {169, 158, 119},
    {171, 157, 123},     {174, 155, 127},     {176, 154, 132},     {178, 153, 136},
    {181, 151, 140},     {183, 150, 144},     {186, 148, 148},     {188, 147, 152},
    {191, 146, 156},     {193, 144, 160},     {196, 143, 164},     {198, 141, 169},
    {127, 182,  38},     {129, 180,  42},     {132, 179,  46},     {134, 178,  50},
    {137, 176,  54},     {139, 175,  58},     {141, 174,  62},     {144, 172,  66},
    {146, 171,  71},     {149, 169,  75},     {151, 168,  79},     {154, 167,  83},
    {156, 165,  87},     {159, 164,  91},     {161, 162,  95},     {164, 161,  99},
    {166, 160, 103},     {169, 158, 108},     {171, 157, 112},     {173, 155, 116},
    {176, 154, 120},     {178, 153, 124},     {181, 151, 128},     {183, 150, 132},
    {186, 149, 136},     {188, 147, 140},     {191, 146, 145},     {193, 144, 149},
    {196, 143, 153},     {198, 142, 157},     {201, 140, 161},     {203, 139, 165},
    {132, 179,  34},     {134, 178,  38},     {136, 176,  42},     {139, 175,  47},
    {141, 174,  51},     {144, 172,  55},     {146, 171,  59},     {149, 169,  63},
    {151, 168,  67},     {154, 167,  71},     {156, 165,  75},     {159, 164,  79},
    {161, 162,  84},     {164, 161,  88},     {166, 160,  92},     {168, 158,  96},
    {171, 157, 100},     {173, 156, 104},     {176, 154, 108},     {178, 153, 112},
    {181, 151, 116},     {183, 150, 121},     {186, 149, 125},     {188, 147, 129},
    {191, 146, 133},     {193, 144, 137},     {195, 143, 141},     {198, 142, 145},
    {200, 140, 149},     {203, 139, 153},     {205, 137, 158},     {208, 136, 162},
    {136, 176,  31},     {139, 175,  35},     {141, 174,  39},     {144, 172,  43},
    {146, 171,  47},     {149, 169,  51},     {151, 168,  55},     {154, 167,  60},
    {156, 165,  64},     {159, 164,  68},     {161, 163,  72},     {163, 161,  76},
    {166, 160,  80},     {168, 158,  84},     {171, 157,  88},     {173, 156,  92},
    {176, 154,  97},     {178, 153, 101},     {181, 151, 105},     {183, 150, 109},
    {186, 149, 113},     {188, 147, 117},     {190, 146, 121},     {193, 144, 125},
    {195, 143, 129},     {198, 142, 134},     {200, 140, 138},     {203, 139, 142},
    {205, 138, 146},     {208, 136, 150},     {210, 135, 154},     {213, 133, 158},
    {141, 174,  27},     {144, 172,  31},     {146, 171,  36},     {149, 170,  40},
    {151, 168,  44},     {154, 167,  48},     {156, 165,  52},     {158, 164,  56},
    {161, 163,  60},     {163, 161,  64},     {166, 160,  68},     {168, 158,  73},
    {171, 157,  77},     {173, 156,  81},     {176, 154,  85},     {178, 153,  89},
    {181, 151,  93},     {183, 150,  97},     {185, 149, 101},     {188, 147, 105},
    {190, 146, 110},     {193, 145, 114},     {195, 143, 118},     {198, 142, 122},
    {200, 140, 126},     {203, 139, 130},     {205, 138, 134},     {208, 136, 138},
    {210, 135, 142},     {213, 133, 147},     {215, 132, 151},     {217, 131, 155},
    {146, 171,  24},     {148, 170,  28},     {151, 168,  32},     {153, 167,  36},
    {156, 165,  40},     {158, 164,  44},     {161, 163,  49},     {163, 161,  53},
    {166, 160,  57},     {168, 158,  61},     {171, 157,  65},     {173, 156,  69},
    {176, 154,  73},     {178, 153,  77},     {180, 152,  81},     {183, 150,  86},
    {185, 149,  90},     {188, 147,  94},     {190, 146,  98},     {193, 145, 102},
    {195, 143, 106},     {198, 142, 110},     {200, 140, 114},     {203, 139, 118},
    {205, 138, 123},     {208, 136, 127},     {210, 135, 131},     {212, 133, 135},
    {215, 132, 139},     {217, 131, 143},     {220, 129, 147},     {222, 128, 151},
    {151, 168,  20},     {153, 167,  25},     {156, 165,  29},     {158, 164,  33},
    {161, 163,  37},     {163, 161,  41},     {166, 160,  45},     {168, 159,  49},
    {171, 157,  53},     {173, 156,  57},     {175, 154,  62},     {178, 153,  66},
    {180, 152,  70},     {183, 150,  74},     {185, 149,  78},     {188, 147,  82},
    {190, 146,  86},     {193, 145,  90},     {195, 143,  94},     {198, 142,  99},
    {200, 140, 103},     {203, 139, 107},     {205, 138, 111},     {207, 136, 115},
    {210, 135, 119},     {212, 134, 123},     {215, 132, 127},     {217, 131, 131},
    {220, 129, 136},     {222, 128, 140},     {225, 127, 144},     {227, 125, 148},
    {156, 166,  17},     {158, 164,  21},     {161, 163,  25},     {163, 161,  29},
    {166, 160,  33},     {168, 159,  38},     {170, 157,  42},     {173, 156,  46},
    {175, 154,  50},     {178, 153,  54},     {180, 152,  58},     {183, 150,  62},
    {185, 149,  66},     {188, 147,  70},     {190, 146,  75},     {193, 145,  79},
    {195, 143,  83},     {198, 142,  87},     {200, 141,  91},     {202, 139,  95},
    {205, 138,  99},     {207, 136, 103},     {210, 135, 107},     {212, 134, 112},
    {215, 132, 116},     {217, 131, 120},     {220, 129, 124},     {222, 128, 128},
    {225, 127, 132},     {227, 125, 136},     {229, 124, 140},     {232, 122, 144},
    {161, 163,  14},     {163, 161,  18},     {165, 160,  22},     {168, 159,  26},
    {170, 157,  30},     {173, 156,  34},     {175, 154,  38},     {178, 153,  42},
    {180, 152,  46},     {183, 150,  51},     {185, 149,  55},     {188, 148,  59},
    {190, 146,  63},     {192, 145,  67},     {195, 143,  71},     {197, 142,  75},
    {200, 141,  79},     {202, 139,  83},     {205, 138,  88},     {207, 136,  92},
    {210, 135,  96},     {212, 134, 100},     {215, 132, 104},     {217, 131, 108},
    {220, 129, 112},     {222, 128, 116},     {224, 127, 120},     {227, 125, 125},
    {229, 124, 129},     {232, 122, 133},     {234, 121, 137},     {237, 120, 141},
    {165, 160,  10},     {168, 159,  14},     {170, 157,  18},     {173, 156,  22},
    {175, 155,  27},     {178, 153,  31},     {180, 152,  35},     {183, 150,  39},
    {185, 149,  43},     {187, 148,  47},     {190, 146,  51},     {192, 145,  55},
    {195, 143,  59},     {197, 142,  64},     {200, 141,  68},     {202, 139,  72},
    {205, 138,  76},     {207, 136,  80},     {210, 135,  84},     {212, 134,  88},
    {215, 132,  92},     {217, 131,  96},     {219, 130, 101},     {222, 128, 105},
    {224, 127, 109},     {227, 125, 113},     {229, 124, 117},     {232, 123, 121},
    {234, 121, 125},     {237, 120, 129},     {239, 118, 133},     {242, 117, 138},
    {170, 157,   7},     {173, 156,  11},     {175, 155,  15},     {178, 153,  19},
    {180, 152,  23},     {182, 150,  27},     {185, 149,  31},     {187, 148,  35},
    {190, 146,  40},     {192, 145,  44},     {195, 143,  48},     {197, 142,  52},
    {200, 141,  56},     {202, 139,  60},     {205, 138,  64},     {207, 137,  68},
    {210, 135,  72},     {212, 134,  77},     {214, 132,  81},     {217, 131,  85},
    {219, 130,  89},     {222, 128,  93},     {224, 127,  97},     {227, 125, 101},
    {229, 124, 105},     {232, 123, 109},     {234, 121, 114},     {237, 120, 118},
    {239, 118, 122},     {242, 117, 126},     {244, 116, 130},     {246, 114, 134},
    {175, 155,   3},     {177, 153,   7},     {180, 152,  11},     {182, 150,  16},
    {185, 149,  20},     {187, 148,  24},     {190, 146,  28},     {192, 145,  32},
    {195, 144,  36},     {197, 142,  40},     {200, 141,  44},     {202, 139,  48},
    {205, 138,  53},     {207, 137,  57},     {209, 135,  61},     {212, 134,  65},
    {214, 132,  69},     {217, 131,  73},     {219, 130,  77},     {222, 128,  81},
    {224, 127,  85},     {227, 125,  90},     {229, 124,  94},     {232, 123,  98},
    {234, 121, 102},     {236, 120, 106},     {239, 118, 110},     {241, 117, 114},
    {244, 116, 118},     {246, 114, 122},     {249, 113, 127},     {251, 112, 131},
    { 26, 243, 109},     { 29, 242, 113},     { 31, 240, 118},     { 34, 239, 122},
    { 36, 238, 126},     { 39, 236, 130},     { 41, 235, 134},     { 43, 233, 138},
    { 46, 232, 142},     { 48, 231, 146},     { 51, 229, 150},     { 53, 228, 155},
    { 56, 226, 159},     { 58, 225, 163},     { 61, 224, 167},     { 63, 222, 171},
    { 66, 221, 175},     { 68, 220, 179},     { 71, 218, 183},     { 73, 217, 187},
    { 75, 215, 192},     { 78, 214, 196},     { 80, 213, 200},     { 83, 211, 204},
    { 85, 210, 208},     { 88, 208, 212},     { 90, 207, 216},     { 93, 206, 220},
    { 95, 204, 225},     { 98, 203, 229},     {100, 201, 233},     {103, 200, 237},
    { 31, 240, 106},     { 34, 239, 110},     { 36, 238, 114},     { 38, 236, 118},
    { 41, 235, 122},     { 43, 233, 126},     { 46, 232, 131},     { 48, 231, 135},
    { 51, 229, 139},     { 53, 228, 143},     { 56, 227, 147},     { 58, 225, 151},
    { 61, 224, 155},     { 63, 222, 159},     { 66, 221, 163},     { 68, 220, 168},
    { 70, 218, 172},     { 73, 217, 176},     { 75, 215, 180},     { 78, 214, 184},
    { 80, 213, 188},     { 83, 211, 192},     { 85, 210, 196},     { 88, 208, 200},
    { 90, 207, 205},     { 93, 206, 209},     { 95, 204, 213},     { 97, 203, 217},
    {100, 202, 221},     {102, 200, 225},     {105, 199, 229},     {107, 197, 233},
    { 36, 238, 102},     { 38, 236, 107},     { 41, 235, 111},     { 43, 234, 115},
    { 46, 232, 119},     { 48, 231, 123},     { 51, 229, 127},     { 53, 228, 131},
    { 56, 227, 135},     { 58, 225, 139},     { 61, 224, 144},     { 63, 222, 148},
    { 65, 221, 152},     { 68, 220, 156},     { 70, 218, 160},     { 73, 217, 164},
    { 75, 215, 168},     { 78, 214, 172},     { 80, 213, 176},     { 83, 211, 181},
    { 85, 210, 185},     { 88, 209, 189},     { 90, 207, 193},     { 92, 206, 197},
    { 95, 204, 201},     { 97, 203, 205},     {100, 202, 209},     {102, 200, 213},
    {105, 199, 218},     {107, 197, 222},     {110, 196, 226},     {112, 195, 230},
    { 41, 235,  99},     { 43, 234, 103},     { 46, 232, 107},     { 48, 231, 111},
    { 51, 229, 115},     { 53, 228, 120},     { 55, 227, 124},     { 58, 225, 128},
    { 60, 224, 132},     { 63, 222, 136},     { 65, 221, 140},     { 68, 220, 144},
    { 70, 218, 148},     { 73, 217, 152},     { 75, 216, 157},     { 78, 214, 161},
    { 80, 213, 165},     { 83, 211, 169},     { 85, 210, 173},     { 87, 209, 177},
    { 90, 207, 181},     { 92, 206, 185},     { 95, 204, 189},     { 97, 203, 194},
    {100, 202, 198},     {102, 200, 202},     {105, 199, 206},     {107, 197, 210},
    {110, 196, 214},     {112, 195, 218},     {115, 193, 222},     {117, 192, 227},
    { 46, 232,  96},     { 48, 231, 100},     { 50, 229, 104},     { 53, 228, 108},
    { 55, 227, 112},     { 58, 225, 116},     { 60, 224, 120},     { 63, 223, 124},
    { 65, 221, 128},     { 68, 220, 133},     { 70, 218, 137},     { 73, 217, 141},
    { 75, 216, 145},     { 78, 214, 149},     { 80, 213, 153},     { 82, 211, 157},
    { 85, 210, 161},     { 87, 209, 165},     { 90, 207, 170},     { 92, 206, 174},
    { 95, 204, 178},     { 97, 203, 182},     {100, 202, 186},     {102, 200, 190},
    {105, 199, 194},     {107, 198, 198},     {110, 196, 202},     {112, 195, 207},
    {114, 193, 211},     {117, 192, 215},     {119, 191, 219},     {122, 189, 223},
    { 50, 230,  92},     { 53, 228,  96},     { 55, 227, 100},     { 58, 225, 104},
    { 60, 224, 109},     { 63, 223, 113},     { 65, 221, 117},     { 68, 220, 121},
    { 70, 218, 125},     { 73, 217, 129},     { 75, 216, 133},     { 77, 214, 137},
    { 80, 213, 141},     { 82, 211, 146},     { 85, 210, 150},     { 87, 209, 154},
    { 90, 207, 158},     { 92, 206, 162},     { 95, 205, 166},     { 97, 203, 170},
    {100, 202, 174},     {102, 200, 178},     {105, 199, 183},     {107, 198, 187},
    {109, 196, 191},     {112, 195, 195},     {114, 193, 199},     {117, 192, 203},
    {119, 191, 207},     {122, 189, 211},     {124, 188, 215},     {127, 186, 220},
    { 55, 227,  89},     { 58, 225,  93},     { 60, 224,  97},     { 63, 223, 101},
    { 65, 221, 105},     { 68, 220, 109},     { 70, 218, 113},     { 72, 217, 117},
    { 75, 216, 122},     { 77, 214, 126},     { 80, 213, 130},     { 82, 212, 134},
    { 85, 210, 138},     { 87, 209, 142},     { 90, 207, 146},     { 92, 206, 150},
    { 95, 205, 154},     { 97, 203, 159},     { 99, 202, 163},     {102, 200, 167},
    {104, 199, 171},     {107, 198, 175},     {109, 196, 179},     {112, 195, 183},
    {114, 193, 187},     {117, 192, 191},     {119, 191, 196},     {122, 189, 200},
    {124, 188, 204},     {127, 187, 208},     {129, 185, 212},     {131, 184, 216},
    { 60, 224,  85},     { 63, 223,  89},     { 65, 221,  93},     { 67, 220,  98},
    { 70, 219, 102},     { 72, 217, 106},     { 75, 216, 110},     { 77, 214, 114},
    { 80, 213, 118},     { 82, 212, 122},     { 85, 210, 126},     { 87, 209, 130},
    { 90, 207, 135},     { 92, 206, 139},     { 94, 205, 143},     { 97, 203, 147},
    { 99, 202, 151},     {102, 200, 155},     {104, 199, 159},     {107, 198, 163},
    {109, 196, 167},     {112, 195, 172},     {114, 194, 176},     {117, 192, 180},
    {119, 191, 184},     {122, 189, 188},     {124, 188, 192},     {126, 187, 196},
    {129, 185, 200},     {131, 184, 204},     {134, 182, 209},     {136, 181, 213},
    { 65, 221,  82},     { 67, 220,  86},     { 70, 219,  90},     { 72, 217,  94},
    { 75, 216,  98},     { 77, 214, 102},     { 80, 213, 106},     { 82, 212, 111},
    { 85, 210, 115},     { 87, 209, 119},     { 89, 207, 123},     { 92, 206, 127},
    { 94, 205, 131},     { 97, 203, 135},     { 99, 202, 139},     {102, 201, 143},
    {104, 199, 148},     {107, 198, 152},     {109, 196, 156},     {112, 195, 160},
    {114, 194, 164},     {117, 192, 168},     {119, 191, 172},     {121, 189, 176},
    {124, 188, 180},     {126, 187, 185},     {129, 185, 189},     {131, 184, 193},
    {134, 182, 197},     {136, 181, 201},     {139, 180, 205},     {141, 178, 209},
    { 70, 219,  78},     { 72, 217,  82},     { 75, 216,  87},     { 77, 214,  91},
    { 80, 213,  95},     { 82, 212,  99},     { 84, 210, 103},     { 87, 209, 107},
    { 89, 208, 111},     { 92, 206, 115},     { 94, 205, 119},     { 97, 203, 124},
    { 99, 202, 128},     {102, 201, 132},     {104, 199, 136},     {107, 198, 140},
    {109, 196, 144},     {112, 195, 148},     {114, 194, 152},     {116, 192, 156},
    {119, 191, 161},     {121, 189, 165},     {124, 188, 169},     {126, 187, 173},
    {129, 185, 177},     {131, 184, 181},     {134, 183, 185},     {136, 181, 189},
    {139, 180, 193},     {141, 178, 198},     {143, 177, 202},     {146, 176, 206},
    { 75, 216,  75},     { 77, 215,  79},     { 79, 213,  83},     { 82, 212,  87},
    { 84, 210,  91},     { 87, 209,  95},     { 89, 208, 100},     { 92, 206, 104},
    { 94, 205, 108},     { 97, 203, 112},     { 99, 202, 116},     {102, 201, 120},
    {104, 199, 124},     {107, 198, 128},     {109, 196, 132},     {111, 195, 137},
    {114, 194, 141},     {116, 192, 145},     {119, 191, 149},     {121, 190, 153},
    {124, 188, 157},     {126, 187, 161},     {129, 185, 165},     {131, 184, 169},
    {134, 183, 174},     {136, 181, 178},     {138, 180, 182},     {141, 178, 186},
    {143, 177, 190},     {146, 176, 194},     {148, 174, 198},     {151, 173, 202},
    { 79, 213,  71},     { 82, 212,  76},     { 84, 210,  80},     { 87, 209,  84},
    { 89, 208,  88},     { 92, 206,  92},     { 94, 205,  96},     { 97, 203, 100},
    { 99, 202, 104},     {102, 201, 108},     {104, 199, 113},     {106, 198, 117},
    {109, 197, 121},     {111, 195, 125},     {114, 194, 129},     {116, 192, 133},
    {119, 191, 137},     {121, 190, 141},     {124, 188, 145},     {126, 187, 150},
    {129, 185, 154},     {131, 184, 158},     {133, 183, 162},     {136, 181, 166},
    {138, 180, 170},     {141, 178, 174},     {143, 177, 178},     {146, 176, 182},
    {148, 174, 187},     {151, 173, 191},     {153, 172, 195},     {156, 170, 199},
    { 84, 210,  68},     { 87, 209,  72},     { 89, 208,  76},     { 92, 206,  80},
    { 94, 205,  84},     { 96, 204,  89},     { 99, 202,  93},     {101, 201,  97},
    {104, 199, 101},     {106, 198, 105},     {109, 197, 109},     {111, 195, 113},
    {114, 194, 117},     {116, 192, 121},     {119, 191, 126},     {121, 190, 130},
    {124, 188, 134},     {126, 187, 138},     {128, 185, 142},     {131, 184, 146},
    {133, 183, 150},     {136, 181, 154},     {138, 180, 158},     {141, 179, 163},
    {143, 177, 167},     {146, 176, 171},     {148, 174, 175},     {151, 173, 179},
    {153, 172, 183},     {156, 170, 187},     {158, 169, 191},     {160, 167, 195},
    { 89, 208,  65},     { 91, 206,  69},     { 94, 205,  73},     { 96, 204,  77},
    { 99, 202,  81},     {101, 201,  85},     {104, 199,  89},     {106, 198,  93},
    {109, 197,  97},     {111, 195, 102},     {114, 194, 106},     {116, 192, 110},
    {119, 191, 114},     {121, 190, 118},     {123, 188, 122},     {126, 187, 126},
    {128, 186, 130},     {131, 184, 134},     {133, 183, 139},     {136, 181, 143},
    {138, 180, 147},     {141, 179, 151},     {143, 177, 155},     {146, 176, 159},
    {148, 174, 163},     {151, 173, 167},     {153, 172, 171},     {155, 170, 176},
    {158, 169, 180},     {160, 167, 184},     {163, 166, 188},     {165, 165, 192},
    { 94, 205,  61},     { 96, 204,  65},     { 99, 202,  69},     {101, 201,  73},
    {104, 199,  78},     {106, 198,  82},     {109, 197,  86},     {111, 195,  90},
    {114, 194,  94},     {116, 193,  98},     {118, 191, 102},     {121, 190, 106},
    {123, 188, 110},     {126, 187, 115},     {128, 186, 119},     {131, 184, 123},
    {133, 183, 127},     {136, 181, 131},     {138, 180, 135},     {141, 179, 139},
    {143, 177, 143},     {146, 176, 147},     {148, 174, 152},     {150, 173, 156},
    {153, 172, 160},     {155, 170, 164},     {158, 169, 168},     {160, 168, 172},
    {163, 166, 176},     {165, 165, 180},     {168, 163, 184},     {170, 162, 189},
    { 99, 202,  58},     {101, 201,  62},     {104, 200,  66},     {106, 198,  70},
    {109, 197,  74},     {111, 195,  78},     {113, 194,  82},     {116, 193,  86},
    {118, 191,  91},     {121, 190,  95},     {123, 188,  99},     {126, 187, 103},
    {128, 186, 107},     {131, 184, 111},     {133, 183, 115},     {136, 181, 119},
    {138, 180, 123},     {140, 179, 128},     {143, 177, 132},     {145, 176, 136},
    {148, 175, 140},     {150, 173, 144},     {153, 172, 148},     {155, 170, 152},
    {158, 169, 156},     {160, 168, 160},     {163, 166, 165},     {165, 165, 169},
    {168, 163, 173},     {170, 162, 177},     {172, 161, 181},     {175, 159, 185},
    {104, 200,  54},     {106, 198,  58},     {108, 197,  62},     {111, 195,  67},
    {113, 194,  71},     {116, 193,  75},     {118, 191,  79},     {121, 190,  83},
    {123, 188,  87},     {126, 187,  91},     {128, 186,  95},     {131, 184,  99},
    {133, 183, 104},     {135, 182, 108},     {138, 180, 112},     {140, 179, 116},
    {143, 177, 120},     {145, 176, 124},     {148, 175, 128},     {150, 173, 132},
    {153, 172, 136},     {155, 170, 141},     {158, 169, 145},     {160, 168, 149},
    {163, 166, 153},     {165, 165, 157},     {167, 163, 161},     {170, 162, 165},
    {172, 161, 169},     {175, 159, 173},     {177, 158, 178},     {180, 157, 182},
    {108, 197,  51},     {111, 195,  55},     {113, 194,  59},     {116, 193,  63},
    {118, 191,  67},     {121, 190,  71},     {123, 189,  75},     {126, 187,  80},
    {128, 186,  84},     {130, 184,  88},     {133, 183,  92},     {135, 182,  96},
    {138, 180, 100},     {140, 179, 104},     {143, 177, 108},     {145, 176, 112},
    {148, 175, 117},     {150, 173, 121},     {153, 172, 125},     {155, 170, 129},
    {158, 169, 133},     {160, 168, 137},     {162, 166, 141},     {165, 165, 145},
    {167, 164, 149},     {170, 162, 154},     {172, 161, 158},     {175, 159, 162},
    {177, 158, 166},     {180, 157, 170},     {182, 155, 174},     {185, 154, 178},
    {113, 194,  47},     {116, 193,  51},     {118, 191,  56},     {121, 190,  60},
    {123, 189,  64},     {125, 187,  68},     {128, 186,  72},     {130, 184,  76},
    {133, 183,  80},     {135, 182,  84},     {138, 180,  88},     {140, 179,  93},
    {143, 177,  97},     {145, 176, 101},     {148, 175, 105},     {150, 173, 109},
    {153, 172, 113},     {155, 171, 117},     {157, 169, 121},     {160, 168, 125},
    {162, 166, 130},     {165, 165, 134},     {167, 164, 138},     {170, 162, 142},
    {172, 161, 146},     {175, 159, 150},     {177, 158, 154},     {180, 157, 158},
    {182, 155, 162},     {184, 154, 167},     {187, 152, 171},     {189, 151, 175},
    {118, 191,  44},     {120, 190,  48},     {123, 189,  52},     {125, 187,  56},
    {128, 186,  60},     {130, 184,  64},     {133, 183,  69},     {135, 182,  73},
    {138, 180,  77},     {140, 179,  81},     {143, 178,  85},     {145, 176,  89},
    {148, 175,  93},     {150, 173,  97},     {152, 172, 101},     {155, 171, 106},
    {157, 169, 110},     {160, 168, 114},     {162, 166, 118},     {165, 165, 122},
    {167, 164, 126},     {170, 162, 130},     {172, 161, 134},     {175, 159, 138},
    {177, 158, 143},     {179, 157, 147},     {182, 155, 151},     {184, 154, 155},
    {187, 153, 159},     {189, 151, 163},     {192, 150, 167},     {194, 148, 171},
    {123, 189,  40},     {125, 187,  45},     {128, 186,  49},     {130, 185,  53},
    {133, 183,  57},     {135, 182,  61},     {138, 180,  65},     {140, 179,  69},
    {143, 178,  73},     {145, 176,  77},     {147, 175,  82},     {150, 173,  86},
    {152, 172,  90},     {155, 171,  94},     {157, 169,  98},     {160, 168, 102},
    {162, 166, 106},     {165, 165, 110},     {167, 164, 114},     {170, 162, 119},
    {172, 161, 123},     {174, 160, 127},     {177, 158, 131},     {179, 157, 135},
    {182, 155, 139},     {184, 154, 143},     {187, 153, 147},     {189, 151, 151},
    {192, 150, 156},     {194, 148, 160},     {197, 147, 164},     {199, 146, 168},
    {128, 186,  37},     {130, 185,  41},     {133, 183,  45},     {135, 182,  49},
    {137, 180,  53},     {140, 179,  58},     {142, 178,  62},     {145, 176,  66},
    {147, 175,  70},     {150, 173,  74},     {152, 172,  78},     {155, 171,  82},
    {157, 169,  86},     {160, 168,  90},     {162, 167,  95},     {165, 165,  99},
    {167, 164, 103},     {169, 162, 107},     {172, 161, 111},     {174, 160, 115},
    {177, 158, 119},     {179, 157, 123},     {182, 155, 127},     {184, 154, 132},
    {187, 153, 136},     {189, 151, 140},     {192, 150, 144},     {194, 148, 148},
    {197, 147, 152},     {199, 146, 156},     {201, 144, 160},     {204, 143, 164},
    {132, 183,  34},     {135, 182,  38},     {137, 180,  42},     {140, 179,  46},
    {142, 178,  50},     {145, 176,  54},     {147, 175,  58},     {150, 174,  62},
    {152, 172,  66},     {155, 171,  71},     {157, 169,  75},     {160, 168,  79},
    {162, 167,  83},     {164, 165,  87},     {167, 164,  91},     {169, 162,  95},
    {172, 161,  99},     {174, 160, 103},     {177, 158, 108},     {179, 157, 112},
    {182, 155, 116},     {184, 154, 120},     {187, 153, 124},     {189, 151, 128},
    {192, 150, 132},     {194, 149, 136},     {196, 147, 140},     {199, 146, 145},
    {201, 144, 149},     {204, 143, 153},     {206, 142, 157},     {209, 140, 161},
    {137, 181,  30},     {140, 179,  34},     {142, 178,  38},     {145, 176,  42},
    {147, 175,  47},     {150, 174,  51},     {152, 172,  55},     {155, 171,  59},
    {157, 169,  63},     {159, 168,  67},     {162, 167,  71},     {164, 165,  75},
    {167, 164,  79},     {169, 162,  84},     {172, 161,  88},     {174, 160,  92},
    {177, 158,  96},     {179, 157, 100},     {182, 156, 104},     {184, 154, 108},
    {187, 153, 112},     {189, 151, 116},     {191, 150, 121},     {194, 149, 125},
    {196, 147, 129},     {199, 146, 133},     {201, 144, 137},     {204, 143, 141},
    {206, 142, 145},     {209, 140, 149},     {211, 139, 153},     {214, 137, 158},
    {142, 178,  27},     {145, 176,  31},     {147, 175,  35},     {150, 174,  39},
    {152, 172,  43},     {154, 171,  47},     {157, 169,  51},     {159, 168,  55},
    {162, 167,  60},     {164, 165,  64},     {167, 164,  68},     {169, 163,  72},
    {172, 161,  76},     {174, 160,  80},     {177, 158,  84},     {179, 157,  88},
    {181, 156,  92},     {184, 154,  97},     {186, 153, 101},     {189, 151, 105},
    {191, 150, 109},     {194, 149, 113},     {196, 147, 117},     {199, 146, 121},
    {201, 144, 125},     {204, 143, 129},     {206, 142, 134},     {209, 140, 138},
    {211, 139, 142},     {213, 138, 146},     {216, 136, 150},     {218, 135, 154},
    {147, 175,  23},     {149, 174,  27},     {152, 172,  31},     {154, 171,  36},
    {157, 170,  40},     {159, 168,  44},     {162, 167,  48},     {164, 165,  52},
    {167, 164,  56},     {169, 163,  60},     {172, 161,  64},     {174, 160,  68},
    {176, 158,  73},     {179, 157,  77},     {181, 156,  81},     {184, 154,  85},
    {186, 153,  89},     {189, 151,  93},     {191, 150,  97},     {194, 149, 101},
    {196, 147, 105},     {199, 146, 110},     {201, 145, 114},     {204, 143, 118},
    {206, 142, 122},     {208, 140, 126},     {211, 139, 130},     {213, 138, 134},
    {216, 136, 138},     {218, 135, 142},     {221, 133, 147},     {223, 132, 151},
    {152, 172,  20},     {154, 171,  24},     {157, 170,  28},     {159, 168,  32},
    {162, 167,  36},     {164, 165,  40},     {167, 164,  44},     {169, 163,  49},
    {171, 161,  53},     {174, 160,  57},     {176, 158,  61},     {179, 157,  65},
    {181, 156,  69},     {184, 154,  73},     {186, 153,  77},     {189, 152,  81},
    {191, 150,  86},     {194, 149,  90},     {196, 147,  94},     {199, 146,  98},
    {201, 145, 102},     {203, 143, 106},     {206, 142, 110},     {208, 140, 114},
    {211, 139, 118},     {213, 138, 123},     {216, 136, 127},     {218, 135, 131},
    {221, 133, 135},     {223, 132, 139},     {226, 131, 143},     {228, 129, 147},
    {157, 170,  16},     {159, 168,  20},     {162, 167,  25},     {164, 165,  29},
    {166, 164,  33},     {169, 163,  37},     {171, 161,  41},     {174, 160,  45},
    {176, 159,  49},     {179, 157,  53},     {181, 156,  57},     {184, 154,  62},
    {186, 153,  66},     {189, 152,  70},     {191, 150,  74},     {194, 149,  78},
    {196, 147,  82},     {198, 146,  86},     {201, 145,  90},     {203, 143,  94},
    {206, 142,  99},     {208, 140, 103},     {211, 139, 107},     {213, 138, 111},
    {216, 136, 115},     {218, 135, 119},     {221, 134, 123},     {223, 132, 127},
    {225, 131, 131},     {228, 129, 136},     {230, 128, 140},     {233, 127, 144},
    {161, 167,  13},     {164, 166,  17},     {166, 164,  21},     {169, 163,  25},
    {171, 161,  29},     {174, 160,  33},     {176, 159,  38},     {179, 157,  42},
    {181, 156,  46},     {184, 154,  50},     {186, 153,  54},     {189, 152,  58},
    {191, 150,  62},     {193, 149,  66},     {196, 147,  70},     {198, 146,  75},
    {201, 145,  79},     {203, 143,  83},     {206, 142,  87},     {208, 141,  91},
    {211, 139,  95},     {213, 138,  99},     {216, 136, 103},     {218, 135, 107},
    {220, 134, 112},     {223, 132, 116},     {225, 131, 120},     {228, 129, 124},
    {230, 128, 128},     {233, 127, 132},     {235, 125, 136},     {238, 124, 140},
    {166, 164,   9},     {169, 163,  14},     {171, 161,  18},     {174, 160,  22},
    {176, 159,  26},     {179, 157,  30},     {181, 156,  34},     {184, 154,  38},
    {186, 153,  42},     {188, 152,  46},     {191, 150,  51},     {193, 149,  55},
    {196, 148,  59},     {198, 146,  63},     {201, 145,  67},     {203, 143,  71},
    {206, 142,  75},     {208, 141,  79},     {211, 139,  83},     {213, 138,  88},
    {215, 136,  92},     {218, 135,  96},     {220, 134, 100},     {223, 132, 104},
    {225, 131, 108},     {228, 129, 112},     {230, 128, 116},     {233, 127, 120},
    {235, 125, 125},     {238, 124, 129},     {240, 122, 133},     {243, 121, 137},
    {171, 161,   6},     {174, 160,  10},     {176, 159,  14},     {178, 157,  18},
    {181, 156,  22},     {183, 155,  27},     {186, 153,  31},     {188, 152,  35},
    {191, 150,  39},     {193, 149,  43},     {196, 148,  47},     {198, 146,  51},
    {201, 145,  55},     {203, 143,  59},     {206, 142,  64},     {208, 141,  68},
    {210, 139,  72},     {213, 138,  76},     {215, 136,  80},     {218, 135,  84},
    {220, 134,  88},     {223, 132,  92},     {225, 131,  96},     {228, 130, 101},
    {230, 128, 105},     {233, 127, 109},     {235, 125, 113},     {238, 124, 117},
    {240, 123, 121},     {242, 121, 125},     {245, 120, 129},     {247, 118, 133},
    {176, 159,   2},     {178, 157,   7},     {181, 156,  11},     {183, 155,  15},
    {186, 153,  19},     {188, 152,  23},     {191, 150,  27},     {193, 149,  31},
    {196, 148,  35},     {198, 146,  40},     {201, 145,  44},     {203, 143,  48},
    {205, 142,  52},     {208, 141,  56},     {210, 139,  60},     {213, 138,  64},
    {215, 137,  68},     {218, 135,  72},     {220, 134,  77},     {223, 132,  81},
    {225, 131,  85},     {228, 130,  89},     {230, 128,  93},     {233, 127,  97},
    {235, 125, 101},     {237, 124, 105},     {240, 123, 109},     {242, 121, 114},
    {245, 120, 118},     {247, 118, 122},     {250, 117, 126},     {252, 116, 130},
    { 27, 247, 109},     { 30, 246, 113},     { 32, 244, 117},     { 35, 243, 121},
    { 37, 242, 125},     { 39, 240, 129},     { 42, 239, 133},     { 44, 238, 137},
    { 47, 236, 142},     { 49, 235, 146},     { 52, 233, 150},     { 54, 232, 154},
    { 57, 231, 158},     { 59, 229, 162},     { 62, 228, 166},     { 64, 226, 170},
    { 67, 225, 174},     { 69, 224, 179},     { 71, 222, 183},     { 74, 221, 187},
    { 76, 219, 191},     { 79, 218, 195},     { 81, 217, 199},     { 84, 215, 203},
    { 86, 214, 207},     { 89, 213, 212},     { 91, 211, 216},     { 94, 210, 220},
    { 96, 208, 224},     { 99, 207, 228},     {101, 206, 232},     {103, 204, 236},
    { 32, 245, 105},     { 34, 243, 109},     { 37, 242, 113},     { 39, 240, 118},
    { 42, 239, 122},     { 44, 238, 126},     { 47, 236, 130},     { 49, 235, 134},
    { 52, 233, 138},     { 54, 232, 142},     { 57, 231, 146},     { 59, 229, 150},
    { 62, 228, 155},     { 64, 226, 159},     { 66, 225, 163},     { 69, 224, 167},
    { 71, 222, 171},     { 74, 221, 175},     { 76, 220, 179},     { 79, 218, 183},
    { 81, 217, 187},     { 84, 215, 192},     { 86, 214, 196},     { 89, 213, 200},
    { 91, 211, 204},     { 94, 210, 208},     { 96, 208, 212},     { 98, 207, 216},
    {101, 206, 220},     {103, 204, 225},     {106, 203, 229},     {108, 201, 233},
    { 37, 242, 102},     { 39, 240, 106},     { 42, 239, 110},     { 44, 238, 114},
    { 47, 236, 118},     { 49, 235, 122},     { 52, 233, 126},     { 54, 232, 131},
    { 57, 231, 135},     { 59, 229, 139},     { 61, 228, 143},     { 64, 227, 147},
    { 66, 225, 151},     { 69, 224, 155},     { 71, 222, 159},     { 74, 221, 163},
    { 76, 220, 168},     { 79, 218, 172},     { 81, 217, 176},     { 84, 215, 180},
    { 86, 214, 184},     { 89, 213, 188},     { 91, 211, 192},     { 93, 210, 196},
    { 96, 208, 200},     { 98, 207, 205},     {101, 206, 209},     {103, 204, 213},
    {106, 203, 217},     {108, 202, 221},     {111, 200, 225},     {113, 199, 229},
    { 42, 239,  98},     { 44, 238, 102},     { 47, 236, 107},     { 49, 235, 111},
    { 52, 234, 115},     { 54, 232, 119},     { 56, 231, 123},     { 59, 229, 127},
    { 61, 228, 131},     { 64, 227, 135},     { 66, 225, 139},     { 69, 224, 144},
    { 71, 222, 148},     { 74, 221, 152},     { 76, 220, 156},     { 79, 218, 160},
    { 81, 217, 164},     { 83, 215, 168},     { 86, 214, 172},     { 88, 213, 176},
    { 91, 211, 181},     { 93, 210, 185},     { 96, 209, 189},     { 98, 207, 193},
    {101, 206, 197},     {103, 204, 201},     {106, 203, 205},     {108, 202, 209},
    {111, 200, 213},     {113, 199, 218},     {115, 197, 222},     {118, 196, 226},
    { 47, 236,  95},     { 49, 235,  99},     { 51, 234, 103},     { 54, 232, 107},
    { 56, 231, 111},     { 59, 229, 115},     { 61, 228, 120},     { 64, 227, 124},
    { 66, 225, 128},     { 69, 224, 132},     { 71, 222, 136},     { 74, 221, 140},
    { 76, 220, 144},     { 78, 218, 148},     { 81, 217, 152},     { 83, 216, 157},
    { 86, 214, 161},     { 88, 213, 165},     { 91, 211, 169},     { 93, 210, 173},
    { 96, 209, 177},     { 98, 207, 181},     {101, 206, 185},     {103, 204, 189},
    {106, 203, 194},     {108, 202, 198},     {110, 200, 202},     {113, 199, 206},
    {115, 197, 210},     {118, 196, 214},     {120, 195, 218},     {123, 193, 222},
    { 51, 234,  91},     { 54, 232,  96},     { 56, 231, 100},     { 59, 229, 104},
    { 61, 228, 108},     { 64, 227, 112},     { 66, 225, 116},     { 69, 224, 120},
    { 71, 223, 124},     { 73, 221, 128},     { 76, 220, 133},     { 78, 218, 137},
    { 81, 217, 141},     { 83, 216, 145},     { 86, 214, 149},     { 88, 213, 153},
    { 91, 211, 157},     { 93, 210, 161},     { 96, 209, 165},     { 98, 207, 170},
    {101, 206, 174},     {103, 204, 178},     {105, 203, 182},     {108, 202, 186},
    {110, 200, 190},     {113, 199, 194},     {115, 198, 198},     {118, 196, 202},
    {120, 195, 207},     {123, 193, 211},     {125, 192, 215},     {128, 191, 219},
    { 56, 231,  88},     { 59, 230,  92},     { 61, 228,  96},     { 64, 227, 100},
    { 66, 225, 104},     { 68, 224, 109},     { 71, 223, 113},     { 73, 221, 117},
    { 76, 220, 121},     { 78, 218, 125},     { 81, 217, 129},     { 83, 216, 133},
    { 86, 214, 137},     { 88, 213, 141},     { 91, 211, 146},     { 93, 210, 150},
    { 96, 209, 154},     { 98, 207, 158},     {100, 206, 162},     {103, 205, 166},
    {105, 203, 170},     {108, 202, 174},     {110, 200, 178},     {113, 199, 183},
    {115, 198, 187},     {118, 196, 191},     {120, 195, 195},     {123, 193, 199},
    {125, 192, 203},     {127, 191, 207},     {130, 189, 211},     {132, 188, 215},
    { 61, 228,  85},     { 63, 227,  89},     { 66, 225,  93},     { 68, 224,  97},
    { 71, 223, 101},     { 73, 221, 105},     { 76, 220, 109},     { 78, 218, 113},
    { 81, 217, 117},     { 83, 216, 122},     { 86, 214, 126},     { 88, 213, 130},
    { 91, 212, 134},     { 93, 210, 138},     { 95, 209, 142},     { 98, 207, 146},
    {100, 206, 150},     {103, 205, 154},     {105, 203, 159},     {108, 202, 163},
    {110, 200, 167},     {113, 199, 171},     {115, 198, 175},     {118, 196, 179},
    {120, 195, 183},     {122, 193, 187},     {125, 192, 191},     {127, 191, 196},
    {130, 189, 200},     {132, 188, 204},     {135, 187, 208},     {137, 185, 212},
    { 66, 225,  81},     { 68, 224,  85},     { 71, 223,  89},     { 73, 221,  93},
    { 76, 220,  98},     { 78, 219, 102},     { 81, 217, 106},     { 83, 216, 110},
    { 85, 214, 114},     { 88, 213, 118},     { 90, 212, 122},     { 93, 210, 126},
    { 95, 209, 130},     { 98, 207, 135},     {100, 206, 139},     {103, 205, 143},
    {105, 203, 147},     {108, 202, 151},     {110, 200, 155},     {113, 199, 159},
    {115, 198, 163},     {117, 196, 167},     {120, 195, 172},     {122, 194, 176},
    {125, 192, 180},     {127, 191, 184},     {130, 189, 188},     {132, 188, 192},
    {135, 187, 196},     {137, 185, 200},     {140, 184, 204},     {142, 182, 209},
    { 71, 223,  78},     { 73, 221,  82},     { 76, 220,  86},     { 78, 219,  90},
    { 80, 217,  94},     { 83, 216,  98},     { 85, 214, 102},     { 88, 213, 106},
    { 90, 212, 111},     { 93, 210, 115},     { 95, 209, 119},     { 98, 207, 123},
    {100, 206, 127},     {103, 205, 131},     {105, 203, 135},     {108, 202, 139},
    {110, 201, 143},     {112, 199, 148},     {115, 198, 152},     {117, 196, 156},
    {120, 195, 160},     {122, 194, 164},     {125, 192, 168},     {127, 191, 172},
    {130, 189, 176},     {132, 188, 180},     {135, 187, 185},     {137, 185, 189},
    {140, 184, 193},     {142, 182, 197},     {144, 181, 201},     {147, 180, 205},
    { 75, 220,  74},     { 78, 219,  78},     { 80, 217,  82},     { 83, 216,  87},
    { 85, 214,  91},     { 88, 213,  95},     { 90, 212,  99},     { 93, 210, 103},
    { 95, 209, 107},     { 98, 208, 111},     {100, 206, 115},     {103, 205, 119},
    {105, 203, 124},     {107, 202, 128},     {110, 201, 132},     {112, 199, 136},
    {115, 198, 140},     {117, 196, 144},     {120, 195, 148},     {122, 194, 152},
    {125, 192, 156},     {127, 191, 161},     {130, 189, 165},     {132, 188, 169},
    {135, 187, 173},     {137, 185, 177},     {139, 184, 181},     {142, 183, 185},
    {144, 181, 189},     {147, 180, 193},     {149, 178, 198},     {152, 177, 202},
    { 80, 217,  71},     { 83, 216,  75},     { 85, 215,  79},     { 88, 213,  83},
    { 90, 212,  87},     { 93, 210,  91},     { 95, 209,  95},     { 98, 208, 100},
    {100, 206, 104},     {102, 205, 108},     {105, 203, 112},     {107, 202, 116},
    {110, 201, 120},     {112, 199, 124},     {115, 198, 128},     {117, 196, 132},
    {120, 195, 137},     {122, 194, 141},     {125, 192, 145},     {127, 191, 149},
    {129, 190, 153},     {132, 188, 157},     {134, 187, 161},     {137, 185, 165},
    {139, 184, 169},     {142, 183, 174},     {144, 181, 178},     {147, 180, 182},
    {149, 178, 186},     {152, 177, 190},     {154, 176, 194},     {157, 174, 198},
    { 85, 215,  67},     { 88, 213,  71},     { 90, 212,  76},     { 93, 210,  80},
    { 95, 209,  84},     { 97, 208,  88},     {100, 206,  92},     {102, 205,  96},
    {105, 203, 100},     {107, 202, 104},     {110, 201, 108},     {112, 199, 113},
    {115, 198, 117},     {117, 197, 121},     {120, 195, 125},     {122, 194, 129},
    {124, 192, 133},     {127, 191, 137},     {129, 190, 141},     {132, 188, 145},
    {134, 187, 150},     {137, 185, 154},     {139, 184, 158},     {142, 183, 162},
    {144, 181, 166},     {147, 180, 170},     {149, 178, 174},     {152, 177, 178},
    {154, 176, 182},     {156, 174, 187},     {159, 173, 191},     {161, 172, 195},
    { 90, 212,  64},     { 92, 210,  68},     { 95, 209,  72},     { 97, 208,  76},
    {100, 206,  80},     {102, 205,  84},     {105, 204,  89},     {107, 202,  93},
    {110, 201,  97},     {112, 199, 101},     {115, 198, 105},     {117, 197, 109},
    {119, 195, 113},     {122, 194, 117},     {124, 192, 121},     {127, 191, 126},
    {129, 190, 130},     {132, 188, 134},     {134, 187, 138},     {137, 185, 142},
    {139, 184, 146},     {142, 183, 150},     {144, 181, 154},     {147, 180, 158},
    {149, 179, 163},     {151, 177, 167},     {154, 176, 171},     {156, 174, 175},
    {159, 173, 179},     {161, 172, 183},     {164, 170, 187},     {166, 169, 191},
    { 95, 209,  60},     { 97, 208,  65},     {100, 206,  69},     {102, 205,  73},
    {105, 204,  77},     {107, 202,  81},     {110, 201,  85},     {112, 199,  89},
    {114, 198,  93},     {117, 197,  97},     {119, 195, 102},     {122, 194, 106},
    {124, 192, 110},     {127, 191, 114},     {129, 190, 118},     {132, 188, 122},
    {134, 187, 126},     {137, 186, 130},     {139, 184, 134},     {142, 183, 139},
    {144, 181, 143},     {146, 180, 147},     {149, 179, 151},     {151, 177, 155},
    {154, 176, 159},     {156, 174, 163},     {159, 173, 167},     {161, 172, 171},
    {164, 170, 176},     {166, 169, 180},     {169, 167, 184},     {171, 166, 188},
    {100, 206,  57},     {102, 205,  61},     {105, 204,  65},     {107, 202,  69},
    {109, 201,  73},     {112, 199,  78},     {114, 198,  82},     {117, 197,  86},
    {119, 195,  90},     {122, 194,  94},     {124, 193,  98},     {127, 191, 102},
    {129, 190, 106},     {132, 188, 110},     {134, 187, 115},     {137, 186, 119},
    {139, 184, 123},     {141, 183, 127},     {144, 181, 131},     {146, 180, 135},
    {149, 179, 139},     {151, 177, 143},     {154, 176, 147},     {156, 174, 152},
    {159, 173, 156},     {161, 172, 160},     {164, 170, 164},     {166, 169, 168},
    {168, 168, 172},     {171, 166, 176},     {173, 165, 180},     {176, 163, 184},
    {104, 204,  54},     {107, 202,  58},     {109, 201,  62},     {112, 200,  66},
    {114, 198,  70},     {117, 197,  74},     {119, 195,  78},     {122, 194,  82},
    {124, 193,  86},     {127, 191,  91},     {129, 190,  95},     {132, 188,  99},
    {134, 187, 103},     {136, 186, 107},     {139, 184, 111},     {141, 183, 115},
    {144, 181, 119},     {146, 180, 123},     {149, 179, 128},     {151, 177, 132},
    {154, 176, 136},     {156, 175, 140},     {159, 173, 144},     {161, 172, 148},
    {163, 170, 152},     {166, 169, 156},     {168, 168, 160},     {171, 166, 165},
    {173, 165, 169},     {176, 163, 173},     {178, 162, 177},     {181, 161, 181},
    {109, 201,  50},     {112, 200,  54},     {114, 198,  58},     {117, 197,  62},
    {119, 195,  67},     {122, 194,  71},     {124, 193,  75},     {126, 191,  79},
    {129, 190,  83},     {131, 188,  87},     {134, 187,  91},     {136, 186,  95},
    {139, 184,  99},     {141, 183, 104},     {144, 182, 108},     {146, 180, 112},
    {149, 179, 116},     {151, 177, 120},     {154, 176, 124},     {156, 175, 128},
    {158, 173, 132},     {161, 172, 136},     {163, 170, 141},     {166, 169, 145},
    {168, 168, 149},     {171, 166, 153},     {173, 165, 157},     {176, 163, 161},
    {178, 162, 165},     {181, 161, 169},     {183, 159, 173},     {186, 158, 178},
    {114, 198,  47},     {117, 197,  51},     {119, 195,  55},     {121, 194,  59},
    {124, 193,  63},     {126, 191,  67},     {129, 190,  71},     {131, 189,  75},
    {134, 187,  80},     {136, 186,  84},     {139, 184,  88},     {141, 183,  92},
    {144, 182,  96},     {146, 180, 100},     {149, 179, 104},     {151, 177, 108},
    {153, 176, 112},     {156, 175, 117},     {158, 173, 121},     {161, 172, 125},
    {163, 170, 129},     {166, 169, 133},     {168, 168, 137},     {171, 166, 141},
    {173, 165, 145},     {176, 164, 149},     {178, 162, 154},     {181, 161, 158},
    {183, 159, 162},     {185, 158, 166},     {188, 157, 170},     {190, 155, 174},
    {119, 196,  43},     {121, 194,  47},     {124, 193,  51},     {126, 191,  56},
    {129, 190,  60},     {131, 189,  64},     {134, 187,  68},     {136, 186,  72},
    {139, 184,  76},     {141, 183,  80},     {144, 182,  84},     {146, 180,  88},
    {148, 179,  93},     {151, 177,  97},     {153, 176, 101},     {156, 175, 105},
    {158, 173, 109},     {161, 172, 113},     {163, 171, 117},     {166, 169, 121},
    {168, 168, 125},     {171, 166, 130},     {173, 165, 134},     {176, 164, 138},
    {178, 162, 142},     {180, 161, 146},     {183, 159, 150},     {185, 158, 154},
    {188, 157, 158},     {190, 155, 162},     {193, 154, 167},     {195, 152, 171},
    {124, 193,  40},     {126, 191,  44},     {129, 190,  48},     {131, 189,  52},
    {134, 187,  56},     {136, 186,  60},     {139, 184,  64},     {141, 183,  69},
    {143, 182,  73},     {146, 180,  77},     {148, 179,  81},     {151, 178,  85},
    {153, 176,  89},     {156, 175,  93},     {158, 173,  97},     {161, 172, 101},
    {163, 171, 106},     {166, 169, 110},     {168, 168, 114},     {170, 166, 118},
    {173, 165, 122},     {175, 164, 126},     {178, 162, 130},     {180, 161, 134},
    {183, 159, 138},     {185, 158, 143},     {188, 157, 147},     {190, 155, 151},
    {193, 154, 155},     {195, 153, 159},     {198, 151, 163},     {200, 150, 167},
    {129, 190,  36},     {131, 189,  40},     {134, 187,  45},     {136, 186,  49},
    {138, 185,  53},     {141, 183,  57},     {143, 182,  61},     {146, 180,  65},
    {148, 179,  69},     {151, 178,  73},     {153, 176,  77},     {156, 175,  82},
    {158, 173,  86},     {161, 172,  90},     {163, 171,  94},     {165, 169,  98},
    {168, 168, 102},     {170, 166, 106},     {173, 165, 110},     {175, 164, 114},
    {178, 162, 119},     {180, 161, 123},     {183, 160, 127},     {185, 158, 131},
    {188, 157, 135},     {190, 155, 139},     {193, 154, 143},     {195, 153, 147},
    {197, 151, 151},     {200, 150, 156},     {202, 148, 160},     {205, 147, 164},
    {133, 187,  33},     {136, 186,  37},     {138, 185,  41},     {141, 183,  45},
    {143, 182,  49},     {146, 180,  53},     {148, 179,  58},     {151, 178,  62},
    {153, 176,  66},     {156, 175,  70},     {158, 173,  74},     {160, 172,  78},
    {163, 171,  82},     {165, 169,  86},     {168, 168,  90},     {170, 167,  95},
    {173, 165,  99},     {175, 164, 103},     {178, 162, 107},     {180, 161, 111},
    {183, 160, 115},     {185, 158, 119},     {188, 157, 123},     {190, 155, 127},
    {192, 154, 132},     {195, 153, 136},     {197, 151, 140},     {200, 150, 144},
    {202, 148, 148},     {205, 147, 152},     {207, 146, 156},     {210, 144, 160},
    {138, 185,  29},     {141, 183,  34},     {143, 182,  38},     {146, 180,  42},
    {148, 179,  46},     {151, 178,  50},     {153, 176,  54},     {155, 175,  58},
    {158, 174,  62},     {160, 172,  66},     {163, 171,  71},     {165, 169,  75},
    {168, 168,  79},     {170, 167,  83},     {173, 165,  87},     {175, 164,  91},
    {178, 162,  95},     {180, 161,  99},     {183, 160, 103},     {185, 158, 108},
    {187, 157, 112},     {190, 155, 116},     {192, 154, 120},     {195, 153, 124},
    {197, 151, 128},     {200, 150, 132},     {202, 149, 136},     {205, 147, 140},
    {207, 146, 145},     {210, 144, 149},     {212, 143, 153},     {214, 142, 157},
    {143, 182,  26},     {146, 181,  30},     {148, 179,  34},     {150, 178,  38},
    {153, 176,  42},     {155, 175,  47},     {158, 174,  51},     {160, 172,  55},
    {163, 171,  59},     {165, 169,  63},     {168, 168,  67},     {170, 167,  71},
    {173, 165,  75},     {175, 164,  79},     {178, 162,  84},     {180, 161,  88},
    {182, 160,  92},     {185, 158,  96},     {187, 157, 100},     {190, 156, 104},
    {192, 154, 108},     {195, 153, 112},     {197, 151, 116},     {200, 150, 121},
    {202, 149, 125},     {205, 147, 129},     {207, 146, 133},     {209, 144, 137},
    {212, 143, 141},     {214, 142, 145},     {217, 140, 149},     {219, 139, 153},
    {148, 179,  23},     {150, 178,  27},     {153, 176,  31},     {155, 175,  35},
    {158, 174,  39},     {160, 172,  43},     {163, 171,  47},     {165, 169,  51},
    {168, 168,  55},     {170, 167,  60},     {173, 165,  64},     {175, 164,  68},
    {177, 163,  72},     {180, 161,  76},     {182, 160,  80},     {185, 158,  84},
    {187, 157,  88},     {190, 156,  92},     {192, 154,  97},     {195, 153, 101},
    {197, 151, 105},     {200, 150, 109},     {202, 149, 113},     {204, 147, 117},
    {207, 146, 121},     {209, 144, 125},     {212, 143, 129},     {214, 142, 134},
    {217, 140, 138},     {219, 139, 142},     {222, 138, 146},     {224, 136, 150},
    {153, 176,  19},     {155, 175,  23},     {158, 174,  27},     {160, 172,  31},
    {163, 171,  36},     {165, 170,  40},     {167, 168,  44},     {170, 167,  48},
    {172, 165,  52},     {175, 164,  56},     {177, 163,  60},     {180, 161,  64},
    {182, 160,  68},     {185, 158,  73},     {187, 157,  77},     {190, 156,  81},
    {192, 154,  85},     {195, 153,  89},     {197, 151,  93},     {199, 150,  97},
    {202, 149, 101},     {204, 147, 105},     {207, 146, 110},     {209, 145, 114},
    {212, 143, 118},     {214, 142, 122},     {217, 140, 126},     {219, 139, 130},
    {222, 138, 134},     {224, 136, 138},     {227, 135, 142},     {229, 133, 147},
    {158, 174,  16},     {160, 172,  20},     {162, 171,  24},     {165, 170,  28},
    {167, 168,  32},     {170, 167,  36},     {172, 165,  40},     {175, 164,  44},
    {177, 163,  49},     {180, 161,  53},     {182, 160,  57},     {185, 158,  61},
    {187, 157,  65},     {190, 156,  69},     {192, 154,  73},     {194, 153,  77},
    {197, 152,  81},     {199, 150,  86},     {202, 149,  90},     {204, 147,  94},
    {207, 146,  98},     {209, 145, 102},     {212, 143, 106},     {214, 142, 110},
    {217, 140, 114},     {219, 139, 118},     {222, 138, 123},     {224, 136, 127},
    {226, 135, 131},     {229, 133, 135},     {231, 132, 139},     {234, 131, 143},
    {162, 171,  12},     {165, 170,  16},     {167, 168,  20},     {170, 167,  25},
    {172, 165,  29},     {175, 164,  33},     {177, 163,  37},     {180, 161,  41},
    {182, 160,  45},     {185, 159,  49},     {187, 157,  53},     {189, 156,  57},
    {192, 154,  62},     {194, 153,  66},     {197, 152,  70},     {199, 150,  74},
    {202, 149,  78},     {204, 147,  82},     {207, 146,  86},     {209, 145,  90},
    {212, 143,  94},     {214, 142,  99},     {217, 140, 103},     {219, 139, 107},
    {221, 138, 111},     {224, 136, 115},     {226, 135, 119},     {229, 134, 123},
    {231, 132, 127},     {234, 131, 131},     {236, 129, 136},     {239, 128, 140},
    {167, 168,   9},     {170, 167,  13},     {172, 166,  17},     {175, 164,  21},
    {177, 163,  25},     {180, 161,  29},     {182, 160,  33},     {184, 159,  38},
    {187, 157,  42},     {189, 156,  46},     {192, 154,  50},     {194, 153,  54},
    {197, 152,  58},     {199, 150,  62},     {202, 149,  66},     {204, 147,  70},
    {207, 146,  75},     {209, 145,  79},     {211, 143,  83},     {214, 142,  87},
    {216, 141,  91},     {219, 139,  95},     {221, 138,  99},     {224, 136, 103},
    {226, 135, 107},     {229, 134, 112},     {231, 132, 116},     {234, 131, 120},
    {236, 129, 124},     {239, 128, 128},     {241, 127, 132},     {243, 125, 136},
    {172, 166,   5},     {175, 164,   9},     {177, 163,  14},     {179, 161,  18},
    {182, 160,  22},     {184, 159,  26},     {187, 157,  30},     {189, 156,  34},
    {192, 154,  38},     {194, 153,  42},     {197, 152,  46},     {199, 150,  51},
    {202, 149,  55},     {204, 148,  59},     {206, 146,  63},     {209, 145,  67},
    {211, 143,  71},     {214, 142,  75},     {216, 141,  79},     {219, 139,  83},
    {221, 138,  88},     {224, 136,  92},     {226, 135,  96},     {229, 134, 100},
    {231, 132, 104},     {234, 131, 108},     {236, 129, 112},     {238, 128, 116},
    {241, 127, 120},     {243, 125, 125},     {246, 124, 129},     {248, 122, 133},
    {177, 163,   2},     {179, 161,   6},     {182, 160,  10},     {184, 159,  14},
    {187, 157,  18},     {189, 156,  22},     {192, 155,  27},     {194, 153,  31},
    {197, 152,  35},     {199, 150,  39},     {201, 149,  43},     {204, 148,  47},
    {206, 146,  51},     {209, 145,  55},     {211, 143,  59},     {214, 142,  64},
    {216, 141,  68},     {219, 139,  72},     {221, 138,  76},     {224, 136,  80},
    {226, 135,  84},     {229, 134,  88},     {231, 132,  92},     {233, 131,  96},
    {236, 130, 101},     {238, 128, 105},     {241, 127, 109},     {243, 125, 113},
    {246, 124, 117},     {248, 123, 121},     {251, 121, 125},     {253, 120, 129},
    { 28, 251, 108},     { 31, 250, 112},     { 33, 249, 116},     { 36, 247, 120},
    { 38, 246, 124},     { 40, 244, 129},     { 43, 243, 133},     { 45, 242, 137},
    { 48, 240, 141},     { 50, 239, 145},     { 53, 237, 149},     { 55, 236, 153},
    { 58, 235, 157},     { 60, 233, 161},     { 63, 232, 166},     { 65, 231, 170},
    { 67, 229, 174},     { 70, 228, 178},     { 72, 226, 182},     { 75, 225, 186},
    { 77, 224, 190},     { 80, 222, 194},     { 82, 221, 198},     { 85, 219, 203},
    { 87, 218, 207},     { 90, 217, 211},     { 92, 215, 215},     { 95, 214, 219},
    { 97, 212, 223},     { 99, 211, 227},     {102, 210, 231},     {104, 208, 236},
    { 33, 249, 105},     { 35, 247, 109},     { 38, 246, 113},     { 40, 244, 117},
    { 43, 243, 121},     { 45, 242, 125},     { 48, 240, 129},     { 50, 239, 133},
    { 53, 238, 137},     { 55, 236, 142},     { 58, 235, 146},     { 60, 233, 150},
    { 62, 232, 154},     { 65, 231, 158},     { 67, 229, 162},     { 70, 228, 166},
    { 72, 226, 170},     { 75, 225, 174},     { 77, 224, 179},     { 80, 222, 183},
    { 82, 221, 187},     { 85, 219, 191},     { 87, 218, 195},     { 90, 217, 199},
    { 92, 215, 203},     { 94, 214, 207},     { 97, 213, 212},     { 99, 211, 216},
    {102, 210, 220},     {104, 208, 224},     {107, 207, 228},     {109, 206, 232},
    { 38, 246, 101},     { 40, 245, 105},     { 43, 243, 109},     { 45, 242, 113},
    { 48, 240, 118},     { 50, 239, 122},     { 53, 238, 126},     { 55, 236, 130},
    { 57, 235, 134},     { 60, 233, 138},     { 62, 232, 142},     { 65, 231, 146},
    { 67, 229, 150},     { 70, 228, 155},     { 72, 226, 159},     { 75, 225, 163},
    { 77, 224, 167},     { 80, 222, 171},     { 82, 221, 175},     { 85, 220, 179},
    { 87, 218, 183},     { 89, 217, 187},     { 92, 215, 192},     { 94, 214, 196},
    { 97, 213, 200},     { 99, 211, 204},     {102, 210, 208},     {104, 208, 212},
    {107, 207, 216},     {109, 206, 220},     {112, 204, 225},     {114, 203, 229},
    { 43, 243,  98},     { 45, 242, 102},     { 48, 240, 106},     { 50, 239, 110},
    { 52, 238, 114},     { 55, 236, 118},     { 57, 235, 122},     { 60, 233, 126},
    { 62, 232, 131},     { 65, 231, 135},     { 67, 229, 139},     { 70, 228, 143},
    { 72, 227, 147},     { 75, 225, 151},     { 77, 224, 155},     { 80, 222, 159},
    { 82, 221, 163},     { 84, 220, 168},     { 87, 218, 172},     { 89, 217, 176},
    { 92, 215, 180},     { 94, 214, 184},     { 97, 213, 188},     { 99, 211, 192},
    {102, 210, 196},     {104, 208, 200},     {107, 207, 205},     {109, 206, 209},
    {111, 204, 213},     {114, 203, 217},     {116, 202, 221},     {119, 200, 225},
    { 47, 240,  94},     { 50, 239,  98},     { 52, 238, 102},     { 55, 236, 107},
    { 57, 235, 111},     { 60, 234, 115},     { 62, 232, 119},     { 65, 231, 123},
    { 67, 229, 127},     { 70, 228, 131},     { 72, 227, 135},     { 75, 225, 139},
    { 77, 224, 144},     { 79, 222, 148},     { 82, 221, 152},     { 84, 220, 156},
    { 87, 218, 160},     { 89, 217, 164},     { 92, 215, 168},     { 94, 214, 172},
    { 97, 213, 176},     { 99, 211, 181},     {102, 210, 185},     {104, 209, 189},
    {106, 207, 193},     {109, 206, 197},     {111, 204, 201},     {114, 203, 205},
    {116, 202, 209},     {119, 200, 213},     {121, 199, 218},     {124, 197, 222},
    { 52, 238,  91},     { 55, 236,  95},     { 57, 235,  99},     { 60, 234, 103},
    { 62, 232, 107},     { 65, 231, 111},     { 67, 229, 115},     { 69, 228, 120},
    { 72, 227, 124},     { 74, 225, 128},     { 77, 224, 132},     { 79, 222, 136},
    { 82, 221, 140},     { 84, 220, 144},     { 87, 218, 148},     { 89, 217, 152},
    { 92, 216, 157},     { 94, 214, 161},     { 97, 213, 165},     { 99, 211, 169},
    {101, 210, 173},     {104, 209, 177},     {106, 207, 181},     {109, 206, 185},
    {111, 204, 189},     {114, 203, 194},     {116, 202, 198},     {119, 200, 202},
    {121, 199, 206},     {124, 197, 210},     {126, 196, 214},     {129, 195, 218},
    { 57, 235,  87},     { 60, 234,  91},     { 62, 232,  96},     { 64, 231, 100},
    { 67, 229, 104},     { 69, 228, 108},     { 72, 227, 112},     { 74, 225, 116},
    { 77, 224, 120},     { 79, 223, 124},     { 82, 221, 128},     { 84, 220, 133},
    { 87, 218, 137},     { 89, 217, 141},     { 92, 216, 145},     { 94, 214, 149},
    { 96, 213, 153},     { 99, 211, 157},     {101, 210, 161},     {104, 209, 165},
    {106, 207, 170},     {109, 206, 174},     {111, 204, 178},     {114, 203, 182},
    {116, 202, 186},     {119, 200, 190},     {121, 199, 194},     {124, 198, 198},
    {126, 196, 202},     {128, 195, 207},     {131, 193, 211},     {133, 192, 215},
    { 62, 232,  84},     { 64, 231,  88},     { 67, 230,  92},     { 69, 228,  96},
    { 72, 227, 100},     { 74, 225, 104},     { 77, 224, 109},     { 79, 223, 113},
    { 82, 221, 117},     { 84, 220, 121},     { 87, 218, 125},     { 89, 217, 129},
    { 91, 216, 133},     { 94, 214, 137},     { 96, 213, 141},     { 99, 211, 146},
    {101, 210, 150},     {104, 209, 154},     {106, 207, 158},     {109, 206, 162},
    {111, 205, 166},     {114, 203, 170},     {116, 202, 174},     {119, 200, 178},
    {121, 199, 183},     {123, 198, 187},     {126, 196, 191},     {128, 195, 195},
    {131, 193, 199},     {133, 192, 203},     {136, 191, 207},     {138, 189, 211},
    { 67, 230,  80},     { 69, 228,  85},     { 72, 227,  89},     { 74, 225,  93},
    { 77, 224,  97},     { 79, 223, 101},     { 82, 221, 105},     { 84, 220, 109},
    { 86, 218, 113},     { 89, 217, 117},     { 91, 216, 122},     { 94, 214, 126},
    { 96, 213, 130},     { 99, 212, 134},     {101, 210, 138},     {104, 209, 142},
    {106, 207, 146},     {109, 206, 150},     {111, 205, 154},     {113, 203, 159},
    {116, 202, 163},     {118, 200, 167},     {121, 199, 171},     {123, 198, 175},
    {126, 196, 179},     {128, 195, 183},     {131, 193, 187},     {133, 192, 191},
    {136, 191, 196},     {138, 189, 200},     {141, 188, 204},     {143, 187, 208},
    { 72, 227,  77},     { 74, 225,  81},     { 77, 224,  85},     { 79, 223,  89},
    { 81, 221,  93},     { 84, 220,  98},     { 86, 219, 102},     { 89, 217, 106},
    { 91, 216, 110},     { 94, 214, 114},     { 96, 213, 118},     { 99, 212, 122},
    {101, 210, 126},     {104, 209, 130},     {106, 207, 135},     {108, 206, 139},
    {111, 205, 143},     {113, 203, 147},     {116, 202, 151},     {118, 200, 155},
    {121, 199, 159},     {123, 198, 163},     {126, 196, 167},     {128, 195, 172},
    {131, 194, 176},     {133, 192, 180},     {136, 191, 184},     {138, 189, 188},
    {140, 188, 192},     {143, 187, 196},     {145, 185, 200},     {148, 184, 204},
    { 76, 224,  74},     { 79, 223,  78},     { 81, 221,  82},     { 84, 220,  86},
    { 86, 219,  90},     { 89, 217,  94},     { 91, 216,  98},     { 94, 214, 102},
    { 96, 213, 106},     { 99, 212, 111},     {101, 210, 115},     {103, 209, 119},
    {106, 207, 123},     {108, 206, 127},     {111, 205, 131},     {113, 203, 135},
    {116, 202, 139},     {118, 201, 143},     {121, 199, 148},     {123, 198, 152},
    {126, 196, 156},     {128, 195, 160},     {131, 194, 164},     {133, 192, 168},
    {135, 191, 172},     {138, 189, 176},     {140, 188, 180},     {143, 187, 185},
    {145, 185, 189},     {148, 184, 193},     {150, 182, 197},     {153, 181, 201},
    { 81, 221,  70},     { 84, 220,  74},     { 86, 219,  78},     { 89, 217,  82},
    { 91, 216,  87},     { 94, 214,  91},     { 96, 213,  95},     { 98, 212,  99},
    {101, 210, 103},     {103, 209, 107},     {106, 208, 111},     {108, 206, 115},
    {111, 205, 119},     {113, 203, 124},     {116, 202, 128},     {118, 201, 132},
    {121, 199, 136},     {123, 198, 140},     {126, 196, 144},     {128, 195, 148},
    {130, 194, 152},     {133, 192, 156},     {135, 191, 161},     {138, 189, 165},
    {140, 188, 169},     {143, 187, 173},     {145, 185, 177},     {148, 184, 181},
    {150, 183, 185},     {153, 181, 189},     {155, 180, 193},     {157, 178, 198},
    { 86, 219,  67},     { 89, 217,  71},     { 91, 216,  75},     { 93, 215,  79},
    { 96, 213,  83},     { 98, 212,  87},     {101, 210,  91},     {103, 209,  95},
    {106, 208, 100},     {108, 206, 104},     {111, 205, 108},     {113, 203, 112},
    {116, 202, 116},     {118, 201, 120},     {121, 199, 124},     {123, 198, 128},
    {125, 196, 132},     {128, 195, 137},     {130, 194, 141},     {133, 192, 145},
    {135, 191, 149},     {138, 190, 153},     {140, 188, 157},     {143, 187, 161},
    {145, 185, 165},     {148, 184, 169},     {150, 183, 174},     {152, 181, 178},
    {155, 180, 182},     {157, 178, 186},     {160, 177, 190},     {162, 176, 194},
    { 91, 216,  63},     { 93, 215,  67},     { 96, 213,  71},     { 98, 212,  76},
    {101, 210,  80},     {103, 209,  84},     {106, 208,  88},     {108, 206,  92},
    {111, 205,  96},     {113, 203, 100},     {115, 202, 104},     {118, 201, 108},
    {120, 199, 113},     {123, 198, 117},     {125, 197, 121},     {128, 195, 125},
    {130, 194, 129},     {133, 192, 133},     {135, 191, 137},     {138, 190, 141},
    {140, 188, 145},     {143, 187, 150},     {145, 185, 154},     {147, 184, 158},
    {150, 183, 162},     {152, 181, 166},     {155, 180, 170},     {157, 178, 174},
    {160, 177, 178},     {162, 176, 182},     {165, 174, 187},     {167, 173, 191},
    { 96, 213,  60},     { 98, 212,  64},     {101, 210,  68},     {103, 209,  72},
    {106, 208,  76},     {108, 206,  80},     {110, 205,  84},     {113, 204,  89},
    {115, 202,  93},     {118, 201,  97},     {120, 199, 101},     {123, 198, 105},
    {125, 197, 109},     {128, 195, 113},     {130, 194, 117},     {133, 192, 121},
    {135, 191, 126},     {138, 190, 130},     {140, 188, 134},     {142, 187, 138},
    {145, 185, 142},     {147, 184, 146},     {150, 183, 150},     {152, 181, 154},
    {155, 180, 158},     {157, 179, 163},     {160, 177, 167},     {162, 176, 171},
    {165, 174, 175},     {167, 173, 179},     {170, 172, 183},     {172, 170, 187},
    {101, 211,  56},     {103, 209,  60},     {105, 208,  65},     {108, 206,  69},
    {110, 205,  73},     {113, 204,  77},     {115, 202,  81},     {118, 201,  85},
    {120, 199,  89},     {123, 198,  93},     {125, 197,  97},     {128, 195, 102},
    {130, 194, 106},     {133, 192, 110},     {135, 191, 114},     {137, 190, 118},
    {140, 188, 122},     {142, 187, 126},     {145, 186, 130},     {147, 184, 134},
    {150, 183, 139},     {152, 181, 143},     {155, 180, 147},     {157, 179, 151},
    {160, 177, 155},     {162, 176, 159},     {165, 174, 163},     {167, 173, 167},
    {169, 172, 171},     {172, 170, 176},     {174, 169, 180},     {177, 167, 184},
    {105, 208,  53},     {108, 206,  57},     {110, 205,  61},     {113, 204,  65},
    {115, 202,  69},     {118, 201,  73},     {120, 199,  78},     {123, 198,  82},
    {125, 197,  86},     {128, 195,  90},     {130, 194,  94},     {132, 193,  98},
    {135, 191, 102},     {137, 190, 106},     {140, 188, 110},     {142, 187, 115},
    {145, 186, 119},     {147, 184, 123},     {150, 183, 127},     {152, 181, 131},
    {155, 180, 135},     {157, 179, 139},     {159, 177, 143},     {162, 176, 147},
    {164, 174, 152},     {167, 173, 156},     {169, 172, 160},     {172, 170, 164},
    {174, 169, 168},     {177, 168, 172},     {179, 166, 176},     {182, 165, 180},
    {110, 205,  49},     {113, 204,  54},     {115, 202,  58},     {118, 201,  62},
    {120, 200,  66},     {123, 198,  70},     {125, 197,  74},     {127, 195,  78},
    {130, 194,  82},     {132, 193,  86},     {135, 191,  91},     {137, 190,  95},
    {140, 188,  99},     {142, 187, 103},     {145, 186, 107},     {147, 184, 111},
    {150, 183, 115},     {152, 181, 119},     {154, 180, 123},     {157, 179, 128},
    {159, 177, 132},     {162, 176, 136},     {164, 175, 140},     {167, 173, 144},
    {169, 172, 148},     {172, 170, 152},     {174, 169, 156},     {177, 168, 160},
    {179, 166, 165},     {182, 165, 169},     {184, 163, 173},     {186, 162, 177},
    {115, 202,  46},     {118, 201,  50},     {120, 200,  54},     {122, 198,  58},
    {125, 197,  62},     {127, 195,  67},     {130, 194,  71},     {132, 193,  75},
    {135, 191,  79},     {137, 190,  83},     {140, 188,  87},     {142, 187,  91},
    {145, 186,  95},     {147, 184,  99},     {149, 183, 104},     {152, 182, 108},
    {154, 180, 112},     {157, 179, 116},     {159, 177, 120},     {162, 176, 124},
    {164, 175, 128},     {167, 173, 132},     {169, 172, 136},     {172, 170, 141},
    {174, 169, 145},     {177, 168, 149},     {179, 166, 153},     {181, 165, 157},
    {184, 163, 161},     {186, 162, 165},     {189, 161, 169},     {191, 159, 173},
    {120, 200,  43},     {122, 198,  47},     {125, 197,  51},     {127, 195,  55},
    {130, 194,  59},     {132, 193,  63},     {135, 191,  67},     {137, 190,  71},
    {140, 189,  75},     {142, 187,  80},     {144, 186,  84},     {147, 184,  88},
    {149, 183,  92},     {152, 182,  96},     {154, 180, 100},     {157, 179, 104},
    {159, 177, 108},     {162, 176, 112},     {164, 175, 117},     {167, 173, 121},
    {169, 172, 125},     {172, 170, 129},     {174, 169, 133},     {176, 168, 137},
    {179, 166, 141},     {181, 165, 145},     {184, 164, 149},     {186, 162, 154},
    {189, 161, 158},     {191, 159, 162},     {194, 158, 166},     {196, 157, 170},
    {125, 197,  39},     {127, 196,  43},     {130, 194,  47},     {132, 193,  51},
    {135, 191,  56},     {137, 190,  60},     {139, 189,  64},     {142, 187,  68},
    {144, 186,  72},     {147, 184,  76},     {149, 183,  80},     {152, 182,  84},
    {154, 180,  88},     {157, 179,  93},     {159, 177,  97},     {162, 176, 101},
    {164, 175, 105},     {167, 173, 109},     {169, 172, 113},     {171, 171, 117},
    {174, 169, 121},     {176, 168, 125},     {179, 166, 130},     {181, 165, 134},
    {184, 164, 138},     {186, 162, 142},     {189, 161, 146},     {191, 159, 150},
    {194, 158, 154},     {196, 157, 158},     {198, 155, 162},     {201, 154, 167},
    {130, 194,  36},     {132, 193,  40},     {134, 191,  44},     {137, 190,  48},
    {139, 189,  52},     {142, 187,  56},     {144, 186,  60},     {147, 184,  64},
    {149, 183,  69},     {152, 182,  73},     {154, 180,  77},     {157, 179,  81},
    {159, 178,  85},     {162, 176,  89},     {164, 175,  93},     {166, 173,  97},
    {169, 172, 101},     {171, 171, 106},     {174, 169, 110},     {176, 168, 114},
    {179, 166, 118},     {181, 165, 122},     {184, 164, 126},     {186, 162, 130},
    {189, 161, 134},     {191, 159, 138},     {193, 158, 143},     {196, 157, 147},
    {198, 155, 151},     {201, 154, 155},     {203, 153, 159},     {206, 151, 163},
    {134, 191,  32},     {137, 190,  36},     {139, 189,  40},     {142, 187,  45},
    {144, 186,  49},     {147, 185,  53},     {149, 183,  57},     {152, 182,  61},
    {154, 180,  65},     {156, 179,  69},     {159, 178,  73},     {161, 176,  77},
    {164, 175,  82},     {166, 173,  86},     {169, 172,  90},     {171, 171,  94},
    {174, 169,  98},     {176, 168, 102},     {179, 166, 106},     {181, 165, 110},
    {184, 164, 114},     {186, 162, 119},     {188, 161, 123},     {191, 160, 127},
    {193, 158, 131},     {196, 157, 135},     {198, 155, 139},     {201, 154, 143},
    {203, 153, 147},     {206, 151, 151},     {208, 150, 156},     {211, 148, 160},
    {139, 189,  29},     {142, 187,  33},     {144, 186,  37},     {147, 185,  41},
    {149, 183,  45},     {151, 182,  49},     {154, 180,  53},     {156, 179,  58},
    {159, 178,  62},     {161, 176,  66},     {164, 175,  70},     {166, 173,  74},
    {169, 172,  78},     {171, 171,  82},     {174, 169,  86},     {176, 168,  90},
    {179, 167,  95},     {181, 165,  99},     {183, 164, 103},     {186, 162, 107},
    {188, 161, 111},     {191, 160, 115},     {193, 158, 119},     {196, 157, 123},
    {198, 155, 127},     {201, 154, 132},     {203, 153, 136},     {206, 151, 140},
    {208, 150, 144},     {211, 148, 148},     {213, 147, 152},     {215, 146, 156},
    {144, 186,  25},     {146, 185,  29},     {149, 183,  34},     {151, 182,  38},
    {154, 180,  42},     {156, 179,  46},     {159, 178,  50},     {161, 176,  54},
    {164, 175,  58},     {166, 174,  62},     {169, 172,  66},     {171, 171,  71},
    {174, 169,  75},     {176, 168,  79},     {178, 167,  83},     {181, 165,  87},
    {183, 164,  91},     {186, 162,  95},     {188, 161,  99},     {191, 160, 103},
    {193, 158, 108},     {196, 157, 112},     {198, 155, 116},     {201, 154, 120},
    {203, 153, 124},     {206, 151, 128},     {208, 150, 132},     {210, 149, 136},
    {213, 147, 140},     {215, 146, 145},     {218, 144, 149},     {220, 143, 153},
    {149, 183,  22},     {151, 182,  26},     {154, 181,  30},     {156, 179,  34},
    {159, 178,  38},     {161, 176,  42},     {164, 175,  47},     {166, 174,  51},
    {169, 172,  55},     {171, 171,  59},     {173, 169,  63},     {176, 168,  67},
    {178, 167,  71},     {181, 165,  75},     {183, 164,  79},     {186, 162,  84},
    {188, 161,  88},     {191, 160,  92},     {193, 158,  96},     {196, 157, 100},
    {198, 156, 104},     {200, 154, 108},     {203, 153, 112},     {205, 151, 116},
    {208, 150, 121},     {210, 149, 125},     {213, 147, 129},     {215, 146, 133},
    {218, 144, 137},     {220, 143, 141},     {223, 142, 145},     {225, 140, 149},
    {154, 181,  18},     {156, 179,  23},     {159, 178,  27},     {161, 176,  31},
    {164, 175,  35},     {166, 174,  39},     {168, 172,  43},     {171, 171,  47},
    {173, 169,  51},     {176, 168,  55},     {178, 167,  60},     {181, 165,  64},
    {183, 164,  68},     {186, 163,  72},     {188, 161,  76},     {191, 160,  80},
    {193, 158,  84},     {195, 157,  88},     {198, 156,  92},     {200, 154,  97},
    {203, 153, 101},     {205, 151, 105},     {208, 150, 109},     {210, 149, 113},
    {213, 147, 117},     {215, 146, 121},     {218, 144, 125},     {220, 143, 129},
    {223, 142, 134},     {225, 140, 138},     {227, 139, 142},     {230, 138, 146},
    {159, 178,  15},     {161, 176,  19},     {163, 175,  23},     {166, 174,  27},
    {168, 172,  31},     {171, 171,  36},     {173, 170,  40},     {176, 168,  44},
    {178, 167,  48},     {181, 165,  52},     {183, 164,  56},     {186, 163,  60},
    {188, 161,  64},     {190, 160,  68},     {193, 158,  73},     {195, 157,  77},
    {198, 156,  81},     {200, 154,  85},     {203, 153,  89},     {205, 151,  93},
    {208, 150,  97},     {210, 149, 101},     {213, 147, 105},     {215, 146, 110},
    {218, 145, 114},     {220, 143, 118},     {222, 142, 122},     {225, 140, 126},
    {227, 139, 130},     {230, 138, 134},     {232, 136, 138},     {235, 135, 142},
    {163, 175,  12},     {166, 174,  16},     {168, 172,  20},     {171, 171,  24},
    {173, 170,  28},     {176, 168,  32},     {178, 167,  36},     {181, 165,  40},
    {183, 164,  44},     {185, 163,  49},     {188, 161,  53},     {190, 160,  57},
    {193, 158,  61},     {195, 157,  65},     {198, 156,  69},     {200, 154,  73},
    {203, 153,  77},     {205, 152,  81},     {208, 150,  86},     {210, 149,  90},
    {213, 147,  94},     {215, 146,  98},     {217, 145, 102},     {220, 143, 106},
    {222, 142, 110},     {225, 140, 114},     {227, 139, 118},     {230, 138, 123},
    {232, 136, 127},     {235, 135, 131},     {237, 133, 135},     {240, 132, 139},
    {168, 172,   8},     {171, 171,  12},     {173, 170,  16},     {176, 168,  20},
    {178, 167,  25},     {180, 165,  29},     {183, 164,  33},     {185, 163,  37},
    {188, 161,  41},     {190, 160,  45},     {193, 159,  49},     {195, 157,  53},
    {198, 156,  57},     {200, 154,  62},     {203, 153,  66},     {205, 152,  70},
    {208, 150,  74},     {210, 149,  78},     {212, 147,  82},     {215, 146,  86},
    {217, 145,  90},     {220, 143,  94},     {222, 142,  99},     {225, 140, 103},
    {227, 139, 107},     {230, 138, 111},     {232, 136, 115},     {235, 135, 119},
    {237, 134, 123},     {239, 132, 127},     {242, 131, 131},     {244, 129, 136},
    {173, 170,   5},     {175, 168,   9},     {178, 167,  13},     {180, 166,  17},
    {183, 164,  21},     {185, 163,  25},     {188, 161,  29},     {190, 160,  33},
    {193, 159,  38},     {195, 157,  42},     {198, 156,  46},     {200, 154,  50},
    {203, 153,  54},     {205, 152,  58},     {207, 150,  62},     {210, 149,  66},
    {212, 147,  70},     {215, 146,  75},     {217, 145,  79},     {220, 143,  83},
    {222, 142,  87},     {225, 141,  91},     {227, 139,  95},     {230, 138,  99},
    {232, 136, 103},     {234, 135, 107},     {237, 134, 112},     {239, 132, 116},
    {242, 131, 120},     {244, 129, 124},     {247, 128, 128},     {249, 127, 132},
    {178, 167,   1},     {180, 166,   5},     {183, 164,   9},     {185, 163,  14},
    {188, 161,  18},     {190, 160,  22},     {193, 159,  26},     {195, 157,  30},
    {197, 156,  34},     {200, 154,  38},     {202, 153,  42},     {205, 152,  46},
    {207, 150,  51},     {210, 149,  55},     {212, 148,  59},     {215, 146,  63},
    {217, 145,  67},     {220, 143,  71},     {222, 142,  75},     {225, 141,  79},
    {227, 139,  83},     {229, 138,  88},     {232, 136,  92},     {234, 135,  96},
    {237, 134, 100},     {239, 132, 104},     {242, 131, 108},     {244, 129, 112},
    {247, 128, 116},     {249, 127, 120},     {252, 125, 125},     {254, 124, 129},
    { 29, 255, 107},     { 32, 254, 111},     { 34, 253, 116},     { 36, 251, 120},
    { 39, 250, 124},     { 41, 249, 128},     { 44, 247, 132},     { 46, 246, 136},
    { 49, 244, 140},     { 51, 243, 144},     { 54, 242, 148},     { 56, 240, 153},
    { 59, 239, 157},     { 61, 237, 161},     { 64, 236, 165},     { 66, 235, 169},
    { 68, 233, 173},     { 71, 232, 177},     { 73, 230, 181},     { 76, 229, 185},
    { 78, 228, 190},     { 81, 226, 194},     { 83, 225, 198},     { 86, 224, 202},
    { 88, 222, 206},     { 91, 221, 210},     { 93, 219, 214},     { 95, 218, 218},
    { 98, 217, 223},     {100, 215, 227},     {103, 214, 231},     {105, 212, 235},
    { 34, 253, 104},     { 36, 251, 108},     { 39, 250, 112},     { 41, 249, 116},
    { 44, 247, 120},     { 46, 246, 124},     { 49, 244, 129},     { 51, 243, 133},
    { 54, 242, 137},     { 56, 240, 141},     { 58, 239, 145},     { 61, 237, 149},
    { 63, 236, 153},     { 66, 235, 157},     { 68, 233, 161},     { 71, 232, 166},
    { 73, 231, 170},     { 76, 229, 174},     { 78, 228, 178},     { 81, 226, 182},
    { 83, 225, 186},     { 86, 224, 190},     { 88, 222, 194},     { 90, 221, 198},
    { 93, 219, 203},     { 95, 218, 207},     { 98, 217, 211},     {100, 215, 215},
    {103, 214, 219},     {105, 212, 223},     {108, 211, 227},     {110, 210, 231},
    { 39, 250, 100},     { 41, 249, 105},     { 44, 247, 109},     { 46, 246, 113},
    { 49, 244, 117},     { 51, 243, 121},     { 53, 242, 125},     { 56, 240, 129},
    { 58, 239, 133},     { 61, 238, 137},     { 63, 236, 142},     { 66, 235, 146},
    { 68, 233, 150},     { 71, 232, 154},     { 73, 231, 158},     { 76, 229, 162},
    { 78, 228, 166},     { 81, 226, 170},     { 83, 225, 174},     { 85, 224, 179},
    { 88, 222, 183},     { 90, 221, 187},     { 93, 219, 191},     { 95, 218, 195},
    { 98, 217, 199},     {100, 215, 203},     {103, 214, 207},     {105, 213, 212},
    {108, 211, 216},     {110, 210, 220},     {113, 208, 224},     {115, 207, 228},
    { 44, 247,  97},     { 46, 246, 101},     { 48, 245, 105},     { 51, 243, 109},
    { 53, 242, 113},     { 56, 240, 118},     { 58, 239, 122},     { 61, 238, 126},
    { 63, 236, 130},     { 66, 235, 134},     { 68, 233, 138},     { 71, 232, 142},
    { 73, 231, 146},     { 76, 229, 150},     { 78, 228, 155},     { 80, 226, 159},
    { 83, 225, 163},     { 85, 224, 167},     { 88, 222, 171},     { 90, 221, 175},
    { 93, 220, 179},     { 95, 218, 183},     { 98, 217, 187},     {100, 215, 192},
    {103, 214, 196},     {105, 213, 200},     {108, 211, 204},     {110, 210, 208},
    {112, 208, 212},     {115, 207, 216},     {117, 206, 220},     {120, 204, 225},
    { 48, 245,  94},     { 51, 243,  98},     { 53, 242, 102},     { 56, 240, 106},
    { 58, 239, 110},     { 61, 238, 114},     { 63, 236, 118},     { 66, 235, 122},
    { 68, 233, 126},     { 71, 232, 131},     { 73, 231, 135},     { 75, 229, 139},
    { 78, 228, 143},     { 80, 227, 147},     { 83, 225, 151},     { 85, 224, 155},
    { 88, 222, 159},     { 90, 221, 163},     { 93, 220, 168},     { 95, 218, 172},
    { 98, 217, 176},     {100, 215, 180},     {102, 214, 184},     {105, 213, 188},
    {107, 211, 192},     {110, 210, 196},     {112, 208, 200},     {115, 207, 205},
    {117, 206, 209},     {120, 204, 213},     {122, 203, 217},     {125, 202, 221},
    { 53, 242,  90},     { 56, 240,  94},     { 58, 239,  98},     { 61, 238, 102},
    { 63, 236, 107},     { 66, 235, 111},     { 68, 234, 115},     { 70, 232, 119},
    { 73, 231, 123},     { 75, 229, 127},     { 78, 228, 131},     { 80, 227, 135},
    { 83, 225, 139},     { 85, 224, 144},     { 88, 222, 148},     { 90, 221, 152},
    { 93, 220, 156},     { 95, 218, 160},     { 97, 217, 164},     {100, 215, 168},
    {102, 214, 172},     {105, 213, 176},     {107, 211, 181},     {110, 210, 185},
    {112, 209, 189},     {115, 207, 193},     {117, 206, 197},     {120, 204, 201},
    {122, 203, 205},     {125, 202, 209},     {127, 200, 213},     {129, 199, 218},
    { 58, 239,  87},     { 61, 238,  91},     { 63, 236,  95},     { 65, 235,  99},
    { 68, 234, 103},     { 70, 232, 107},     { 73, 231, 111},     { 75, 229, 115},
    { 78, 228, 120},     { 80, 227, 124},     { 83, 225, 128},     { 85, 224, 132},
    { 88, 222, 136},     { 90, 221, 140},     { 92, 220, 144},     { 95, 218, 148},
    { 97, 217, 152},     {100, 216, 157},     {102, 214, 161},     {105, 213, 165},
    {107, 211, 169},     {110, 210, 173},     {112, 209, 177},     {115, 207, 181},
    {117, 206, 185},     {120, 204, 189},     {122, 203, 194},     {124, 202, 198},
    {127, 200, 202},     {129, 199, 206},     {132, 197, 210},     {134, 196, 214},
    { 63, 236,  83},     { 65, 235,  87},     { 68, 234,  91},     { 70, 232,  96},
    { 73, 231, 100},     { 75, 229, 104},     { 78, 228, 108},     { 80, 227, 112},
    { 83, 225, 116},     { 85, 224, 120},     { 87, 223, 124},     { 90, 221, 128},
    { 92, 220, 133},     { 95, 218, 137},     { 97, 217, 141},     {100, 216, 145},
    {102, 214, 149},     {105, 213, 153},     {107, 211, 157},     {110, 210, 161},
    {112, 209, 165},     {115, 207, 170},     {117, 206, 174},     {119, 204, 178},
    {122, 203, 182},     {124, 202, 186},     {127, 200, 190},     {129, 199, 194},
    {132, 198, 198},     {134, 196, 202},     {137, 195, 207},     {139, 193, 211},
    { 68, 234,  80},     { 70, 232,  84},     { 73, 231,  88},     { 75, 230,  92},
    { 78, 228,  96},     { 80, 227, 100},     { 82, 225, 104},     { 85, 224, 109},
    { 87, 223, 113},     { 90, 221, 117},     { 92, 220, 121},     { 95, 218, 125},
    { 97, 217, 129},     {100, 216, 133},     {102, 214, 137},     {105, 213, 141},
    {107, 211, 146},     {110, 210, 150},     {112, 209, 154},     {114, 207, 158},
    {117, 206, 162},     {119, 205, 166},     {122, 203, 170},     {124, 202, 174},
    {127, 200, 178},     {129, 199, 183},     {132, 198, 187},     {134, 196, 191},
    {137, 195, 195},     {139, 193, 199},     {141, 192, 203},     {144, 191, 207},
    { 73, 231,  76},     { 75, 230,  80},     { 77, 228,  85},     { 80, 227,  89},
    { 82, 225,  93},     { 85, 224,  97},     { 87, 223, 101},     { 90, 221, 105},
    { 92, 220, 109},     { 95, 218, 113},     { 97, 217, 117},     {100, 216, 122},
    {102, 214, 126},     {105, 213, 130},     {107, 212, 134},     {109, 210, 138},
    {112, 209, 142},     {114, 207, 146},     {117, 206, 150},     {119, 205, 154},
    {122, 203, 159},     {124, 202, 163},     {127, 200, 167},     {129, 199, 171},
    {132, 198, 175},     {134, 196, 179},     {136, 195, 183},     {139, 193, 187},
    {141, 192, 191},     {144, 191, 196},     {146, 189, 200},     {149, 188, 204},
    { 77, 228,  73},     { 80, 227,  77},     { 82, 225,  81},     { 85, 224,  85},
    { 87, 223,  89},     { 90, 221,  93},     { 92, 220,  98},     { 95, 219, 102},
    { 97, 217, 106},     { 99, 216, 110},     {102, 214, 114},     {104, 213, 118},
    {107, 212, 122},     {109, 210, 126},     {112, 209, 130},     {114, 207, 135},
    {117, 206, 139},     {119, 205, 143},     {122, 203, 147},     {124, 202, 151},
    {127, 200, 155},     {129, 199, 159},     {131, 198, 163},     {134, 196, 167},
    {136, 195, 172},     {139, 194, 176},     {141, 192, 180},     {144, 191, 184},
    {146, 189, 188},     {149, 188, 192},     {151, 187, 196},     {154, 185, 200},
    { 82, 226,  69},     { 85, 224,  74},     { 87, 223,  78},     { 90, 221,  82},
    { 92, 220,  86},     { 94, 219,  90},     { 97, 217,  94},     { 99, 216,  98},
    {102, 214, 102},     {104, 213, 106},     {107, 212, 111},     {109, 210, 115},
    {112, 209, 119},     {114, 207, 123},     {117, 206, 127},     {119, 205, 131},
    {122, 203, 135},     {124, 202, 139},     {126, 201, 143},     {129, 199, 148},
    {131, 198, 152},     {134, 196, 156},     {136, 195, 160},     {139, 194, 164},
    {141, 192, 168},     {144, 191, 172},     {146, 189, 176},     {149, 188, 180},
    {151, 187, 185},     {154, 185, 189},     {156, 184, 193},     {158, 182, 197},
    { 87, 223,  66},     { 89, 221,  70},     { 92, 220,  74},     { 94, 219,  78},
    { 97, 217,  82},     { 99, 216,  87},     {102, 214,  91},     {104, 213,  95},
    {107, 212,  99},     {109, 210, 103},     {112, 209, 107},     {114, 208, 111},
    {117, 206, 115},     {119, 205, 119},     {121, 203, 124},     {124, 202, 128},
    {126, 201, 132},     {129, 199, 136},     {131, 198, 140},     {134, 196, 144},
    {136, 195, 148},     {139, 194, 152},     {141, 192, 156},     {144, 191, 161},
    {146, 189, 165},     {149, 188, 169},     {151, 187, 173},     {153, 185, 177},
    {156, 184, 181},     {158, 183, 185},     {161, 181, 189},     {163, 180, 193},
    { 92, 220,  63},     { 94, 219,  67},     { 97, 217,  71},     { 99, 216,  75},
    {102, 215,  79},     {104, 213,  83},     {107, 212,  87},     {109, 210,  91},
    {112, 209,  95},     {114, 208, 100},     {116, 206, 104},     {119, 205, 108},
    {121, 203, 112},     {124, 202, 116},     {126, 201, 120},     {129, 199, 124},
    {131, 198, 128},     {134, 196, 132},     {136, 195, 137},     {139, 194, 141},
    {141, 192, 145},     {143, 191, 149},     {146, 190, 153},     {148, 188, 157},
    {151, 187, 161},     {153, 185, 165},     {156, 184, 169},     {158, 183, 174},
    {161, 181, 178},     {163, 180, 182},     {166, 178, 186},     {168, 177, 190},
    { 97, 217,  59},     { 99, 216,  63},     {102, 215,  67},     {104, 213,  71},
    {107, 212,  76},     {109, 210,  80},     {111, 209,  84},     {114, 208,  88},
    {116, 206,  92},     {119, 205,  96},     {121, 203, 100},     {124, 202, 104},
    {126, 201, 108},     {129, 199, 113},     {131, 198, 117},     {134, 197, 121},
    {136, 195, 125},     {138, 194, 129},     {141, 192, 133},     {143, 191, 137},
    {146, 190, 141},     {148, 188, 145},     {151, 187, 150},     {153, 185, 154},
    {156, 184, 158},     {158, 183, 162},     {161, 181, 166},     {163, 180, 170},
    {166, 178, 174},     {168, 177, 178},     {170, 176, 182},     {173, 174, 187},
    {101, 215,  56},     {104, 213,  60},     {106, 212,  64},     {109, 210,  68},
    {111, 209,  72},     {114, 208,  76},     {116, 206,  80},     {119, 205,  84},
    {121, 204,  89},     {124, 202,  93},     {126, 201,  97},     {129, 199, 101},
    {131, 198, 105},     {133, 197, 109},     {136, 195, 113},     {138, 194, 117},
    {141, 192, 121},     {143, 191, 126},     {146, 190, 130},     {148, 188, 134},
    {151, 187, 138},     {153, 185, 142},     {156, 184, 146},     {158, 183, 150},
    {161, 181, 154},     {163, 180, 158},     {165, 179, 163},     {168, 177, 167},
    {170, 176, 171},     {173, 174, 175},     {175, 173, 179},     {178, 172, 183},
    {106, 212,  52},     {109, 211,  56},     {111, 209,  60},     {114, 208,  65},
    {116, 206,  69},     {119, 205,  73},     {121, 204,  77},     {124, 202,  81},
    {126, 201,  85},     {128, 199,  89},     {131, 198,  93},     {133, 197,  97},
    {136, 195, 102},     {138, 194, 106},     {141, 192, 110},     {143, 191, 114},
    {146, 190, 118},     {148, 188, 122},     {151, 187, 126},     {153, 186, 130},
    {156, 184, 134},     {158, 183, 139},     {160, 181, 143},     {163, 180, 147},
    {165, 179, 151},     {168, 177, 155},     {170, 176, 159},     {173, 174, 163},
    {175, 173, 167},     {178, 172, 171},     {180, 170, 176},     {183, 169, 180},
    {111, 209,  49},     {114, 208,  53},     {116, 206,  57},     {119, 205,  61},
    {121, 204,  65},     {123, 202,  69},     {126, 201,  73},     {128, 199,  78},
    {131, 198,  82},     {133, 197,  86},     {136, 195,  90},     {138, 194,  94},
    {141, 193,  98},     {143, 191, 102},     {146, 190, 106},     {148, 188, 110},
    {151, 187, 115},     {153, 186, 119},     {155, 184, 123},     {158, 183, 127},
    {160, 181, 131},     {163, 180, 135},     {165, 179, 139},     {168, 177, 143},
    {170, 176, 147},     {173, 174, 152},     {175, 173, 156},     {178, 172, 160},
    {180, 170, 164},     {182, 169, 168},     {185, 168, 172},     {187, 166, 176},
    {116, 206,  45},     {118, 205,  49},     {121, 204,  54},     {123, 202,  58},
    {126, 201,  62},     {128, 200,  66},     {131, 198,  70},     {133, 197,  74},
    {136, 195,  78},     {138, 194,  82},     {141, 193,  86},     {143, 191,  91},
    {145, 190,  95},     {148, 188,  99},     {150, 187, 103},     {153, 186, 107},
    {155, 184, 111},     {158, 183, 115},     {160, 181, 119},     {163, 180, 123},
    {165, 179, 128},     {168, 177, 132},     {170, 176, 136},     {173, 175, 140},
    {175, 173, 144},     {177, 172, 148},     {180, 170, 152},     {182, 169, 156},
    {185, 168, 160},     {187, 166, 165},     {190, 165, 169},     {192, 163, 173},
    {121, 204,  42},     {123, 202,  46},     {126, 201,  50},     {128, 200,  54},
    {131, 198,  58},     {133, 197,  62},     {136, 195,  67},     {138, 194,  71},
    {140, 193,  75},     {143, 191,  79},     {145, 190,  83},     {148, 188,  87},
    {150, 187,  91},     {153, 186,  95},     {155, 184,  99},     {158, 183, 104},
    {160, 182, 108},     {163, 180, 112},     {165, 179, 116},     {168, 177, 120},
    {170, 176, 124},     {172, 175, 128},     {175, 173, 132},     {177, 172, 136},
    {180, 170, 141},     {182, 169, 145},     {185, 168, 149},     {187, 166, 153},
    {190, 165, 157},     {192, 163, 161},     {195, 162, 165},     {197, 161, 169},
    {126, 201,  38},     {128, 200,  43},     {131, 198,  47},     {133, 197,  51},
    {135, 195,  55},     {138, 194,  59},     {140, 193,  63},     {143, 191,  67},
    {145, 190,  71},     {148, 189,  75},     {150, 187,  80},     {153, 186,  84},
    {155, 184,  88},     {158, 183,  92},     {160, 182,  96},     {163, 180, 100},
    {165, 179, 104},     {167, 177, 108},     {170, 176, 112},     {172, 175, 117},
    {175, 173, 121},     {177, 172, 125},     {180, 170, 129},     {182, 169, 133},
    {185, 168, 137},     {187, 166, 141},     {190, 165, 145},     {192, 164, 149},
    {195, 162, 154},     {197, 161, 158},     {199, 159, 162},     {202, 158, 166},
    {130, 198,  35},     {133, 197,  39},     {135, 196,  43},     {138, 194,  47},
    {140, 193,  51},     {143, 191,  56},     {145, 190,  60},     {148, 189,  64},
    {150, 187,  68},     {153, 186,  72},     {155, 184,  76},     {158, 183,  80},
    {160, 182,  84},     {162, 180,  88},     {165, 179,  93},     {167, 177,  97},
    {170, 176, 101},     {172, 175, 105},     {175, 173, 109},     {177, 172, 113},
    {180, 171, 117},     {182, 169, 121},     {185, 168, 125},     {187, 166, 130},
    {189, 165, 134},     {192, 164, 138},     {194, 162, 142},     {197, 161, 146},
    {199, 159, 150},     {202, 158, 154},     {204, 157, 158},     {207, 155, 162},
    {135, 196,  32},     {138, 194,  36},     {140, 193,  40},     {143, 191,  44},
    {145, 190,  48},     {148, 189,  52},     {150, 187,  56},     {153, 186,  60},
    {155, 184,  64},     {157, 183,  69},     {160, 182,  73},     {162, 180,  77},
    {165, 179,  81},     {167, 178,  85},     {170, 176,  89},     {172, 175,  93},
    {175, 173,  97},     {177, 172, 101},     {180, 171, 106},     {182, 169, 110},
    {184, 168, 114},     {187, 166, 118},     {189, 165, 122},     {192, 164, 126},
    {194, 162, 130},     {197, 161, 134},     {199, 159, 138},     {202, 158, 143},
    {204, 157, 147},     {207, 155, 151},     {209, 154, 155},     {212, 153, 159},
    {140, 193,  28},     {143, 191,  32},     {145, 190,  36},     {148, 189,  40},
    {150, 187,  45},     {152, 186,  49},     {155, 185,  53},     {157, 183,  57},
    {160, 182,  61},     {162, 180,  65},     {165, 179,  69},     {167, 178,  73},
    {170, 176,  77},     {172, 175,  82},     {175, 173,  86},     {177, 172,  90},
    {179, 171,  94},     {182, 169,  98},     {184, 168, 102},     {187, 166, 106},
    {189, 165, 110},     {192, 164, 114},     {194, 162, 119},     {197, 161, 123},
    {199, 160, 127},     {202, 158, 131},     {204, 157, 135},     {207, 155, 139},
    {209, 154, 143},     {211, 153, 147},     {214, 151, 151},     {216, 150, 156},
    {145, 190,  25},     {147, 189,  29},     {150, 187,  33},     {152, 186,  37},
    {155, 185,  41},     {157, 183,  45},     {160, 182,  49},     {162, 180,  53},
    {165, 179,  58},     {167, 178,  62},     {170, 176,  66},     {172, 175,  70},
    {174, 173,  74},     {177, 172,  78},     {179, 171,  82},     {182, 169,  86},
    {184, 168,  90},     {187, 167,  95},     {189, 165,  99},     {192, 164, 103},
    {194, 162, 107},     {197, 161, 111},     {199, 160, 115},     {202, 158, 119},
    {204, 157, 123},     {206, 155, 127},     {209, 154, 132},     {211, 153, 136},
    {214, 151, 140},     {216, 150, 144},     {219, 148, 148},     {221, 147, 152},
    {150, 187,  21},     {152, 186,  25},     {155, 185,  29},     {157, 183,  34},
    {160, 182,  38},     {162, 180,  42},     {165, 179,  46},     {167, 178,  50},
    {169, 176,  54},     {172, 175,  58},     {174, 174,  62},     {177, 172,  66},
    {179, 171,  71},     {182, 169,  75},     {184, 168,  79},     {187, 167,  83},
    {189, 165,  87},     {192, 164,  91},     {194, 162,  95},     {197, 161,  99},
    {199, 160, 103},     {201, 158, 108},     {204, 157, 112},     {206, 155, 116},
    {209, 154, 120},     {211, 153, 124},     {214, 151, 128},     {216, 150, 132},
    {219, 149, 136},     {221, 147, 140},     {224, 146, 145},     {226, 144, 149},
    {155, 185,  18},     {157, 183,  22},     {160, 182,  26},     {162, 181,  30},
    {164, 179,  34},     {167, 178,  38},     {169, 176,  42},     {172, 175,  47},
    {174, 174,  51},     {177, 172,  55},     {179, 171,  59},     {182, 169,  63},
    {184, 168,  67},     {187, 167,  71},     {189, 165,  75},     {192, 164,  79},
    {194, 162,  84},     {196, 161,  88},     {199, 160,  92},     {201, 158,  96},
    {204, 157, 100},     {206, 156, 104},     {209, 154, 108},     {211, 153, 112},
    {214, 151, 116},     {216, 150, 121},     {219, 149, 125},     {221, 147, 129},
    {223, 146, 133},     {226, 144, 137},     {228, 143, 141},     {231, 142, 145},
    {159, 182,  14},     {162, 181,  18},     {164, 179,  23},     {167, 178,  27},
    {169, 176,  31},     {172, 175,  35},     {174, 174,  39},     {177, 172,  43},
    {179, 171,  47},     {182, 169,  51},     {184, 168,  55},     {186, 167,  60},
    {189, 165,  64},     {191, 164,  68},     {194, 163,  72},     {196, 161,  76},
    {199, 160,  80},     {201, 158,  84},     {204, 157,  88},     {206, 156,  92},
    {209, 154,  97},     {211, 153, 101},     {214, 151, 105},     {216, 150, 109},
    {218, 149, 113},     {221, 147, 117},     {223, 146, 121},     {226, 144, 125},
    {228, 143, 129},     {231, 142, 134},     {233, 140, 138},     {236, 139, 142},
    {164, 179,  11},     {167, 178,  15},     {169, 176,  19},     {172, 175,  23},
    {174, 174,  27},     {177, 172,  31},     {179, 171,  36},     {181, 170,  40},
    {184, 168,  44},     {186, 167,  48},     {189, 165,  52},     {191, 164,  56},
    {194, 163,  60},     {196, 161,  64},     {199, 160,  68},     {201, 158,  73},
    {204, 157,  77},     {206, 156,  81},     {209, 154,  85},     {211, 153,  89},
    {213, 151,  93},     {216, 150,  97},     {218, 149, 101},     {221, 147, 105},
    {223, 146, 110},     {226, 145, 114},     {228, 143, 118},     {231, 142, 122},
    {233, 140, 126},     {236, 139, 130},     {238, 138, 134},     {241, 136, 138},
    {169, 177,   7},     {172, 175,  12},     {174, 174,  16},     {176, 172,  20},
    {179, 171,  24},     {181, 170,  28},     {184, 168,  32},     {186, 167,  36},
    {189, 165,  40},     {191, 164,  44},     {194, 163,  49},     {196, 161,  53},
    {199, 160,  57},     {201, 158,  61},     {204, 157,  65},     {206, 156,  69},
    {208, 154,  73},     {211, 153,  77},     {213, 152,  81},     {216, 150,  86},
    {218, 149,  90},     {221, 147,  94},     {223, 146,  98},     {226, 145, 102},
    {228, 143, 106},     {231, 142, 110},     {233, 140, 114},     {236, 139, 118},
    {238, 138, 123},     {240, 136, 127},     {243, 135, 131},     {245, 133, 135},
    {174, 174,   4},     {176, 172,   8},     {179, 171,  12},     {181, 170,  16},
    {184, 168,  20},     {186, 167,  25},     {189, 165,  29},     {191, 164,  33},
    {194, 163,  37},     {196, 161,  41},     {199, 160,  45},     {201, 159,  49},
    {203, 157,  53},     {206, 156,  57},     {208, 154,  62},     {211, 153,  66},
    {213, 152,  70},     {216, 150,  74},     {218, 149,  78},     {221, 147,  82},
    {223, 146,  86},     {226, 145,  90},     {228, 143,  94},     {230, 142,  99},
    {233, 140, 103},     {235, 139, 107},     {238, 138, 111},     {240, 136, 115},
    {243, 135, 119},     {245, 134, 123},     {248, 132, 127},     {250, 131, 131},
    {179, 171,   0},     {181, 170,   5},     {184, 168,   9},     {186, 167,  13},
    {189, 166,  17},     {191, 164,  21},     {194, 163,  25},     {196, 161,  29},
    {198, 160,  33},     {201, 159,  38},     {203, 157,  42},     {206, 156,  46},
    {208, 154,  50},     {211, 153,  54},     {213, 152,  58},     {216, 150,  62},
    {218, 149,  66},     {221, 147,  70},     {223, 146,  75},     {225, 145,  79},
    {228, 143,  83},     {230, 142,  87},     {233, 141,  91},     {235, 139,  95},
    {238, 138,  99},     {240, 136, 103},     {243, 135, 107},     {245, 134, 112},
    {248, 132, 116},     {250, 131, 120},     {253, 129, 124},     {255, 128, 128}
};

#endif // RGB555_TO_YUV_H