/* 
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Copyright (C) 2025 T. Wirtl (embedded-ideas.de)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef XGB_CAPTURE_H_
#define XGB_CAPTURE_H_

#define XGB_CAPTURE_WIDTH  240
#define XGB_CAPTURE_HEIGHT 160

#define XGB_CAPTURE_GET_LINE(_buf, _idx) (((uint16_t*)(_buf))+(((_idx)*(XGB_CAPTURE_WIDTH + 2))+1))             // Start address of the 15-bit RGB555 line data (MSB=0)
#define XGB_CAPTURE_GET_LINE_IDX(_linebuf) *((volatile uint8_t*)&((_linebuf)[XGB_CAPTURE_WIDTH*sizeof(uint16_t)]))   // 1 based line index (1-240)
#define XGB_CAPTURE_BUFFERED_LINES_NUM 50

uint16_t* xgb_capture_init(void);

#endif /* XGB_CAPTURE_H_ */